/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedGenerator;
import org.apache.spark.sql.catalyst.analysis.UnresolvedInlineTable;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSubqueryColumnAliases;
import org.apache.spark.sql.catalyst.analysis.UnresolvedTableValuedFunction;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.Cube;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FrameType;
import org.apache.spark.sql.catalyst.expressions.Generator;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.Rollup;
import org.apache.spark.sql.catalyst.expressions.RowFrame$;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.UnspecifiedFrame$;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.Cross$;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.NaturalJoin;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.UsingJoin;
import org.apache.spark.sql.catalyst.plans.logical.Distinct;
import org.apache.spark.sql.catalyst.plans.logical.GroupingSets;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.catalyst.plans.logical.Sample;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias$;
import org.apache.spark.sql.catalyst.plans.logical.Union$;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedHint;
import org.apache.spark.sql.catalyst.plans.logical.With;
import org.apache.spark.sql.catalyst.plans.logical.WithWindowDefinition;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001!3A\u0001B\u0003\u0001%!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C\u0005E!)\u0001\t\u0001C\u0005\u0003\ny\u0001\u000b\\1o!\u0006\u00148/\u001a:Tk&$XM\u0003\u0002\u0007\u000f\u00051\u0001/\u0019:tKJT!\u0001C\u0005\u0002\u0011\r\fG/\u00197zgRT!AC\u0006\u0002\u0007M\fHN\u0003\u0002\r\u001b\u0005)1\u000f]1sW*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u00192\u0001A\n\u0018!\t!R#D\u0001\f\u0013\t12BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u00031mi\u0011!\u0007\u0006\u00035\u001d\t\u0001\"\u00198bYf\u001c\u0018n]\u0005\u00039e\u0011A\"\u00118bYf\u001c\u0018n\u001d+fgR\fa\u0001P5oSRtD#A\u0010\u0011\u0005\u0001\u0002Q\"A\u0003\u0002\u0017\u0005\u001c8/\u001a:u\u000bF,\u0018\r\u001c\u000b\u0004G%2\u0004C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#\u0001B+oSRDQA\u000b\u0002A\u0002-\n!b]9m\u0007>lW.\u00198e!\ta3G\u0004\u0002.cA\u0011a&J\u0007\u0002_)\u0011\u0001'E\u0001\u0007yI|w\u000e\u001e \n\u0005I*\u0013A\u0002)sK\u0012,g-\u0003\u00025k\t11\u000b\u001e:j]\u001eT!AM\u0013\t\u000b]\u0012\u0001\u0019\u0001\u001d\u0002\tAd\u0017M\u001c\t\u0003syj\u0011A\u000f\u0006\u0003wq\nq\u0001\\8hS\u000e\fGN\u0003\u0002>\u000f\u0005)\u0001\u000f\\1og&\u0011qH\u000f\u0002\f\u0019><\u0017nY1m!2\fg.A\u0005j]R,'oY3qiR\u00191EQ\"\t\u000b)\u001a\u0001\u0019A\u0016\t\u000b\u0011\u001b\u0001\u0019A#\u0002\u00115,7o]1hKN\u00042\u0001\n$,\u0013\t9UE\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002")
public class PlanParserSuite
extends SparkFunSuite
implements AnalysisTest {
    private final Analyzer caseSensitiveAnalyzer;
    private final Analyzer caseInsensitiveAnalyzer;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public Analyzer getAnalyzer(boolean caseSensitive) {
        return AnalysisTest.getAnalyzer$(this, caseSensitive);
    }

    @Override
    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$(this, inputPlan, expectedPlan, caseSensitive);
    }

    @Override
    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$(this);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$(this);
    }

    @Override
    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$(this, inputPlan, caseSensitive);
    }

    @Override
    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$(this);
    }

    @Override
    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$(this, inputPlan, expectedErrors, caseSensitive);
    }

    @Override
    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$(this);
    }

    @Override
    public SQLConf conf() {
        return PlanTestBase.conf$(this);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$(this, plan1, plan2);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        PlanTestBase.withSQLConf$(this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    @Override
    public Analyzer caseSensitiveAnalyzer() {
        return this.caseSensitiveAnalyzer;
    }

    @Override
    public Analyzer caseInsensitiveAnalyzer() {
        return this.caseInsensitiveAnalyzer;
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$AnalysisTest$_setter_$caseSensitiveAnalyzer_$eq(Analyzer x$1) {
        this.caseSensitiveAnalyzer = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$AnalysisTest$_setter_$caseInsensitiveAnalyzer_$eq(Analyzer x$1) {
        this.caseInsensitiveAnalyzer = x$1;
    }

    private void assertEqual(String sqlCommand, LogicalPlan plan) {
        this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(sqlCommand), plan, false);
    }

    private void intercept(String sqlCommand, Seq<String> messages) {
        ParseException e = (ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlCommand), ClassTag$.MODULE$.apply(ParseException.class), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        messages.foreach((Function1 & Serializable & scala.Serializable)message -> {
            String $org_scalatest_assert_macro_left = e.message();
            String $org_scalatest_assert_macro_right = message;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        });
    }

    private static final With cte$1(LogicalPlan plan, Seq namedPlans) {
        Seq ctes = (Seq)namedPlans.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            LogicalPlan cte = (LogicalPlan)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)SubqueryAlias$.MODULE$.apply(name, cte));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        return new With(plan, ctes);
    }

    public static final /* synthetic */ void $anonfun$new$15(PlanParserSuite $this, String baseSql$1, String s1$1, LogicalPlan p1$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String s2 = (String)tuple2._1();
        Function1 pf2 = (Function1)tuple2._2();
        $this.assertEqual(new StringBuilder(0).append(baseSql$1).append(s1$1).append(s2).toString(), (LogicalPlan)pf2.apply((Object)p1$1));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$14(PlanParserSuite $this, Seq limitWindowClauses$1, String baseSql$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String s1 = (String)tuple2._1();
        LogicalPlan p1 = (LogicalPlan)tuple2._2();
        limitWindowClauses$1.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            PlanParserSuite.$anonfun$new$15($this, baseSql$1, s1, p1, x0$2);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final LogicalPlan insert$1(Map partition, boolean overwrite, boolean ifPartitionNotExists, LogicalPlan plan$1) {
        return new InsertIntoTable(package.plans$.MODULE$.table("s"), partition, plan$1, overwrite, ifPartitionNotExists);
    }

    private static final boolean insert$default$2$1() {
        return false;
    }

    private static final boolean insert$default$3$1() {
        return false;
    }

    private static final void test$1(String sql, JoinType jt, Seq tests) {
        tests.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.apply((Object)sql, (Object)jt);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Seq $anonfun$new$40(int x) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x))}));
    }

    public PlanParserSuite() {
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$(this);
        AnalysisTest.$init$(this);
        this.test("case insensitive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("a")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("sELEct * FroM a", plan);
            this.assertEqual("select * fRoM a", plan);
            this.assertEqual("SELECT * FROM a", plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("explain", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept("EXPLAIN logical SELECT 1", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported SQL statement"}));
            this.intercept("EXPLAIN formatted SELECT 1", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported SQL statement"}));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("set operations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan a = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("a")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            LogicalPlan b = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("b")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("select * from a union select * from b", (LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b)));
            this.assertEqual("select * from a union distinct select * from b", (LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b)));
            this.assertEqual("select * from a union all select * from b", package.plans$.MODULE$.DslLogicalPlan(a).union(b));
            this.assertEqual("select * from a except select * from b", package.plans$.MODULE$.DslLogicalPlan(a).except(b, false));
            this.assertEqual("select * from a except distinct select * from b", package.plans$.MODULE$.DslLogicalPlan(a).except(b, false));
            this.assertEqual("select * from a except all select * from b", package.plans$.MODULE$.DslLogicalPlan(a).except(b, true));
            this.assertEqual("select * from a minus select * from b", package.plans$.MODULE$.DslLogicalPlan(a).except(b, false));
            this.assertEqual("select * from a minus all select * from b", package.plans$.MODULE$.DslLogicalPlan(a).except(b, true));
            this.assertEqual("select * from a minus distinct select * from b", package.plans$.MODULE$.DslLogicalPlan(a).except(b, false));
            this.assertEqual("select * from a intersect select * from b", package.plans$.MODULE$.DslLogicalPlan(a).intersect(b, false));
            this.assertEqual("select * from a intersect distinct select * from b", package.plans$.MODULE$.DslLogicalPlan(a).intersect(b, false));
            this.assertEqual("select * from a intersect all select * from b", package.plans$.MODULE$.DslLogicalPlan(a).intersect(b, true));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("common table expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("with cte1 as (select * from a) select * from cte1", (LogicalPlan)PlanParserSuite.cte$1(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("cte1")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cte1"), (Object)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("a")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))})));
            this.assertEqual("with cte1 (select 1) select * from cte1", (LogicalPlan)PlanParserSuite.cte$1(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("cte1")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cte1"), (Object)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})))})));
            this.assertEqual("with cte1 (select 1), cte2 as (select * from cte1) select * from cte2", (LogicalPlan)PlanParserSuite.cte$1(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("cte2")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cte1"), (Object)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cte2"), (Object)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("cte1")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))})));
            this.intercept("with cte1 (select 1), cte1 as (select 1 from cte1) select * from cte1", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found duplicate keys 'cte1'"}));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        this.test("simple select query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("select 1", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})));
            this.assertEqual("select a, b", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})));
            this.assertEqual("select a, b from db.c", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("db", "c")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})));
            this.assertEqual("select a, b from db.c where x < 1", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("db", "c")).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "x")).$less((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})));
            this.assertEqual("select a, b from db.c having x < 1", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("db", "c")).groupBy((Seq)Nil$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "x")).$less((Expression)package.expressions$.MODULE$.intToLiteral(1))));
            this.assertEqual("select distinct a, b from db.c", (LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("db", "c")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))));
            this.assertEqual("select all a, b from db.c", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("db", "c")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})));
            this.assertEqual("select from tbl", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "from")).as("tbl")})));
            this.assertEqual("select a from 1k.2m", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("1k", "2m")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.test("reverse select query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("from a", package.plans$.MODULE$.table("a"));
            this.assertEqual("from a select b, c", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("a")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))})));
            this.assertEqual("from db.a select b, c where d < 1", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("db", "a")).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).$less((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))})));
            this.assertEqual("from a select distinct b, c", (LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("a")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))));
            this.assertEqual("from (from a union all from b) c select *", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("a")).union(package.plans$.MODULE$.table("b"))).as("c")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("multi select query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("from a select * select * where s < 10", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("a")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).union(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("a")).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "s")).$less((Expression)package.expressions$.MODULE$.intToLiteral(10)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))));
            this.intercept("from a select * select * from x where a.s < 10", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Multi-Insert queries cannot have a FROM clause in their individual SELECT statements"}));
            package.plans$.DslLogicalPlan qual$1 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("a")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            String x$1 = "tbl1";
            boolean x$2 = qual$1.insertInto$default$2();
            package.plans$.DslLogicalPlan qual$2 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("a")).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "s")).$less((Expression)package.expressions$.MODULE$.intToLiteral(10)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            String x$3 = "tbl2";
            boolean x$4 = qual$2.insertInto$default$2();
            this.assertEqual("from a insert into tbl1 select * insert into tbl2 select * where s < 10", package.plans$.MODULE$.DslLogicalPlan(qual$1.insertInto(x$1, x$2)).union(qual$2.insertInto(x$3, x$4)));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        this.test("query organization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String baseSql = "select * from t";
            LogicalPlan basePlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            Map ws = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"w1"), (Object)new WindowSpecDefinition((Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (WindowFrame)UnspecifiedFrame$.MODULE$))}));
            Seq limitWindowClauses = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Function1 & Serializable & scala.Serializable)p -> p), new Tuple2((Object)" limit 10", (Function1 & Serializable & scala.Serializable)p -> package.plans$.MODULE$.DslLogicalPlan(p).limit((Expression)package.expressions$.MODULE$.intToLiteral(10))), new Tuple2((Object)" window w1 as ()", (Function1 & Serializable & scala.Serializable)p -> new WithWindowDefinition(ws, p)), new Tuple2((Object)" window w1 as () limit 10", (Function1 & Serializable & scala.Serializable)p -> package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new WithWindowDefinition(ws, p)).limit((Expression)package.expressions$.MODULE$.intToLiteral(10)))}));
            Seq orderSortDistrClusterClauses = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)basePlan), new Tuple2((Object)" order by a, b desc", (Object)package.plans$.MODULE$.DslLogicalPlan(basePlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()}))), new Tuple2((Object)" sort by a, b desc", (Object)package.plans$.MODULE$.DslLogicalPlan(basePlan).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).desc()})))}));
            orderSortDistrClusterClauses.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                PlanParserSuite.$anonfun$new$14(this, limitWindowClauses, baseSql, x0$1);
                return BoxedUnit.UNIT;
            });
            String msg = "Combination of ORDER BY/SORT BY/DISTRIBUTE BY/CLUSTER BY is not supported";
            this.intercept(new StringBuilder(21).append(baseSql).append(" order by a sort by a").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{msg}));
            this.intercept(new StringBuilder(29).append(baseSql).append(" cluster by a distribute by a").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{msg}));
            this.intercept(new StringBuilder(24).append(baseSql).append(" order by a cluster by a").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{msg}));
            this.intercept(new StringBuilder(27).append(baseSql).append(" order by a distribute by a").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{msg}));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("insert into", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sql = "select * from t";
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringBuilder(25).append("insert overwrite table s ").append(sql).toString(), PlanParserSuite.insert$1(Predef$.MODULE$.Map().empty(), true, PlanParserSuite.insert$default$3$1(), plan));
            this.assertEqual(new StringBuilder(57).append("insert overwrite table s partition (e = 1) if not exists ").append(sql).toString(), PlanParserSuite.insert$1((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e"), (Object)Option$.MODULE$.apply((Object)"1"))})), true, true, plan));
            this.assertEqual(new StringBuilder(14).append("insert into s ").append(sql).toString(), PlanParserSuite.insert$1(Predef$.MODULE$.Map().empty(), PlanParserSuite.insert$default$2$1(), PlanParserSuite.insert$default$3$1(), plan));
            this.assertEqual(new StringBuilder(47).append("insert into table s partition (c = 'd', e = 1) ").append(sql).toString(), PlanParserSuite.insert$1((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)Option$.MODULE$.apply((Object)"d")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e"), (Object)Option$.MODULE$.apply((Object)"1"))})), PlanParserSuite.insert$default$2$1(), PlanParserSuite.insert$default$3$1(), plan));
            LogicalPlan plan2 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "x")).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("from t insert into s select * limit 1 insert into u select * where x > 5", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new InsertIntoTable(package.plans$.MODULE$.table("s"), Predef$.MODULE$.Map().empty(), package.plans$.MODULE$.DslLogicalPlan(plan).limit((Expression)package.expressions$.MODULE$.intToLiteral(1)), false, false)).union((LogicalPlan)new InsertIntoTable(package.plans$.MODULE$.table("u"), Predef$.MODULE$.Map().empty(), plan2, false, false)));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        this.test("insert with if not exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String sql = "select * from t";
            this.intercept(new StringBuilder(60).append("insert overwrite table s partition (e = 1, x) if not exists ").append(sql).toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dynamic partitions do not support IF NOT EXISTS. Specified partitions with value: [x]"}));
            return (ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(new StringBuilder(39).append("insert overwrite table s if not exists ").append(sql).toString()), ClassTag$.MODULE$.apply(ParseException.class), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        this.test("aggregation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String m;
            String sql = "select a, b, sum(c) as c from d group by a, b";
            this.assertEqual(sql, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("d")).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as("c")})));
            this.assertEqual(new StringBuilder(10).append(sql).append(" with cube").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("d")).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Cube((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as("c")})));
            this.assertEqual(new StringBuilder(12).append(sql).append(" with rollup").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("d")).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Rollup((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as("c")})));
            this.assertEqual(new StringBuilder(31).append(sql).append(" grouping sets((a, b), (a), ())").toString(), (LogicalPlan)new GroupingSets((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), package.plans$.MODULE$.table("d"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedExpression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")), package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "sum")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as("c")}))));
            String $org_scalatest_assert_macro_left = m = ((ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan("SELECT a, b, count(distinct a, distinct b) as c FROM d GROUP BY a, b"), ClassTag$.MODULE$.apply(ParseException.class), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230))).getMessage();
            String $org_scalatest_assert_macro_right = "extraneous input 'b'";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        this.test("limit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sql = "select * from t";
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringBuilder(9).append(sql).append(" limit 10").toString(), package.plans$.MODULE$.DslLogicalPlan(plan).limit((Expression)package.expressions$.MODULE$.intToLiteral(10)));
            this.assertEqual(new StringBuilder(25).append(sql).append(" limit cast(9 / 4 as int)").toString(), package.plans$.MODULE$.DslLogicalPlan(plan).limit((Expression)new Cast(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)9))).$div((Expression)package.expressions$.MODULE$.intToLiteral(4)), (DataType)IntegerType$.MODULE$, Cast$.MODULE$.apply$default$3())));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        this.test("window spec", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sql = "select * from t";
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            WindowSpecDefinition spec = new WindowSpecDefinition((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).asc()})), (WindowFrame)new SpecifiedWindowFrame((FrameType)RowFrame$.MODULE$, package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).unary_$minus(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))));
            Map ws1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"w1"), (Object)spec), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"w2"), (Object)spec), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"w3"), (Object)spec)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(149).append(sql).append("\n         |window w1 as (partition by a, b order by c rows between 1 preceding and 1 following),\n         |       w2 as w1,\n         |       w3 as w1").toString())).stripMargin(), (LogicalPlan)new WithWindowDefinition(ws1, plan));
            this.intercept(new StringBuilder(16).append(sql).append(" window w2 as w1").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot resolve window reference 'w1'"}));
            this.intercept(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(149).append(sql).append("\n         |window w1 as (partition by a, b order by c rows between 1 preceding and 1 following),\n         |       w2 as w1,\n         |       w3 as w2").toString())).stripMargin(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Window reference 'w2' is not a window specification"}));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        this.test("lateral view", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UnresolvedGenerator explode = new UnresolvedGenerator(FunctionIdentifier$.MODULE$.apply("explode"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "x"))})));
            UnresolvedGenerator jsonTuple = new UnresolvedGenerator(FunctionIdentifier$.MODULE$.apply("json_tuple"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "x")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "y"))})));
            package.plans$.DslLogicalPlan qual$3 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t"));
            UnresolvedGenerator x$5 = explode;
            Some x$6 = new Some((Object)"expl");
            Seq x$7 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}));
            Seq x$8 = qual$3.generate$default$2();
            boolean x$9 = qual$3.generate$default$3();
            this.assertEqual("select * from t lateral view explode(x) expl as x", package.plans$.MODULE$.DslLogicalPlan(qual$3.generate((Generator)x$5, x$8, x$9, (Option)x$6, x$7)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            package.plans$.DslLogicalPlan qual$4 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t"));
            UnresolvedGenerator x$10 = explode;
            Some x$11 = new Some((Object)"expl");
            Seq x$12 = qual$4.generate$default$2();
            boolean x$13 = qual$4.generate$default$3();
            Seq x$14 = qual$4.generate$default$5();
            package.plans$.DslLogicalPlan qual$5 = package.plans$.MODULE$.DslLogicalPlan(qual$4.generate((Generator)x$10, x$12, x$13, (Option)x$11, x$14));
            UnresolvedGenerator x$15 = jsonTuple;
            boolean x$16 = true;
            Some x$17 = new Some((Object)"jtup");
            Seq x$18 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"q", "z"}));
            Seq x$19 = qual$5.generate$default$2();
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("select *\n        |from t\n        |lateral view explode(x) expl\n        |lateral view outer json_tuple(x, y) jtup q, z")).stripMargin(), package.plans$.MODULE$.DslLogicalPlan(qual$5.generate((Generator)x$15, x$19, x$16, (Option)x$17, x$18)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            package.plans$.DslLogicalPlan qual$6 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t1"));
            UnresolvedGenerator x$20 = explode;
            Some x$21 = new Some((Object)"expl");
            Seq x$22 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}));
            Seq x$23 = qual$6.generate$default$2();
            boolean x$24 = qual$6.generate$default$3();
            LogicalPlan from = qual$6.generate((Generator)x$20, x$23, x$24, (Option)x$21, x$22);
            package.plans$.DslLogicalPlan qual$7 = package.plans$.MODULE$.DslLogicalPlan(from);
            UnresolvedGenerator x$25 = jsonTuple;
            Some x$26 = new Some((Object)"jtup");
            Seq x$27 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"q", "z"}));
            Seq x$28 = qual$7.generate$default$2();
            boolean x$29 = qual$7.generate$default$3();
            package.plans$.DslLogicalPlan qual$8 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$7.generate((Generator)x$25, x$28, x$29, (Option)x$26, x$27)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            String x$30 = "t2";
            boolean x$31 = qual$8.insertInto$default$2();
            package.plans$.DslLogicalPlan qual$9 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(from).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "s")).$less((Expression)package.expressions$.MODULE$.intToLiteral(10)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            String x$32 = "t3";
            boolean x$33 = qual$9.insertInto$default$2();
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("from t1\n        |lateral view explode(x) expl as x\n        |insert into t2\n        |select *\n        |lateral view json_tuple(x, y) jtup q, z\n        |insert into t3\n        |select *\n        |where s < 10\n      ")).stripMargin(), (LogicalPlan)Union$.MODULE$.apply(qual$8.insertInto(x$30, x$31), qual$9.insertInto(x$32, x$33)));
            package.plans$.DslLogicalPlan qual$10 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t"));
            UnresolvedGenerator x$34 = new UnresolvedGenerator(FunctionIdentifier$.MODULE$.apply("posexplode"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "x"))})));
            Some x$35 = new Some((Object)"posexpl");
            Seq x$36 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x", "y"}));
            Seq x$37 = qual$10.generate$default$2();
            boolean x$38 = qual$10.generate$default$3();
            LogicalPlan expected = package.plans$.MODULE$.DslLogicalPlan(qual$10.generate((Generator)x$34, x$37, x$38, (Option)x$35, x$36)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("select * from t lateral view posexplode(x) posexpl as x, y", expected);
            this.intercept(new StringOps(Predef$.MODULE$.augmentString("select *\n        |from t\n        |lateral view explode(x) expl\n        |pivot (\n        |  sum(x)\n        |  FOR y IN ('a', 'b')\n        |)")).stripMargin(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LATERAL cannot be used together with PIVOT in FROM clause"}));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        this.test("joins", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Function2 & Serializable & scala.Serializable testUnconditionalJoin = (Function2 & Serializable & scala.Serializable)(sql, jt) -> {
                this.assertEqual(new StringBuilder(24).append("select * from t as tt ").append(sql).append(" u").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).as("tt")).join(package.plans$.MODULE$.table("u"), jt, (Option)None$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
                return BoxedUnit.UNIT;
            };
            Function2 & Serializable & scala.Serializable testConditionalJoin = (Function2 & Serializable & scala.Serializable)(sql, jt) -> {
                this.assertEqual(new StringBuilder(33).append("select * from t ").append(sql).append(" u as uu on a = b").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).join(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("u")).as("uu"), jt, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b")))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
                return BoxedUnit.UNIT;
            };
            Function2 & Serializable & scala.Serializable testNaturalJoin = (Function2 & Serializable & scala.Serializable)(sql, jt) -> {
                this.assertEqual(new StringBuilder(35).append("select * from t tt natural ").append(sql).append(" u as uu").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).as("tt")).join(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("u")).as("uu"), (JoinType)new NaturalJoin(jt), (Option)None$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
                return BoxedUnit.UNIT;
            };
            Function2 & Serializable & scala.Serializable testUsingJoin = (Function2 & Serializable & scala.Serializable)(sql, jt) -> {
                this.assertEqual(new StringBuilder(30).append("select * from t ").append(sql).append(" u using(a, b)").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).join(package.plans$.MODULE$.table("u"), (JoinType)new UsingJoin(jt, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}))), (Option)None$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
                return BoxedUnit.UNIT;
            };
            Seq testAll = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function2[]{testUnconditionalJoin, testConditionalJoin, testNaturalJoin, testUsingJoin}));
            Seq testExistence = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function2[]{testUnconditionalJoin, testConditionalJoin, testUsingJoin}));
            PlanParserSuite.test$1("cross join", (JoinType)Cross$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function2[]{testUnconditionalJoin})));
            PlanParserSuite.test$1(",", (JoinType)Inner$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function2[]{testUnconditionalJoin})));
            PlanParserSuite.test$1("join", (JoinType)Inner$.MODULE$, testAll);
            PlanParserSuite.test$1("inner join", (JoinType)Inner$.MODULE$, testAll);
            PlanParserSuite.test$1("left join", (JoinType)LeftOuter$.MODULE$, testAll);
            PlanParserSuite.test$1("left outer join", (JoinType)LeftOuter$.MODULE$, testAll);
            PlanParserSuite.test$1("right join", (JoinType)RightOuter$.MODULE$, testAll);
            PlanParserSuite.test$1("right outer join", (JoinType)RightOuter$.MODULE$, testAll);
            PlanParserSuite.test$1("full join", (JoinType)FullOuter$.MODULE$, testAll);
            PlanParserSuite.test$1("full outer join", (JoinType)FullOuter$.MODULE$, testAll);
            PlanParserSuite.test$1("left semi join", (JoinType)LeftSemi$.MODULE$, testExistence);
            PlanParserSuite.test$1("left anti join", (JoinType)LeftAnti$.MODULE$, testExistence);
            PlanParserSuite.test$1("anti join", (JoinType)LeftAnti$.MODULE$, testExistence);
            this.intercept("select * from a natural cross join b", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.intercept("select * from a natural join b on a.id = b.id", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            package.plans$.DslLogicalPlan qual$11 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("a"));
            LogicalPlan x$39 = package.plans$.MODULE$.table("b");
            JoinType x$40 = qual$11.join$default$2();
            Option x$41 = qual$11.join$default$3();
            package.plans$.DslLogicalPlan qual$12 = package.plans$.MODULE$.DslLogicalPlan(qual$11.join(x$39, x$40, x$41));
            LogicalPlan x$42 = package.plans$.MODULE$.table("c");
            JoinType x$43 = qual$12.join$default$2();
            Option x$44 = qual$12.join$default$3();
            package.plans$.DslLogicalPlan qual$13 = package.plans$.MODULE$.DslLogicalPlan(qual$12.join(x$42, x$43, x$44));
            LogicalPlan x$45 = package.plans$.MODULE$.table("d");
            RightOuter$ x$46 = RightOuter$.MODULE$;
            Option x$47 = qual$13.join$default$3();
            this.assertEqual("select * from a join b join c right join d", package.plans$.MODULE$.DslLogicalPlan(qual$13.join(x$45, (JoinType)x$46, x$47)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            package.plans$.DslLogicalPlan qual$14 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t1"));
            LogicalPlan x$48 = package.plans$.MODULE$.table("t2");
            Cross$ x$49 = Cross$.MODULE$;
            Option x$50 = qual$14.join$default$3();
            this.assertEqual("select * from t1 cross join t2 join t3 on t3.id = t1.id join t4 on t4.id = t1.id", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$14.join(x$48, (JoinType)x$49, x$50)).join(package.plans$.MODULE$.table("t3"), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "t3.id")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "t1.id")))))).join(package.plans$.MODULE$.table("t4"), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "t4.id")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "t1.id")))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.intercept("select * from t1 inner join t2 inner join t3 on col3 = col2 on col3 = col1", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.assertEqual("select * from t1 inner join (t2 inner join t3 on col3 = col2) on col3 = col1", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t1")).join(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t2")).join(package.plans$.MODULE$.table("t3"), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "col3")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "col2"))))), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "col3")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "col1")))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual("select * from t1 inner join (t2 inner join t3) on col3 = col2", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t1")).join(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t2")).join(package.plans$.MODULE$.table("t3"), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "col3")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "col2")))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual("select * from t1 inner join (t2 inner join t3 on col3 = col2)", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t1")).join(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t2")).join(package.plans$.MODULE$.table("t3"), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "col3")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "col2"))))), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            package.plans$.DslLogicalPlan qual$15 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t1"));
            LogicalPlan x$51 = package.plans$.MODULE$.table("t3");
            JoinType x$52 = qual$15.join$default$2();
            Option x$53 = qual$15.join$default$3();
            this.assertEqual("select * from t1, t3 join t2 on t1.col1 = t2.col2", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$15.join(x$51, x$52, x$53)).join(package.plans$.MODULE$.table("t2"), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "t1.col1")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "t2.col2")))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
        this.test("sampled relations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sql = "select * from t";
            this.assertEqual(new StringBuilder(22).append(sql).append(" tablesample(100 rows)").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).limit((Expression)package.expressions$.MODULE$.intToLiteral(100))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual(new StringBuilder(29).append(sql).append(" tablesample(43 percent) as x").toString(), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Sample(0.0, 0.43, false, 10L, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).as("x"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual(new StringBuilder(37).append(sql).append(" tablesample(bucket 4 out of 10) as x").toString(), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Sample(0.0, 0.4, false, 10L, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).as("x"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.intercept(new StringBuilder(42).append(sql).append(" tablesample(bucket 4 out of 10 on x) as x").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TABLESAMPLE(BUCKET x OUT OF y ON colname) is not supported"}));
            this.intercept(new StringBuilder(38).append(sql).append(" tablesample(bucket 11 out of 10) as x").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(47).append("Sampling fraction (").append(1.1).append(") must be on interval [0, 1]").toString()}));
            this.intercept("SELECT * FROM parquet_t0 TABLESAMPLE(300M) s", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TABLESAMPLE(byteLengthLiteral) is not supported"}));
            this.intercept("SELECT * FROM parquet_t0 TABLESAMPLE(BUCKET 3 OUT OF 32 ON rand()) s", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TABLESAMPLE(BUCKET x OUT OF y ON function) is not supported"}));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
        this.test("sub-query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t0")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "id"))}));
            this.assertEqual("select id from (t0)", plan);
            this.assertEqual("select id from ((((((t0))))))", plan);
            this.assertEqual("(select * from t1) union distinct (select * from t2)", (LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t1")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).union(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t2")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))));
            this.assertEqual("select * from ((select * from t1) union (select * from t2)) t", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t1")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).union(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t2")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))))).as("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("select  id\n        |from (((select id from t0)\n        |       union all\n        |       (select  id from t0))\n        |      union all\n        |      (select id from t0)) as u_1\n      ")).stripMargin(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(plan).union(plan)).union(plan)).as("u_1")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "id"))})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
        this.test("scalar sub-query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("select (select max(b) from s) ss from t", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("s")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "max")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3())).as("ss")})));
            this.assertEqual("select * from t where a = (select b from s)", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("s")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3())))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual("select g from t group by g having a > (select b from s)", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "g"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "g"))}))).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("s")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3()))));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 466));
        this.test("table reference", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("table t", package.plans$.MODULE$.table("t"));
            this.assertEqual("table d.t", package.plans$.MODULE$.table("d", "t"));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
        this.test("table valued function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
            this.assertEqual("select * from range(2)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new UnresolvedTableValuedFunction("range", (Seq)Nil$.MODULE$.$colon$colon((Object)literal), (Seq)Seq$.MODULE$.empty())).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
        this.test("SPARK-20311 range(N) as alias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10));
            this.assertEqual("SELECT * FROM range(10) AS t", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)SubqueryAlias$.MODULE$.apply("t", (LogicalPlan)new UnresolvedTableValuedFunction("range", (Seq)Nil$.MODULE$.$colon$colon((Object)literal), (Seq)Seq$.MODULE$.empty()))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            Literal literal2 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)7));
            String string = "a";
            this.assertEqual("SELECT * FROM range(7) AS t(a)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)SubqueryAlias$.MODULE$.apply("t", (LogicalPlan)new UnresolvedTableValuedFunction("range", (Seq)Nil$.MODULE$.$colon$colon((Object)literal2), (Seq)Nil$.MODULE$.$colon$colon((Object)string)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
        this.test("SPARK-20841 Support table column aliases in FROM clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertEqual("SELECT * FROM testData AS t(col1, col2)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new UnresolvedSubqueryColumnAliases((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1", "col2"})), (LogicalPlan)SubqueryAlias$.MODULE$.apply("t", (LogicalPlan)new UnresolvedRelation(TableIdentifier$.MODULE$.apply("testData"))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
        this.test("SPARK-20962 Support subquery column aliases in FROM clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertEqual("SELECT * FROM (SELECT a AS x, b AS y FROM t) t(col1, col2)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new UnresolvedSubqueryColumnAliases((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1", "col2"})), (LogicalPlan)SubqueryAlias$.MODULE$.apply("t", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new UnresolvedRelation(TableIdentifier$.MODULE$.apply("t"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).as("x"), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).as("y")}))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511));
        this.test("SPARK-20963 Support aliases for join relations in FROM clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan src1 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new UnresolvedRelation(TableIdentifier$.MODULE$.apply("src1"))).as("s1");
            LogicalPlan src2 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new UnresolvedRelation(TableIdentifier$.MODULE$.apply("src2"))).as("s2");
            this.assertEqual("SELECT * FROM (src1 s1 INNER JOIN src2 s2 ON s1.id = s2.id) dst(a, b, c, d)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new UnresolvedSubqueryColumnAliases((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d"})), (LogicalPlan)SubqueryAlias$.MODULE$.apply("dst", package.plans$.MODULE$.DslLogicalPlan(src1).join(src2, (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "s1.id")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "s2.id")))))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
        this.test("inline table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("values 1, 2, 3, 4", (LogicalPlan)new UnresolvedInlineTable((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1"})), (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4}))).map((Function1 & Serializable & scala.Serializable)x -> PlanParserSuite.$anonfun$new$40(BoxesRunTime.unboxToInt((Object)x)), Seq$.MODULE$.canBuildFrom())));
            Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply((Object)"a")}));
            Seq seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), Literal$.MODULE$.apply((Object)"b")}));
            this.assertEqual("values (1, 'a'), (2, 'b') as tbl(a, b)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new UnresolvedInlineTable((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)Nil$.MODULE$.$colon$colon((Object)seq2).$colon$colon((Object)seq))).as("tbl"));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 535));
        this.test("simple select query with !> and !<", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("select a, b from db.c where x !< 1", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("db", "c")).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "x")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})));
            this.assertEqual("select a, b from db.c where x !> 1", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("db", "c")).where((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "x")).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "b"))})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 546));
        this.test("select hint syntax", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String m3;
            String m;
            String $org_scalatest_assert_macro_left = m = ((ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT() */ * FROM t"), ClassTag$.MODULE$.apply(ParseException.class), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557))).getMessage();
            String $org_scalatest_assert_macro_right = "mismatched input";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 560));
            String $org_scalatest_assert_macro_left2 = m3 = ((ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ INDEX(a b c) */ * from default.t"), ClassTag$.MODULE$.apply(ParseException.class), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 563))).getMessage();
            String $org_scalatest_assert_macro_right2 = "mismatched input 'b' expecting";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 566));
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT */ * FROM t"), (LogicalPlan)new UnresolvedHint("HINT", (Seq)Seq$.MODULE$.empty(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ BROADCASTJOIN(u) */ * FROM t"), (LogicalPlan)new UnresolvedHint("BROADCASTJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).$((Seq)Nil$.MODULE$)})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ MAPJOIN(u) */ * FROM t"), (LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).$((Seq)Nil$.MODULE$)})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ STREAMTABLE(a,b,c) */ * FROM t"), (LogicalPlan)new UnresolvedHint("STREAMTABLE", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ INDEX(t, emp_job_ix) */ * FROM t"), (LogicalPlan)new UnresolvedHint("INDEX", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"emp_job_ix"}))).$((Seq)Nil$.MODULE$)})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ MAPJOIN(`default.t`) */ * from `default.t`"), (LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{UnresolvedAttribute$.MODULE$.quoted("default.t")})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("default.t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ MAPJOIN(t) */ a from t where true group by a order by a"), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).$((Seq)Nil$.MODULE$)})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).where((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a"))})))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).asc()})), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ COALESCE(10) */ * FROM t"), (LogicalPlan)new UnresolvedHint("COALESCE", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ REPARTITION(100) */ * FROM t"), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100))})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("INSERT INTO s SELECT /*+ REPARTITION(100), COALESCE(500), COALESCE(10) */ * FROM t"), (LogicalPlan)new InsertIntoTable(package.plans$.MODULE$.table("s"), Predef$.MODULE$.Map().empty(), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100))})), (LogicalPlan)new UnresolvedHint("COALESCE", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)500))})), (LogicalPlan)new UnresolvedHint("COALESCE", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))))), false, false), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ BROADCASTJOIN(u), REPARTITION(100) */ * FROM t"), (LogicalPlan)new UnresolvedHint("BROADCASTJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).$((Seq)Nil$.MODULE$)})), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100))})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))), this.comparePlans$default$3());
            this.intercept("SELECT /*+ COALESCE(30 + 50) */ * FROM t", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mismatched input"}));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 555));
        this.test("SPARK-20854: select hint syntax with expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Unevaluable[] unevaluableArray = new Unevaluable[2];
            unevaluableArray[0] = package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$);
            Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Literal literal2 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
            Literal literal3 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3));
            unevaluableArray[1] = UnresolvedFunction$.MODULE$.apply("array", (Seq)Nil$.MODULE$.$colon$colon((Object)literal3).$colon$colon((Object)literal2).$colon$colon((Object)literal), false);
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1(a, array(1, 2, 3)) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])unevaluableArray)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1(a, 5, 'a', b) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5)), Literal$.MODULE$.apply((Object)"a"), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            Expression[] expressionArray = new Expression[3];
            expressionArray[0] = Literal$.MODULE$.apply((Object)"a");
            UnresolvedAttribute unresolvedAttribute = package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$);
            UnresolvedAttribute unresolvedAttribute2 = package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$);
            expressionArray[1] = CreateStruct$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2).$colon$colon((Object)unresolvedAttribute));
            Literal literal4 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Literal literal5 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
            expressionArray[2] = CreateStruct$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)literal5).$colon$colon((Object)literal4));
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1('a', (b, c), (1, 2)) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])expressionArray)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 626));
        this.test("SPARK-20854: multiple hints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1(a, 1) hint2(b, 2) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))})), (LogicalPlan)new UnresolvedHint("hint2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1(a, 1),hint2(b, 2) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))})), (LogicalPlan)new UnresolvedHint("hint2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1(a, 1) */ /*+ hint2(b, 2) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))})), (LogicalPlan)new UnresolvedHint("hint2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1(a, 1), hint2(b, 2) */ /*+ hint3(c, 3) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))})), (LogicalPlan)new UnresolvedHint("hint2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))})), (LogicalPlan)new UnresolvedHint("hint3", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))))), this.comparePlans$default$3());
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
        this.test("TRIM function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept("select ltrim(both 'S' from 'SS abc S'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"missing ')' at '<EOF>'"}));
            this.intercept("select rtrim(trailing 'S' from 'SS abc S'", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"missing ')' at '<EOF>'"}));
            this.assertEqual("SELECT TRIM(BOTH '@$%&( )abc' FROM '@ $ % & ()abc ' )", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "TRIM")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("@$%&( )abc"), package.expressions$.MODULE$.stringToLiteral("@ $ % & ()abc ")}))})));
            this.assertEqual("SELECT TRIM(LEADING 'c []' FROM '[ ccccbcc ')", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "ltrim")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("c []"), package.expressions$.MODULE$.stringToLiteral("[ ccccbcc ")}))})));
            this.assertEqual("SELECT TRIM(TRAILING 'c&^,.' FROM 'bc...,,,&&&ccc')", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "rtrim")).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("c&^,."), package.expressions$.MODULE$.stringToLiteral("bc...,,,&&&ccc")}))})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 693));
        this.test("precedence of set operations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan a = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("a")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            LogicalPlan b = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("b")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            LogicalPlan c = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("c")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            LogicalPlan d = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("d")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            String query1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM a\n        |UNION\n        |SELECT * FROM b\n        |EXCEPT\n        |SELECT * FROM c\n        |INTERSECT\n        |SELECT * FROM d\n      ")).stripMargin();
            String query2 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM a\n        |UNION\n        |SELECT * FROM b\n        |EXCEPT ALL\n        |SELECT * FROM c\n        |INTERSECT ALL\n        |SELECT * FROM d\n      ")).stripMargin();
            this.assertEqual(query1, package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b))).except(package.plans$.MODULE$.DslLogicalPlan(c).intersect(d, false), false));
            this.assertEqual(query2, package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b))).except(package.plans$.MODULE$.DslLogicalPlan(c).intersect(d, true), true));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_SETOPS_PRECEDENCE_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.assertEqual(query1, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b))).except(c, false)).intersect(d, false));
                this.assertEqual(query2, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b))).except(c, true)).intersect(d, true));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_SETOPS_PRECEDENCE_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.assertEqual(query1, package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b))).except(package.plans$.MODULE$.DslLogicalPlan(c).intersect(d, false), false));
                this.assertEqual(query2, package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b))).except(package.plans$.MODULE$.DslLogicalPlan(c).intersect(d, true), true));
            });
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 711));
    }
}

