/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001]2AAB\u0004\u0001)!)\u0011\u0004\u0001C\u00015!9Q\u0004\u0001b\u0001\n\u0003q\u0002BB\u0017\u0001A\u0003%q\u0004C\u0004/\u0001\t\u0007I\u0011A\u0018\t\rY\u0002\u0001\u0015!\u00031\u0005i!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\b+\u0019:tKJ\u001cV/\u001b;f\u0015\tA\u0011\"\u0001\u0004qCJ\u001cXM\u001d\u0006\u0003\u0015-\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u00195\t1a]9m\u0015\tqq\"A\u0003ta\u0006\u00148N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001A\n\u0003\u0001U\u0001\"AF\f\u000e\u00035I!\u0001G\u0007\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\tq!\u0001\fiSZ,gj\u001c8SKN,'O^3e\u0017\u0016Lxo\u001c:e+\u0005y\u0002c\u0001\u0011$K5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013EA\u0003BeJ\f\u0017\u0010\u0005\u0002'W5\tqE\u0003\u0002)S\u0005!A.\u00198h\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\rM#(/\u001b8h\u0003]A\u0017N^3O_:\u0014Vm]3sm\u0016$7*Z=x_J$\u0007%\u0001\u000fiSZ,7\u000b\u001e:jGRtuN\u001c*fg\u0016\u0014h/\u001a3LKf<xN\u001d3\u0016\u0003A\u00022!\r\u001b&\u001b\u0005\u0011$BA\u001a\"\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003kI\u00121aU3r\u0003uA\u0017N^3TiJL7\r\u001e(p]J+7/\u001a:wK\u0012\\U-_<pe\u0012\u0004\u0003")
public class TableIdentifierParserSuite
extends SparkFunSuite {
    private final String[] hiveNonReservedKeyword = (String[])((Object[])new String[]{"add", "admin", "after", "analyze", "archive", "asc", "before", "bucket", "buckets", "cascade", "change", "cluster", "clustered", "clusterstatus", "collection", "columns", "comment", "compact", "compactions", "compute", "concatenate", "continue", "cost", "data", "day", "databases", "datetime", "dbproperties", "deferred", "defined", "delimited", "dependency", "desc", "directories", "directory", "disable", "distribute", "enable", "escaped", "exclusive", "explain", "export", "fields", "file", "fileformat", "first", "format", "formatted", "functions", "hold_ddltime", "hour", "idxproperties", "ignore", "index", "indexes", "inpath", "inputdriver", "inputformat", "items", "jar", "keys", "key_type", "last", "limit", "offset", "lines", "load", "location", "lock", "locks", "logical", "long", "mapjoin", "materialized", "metadata", "minus", "minute", "month", "msck", "noscan", "no_drop", "nulls", "offline", "option", "outputdriver", "outputformat", "overwrite", "owner", "partitioned", "partitions", "plus", "pretty", "principals", "protection", "purge", "read", "readonly", "rebuild", "recordreader", "recordwriter", "reload", "rename", "repair", "replace", "replication", "restrict", "rewrite", "role", "roles", "schemas", "second", "serde", "serdeproperties", "server", "sets", "shared", "show", "show_database", "skewed", "sort", "sorted", "ssl", "statistics", "stored", "streamtable", "string", "struct", "tables", "tblproperties", "temporary", "terminated", "tinyint", "touch", "transactions", "unarchive", "undo", "uniontype", "unlock", "unset", "unsigned", "uri", "use", "utc", "utctimestamp", "view", "while", "year", "work", "transaction", "write", "isolation", "level", "snapshot", "autocommit", "all", "any", "alter", "array", "as", "authorization", "between", "bigint", "binary", "boolean", "both", "by", "create", "cube", "current_date", "current_timestamp", "cursor", "date", "decimal", "delete", "describe", "double", "drop", "exists", "external", "false", "fetch", "float", "for", "grant", "group", "grouping", "import", "in", "insert", "int", "into", "is", "pivot", "lateral", "like", "local", "none", "null", "of", "order", "out", "outer", "partition", "percent", "procedure", "range", "reads", "revoke", "rollup", "row", "rows", "set", "smallint", "table", "timestamp", "to", "trigger", "true", "truncate", "update", "user", "values", "with", "regexp", "rlike", "bigint", "binary", "boolean", "current_date", "current_timestamp", "date", "double", "float", "int", "smallint", "timestamp", "at", "position", "both", "leading", "trailing", "extract"});
    private final Seq<String> hiveStrictNonReservedKeyword = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"anti", "full", "inner", "left", "semi", "right", "natural", "union", "intersect", "except", "database", "on", "join", "cross", "select", "from", "where", "having", "from", "to", "table", "with", "not"}));

    public String[] hiveNonReservedKeyword() {
        return this.hiveNonReservedKeyword;
    }

    public Seq<String> hiveStrictNonReservedKeyword() {
        return this.hiveStrictNonReservedKeyword;
    }

    public TableIdentifierParserSuite() {
        this.test("table identifier", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(TableIdentifier$.MODULE$.apply("q"));
            TableIdentifier $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableIdentifier("q");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new TableIdentifier("q", Option$.MODULE$.apply((Object)"d")));
            TableIdentifier $org_scalatest_assert_macro_right2 = CatalystSqlParser$.MODULE$.parseTableIdentifier("d.q");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "d.q.g", "t:", "${some.var.x}", "tab:1"}))).foreach((Function1 & Serializable & scala.Serializable)identifier -> (ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parseTableIdentifier(identifier), ClassTag$.MODULE$.apply(ParseException.class), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67)));
        }, new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("quoted identifiers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new TableIdentifier("z", (Option)new Some((Object)"x.y")));
            TableIdentifier $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableIdentifier("`x.y`.z");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new TableIdentifier("y.z", (Option)new Some((Object)"x")));
            TableIdentifier $org_scalatest_assert_macro_right2 = CatalystSqlParser$.MODULE$.parseTableIdentifier("x.`y.z`");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new TableIdentifier("z", (Option)new Some((Object)"`x.y`")));
            TableIdentifier $org_scalatest_assert_macro_right3 = CatalystSqlParser$.MODULE$.parseTableIdentifier("```x.y```.z");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(new TableIdentifier("`y.z`", (Option)new Some((Object)"x")));
            TableIdentifier $org_scalatest_assert_macro_right4 = CatalystSqlParser$.MODULE$.parseTableIdentifier("x.```y.z```");
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(new TableIdentifier("x.y.z", (Option)None$.MODULE$));
            TableIdentifier $org_scalatest_assert_macro_right5 = CatalystSqlParser$.MODULE$.parseTableIdentifier("`x.y.z`");
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        }, new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("table identifier - strict keywords", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.hiveStrictNonReservedKeyword().foreach((Function1 & Serializable & scala.Serializable)keyword -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(TableIdentifier$.MODULE$.apply(keyword));
            TableIdentifier $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableIdentifier(keyword);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(TableIdentifier$.MODULE$.apply(keyword));
            TableIdentifier $org_scalatest_assert_macro_right2 = CatalystSqlParser$.MODULE$.parseTableIdentifier(new StringBuilder(2).append("`").append((String)keyword).append("`").toString());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new TableIdentifier(keyword, Option$.MODULE$.apply((Object)"db")));
            TableIdentifier $org_scalatest_assert_macro_right3 = CatalystSqlParser$.MODULE$.parseTableIdentifier(new StringBuilder(5).append("db.`").append((String)keyword).append("`").toString());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        }), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("table identifier - non reserved keywords", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.hiveNonReservedKeyword())).foreach((Function1 & Serializable & scala.Serializable)nonReserved -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(TableIdentifier$.MODULE$.apply(nonReserved));
            TableIdentifier $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableIdentifier(nonReserved);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        }), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("SPARK-17364 table identifier - contains number", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TableIdentifier $org_scalatest_assert_macro_left = CatalystSqlParser$.MODULE$.parseTableIdentifier("123_");
            TableIdentifier $org_scalatest_assert_macro_right = TableIdentifier$.MODULE$.apply("123_");
            TableIdentifier tableIdentifier = $org_scalatest_assert_macro_left;
            TableIdentifier tableIdentifier2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            TableIdentifier $org_scalatest_assert_macro_left2 = CatalystSqlParser$.MODULE$.parseTableIdentifier("1a.123_");
            TableIdentifier $org_scalatest_assert_macro_right2 = new TableIdentifier("123_", (Option)new Some((Object)"1a"));
            TableIdentifier tableIdentifier3 = $org_scalatest_assert_macro_left2;
            TableIdentifier tableIdentifier4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(tableIdentifier3 != null ? !tableIdentifier3.equals(tableIdentifier4) : tableIdentifier4 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            TableIdentifier $org_scalatest_assert_macro_left3 = CatalystSqlParser$.MODULE$.parseTableIdentifier("a.123A");
            TableIdentifier $org_scalatest_assert_macro_right3 = new TableIdentifier("123A", (Option)new Some((Object)"a"));
            TableIdentifier tableIdentifier5 = $org_scalatest_assert_macro_left3;
            TableIdentifier tableIdentifier6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(tableIdentifier5 != null ? !tableIdentifier5.equals(tableIdentifier6) : tableIdentifier6 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            TableIdentifier $org_scalatest_assert_macro_left4 = CatalystSqlParser$.MODULE$.parseTableIdentifier("a.123E3_LIST");
            TableIdentifier $org_scalatest_assert_macro_right4 = new TableIdentifier("123E3_LIST", (Option)new Some((Object)"a"));
            TableIdentifier tableIdentifier7 = $org_scalatest_assert_macro_left4;
            TableIdentifier tableIdentifier8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(tableIdentifier7 != null ? !tableIdentifier7.equals(tableIdentifier8) : tableIdentifier8 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            TableIdentifier $org_scalatest_assert_macro_left5 = CatalystSqlParser$.MODULE$.parseTableIdentifier("a.123D_LIST");
            TableIdentifier $org_scalatest_assert_macro_right5 = new TableIdentifier("123D_LIST", (Option)new Some((Object)"a"));
            TableIdentifier tableIdentifier9 = $org_scalatest_assert_macro_left5;
            TableIdentifier tableIdentifier10 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(tableIdentifier9 != null ? !tableIdentifier9.equals(tableIdentifier10) : tableIdentifier10 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            TableIdentifier $org_scalatest_assert_macro_left6 = CatalystSqlParser$.MODULE$.parseTableIdentifier("a.123BD_LIST");
            TableIdentifier $org_scalatest_assert_macro_right6 = new TableIdentifier("123BD_LIST", (Option)new Some((Object)"a"));
            TableIdentifier tableIdentifier11 = $org_scalatest_assert_macro_left6;
            TableIdentifier tableIdentifier12 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(tableIdentifier11 != null ? !tableIdentifier11.equals(tableIdentifier12) : tableIdentifier12 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        }, new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("SPARK-17832 table identifier - contains backtick", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TableIdentifier complexName = new TableIdentifier("`weird`table`name", (Option)new Some((Object)"`d`b`1"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(complexName);
            TableIdentifier $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableIdentifier("```d``b``1`.```weird``table``name`");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(complexName);
            TableIdentifier $org_scalatest_assert_macro_right2 = CatalystSqlParser$.MODULE$.parseTableIdentifier(complexName.quotedString());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parseTableIdentifier(complexName.unquotedString()), ClassTag$.MODULE$.apply(ParseException.class), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            TableIdentifier complexName2 = new TableIdentifier("x``y", (Option)new Some((Object)"d``b"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(complexName2);
            TableIdentifier $org_scalatest_assert_macro_right3 = CatalystSqlParser$.MODULE$.parseTableIdentifier(complexName2.quotedString());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        }, new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
    }
}

