/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.package$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t3A!\u0002\u0004\u0001'!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;!)!\u0007\u0001C\u0001g!)q\b\u0001C\u0001\u0001\n1B+\u00192mKN\u001b\u0007.Z7b!\u0006\u00148/\u001a:Tk&$XM\u0003\u0002\b\u0011\u00051\u0001/\u0019:tKJT!!\u0003\u0006\u0002\u0011\r\fG/\u00197zgRT!a\u0003\u0007\u0002\u0007M\fHN\u0003\u0002\u000e\u001d\u0005)1\u000f]1sW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005U1R\"\u0001\u0007\n\u0005]a!!D*qCJ\\g)\u001e8Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u00025A\u00111\u0004A\u0007\u0002\r\u0005)\u0001/\u0019:tKR\u0011a\u0004\n\t\u0003?\tj\u0011\u0001\t\u0006\u0003C)\tQ\u0001^=qKNL!a\t\u0011\u0003\u0015M#(/^2u)f\u0004X\rC\u0003\f\u0005\u0001\u0007Q\u0005\u0005\u0002'_9\u0011q%\f\t\u0003Q-j\u0011!\u000b\u0006\u0003UI\ta\u0001\u0010:p_Rt$\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z\u0013A\u0002)sK\u0012,g-\u0003\u00021c\t11\u000b\u001e:j]\u001eT!AL\u0016\u0002!\rDWmY6UC\ndWmU2iK6\fGc\u0001\u001b9uA\u0011QGN\u0007\u0002W%\u0011qg\u000b\u0002\u0005+:LG\u000fC\u0003:\u0007\u0001\u0007Q%A\tuC\ndWmU2iK6\f7\u000b\u001e:j]\u001eDQaO\u0002A\u0002q\n\u0001#\u001a=qK\u000e$X\r\u001a#bi\u0006$\u0016\u0010]3\u0011\u0005}i\u0014B\u0001 !\u0005!!\u0015\r^1UsB,\u0017aC1tg\u0016\u0014H/\u0012:s_J$\"\u0001N!\t\u000b-!\u0001\u0019A\u0013")
public class TableSchemaParserSuite
extends SparkFunSuite {
    public StructType parse(String sql) {
        return CatalystSqlParser$.MODULE$.parseTableSchema(sql);
    }

    public void checkTableSchema(String tableSchemaString, DataType expectedDataType) {
        this.test(new StringBuilder(6).append("parse ").append(tableSchemaString).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.parse(tableSchemaString));
            DataType $org_scalatest_assert_macro_right = expectedDataType;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableSchemaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        }, new Position("TableSchemaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
    }

    public void assertError(String sql) {
        this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parseTableSchema(sql), ClassTag$.MODULE$.apply(ParseException.class), new Position("TableSchemaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
    }

    public TableSchemaParserSuite() {
        this.checkTableSchema("a int", (DataType)new StructType().add("a", "int"));
        this.checkTableSchema("A int", (DataType)new StructType().add("A", "int"));
        this.checkTableSchema("a INT", (DataType)new StructType().add("a", "int"));
        this.checkTableSchema("`!@#$%.^&*()` string", (DataType)new StructType().add("!@#$%.^&*()", "string"));
        this.checkTableSchema("a int, b long", (DataType)new StructType().add("a", "int").add("b", "long"));
        StructField structField = new StructField("intType", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("ts", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("a", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkTableSchema("a STRUCT<intType: int, ts:timestamp>", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3)));
        this.checkTableSchema("a int comment 'test'", (DataType)new StructType().add("a", "int", true, "test"));
        this.test("complex hive type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String tableSchemaString = new StringOps(Predef$.MODULE$.augmentString("\n        |complexStructCol struct<\n        |struct:struct<deciMal:DECimal, anotherDecimal:decimAL(5,2)>,\n        |MAP:Map<timestamp, varchar(10)>,\n        |arrAy:Array<double>,\n        |anotherArray:Array<char(9)>>\n      ")).stripMargin().replace("\n", "");
            MetadataBuilder builder = new MetadataBuilder();
            builder.putString(package$.MODULE$.HIVE_TYPE_STRING(), "struct<struct:struct<deciMal:decimal(10,0),anotherDecimal:decimal(5,2)>,MAP:map<timestamp,varchar(10)>,arrAy:array<double>,anotherArray:array<char(9)>>");
            StructField structField = new StructField("deciMal", (DataType)DecimalType$.MODULE$.USER_DEFAULT(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("anotherDecimal", (DataType)new DecimalType(5, 2), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField3 = new StructField("struct", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField4 = new StructField("MAP", (DataType)MapType$.MODULE$.apply((DataType)TimestampType$.MODULE$, (DataType)StringType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField5 = new StructField("arrAy", (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField6 = new StructField("anotherArray", (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField7 = new StructField("complexStructCol", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6).$colon$colon((Object)structField5).$colon$colon((Object)structField4).$colon$colon((Object)structField3)), true, builder.build());
            StructType expectedDataType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField7));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.parse(tableSchemaString));
            StructType $org_scalatest_assert_macro_right = expectedDataType;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableSchemaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        }, new Position("TableSchemaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("Negative cases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertError("");
            this.assertError("a");
            this.assertError("a INT b long");
            this.assertError("a INT,, b long");
            this.assertError("a INT, b long,,");
            this.assertError("a INT, b long, c int,");
        }, new Position("TableSchemaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
    }
}

