/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.statsEstimation;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.Statistics$;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils$;
import org.apache.spark.sql.catalyst.statsEstimation.StatsEstimationTestBase;
import org.apache.spark.sql.catalyst.statsEstimation.StatsTestPlan;
import org.apache.spark.sql.catalyst.statsEstimation.StatsTestPlan$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001=4A!\u0003\u0006\u0001/!)a\u0005\u0001C\u0001O!9\u0011\u0006\u0001b\u0001\n\u0013Q\u0003BB\u001c\u0001A\u0003%1\u0006C\u00049\u0001\t\u0007I\u0011B\u001d\t\r5\u0003\u0001\u0015!\u0003;\u0011\u001dq\u0005A1A\u0005\n=Ca!\u0016\u0001!\u0002\u0013\u0001\u0006\"\u0002,\u0001\t\u00139&\u0001G!hOJ,w-\u0019;f\u000bN$\u0018.\\1uS>t7+^5uK*\u00111\u0002D\u0001\u0010gR\fGo]#ti&l\u0017\r^5p]*\u0011QBD\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0002E\u0001\u0004gFd'BA\t\u0013\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019B#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0007\u000f!!\tI\"$D\u0001\u0011\u0013\tY\u0002CA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003;yi\u0011AC\u0005\u0003?)\u0011qc\u0015;biN,5\u000f^5nCRLwN\u001c+fgR\u0014\u0015m]3\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\rb\u0011!\u00029mC:\u001c\u0018BA\u0013#\u0005!\u0001F.\u00198UKN$\u0018A\u0002\u001fj]&$h\bF\u0001)!\ti\u0002!\u0001\u0006d_2,XN\\%oM>,\u0012a\u000b\t\u0004Y=\nT\"A\u0017\u000b\u00059b\u0011aC3yaJ,7o]5p]NL!\u0001M\u0017\u0003\u0019\u0005#HO]5ckR,W*\u00199\u0011\u0005I*T\"A\u001a\u000b\u0005Q\u0012\u0013a\u00027pO&\u001c\u0017\r\\\u0005\u0003mM\u0012!bQ8mk6t7\u000b^1u\u0003-\u0019w\u000e\\;n]&sgm\u001c\u0011\u0002\u00159\fW.\u001a+p\u0003R$(/F\u0001;!\u0011YDi\u0012&\u000f\u0005q\u0012\u0005CA\u001fA\u001b\u0005q$BA \u0017\u0003\u0019a$o\\8u})\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\u00061\u0001K]3eK\u001aL!!\u0012$\u0003\u00075\u000b\u0007O\u0003\u0002D\u0001B\u00111\bS\u0005\u0003\u0013\u001a\u0013aa\u0015;sS:<\u0007C\u0001\u0017L\u0013\taUFA\u0005BiR\u0014\u0018NY;uK\u0006Ya.Y7f)>\fE\u000f\u001e:!\u00035q\u0017-\\3U_\u000e{G.\u00138g_V\t\u0001\u000b\u0005\u0003<\t\u001e\u000b\u0006\u0003\u0002*T\u0015Fj\u0011\u0001Q\u0005\u0003)\u0002\u0013a\u0001V;qY\u0016\u0014\u0014A\u00048b[\u0016$vnQ8m\u0013:4w\u000eI\u0001\u000eG\",7m[!hON#\u0018\r^:\u0015\u000ba[fm[7\u0011\u0005IK\u0016B\u0001.A\u0005\u0011)f.\u001b;\t\u000bqC\u0001\u0019A/\u0002\u0019Q\f'\r\\3D_2,XN\\:\u0011\u0007y\u001bwI\u0004\u0002`C:\u0011Q\bY\u0005\u0002\u0003&\u0011!\rQ\u0001\ba\u0006\u001c7.Y4f\u0013\t!WMA\u0002TKFT!A\u0019!\t\u000b\u001dD\u0001\u0019\u00015\u0002\u001bQ\f'\r\\3S_^\u001cu.\u001e8u!\tq\u0016.\u0003\u0002kK\n1!)[4J]RDQ\u0001\u001c\u0005A\u0002u\u000bab\u001a:pkB\u0014\u0015pQ8mk6t7\u000fC\u0003o\u0011\u0001\u0007\u0001.\u0001\ffqB,7\r^3e\u001fV$\b/\u001e;S_^\u001cu.\u001e8u\u0001")
public class AggregateEstimationSuite
extends SparkFunSuite
implements StatsEstimationTestBase,
PlanTest {
    private final AttributeMap<ColumnStat> columnInfo;
    private final Map<String, Attribute> nameToAttr;
    private final Map<String, Tuple2<Attribute, ColumnStat>> nameToColInfo;
    private boolean originalValue;

    @Override
    public SQLConf conf() {
        return PlanTestBase.conf$(this);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$(this, plan1, plan2);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        PlanTestBase.withSQLConf$(this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$statsEstimation$StatsEstimationTestBase$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$statsEstimation$StatsEstimationTestBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void beforeAll() {
        StatsEstimationTestBase.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        StatsEstimationTestBase.afterAll$(this);
    }

    @Override
    public long getColSize(Attribute attribute, ColumnStat colStat) {
        return StatsEstimationTestBase.getColSize$(this, attribute, colStat);
    }

    @Override
    public AttributeReference attr(String colName) {
        return StatsEstimationTestBase.attr$(this, colName);
    }

    @Override
    public AttributeMap<ColumnStat> toAttributeMap(Seq<Tuple2<String, ColumnStat>> colStats, LogicalPlan plan) {
        return StatsEstimationTestBase.toAttributeMap$(this, colStats, plan);
    }

    @Override
    public ColumnStat rangeColumnStat(int distinctCount, int nullCount) {
        return StatsEstimationTestBase.rangeColumnStat$(this, distinctCount, nullCount);
    }

    @Override
    public boolean originalValue() {
        return this.originalValue;
    }

    @Override
    public void originalValue_$eq(boolean x$1) {
        this.originalValue = x$1;
    }

    private AttributeMap<ColumnStat> columnInfo() {
        return this.columnInfo;
    }

    private Map<String, Attribute> nameToAttr() {
        return this.nameToAttr;
    }

    private Map<String, Tuple2<Attribute, ColumnStat>> nameToColInfo() {
        return this.nameToColInfo;
    }

    private void checkAggStats(Seq<String> tableColumns, BigInt tableRowCount, Seq<String> groupByColumns, BigInt expectedOutputRowCount) {
        Seq attributes = (Seq)groupByColumns.map(this.nameToAttr(), Seq$.MODULE$.canBuildFrom());
        Count x$1 = Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)));
        String x$2 = "cnt";
        ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
        Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
        Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
        Aggregate testAgg = new Aggregate(attributes, (Seq)attributes.$colon$plus((Object)new Alias((Expression)x$1, x$2, x$3, x$4, x$5), Seq$.MODULE$.canBuildFrom()), (LogicalPlan)new StatsTestPlan((Seq<Attribute>)((Seq)tableColumns.map(this.nameToAttr(), Seq$.MODULE$.canBuildFrom())), tableRowCount, (AttributeMap<ColumnStat>)AttributeMap$.MODULE$.apply((Seq)tableColumns.map(this.nameToColInfo(), Seq$.MODULE$.canBuildFrom())), StatsTestPlan$.MODULE$.apply$default$4()));
        AttributeMap expectedAttrStats = AttributeMap$.MODULE$.apply((Seq)groupByColumns.map(this.nameToColInfo(), Seq$.MODULE$.canBuildFrom()));
        Statistics expectedStats = new Statistics(EstimationUtils$.MODULE$.getOutputSize(testAgg.output(), expectedOutputRowCount, expectedAttrStats), (Option)new Some((Object)expectedOutputRowCount), expectedAttrStats, Statistics$.MODULE$.apply$default$4());
        Statistics $org_scalatest_assert_macro_left = testAgg.stats();
        Statistics $org_scalatest_assert_macro_right = expectedStats;
        Statistics statistics = $org_scalatest_assert_macro_left;
        Statistics statistics2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AggregateEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
    }

    public AggregateEstimationSuite() {
        StatsEstimationTestBase.$init$(this);
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$(this);
        this.columnInfo = AttributeMap$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.attr("key11")), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.attr("key12")), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(4)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)10)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)40)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.attr("key21")), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.attr("key22")), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)10)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)20)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.attr("key31")), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.attr("key32")), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(4)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.attr("key33")), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()))})));
        this.nameToAttr = (Map)this.columnInfo().map((Function1 & Serializable & scala.Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((NamedExpression)kv._1()).name()), kv._1()), Map$.MODULE$.canBuildFrom());
        this.nameToColInfo = (Map)this.columnInfo().map((Function1 & Serializable & scala.Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((NamedExpression)kv._1()).name()), kv), Map$.MODULE$.canBuildFrom());
        this.test("set an upper bound if the product of ndv's of group-by columns is too large", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAggStats((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key11", "key12"}))), BigInt$.MODULE$.int2bigInt(4), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key11", "key12"}))), BigInt$.MODULE$.int2bigInt(4)), new Position("AggregateEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("data contains all combinations of distinct values of group-by columns.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAggStats((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key21", "key22"}))), BigInt$.MODULE$.int2bigInt(6), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key21", "key22"}))), ((BigInt)((ColumnStat)((Tuple2)this.nameToColInfo().apply((Object)"key21"))._2()).distinctCount().get()).$times((BigInt)((ColumnStat)((Tuple2)this.nameToColInfo().apply((Object)"key22"))._2()).distinctCount().get())), new Position("AggregateEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("empty group-by column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAggStats((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key11", "key12"}))), BigInt$.MODULE$.int2bigInt(4), (Seq<String>)Nil$.MODULE$, BigInt$.MODULE$.int2bigInt(1)), new Position("AggregateEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("aggregate on empty table - with or without group-by column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkAggStats((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key31"}))), BigInt$.MODULE$.int2bigInt(0), (Seq<String>)Nil$.MODULE$, BigInt$.MODULE$.int2bigInt(1));
            this.checkAggStats((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key31"}))), BigInt$.MODULE$.int2bigInt(0), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key31"}))), BigInt$.MODULE$.int2bigInt(0));
        }, new Position("AggregateEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("group-by column with only null value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAggStats((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key22", "key32"}))), BigInt$.MODULE$.int2bigInt(6), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key22", "key32"}))), (BigInt)((ColumnStat)((Tuple2)this.nameToColInfo().apply((Object)"key22"))._2()).distinctCount().get()), new Position("AggregateEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("group-by column with null value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAggStats((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key21", "key33"}))), BigInt$.MODULE$.int2bigInt(6), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key21", "key33"}))), ((BigInt)((ColumnStat)((Tuple2)this.nameToColInfo().apply((Object)"key21"))._2()).distinctCount().get()).$times(((BigInt)((ColumnStat)((Tuple2)this.nameToColInfo().apply((Object)"key33"))._2()).distinctCount().get()).$plus(BigInt$.MODULE$.int2bigInt(1)))), new Position("AggregateEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("non-cbo estimation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq attributes;
            Seq x$1 = attributes = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key12"}))).map(this.nameToAttr(), Seq$.MODULE$.canBuildFrom());
            BigInt x$2 = BigInt$.MODULE$.int2bigInt(4);
            Some x$3 = new Some((Object)BigInt$.MODULE$.int2bigInt(48));
            AttributeMap x$4 = AttributeMap$.MODULE$.apply((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key12"}))).map(this.nameToColInfo(), Seq$.MODULE$.canBuildFrom()));
            StatsTestPlan child = new StatsTestPlan((Seq<Attribute>)x$1, x$2, (AttributeMap<ColumnStat>)x$4, (Option<BigInt>)x$3);
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CBO_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Alias[] aliasArray = new Alias[1];
                Count x$5 = Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)));
                String x$6 = "cnt";
                ExprId x$7 = Alias$.MODULE$.apply$default$3((Expression)x$5, x$6);
                Seq x$8 = Alias$.MODULE$.apply$default$4((Expression)x$5, x$6);
                Option x$9 = Alias$.MODULE$.apply$default$5((Expression)x$5, x$6);
                aliasArray[0] = new Alias((Expression)x$5, x$6, x$7, x$8, x$9);
                Aggregate noGroupAgg = new Aggregate((Seq)Nil$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])aliasArray)), (LogicalPlan)child);
                Statistics $org_scalatest_assert_macro_left = noGroupAgg.stats();
                Statistics $org_scalatest_assert_macro_right = new Statistics(BigInt$.MODULE$.int2bigInt(16), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4());
                Statistics statistics = $org_scalatest_assert_macro_left;
                Statistics statistics2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AggregateEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
                Count x$10 = Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)));
                String x$11 = "cnt";
                ExprId x$12 = Alias$.MODULE$.apply$default$3((Expression)x$10, x$11);
                Seq x$13 = Alias$.MODULE$.apply$default$4((Expression)x$10, x$11);
                Option x$14 = Alias$.MODULE$.apply$default$5((Expression)x$10, x$11);
                Aggregate hasGroupAgg = new Aggregate(attributes, (Seq)attributes.$colon$plus((Object)new Alias((Expression)x$10, x$11, x$12, x$13, x$14), Seq$.MODULE$.canBuildFrom()), (LogicalPlan)child);
                Statistics $org_scalatest_assert_macro_left2 = hasGroupAgg.stats();
                Statistics $org_scalatest_assert_macro_right2 = new Statistics(BigInt$.MODULE$.int2bigInt(80), Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4());
                Statistics statistics3 = $org_scalatest_assert_macro_left2;
                Statistics statistics4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(statistics3 != null ? !statistics3.equals(statistics4) : statistics4 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AggregateEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            });
        }, new Position("AggregateEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
    }
}

