/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.util.NumberConverter$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a2Aa\u0001\u0003\u0001#!)a\u0003\u0001C\u0001/!1!\u0004\u0001Q\u0005\nm\u0011ACT;nE\u0016\u00148i\u001c8wKJ$XM]*vSR,'BA\u0003\u0007\u0003\u0011)H/\u001b7\u000b\u0005\u001dA\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0015\u001b\u0005Q\u0011BA\u000b\u000b\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012\u0001\u0007\t\u00033\u0001i\u0011\u0001B\u0001\nG\",7m[\"p]Z$R\u0001\b\u00120iY\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011A!\u00168ji\")1E\u0001a\u0001I\u0005\ta\u000e\u0005\u0002&Y9\u0011aE\u000b\t\u0003Oyi\u0011\u0001\u000b\u0006\u0003SA\ta\u0001\u0010:p_Rt\u0014BA\u0016\u001f\u0003\u0019\u0001&/\u001a3fM&\u0011QF\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-r\u0002\"\u0002\u0019\u0003\u0001\u0004\t\u0014\u0001\u00034s_6\u0014\u0015m]3\u0011\u0005u\u0011\u0014BA\u001a\u001f\u0005\rIe\u000e\u001e\u0005\u0006k\t\u0001\r!M\u0001\u0007i>\u0014\u0015m]3\t\u000b]\u0012\u0001\u0019\u0001\u0013\u0002\u0011\u0015D\b/Z2uK\u0012\u0004")
public class NumberConverterSuite
extends SparkFunSuite {
    private void checkConv(String n, int fromBase, int toBase, String expected) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(NumberConverter$.MODULE$.convert(UTF8String.fromString((String)n).getBytes(), fromBase, toBase));
        UTF8String $org_scalatest_assert_macro_right = UTF8String.fromString((String)expected);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
    }

    public NumberConverterSuite() {
        this.test("convert", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            this.checkConv("3", 10, 2, "11");
            this.checkConv("-15", 10, -16, "-F");
            this.checkConv("-15", 10, 16, "FFFFFFFFFFFFFFF1");
            this.checkConv("big", 36, 16, "3A48");
            this.checkConv("9223372036854775807", 36, 16, "FFFFFFFFFFFFFFFF");
            this.checkConv("11abc", 10, 16, "B");
        }, new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
    }
}

