/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.util.UUID;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.util.RandomUUIDGenerator;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001e1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\tA\"+\u00198e_6,V+\u0013#HK:,'/\u0019;peN+\u0018\u000e^3\u000b\u0005\u0011)\u0011\u0001B;uS2T!AB\u0004\u0002\u0011\r\fG/\u00197zgRT!\u0001C\u0005\u0002\u0007M\fHN\u0003\u0002\u000b\u0017\u0005)1\u000f]1sW*\u0011A\"D\u0001\u0007CB\f7\r[3\u000b\u00039\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I\u0019R\"A\u0005\n\u0005QI!!D*qCJ\\g)\u001e8Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u0007\u0001")
public class RandomUUIDGeneratorSuite
extends SparkFunSuite {
    public static final /* synthetic */ Assertion $anonfun$new$2(RandomUUIDGeneratorSuite $this, RandomUUIDGenerator generator$1, int _) {
        UUID uuid = generator$1.getNextUUID();
        int $org_scalatest_assert_macro_left = uuid.version();
        int $org_scalatest_assert_macro_right = 4;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomUUIDGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        int $org_scalatest_assert_macro_left2 = uuid.variant();
        int $org_scalatest_assert_macro_right2 = 2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomUUIDGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
    }

    public static final /* synthetic */ Assertion $anonfun$new$4(RandomUUIDGeneratorSuite $this, RandomUUIDGenerator generator1$1, RandomUUIDGenerator generator2$1, RandomUUIDGenerator generator3$1, int _) {
        UUID uuid1 = generator1$1.getNextUUID();
        UUID uuid2 = generator2$1.getNextUUID();
        UUID uuid3 = generator3$1.getNextUUID();
        UUID $org_scalatest_assert_macro_left = uuid1;
        UUID $org_scalatest_assert_macro_right = uuid2;
        UUID uUID = $org_scalatest_assert_macro_left;
        UUID uUID2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomUUIDGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        UUID $org_scalatest_assert_macro_left2 = uuid1;
        UUID $org_scalatest_assert_macro_right2 = uuid3;
        UUID uUID3 = $org_scalatest_assert_macro_left2;
        UUID uUID4 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", (Object)$org_scalatest_assert_macro_right2, uUID3 == null ? uUID4 != null : !((Object)uUID3).equals(uUID4), Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomUUIDGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
    }

    public RandomUUIDGeneratorSuite() {
        this.test("RandomUUIDGenerator should generate version 4, variant 2 UUIDs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            RandomUUIDGenerator generator = new RandomUUIDGenerator(new Random().nextLong());
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & java.io.Serializable & Serializable)_ -> RandomUUIDGeneratorSuite.$anonfun$new$2(this, generator, BoxesRunTime.unboxToInt((Object)_)));
        }, new Position("RandomUUIDGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 25));
        this.test("UUID from RandomUUIDGenerator should be deterministic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            Random r1 = new Random(100);
            RandomUUIDGenerator generator1 = new RandomUUIDGenerator(r1.nextLong());
            Random r2 = new Random(100);
            RandomUUIDGenerator generator2 = new RandomUUIDGenerator(r2.nextLong());
            Random r3 = new Random(101);
            RandomUUIDGenerator generator3 = new RandomUUIDGenerator(r3.nextLong());
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & java.io.Serializable & Serializable)_ -> RandomUUIDGeneratorSuite.$anonfun$new$4(this, generator1, generator2, generator3, BoxesRunTime.unboxToInt((Object)_)));
        }, new Position("RandomUUIDGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        this.test("Get UTF8String UUID", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            Bool bool;
            Bool bool2;
            RandomUUIDGenerator generator = new RandomUUIDGenerator(new Random().nextLong());
            UTF8String utf8StringUUID = generator.getNextUUIDUTF8String();
            UUID uuid = UUID.fromString(utf8StringUUID.toString());
            int $org_scalatest_assert_macro_left = uuid.version();
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                int $org_scalatest_assert_macro_left3 = uuid.variant();
                int $org_scalatest_assert_macro_right2 = 2;
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            } else {
                bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool2;
            Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left4.value()) {
                String $org_scalatest_assert_macro_left5 = utf8StringUUID.toString();
                String $org_scalatest_assert_macro_right4 = uuid.toString();
                String string = $org_scalatest_assert_macro_left5;
                String string2 = $org_scalatest_assert_macro_right4;
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right5 = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left4.$amp$amp($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomUUIDGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        }, new Position("RandomUUIDGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
    }
}

