/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import java.math.BigInteger;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.PrivateMethodTester;
import org.scalatest.PrivateMethodTester$PrivateMethod$;
import org.scalatest.Tag;
import scala.Double$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.Statics;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001i3AAB\u0004\u0001%!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C\u0005E!9!\t\u0001b\u0001\n\u0013\u0019\u0005BB)\u0001A\u0003%A\tC\u0003S\u0001\u0011%1K\u0001\u0007EK\u000eLW.\u00197Tk&$XM\u0003\u0002\t\u0013\u0005)A/\u001f9fg*\u0011!bC\u0001\u0004gFd'B\u0001\u0007\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aE\f\u0011\u0005Q)R\"A\u0006\n\u0005YY!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\u001f\u0005I1oY1mCR,7\u000f^\u0005\u00039e\u00111\u0003\u0015:jm\u0006$X-T3uQ>$G+Z:uKJ\fa\u0001P5oSRtD#A\u0010\u0011\u0005\u0001\u0002Q\"A\u0004\u0002\u0019\rDWmY6EK\u000eLW.\u00197\u0015\u000b\rJcf\u000f!\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006U\t\u0001\raK\u0001\u0002IB\u0011\u0001\u0005L\u0005\u0003[\u001d\u0011q\u0001R3dS6\fG\u000eC\u00030\u0005\u0001\u0007\u0001'\u0001\u0004tiJLgn\u001a\t\u0003car!A\r\u001c\u0011\u0005M*S\"\u0001\u001b\u000b\u0005U\n\u0012A\u0002\u001fs_>$h(\u0003\u00028K\u00051\u0001K]3eK\u001aL!!\u000f\u001e\u0003\rM#(/\u001b8h\u0015\t9T\u0005C\u0003=\u0005\u0001\u0007Q(A\u0005qe\u0016\u001c\u0017n]5p]B\u0011AEP\u0005\u0003\u007f\u0015\u00121!\u00138u\u0011\u0015\t%\u00011\u0001>\u0003\u0015\u00198-\u00197f\u0003)!WmY5nC24\u0016\r\\\u000b\u0002\tB\u0019QI\u0012%\u000e\u0003\u0001I!aR\u000e\u0003\u001bA\u0013\u0018N^1uK6+G\u000f[8e!\tIeJ\u0004\u0002K\u0019:\u00111gS\u0005\u0002M%\u0011Q*J\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0005K\u0001\u0006CS\u001e$UmY5nC2T!!T\u0013\u0002\u0017\u0011,7-[7bYZ\u000bG\u000eI\u0001\rG\",7m[\"p[B\f7\r\u001e\u000b\u0004GQ+\u0006\"\u0002\u0016\u0006\u0001\u0004Y\u0003\"\u0002,\u0006\u0001\u00049\u0016\u0001C3ya\u0016\u001cG/\u001a3\u0011\u0005\u0011B\u0016BA-&\u0005\u001d\u0011un\u001c7fC:\u0004")
public class DecimalSuite
extends SparkFunSuite
implements PrivateMethodTester {
    private final PrivateMethodTester.PrivateMethod<BigDecimal> decimalVal;
    private volatile PrivateMethodTester$PrivateMethod$ PrivateMethod$module;

    public PrivateMethodTester.Invoker anyRefToInvoker(Object target) {
        return PrivateMethodTester.anyRefToInvoker$((PrivateMethodTester)this, (Object)target);
    }

    public PrivateMethodTester$PrivateMethod$ PrivateMethod() {
        if (this.PrivateMethod$module == null) {
            this.PrivateMethod$lzycompute$1();
        }
        return this.PrivateMethod$module;
    }

    private void checkDecimal(Decimal d, String string, int precision, int scale) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(d.toString());
        String $org_scalatest_assert_macro_right = string;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)d.precision()));
        int $org_scalatest_assert_macro_right2 = precision;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)d.scale()));
        int $org_scalatest_assert_macro_right3 = scale;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
    }

    private PrivateMethodTester.PrivateMethod<BigDecimal> decimalVal() {
        return this.decimalVal;
    }

    private void checkCompact(Decimal d, boolean expected) {
        boolean isCompact;
        boolean $org_scalatest_assert_macro_left = isCompact = this.anyRefToInvoker(d).invokePrivate(this.decimalVal().apply((Seq)Nil$.MODULE$)) == null;
        boolean $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(9).append(d).append(" ").append((Object)(expected ? "was not" : "was")).append(" compact").toString(), Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
    }

    private final void PrivateMethod$lzycompute$1() {
        DecimalSuite decimalSuite = this;
        synchronized (decimalSuite) {
            if (this.PrivateMethod$module == null) {
                this.PrivateMethod$module = new PrivateMethodTester$PrivateMethod$((PrivateMethodTester)this);
            }
        }
    }

    private final void checkValues$1(Decimal d, double doubleValue, long longValue) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)d.toDouble()));
        double $org_scalatest_assert_macro_right = doubleValue;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)d.toLong()));
        long $org_scalatest_assert_macro_right2 = longValue;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
    }

    public static final /* synthetic */ void $anonfun$new$20(DecimalSuite $this, Enumeration.Value mode$1, String n) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-"}))).foreach((Function1 & Serializable & scala.Serializable)sign -> {
            BigDecimal bd = package$.MODULE$.BigDecimal().apply(new StringBuilder(0).append((String)sign).append(n).toString());
            long unscaled = bd.$times(BigDecimal$.MODULE$.int2bigDecimal(10)).toLongExact();
            Decimal d = Decimal$.MODULE$.apply(unscaled, 8, 1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(d.changePrecision(10, 0, mode$1), "d.changePrecision(10, 0, mode)", Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(d.toString());
            String $org_scalatest_assert_macro_right = bd.setScale(0, mode$1).toString();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(13).append("num: ").append((String)sign).append(n).append(", mode: ").append(mode$1).toString(), Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            Decimal copy = d.toPrecision(10, 0, mode$1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(copy);
            Null$ $org_scalatest_assert_macro_right2 = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!==", null, $org_scalatest_assert_macro_left2.$bang$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
            Decimal $org_scalatest_assert_macro_left3 = d;
            Decimal $org_scalatest_assert_macro_right3 = copy;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "ne", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 != $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(d);
            Decimal $org_scalatest_assert_macro_right4 = copy;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(copy.toString());
            String $org_scalatest_assert_macro_right5 = bd.setScale(0, mode$1).toString();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)new StringBuilder(13).append("num: ").append((String)sign).append(n).append(", mode: ").append(mode$1).toString(), Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        });
    }

    public static final /* synthetic */ void $anonfun$new$19(DecimalSuite $this, Enumeration.Value mode) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0.4", "0.5", "0.6", "1.0", "1.1", "1.6", "2.5", "5.5"}))).foreach((Function1 & Serializable & scala.Serializable)n -> {
            DecimalSuite.$anonfun$new$20($this, mode, n);
            return BoxedUnit.UNIT;
        });
    }

    public DecimalSuite() {
        PrivateMethodTester.$init$((PrivateMethodTester)this);
        this.test("creating decimals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.checkDecimal(new Decimal(), "0", 1, 0);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("0.09")), "0.09", 3, 2);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("0.9")), "0.9", 2, 1);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("0.90")), "0.90", 3, 2);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("0.0")), "0.0", 2, 1);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("0")), "0", 1, 0);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("1.0")), "1.0", 2, 1);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-0.09")), "-0.09", 3, 2);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-0.9")), "-0.9", 2, 1);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-0.90")), "-0.90", 3, 2);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-1.0")), "-1.0", 2, 1);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("10.030")), "10.030", 5, 3);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("10.030"), 4, 1), "10.0", 4, 1);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-9.95"), 4, 1), "-10.0", 4, 1);
            this.checkDecimal(Decimal$.MODULE$.apply("10.030"), "10.030", 5, 3);
            this.checkDecimal(Decimal$.MODULE$.apply(10.03), "10.03", 4, 2);
            this.checkDecimal(Decimal$.MODULE$.apply(17L), "17", 20, 0);
            this.checkDecimal(Decimal$.MODULE$.apply(17), "17", 10, 0);
            this.checkDecimal(Decimal$.MODULE$.apply(17L, 2, 1), "1.7", 2, 1);
            this.checkDecimal(Decimal$.MODULE$.apply(170L, 4, 2), "1.70", 4, 2);
            this.checkDecimal(Decimal$.MODULE$.apply(17L, 24, 1), "1.7", 24, 1);
            this.checkDecimal(Decimal$.MODULE$.apply((long)1.0E17, 18, 0), ((Object)BoxesRunTime.boxToLong((long)((long)1.0E17))).toString(), 18, 0);
            this.checkDecimal(Decimal$.MODULE$.apply(1000000000000000000L, 20, 2), "10000000000000000.00", 20, 2);
            this.checkDecimal(Decimal$.MODULE$.apply(Long.MAX_VALUE), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString(), 20, 0);
            this.checkDecimal(Decimal$.MODULE$.apply(Long.MIN_VALUE), ((Object)BoxesRunTime.boxToLong((long)Long.MIN_VALUE)).toString(), 20, 0);
            this.intercept((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.apply(170L, 2, 1), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.apply(170L, 2, 0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("10.030"), 2, 1), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-9.95"), 2, 1), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.apply((long)1.0E17, 17, 0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        this.test("creating decimals with negative scale", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("98765"), 5, -3), "9.9E+4", 5, -3);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("314.159"), 6, -2), "3E+2", 6, -2);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(1.579E12), 4, -9), "1.579E+12", 4, -9);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(1.579E12), 4, -10), "1.58E+12", 4, -10);
            this.checkDecimal(Decimal$.MODULE$.apply(103050709L, 9, -10), "1.03050709E+18", 9, -10);
            this.checkDecimal(Decimal$.MODULE$.apply((long)1.0E8, 10, -10), "1.00000000E+18", 10, -10);
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("double and long values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkValues$1(new Decimal(), 0.0, 0L);
            this.checkValues$1(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("10.030")), 10.03, 10L);
            this.checkValues$1(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("10.030"), 4, 1), 10.0, 10L);
            this.checkValues$1(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-9.95"), 4, 1), -10.0, -10L);
            this.checkValues$1(Decimal$.MODULE$.apply(10.03), 10.03, 10L);
            this.checkValues$1(Decimal$.MODULE$.apply(17L), 17.0, 17L);
            this.checkValues$1(Decimal$.MODULE$.apply(17), 17.0, 17L);
            this.checkValues$1(Decimal$.MODULE$.apply(17L, 2, 1), 1.7, 1L);
            this.checkValues$1(Decimal$.MODULE$.apply(170L, 4, 2), 1.7, 1L);
            this.checkValues$1(Decimal$.MODULE$.apply((long)1.0E16), 1.0E16, (long)1.0E16);
            this.checkValues$1(Decimal$.MODULE$.apply((long)1.0E17), 1.0E17, (long)1.0E17);
            this.checkValues$1(Decimal$.MODULE$.apply((long)1.0E18), 1.0E18, (long)1.0E18);
            this.checkValues$1(Decimal$.MODULE$.apply((long)2.0E18), 2.0E18, (long)2.0E18);
            this.checkValues$1(Decimal$.MODULE$.apply(Long.MAX_VALUE), Long.MAX_VALUE, Long.MAX_VALUE);
            this.checkValues$1(Decimal$.MODULE$.apply(Long.MIN_VALUE), Long.MIN_VALUE, Long.MIN_VALUE);
            this.checkValues$1(Decimal$.MODULE$.apply(Double.MAX_VALUE), Double.MAX_VALUE, 0L);
            this.checkValues$1(Decimal$.MODULE$.apply(Double$.MODULE$.MinValue()), Double$.MODULE$.MinValue(), 0L);
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.decimalVal = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "decimalVal"));
        this.test("small decimals represented as unscaled long", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkCompact(new Decimal(), true);
            this.checkCompact(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("10.03")), false);
            this.checkCompact(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("100000000000000000000")), false);
            this.checkCompact(Decimal$.MODULE$.apply(17L), true);
            this.checkCompact(Decimal$.MODULE$.apply(17), true);
            this.checkCompact(Decimal$.MODULE$.apply(17L, 2, 1), true);
            this.checkCompact(Decimal$.MODULE$.apply(170L, 4, 2), true);
            this.checkCompact(Decimal$.MODULE$.apply(17L, 24, 1), true);
            this.checkCompact(Decimal$.MODULE$.apply((long)1.0E16), true);
            this.checkCompact(Decimal$.MODULE$.apply((long)1.0E17), true);
            this.checkCompact(Decimal$.MODULE$.apply((long)1.0E18 - 1L), true);
            this.checkCompact(Decimal$.MODULE$.apply((long)-1.0E18 + 1L), true);
            this.checkCompact(Decimal$.MODULE$.apply((long)1.0E18 - 1L, 30, 10), true);
            this.checkCompact(Decimal$.MODULE$.apply((long)-1.0E18 + 1L, 30, 10), true);
            this.checkCompact(Decimal$.MODULE$.apply((long)1.0E18), false);
            this.checkCompact(Decimal$.MODULE$.apply((long)-1.0E18), false);
            this.checkCompact(Decimal$.MODULE$.apply((long)1.0E18, 30, 10), false);
            this.checkCompact(Decimal$.MODULE$.apply((long)-1.0E18, 30, 10), false);
            this.checkCompact(Decimal$.MODULE$.apply(Long.MAX_VALUE), false);
            this.checkCompact(Decimal$.MODULE$.apply(Long.MIN_VALUE), false);
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("hash code", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Decimal$.MODULE$.apply(123).hashCode()));
            int $org_scalatest_assert_macro_right = 123;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Decimal$.MODULE$.apply(-123).hashCode()));
            int $org_scalatest_assert_macro_right2 = -123;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Decimal$.MODULE$.apply(Integer.MAX_VALUE).hashCode()));
            int $org_scalatest_assert_macro_right3 = Integer.MAX_VALUE;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Decimal$.MODULE$.apply(Long.MAX_VALUE).hashCode()));
            int $org_scalatest_assert_macro_right4 = Statics.longHash((long)Long.MAX_VALUE);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(123)).hashCode()));
            int $org_scalatest_assert_macro_right5 = 123;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            BigDecimal reallyBig = package$.MODULE$.BigDecimal().apply("123182312312313232112312312123.1231231231");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Decimal$.MODULE$.apply(reallyBig).hashCode()));
            int $org_scalatest_assert_macro_right6 = reallyBig.hashCode();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("equals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.checkCompact(Decimal$.MODULE$.apply(123), true);
            this.checkCompact(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(123)), false);
            this.checkCompact(Decimal$.MODULE$.apply("123"), false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Decimal$.MODULE$.apply(123));
            Decimal $org_scalatest_assert_macro_right = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(123));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Decimal$.MODULE$.apply(123));
            Decimal $org_scalatest_assert_macro_right2 = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("123.00"));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(Decimal$.MODULE$.apply(-123));
            Decimal $org_scalatest_assert_macro_right3 = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(-123));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(Decimal$.MODULE$.apply(-123));
            Decimal $org_scalatest_assert_macro_right4 = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-123.00"));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("isZero", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply(0).isZero(), "Decimal.apply(0).isZero", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply(0L, 4, 2).isZero(), "Decimal.apply(0L, 4, 2).isZero", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply("0").isZero(), "Decimal.apply(\"0\").isZero", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply("0.000").isZero(), "Decimal.apply(\"0.000\").isZero", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply(1).isZero(), "Decimal.apply(1).isZero", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply(1L, 4, 2).isZero(), "Decimal.apply(1L, 4, 2).isZero", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply("1").isZero(), "Decimal.apply(\"1\").isZero", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply("0.001").isZero(), "Decimal.apply(\"0.001\").isZero", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("arithmetic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Decimal$.MODULE$.apply(100).$plus(Decimal$.MODULE$.apply(-100)));
            Decimal $org_scalatest_assert_macro_right = Decimal$.MODULE$.apply(0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Decimal$.MODULE$.apply(100).$plus(Decimal$.MODULE$.apply(-100)));
            Decimal $org_scalatest_assert_macro_right2 = Decimal$.MODULE$.apply(0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(Decimal$.MODULE$.apply(100).$times(Decimal$.MODULE$.apply(-100)));
            Decimal $org_scalatest_assert_macro_right3 = Decimal$.MODULE$.apply(-10000);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(Decimal$.MODULE$.apply(1.0E13).$times(Decimal$.MODULE$.apply(1.0E13)));
            Decimal $org_scalatest_assert_macro_right4 = Decimal$.MODULE$.apply(1.0E26);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(Decimal$.MODULE$.apply(100).$div(Decimal$.MODULE$.apply(-100)));
            Decimal $org_scalatest_assert_macro_right5 = Decimal$.MODULE$.apply(-1);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(Decimal$.MODULE$.apply(100).$div(Decimal$.MODULE$.apply(0)));
            Null$ $org_scalatest_assert_macro_right6 = null;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", null, $org_scalatest_assert_macro_left6.$eq$eq$eq($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(Decimal$.MODULE$.apply(100).$percent(Decimal$.MODULE$.apply(-100)));
            Decimal $org_scalatest_assert_macro_right7 = Decimal$.MODULE$.apply(0);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(Decimal$.MODULE$.apply(100).$percent(Decimal$.MODULE$.apply(3)));
            Decimal $org_scalatest_assert_macro_right8 = Decimal$.MODULE$.apply(1);
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(Decimal$.MODULE$.apply(-100).$percent(Decimal$.MODULE$.apply(3)));
            Decimal $org_scalatest_assert_macro_right9 = Decimal$.MODULE$.apply(-1);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(Decimal$.MODULE$.apply(100).$percent(Decimal$.MODULE$.apply(0)));
            Null$ $org_scalatest_assert_macro_right10 = null;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", null, $org_scalatest_assert_macro_left10.$eq$eq$eq($org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        this.test("accurate precision after multiplication", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            java.math.BigDecimal decimal = Decimal$.MODULE$.apply(Long.MAX_VALUE, 38, 0).$times(Decimal$.MODULE$.apply(Long.MAX_VALUE, 38, 0)).toJavaBigDecimal();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(decimal.unscaledValue().toString());
            String $org_scalatest_assert_macro_right = "85070591730234615847396907784232501249";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        this.test("fix non-terminating decimal expansion problem", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Decimal decimal = Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(1.0), 10, 3).$div(Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(3.0), 10, 3));
            double $org_scalatest_assert_macro_left = decimal.toDouble() - 0.333;
            double $org_scalatest_assert_macro_right = 0.001;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        this.test("fix loss of precision/scale when doing division operation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool bool;
            Decimal a = Decimal$.MODULE$.apply(2).$div(Decimal$.MODULE$.apply(3));
            double $org_scalatest_assert_macro_left = a.toDouble();
            double $org_scalatest_assert_macro_right = 1.0;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                double $org_scalatest_assert_macro_left3 = a.toDouble();
                double $org_scalatest_assert_macro_right2 = 0.6;
                bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            Decimal b = Decimal$.MODULE$.apply(1).$div(Decimal$.MODULE$.apply(8));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)b.toDouble()));
            double $org_scalatest_assert_macro_right4 = 0.125;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        this.test("set/setOrNull", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)new Decimal().set(10L, 10, 0).toUnscaledLong()));
            long $org_scalatest_assert_macro_right = 10L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)new Decimal().set(100L, 10, 0).toUnscaledLong()));
            long $org_scalatest_assert_macro_right2 = 100L;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)Decimal$.MODULE$.apply(Long.MAX_VALUE, 100, 0).toUnscaledLong()));
            long $org_scalatest_assert_macro_right3 = Long.MAX_VALUE;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        this.test("changePrecision/toPrecision on compact decimal should respect rounding mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{Decimal$.MODULE$.ROUND_FLOOR(), Decimal$.MODULE$.ROUND_CEILING(), Decimal$.MODULE$.ROUND_HALF_UP(), Decimal$.MODULE$.ROUND_HALF_EVEN()}))).foreach((Function1 & Serializable & scala.Serializable)mode -> {
            DecimalSuite.$anonfun$new$19(this, mode);
            return BoxedUnit.UNIT;
        }), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        this.test("SPARK-20341: support BigInt's value does not fit in long value range", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BigInt bigInt = BigInt$.MODULE$.apply("9223372036854775808");
            Decimal decimal = Decimal$.MODULE$.apply(bigInt);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(decimal.toJavaBigDecimal().unscaledValue().toString());
            String $org_scalatest_assert_macro_right = "9223372036854775808";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        this.test("SPARK-26038: toScalaBigInt/toJavaBigInteger", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Decimal decimal = Decimal$.MODULE$.apply("1234568790123456789012348790.1234879012345678901234568790");
            BigInt $org_scalatest_assert_macro_left = decimal.toScalaBigInt();
            BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.apply("1234568790123456789012348790");
            BigInt bigInt = $org_scalatest_assert_macro_left;
            BigInt bigInt2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
            BigInteger $org_scalatest_assert_macro_left2 = decimal.toJavaBigInteger();
            BigInteger $org_scalatest_assert_macro_right2 = new BigInteger("1234568790123456789012348790");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, BoxesRunTime.equalsNumNum((Number)$org_scalatest_assert_macro_left2, (Number)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
            Decimal decimalLong = Decimal$.MODULE$.apply(123456789123456789L, 18, 9);
            BigInt $org_scalatest_assert_macro_left3 = decimalLong.toScalaBigInt();
            BigInt $org_scalatest_assert_macro_right3 = BigInt$.MODULE$.apply("123456789");
            BigInt bigInt3 = $org_scalatest_assert_macro_left3;
            BigInt bigInt4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(bigInt3 != null ? !bigInt3.equals(bigInt4) : bigInt4 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
            BigInteger $org_scalatest_assert_macro_left4 = decimalLong.toJavaBigInteger();
            BigInteger $org_scalatest_assert_macro_right4 = new BigInteger("123456789");
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, BoxesRunTime.equalsNumNum((Number)$org_scalatest_assert_macro_left4, (Number)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
    }
}

