/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001}1AAA\u0002\u0001\u001d!)1\u0004\u0001C\u00019\t9B+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s'VLG/\u001a\u0006\u0003\t\u0015\tA!\u001e;jY*\u0011aaB\u0001\u0004gFd'B\u0001\u0005\n\u0003\u0015\u0019\b/\u0019:l\u0015\tQ1\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0019\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aD\n\u0011\u0005A\tR\"A\u0004\n\u0005I9!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001535\tQC\u0003\u0002\u0017/\u0005)\u0001\u000f\\1og*\u0011\u0001$B\u0001\tG\u0006$\u0018\r\\=ti&\u0011!$\u0006\u0002\n'Fc\u0005*\u001a7qKJ\fa\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"A\u0002")
public class TimestampFormatterSuite
extends SparkFunSuite
implements SQLHelper {
    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    public static final /* synthetic */ void $anonfun$new$6(TimestampFormatterSuite $this, String pattern) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{-58710115316212000L, -18926315945345679L, -9463427405253013L, -244000001L, 0L, 99628200102030L, 1543749753123456L, 2177456523456789L, 11858049903010203L}))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)micros -> DateTimeTestUtils$.MODULE$.outstandingTimezones().foreach((Function1 & Serializable & scala.Serializable)timeZone -> {
            TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply(pattern, timeZone);
            String timestamp = formatter.format(micros);
            long parsed = formatter.parse(timestamp);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)micros));
            long $org_scalatest_assert_macro_right = parsed;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        }));
    }

    public static final /* synthetic */ void $anonfun$new$10(TimestampFormatterSuite $this, String timestamp) {
        DateTimeTestUtils$.MODULE$.outstandingTimezones().foreach((Function1 & Serializable & scala.Serializable)timeZone -> {
            TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply("yyyy-MM-dd'T'HH:mm:ss.SSSSSS", timeZone);
            long micros = formatter.parse(timestamp);
            String formatted = formatter.format(micros);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(timestamp);
            String $org_scalatest_assert_macro_right = formatted;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        });
    }

    public TimestampFormatterSuite() {
        SQLHelper.$init$(this);
        this.test("parsing timestamps using time zones", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String localDate = "2018-12-02T10:11:12.001234";
            Map expectedMicros = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"UTC"), (Object)BoxesRunTime.boxToLong((long)1543745472001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PST"), (Object)BoxesRunTime.boxToLong((long)1543774272001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CET"), (Object)BoxesRunTime.boxToLong((long)1543741872001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Africa/Dakar"), (Object)BoxesRunTime.boxToLong((long)1543745472001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"America/Los_Angeles"), (Object)BoxesRunTime.boxToLong((long)1543774272001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Antarctica/Vostok"), (Object)BoxesRunTime.boxToLong((long)1543723872001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Asia/Hong_Kong"), (Object)BoxesRunTime.boxToLong((long)1543716672001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Europe/Amsterdam"), (Object)BoxesRunTime.boxToLong((long)1543741872001234L))}));
            DateTimeTestUtils$.MODULE$.outstandingTimezonesIds().foreach((Function1 & Serializable & scala.Serializable)timeZone -> {
                TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply("yyyy-MM-dd'T'HH:mm:ss.SSSSSS", TimeZone.getTimeZone(timeZone));
                long microsSinceEpoch = formatter.parse(localDate);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)microsSinceEpoch));
                long $org_scalatest_assert_macro_right = BoxesRunTime.unboxToLong((Object)expectedMicros.apply(timeZone));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            });
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("format timestamps using time zones", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long microsSinceEpoch = 1543745472001234L;
            Map expectedTimestamp = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"UTC"), (Object)"2018-12-02T10:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PST"), (Object)"2018-12-02T02:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CET"), (Object)"2018-12-02T11:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Africa/Dakar"), (Object)"2018-12-02T10:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"America/Los_Angeles"), (Object)"2018-12-02T02:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Antarctica/Vostok"), (Object)"2018-12-02T16:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Asia/Hong_Kong"), (Object)"2018-12-02T18:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Europe/Amsterdam"), (Object)"2018-12-02T11:11:12.001234")}));
            DateTimeTestUtils$.MODULE$.outstandingTimezonesIds().foreach((Function1 & Serializable & scala.Serializable)timeZone -> {
                TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply("yyyy-MM-dd'T'HH:mm:ss.SSSSSS", TimeZone.getTimeZone(timeZone));
                String timestamp = formatter.format(microsSinceEpoch);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(timestamp);
                String $org_scalatest_assert_macro_right = (String)expectedTimestamp.apply(timeZone);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            });
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("roundtrip micros -> timestamp -> micros using timezones", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSSSS", "yyyy-MM-dd'T'HH:mm:ss.SSSSSSXXXXX"}))).foreach((Function1 & Serializable & scala.Serializable)pattern -> {
            TimestampFormatterSuite.$anonfun$new$6(this, pattern);
            return BoxedUnit.UNIT;
        }), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("roundtrip timestamp -> micros -> timestamp using timezones", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0109-07-20T18:38:03.788000", "1370-04-01T10:00:54.654321", "1670-02-11T14:09:54.746987", "1969-12-31T23:55:55.999999", "1970-01-01T00:00:00.000000", "1973-02-27T02:30:00.102030", "2018-12-02T11:22:33.123456", "2039-01-01T01:02:03.456789", "2345-10-07T22:45:03.010203"}))).foreach((Function1 & Serializable & scala.Serializable)timestamp -> {
            TimestampFormatterSuite.$anonfun$new$10(this, timestamp);
            return BoxedUnit.UNIT;
        }), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test(" case insensitive parsing of am and pm", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply("yyyy MMM dd hh:mm:ss a", TimeZone.getTimeZone("UTC"));
            long micros = formatter.parse("2009 Mar 20 11:30:01 am");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)micros));
            long $org_scalatest_assert_macro_right = TimeUnit.SECONDS.toMicros(LocalDateTime.of(2009, 3, 20, 11, 30, 1).toEpochSecond(ZoneOffset.UTC));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
    }
}

