/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayJoin$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.expressions.codegen.UTF8StringBuilder;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array, delimiter[, nullReplacement]) - Concatenates the elements of the given array\n      using the delimiter and an optional string to replace nulls. If no value is set for\n      nullReplacement, any null value is filtered.", examples="\n    Examples:\n      > SELECT _FUNC_(array('hello', 'world'), ' ');\n       hello world\n      > SELECT _FUNC_(array('hello', null ,'world'), ' ');\n       hello world\n      > SELECT _FUNC_(array('hello', null ,'world'), ' ', ',');\n       hello , world\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\tUa\u0001\u0002\u0013&\u0001JB\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005g!Aa\t\u0001BK\u0002\u0013\u0005A\t\u0003\u0005H\u0001\tE\t\u0015!\u00034\u0011!A\u0005A!f\u0001\n\u0003I\u0005\u0002C'\u0001\u0005#\u0005\u000b\u0011\u0002&\t\u000b9\u0003A\u0011A(\t\u000b9\u0003A\u0011\u0001+\t\u000b9\u0003A\u0011A,\t\u000bm\u0003A\u0011\t/\t\u000b=\u0004A\u0011\t9\t\u000bI\u0004A\u0011I:\t\u000b]\u0004A\u0011I:\t\u000ba\u0004A\u0011I=\t\u000f\u0005\u001d\u0001\u0001\"\u0015\u0002\n!9\u0011Q\u0005\u0001\u0005\n\u0005\u001d\u0002bBA$\u0001\u0011\u0005\u0013\u0011\n\u0005\b\u0003#\u0002A\u0011IA*\u0011%\t)\u0006AA\u0001\n\u0003\t9\u0006C\u0005\u0002`\u0001\t\n\u0011\"\u0001\u0002b!I\u0011q\u000f\u0001\u0012\u0002\u0013\u0005\u0011\u0011\r\u0005\n\u0003s\u0002\u0011\u0013!C\u0001\u0003wB\u0011\"a \u0001\u0003\u0003%\t%!!\t\u0013\u0005E\u0005!!A\u0005\u0002\u0005M\u0005\"CAN\u0001\u0005\u0005I\u0011AAO\u0011%\t\u0019\u000bAA\u0001\n\u0003\n)\u000bC\u0005\u00024\u0002\t\t\u0011\"\u0001\u00026\"I\u0011\u0011\u0018\u0001\u0002\u0002\u0013\u0005\u00131X\u0004\n\u00033,\u0013\u0011!E\u0001\u000374\u0001\u0002J\u0013\u0002\u0002#\u0005\u0011Q\u001c\u0005\u0007\u001dz!\t!a;\t\u0013\u00055h$!A\u0005F\u0005=\b\"CAy=\u0005\u0005I\u0011QAz\u0011%\tYPHA\u0001\n\u0003\u000bi\u0010C\u0005\u0003\fy\t\t\u0011\"\u0003\u0003\u000e\tI\u0011I\u001d:bs*{\u0017N\u001c\u0006\u0003M\u001d\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001&K\u0001\tG\u0006$\u0018\r\\=ti*\u0011!fK\u0001\u0004gFd'B\u0001\u0017.\u0003\u0015\u0019\b/\u0019:l\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\u0004\u0001M)\u0001aM\u001c;\u0001B\u0011A'N\u0007\u0002K%\u0011a'\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001b9\u0013\tITEA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002<\u0003&\u0011!\t\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006CJ\u0014\u0018-_\u000b\u0002g\u00051\u0011M\u001d:bs\u0002\n\u0011\u0002Z3mS6LG/\u001a:\u0002\u0015\u0011,G.[7ji\u0016\u0014\b%A\bok2d'+\u001a9mC\u000e,W.\u001a8u+\u0005Q\u0005cA\u001eLg%\u0011A\n\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0002!9,H\u000e\u001c*fa2\f7-Z7f]R\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003Q#J\u001b\u0006C\u0001\u001b\u0001\u0011\u0015\u0019u\u00011\u00014\u0011\u00151u\u00011\u00014\u0011\u0015Au\u00011\u0001K)\r\u0001VK\u0016\u0005\u0006\u0007\"\u0001\ra\r\u0005\u0006\r\"\u0001\ra\r\u000b\u0005!bK&\fC\u0003D\u0013\u0001\u00071\u0007C\u0003G\u0013\u0001\u00071\u0007C\u0003I\u0013\u0001\u00071'\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0018\t\u0004=\u001aLgBA0e\u001d\t\u00017-D\u0001b\u0015\t\u0011\u0017'\u0001\u0004=e>|GOP\u0005\u0002{%\u0011Q\rP\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0007NA\u0002TKFT!!\u001a\u001f\u0011\u0005)lW\"A6\u000b\u00051L\u0013!\u0002;za\u0016\u001c\u0018B\u00018l\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005dQ&dGM]3o+\u0005\t\bc\u00010gg\u0005Aa.\u001e7mC\ndW-F\u0001u!\tYT/\u0003\u0002wy\t9!i\\8mK\u0006t\u0017\u0001\u00034pY\u0012\f'\r\\3\u0002\t\u00154\u0018\r\u001c\u000b\u0003uv\u0004\"aO>\n\u0005qd$aA!os\"9aP\u0004I\u0001\u0002\u0004y\u0018!B5oaV$\b\u0003BA\u0001\u0003\u0007i\u0011aJ\u0005\u0004\u0003\u000b9#aC%oi\u0016\u0014h.\u00197S_^\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005-\u0011qCA\u0011!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\tK\u000591m\u001c3fO\u0016t\u0017\u0002BA\u000b\u0003\u001f\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u00033y\u0001\u0019AA\u000e\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u001b\ti\"\u0003\u0003\u0002 \u0005=!AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003Gy\u0001\u0019AA\u0006\u0003\t)g/A\u000ehK:\u001cu\u000eZ3G_J\f%O]1z\u0003:$G)\u001a7j[&$XM\u001d\u000b\t\u0003S\tI$a\u000f\u0002>A!\u00111FA\u001a\u001d\u0011\ti#a\f\u0011\u0005\u0001d\u0014bAA\u0019y\u00051\u0001K]3eK\u001aLA!!\u000e\u00028\t11\u000b\u001e:j]\u001eT1!!\r=\u0011\u001d\tI\u0002\u0005a\u0001\u00037Aq!a\t\u0011\u0001\u0004\tY\u0001C\u0004\u0002@A\u0001\r!!\u0011\u0002\u00119,H\u000e\\#wC2\u00042bOA\"\u0003S\tI#!\u000b\u0002*%\u0019\u0011Q\t\u001f\u0003\u0013\u0019+hn\u0019;j_:\u001c\u0014\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005-\u0003c\u00016\u0002N%\u0019\u0011qJ6\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\u0002\u001d:fiRLh*Y7f+\t\tI#\u0001\u0003d_BLHc\u0002)\u0002Z\u0005m\u0013Q\f\u0005\b\u0007N\u0001\n\u00111\u00014\u0011\u001d15\u0003%AA\u0002MBq\u0001S\n\u0011\u0002\u0003\u0007!*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\r$fA\u001a\u0002f-\u0012\u0011q\r\t\u0005\u0003S\n\u0019(\u0004\u0002\u0002l)!\u0011QNA8\u0003%)hn\u00195fG.,GMC\u0002\u0002rq\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)(a\u001b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0010\u0016\u0004\u0015\u0006\u0015\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0004B!\u0011QQAH\u001b\t\t9I\u0003\u0003\u0002\n\u0006-\u0015\u0001\u00027b]\u001eT!!!$\u0002\t)\fg/Y\u0005\u0005\u0003k\t9)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0016B\u00191(a&\n\u0007\u0005eEHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002{\u0003?C\u0011\"!)\u001a\u0003\u0003\u0005\r!!&\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\u000bE\u0003\u0002*\u0006=&0\u0004\u0002\u0002,*\u0019\u0011Q\u0016\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00022\u0006-&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2\u0001^A\\\u0011!\t\tkGA\u0001\u0002\u0004Q\u0018AB3rk\u0006d7\u000fF\u0002u\u0003{C\u0001\"!)\u001d\u0003\u0003\u0005\rA\u001f\u0015\u0010\u0001\u0005\u0005\u0017qYAe\u0003\u001b\fy-a5\u0002VB\u0019A'a1\n\u0007\u0005\u0015WEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005-\u0017!!7\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006&\u0019:sCfd\u0003\u0005Z3mS6LG/\u001a:\\Y\u0001rW\u000f\u001c7SKBd\u0017mY3nK:$X,\u000b\u0011.A\r{gnY1uK:\fG/Z:!i\",\u0007%\u001a7f[\u0016tGo\u001d\u0011pM\u0002\"\b.\u001a\u0011hSZ,g\u000eI1se\u0006L(\u0002\t\u0011!A\u0001\u0002So]5oO\u0002\"\b.\u001a\u0011eK2LW.\u001b;fe\u0002\ng\u000e\u001a\u0011b]\u0002z\u0007\u000f^5p]\u0006d\u0007e\u001d;sS:<\u0007\u0005^8!e\u0016\u0004H.Y2fA9,H\u000e\\:/A%3\u0007E\\8!m\u0006dW/\u001a\u0011jg\u0002\u001aX\r\u001e\u0011g_JT\u0001\u0005\t\u0011!A\u0001rW\u000f\u001c7SKBd\u0017mY3nK:$H\u0006I1os\u0002rW\u000f\u001c7!m\u0006dW/\u001a\u0011jg\u00022\u0017\u000e\u001c;fe\u0016$g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\t.AA}\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQ\u001dBW\r\u001c7pO1\u0002se^8sY\u0012<\u0013\u0006\f\u0011(A\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t5fY2|\u0007e^8sY\u0012T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfDs\u0005[3mY><C\u0006\t8vY2\u0004CfJ<pe2$w%\u000b\u0017!O\u0001:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011iK2dw\u000eI<pe2$'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\bf\n5fY2|w\u0005\f\u0011ok2d\u0007\u0005L\u0014x_JdGmJ\u0015-A\u001d\u0002s\u0005\f\u0011(Y\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t5fY2|\u0007\u0005\f\u0011x_JdGM\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t9.A\u00033]Qr\u0003'A\u0005BeJ\f\u0017PS8j]B\u0011AGH\n\u0005=\u0005}\u0007\t\u0005\u0005\u0002b\u0006\u001d8g\r&Q\u001b\t\t\u0019OC\u0002\u0002fr\nqA];oi&lW-\u0003\u0003\u0002j\u0006\r(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011\u00111\\\u0001\ti>\u001cFO]5oOR\u0011\u00111Q\u0001\u0006CB\u0004H.\u001f\u000b\b!\u0006U\u0018q_A}\u0011\u0015\u0019\u0015\u00051\u00014\u0011\u00151\u0015\u00051\u00014\u0011\u0015A\u0015\u00051\u0001K\u0003\u001d)h.\u00199qYf$B!a@\u0003\bA!1h\u0013B\u0001!\u0019Y$1A\u001a4\u0015&\u0019!Q\u0001\u001f\u0003\rQ+\b\u000f\\34\u0011!\u0011IAIA\u0001\u0002\u0004\u0001\u0016a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011y\u0001\u0005\u0003\u0002\u0006\nE\u0011\u0002\u0002B\n\u0003\u000f\u0013aa\u00142kK\u000e$\b")
public class ArrayJoin
extends Expression
implements ExpectsInputTypes,
scala.Serializable {
    private final Expression array;
    private final Expression delimiter;
    private final Option<Expression> nullReplacement;

    public static Option<Tuple3<Expression, Expression, Option<Expression>>> unapply(ArrayJoin arrayJoin) {
        return ArrayJoin$.MODULE$.unapply(arrayJoin);
    }

    public static Function1<Tuple3<Expression, Expression, Option<Expression>>, ArrayJoin> tupled() {
        return ArrayJoin$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<Expression>, ArrayJoin>>> curried() {
        return ArrayJoin$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression array() {
        return this.array;
    }

    public Expression delimiter() {
        return this.delimiter;
    }

    public Option<Expression> nullReplacement() {
        return this.nullReplacement;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return this.nullReplacement().isDefined() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{ArrayType$.MODULE$.apply(StringType$.MODULE$), StringType$.MODULE$, StringType$.MODULE$})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{ArrayType$.MODULE$.apply(StringType$.MODULE$), StringType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        return this.nullReplacement().isDefined() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.array(), this.delimiter(), (Expression)this.nullReplacement().get()})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.array(), this.delimiter()}));
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)x$32.nullable()));
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)x$33.foldable()));
    }

    @Override
    public Object eval(InternalRow input) {
        Function1 & Serializable & scala.Serializable intersect;
        Object arrayEval = this.array().eval(input);
        if (arrayEval == null) {
            return null;
        }
        Object delimiterEval = this.delimiter().eval(input);
        if (delimiterEval == null) {
            return null;
        }
        Option nullReplacementEval = this.nullReplacement().map((Function1 & Serializable & scala.Serializable)x$34 -> x$34.eval(input));
        if (nullReplacementEval.contains(null)) {
            return null;
        }
        UTF8StringBuilder buffer = new UTF8StringBuilder();
        BooleanRef firstItem = BooleanRef.create((boolean)true);
        Option option = nullReplacementEval;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object rep = some.value();
            intersect = (Function1 & Serializable & scala.Serializable)prependDelimiter -> BoxesRunTime.boxToBoolean((boolean)ArrayJoin.$anonfun$eval$11(buffer, delimiterEval, rep, BoxesRunTime.unboxToBoolean((Object)prependDelimiter)));
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)ArrayJoin.$anonfun$eval$12(BoxesRunTime.unboxToBoolean((Object)x$35)));
        } else {
            throw new MatchError((Object)option);
        }
        Function1 & Serializable & scala.Serializable nullHandling = intersect;
        ((ArrayData)arrayEval).foreach(StringType$.MODULE$, (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$36, item) -> {
            ArrayJoin.$anonfun$eval$13(nullHandling, firstItem, buffer, delimiterEval, BoxesRunTime.unboxToInt((Object)x$36), item);
            return BoxedUnit.UNIT;
        });
        return buffer.build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String string;
        Option<Expression> option = this.nullReplacement();
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression replacement = (Expression)some.value();
            ExprCode replacementGen = replacement.genCode(ctx);
            Function3 & Serializable & scala.Serializable nullHandling = (Function3 & Serializable & scala.Serializable)(buffer, delimiter, firstItem) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(127).append("\n             |if (!").append((String)firstItem).append(") {\n             |  ").append((String)buffer).append(".append(").append((String)delimiter).append(");\n             |}\n             |").append((String)buffer).append(".append(").append(replacementGen.value()).append(");\n             |").append((String)firstItem).append(" = false;\n           ").toString())).stripMargin();
            String execCode = replacement.nullable() ? ctx.nullSafeExec(replacement.nullable(), ExprValue$.MODULE$.exprValueToString(replacementGen.isNull()), this.genCodeForArrayAndDelimiter(ctx, ev, (Function3<String, String, String, String>)nullHandling)) : this.genCodeForArrayAndDelimiter(ctx, ev, (Function3<String, String, String, String>)nullHandling);
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(36).append("\n           |").append(replacementGen.code()).append("\n           |").append(execCode).append("\n         ").toString())).stripMargin();
        } else if (None$.MODULE$.equals(option)) {
            string = this.genCodeForArrayAndDelimiter(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(x$37, x$38, x$39) -> "// nulls are ignored");
        } else {
            throw new MatchError(option);
        }
        String code = string;
        return this.nullable() ? ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean ", " = true;\n           |UTF8String ", " = null;\n           |", "\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), code})).stripMargin(), ev.copy$default$2(), ev.copy$default$3()) : ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |UTF8String ", " = null;\n           |", "\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), code})).stripMargin(), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    private String genCodeForArrayAndDelimiter(CodegenContext ctx, ExprCode ev, Function3<String, String, String, String> nullEval) {
        ExprCode arrayGen = this.array().genCode(ctx);
        ExprCode delimiterGen = this.delimiter().genCode(ctx);
        String buffer = ctx.freshName("buffer");
        String bufferClass = UTF8StringBuilder.class.getName();
        String i = ctx.freshName("i");
        String firstItem = ctx.freshName("firstItem");
        String resultCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(331).append("\n         |").append(bufferClass).append(" ").append(buffer).append(" = new ").append(bufferClass).append("();\n         |boolean ").append(firstItem).append(" = true;\n         |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(arrayGen.value()).append(".numElements(); ").append(i).append(" ++) {\n         |  if (").append(arrayGen.value()).append(".isNullAt(").append(i).append(")) {\n         |    ").append(nullEval.apply((Object)buffer, (Object)ExprValue$.MODULE$.exprValueToString(delimiterGen.value()), (Object)firstItem)).append("\n         |  } else {\n         |    if (!").append(firstItem).append(") {\n         |      ").append(buffer).append(".append(").append(delimiterGen.value()).append(");\n         |    }\n         |    ").append(buffer).append(".append(").append(CodeGenerator$.MODULE$.getValue(ExprValue$.MODULE$.exprValueToString(arrayGen.value()), StringType$.MODULE$, i)).append(");\n         |    ").append(firstItem).append(" = false;\n         |  }\n         |}\n         |").append(ev.value()).append(" = ").append(buffer).append(".build();").toString())).stripMargin();
        return this.array().nullable() || this.delimiter().nullable() ? Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)arrayGen.code()), ctx.nullSafeExec(this.array().nullable(), ExprValue$.MODULE$.exprValueToString(arrayGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)delimiterGen.code()), ctx.nullSafeExec(this.delimiter().nullable(), ExprValue$.MODULE$.exprValueToString(delimiterGen.isNull()), new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(39).append("\n             |").append(ev.isNull()).append(" = false;\n             |").append(resultCode).toString())).stripMargin())))) : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(33).append("\n         |").append(arrayGen.code()).append("\n         |").append(delimiterGen.code()).append("\n         |").append(resultCode).toString())).stripMargin();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "array_join";
    }

    public ArrayJoin copy(Expression array, Expression delimiter, Option<Expression> nullReplacement) {
        return new ArrayJoin(array, delimiter, nullReplacement);
    }

    public Expression copy$default$1() {
        return this.array();
    }

    public Expression copy$default$2() {
        return this.delimiter();
    }

    public Option<Expression> copy$default$3() {
        return this.nullReplacement();
    }

    @Override
    public String productPrefix() {
        return "ArrayJoin";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.array();
                break;
            }
            case 1: {
                option = this.delimiter();
                break;
            }
            case 2: {
                option = this.nullReplacement();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayJoin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayJoin)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayJoin arrayJoin = (ArrayJoin)x$1;
        Expression expression = this.array();
        Expression expression2 = arrayJoin.array();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimiter();
        Expression expression4 = arrayJoin.delimiter();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Expression> option = this.nullReplacement();
        Option<Expression> option2 = arrayJoin.nullReplacement();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!arrayJoin.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$eval$11(UTF8StringBuilder buffer$1, Object delimiterEval$1, Object rep$1, boolean prependDelimiter) {
        if (!prependDelimiter) {
            buffer$1.append((UTF8String)delimiterEval$1);
        }
        buffer$1.append((UTF8String)rep$1);
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$eval$12(boolean x$35) {
        return false;
    }

    public static final /* synthetic */ void $anonfun$eval$13(Function1 nullHandling$1, BooleanRef firstItem$1, UTF8StringBuilder buffer$1, Object delimiterEval$1, int x$36, Object item) {
        if (item == null) {
            if (BoxesRunTime.unboxToBoolean((Object)nullHandling$1.apply((Object)BoxesRunTime.boxToBoolean((boolean)firstItem$1.elem)))) {
                firstItem$1.elem = false;
            }
        } else {
            if (!firstItem$1.elem) {
                buffer$1.append((UTF8String)delimiterEval$1);
            }
            buffer$1.append((UTF8String)item);
            firstItem$1.elem = false;
        }
    }

    public ArrayJoin(Expression array, Expression delimiter, Option<Expression> nullReplacement) {
        this.array = array;
        this.delimiter = delimiter;
        this.nullReplacement = nullReplacement;
        ExpectsInputTypes.$init$(this);
    }

    public ArrayJoin(Expression array, Expression delimiter) {
        this(array, delimiter, (Option<Expression>)None$.MODULE$);
    }

    public ArrayJoin(Expression array, Expression delimiter, Expression nullReplacement) {
        this(array, delimiter, (Option<Expression>)new Some((Object)nullReplacement));
    }
}

