/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MonthsBetween$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(timestamp1, timestamp2[, roundOff]) - If `timestamp1` is later than `timestamp2`, then the result\n      is positive. If `timestamp1` and `timestamp2` are on the same day of month, or both\n      are the last day of month, time of day will be ignored. Otherwise, the difference is\n      calculated based on 31 days per month, and rounded to 8 digits unless roundOff=false.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('1997-02-28 10:30:00', '1996-10-30');\n       3.94959677\n      > SELECT _FUNC_('1997-02-28 10:30:00', '1996-10-30', false);\n       3.9495967741935485\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001B\u0014)\u0001VB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011!\t\u0006A!f\u0001\n\u0003Q\u0005\u0002\u0003*\u0001\u0005#\u0005\u000b\u0011B&\t\u0011M\u0003!Q3A\u0005\u0002QC\u0001b\u0019\u0001\u0003\u0012\u0003\u0006I!\u0016\u0005\u0006I\u0002!\t!\u001a\u0005\u0006I\u0002!\ta\u001b\u0005\u0006I\u0002!\tA\u001c\u0005\u0006e\u0002!\te\u001d\u0005\u0006{\u0002!\tE \u0005\b\u0003\u001b\u0001A\u0011IA\b\u0011\u001d\t9\u0002\u0001C!\u00033Aq!!\b\u0001\t\u0003\ny\u0002C\u0004\u00022\u0001!\t%a\r\t\u000f\u0005=\u0003\u0001\"\u0011\u0002R!I\u00111\u000b\u0001\u0002\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u0003?\u0002\u0011\u0013!C\u0001\u0003CB\u0011\"a\u001e\u0001#\u0003%\t!!\u0019\t\u0013\u0005e\u0004!%A\u0005\u0002\u0005\u0005\u0004\"CA>\u0001E\u0005I\u0011AA?\u0011%\t\t\tAA\u0001\n\u0003\n\u0019\tC\u0005\u0002\u0014\u0002\t\t\u0011\"\u0001\u0002\u0016\"I\u0011Q\u0014\u0001\u0002\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0003K\u0003\u0011\u0011!C!\u0003OC\u0011\"!.\u0001\u0003\u0003%\t!a.\t\u0013\u0005\u0005\u0007!!A\u0005B\u0005\rw!CAqQ\u0005\u0005\t\u0012AAr\r!9\u0003&!A\t\u0002\u0005\u0015\bB\u00023 \t\u0003\t\u0019\u0010C\u0005\u0002v~\t\t\u0011\"\u0012\u0002x\"I\u0011\u0011`\u0010\u0002\u0002\u0013\u0005\u00151 \u0005\n\u0005\u000by\u0012\u0013!C\u0001\u0003{B\u0011Ba\u0002 \u0003\u0003%\tI!\u0003\t\u0013\t]q$%A\u0005\u0002\u0005u\u0004\"\u0003B\r?\u0005\u0005I\u0011\u0002B\u000e\u00055iuN\u001c;ig\n+Go^3f]*\u0011\u0011FK\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002,Y\u0005A1-\u0019;bYf\u001cHO\u0003\u0002.]\u0005\u00191/\u001d7\u000b\u0005=\u0002\u0014!B:qCJ\\'BA\u00193\u0003\u0019\t\u0007/Y2iK*\t1'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001mij\u0004I\u0012\t\u0003oaj\u0011\u0001K\u0005\u0003s!\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t94(\u0003\u0002=Q\t9B+[7f5>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003oyJ!a\u0010\u0015\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"!\u0011#\u000e\u0003\tS\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000b\n\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002B\u000f&\u0011\u0001J\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006I\u0006$X-M\u000b\u0002\u0017B\u0011q\u0007T\u0005\u0003\u001b\"\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019!\u0017\r^32A\u0005)A-\u0019;fe\u00051A-\u0019;fe\u0001\n\u0001B]8v]\u0012|eMZ\u0001\ne>,h\u000eZ(gM\u0002\n!\u0002^5nKj{g.Z%e+\u0005)\u0006cA!W1&\u0011qK\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005e\u0003gB\u0001._!\tY&)D\u0001]\u0015\tiF'\u0001\u0004=e>|GOP\u0005\u0003?\n\u000ba\u0001\u0015:fI\u00164\u0017BA1c\u0005\u0019\u0019FO]5oO*\u0011qLQ\u0001\fi&lWMW8oK&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0006M\u001eD\u0017N\u001b\t\u0003o\u0001AQ!S\u0005A\u0002-CQaT\u0005A\u0002-CQ!U\u0005A\u0002-CqaU\u0005\u0011\u0002\u0003\u0007Q\u000bF\u0002gY6DQ!\u0013\u0006A\u0002-CQa\u0014\u0006A\u0002-#BAZ8qc\")\u0011j\u0003a\u0001\u0017\")qj\u0003a\u0001\u0017\")\u0011k\u0003a\u0001\u0017\u0006A1\r[5mIJ,g.F\u0001u!\r)(p\u0013\b\u0003mbt!aW<\n\u0003\rK!!\u001f\"\u0002\u000fA\f7m[1hK&\u00111\u0010 \u0002\u0004'\u0016\f(BA=C\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002\u007fB!QO_A\u0001!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004Y\u0005)A/\u001f9fg&!\u00111BA\u0003\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\t\t\t\u0002\u0005\u0003\u0002\u0004\u0005M\u0011\u0002BA\u000b\u0003\u000b\u0011\u0001\u0002R1uCRK\b/Z\u0001\ro&$\b\u000eV5nKj{g.\u001a\u000b\u0004u\u0005m\u0001\"B*\u0010\u0001\u0004A\u0016\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003CA\u0011\u0003O\tY#a\f\u0011\u0007\u0005\u000b\u0019#C\u0002\u0002&\t\u00131!\u00118z\u0011\u001d\tI\u0003\u0005a\u0001\u0003C\t!\u0001^\u0019\t\u000f\u00055\u0002\u00031\u0001\u0002\"\u0005\u0011AO\r\u0005\u0007#B\u0001\r!!\t\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u001b\u0003\u0003\nY\u0005\u0005\u0003\u00028\u0005uRBAA\u001d\u0015\r\tY\u0004K\u0001\bG>$WmZ3o\u0013\u0011\ty$!\u000f\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\u0011\u0012\u0001\u0004\t)%A\u0002dib\u0004B!a\u000e\u0002H%!\u0011\u0011JA\u001d\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!\u0014\u0012\u0001\u0004\t)$\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003a\u000bAaY8qsRIa-a\u0016\u0002Z\u0005m\u0013Q\f\u0005\b\u0013N\u0001\n\u00111\u0001L\u0011\u001dy5\u0003%AA\u0002-Cq!U\n\u0011\u0002\u0003\u00071\nC\u0004T'A\u0005\t\u0019A+\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\r\u0016\u0004\u0017\u0006\u00154FAA4!\u0011\tI'a\u001d\u000e\u0005\u0005-$\u0002BA7\u0003_\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005E$)\u0001\u0006b]:|G/\u0019;j_:LA!!\u001e\u0002l\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u007fR3!VA3\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0011\t\u0005\u0003\u000f\u000b\t*\u0004\u0002\u0002\n*!\u00111RAG\u0003\u0011a\u0017M\\4\u000b\u0005\u0005=\u0015\u0001\u00026bm\u0006L1!YAE\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9\nE\u0002B\u00033K1!a'C\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t#!)\t\u0013\u0005\r&$!AA\u0002\u0005]\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002*B1\u00111VAY\u0003Ci!!!,\u000b\u0007\u0005=&)\u0001\u0006d_2dWm\u0019;j_:LA!a-\u0002.\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tI,a0\u0011\u0007\u0005\u000bY,C\u0002\u0002>\n\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002$r\t\t\u00111\u0001\u0002\"\u00051Q-];bYN$B!!/\u0002F\"I\u00111U\u000f\u0002\u0002\u0003\u0007\u0011\u0011\u0005\u0015\u0010\u0001\u0005%\u0017qZAi\u0003+\f9.a7\u0002^B\u0019q'a3\n\u0007\u00055\u0007FA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005M\u0017aa\u0001\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006\u0006^5nKN$\u0018-\u001c92Y\u0001\"\u0018.\\3ti\u0006l\u0007OM.-AI|WO\u001c3PM\u001al\u0016\u0006I\u0017!\u0013\u001a\u0004\u0003\r^5nKN$\u0018-\u001c92A\u0002J7\u000f\t7bi\u0016\u0014\b\u0005\u001e5b]\u0002\u0002G/[7fgR\fW\u000e\u001d\u001aaY\u0001\"\b.\u001a8!i\",\u0007E]3tk2$(\u0002\t\u0011!A\u0001\u0002\u0013n\u001d\u0011q_NLG/\u001b<f]\u0001Je\r\t1uS6,7\u000f^1naF\u0002\u0007%\u00198eA\u0001$\u0018.\\3ti\u0006l\u0007O\r1!CJ,\u0007e\u001c8!i\",\u0007e]1nK\u0002\"\u0017-\u001f\u0011pM\u0002jwN\u001c;iY\u0001z'\u000f\t2pi\"T\u0001\u0005\t\u0011!A\u0001\n'/\u001a\u0011uQ\u0016\u0004C.Y:uA\u0011\f\u0017\u0010I8gA5|g\u000e\u001e5-AQLW.\u001a\u0011pM\u0002\"\u0017-\u001f\u0011xS2d\u0007EY3!S\u001etwN]3e]\u0001zE\u000f[3so&\u001cX\r\f\u0011uQ\u0016\u0004C-\u001b4gKJ,gnY3!SNT\u0001\u0005\t\u0011!A\u0001\u001a\u0017\r\\2vY\u0006$X\r\u001a\u0011cCN,G\rI8oAM\n\u0004\u0005Z1zg\u0002\u0002XM\u001d\u0011n_:$\b\u000e\f\u0011b]\u0012\u0004#o\\;oI\u0016$\u0007\u0005^8!q\u0001\"\u0017nZ5ug\u0002*h\u000e\\3tg\u0002\u0012x.\u001e8e\u001f\u001a4WHZ1mg\u0016t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!7\u0002\u0003sR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ\u0019:s]j\u0003GM\u00173q\u0001\n\u0004GO\u001a1uA\u0002t\u0005\f\u0011(ceJd'L\u00191[M\u0002t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!g9JD'O\u001b:m]:$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00142se:T\u0006\r\u001a.ea\u0002\u0013\u0007\r\u001e4ai\u0002\u0004g\n\u0017!OEJ\u0014HN\u00172a5\u001a\u0004g\n\u0017!M\u0006d7/Z\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMr\u0013\bN\u001d6sY:t\u0007N\u0019:gU\"\u0004(\u000e\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011q\\\u0001\u0006c9*d\u0006M\u0001\u000e\u001b>tG\u000f[:CKR<X-\u001a8\u0011\u0005]z2\u0003B\u0010\u0002h\u001a\u0003\u0012\"!;\u0002p.[5*\u00164\u000e\u0005\u0005-(bAAw\u0005\u00069!/\u001e8uS6,\u0017\u0002BAy\u0003W\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85)\t\t\u0019/\u0001\u0005u_N#(/\u001b8h)\t\t))A\u0003baBd\u0017\u0010F\u0005g\u0003{\fyP!\u0001\u0003\u0004!)\u0011J\ta\u0001\u0017\")qJ\ta\u0001\u0017\")\u0011K\ta\u0001\u0017\"91K\tI\u0001\u0002\u0004)\u0016aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!!1\u0002B\n!\u0011\teK!\u0004\u0011\u000f\u0005\u0013yaS&L+&\u0019!\u0011\u0003\"\u0003\rQ+\b\u000f\\35\u0011!\u0011)\u0002JA\u0001\u0002\u00041\u0017a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\n1B]3bIJ+7o\u001c7wKR\u0011!Q\u0004\t\u0005\u0003\u000f\u0013y\"\u0003\u0003\u0003\"\u0005%%AB(cU\u0016\u001cG\u000f")
public class MonthsBetween
extends TernaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
scala.Serializable {
    private final Expression date1;
    private final Expression date2;
    private final Expression roundOff;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient TimeZone timeZone;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$4() {
        return MonthsBetween$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Expression, Expression, Option<String>>> unapply(MonthsBetween monthsBetween) {
        return MonthsBetween$.MODULE$.unapply(monthsBetween);
    }

    public static Option<String> apply$default$4() {
        return MonthsBetween$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Option<String>>, MonthsBetween> tupled() {
        return MonthsBetween$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Option<String>, MonthsBetween>>>> curried() {
        return MonthsBetween$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        MonthsBetween monthsBetween = this;
        synchronized (monthsBetween) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        MonthsBetween monthsBetween = this;
        synchronized (monthsBetween) {
            if (!this.bitmap$trans$0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return !this.bitmap$trans$0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    public Expression date1() {
        return this.date1;
    }

    public Expression date2() {
        return this.date2;
    }

    public Expression roundOff() {
        return this.roundOff;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.date1(), this.date2(), this.roundOff()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, TimestampType$.MODULE$, BooleanType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object t1, Object t2, Object roundOff) {
        return BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(BoxesRunTime.unboxToLong((Object)t1), BoxesRunTime.unboxToLong((Object)t2), BoxesRunTime.unboxToBoolean((Object)roundOff), this.timeZone()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(d1, d2, roundOff) -> new StringBuilder(22).append(dtu).append(".monthsBetween(").append((String)d1).append(", ").append((String)d2).append(", ").append((String)roundOff).append(", ").append(tz).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "months_between";
    }

    public MonthsBetween copy(Expression date1, Expression date2, Expression roundOff, Option<String> timeZoneId) {
        return new MonthsBetween(date1, date2, roundOff, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.date1();
    }

    public Expression copy$default$2() {
        return this.date2();
    }

    public Expression copy$default$3() {
        return this.roundOff();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "MonthsBetween";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.date1();
                break;
            }
            case 1: {
                option = this.date2();
                break;
            }
            case 2: {
                option = this.roundOff();
                break;
            }
            case 3: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MonthsBetween;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MonthsBetween)) return false;
        boolean bl = true;
        if (!bl) return false;
        MonthsBetween monthsBetween = (MonthsBetween)x$1;
        Expression expression = this.date1();
        Expression expression2 = monthsBetween.date1();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.date2();
        Expression expression4 = monthsBetween.date2();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.roundOff();
        Expression expression6 = monthsBetween.roundOff();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = monthsBetween.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!monthsBetween.canEqual(this)) return false;
        return true;
    }

    public MonthsBetween(Expression date1, Expression date2, Expression roundOff, Option<String> timeZoneId) {
        this.date1 = date1;
        this.date2 = date2;
        this.roundOff = roundOff;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public MonthsBetween(Expression date1, Expression date2) {
        this(date1, date2, Literal$.MODULE$.TrueLiteral(), (Option<String>)None$.MODULE$);
    }

    public MonthsBetween(Expression date1, Expression date2, Expression roundOff) {
        this(date1, date2, roundOff, (Option<String>)None$.MODULE$);
    }
}

