/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Sequence$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode$;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.util.ArrayData$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.Mirrors;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n    _FUNC_(start, stop, step) - Generates an array of elements from start to stop (inclusive),\n      incrementing by step. The type of the returned elements is the same as the type of argument\n      expressions.\n\n      Supported types are: byte, short, integer, long, date, timestamp.\n\n      The start and stop expressions must resolve to the same type.\n      If start and stop expressions resolve to the 'date' or 'timestamp' type\n      then the step expression must resolve to the 'interval' type, otherwise to the same type\n      as the start and stop expressions.\n  ", arguments="\n    Arguments:\n      * start - an expression. The start of the range.\n      * stop - an expression. The end the range (inclusive).\n      * step - an optional expression. The step of the range.\n          By default step is 1 if start is less than or equal to stop, otherwise -1.\n          For the temporal sequences it's 1 day and -1 day respectively.\n          If start is greater than stop then the step must be negative, and vice versa.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(1, 5);\n       [1,2,3,4,5]\n      > SELECT _FUNC_(5, 1);\n       [5,4,3,2,1]\n      > SELECT _FUNC_(to_date('2018-01-01'), to_date('2018-03-01'), interval 1 month);\n       [2018-01-01,2018-02-01,2018-03-01]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\r5h\u0001B*U\u0001\u0006D\u0001B\u001d\u0001\u0003\u0016\u0004%\ta\u001d\u0005\ti\u0002\u0011\t\u0012)A\u0005E\"AQ\u000f\u0001BK\u0002\u0013\u00051\u000f\u0003\u0005w\u0001\tE\t\u0015!\u0003c\u0011!9\bA!f\u0001\n\u0003A\b\u0002\u0003?\u0001\u0005#\u0005\u000b\u0011B=\t\u0011u\u0004!Q3A\u0005\u0002yD\u0011\"a\u0006\u0001\u0005#\u0005\u000b\u0011B@\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005\u001d\u0002bBA\r\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003o\u0001A\u0011IA\u001d\u0011\u001d\ti\u0004\u0001C!\u0003\u007fAq!a\u0015\u0001\t\u0003\n)\u0006C\u0004\u0002^\u0001!\t%!\u0016\t\u000f\u0005}\u0003\u0001\"\u0011\u0002b!9\u0011q\u000e\u0001\u0005B\u0005E\u0004bBA@\u0001\u0011\u0005\u0011q\b\u0005\b\u0003\u0003\u0003A\u0011AAB\u0011)\ty\t\u0001EC\u0002\u0013%\u0011\u0011\u0013\u0005\b\u0003\u007f\u0004A\u0011IB5\u0011\u001d\u00199\b\u0001C)\u0007sB\u0011b!!\u0001\u0003\u0003%\taa!\t\u0013\r5\u0005!%A\u0005\u0002\r=\u0005\"CBJ\u0001E\u0005I\u0011ABH\u0011%\u0019)\nAI\u0001\n\u0003\u00199\nC\u0005\u0004\u001c\u0002\t\n\u0011\"\u0001\u0004*!I1Q\u0014\u0001\u0002\u0002\u0013\u00053q\u0014\u0005\n\u0007K\u0003\u0011\u0011!C\u0001\u0007OC\u0011b!+\u0001\u0003\u0003%\taa+\t\u0013\rE\u0006!!A\u0005B\rM\u0006\"CBa\u0001\u0005\u0005I\u0011ABb\u0011%\u00199\rAA\u0001\n\u0003\u001aImB\u0004\u0002\u0018RC\t!!'\u0007\rM#\u0006\u0012AAN\u0011\u001d\tIb\tC\u0001\u0003G+a!!*$\t\u0005\u001dfABAZG\u0011\t)\f\u0003\u0006\u00028\u001a\u0012\t\u0011)A\u0005\u0003sC!\"!0'\u0005\u0003\u0005\u000b\u0011BAE\u0011)\tyL\nB\u0001B\u0003%\u0011Q\u0016\u0005\b\u000331C\u0011AAa\u0011%\tYM\nb\u0001\n\u0013\ti\r\u0003\u0005\u0002P\u001a\u0002\u000b\u0011BAW\u0011\u001d\t\tN\nC\u0001\u0003'Dq!!7'\t\u0003\tYNB\u0005\u0002|\u000e\u0002\n1%\u0003\u0002~\"9\u0011q`\u0018\u0007\u0002\t\u0005\u0001bBAm_\u0019\u0005!\u0011\u0002\u0005\n\u00057y#\u0019!D\u0001\u0005;1aAa\b$\t\t\u0005\u0002B\u0003B\rg\t\u0005\t\u0015!\u0003\u0003(!Q!QF\u001a\u0003\u0004\u0003\u0006YAa\f\t\u0015\t-3G!A!\u0002\u0017\u0011i\u0005C\u0004\u0002\u001aM\"\tAa\u0015\t\u0013\tm1G1A\u0005B\tu\u0001\u0002\u0003B0g\u0001\u0006I!a1\t\u000f\u0005}8\u0007\"\u0011\u0003b!9\u0011\u0011\\\u001a\u0005B\tUdA\u0002BBG\u0011\u0011)\t\u0003\u0006\u0003\nr\u0012\t\u0011)A\u0005\u0005OA!Ba#=\u0005\u0003\u0005\u000b\u0011\u0002BG\u0011)\u0011\u0019\n\u0010B\u0001B\u0003%!Q\u0013\u0005\u000b\u0005?c$\u0011!Q\u0001\n\t\u0005\u0006B\u0003BYy\t\r\t\u0015a\u0003\u00034\"Q!1\n\u001f\u0003\u0002\u0003\u0006YA!.\t\u000f\u0005eA\b\"\u0001\u00038\"I!1\u0004\u001fC\u0002\u0013\u0005#Q\u0004\u0005\t\u0005?b\u0004\u0015!\u0003\u0002D\"I!\u0011\u001a\u001fC\u0002\u0013%!1\u001a\u0005\t\u0005\u001fd\u0004\u0015!\u0003\u0003N\"I!\u0011\u001b\u001fC\u0002\u0013%!1\u001b\u0005\t\u0005+d\u0004\u0015!\u0003\u0003\u000e\"9\u0011q \u001f\u0005B\t]\u0007bBAmy\u0011\u0005#\u0011\u001d\u0005\b\u0005_\u001cC\u0011\u0002By\u0011\u001d\u0019ia\tC\u0005\u0007\u001fA\u0011\"!5$\u0003\u0003%\ti!\b\t\u0013\r\u001d2%%A\u0005\u0002\r%\u0002\"CB G\u0005\u0005I\u0011QB!\u0011%\u0019yeII\u0001\n\u0003\u0019I\u0003C\u0005\u0004R\r\n\t\u0011\"\u0003\u0004T\tA1+Z9vK:\u001cWM\u0003\u0002V-\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t9\u0006,\u0001\u0005dCR\fG._:u\u0015\tI&,A\u0002tc2T!a\u0017/\u0002\u000bM\u0004\u0018M]6\u000b\u0005us\u0016AB1qC\u000eDWMC\u0001`\u0003\ry'oZ\u0002\u0001'\u0015\u0001!MZ5p!\t\u0019G-D\u0001U\u0013\t)GK\u0001\u0006FqB\u0014Xm]:j_:\u0004\"aY4\n\u0005!$&a\u0006+j[\u0016TvN\\3Bo\u0006\u0014X-\u0012=qe\u0016\u001c8/[8o!\tQW.D\u0001l\u0015\u0005a\u0017!B:dC2\f\u0017B\u00018l\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u001b9\n\u0005E\\'\u0001D*fe&\fG.\u001b>bE2,\u0017!B:uCJ$X#\u00012\u0002\rM$\u0018M\u001d;!\u0003\u0011\u0019Ho\u001c9\u0002\u000bM$x\u000e\u001d\u0011\u0002\u000fM$X\r](qiV\t\u0011\u0010E\u0002ku\nL!a_6\u0003\r=\u0003H/[8o\u0003!\u0019H/\u001a9PaR\u0004\u0013A\u0003;j[\u0016TvN\\3JIV\tq\u0010\u0005\u0003ku\u0006\u0005\u0001\u0003BA\u0002\u0003#qA!!\u0002\u0002\u000eA\u0019\u0011qA6\u000e\u0005\u0005%!bAA\u0006A\u00061AH]8pizJ1!a\u0004l\u0003\u0019\u0001&/\u001a3fM&!\u00111CA\u000b\u0005\u0019\u0019FO]5oO*\u0019\u0011qB6\u0002\u0017QLW.\u001a.p]\u0016LE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u0005u\u0011qDA\u0011\u0003G\t)\u0003\u0005\u0002d\u0001!)!/\u0003a\u0001E\")Q/\u0003a\u0001E\")q/\u0003a\u0001s\"9Q0\u0003I\u0001\u0002\u0004yHCBA\u000f\u0003S\tY\u0003C\u0003s\u0015\u0001\u0007!\rC\u0003v\u0015\u0001\u0007!\r\u0006\u0005\u0002\u001e\u0005=\u0012\u0011GA\u001a\u0011\u0015\u00118\u00021\u0001c\u0011\u0015)8\u00021\u0001c\u0011\u0019\t)d\u0003a\u0001E\u0006!1\u000f^3q\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\r1\u00171\b\u0005\u0007{2\u0001\r!!\u0001\u0002\u0011\rD\u0017\u000e\u001c3sK:,\"!!\u0011\u0011\u000b\u0005\r\u0013Q\n2\u000f\t\u0005\u0015\u0013\u0011\n\b\u0005\u0003\u000f\t9%C\u0001m\u0013\r\tYe[\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty%!\u0015\u0003\u0007M+\u0017OC\u0002\u0002L-\f\u0001BZ8mI\u0006\u0014G.Z\u000b\u0003\u0003/\u00022A[A-\u0013\r\tYf\u001b\u0002\b\u0005>|G.Z1o\u0003!qW\u000f\u001c7bE2,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005\r\u0004\u0003BA3\u0003Wj!!a\u001a\u000b\u0007\u0005%\u0004,A\u0003usB,7/\u0003\u0003\u0002n\u0005\u001d$!C!se\u0006LH+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\t\u0019\b\u0005\u0003\u0002v\u0005mTBAA<\u0015\r\tIHV\u0001\tC:\fG._:jg&!\u0011QPA<\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018!E2pKJ\u001c\u0017N\u00197f\u0007\"LG\u000e\u001a:f]\u0006q1-Y:u\u0007\"LG\u000e\u001a:f]R{Gc\u00012\u0002\u0006\"9\u0011qQ\nA\u0002\u0005%\u0015!C<jI\u0016\u0014H+\u001f9f!\u0011\t)'a#\n\t\u00055\u0015q\r\u0002\t\t\u0006$\u0018\rV=qK\u0006!\u0011.\u001c9m+\t\t\u0019\nE\u0002\u0002\u0016>r!a\u0019\u0012\u0002\u0011M+\u0017/^3oG\u0016\u0004\"aY\u0012\u0014\t\r\nij\u001c\t\u0004U\u0006}\u0015bAAQW\n1\u0011I\\=SK\u001a$\"!!'\u0003#1+7o\u001d+iC:|%/R9vC24e\u000eE\u0005k\u0003S\u000bi+!,\u0002X%\u0019\u00111V6\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004c\u00016\u00020&\u0019\u0011\u0011W6\u0003\u0007\u0005s\u0017PA\u0006EK\u001a\fW\u000f\u001c;Ti\u0016\u00048c\u0001\u0014\u0002\u001e\u0006!A\u000e^3r!\r\tY,J\u0007\u0002G\u0005A1\u000f^3q)f\u0004X-A\u0002p]\u0016$\u0002\"a1\u0002F\u0006\u001d\u0017\u0011\u001a\t\u0004\u0003w3\u0003bBA\\U\u0001\u0007\u0011\u0011\u0018\u0005\b\u0003{S\u0003\u0019AAE\u0011\u001d\tyL\u000ba\u0001\u0003[\u000b1B\\3hCRLg/Z(oKV\u0011\u0011QV\u0001\r]\u0016<\u0017\r^5wK>sW\rI\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003[\u000b).a6\t\rIl\u0003\u0019AAW\u0011\u0019)X\u00061\u0001\u0002.\u00069q-\u001a8D_\u0012,G\u0003CAo\u0003S\f\u00190a>\u0011\t\u0005}\u0017Q]\u0007\u0003\u0003CT1!a9U\u0003\u001d\u0019w\u000eZ3hK:LA!a:\u0002b\nAQ\t\u001f9s\u0007>$W\rC\u0004\u0002l:\u0002\r!!<\u0002\u0007\r$\b\u0010\u0005\u0003\u0002`\u0006=\u0018\u0002BAy\u0003C\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002v:\u0002\r!!8\u0002\u0011M$\u0018M\u001d;HK:Dq!!?/\u0001\u0004\ti.A\u0004ti>\u0004x)\u001a8\u0003\u0019M+\u0017/^3oG\u0016LU\u000e\u001d7\u0014\u0007=\ni*\u0001\u0003fm\u0006dG\u0003CAW\u0005\u0007\u0011)Aa\u0002\t\rI\u0004\u0004\u0019AAW\u0011\u0019)\b\u00071\u0001\u0002.\"9\u0011Q\u0007\u0019A\u0002\u00055FCDA\u0001\u0005\u0017\u0011iAa\u0004\u0003\u0012\tM!q\u0003\u0005\b\u0003W\f\u0004\u0019AAw\u0011\u0019\u0011\u0018\u00071\u0001\u0002\u0002!1Q/\ra\u0001\u0003\u0003Aq!!\u000e2\u0001\u0004\t\t\u0001C\u0004\u0003\u0016E\u0002\r!!\u0001\u0002\u0007\u0005\u0014(\u000fC\u0004\u0003\u001aE\u0002\r!!\u0001\u0002\u0011\u0015dW-\u001c+za\u0016\f1\u0002Z3gCVdGo\u0015;faV\u0011\u00111\u0019\u0002\u0015\u0013:$Xm\u001a:bYN+\u0017/^3oG\u0016LU\u000e\u001d7\u0016\t\t\r\"qH\n\u0006g\u0005u%Q\u0005\t\u0004\u0003w{\u0003\u0003BA3\u0005SIAAa\u000b\u0002h\ta\u0011J\u001c;fOJ\fG\u000eV=qK\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\r\tE\"q\u0007B\u001e\u001b\t\u0011\u0019DC\u0002\u00036-\fqA]3gY\u0016\u001cG/\u0003\u0003\u0003:\tM\"\u0001C\"mCN\u001cH+Y4\u0011\t\tu\"q\b\u0007\u0001\t\u001d\u0011\te\rb\u0001\u0005\u0007\u0012\u0011\u0001V\t\u0005\u0005\u000b\ni\u000bE\u0002k\u0005\u000fJ1A!\u0013l\u0005\u001dqu\u000e\u001e5j]\u001e\f1A\\;n!\u0019\t\u0019Ea\u0014\u0003<%!!\u0011KA)\u0005!Ie\u000e^3he\u0006dG\u0003\u0002B+\u0005;\"bAa\u0016\u0003Z\tm\u0003#BA^g\tm\u0002b\u0002B\u0017o\u0001\u000f!q\u0006\u0005\b\u0005\u0017:\u00049\u0001B'\u0011\u001d\u0011Ib\u000ea\u0001\u0005O\tA\u0002Z3gCVdGo\u0015;fa\u0002\"\u0002Ba\u0019\u0003j\t5$\u0011\u000f\t\u0006U\n\u0015$1H\u0005\u0004\u0005OZ'!B!se\u0006L\bb\u0002B6u\u0001\u0007\u0011QV\u0001\u0007S:\u0004X\u000f^\u0019\t\u000f\t=$\b1\u0001\u0002.\u00061\u0011N\u001c9viJBqAa\u001d;\u0001\u0004\ti+\u0001\u0004j]B,Ho\r\u000b\u000f\u0003\u0003\u00119H!\u001f\u0003|\tu$q\u0010BA\u0011\u001d\tYo\u000fa\u0001\u0003[DaA]\u001eA\u0002\u0005\u0005\u0001BB;<\u0001\u0004\t\t\u0001C\u0004\u00026m\u0002\r!!\u0001\t\u000f\tU1\b1\u0001\u0002\u0002!9!\u0011D\u001eA\u0002\u0005\u0005!\u0001\u0006+f[B|'/\u00197TKF,XM\\2f\u00136\u0004H.\u0006\u0003\u0003\b\nu5#\u0002\u001f\u0002\u001e\n\u0015\u0012A\u00013u\u0003\u0015\u00198-\u00197f!\rQ'qR\u0005\u0004\u0005#['\u0001\u0002'p]\u001e\f\u0001B\u001a:p[2{gn\u001a\t\bU\n]%Q\u0012BN\u0013\r\u0011Ij\u001b\u0002\n\rVt7\r^5p]F\u0002BA!\u0010\u0003\u001e\u00129!\u0011\t\u001fC\u0002\t\r\u0013\u0001\u0003;j[\u0016TvN\\3\u0011\t\t\r&QV\u0007\u0003\u0005KSAAa*\u0003*\u0006!Q\u000f^5m\u0015\t\u0011Y+\u0001\u0003kCZ\f\u0017\u0002\u0002BX\u0005K\u0013\u0001\u0002V5nKj{g.Z\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004C\u0002B\u0019\u0005o\u0011Y\n\u0005\u0004\u0002D\t=#1\u0014\u000b\u000b\u0005s\u0013\tMa1\u0003F\n\u001dGC\u0002B^\u0005{\u0013y\fE\u0003\u0002<r\u0012Y\nC\u0004\u00032\u000e\u0003\u001dAa-\t\u000f\t-3\tq\u0001\u00036\"9!\u0011R\"A\u0002\t\u001d\u0002b\u0002BF\u0007\u0002\u0007!Q\u0012\u0005\b\u0005'\u001b\u0005\u0019\u0001BK\u0011\u001d\u0011yj\u0011a\u0001\u0005C\u000b!CY1dW\u0016$7+Z9vK:\u001cW-S7qYV\u0011!Q\u001a\t\u0006\u0003w\u001b$1T\u0001\u0014E\u0006\u001c7.\u001a3TKF,XM\\2f\u00136\u0004H\u000eI\u0001\u000f[&\u001c'o\\:QKJluN\u001c;i+\t\u0011i)A\bnS\u000e\u0014xn\u001d)fe6{g\u000e\u001e5!)!\u0011INa7\u0003^\n}\u0007#\u00026\u0003f\tm\u0005b\u0002B6\u0015\u0002\u0007\u0011Q\u0016\u0005\b\u0005_R\u0005\u0019AAW\u0011\u001d\u0011\u0019H\u0013a\u0001\u0003[#b\"!\u0001\u0003d\n\u0015(q\u001dBu\u0005W\u0014i\u000fC\u0004\u0002l.\u0003\r!!<\t\rI\\\u0005\u0019AA\u0001\u0011\u0019)8\n1\u0001\u0002\u0002!9\u0011QG&A\u0002\u0005\u0005\u0001b\u0002B\u000b\u0017\u0002\u0007\u0011\u0011\u0001\u0005\b\u00053Y\u0005\u0019AA\u0001\u0003E9W\r^*fcV,gnY3MK:<G\u000f[\u000b\u0005\u0005g\u001c\u0019\u0001\u0006\u0005\u0003v\u000e\u001d1\u0011BB\u0006)\u0011\u00119P!@\u0011\u0007)\u0014I0C\u0002\u0003|.\u00141!\u00138u\u0011\u001d\u0011Y\u0005\u0014a\u0002\u0005\u007f\u0004b!a\u0011\u0003P\r\u0005\u0001\u0003\u0002B\u001f\u0007\u0007!qa!\u0002M\u0005\u0004\u0011\u0019EA\u0001V\u0011\u0019\u0011H\n1\u0001\u0004\u0002!1Q\u000f\u0014a\u0001\u0007\u0003Aq!!\u000eM\u0001\u0004\u0019\t!A\u000bhK:\u001cV-];f]\u000e,G*\u001a8hi\"\u001cu\u000eZ3\u0015\u0019\u0005\u00051\u0011CB\n\u0007+\u00199b!\u0007\t\u000f\u0005-X\n1\u0001\u0002n\"1!/\u0014a\u0001\u0003\u0003Aa!^'A\u0002\u0005\u0005\u0001bBA\u001b\u001b\u0002\u0007\u0011\u0011\u0001\u0005\b\u00077i\u0005\u0019AA\u0001\u0003\raWM\u001c\u000b\u000b\u0003;\u0019yb!\t\u0004$\r\u0015\u0002\"\u0002:O\u0001\u0004\u0011\u0007\"B;O\u0001\u0004\u0011\u0007\"B<O\u0001\u0004I\bbB?O!\u0003\u0005\ra`\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u001111\u0006\u0016\u0004\u007f\u000e52FAB\u0018!\u0011\u0019\tda\u000f\u000e\u0005\rM\"\u0002BB\u001b\u0007o\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\re2.\u0001\u0006b]:|G/\u0019;j_:LAa!\u0010\u00044\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u000fUt\u0017\r\u001d9msR!11IB&!\u0011Q'p!\u0012\u0011\u000f)\u001c9E\u00192z\u007f&\u00191\u0011J6\u0003\rQ+\b\u000f\\35\u0011%\u0019i\u0005UA\u0001\u0002\u0004\ti\"A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"a!\u0016\u0011\t\r]3QL\u0007\u0003\u00073RAaa\u0017\u0003*\u0006!A.\u00198h\u0013\u0011\u0019yf!\u0017\u0003\r=\u0013'.Z2uQ\r!21\r\t\u0004U\u000e\u0015\u0014bAB4W\nIAO]1og&,g\u000e\u001e\u000b\u0005\u0003[\u001bY\u0007C\u0005\u0004nU\u0001\n\u00111\u0001\u0004p\u0005)\u0011N\u001c9viB!1\u0011OB:\u001b\u00051\u0016bAB;-\nY\u0011J\u001c;fe:\fGNU8x\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002^\u000em4Q\u0010\u0005\b\u0003W4\u0002\u0019AAw\u0011\u001d\u0019yH\u0006a\u0001\u0003;\f!!\u001a<\u0002\t\r|\u0007/\u001f\u000b\u000b\u0003;\u0019)ia\"\u0004\n\u000e-\u0005b\u0002:\u0018!\u0003\u0005\rA\u0019\u0005\bk^\u0001\n\u00111\u0001c\u0011\u001d9x\u0003%AA\u0002eDq!`\f\u0011\u0002\u0003\u0007q0\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\rE%f\u00012\u0004.\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u00073S3!_B\u0017\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCABQ!\u0011\u00199fa)\n\t\u0005M1\u0011L\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005o\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002.\u000e5\u0006\"CBX=\u0005\u0005\t\u0019\u0001B|\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u00111Q\u0017\t\u0007\u0007o\u001bi,!,\u000e\u0005\re&bAB^W\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\r}6\u0011\u0018\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002X\r\u0015\u0007\"CBXA\u0005\u0005\t\u0019AAW\u0003\u0019)\u0017/^1mgR!\u0011qKBf\u0011%\u0019y+IA\u0001\u0002\u0004\ti\u000bK\n\u0001\u0007\u001f\u001c)na6\u0004\\\u000eu7\u0011]Br\u0007O\u001cI\u000fE\u0002d\u0007#L1aa5U\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#a!7\u0002\toR\u0001\u0005\t\u0011!?\u001a+fjQ0)gR\f'\u000f\u001e\u0017!gR|\u0007\u000f\f\u0011ti\u0016\u0004\u0018\u0006I\u0017!\u000f\u0016tWM]1uKN\u0004\u0013M\u001c\u0011beJ\f\u0017\u0010I8gA\u0015dW-\\3oiN\u0004cM]8nAM$\u0018M\u001d;!i>\u00043\u000f^8qA!Jgn\u00197vg&4X-\u000b\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011j]\u000e\u0014X-\\3oi&tw\r\t2zAM$X\r\u001d\u0018!)\",\u0007\u0005^=qK\u0002zg\r\t;iK\u0002\u0012X\r^;s]\u0016$\u0007%\u001a7f[\u0016tGo\u001d\u0011jg\u0002\"\b.\u001a\u0011tC6,\u0007%Y:!i\",\u0007\u0005^=qK\u0002zg\rI1sOVlWM\u001c;\u000bA\u0001\u0002\u0003\u0005\t\u0011fqB\u0014Xm]:j_:\u001chF\u0003\u0006!A\u0001\u0002\u0003\u0005I*vaB|'\u000f^3eAQL\b/Z:!CJ,'\b\t2zi\u0016d\u0003e\u001d5peRd\u0003%\u001b8uK\u001e,'\u000f\f\u0011m_:<G\u0006\t3bi\u0016d\u0003\u0005^5nKN$\u0018-\u001c9/\u0015)\u0001\u0003\u0005\t\u0011!AQCW\rI:uCJ$\b%\u00198eAM$x\u000e\u001d\u0011fqB\u0014Xm]:j_:\u001c\b%\\;ti\u0002\u0012Xm]8mm\u0016\u0004Co\u001c\u0011uQ\u0016\u00043/Y7fAQL\b/\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011JM\u0002\u001aH/\u0019:uA\u0005tG\rI:u_B\u0004S\r\u001f9sKN\u001c\u0018n\u001c8tAI,7o\u001c7wK\u0002\"x\u000e\t;iK\u0002:C-\u0019;fO\u0001z'\u000fI\u0014uS6,7\u000f^1na\u001e\u0002C/\u001f9f\u0015\u0001\u0002\u0003\u0005\t\u0011!i\",g\u000e\t;iK\u0002\u001aH/\u001a9!Kb\u0004(/Z:tS>t\u0007%\\;ti\u0002\u0012Xm]8mm\u0016\u0004Co\u001c\u0011uQ\u0016\u0004s%\u001b8uKJ4\u0018\r\\\u0014!if\u0004X\r\f\u0011pi\",'o^5tK\u0002\"x\u000e\t;iK\u0002\u001a\u0018-\\3!if\u0004XM\u0003\u0011!A\u0001\u0002\u0003%Y:!i\",\u0007e\u001d;beR\u0004\u0013M\u001c3!gR|\u0007\u000fI3yaJ,7o]5p]Nt#\u0002\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EABp\u0003\rU$\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011ti\u0006\u0014H\u000fI\u0017!C:\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/AQCW\rI:uCJ$\be\u001c4!i\",\u0007E]1oO\u0016t#\u0002\t\u0011!A\u0001\u0002#\u0006I:u_B\u0004S\u0006I1oA\u0015D\bO]3tg&|gN\f\u0011UQ\u0016\u0004SM\u001c3!i\",\u0007E]1oO\u0016\u0004\u0003&\u001b8dYV\u001c\u0018N^3*])\u0001\u0003\u0005\t\u0011!A)\u00023\u000f^3qA5\u0002\u0013M\u001c\u0011paRLwN\\1mA\u0015D\bO]3tg&|gN\f\u0011UQ\u0016\u00043\u000f^3qA=4\u0007\u0005\u001e5fAI\fgnZ3/\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EQ=!I\u00164\u0017-\u001e7uAM$X\r\u001d\u0011jg\u0002\n\u0004%\u001b4!gR\f'\u000f\u001e\u0011jg\u0002bWm]:!i\"\fg\u000eI8sA\u0015\fX/\u00197!i>\u00043\u000f^8qY\u0001zG\u000f[3so&\u001cX\rI\u00172])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t$pe\u0002\"\b.\u001a\u0011uK6\u0004xN]1mAM,\u0017/^3oG\u0016\u001c\b%\u001b;(g\u0002\n\u0004\u0005Z1zA\u0005tG\rI\u00172A\u0011\f\u0017\u0010\t:fgB,7\r^5wK2LhF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A%3\u0007e\u001d;beR\u0004\u0013n\u001d\u0011he\u0016\fG/\u001a:!i\"\fg\u000eI:u_B\u0004C\u000f[3oAQDW\rI:uKB\u0004S.^:uA\t,\u0007E\\3hCRLg/\u001a\u0017!C:$\u0007E^5dK\u00022XM]:b])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0019)/AAs\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\nD\u0006I\u001b*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0016\u0007\f\u001a-g1\"D&N/\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QUb\u0003%M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am+D\u0006\u000e\u00174YIb\u0013'\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)i>|F-\u0019;fQ\u001d\u0012\u0004'\r\u001d.aEj\u0003'M\u0014*Y\u0001\"xn\u00183bi\u0016DsE\r\u00192q5\u00024'\f\u00192O%b\u0003%\u001b8uKJ4\u0018\r\u001c\u00112A5|g\u000e\u001e5*w)\u0001\u0003\u0005\t\u0011!A\u0001Z&\u0007M\u00199[A\nT\u0006M\u0019-eA\n\u0004(\f\u00193[A\nDF\r\u00192q5\u00024'\f\u00192;*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0004l\u0006)!G\f\u001b/a\u0001")
public class Sequence
extends Expression
implements TimeZoneAwareExpression,
scala.Serializable {
    private transient SequenceImpl impl;
    private final Expression start;
    private final Expression stop;
    private final Option<Expression> stepOpt;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient TimeZone timeZone;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$4() {
        return Sequence$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Expression, Option<Expression>, Option<String>>> unapply(Sequence sequence) {
        return Sequence$.MODULE$.unapply(sequence);
    }

    public static Option<String> apply$default$4() {
        return Sequence$.MODULE$.apply$default$4();
    }

    private boolean resolved$lzycompute() {
        Sequence sequence = this;
        synchronized (sequence) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        Sequence sequence = this;
        synchronized (sequence) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    public Expression start() {
        return this.start;
    }

    public Expression stop() {
        return this.stop;
    }

    public Option<Expression> stepOpt() {
        return this.stepOpt;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Some x$1 = new Some((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Option<Expression> x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.start(), this.stop()}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.stepOpt()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable & scala.Serializable)x$61 -> BoxesRunTime.boxToBoolean((boolean)x$61.foldable()));
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable & scala.Serializable)x$62 -> BoxesRunTime.boxToBoolean((boolean)x$62.nullable()));
    }

    @Override
    public ArrayType dataType() {
        return new ArrayType(this.start().dataType(), false);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType;
        boolean bl;
        boolean bl2;
        DataType startType = this.start().dataType();
        boolean typesCorrect = startType.sameType(this.stop().dataType()) && (bl2 = (bl = TimestampType$.MODULE$.equals(dataType = startType) ? true : DateType$.MODULE$.equals(dataType)) ? this.stepOpt().isEmpty() || CalendarIntervalType$.MODULE$.acceptsType(this.stepType$1()) : (dataType instanceof IntegralType ? this.stepOpt().isEmpty() || this.stepType$1().sameType(startType) : false));
        return typesCorrect ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(48).append(this.prettyName()).append(" only supports integral, timestamp or date types").toString());
    }

    public Seq<Expression> coercibleChildren() {
        return (Seq)this.children().filter((Function1 & Serializable & scala.Serializable)x$63 -> BoxesRunTime.boxToBoolean((boolean)Sequence.$anonfun$coercibleChildren$1(x$63)));
    }

    public Expression castChildrenTo(DataType widerType) {
        return new Sequence(new Cast(this.start(), widerType, Cast$.MODULE$.apply$default$3()), new Cast(this.stop(), widerType, Cast$.MODULE$.apply$default$3()), (Option<Expression>)this.stepOpt().map((Function1 & Serializable & scala.Serializable)step -> {
            DataType dataType = step.dataType();
            CalendarIntervalType$ calendarIntervalType$ = CalendarIntervalType$.MODULE$;
            return (dataType == null ? calendarIntervalType$ != null : !dataType.equals(calendarIntervalType$)) ? new Cast((Expression)step, widerType, Cast$.MODULE$.apply$default$3()) : step;
        }), this.timeZoneId());
    }

    private SequenceImpl impl$lzycompute() {
        Sequence sequence = this;
        synchronized (sequence) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                SequenceImpl sequenceImpl;
                DataType dataType = this.dataType().elementType();
                if (dataType instanceof IntegralType) {
                    IntegralType integralType = (IntegralType)dataType;
                    ClassTag ct = ClassTag$.MODULE$.apply((Class)((Mirrors.RuntimeMirror)integralType.tag().mirror()).runtimeClass(integralType.tag().tpe()));
                    sequenceImpl = new IntegralSequenceImpl<Object>(integralType, ct, integralType.integral());
                } else if (TimestampType$.MODULE$.equals(dataType)) {
                    sequenceImpl = new TemporalSequenceImpl(LongType$.MODULE$, 1L, (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x))), this.timeZone(), ClassTag$.MODULE$.Long(), Numeric.LongIsIntegral$.MODULE$);
                } else if (DateType$.MODULE$.equals(dataType)) {
                    sequenceImpl = new TemporalSequenceImpl(IntegerType$.MODULE$, 86400000000L, (JFunction1.mcIJ.sp & Serializable & scala.Serializable)x$64 -> (int)x$64, this.timeZone(), ClassTag$.MODULE$.Int(), Numeric.IntIsIntegral$.MODULE$);
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.impl = sequenceImpl;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.impl;
    }

    private SequenceImpl impl() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.impl$lzycompute() : this.impl;
    }

    @Override
    public Object eval(InternalRow input) {
        Object startVal = this.start().eval(input);
        if (startVal == null) {
            return null;
        }
        Object stopVal = this.stop().eval(input);
        if (stopVal == null) {
            return null;
        }
        Object stepVal = this.stepOpt().map((Function1 & Serializable & scala.Serializable)x$65 -> x$65.eval(input)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.impl().defaultStep().apply(startVal, stopVal));
        if (stepVal == null) {
            return null;
        }
        return ArrayData$.MODULE$.toArrayData(this.impl().eval(startVal, stopVal, stepVal));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        ExprCode startGen = this.start().genCode(ctx);
        ExprCode stopGen = this.stop().genCode(ctx);
        ExprCode stepGen = (ExprCode)this.stepOpt().map((Function1 & Serializable & scala.Serializable)x$66 -> x$66.genCode(ctx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.impl().defaultStep().genCode(ctx, startGen, stopGen));
        String resultType = CodeGenerator$.MODULE$.javaType(this.dataType());
        String arr = ctx.freshName("arr");
        String arrElemType = CodeGenerator$.MODULE$.javaType(this.dataType().elementType());
        String resultCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(98).append("\n         |final ").append(arrElemType).append("[] ").append(arr).append(" = null;\n         |").append(this.impl().genCode(ctx, ExprValue$.MODULE$.exprValueToString(startGen.value()), ExprValue$.MODULE$.exprValueToString(stopGen.value()), ExprValue$.MODULE$.exprValueToString(stepGen.value()), arr, arrElemType)).append("\n         |").append(ev.value()).append(" = UnsafeArrayData.fromPrimitiveArray(").append(arr).append(");\n       ").toString())).stripMargin();
        if (this.nullable()) {
            String nullSafeEval = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)startGen.code()), ctx.nullSafeExec(this.start().nullable(), ExprValue$.MODULE$.exprValueToString(startGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)stopGen.code()), ctx.nullSafeExec(this.stop().nullable(), ExprValue$.MODULE$.exprValueToString(stopGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)stepGen.code()), ctx.nullSafeExec(this.stepOpt().exists((Function1 & Serializable & scala.Serializable)x$67 -> BoxesRunTime.boxToBoolean((boolean)x$67.nullable())), ExprValue$.MODULE$.exprValueToString(stepGen.isNull()), new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("\n                 |").append(ev.isNull()).append(" = false;\n                 |").append(resultCode).append("\n               ").toString())).stripMargin()))))));
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean ", " = true;\n           |", " ", " = null;\n           |", "\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), resultType, ev.value(), nullSafeEval})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
        } else {
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |", "\n           |", "\n           |", " ", " = null;\n           |", "\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{startGen.code(), stopGen.code(), stepGen.code(), resultType, ev.value(), resultCode})).stripMargin(), FalseLiteral$.MODULE$, ev.copy$default$3());
        }
        return exprCode;
    }

    public Sequence copy(Expression start, Expression stop, Option<Expression> stepOpt, Option<String> timeZoneId) {
        return new Sequence(start, stop, stepOpt, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.start();
    }

    public Expression copy$default$2() {
        return this.stop();
    }

    public Option<Expression> copy$default$3() {
        return this.stepOpt();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "Sequence";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.start();
                break;
            }
            case 1: {
                object = this.stop();
                break;
            }
            case 2: {
                object = this.stepOpt();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sequence;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sequence)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sequence sequence = (Sequence)x$1;
        Expression expression = this.start();
        Expression expression2 = sequence.start();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.stop();
        Expression expression4 = sequence.stop();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Expression> option = this.stepOpt();
        Option<Expression> option2 = sequence.stepOpt();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = sequence.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!sequence.canEqual(this)) return false;
        return true;
    }

    private final DataType stepType$1() {
        return ((Expression)this.stepOpt().get()).dataType();
    }

    public static final /* synthetic */ boolean $anonfun$coercibleChildren$1(Expression x$63) {
        DataType dataType = x$63.dataType();
        CalendarIntervalType$ calendarIntervalType$ = CalendarIntervalType$.MODULE$;
        return dataType == null ? calendarIntervalType$ != null : !dataType.equals(calendarIntervalType$);
    }

    public Sequence(Expression start, Expression stop, Option<Expression> stepOpt, Option<String> timeZoneId) {
        this.start = start;
        this.stop = stop;
        this.stepOpt = stepOpt;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
    }

    public Sequence(Expression start, Expression stop) {
        this(start, stop, (Option<Expression>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    public Sequence(Expression start, Expression stop, Expression step) {
        this(start, stop, (Option<Expression>)new Some((Object)step), (Option<String>)None$.MODULE$);
    }

    public static class DefaultStep {
        private final Function2<Object, Object, Object> lteq;
        private final DataType stepType;
        private final Object one;
        private final Object negativeOne;

        private Object negativeOne() {
            return this.negativeOne;
        }

        public Object apply(Object start, Object stop) {
            return BoxesRunTime.unboxToBoolean((Object)this.lteq.apply(start, stop)) ? this.one : this.negativeOne();
        }

        public ExprCode genCode(CodegenContext ctx, ExprCode startGen, ExprCode stopGen) {
            Seq seq = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.one, this.negativeOne()}))).map((Function1 & Serializable & scala.Serializable)x$68 -> Literal$.MODULE$.apply(x$68).genCode(ctx).value(), Seq$.MODULE$.canBuildFrom());
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)seq);
            }
            ExprValue oneVal = (ExprValue)((SeqLike)some.get()).apply(0);
            ExprValue negativeOneVal = (ExprValue)((SeqLike)some.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)oneVal, (Object)negativeOneVal);
            Tuple2 tuple22 = tuple2;
            ExprValue oneVal2 = (ExprValue)tuple22._1();
            ExprValue negativeOneVal2 = (ExprValue)tuple22._2();
            return ExprCode$.MODULE$.forNonNullValue(JavaCode$.MODULE$.expression(new StringBuilder(10).append(startGen.value()).append(" <= ").append(stopGen.value()).append(" ? ").append(oneVal2).append(" : ").append(negativeOneVal2).toString(), this.stepType));
        }

        public DefaultStep(Function2<Object, Object, Object> lteq, DataType stepType, Object one) {
            this.lteq = lteq;
            this.stepType = stepType;
            this.one = one;
            UnaryMinus qual$1 = new UnaryMinus(Literal$.MODULE$.apply(one));
            InternalRow x$1 = qual$1.eval$default$1();
            this.negativeOne = qual$1.eval(x$1);
        }
    }

    public static class IntegralSequenceImpl<T>
    implements SequenceImpl {
        private final IntegralType elemType;
        private final ClassTag<T> evidence$1;
        private final Integral<T> num;
        private final DefaultStep defaultStep;

        @Override
        public DefaultStep defaultStep() {
            return this.defaultStep;
        }

        @Override
        public Object eval(Object input1, Object input2, Object input3) {
            Object start = input1;
            Object stop = input2;
            Object step = input3;
            int i = Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$getSequenceLength(start, stop, step, this.num);
            Object arr = this.evidence$1.newArray(i);
            while (i > 0) {
                ScalaRunTime$.MODULE$.array_update(arr, --i, this.num.mkNumericOps(start).$plus(this.num.mkNumericOps(step).$times(this.num.fromInt(i))));
            }
            return arr;
        }

        @Override
        public String genCode(CodegenContext ctx, String start, String stop, String step, String arr, String elemType) {
            String i = ctx.freshName("i");
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(125).append("\n         |").append(Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$genSequenceLengthCode(ctx, start, stop, step, i)).append("\n         |").append(arr).append(" = new ").append(elemType).append("[").append(i).append("];\n         |while (").append(i).append(" > 0) {\n         |  ").append(i).append("--;\n         |  ").append(arr).append("[").append(i).append("] = (").append(elemType).append(") (").append(start).append(" + ").append(step).append(" * ").append(i).append(");\n         |}\n         ").toString())).stripMargin();
        }

        public static final /* synthetic */ boolean $anonfun$defaultStep$1(IntegralSequenceImpl $this, Object x, Object y) {
            return $this.elemType.ordering().lteq(x, y);
        }

        public IntegralSequenceImpl(IntegralType elemType, ClassTag<T> evidence$1, Integral<T> num) {
            this.elemType = elemType;
            this.evidence$1 = evidence$1;
            this.num = num;
            this.defaultStep = new DefaultStep((Function2<Object, Object, Object>)(Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)IntegralSequenceImpl.$anonfun$defaultStep$1(this, x, y)), elemType, num.one());
        }
    }

    public static interface SequenceImpl {
        public Object eval(Object var1, Object var2, Object var3);

        public String genCode(CodegenContext var1, String var2, String var3, String var4, String var5, String var6);

        public DefaultStep defaultStep();
    }

    public static class TemporalSequenceImpl<T>
    implements SequenceImpl {
        private final IntegralType dt;
        private final long scale;
        private final Function1<Object, T> fromLong;
        private final TimeZone timeZone;
        private final ClassTag<T> evidence$2;
        private final Integral<T> num;
        private final DefaultStep defaultStep;
        private final IntegralSequenceImpl<T> backedSequenceImpl;
        private final long microsPerMonth;

        @Override
        public DefaultStep defaultStep() {
            return this.defaultStep;
        }

        private IntegralSequenceImpl<T> backedSequenceImpl() {
            return this.backedSequenceImpl;
        }

        private long microsPerMonth() {
            return this.microsPerMonth;
        }

        @Override
        public Object eval(Object input1, Object input2, Object input3) {
            Object object;
            Object start = input1;
            Object stop = input2;
            CalendarInterval step = (CalendarInterval)input3;
            int stepMonths = step.months;
            long stepMicros = step.microseconds;
            if (stepMonths == 0) {
                object = this.backedSequenceImpl().eval(start, stop, this.fromLong.apply((Object)BoxesRunTime.boxToLong((long)(stepMicros / this.scale))));
            } else {
                long intervalStepInMicros = stepMicros + (long)stepMonths * this.microsPerMonth();
                long startMicros = this.num.toLong(start) * this.scale;
                long stopMicros = this.num.toLong(stop) * this.scale;
                int maxEstimatedArrayLength = Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$getSequenceLength(BoxesRunTime.boxToLong((long)startMicros), BoxesRunTime.boxToLong((long)stopMicros), BoxesRunTime.boxToLong((long)intervalStepInMicros), Numeric.LongIsIntegral$.MODULE$);
                int stepSign = stopMicros > startMicros ? 1 : -1;
                long exclusiveItem = stopMicros + (long)stepSign;
                Object arr = this.evidence$2.newArray(maxEstimatedArrayLength);
                long t = startMicros;
                int i = 0;
                while (t < exclusiveItem ^ stepSign < 0) {
                    ScalaRunTime$.MODULE$.array_update(arr, i, this.fromLong.apply((Object)BoxesRunTime.boxToLong((long)(t / this.scale))));
                    t = DateTimeUtils$.MODULE$.timestampAddInterval(t, stepMonths, stepMicros, this.timeZone);
                    ++i;
                }
                object = ScalaRunTime$.MODULE$.array_length(arr) == i ? arr : Predef$.MODULE$.genericArrayOps(arr).slice(0, i);
            }
            return object;
        }

        @Override
        public String genCode(CodegenContext ctx, String start, String stop, String step, String arr, String elemType) {
            String stepMonths = ctx.freshName("stepMonths");
            String stepMicros = ctx.freshName("stepMicros");
            String stepScaled = ctx.freshName("stepScaled");
            String intervalInMicros = ctx.freshName("intervalInMicros");
            String startMicros = ctx.freshName("startMicros");
            String stopMicros = ctx.freshName("stopMicros");
            String arrLength = ctx.freshName("arrLength");
            String stepSign = ctx.freshName("stepSign");
            String exclusiveItem = ctx.freshName("exclusiveItem");
            String t = ctx.freshName("t");
            String i = ctx.freshName("i");
            String genTimeZone = ctx.addReferenceObj("timeZone", this.timeZone, TimeZone.class.getName());
            String sequenceLengthCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n           |final long ").append(intervalInMicros).append(" = ").append(stepMicros).append(" + ").append(stepMonths).append(" * ").append(this.microsPerMonth()).append("L;\n           |").append(Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$genSequenceLengthCode(ctx, startMicros, stopMicros, intervalInMicros, arrLength)).append("\n          ").toString())).stripMargin();
            String timestampAddIntervalCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(120).append("\n           |").append(t).append(" = org.apache.spark.sql.catalyst.util.DateTimeUtils.timestampAddInterval(\n           |  ").append(t).append(", ").append(stepMonths).append(", ").append(stepMicros).append(", ").append(genTimeZone).append(");\n          ").toString())).stripMargin();
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(677).append("\n         |final int ").append(stepMonths).append(" = ").append(step).append(".months;\n         |final long ").append(stepMicros).append(" = ").append(step).append(".microseconds;\n         |\n         |if (").append(stepMonths).append(" == 0) {\n         |  final ").append(elemType).append(" ").append(stepScaled).append(" = (").append(elemType).append(") (").append(stepMicros).append(" / ").append(this.scale).append("L);\n         |  ").append(this.backedSequenceImpl().genCode(ctx, start, stop, stepScaled, arr, elemType)).append(";\n         |\n         |} else {\n         |  final long ").append(startMicros).append(" = ").append(start).append(" * ").append(this.scale).append("L;\n         |  final long ").append(stopMicros).append(" = ").append(stop).append(" * ").append(this.scale).append("L;\n         |\n         |  ").append(sequenceLengthCode).append("\n         |\n         |  final int ").append(stepSign).append(" = ").append(stopMicros).append(" > ").append(startMicros).append(" ? +1 : -1;\n         |  final long ").append(exclusiveItem).append(" = ").append(stopMicros).append(" + ").append(stepSign).append(";\n         |\n         |  ").append(arr).append(" = new ").append(elemType).append("[").append(arrLength).append("];\n         |  long ").append(t).append(" = ").append(startMicros).append(";\n         |  int ").append(i).append(" = 0;\n         |\n         |  while (").append(t).append(" < ").append(exclusiveItem).append(" ^ ").append(stepSign).append(" < 0) {\n         |    ").append(arr).append("[").append(i).append("] = (").append(elemType).append(") (").append(t).append(" / ").append(this.scale).append("L);\n         |    ").append(timestampAddIntervalCode).append("\n         |    ").append(i).append(" += 1;\n         |  }\n         |\n         |  if (").append(arr).append(".length > ").append(i).append(") {\n         |    ").append(arr).append(" = java.util.Arrays.copyOf(").append(arr).append(", ").append(i).append(");\n         |  }\n         |}\n         ").toString())).stripMargin();
        }

        public static final /* synthetic */ boolean $anonfun$defaultStep$2(TemporalSequenceImpl $this, Object x, Object y) {
            return $this.dt.ordering().lteq(x, y);
        }

        public TemporalSequenceImpl(IntegralType dt, long scale, Function1<Object, T> fromLong, TimeZone timeZone, ClassTag<T> evidence$2, Integral<T> num) {
            this.dt = dt;
            this.scale = scale;
            this.fromLong = fromLong;
            this.timeZone = timeZone;
            this.evidence$2 = evidence$2;
            this.num = num;
            this.defaultStep = new DefaultStep((Function2<Object, Object, Object>)(Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)TemporalSequenceImpl.$anonfun$defaultStep$2(this, x, y)), CalendarIntervalType$.MODULE$, new CalendarInterval(0, 86400000000L));
            this.backedSequenceImpl = new IntegralSequenceImpl<T>(dt, evidence$2, num);
            this.microsPerMonth = 2419200000000L;
        }
    }
}

