/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Sha1$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns a sha1 hash value as a hex string of the `expr`.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark');\n       85f5955f4b27a9a4c2aab6ffe5d7189fc298b92c\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\f\u0019\u0001\u0016B\u0001B\u000e\u0001\u0003\u0016\u0004%\ta\u000e\u0005\tw\u0001\u0011\t\u0012)A\u0005q!)A\b\u0001C\u0001{!)\u0001\t\u0001C!\u0003\")\u0001\n\u0001C!\u0013\")a\u000b\u0001C)/\")Q\f\u0001C!=\"9A\u000eAA\u0001\n\u0003i\u0007bB8\u0001#\u0003%\t\u0001\u001d\u0005\bw\u0002\t\t\u0011\"\u0011}\u0011%\tY\u0001AA\u0001\n\u0003\ti\u0001C\u0005\u0002\u0016\u0001\t\t\u0011\"\u0001\u0002\u0018!I\u0011Q\u0004\u0001\u0002\u0002\u0013\u0005\u0013q\u0004\u0005\n\u0003[\u0001\u0011\u0011!C\u0001\u0003_A\u0011\"!\u000f\u0001\u0003\u0003%\t%a\u000f\b\u0013\u0005M\u0003$!A\t\u0002\u0005Uc\u0001C\f\u0019\u0003\u0003E\t!a\u0016\t\rq\nB\u0011AA3\u0011%\t9'EA\u0001\n\u000b\nI\u0007C\u0005\u0002lE\t\t\u0011\"!\u0002n!I\u0011\u0011O\t\u0002\u0002\u0013\u0005\u00151\u000f\u0005\n\u0003\u007f\n\u0012\u0011!C\u0005\u0003\u0003\u0013Aa\u00155bc)\u0011\u0011DG\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u001c9\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u001e=\u0005\u00191/\u001d7\u000b\u0005}\u0001\u0013!B:qCJ\\'BA\u0011#\u0003\u0019\t\u0007/Y2iK*\t1%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001M)j3\u0007\u0005\u0002(Q5\t\u0001$\u0003\u0002*1\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002(W%\u0011A\u0006\u0007\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t9\u0001K]8ek\u000e$\bC\u0001\u00185\u0013\t)tF\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003dQ&dG-F\u00019!\t9\u0013(\u0003\u0002;1\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003\u0019a\u0014N\\5u}Q\u0011ah\u0010\t\u0003O\u0001AQAN\u0002A\u0002a\n\u0001\u0002Z1uCRK\b/Z\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\u0011Q\tH\u0001\u0006if\u0004Xm]\u0005\u0003\u000f\u0012\u0013\u0001\u0002R1uCRK\b/Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u0001&\u0011\u0007-\u001b&I\u0004\u0002M#:\u0011Q\nU\u0007\u0002\u001d*\u0011q\nJ\u0001\u0007yI|w\u000e\u001e \n\u0003AJ!AU\u0018\u0002\u000fA\f7m[1hK&\u0011A+\u0016\u0002\u0004'\u0016\f(B\u0001*0\u00031qW\u000f\u001c7TC\u001a,WI^1m)\tA6\f\u0005\u0002/3&\u0011!l\f\u0002\u0004\u0003:L\b\"\u0002/\u0007\u0001\u0004A\u0016!B5oaV$\u0018!\u00033p\u000f\u0016t7i\u001c3f)\ryVM\u001b\t\u0003A\u000el\u0011!\u0019\u0006\u0003Eb\tqaY8eK\u001e,g.\u0003\u0002eC\nAQ\t\u001f9s\u0007>$W\rC\u0003g\u000f\u0001\u0007q-A\u0002dib\u0004\"\u0001\u00195\n\u0005%\f'AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006W\u001e\u0001\raX\u0001\u0003KZ\fAaY8qsR\u0011aH\u001c\u0005\bm!\u0001\n\u00111\u00019\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012!\u001d\u0016\u0003qI\\\u0013a\u001d\t\u0003ifl\u0011!\u001e\u0006\u0003m^\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005a|\u0013AC1o]>$\u0018\r^5p]&\u0011!0\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001~!\rq\u0018qA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0011\u0001\u00026bm\u0006L1!!\u0003\u0000\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0002\t\u0004]\u0005E\u0011bAA\n_\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019\u0001,!\u0007\t\u0013\u0005mA\"!AA\u0002\u0005=\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\"A)\u00111EA\u001516\u0011\u0011Q\u0005\u0006\u0004\u0003Oy\u0013AC2pY2,7\r^5p]&!\u00111FA\u0013\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005E\u0012q\u0007\t\u0004]\u0005M\u0012bAA\u001b_\t9!i\\8mK\u0006t\u0007\u0002CA\u000e\u001d\u0005\u0005\t\u0019\u0001-\u0002\r\u0015\fX/\u00197t)\u0011\t\t$!\u0010\t\u0011\u0005mq\"!AA\u0002aC3\u0002AA!\u0003\u000f\nI%!\u0014\u0002PA\u0019q%a\u0011\n\u0007\u0005\u0015\u0003DA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005-\u0013aR0G+:\u001bu\fK3yaJL\u0003%\f\u0011SKR,(O\\:!C\u0002\u001a\b.Y\u0019!Q\u0006\u001c\b\u000e\t<bYV,\u0007%Y:!C\u0002BW\r\u001f\u0011tiJLgn\u001a\u0011pM\u0002\"\b.\u001a\u0011aKb\u0004(\u000f\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!\u0015\u0002C*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u00159be.<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00119k\u0019,\u0014(N\u001bgi\t\u0014t'Y\u001dbi\r\u0014\u0014-\u001927M\u001a,W\u0007Z\u001c2qe27MM\u001d9Ef\u00124M\u0003\u0011!\u0003\u0011\u0019\u0006.Y\u0019\u0011\u0005\u001d\n2\u0003B\t\u0002ZM\u0002b!a\u0017\u0002barTBAA/\u0015\r\tyfL\u0001\beVtG/[7f\u0013\u0011\t\u0019'!\u0018\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0002V\u0005AAo\\*ue&tw\rF\u0001~\u0003\u0015\t\u0007\u000f\u001d7z)\rq\u0014q\u000e\u0005\u0006mQ\u0001\r\u0001O\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t)(a\u001f\u0011\t9\n9\bO\u0005\u0004\u0003sz#AB(qi&|g\u000e\u0003\u0005\u0002~U\t\t\u00111\u0001?\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0004B\u0019a0!\"\n\u0007\u0005\u001duP\u0001\u0004PE*,7\r\u001e")
public class Sha1
extends UnaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Sha1 sha1) {
        return Sha1$.MODULE$.unapply(sha1);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Sha1, A> function1) {
        return Sha1$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Sha1> compose(Function1<A, Expression> function1) {
        return Sha1$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BinaryType$[]{BinaryType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object input) {
        return UTF8String.fromString((String)DigestUtils.sha1Hex((byte[])((byte[])input)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(76).append("UTF8String.fromString(org.apache.commons.codec.digest.DigestUtils.sha1Hex(").append((String)c).append("))").toString());
    }

    public Sha1 copy(Expression child) {
        return new Sha1(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Sha1";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sha1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sha1)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sha1 sha1 = (Sha1)x$1;
        Expression expression = this.child();
        Expression expression2 = sha1.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!sha1.canEqual(this)) return false;
        return true;
    }

    public Sha1(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

