/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrim$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading and trailing space characters from `str`.\n\n    _FUNC_(BOTH trimStr FROM str) - Remove the leading and trailing `trimStr` characters from `str`\n\n    _FUNC_(LEADING trimStr FROM str) - Remove the leading `trimStr` characters from `str`\n\n    _FUNC_(TRAILING trimStr FROM str) - Remove the trailing `trimStr` characters from `str`\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n      * BOTH, FROM - these are keywords to specify trimming string characters from both ends of\n          the string\n      * LEADING, FROM - these are keywords to specify trimming string characters from the left\n          end of the string\n      * TRAILING, FROM - these are keywords to specify trimming string characters from the right\n          end of the string\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_('SL', 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(BOTH 'SL' FROM 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(LEADING 'SL' FROM 'SSparkSQLS');\n       parkSQLS\n      > SELECT _FUNC_(TRAILING 'SL' FROM 'SSparkSQLS');\n       SSparkSQ\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Mw!B\u0010!\u0011\u0003ic!B\u0018!\u0011\u0003\u0001\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004\"\u0002\u001f\u0002\t\u0003i\u0004B\u0002\u001f\u0002\t\u0003\tY\u000b\u0003\u0005=\u0003\u0005\u0005I\u0011QAX\u0011%\t),AI\u0001\n\u0003\tY\u0004C\u0005\u00028\u0006\t\t\u0011\"!\u0002:\"I\u0011qY\u0001\u0012\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u0013\f\u0011\u0011!C\u0005\u0003\u00174Aa\f\u0011A\u007f!A\u0011J\u0003BK\u0002\u0013\u0005!\n\u0003\u0005L\u0015\tE\t\u0015!\u0003A\u0011!a%B!f\u0001\n\u0003i\u0005\u0002C)\u000b\u0005#\u0005\u000b\u0011\u0002(\t\u000biRA\u0011\u0001*\t\u000biRA\u0011A+\t\u000biRA\u0011\u0001-\t\u000biSA\u0011I.\t\u000b\u001dTA\u0011\t5\t\u000bITA\u0011I:\t\u000buTA\u0011\t@\t\u0013\u0005e!\"!A\u0005\u0002\u0005m\u0001\"CA\u0011\u0015E\u0005I\u0011AA\u0012\u0011%\tIDCI\u0001\n\u0003\tY\u0004C\u0005\u0002@)\t\t\u0011\"\u0011\u0002B!I\u0011\u0011\u000b\u0006\u0002\u0002\u0013\u0005\u00111\u000b\u0005\n\u00037R\u0011\u0011!C\u0001\u0003;B\u0011\"a\u0019\u000b\u0003\u0003%\t%!\u001a\t\u0013\u0005M$\"!A\u0005\u0002\u0005U\u0004\"CA@\u0015\u0005\u0005I\u0011IAA\u0003)\u0019FO]5oOR\u0013\u0018.\u001c\u0006\u0003C\t\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0005J\u0001\tG\u0006$\u0018\r\\=ti*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001A\u0011a&A\u0007\u0002A\tQ1\u000b\u001e:j]\u001e$&/[7\u0014\u0007\u0005\tt\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VM\u001a\t\u0003eaJ!!O\u001a\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005i\u0013!B1qa2LH#\u0002 \u0002&\u0006%\u0006C\u0001\u0018\u000b'\u0015Q\u0001i\u0011$8!\tq\u0013)\u0003\u0002CA\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00059\"\u0015BA#!\u0005U\u0019FO]5oOJ\"&/[7FqB\u0014Xm]:j_:\u0004\"AM$\n\u0005!\u001b$a\u0002)s_\u0012,8\r^\u0001\u0007gJ\u001c7\u000b\u001e:\u0016\u0003\u0001\u000bqa\u001d:d'R\u0014\b%A\u0004ue&l7\u000b\u001e:\u0016\u00039\u00032AM(A\u0013\t\u00016G\u0001\u0004PaRLwN\\\u0001\tiJLWn\u0015;sAQ\u0019ah\u0015+\t\u000b%{\u0001\u0019\u0001!\t\u000f1{\u0001\u0013!a\u0001\u001dR\u0019aHV,\t\u000b1\u0003\u0002\u0019\u0001!\t\u000b%\u0003\u0002\u0019\u0001!\u0015\u0005yJ\u0006\"B%\u0012\u0001\u0004\u0001\u0015A\u00039sKR$\u0018PT1nKV\tA\f\u0005\u0002^I:\u0011aL\u0019\t\u0003?Nj\u0011\u0001\u0019\u0006\u0003C2\na\u0001\u0010:p_Rt\u0014BA24\u0003\u0019\u0001&/\u001a3fM&\u0011QM\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\r\u001c\u0014\u0001C2iS2$'/\u001a8\u0016\u0003%\u00042A[8A\u001d\tYWN\u0004\u0002`Y&\tA'\u0003\u0002og\u00059\u0001/Y2lC\u001e,\u0017B\u00019r\u0005\r\u0019V-\u001d\u0006\u0003]N\nA!\u001a<bYR\u0011Ao\u001e\t\u0003eUL!A^\u001a\u0003\u0007\u0005s\u0017\u0010C\u0004y)A\u0005\t\u0019A=\u0002\u000b%t\u0007/\u001e;\u0011\u0005i\\X\"\u0001\u0012\n\u0005q\u0014#aC%oi\u0016\u0014h.\u00197S_^\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u000b}\fY!!\u0006\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002!\u0003\u001d\u0019w\u000eZ3hK:LA!!\u0003\u0002\u0004\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002\u000eU\u0001\r!a\u0004\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\u0002\u0005E\u0011\u0002BA\n\u0003\u0007\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\u0018U\u0001\ra`\u0001\u0003KZ\fAaY8qsR)a(!\b\u0002 !9\u0011J\u0006I\u0001\u0002\u0004\u0001\u0005b\u0002'\u0017!\u0003\u0005\rAT\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)CK\u0002A\u0003OY#!!\u000b\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003g\u0019\u0014AC1o]>$\u0018\r^5p]&!\u0011qGA\u0017\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tiDK\u0002O\u0003O\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\"!\u0011\t)%a\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\nA\u0001\\1oO*\u0011\u0011QJ\u0001\u0005U\u00064\u0018-C\u0002f\u0003\u000f\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0016\u0011\u0007I\n9&C\u0002\u0002ZM\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001^A0\u0011%\t\tgGA\u0001\u0002\u0004\t)&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003O\u0002R!!\u001b\u0002pQl!!a\u001b\u000b\u0007\u000554'\u0001\u0006d_2dWm\u0019;j_:LA!!\u001d\u0002l\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9(! \u0011\u0007I\nI(C\u0002\u0002|M\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002bu\t\t\u00111\u0001u\u0003\u0019)\u0017/^1mgR!\u0011qOAB\u0011!\t\tGHA\u0001\u0002\u0004!\bf\u0005\u0006\u0002\b\u00065\u0015qRAJ\u0003+\u000bI*a'\u0002 \u0006\u0005\u0006c\u0001\u0018\u0002\n&\u0019\u00111\u0012\u0011\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011S\u0001\u0003b*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tiJL\u0003%\f\u0011SK6|g/Z:!i\",\u0007\u0005\\3bI&tw\rI1oI\u0002\"(/Y5mS:<\u0007e\u001d9bG\u0016\u00043\r[1sC\u000e$XM]:!MJ|W\u000e\t1tiJ\u0004gF\u0003\u0006!A\u0001\u0002sLR+O\u0007~C#i\u0014+IAQ\u0014\u0018.\\*ue\u00022%kT'!gR\u0014\u0018\u0006I\u0017!%\u0016lwN^3!i\",\u0007\u0005\\3bI&tw\rI1oI\u0002\"(/Y5mS:<\u0007\u0005\u0019;sS6\u001cFO\u001d1!G\"\f'/Y2uKJ\u001c\bE\u001a:p[\u0002\u00027\u000f\u001e:a\u0015)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015M\u000b\u0006#\u0015JT$!iJLWn\u0015;sA\u0019\u0013v*\u0014\u0011tiJL\u0003%\f\u0011SK6|g/\u001a\u0011uQ\u0016\u0004C.Z1eS:<\u0007\u0005\u0019;sS6\u001cFO\u001d1!G\"\f'/Y2uKJ\u001c\bE\u001a:p[\u0002\u00027\u000f\u001e:a\u0015)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015U%\u0006KE*\u0013(HAQ\u0014\u0018.\\*ue\u00022%kT'!gR\u0014\u0018\u0006I\u0017!%\u0016lwN^3!i\",\u0007\u0005\u001e:bS2Lgn\u001a\u0011aiJLWn\u0015;sA\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005Y:ue\u0002T\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#!a&\u0002\u0007oT\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I:ue\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:T\u0001\u0005\t\u0011!A\u0001R\u0003\u0005\u001e:j[N#(\u000fI\u0017!i\",\u0007\u0005\u001e:j[\u0002\u001aHO]5oO\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011u_\u0002\"(/[7-AQDW\r\t3fM\u0006,H\u000e\u001e\u0011wC2,X\rI5tA\u0005\u00043/\u001b8hY\u0016\u00043\u000f]1dK*\u0001\u0003\u0005\t\u0011!A)\u0002#i\u0014+IY\u00012%kT'![\u0001\"\b.Z:fA\u0005\u0014X\rI6fs^|'\u000fZ:!i>\u00043\u000f]3dS\u001aL\b\u0005\u001e:j[6Lgn\u001a\u0011tiJLgn\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004cM]8nA\t|G\u000f\u001b\u0011f]\u0012\u001c\be\u001c4\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C\u000f[3!gR\u0014\u0018N\\4\u000bA\u0001\u0002\u0003\u0005\t\u0011+A1+\u0015\tR%O\u000f2\u0002cIU(NA5\u0002C\u000f[3tK\u0002\n'/\u001a\u0011lKf<xN\u001d3tAQ|\u0007e\u001d9fG&4\u0017\u0010\t;sS6l\u0017N\\4!gR\u0014\u0018N\\4!G\"\f'/Y2uKJ\u001c\bE\u001a:p[\u0002\"\b.\u001a\u0011mK\u001a$(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!K:$\u0007e\u001c4!i\",\u0007e\u001d;sS:<'\u0002\t\u0011!A\u0001\u0002#\u0006\t+S\u0003&c\u0015JT$-A\u0019\u0013v*\u0014\u0011.AQDWm]3!CJ,\u0007e[3zo>\u0014Hm\u001d\u0011u_\u0002\u001a\b/Z2jMf\u0004CO]5n[&tw\rI:ue&tw\rI2iCJ\f7\r^3sg\u00022'o\\7!i\",\u0007E]5hQRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011f]\u0012\u0004sN\u001a\u0011uQ\u0016\u00043\u000f\u001e:j]\u001eT\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QT\u0001\u0003,*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005\t\u0011!AM\u0003\u0018M]6T#2\u0003\u0003\u0005I\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a\u0006/\u0019:l'Fc%\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014T\u0019\u001eb\u0003eJ*Ta\u0006\u00148nU)M'\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t9be.\u001c\u0016K\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015C\u001fRC\u0005eJ*MO\u00012%kT'!OM\u001b\u0006/\u0019:l'Fc5kJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AA\f'o[*R\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"bU)\u0011#J\u001d\u001e\u0003se\u0015'(A\u0019\u0013v*\u0014\u0011('N\u0003\u0018M]6T#2\u001bv%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a\u0006\u00148nU)M'*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CCKU!J\u0019&su\tI\u0014T\u0019\u001e\u0002cIU(NA\u001d\u001a6\u000b]1sWN\u000bFjU\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a6\u000b]1sWN\u000b&\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\r\u0016!B\u0019/k9\u0002\u0004BBAT\u0007\u0001\u0007\u0001)A\u0002tiJDQ\u0001T\u0002A\u0002\u0001#2APAW\u0011\u0019\t9\u000b\u0002a\u0001\u0001R)a(!-\u00024\")\u0011*\u0002a\u0001\u0001\"9A*\u0002I\u0001\u0002\u0004q\u0015aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u00111XAb!\u0011\u0011t*!0\u0011\u000bI\ny\f\u0011(\n\u0007\u0005\u00057G\u0001\u0004UkBdWM\r\u0005\t\u0003\u000b<\u0011\u0011!a\u0001}\u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u00055\u0007\u0003BA#\u0003\u001fLA!!5\u0002H\t1qJ\u00196fGR\u0004")
public class StringTrim
extends Expression
implements String2TrimExpression,
scala.Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrim$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrim stringTrim) {
        return StringTrim$.MODULE$.unapply(stringTrim);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrim$.MODULE$.apply$default$2();
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression srcStr() {
        return this.srcStr;
    }

    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "trim";
    }

    @Override
    public Seq<Expression> children() {
        List list;
        if (this.trimStr().isDefined()) {
            Expression expression = this.srcStr();
            Expression expression2 = (Expression)this.trimStr().get();
            list = Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
        } else {
            Expression expression = this.srcStr();
            list = Nil$.MODULE$.$colon$colon((Object)expression);
        }
        return list;
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String srcString = (UTF8String)this.srcStr().eval(input);
        return srcString == null ? null : (this.trimStr().isDefined() ? srcString.trim((UTF8String)((Expression)this.trimStr().get()).eval(input)) : srcString.trim());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Seq evals = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$32 -> x$32.genCode(ctx), Seq$.MODULE$.canBuildFrom());
        ExprCode srcString = (ExprCode)evals.apply(0);
        if (evals.length() == 1) {
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$33 -> x$33.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trim();\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), ev.value(), srcString.value()})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        } else {
            ExprCode trimString = (ExprCode)evals.apply(1);
            String getTrimFunction = new StringBuilder(84).append("\n        if (").append(trimString.isNull()).append(") {\n          ").append(ev.isNull()).append(" = true;\n        } else {\n          ").append(ev.value()).append(" = ").append(srcString.value()).append(".trim(").append(trimString.value()).append(");\n        }").toString();
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$34 -> x$34.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), getTrimFunction})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        }
        return exprCode;
    }

    public StringTrim copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrim(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrim";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.srcStr();
                break;
            }
            case 1: {
                option = this.trimStr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrim;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrim)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrim stringTrim = (StringTrim)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrim.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrim.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrim.canEqual(this)) return false;
        return true;
    }

    public StringTrim(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
    }

    public StringTrim(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrim(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

