/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;

public final class UDTRegistration$
implements Serializable,
Logging {
    public static UDTRegistration$ MODULE$;
    private Map<String, String> udtMap;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new UDTRegistration$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Map<String, String> udtMap$lzycompute() {
        UDTRegistration$ uDTRegistration$ = this;
        synchronized (uDTRegistration$) {
            if (!this.bitmap$0) {
                this.udtMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"org.apache.spark.ml.linalg.Vector", (Object)"org.apache.spark.ml.linalg.VectorUDT"), new Tuple2((Object)"org.apache.spark.ml.linalg.DenseVector", (Object)"org.apache.spark.ml.linalg.VectorUDT"), new Tuple2((Object)"org.apache.spark.ml.linalg.SparseVector", (Object)"org.apache.spark.ml.linalg.VectorUDT"), new Tuple2((Object)"org.apache.spark.ml.linalg.Matrix", (Object)"org.apache.spark.ml.linalg.MatrixUDT"), new Tuple2((Object)"org.apache.spark.ml.linalg.DenseMatrix", (Object)"org.apache.spark.ml.linalg.MatrixUDT"), new Tuple2((Object)"org.apache.spark.ml.linalg.SparseMatrix", (Object)"org.apache.spark.ml.linalg.MatrixUDT")}));
                this.bitmap$0 = true;
            }
        }
        return this.udtMap;
    }

    private Map<String, String> udtMap() {
        return !this.bitmap$0 ? this.udtMap$lzycompute() : this.udtMap;
    }

    public boolean exists(String userClassName) {
        return this.udtMap().contains((Object)userClassName);
    }

    public void register(String userClass, String udtClass) {
        if (this.udtMap().contains((Object)userClass)) {
            this.logWarning((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(54).append("Cannot register UDT for ").append(userClass).append(", which is already registered.").toString());
        } else {
            this.udtMap().$plus$eq(new Tuple2((Object)userClass, (Object)udtClass));
        }
    }

    public Option<Class<?>> getUDTFor(String userClass) {
        return this.udtMap().get((Object)userClass).map((Function1 & java.io.Serializable & Serializable)udtClassName -> {
            Class udtClass;
            if (Utils$.MODULE$.classIsLoadable(udtClassName)) {
                udtClass = Utils$.MODULE$.classForName(udtClassName);
                if (!UserDefinedType.class.isAssignableFrom(udtClass)) {
                    throw new SparkException(new StringBuilder(57).append(udtClass.getName()).append(" is not an UserDefinedType. Please make sure registering ").append(new StringBuilder(23).append("an UserDefinedType for ").append(userClass).toString()).toString());
                }
            } else {
                throw new SparkException(new StringBuilder(49).append("Can not load in UserDefinedType ").append((String)udtClassName).append(" for user class ").append(userClass).append(".").toString());
            }
            return udtClass;
        });
    }

    private Object readResolve() {
        return MODULE$;
    }

    private UDTRegistration$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

