/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    expr1 _FUNC_ expr2 - Returns same result as the EQUAL(=) operator for non-null operands,\n      but returns true if both are null, false if one of the them is null.\n  ", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be used in equality comparison. Map type is not supported.\n          For complex types such array/struct, the data types of fields must be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1 _FUNC_ '1';\n       true\n      > SELECT true _FUNC_ NULL;\n       false\n      > SELECT NULL _FUNC_ NULL;\n       true\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001\u0002\u000e\u001c\u0001\"B\u0001B\u000e\u0001\u0003\u0016\u0004%\ta\u000e\u0005\tw\u0001\u0011\t\u0012)A\u0005q!AA\b\u0001BK\u0002\u0013\u0005q\u0007\u0003\u0005>\u0001\tE\t\u0015!\u00039\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u001dy\u0007!!A\u0005\u0002ADqa\u001d\u0001\u0012\u0002\u0013\u0005A\u000fC\u0004\u0000\u0001E\u0005I\u0011\u0001;\t\u0013\u0005\u0005\u0001!!A\u0005B\u0005\r\u0001\"CA\n\u0001\u0005\u0005I\u0011AA\u000b\u0011%\ti\u0002AA\u0001\n\u0003\ty\u0002C\u0005\u0002&\u0001\t\t\u0011\"\u0011\u0002(!I\u0011Q\u0007\u0001\u0002\u0002\u0013\u0005\u0011q\u0007\u0005\n\u0003w\u0001\u0011\u0011!C!\u0003{9\u0011\"a\u0017\u001c\u0003\u0003E\t!!\u0018\u0007\u0011iY\u0012\u0011!E\u0001\u0003?BaA\u0010\u000b\u0005\u0002\u00055\u0004\"CA8)\u0005\u0005IQIA9\u0011%\t\u0019\bFA\u0001\n\u0003\u000b)\bC\u0005\u0002|Q\t\t\u0011\"!\u0002~!I\u0011q\u0012\u000b\u0002\u0002\u0013%\u0011\u0011\u0013\u0002\u000e\u000bF,\u0018\r\u001c(vY2\u001c\u0016MZ3\u000b\u0005qi\u0012aC3yaJ,7o]5p]NT!AH\u0010\u0002\u0011\r\fG/\u00197zgRT!\u0001I\u0011\u0002\u0007M\fHN\u0003\u0002#G\u0005)1\u000f]1sW*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u0015.gA\u0011!fK\u0007\u00027%\u0011Af\u0007\u0002\u0011\u0005&t\u0017M]=D_6\u0004\u0018M]5t_:\u0004\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002/i%\u0011Qg\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005Y\u00164G/F\u00019!\tQ\u0013(\u0003\u0002;7\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003\u0019a\u0014N\\5u}Q\u0019\u0001)\u0011\"\u0011\u0005)\u0002\u0001\"\u0002\u001c\u0006\u0001\u0004A\u0004\"\u0002\u001f\u0006\u0001\u0004A\u0014AB:z[\n|G.F\u0001F!\t1UJ\u0004\u0002H\u0017B\u0011\u0001jL\u0007\u0002\u0013*\u0011!jJ\u0001\u0007yI|w\u000e\u001e \n\u00051{\u0013A\u0002)sK\u0012,g-\u0003\u0002O\u001f\n11\u000b\u001e:j]\u001eT!\u0001T\u0018\u0002\u00119,H\u000e\\1cY\u0016,\u0012A\u0015\t\u0003]MK!\u0001V\u0018\u0003\u000f\t{w\u000e\\3b]\u0006!QM^1m)\t9&\f\u0005\u0002/1&\u0011\u0011l\f\u0002\u0004\u0003:L\bbB.\t!\u0003\u0005\r\u0001X\u0001\u0006S:\u0004X\u000f\u001e\t\u0003;zk\u0011!H\u0005\u0003?v\u00111\"\u00138uKJt\u0017\r\u001c*po\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0004E\"l\u0007CA2g\u001b\u0005!'BA3\u001c\u0003\u001d\u0019w\u000eZ3hK:L!a\u001a3\u0003\u0011\u0015C\bO]\"pI\u0016DQ![\u0005A\u0002)\f1a\u0019;y!\t\u00197.\u0003\u0002mI\nq1i\u001c3fO\u0016t7i\u001c8uKb$\b\"\u00028\n\u0001\u0004\u0011\u0017AA3w\u0003\u0011\u0019w\u000e]=\u0015\u0007\u0001\u000b(\u000fC\u00047\u0015A\u0005\t\u0019\u0001\u001d\t\u000fqR\u0001\u0013!a\u0001q\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A;+\u0005a28&A<\u0011\u0005alX\"A=\u000b\u0005i\\\u0018!C;oG\",7m[3e\u0015\tax&\u0001\u0006b]:|G/\u0019;j_:L!A`=\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0001\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001f\tAA[1wC&\u0019a*!\u0003\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005]\u0001c\u0001\u0018\u0002\u001a%\u0019\u00111D\u0018\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007]\u000b\t\u0003C\u0005\u0002$=\t\t\u00111\u0001\u0002\u0018\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u000b\u0011\u000b\u0005-\u0012\u0011G,\u000e\u0005\u00055\"bAA\u0018_\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0012Q\u0006\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002S\u0003sA\u0001\"a\t\u0012\u0003\u0003\u0005\raV\u0001\u0007KF,\u0018\r\\:\u0015\u0007I\u000by\u0004\u0003\u0005\u0002$I\t\t\u00111\u0001XQ=\u0001\u00111IA%\u0003\u0017\ny%!\u0015\u0002V\u0005]\u0003c\u0001\u0016\u0002F%\u0019\u0011qI\u000e\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QJ\u0001\u0002X)\u0001\u0003\u0005\t\u0011fqB\u0014\u0018\u0007I0G+:\u001bu\fI3yaJ\u0014\u0004%\f\u0011SKR,(O\\:!g\u0006lW\r\t:fgVdG\u000fI1tAQDW\rI#R+\u0006c\u0005&P\u0015!_B,'/\u0019;pe\u00022wN\u001d\u0011o_:lc.\u001e7mA=\u0004XM]1oINd#\u0002\t\u0011!A\u0001\u0002#-\u001e;!e\u0016$XO\u001d8tAQ\u0014X/\u001a\u0011jM\u0002\u0012w\u000e\u001e5!CJ,\u0007E\\;mY2\u0002c-\u00197tK\u0002Jg\rI8oK\u0002zg\r\t;iK\u0002\"\b.Z7!SN\u0004c.\u001e7m])\u0001\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u00111K\u0001\u0003^)\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003%\u001a=qeFb\u0003%\u001a=qeJ\u0002S\u0006\t;iK\u0002\"xo\u001c\u0011fqB\u0014Xm]:j_:\u001c\b%\\;ti\u0002\u0012W\rI:b[\u0016\u0004C/\u001f9fA=\u0014\beY1oA\t,\u0007eY1ti\u0016$\u0007\u0005^8!C\u0002\u001aw.\\7p]\u0002\"\u0018\u0010]3-\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u00198eA5,8\u000f\u001e\u0011cK\u0002\n\u0007\u0005^=qK\u0002\"\b.\u0019;!G\u0006t\u0007EY3!kN,G\rI5oA\u0015\fX/\u00197jif\u00043m\\7qCJL7o\u001c8/A5\u000b\u0007\u000f\t;za\u0016\u0004\u0013n\u001d\u0011o_R\u00043/\u001e9q_J$X\r\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002ci\u001c:!G>l\u0007\u000f\\3yAQL\b/Z:!gV\u001c\u0007\u000eI1se\u0006Lxf\u001d;sk\u000e$H\u0006\t;iK\u0002\"\u0017\r^1!if\u0004Xm\u001d\u0011pM\u00022\u0017.\u001a7eg\u0002jWo\u001d;!E\u0016\u0004sN\u001d3fe\u0006\u0014G.\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u00033\n\u0011\u0011\u0010\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!e\u0001zf)\u0016(D?\u0002\u00124H\u0003\u0011!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006%\r\u0011`\rVs5i\u0018\u0011(c\u001dZ$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003CO];fA}3UKT\"`A9+F\nT\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!M\u0006d7/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!\u001dVcE\nI0G+:\u001bu\f\t(V\u00192[$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003%A\u0007FcV\fGNT;mYN\u000bg-\u001a\t\u0003UQ\u0019B\u0001FA1gA9\u00111MA5qa\u0002UBAA3\u0015\r\t9gL\u0001\beVtG/[7f\u0013\u0011\tY'!\u001a\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002^\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u0006\u0005)\u0011\r\u001d9msR)\u0001)a\u001e\u0002z!)ag\u0006a\u0001q!)Ah\u0006a\u0001q\u00059QO\\1qa2LH\u0003BA@\u0003\u0017\u0003RALAA\u0003\u000bK1!a!0\u0005\u0019y\u0005\u000f^5p]B)a&a\"9q%\u0019\u0011\u0011R\u0018\u0003\rQ+\b\u000f\\33\u0011!\ti\tGA\u0001\u0002\u0004\u0001\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\u0019\n\u0005\u0003\u0002\b\u0005U\u0015\u0002BAL\u0003\u0013\u0011aa\u00142kK\u000e$\b")
public class EqualNullSafe
extends BinaryComparison
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(EqualNullSafe equalNullSafe) {
        return EqualNullSafe$.MODULE$.unapply(equalNullSafe);
    }

    public static Function1<Tuple2<Expression, Expression>, EqualNullSafe> tupled() {
        return EqualNullSafe$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, EqualNullSafe>> curried() {
        return EqualNullSafe$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "<=>";
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object eval(InternalRow input) {
        Object input1 = this.left().eval(input);
        Object input2 = this.right().eval(input);
        return input1 == null && input2 == null ? BoxesRunTime.boxToBoolean((boolean)true) : (input1 == null || input2 == null ? BoxesRunTime.boxToBoolean((boolean)false) : BoxesRunTime.boxToBoolean((boolean)this.ordering().equiv(input1, input2)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval1 = this.left().genCode(ctx);
        ExprCode eval2 = this.right().genCode(ctx);
        String equalCode = ctx.genEqual(this.left().dataType(), ExprValue$.MODULE$.exprValueToString(eval1.value()), ExprValue$.MODULE$.exprValueToString(eval2.value()));
        return ev.copy(eval1.code().$plus(eval2.code()).$plus(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = (", " && ", ") ||\n           (!", " && !", " && ", ");"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), eval1.isNull(), eval2.isNull(), eval1.isNull(), eval2.isNull(), equalCode}))), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    public EqualNullSafe copy(Expression left, Expression right) {
        return new EqualNullSafe(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "EqualNullSafe";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EqualNullSafe;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EqualNullSafe)) return false;
        boolean bl = true;
        if (!bl) return false;
        EqualNullSafe equalNullSafe = (EqualNullSafe)x$1;
        Expression expression = this.left();
        Expression expression2 = equalNullSafe.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = equalNullSafe.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!equalNullSafe.canEqual(this)) return false;
        return true;
    }

    public EqualNullSafe(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

