/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RDG;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([seed]) - Returns a random value with independent and identically distributed (i.i.d.) uniformly distributed values in [0, 1).", examples="\n    Examples:\n      > SELECT _FUNC_();\n       0.9629742951434543\n      > SELECT _FUNC_(0);\n       0.8446490682263027\n      > SELECT _FUNC_(null);\n       0.8446490682263027\n  ", note="The function is non-deterministic in general case.", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001\u0002\r\u001a\u0001\u001aB\u0001b\u000e\u0001\u0003\u0016\u0004%\t\u0001\u000f\u0005\ty\u0001\u0011\t\u0012)A\u0005s!)Q\b\u0001C\u0001}!)Q\b\u0001C\u0001\u0003\")!\t\u0001C!\u0007\")\u0011\n\u0001C)\u0015\")A\u000b\u0001C!+\")1\r\u0001C!\u0003\"9A\rAA\u0001\n\u0003)\u0007bB4\u0001#\u0003%\t\u0001\u001b\u0005\bg\u0002\t\t\u0011\"\u0011u\u0011\u001di\b!!A\u0005\u0002yD\u0011\"!\u0002\u0001\u0003\u0003%\t!a\u0002\t\u0013\u0005M\u0001!!A\u0005B\u0005U\u0001\"CA\u0012\u0001\u0005\u0005I\u0011AA\u0013\u0011%\ty\u0003AA\u0001\n\u0003\n\tdB\u0004\u0002VeA\t!a\u0016\u0007\raI\u0002\u0012AA-\u0011\u0019i$\u0003\"\u0001\u0002b!9\u00111\r\n\u0005\u0002\u0005\u0015\u0004\"CA2%\u0005\u0005I\u0011QA5\u0011%\tiGEA\u0001\n\u0003\u000by\u0007C\u0005\u0002|I\t\t\u0011\"\u0003\u0002~\t!!+\u00198e\u0015\tQ2$A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u000f\u001e\u0003!\u0019\u0017\r^1msN$(B\u0001\u0010 \u0003\r\u0019\u0018\u000f\u001c\u0006\u0003A\u0005\nQa\u001d9be.T!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO\u000e\u00011#\u0002\u0001(W9\"\u0004C\u0001\u0015*\u001b\u0005I\u0012B\u0001\u0016\u001a\u0005\r\u0011Fi\u0012\t\u0003Q1J!!L\r\u00031\u0015C\bO]3tg&|gnV5uQJ\u000bg\u000eZ8n'\u0016,G\r\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004GA\u0004Qe>$Wo\u0019;\u0011\u0005=*\u0014B\u0001\u001c1\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015\u0019\u0007.\u001b7e+\u0005I\u0004C\u0001\u0015;\u0013\tY\u0014D\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002@\u0001B\u0011\u0001\u0006\u0001\u0005\u0006o\r\u0001\r!\u000f\u000b\u0002\u007f\u0005Yq/\u001b;i\u001d\u0016<8+Z3e)\tyD\tC\u0003F\u000b\u0001\u0007a)\u0001\u0003tK\u0016$\u0007CA\u0018H\u0013\tA\u0005G\u0001\u0003M_:<\u0017\u0001D3wC2Le\u000e^3s]\u0006dGCA&O!\tyC*\u0003\u0002Na\t1Ai\\;cY\u0016DQa\u0014\u0004A\u0002A\u000bQ!\u001b8qkR\u0004\"!\u0015*\u000e\u0003mI!aU\u000e\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$2A\u0016/b!\t9&,D\u0001Y\u0015\tI\u0016$A\u0004d_\u0012,w-\u001a8\n\u0005mC&\u0001C#yaJ\u001cu\u000eZ3\t\u000bu;\u0001\u0019\u00010\u0002\u0007\r$\b\u0010\u0005\u0002X?&\u0011\u0001\r\u0017\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015\u0011w\u00011\u0001W\u0003\t)g/A\u0005ge\u0016\u001c\bnQ8qs\u0006!1m\u001c9z)\tyd\rC\u00048\u0013A\u0005\t\u0019A\u001d\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t\u0011N\u000b\u0002:U.\n1\u000e\u0005\u0002mc6\tQN\u0003\u0002o_\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003aB\n!\"\u00198o_R\fG/[8o\u0013\t\u0011XNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A;\u0011\u0005Y\\X\"A<\u000b\u0005aL\u0018\u0001\u00027b]\u001eT\u0011A_\u0001\u0005U\u00064\u0018-\u0003\u0002}o\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012a \t\u0004_\u0005\u0005\u0011bAA\u0002a\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011BA\b!\ry\u00131B\u0005\u0004\u0003\u001b\u0001$aA!os\"A\u0011\u0011C\u0007\u0002\u0002\u0003\u0007q0A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003/\u0001b!!\u0007\u0002 \u0005%QBAA\u000e\u0015\r\ti\u0002M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0011\u00037\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qEA\u0017!\ry\u0013\u0011F\u0005\u0004\u0003W\u0001$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003#y\u0011\u0011!a\u0001\u0003\u0013\ta!Z9vC2\u001cH\u0003BA\u0014\u0003gA\u0011\"!\u0005\u0011\u0003\u0003\u0005\r!!\u0003)'\u0001\t9$!\u0010\u0002@\u0005\r\u0013QIA%\u0003\u0017\ny%!\u0015\u0011\u0007!\nI$C\u0002\u0002<e\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002B\u0005\tYa\u0018$V\u001d\u000e{\u0006fW:fK\u0012l\u0016\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u0004#/\u00198e_6\u0004c/\u00197vK\u0002:\u0018\u000e\u001e5!S:$W\r]3oI\u0016tG\u000fI1oI\u0002JG-\u001a8uS\u000e\fG\u000e\\=!I&\u001cHO]5ckR,G\r\t\u0015j]%tCML\u0015!k:Lgm\u001c:nYf\u0004C-[:ue&\u0014W\u000f^3eAY\fG.^3tA%t\u0007e\u0017\u0019-AEJc&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t9%AA0\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0019/sY\u0012\u0014h\u000e\u001b3sU\nDg\r\u001b6iMR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AAr\u0003\b\u000e\u001b7ie\u0002d\u0007\u000f\u001a3mM\u0002$g\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)]VdG.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a9BD\u0007\u000e\u001c5sA2\u0004H\r\u001a7gA\u0012tG\u0003\u0011!\u0003\u0011qw\u000e^3\"\u0005\u00055\u0013A\r+iK\u00022WO\\2uS>t\u0007%[:!]>tW\u0006Z3uKJl\u0017N\\5ti&\u001c\u0007%\u001b8!O\u0016tWM]1mA\r\f7/\u001a\u0018\u0002\u000bMLgnY3\"\u0005\u0005M\u0013!B\u0019/k9\u0002\u0014\u0001\u0002*b]\u0012\u0004\"\u0001\u000b\n\u0014\tI\tY\u0006\u000e\t\u0004_\u0005u\u0013bAA0a\t1\u0011I\\=SK\u001a$\"!a\u0016\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007}\n9\u0007C\u0003F)\u0001\u0007a\tF\u0002@\u0003WBQaN\u000bA\u0002e\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002r\u0005]\u0004\u0003B\u0018\u0002teJ1!!\u001e1\u0005\u0019y\u0005\u000f^5p]\"A\u0011\u0011\u0010\f\u0002\u0002\u0003\u0007q(A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0010\t\u0004m\u0006\u0005\u0015bAABo\n1qJ\u00196fGR\u0004")
public class Rand
extends RDG
implements ExpressionWithRandomSeed,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Rand rand) {
        return Rand$.MODULE$.unapply(rand);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Rand withNewSeed(long seed) {
        return new Rand(new Literal(BoxesRunTime.boxToLong((long)seed), LongType$.MODULE$));
    }

    public double evalInternal(InternalRow input) {
        return this.rng().nextDouble();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(new StringBuilder(28).append(rngTerm).append(" = new ").append(className).append("(").append(this.seed()).append("L + partitionIndex);").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", ".nextDouble();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), rngTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Rand freshCopy() {
        return new Rand(this.child());
    }

    public Rand copy(Expression child) {
        return new Rand(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Rand";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Rand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Rand)) return false;
        boolean bl = true;
        if (!bl) return false;
        Rand rand = (Rand)x$1;
        Expression expression = this.child();
        Expression expression2 = rand.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!rand.canEqual(this)) return false;
        return true;
    }

    public Rand(Expression child) {
        this.child = child;
    }

    public Rand() {
        this(new Literal(BoxesRunTime.boxToLong((long)Utils$.MODULE$.random().nextLong()), LongType$.MODULE$));
    }
}

