/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FromUTCTimestamp$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp, timezone) - Given a timestamp like '2017-07-14 02:40:00.0', interprets it as a time in UTC, and renders that time as a timestamp in the given time zone. For example, 'GMT+1' would yield '2017-07-14 03:40:00.0'.", examples="\n    Examples:\n      > SELECT _FUNC_('2016-08-31', 'Asia/Seoul');\n       2016-08-31 09:00:00\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001B\u000e\u001d\u0001&B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u007f\u0001\u0011\t\u0012)A\u0005y!A\u0001\t\u0001BK\u0002\u0013\u00051\b\u0003\u0005B\u0001\tE\t\u0015!\u0003=\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u00159\u0005\u0001\"\u0011I\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015\u0019\b\u0001\"\u0011u\u0011%\t)\u0001AA\u0001\n\u0003\t9\u0001C\u0005\u0002\u000e\u0001\t\n\u0011\"\u0001\u0002\u0010!I\u0011Q\u0005\u0001\u0012\u0002\u0013\u0005\u0011q\u0002\u0005\n\u0003O\u0001\u0011\u0011!C!\u0003SA\u0011\"!\u000f\u0001\u0003\u0003%\t!a\u000f\t\u0013\u0005\r\u0003!!A\u0005\u0002\u0005\u0015\u0003\"CA&\u0001\u0005\u0005I\u0011IA'\u0011%\tY\u0006AA\u0001\n\u0003\ti\u0006C\u0005\u0002h\u0001\t\t\u0011\"\u0011\u0002j\u001dI\u0011Q\u0012\u000f\u0002\u0002#\u0005\u0011q\u0012\u0004\t7q\t\t\u0011#\u0001\u0002\u0012\"1!)\u0006C\u0001\u0003?C\u0011\"!)\u0016\u0003\u0003%)%a)\t\u0013\u0005\u0015V#!A\u0005\u0002\u0006\u001d\u0006\"CAW+\u0005\u0005I\u0011QAX\u0011%\t\t-FA\u0001\n\u0013\t\u0019M\u0001\tGe>lW\u000bV\"US6,7\u000f^1na*\u0011QDH\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002 A\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001U9\nt\u0007\u0005\u0002,Y5\tA$\u0003\u0002.9\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003W=J!\u0001\r\u000f\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00023q%\u0011\u0011h\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005Y\u00164G/F\u0001=!\tYS(\u0003\u0002?9\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003\u0019a\u0014N\\5u}Q\u0019A)\u0012$\u0011\u0005-\u0002\u0001\"\u0002\u001e\u0006\u0001\u0004a\u0004\"\u0002!\u0006\u0001\u0004a\u0014AC5oaV$H+\u001f9fgV\t\u0011\nE\u0002K%Vs!a\u0013)\u000f\u00051{U\"A'\u000b\u00059C\u0013A\u0002\u001fs_>$h(C\u00015\u0013\t\t6'A\u0004qC\u000e\\\u0017mZ3\n\u0005M#&aA*fc*\u0011\u0011k\r\t\u0003-fk\u0011a\u0016\u0006\u00031\u0002\nQ\u0001^=qKNL!AW,\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003u\u0003\"A\u00160\n\u0005};&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001c!\t\u0019wM\u0004\u0002eKB\u0011AjM\u0005\u0003MN\na\u0001\u0015:fI\u00164\u0017B\u00015j\u0005\u0019\u0019FO]5oO*\u0011amM\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004Y>\f\bC\u0001\u001an\u0013\tq7GA\u0002B]fDQ\u0001]\u0005A\u00021\fA\u0001^5nK\")!/\u0003a\u0001Y\u0006AA/[7fu>tW-A\u0005e_\u001e+gnQ8eKR!Qo_A\u0001!\t1\u00180D\u0001x\u0015\tAH$A\u0004d_\u0012,w-\u001a8\n\u0005i<(\u0001C#yaJ\u001cu\u000eZ3\t\u000bqT\u0001\u0019A?\u0002\u0007\r$\b\u0010\u0005\u0002w}&\u0011qp\u001e\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0019\t\u0019A\u0003a\u0001k\u0006\u0011QM^\u0001\u0005G>\u0004\u0018\u0010F\u0003E\u0003\u0013\tY\u0001C\u0004;\u0017A\u0005\t\u0019\u0001\u001f\t\u000f\u0001[\u0001\u0013!a\u0001y\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\tU\ra\u00141C\u0016\u0003\u0003+\u0001B!a\u0006\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"A\u0005v]\u000eDWmY6fI*\u0019\u0011qD\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002$\u0005e!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002,A!\u0011QFA\u001c\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012\u0001\u00027b]\u001eT!!!\u000e\u0002\t)\fg/Y\u0005\u0004Q\u0006=\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u001f!\r\u0011\u0014qH\u0005\u0004\u0003\u0003\u001a$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00017\u0002H!I\u0011\u0011\n\t\u0002\u0002\u0003\u0007\u0011QH\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005=\u0003#BA)\u0003/bWBAA*\u0015\r\t)fM\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA-\u0003'\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qLA3!\r\u0011\u0014\u0011M\u0005\u0004\u0003G\u001a$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u0013\u0012\u0012\u0011!a\u0001Y\u00061Q-];bYN$B!a\u0018\u0002l!A\u0011\u0011J\n\u0002\u0002\u0003\u0007A\u000eK\n\u0001\u0003_\n)(a\u001e\u0002|\u0005u\u0014\u0011QAB\u0003\u000f\u000bI\tE\u0002,\u0003cJ1!a\u001d\u001d\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u001f\u0002\u0003\u0013|f)\u0016(D?\"\"\u0018.\\3ti\u0006l\u0007\u000f\f\u0011uS6,'p\u001c8fS\u0001j\u0003eR5wK:\u0004\u0013\r\t;j[\u0016\u001cH/Y7qA1L7.\u001a\u0011(eA\nt'\f\u00198[E\"\u0004\u0005\r\u001a;iAR\u0004\u0007\r\u00181O1\u0002\u0013N\u001c;feB\u0014X\r^:!SR\u0004\u0013m\u001d\u0011bAQLW.\u001a\u0011j]\u0002*Fk\u0011\u0017!C:$\u0007E]3oI\u0016\u00148\u000f\t;iCR\u0004C/[7fA\u0005\u001c\b%\u0019\u0011uS6,7\u000f^1na\u0002Jg\u000e\t;iK\u0002:\u0017N^3oAQLW.\u001a\u0011{_:,g\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003eJ$N).\nt\u0005I<pk2$\u0007%_5fY\u0012\u0004sE\r\u00192o5\u0002t'L\u00195AA\u001a$\b\u000e\u0019;aAr\u0003g\n\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a \u0002?*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00192m5\u0002\u0004(L\u001a2O1\u0002s%Q:jC>\u001aVm\\;mO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192m5\u0002\u0004(L\u001a2AAJ$\b\r\u0019;aAR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u000b\u000ba\u0002Z1uKRLW.Z0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002\f\u0006)\u0011GL\u001b/a\u0005\u0001bI]8n+R\u001bE+[7fgR\fW\u000e\u001d\t\u0003WU\u0019B!FAJoA9\u0011QSANyq\"UBAAL\u0015\r\tIjM\u0001\beVtG/[7f\u0013\u0011\ti*a&\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002\u0010\u0006AAo\\*ue&tw\r\u0006\u0002\u0002,\u0005)\u0011\r\u001d9msR)A)!+\u0002,\")!\b\u0007a\u0001y!)\u0001\t\u0007a\u0001y\u00059QO\\1qa2LH\u0003BAY\u0003{\u0003RAMAZ\u0003oK1!!.4\u0005\u0019y\u0005\u000f^5p]B)!'!/=y%\u0019\u00111X\u001a\u0003\rQ+\b\u000f\\33\u0011!\ty,GA\u0001\u0002\u0004!\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t)\r\u0005\u0003\u0002.\u0005\u001d\u0017\u0002BAe\u0003_\u0011aa\u00142kK\u000e$\b")
public class FromUTCTimestamp
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(FromUTCTimestamp fromUTCTimestamp) {
        return FromUTCTimestamp$.MODULE$.unapply(fromUTCTimestamp);
    }

    public static Function1<Tuple2<Expression, Expression>, FromUTCTimestamp> tupled() {
        return FromUTCTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, FromUTCTimestamp>> curried() {
        return FromUTCTimestamp$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "from_utc_timestamp";
    }

    @Override
    public Object nullSafeEval(Object time, Object timezone) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromUTCTime(BoxesRunTime.unboxToLong((Object)time), ((UTF8String)timezone).toString()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        if (this.right().foldable()) {
            UTF8String tz = (UTF8String)this.right().eval(this.right().eval$default$1());
            if (tz == null) {
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean ", " = true;\n           |long ", " = 0;\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
            } else {
                String tzClass = ZoneId.class.getName();
                String dtu2 = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
                String escapedTz = StringEscapeUtils.escapeJava((String)tz.toString());
                String tzTerm = ctx.addMutableState(tzClass, "tz", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(18).append((String)v).append(" = ").append(dtu2).append(".getZoneId(\"").append(escapedTz).append("\");").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                String utcTerm = "java.time.ZoneOffset.UTC";
                ExprCode eval = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |boolean ", " = ", ";\n           |long ", " = 0;\n           |if (!", ") {\n           |  ", " = ", ".convertTz(", ", ", ", ", ");\n           |}\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), ev.value(), ev.isNull(), ev.value(), dtu2, eval.value(), utcTerm, tzTerm})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            exprCode = this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(timestamp, format) -> new StringBuilder(27).append(dtu).append(".fromUTCTime(").append((String)timestamp).append(", ").append((String)format).append(".toString())").toString());
        }
        return exprCode;
    }

    public FromUTCTimestamp copy(Expression left, Expression right) {
        return new FromUTCTimestamp(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "FromUTCTimestamp";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FromUTCTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FromUTCTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        FromUTCTimestamp fromUTCTimestamp = (FromUTCTimestamp)x$1;
        Expression expression = this.left();
        Expression expression2 = fromUTCTimestamp.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = fromUTCTimestamp.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!fromUTCTimestamp.canEqual(this)) return false;
        return true;
    }

    public FromUTCTimestamp(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

