/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.First$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr[, isIgnoreNull]) - Returns the first value of `expr` for a group of rows.\n      If `isIgnoreNull` is true, returns only non-null values.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (10), (5), (20) AS tab(col);\n       10\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (5), (20) AS tab(col);\n       NULL\n      > SELECT _FUNC_(col, true) FROM VALUES (NULL), (5), (20) AS tab(col);\n       5\n  ", note="\n    The function is non-deterministic because its results depends on the order of the rows\n    which may be non-deterministic after a shuffle.\n  ", group="agg_funcs", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001\u0002\u0014(\u0001ZB\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005P\u0001\tE\t\u0015!\u0003K\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015\u0001\u0006\u0001\"\u0001V\u0011\u00159\u0006\u0001\"\u0011Y\u0011\u0015)\u0007\u0001\"\u0011g\u0011!Q\u0007\u0001#b\u0001\n\u00032\u0007\"B6\u0001\t\u0003b\u0007\"B:\u0001\t\u0003\"\b\"B=\u0001\t\u0003R\bBBA\u0002\u0001\u0011%a\r\u0003\u0006\u0002\u0006\u0001A)\u0019!C\u0005\u0003\u000fA!\"a\u0004\u0001\u0011\u000b\u0007I\u0011BA\u0004\u0011)\t\t\u0002\u0001EC\u0002\u0013\u0005\u00131\u0003\u0005\u000b\u0003/\u0001\u0001R1A\u0005B\u0005e\u0001\"CA\u0012\u0001!\u0015\r\u0011\"\u0011Y\u0011%\t)\u0003\u0001EC\u0002\u0013\u0005\u0003\f\u0003\u0006\u0002(\u0001A)\u0019!C!\u0003\u000fAq!!\u000b\u0001\t\u0003\nY\u0003C\u0005\u0002>\u0001\t\t\u0011\"\u0001\u0002@!I\u0011Q\t\u0001\u0012\u0002\u0013\u0005\u0011q\t\u0005\n\u0003;\u0002\u0011\u0013!C\u0001\u0003\u000fB\u0011\"a\u0018\u0001\u0003\u0003%\t%!\u0019\t\u0013\u0005E\u0004!!A\u0005\u0002\u0005M\u0004\"CA>\u0001\u0005\u0005I\u0011AA?\u0011%\tI\tAA\u0001\n\u0003\nY\tC\u0005\u0002\u001a\u0002\t\t\u0011\"\u0001\u0002\u001c\"I\u0011q\u0014\u0001\u0002\u0002\u0013\u0005\u0013\u0011U\u0004\n\u0003\u0017<\u0013\u0011!E\u0001\u0003\u001b4\u0001BJ\u0014\u0002\u0002#\u0005\u0011q\u001a\u0005\u0007!\u0002\"\t!!8\t\u0013\u0005%\u0002%!A\u0005F\u0005}\u0007\"CAqA\u0005\u0005I\u0011QAr\u0011%\tI\u000fIA\u0001\n\u0003\u000bY\u000fC\u0005\u0002~\u0002\n\t\u0011\"\u0003\u0002\u0000\n)a)\u001b:ti*\u0011\u0001&K\u0001\nC\u001e<'/Z4bi\u0016T!AK\u0016\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003Y5\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003]=\n1a]9m\u0015\t\u0001\u0014'A\u0003ta\u0006\u00148N\u0003\u00023g\u00051\u0011\r]1dQ\u0016T\u0011\u0001N\u0001\u0004_J<7\u0001A\n\u0006\u0001]Zt(\u0012\t\u0003qej\u0011aJ\u0005\u0003u\u001d\u0012A\u0003R3dY\u0006\u0014\u0018\r^5wK\u0006;wM]3hCR,\u0007C\u0001\u001f>\u001b\u0005I\u0013B\u0001 *\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\b!J|G-^2u!\t\u0001e)\u0003\u0002H\u0003\na1+\u001a:jC2L'0\u00192mK\u0006)1\r[5mIV\t!\n\u0005\u0002=\u0017&\u0011A*\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%A\bjO:|'/\u001a(vY2\u001cX\t\u001f9s\u0003AIwM\\8sK:+H\u000e\\:FqB\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0004%N#\u0006C\u0001\u001d\u0001\u0011\u0015AU\u00011\u0001K\u0011\u0015qU\u00011\u0001K)\t\u0011f\u000bC\u0003I\r\u0001\u0007!*\u0001\u0005dQ&dGM]3o+\u0005I\u0006c\u0001.c\u0015:\u00111\f\u0019\b\u00039~k\u0011!\u0018\u0006\u0003=V\na\u0001\u0010:p_Rt\u0014\"\u0001\"\n\u0005\u0005\f\u0015a\u00029bG.\fw-Z\u0005\u0003G\u0012\u00141aU3r\u0015\t\t\u0017)\u0001\u0005ok2d\u0017M\u00197f+\u00059\u0007C\u0001!i\u0013\tI\u0017IA\u0004C_>dW-\u00198\u0002\u001b\u0011,G/\u001a:nS:L7\u000f^5d\u0003!!\u0017\r^1UsB,W#A7\u0011\u00059\fX\"A8\u000b\u0005Al\u0013!\u0002;za\u0016\u001c\u0018B\u0001:p\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\tQ\u000fE\u0002[EZ\u0004\"A\\<\n\u0005a|'\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\u0005Y\bC\u0001?\u0000\u001b\u0005i(B\u0001@,\u0003!\tg.\u00197zg&\u001c\u0018bAA\u0001{\nyA+\u001f9f\u0007\",7m\u001b*fgVdG/A\u0006jO:|'/\u001a(vY2\u001c\u0018!\u00024jeN$XCAA\u0005!\ra\u00141B\u0005\u0004\u0003\u001bI#AE!uiJL'-\u001e;f%\u00164WM]3oG\u0016\f\u0001B^1mk\u0016\u001cV\r^\u0001\u0014C\u001e<')\u001e4gKJ\fE\u000f\u001e:jEV$Xm]\u000b\u0003\u0003+\u0001BA\u00172\u0002\n\u0005i\u0011N\\5uS\u0006dg+\u00197vKN,\"!a\u0007\u0011\ti\u0013\u0017Q\u0004\t\u0004y\u0005}\u0011bAA\u0011S\t9A*\u001b;fe\u0006d\u0017!E;qI\u0006$X-\u0012=qe\u0016\u001c8/[8og\u0006\u0001R.\u001a:hK\u0016C\bO]3tg&|gn]\u0001\u0013KZ\fG.^1uK\u0016C\bO]3tg&|g.\u0001\u0005u_N#(/\u001b8h)\t\ti\u0003\u0005\u0003\u00020\u0005]b\u0002BA\u0019\u0003g\u0001\"\u0001X!\n\u0007\u0005U\u0012)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003s\tYD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003k\t\u0015\u0001B2paf$RAUA!\u0003\u0007Bq\u0001\u0013\f\u0011\u0002\u0003\u0007!\nC\u0004O-A\u0005\t\u0019\u0001&\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\n\u0016\u0004\u0015\u0006-3FAA'!\u0011\ty%!\u0017\u000e\u0005\u0005E#\u0002BA*\u0003+\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]\u0013)\u0001\u0006b]:|G/\u0019;j_:LA!a\u0017\u0002R\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0019\u0011\t\u0005\u0015\u0014qN\u0007\u0003\u0003ORA!!\u001b\u0002l\u0005!A.\u00198h\u0015\t\ti'\u0001\u0003kCZ\f\u0017\u0002BA\u001d\u0003O\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u001e\u0011\u0007\u0001\u000b9(C\u0002\u0002z\u0005\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a \u0002\u0006B\u0019\u0001)!!\n\u0007\u0005\r\u0015IA\u0002B]fD\u0011\"a\"\u001c\u0003\u0003\u0005\r!!\u001e\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\t\u0005\u0004\u0002\u0010\u0006U\u0015qP\u0007\u0003\u0003#S1!a%B\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003/\u000b\tJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA4\u0002\u001e\"I\u0011qQ\u000f\u0002\u0002\u0003\u0007\u0011qP\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u001d\f\u0019\u000bC\u0005\u0002\bz\t\t\u00111\u0001\u0002\u0000!:\u0002!a*\u0002.\u0006=\u00161WA[\u0003s\u000bY,a0\u0002B\u0006\u0015\u0017q\u0019\t\u0004y\u0005%\u0016bAAVS\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAY\u0003\u0005M\"\u0002\t\u0011!A}3UKT\"`Q\u0015D\bO].-A%\u001c\u0018j\u001a8pe\u0016tU\u000f\u001c7^S\u0001j\u0003EU3ukJt7\u000f\t;iK\u00022\u0017N]:uAY\fG.^3!_\u001a\u0004\u0003-\u001a=qe\u0002\u0004cm\u001c:!C\u0002:'o\\;qA=4\u0007E]8xg:R\u0001\u0005\t\u0011!A\u0001Je\r\t1jg&;gn\u001c:f\u001dVdG\u000e\u0019\u0011jg\u0002\"(/^3-AI,G/\u001e:og\u0002zg\u000e\\=!]>tWF\\;mY\u00022\u0018\r\\;fg:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003o\u000b!Q\u0002\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)G>d\u0017\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003&\r\u0019*Y\u0001BS'\u000b\u0017!QI\u0002\u0014\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\r|G.\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005\u000b(V\u00192KC\u0006\t\u00156S1\u0002\u0003F\r\u0019*A\u0005\u001b\u0006\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u001dVcEJ\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015d_2d\u0003\u0005\u001e:vK&\u0002cIU(NAY\u000bE*V#TA!rU\u000b\u0014'*Y\u0001BS'\u000b\u0017!QI\u0002\u0014\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u000e\u0006!A\u0005!an\u001c;fC\t\ti,AA\u0013\u0015\u0001\u0002\u0003\u0005\t+iK\u00022WO\\2uS>t\u0007%[:!]>tW\u0006Z3uKJl\u0017N\\5ti&\u001c\u0007EY3dCV\u001cX\rI5ug\u0002\u0012Xm];miN\u0004C-\u001a9f]\u0012\u001c\be\u001c8!i\",\u0007e\u001c:eKJ\u0004sN\u001a\u0011uQ\u0016\u0004#o\\<t\u0015\u0001\u0002\u0003\u0005I<iS\u000eD\u0007%\\1zA\t,\u0007E\\8o[\u0011,G/\u001a:nS:L7\u000f^5dA\u00054G/\u001a:!C\u0002\u001a\b.\u001e4gY\u0016t#\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005\r\u0017!C1hO~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\tI-A\u00033]Ar\u0003'A\u0003GSJ\u001cH\u000f\u0005\u00029AM!\u0001%!5F!\u001d\t\u0019.!7K\u0015Jk!!!6\u000b\u0007\u0005]\u0017)A\u0004sk:$\u0018.\\3\n\t\u0005m\u0017Q\u001b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAAg)\t\t\u0019'A\u0003baBd\u0017\u0010F\u0003S\u0003K\f9\u000fC\u0003IG\u0001\u0007!\nC\u0003OG\u0001\u0007!*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u00055\u0018\u0011 \t\u0006\u0001\u0006=\u00181_\u0005\u0004\u0003c\f%AB(qi&|g\u000eE\u0003A\u0003kT%*C\u0002\u0002x\u0006\u0013a\u0001V;qY\u0016\u0014\u0004\u0002CA~I\u0005\u0005\t\u0019\u0001*\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0001!\u0011\t)Ga\u0001\n\t\t\u0015\u0011q\r\u0002\u0007\u001f\nTWm\u0019;")
public class First
extends DeclarativeAggregate
implements ExpectsInputTypes {
    private boolean deterministic;
    private AttributeReference first;
    private AttributeReference valueSet;
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Literal> initialValues;
    private Seq<Expression> updateExpressions;
    private Seq<Expression> mergeExpressions;
    private AttributeReference evaluateExpression;
    private final Expression child;
    private final Expression ignoreNullsExpr;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(First first) {
        return First$.MODULE$.unapply(first);
    }

    public static Function1<Tuple2<Expression, Expression>, First> tupled() {
        return First$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, First>> curried() {
        return First$.MODULE$.curried();
    }

    public Expression child() {
        return this.child;
    }

    public Expression ignoreNullsExpr() {
        return this.ignoreNullsExpr;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.child();
        Expression expression2 = this.ignoreNullsExpr();
        return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private boolean deterministic$lzycompute() {
        First first = this;
        synchronized (first) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.deterministic = false;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.deterministic;
    }

    @Override
    public boolean deterministic() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.deterministic$lzycompute() : this.deterministic;
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{AnyDataType$.MODULE$, BooleanType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.ignoreNullsExpr().foldable() ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(65).append("The second argument of First must be a boolean literal, but got: ").append(this.ignoreNullsExpr().sql()).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$);
    }

    private boolean ignoreNulls() {
        return BoxesRunTime.unboxToBoolean((Object)this.ignoreNullsExpr().eval(this.ignoreNullsExpr().eval$default$1()));
    }

    private AttributeReference first$lzycompute() {
        First first = this;
        synchronized (first) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String x$1 = "first";
                DataType x$2 = this.child().dataType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                this.first = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.first;
    }

    private AttributeReference first() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.first$lzycompute() : this.first;
    }

    private AttributeReference valueSet$lzycompute() {
        First first = this;
        synchronized (first) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                String x$1 = "valueSet";
                BooleanType$ x$2 = BooleanType$.MODULE$;
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                this.valueSet = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.valueSet;
    }

    private AttributeReference valueSet() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.valueSet$lzycompute() : this.valueSet;
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        First first = this;
        synchronized (first) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                AttributeReference attributeReference = this.first();
                AttributeReference attributeReference2 = this.valueSet();
                this.aggBufferAttributes = Nil$.MODULE$.$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.aggBufferAttributes$lzycompute() : this.aggBufferAttributes;
    }

    private Seq<Literal> initialValues$lzycompute() {
        First first = this;
        synchronized (first) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.initialValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.create(null, this.child().dataType()), Literal$.MODULE$.create(BoxesRunTime.boxToBoolean((boolean)false), BooleanType$.MODULE$)}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.initialValues;
    }

    public Seq<Literal> initialValues() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.initialValues$lzycompute() : this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        First first = this;
        synchronized (first) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.updateExpressions = this.ignoreNulls() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.valueSet()).$bar$bar((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()))), this.first(), this.child()), (Expression)((Object)package$expressions$.MODULE$.DslExpression(this.valueSet()).$bar$bar((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNotNull())))})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new If(this.valueSet(), this.first(), this.child()), Literal$.MODULE$.create(BoxesRunTime.boxToBoolean((boolean)true), BooleanType$.MODULE$)}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.updateExpressions$lzycompute() : this.updateExpressions;
    }

    private Seq<Expression> mergeExpressions$lzycompute() {
        First first = this;
        synchronized (first) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.mergeExpressions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new If(this.RichAttribute(this.valueSet()).left(), this.RichAttribute(this.first()).left(), this.RichAttribute(this.first()).right()), (Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.valueSet()).left()).$bar$bar(this.RichAttribute(this.valueSet()).right()))}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.mergeExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.mergeExpressions$lzycompute() : this.mergeExpressions;
    }

    private AttributeReference evaluateExpression$lzycompute() {
        First first = this;
        synchronized (first) {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                this.evaluateExpression = this.first();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public AttributeReference evaluateExpression() {
        return (byte)(this.bitmap$0 & 0x80) == 0 ? this.evaluateExpression$lzycompute() : this.evaluateExpression;
    }

    @Override
    public String toString() {
        return new StringBuilder(2).append(this.prettyName()).append("(").append(this.child()).append(")").append((Object)(this.ignoreNulls() ? " ignore nulls" : BoxedUnit.UNIT)).toString();
    }

    public First copy(Expression child, Expression ignoreNullsExpr) {
        return new First(child, ignoreNullsExpr);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.ignoreNullsExpr();
    }

    @Override
    public String productPrefix() {
        return "First";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.child();
                break;
            }
            case 1: {
                expression = this.ignoreNullsExpr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof First;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof First)) return false;
        boolean bl = true;
        if (!bl) return false;
        First first = (First)x$1;
        Expression expression = this.child();
        Expression expression2 = first.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.ignoreNullsExpr();
        Expression expression4 = first.ignoreNullsExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!first.canEqual(this)) return false;
        return true;
    }

    public First(Expression child, Expression ignoreNullsExpr) {
        this.child = child;
        this.ignoreNullsExpr = ignoreNullsExpr;
        ExpectsInputTypes.$init$(this);
    }

    public First(Expression child) {
        this(child, Literal$.MODULE$.create(BoxesRunTime.boxToBoolean((boolean)false), BooleanType$.MODULE$));
    }
}

