/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$IntervalUnit$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$ParseState$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class IntervalUtils$ {
    public static IntervalUtils$ MODULE$;
    private final Regex yearMonthPattern;
    private final Regex dayTimePatternLegacy;
    private final String fallbackNotice;
    private final String signRe;
    private final String dayRe;
    private final String hourRe;
    private final String minuteRe;
    private final String secondRe;
    private final Map<Tuple2<Enumeration.Value, Enumeration.Value>, Regex> dayTimePattern;
    private final UTF8String intervalStr;
    private final UTF8String yearStr;
    private final UTF8String monthStr;
    private final UTF8String weekStr;
    private final UTF8String dayStr;
    private final UTF8String hourStr;
    private final UTF8String minuteStr;
    private final UTF8String secondStr;
    private final UTF8String millisStr;
    private final UTF8String microsStr;

    static {
        new IntervalUtils$();
    }

    public int getYears(CalendarInterval interval) {
        return interval.months / 12;
    }

    public byte getMonths(CalendarInterval interval) {
        return (byte)(interval.months % 12);
    }

    public int getDays(CalendarInterval interval) {
        int daysInMicroseconds = (int)(interval.microseconds / 86400000000L);
        return Math.addExact(interval.days, daysInMicroseconds);
    }

    public long getHours(CalendarInterval interval) {
        return interval.microseconds % 86400000000L / 3600000000L;
    }

    public byte getMinutes(CalendarInterval interval) {
        return (byte)(interval.microseconds % 3600000000L / 60000000L);
    }

    public Decimal getSeconds(CalendarInterval interval) {
        return Decimal$.MODULE$.apply(interval.microseconds % 60000000L, 8, 6);
    }

    private long toLongWithRange(Enumeration.Value fieldName, String s, long minValue, long maxValue) {
        long result = s == null ? 0L : new StringOps(Predef$.MODULE$.augmentString(s)).toLong();
        Predef$.MODULE$.require(minValue <= result && result <= maxValue, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append(fieldName).append(" ").append(result).append(" outside range [").append(minValue).append(", ").append(maxValue).append("]").toString());
        return result;
    }

    private Regex yearMonthPattern() {
        return this.yearMonthPattern;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CalendarInterval fromYearMonthString(String input) {
        Option option;
        Predef$.MODULE$.require(input != null, (Function0 & Serializable & scala.Serializable)() -> "Interval year-month string must be not null");
        String string = input.trim();
        Option option2 = this.yearMonthPattern().unapplySeq((CharSequence)string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(3) == 0) {
            String string2 = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String yearStr = (String)((LinearSeqOptimized)option2.get()).apply(1);
            String monthStr = (String)((LinearSeqOptimized)option2.get()).apply(2);
            if ("-".equals(string2)) {
                return this.negateExact(this.toInterval$1(yearStr, monthStr));
            }
        }
        if ((option = this.yearMonthPattern().unapplySeq((CharSequence)string)).isEmpty()) throw new IllegalArgumentException(new StringBuilder(59).append("Interval string does not match year-month format of 'y-m': ").append(input).toString());
        if (option.get() == null) throw new IllegalArgumentException(new StringBuilder(59).append("Interval string does not match year-month format of 'y-m': ").append(input).toString());
        if (((LinearSeqOptimized)option.get()).lengthCompare(3) != 0) throw new IllegalArgumentException(new StringBuilder(59).append("Interval string does not match year-month format of 'y-m': ").append(input).toString());
        String yearStr = (String)((LinearSeqOptimized)option.get()).apply(1);
        String monthStr = (String)((LinearSeqOptimized)option.get()).apply(2);
        return this.toInterval$1(yearStr, monthStr);
    }

    public CalendarInterval fromDayTimeString(String s) {
        return this.fromDayTimeString(s, IntervalUtils$IntervalUnit$.MODULE$.DAY(), IntervalUtils$IntervalUnit$.MODULE$.SECOND());
    }

    public CalendarInterval fromDayTimeString(String input, Enumeration.Value from, Enumeration.Value to) {
        return BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_FROM_DAYTIME_STRING())) ? this.parseDayTimeLegacy(input, from, to) : this.parseDayTime(input, from, to);
    }

    private Regex dayTimePatternLegacy() {
        return this.dayTimePatternLegacy;
    }

    private String fallbackNotice() {
        return this.fallbackNotice;
    }

    /*
     * Unable to fully structure code
     */
    private CalendarInterval parseDayTimeLegacy(String input, Enumeration.Value from, Enumeration.Value to) {
        Predef$.MODULE$.require(input != null, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseDayTimeLegacy$1(), ()Ljava/lang/String;)());
        Predef$.MODULE$.assert(input.length() == input.trim().length());
        m = this.dayTimePatternLegacy().pattern().matcher(input);
        Predef$.MODULE$.require(m.matches(), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseDayTimeLegacy$2(java.lang.String ), ()Ljava/lang/String;)((String)input));
        try {
            if (m.group(1) == null) ** GOTO lbl-1000
            v0 = m.group(1);
            var7_5 = "-";
            if (!(v0 != null ? v0.equals(var7_5) == false : var7_5 != null)) {
                v1 = -1;
            } else lbl-1000:
            // 2 sources

            {
                v1 = 1;
            }
            sign = v1;
            days = m.group(2) == null ? 0 : (int)this.toLongWithRange(IntervalUtils$IntervalUnit$.MODULE$.DAY(), m.group(3), 0L, 0x7FFFFFFFL);
            hours = 0L;
            minutes = 0L;
            seconds = 0L;
            if (m.group(5) != null) ** GOTO lbl-1000
            v2 = from;
            var15_11 = IntervalUtils$IntervalUnit$.MODULE$.MINUTE();
            if (!(v2 != null ? v2.equals(var15_11) == false : var15_11 != null)) lbl-1000:
            // 2 sources

            {
                hours = this.toLongWithRange(IntervalUtils$IntervalUnit$.MODULE$.HOUR(), m.group(5), 0L, 23L);
                minutes = this.toLongWithRange(IntervalUtils$IntervalUnit$.MODULE$.MINUTE(), m.group(6), 0L, 59L);
                seconds = this.toLongWithRange(IntervalUtils$IntervalUnit$.MODULE$.SECOND(), m.group(7), 0L, 59L);
            } else if (m.group(8) != null) {
                minutes = this.toLongWithRange(IntervalUtils$IntervalUnit$.MODULE$.MINUTE(), m.group(6), 0L, 59L);
                seconds = this.toLongWithRange(IntervalUtils$IntervalUnit$.MODULE$.SECOND(), m.group(7), 0L, 59L);
            } else {
                hours = this.toLongWithRange(IntervalUtils$IntervalUnit$.MODULE$.HOUR(), m.group(6), 0L, 23L);
                minutes = this.toLongWithRange(IntervalUtils$IntervalUnit$.MODULE$.SECOND(), m.group(7), 0L, 59L);
            }
            secondsFraction = this.parseNanos(m.group(9), seconds < 0L);
            var18_13 = to;
            v3 = IntervalUtils$IntervalUnit$.MODULE$.HOUR();
            var19_14 = var18_13;
            if (!(v3 != null ? v3.equals(var19_14) == false : var19_14 != null)) {
                minutes = 0L;
                seconds = 0L;
                secondsFraction = 0L;
                var4_15 = BoxedUnit.UNIT;
            } else {
                v4 = IntervalUtils$IntervalUnit$.MODULE$.MINUTE();
                var20_18 = var18_13;
                if (!(v4 != null ? v4.equals(var20_18) == false : var20_18 != null)) {
                    seconds = 0L;
                    secondsFraction = 0L;
                    var4_16 = BoxedUnit.UNIT;
                } else {
                    v5 = IntervalUtils$IntervalUnit$.MODULE$.SECOND();
                    var21_19 = var18_13;
                    if (!(v5 != null ? v5.equals(var21_19) == false : var21_19 != null)) {
                        var4_17 = BoxedUnit.UNIT;
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(44).append("Cannot support (interval '").append(input).append("' ").append(from).append(" to ").append(to).append(") expression").toString());
                    }
                }
            }
            micros = secondsFraction;
            micros = Math.addExact(micros, Math.multiplyExact(hours, 3600000000L));
            micros = Math.addExact(micros, Math.multiplyExact(minutes, 60000000L));
            micros = Math.addExact(micros, Math.multiplyExact(seconds, 1000000L));
            v6 = new CalendarInterval(0, sign * days, (long)sign * micros);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringBuilder(40).append("Error parsing interval day-time string: ").append(e.getMessage()).toString(), e);
        }
        return v6;
    }

    private String signRe() {
        return this.signRe;
    }

    private String dayRe() {
        return this.dayRe;
    }

    private String hourRe() {
        return this.hourRe;
    }

    private String minuteRe() {
        return this.minuteRe;
    }

    private String secondRe() {
        return this.secondRe;
    }

    private Map<Tuple2<Enumeration.Value, Enumeration.Value>, Regex> dayTimePattern() {
        return this.dayTimePattern;
    }

    private Seq<Enumeration.Value> unitsRange(Enumeration.Value start, Enumeration.Value end) {
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(start.id()), end.id()).map((Function1 & Serializable & scala.Serializable)x$1 -> IntervalUtils$IntervalUnit$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     */
    private CalendarInterval parseDayTime(String input, Enumeration.Value from, Enumeration.Value to) {
        Predef$.MODULE$.require(input != null, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseDayTime$1(), ()Ljava/lang/String;)());
        regexp = this.dayTimePattern().get((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)from), (Object)to));
        Predef$.MODULE$.require(regexp.isDefined(), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseDayTime$2(java.lang.String scala.Enumeration$Value scala.Enumeration$Value ), ()Ljava/lang/String;)((String)input, (Enumeration.Value)from, (Enumeration.Value)to));
        pattern = ((Regex)regexp.get()).pattern();
        m = pattern.matcher(input.trim());
        Predef$.MODULE$.require(m.matches(), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseDayTime$3(java.util.regex.Pattern java.lang.String ), ()Ljava/lang/String;)((Pattern)pattern, (String)input));
        micros = LongRef.create((long)0L);
        days = IntRef.create((int)0);
        this.unitsRange(to, from).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseDayTime$4$adapted(scala.runtime.IntRef java.util.regex.Matcher scala.runtime.LongRef java.lang.String scala.Enumeration$Value scala.Enumeration$Value scala.Enumeration$Value ), (Lscala/Enumeration$Value;)Ljava/lang/Object;)((IntRef)days, (Matcher)m, (LongRef)micros, (String)input, (Enumeration.Value)from, (Enumeration.Value)to));
        if (m.group("sign") == null) ** GOTO lbl-1000
        v0 = m.group("sign");
        var10_9 = "-";
        if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
            v1 = -1;
        } else lbl-1000:
        // 2 sources

        {
            v1 = 1;
        }
        sign = v1;
        return new CalendarInterval(0, sign * days.elem, (long)sign * micros.elem);
    }

    private long parseNanos(String nanosStr, boolean isNegative) {
        long l;
        if (nanosStr != null) {
            int maxNanosLen = 9;
            String alignedStr = nanosStr.length() < maxNanosLen ? new StringBuilder(9).append(nanosStr).append("000000000").toString().substring(0, maxNanosLen) : nanosStr;
            long nanos = this.toLongWithRange(IntervalUtils$IntervalUnit$.MODULE$.NANOSECOND(), alignedStr, 0L, 999999999L);
            long micros = nanos / 1000L;
            l = isNegative ? -micros : micros;
        } else {
            l = 0L;
        }
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long parseSecondNano(String secondNano) {
        long seconds;
        Option option;
        String[] stringArray = secondNano.split("\\.");
        Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0) {
            String secondsStr = (String)((SeqLike)option2.get()).apply(0);
            return this.parseSeconds$1(secondsStr);
        }
        Option option3 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option3.isEmpty() && option3.get() != null && ((SeqLike)option3.get()).lengthCompare(2) == 0) {
            String string = (String)((SeqLike)option3.get()).apply(0);
            String nanosStr = (String)((SeqLike)option3.get()).apply(1);
            if ("".equals(string)) {
                return this.parseNanos(nanosStr, false);
            }
        }
        if ((option = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty()) throw new IllegalArgumentException("Interval string does not match second-nano format of ss.nnnnnnnnn");
        if (option.get() == null) throw new IllegalArgumentException("Interval string does not match second-nano format of ss.nnnnnnnnn");
        if (((SeqLike)option.get()).lengthCompare(2) != 0) throw new IllegalArgumentException("Interval string does not match second-nano format of ss.nnnnnnnnn");
        String secondsStr = (String)((SeqLike)option.get()).apply(0);
        String nanosStr = (String)((SeqLike)option.get()).apply(1);
        return Math.addExact(seconds, this.parseNanos(nanosStr, (seconds = this.parseSeconds$1(secondsStr)) < 0L));
    }

    public long getDuration(CalendarInterval interval, TimeUnit targetUnit, int daysPerMonth) {
        long monthsDuration = Math.multiplyExact((long)daysPerMonth * 86400000000L, (long)interval.months);
        long daysDuration = Math.multiplyExact(86400000000L, (long)interval.days);
        long result = Math.addExact(interval.microseconds, Math.addExact(daysDuration, monthsDuration));
        return targetUnit.convert(result, TimeUnit.MICROSECONDS);
    }

    public int getDuration$default$3() {
        return 31;
    }

    public boolean isNegative(CalendarInterval interval, int daysPerMonth) {
        return this.getDuration(interval, TimeUnit.MICROSECONDS, daysPerMonth) < 0L;
    }

    public int isNegative$default$2() {
        return 31;
    }

    private CalendarInterval fromDoubles(double monthsWithFraction, double daysWithFraction, double microsWithFraction) {
        int truncatedMonths = Math.toIntExact((long)monthsWithFraction);
        int truncatedDays = Math.toIntExact((long)daysWithFraction);
        double micros = microsWithFraction + (double)86400000000L * (daysWithFraction - (double)truncatedDays);
        return new CalendarInterval(truncatedMonths, truncatedDays, RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(micros)));
    }

    private CalendarInterval safeFromDoubles(double monthsWithFraction, double daysWithFraction, double microsWithFraction) {
        int truncatedDays = (int)daysWithFraction;
        double micros = microsWithFraction + (double)86400000000L * (daysWithFraction - (double)truncatedDays);
        return new CalendarInterval((int)monthsWithFraction, truncatedDays, RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(micros)));
    }

    public CalendarInterval negateExact(CalendarInterval interval) {
        int months = Math.negateExact(interval.months);
        int days = Math.negateExact(interval.days);
        long microseconds = Math.negateExact(interval.microseconds);
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval negate(CalendarInterval interval) {
        return new CalendarInterval(-interval.months, -interval.days, -interval.microseconds);
    }

    public CalendarInterval addExact(CalendarInterval left, CalendarInterval right) {
        int months = Math.addExact(left.months, right.months);
        int days = Math.addExact(left.days, right.days);
        long microseconds = Math.addExact(left.microseconds, right.microseconds);
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval add(CalendarInterval left, CalendarInterval right) {
        int months = left.months + right.months;
        int days = left.days + right.days;
        long microseconds = left.microseconds + right.microseconds;
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval subtractExact(CalendarInterval left, CalendarInterval right) {
        int months = Math.subtractExact(left.months, right.months);
        int days = Math.subtractExact(left.days, right.days);
        long microseconds = Math.subtractExact(left.microseconds, right.microseconds);
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval subtract(CalendarInterval left, CalendarInterval right) {
        int months = left.months - right.months;
        int days = left.days - right.days;
        long microseconds = left.microseconds - right.microseconds;
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval multiply(CalendarInterval interval, double num) {
        return this.safeFromDoubles(num * (double)interval.months, num * (double)interval.days, num * (double)interval.microseconds);
    }

    public CalendarInterval multiplyExact(CalendarInterval interval, double num) {
        return this.fromDoubles(num * (double)interval.months, num * (double)interval.days, num * (double)interval.microseconds);
    }

    public CalendarInterval divide(CalendarInterval interval, double num) {
        if (num == 0.0) {
            return null;
        }
        return this.safeFromDoubles((double)interval.months / num, (double)interval.days / num, (double)interval.microseconds / num);
    }

    public CalendarInterval divideExact(CalendarInterval interval, double num) {
        if (num == 0.0) {
            throw new ArithmeticException("divide by zero");
        }
        return this.fromDoubles((double)interval.months / num, (double)interval.days / num, (double)interval.microseconds / num);
    }

    private final UTF8String intervalStr() {
        return this.intervalStr;
    }

    private UTF8String unitToUtf8(Enumeration.Value unit) {
        return UTF8String.fromString((String)unit.toString());
    }

    private final UTF8String yearStr() {
        return this.yearStr;
    }

    private final UTF8String monthStr() {
        return this.monthStr;
    }

    private final UTF8String weekStr() {
        return this.weekStr;
    }

    private final UTF8String dayStr() {
        return this.dayStr;
    }

    private final UTF8String hourStr() {
        return this.hourStr;
    }

    private final UTF8String minuteStr() {
        return this.minuteStr;
    }

    private final UTF8String secondStr() {
        return this.secondStr;
    }

    private final UTF8String millisStr() {
        return this.millisStr;
    }

    private final UTF8String microsStr() {
        return this.microsStr;
    }

    public CalendarInterval safeStringToInterval(UTF8String input) {
        CalendarInterval calendarInterval;
        try {
            calendarInterval = this.stringToInterval(input);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            calendarInterval = null;
        }
        return calendarInterval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CalendarInterval stringToInterval(UTF8String input) {
        boolean bl;
        if (input == null) {
            throw IntervalUtils$.throwIAE$1("interval string cannot be null", IntervalUtils$.throwIAE$default$2$1(), input);
        }
        UTF8String s = input.trimAll().toLowerCase();
        byte[] bytes = s.getBytes();
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).isEmpty()) {
            throw IntervalUtils$.throwIAE$1("interval string cannot be empty", IntervalUtils$.throwIAE$default$2$1(), input);
        }
        ObjectRef state = ObjectRef.create((Object)IntervalUtils$ParseState$.MODULE$.PREFIX());
        IntRef i = IntRef.create((int)0);
        long currentValue = 0L;
        boolean isNegative = false;
        int months = 0;
        int days = 0;
        long microseconds = 0L;
        int fractionScale = 0;
        int initialFractionScale = (int)100000000L;
        int fraction = 0;
        boolean pointPrefixed = false;
        while (i.elem < bytes.length) {
            BoxedUnit boxedUnit;
            byte b = bytes[i.elem];
            Enumeration.Value value = (Enumeration.Value)state.elem;
            Enumeration.Value value2 = IntervalUtils$ParseState$.MODULE$.PREFIX();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                if (s.startsWith(this.intervalStr())) {
                    if (s.numBytes() == this.intervalStr().numBytes()) {
                        throw IntervalUtils$.throwIAE$1("interval string cannot be empty", IntervalUtils$.throwIAE$default$2$1(), input);
                    }
                    if (bytes[i.elem + this.intervalStr().numBytes()] > 32) {
                        throw IntervalUtils$.throwIAE$1(new StringBuilder(24).append("invalid interval prefix ").append(IntervalUtils$.currentWord$1(s, i)).toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                    }
                    i.elem += this.intervalStr().numBytes() + 1;
                }
                state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value4 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                IntervalUtils$.trimToNextState$1(b, IntervalUtils$ParseState$.MODULE$.SIGN(), i, state);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value6 = IntervalUtils$ParseState$.MODULE$.SIGN();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                BoxedUnit boxedUnit2;
                currentValue = 0L;
                fraction = 0;
                state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_VALUE();
                fractionScale = -1;
                pointPrefixed = false;
                byte by = b;
                if (45 == by) {
                    isNegative = true;
                    ++i.elem;
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if (43 == by) {
                    isNegative = false;
                    ++i.elem;
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if (48 <= b && b <= 57) {
                    isNegative = false;
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    if (46 != by) throw IntervalUtils$.throwIAE$1(new StringBuilder(22).append("unrecognized number '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                    isNegative = false;
                    fractionScale = initialFractionScale;
                    pointPrefixed = true;
                    ++i.elem;
                    state.elem = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value8 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_VALUE();
            Enumeration.Value value9 = value;
            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                IntervalUtils$.trimToNextState$1(b, IntervalUtils$ParseState$.MODULE$.VALUE(), i, state);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value10 = IntervalUtils$ParseState$.MODULE$.VALUE();
            Enumeration.Value value11 = value;
            if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                BoxedUnit boxedUnit3;
                byte by = b;
                if (48 <= b && b <= 57) {
                    BoxedUnit boxedUnit4;
                    try {
                        currentValue = Math.addExact(Math.multiplyExact(10L, currentValue), (long)(b - 48));
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    catch (ArithmeticException e) {
                        throw IntervalUtils$.throwIAE$1(e.getMessage(), e, input);
                    }
                    boxedUnit3 = boxedUnit4;
                } else if (b <= 32) {
                    state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_UNIT();
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    if (46 != by) throw IntervalUtils$.throwIAE$1(new StringBuilder(16).append("invalid value '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                    fractionScale = initialFractionScale;
                    state.elem = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                ++i.elem;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value12 = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
            Enumeration.Value value13 = value;
            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                if (48 <= b && b <= 57 && fractionScale > 0) {
                    fraction += (b - 48) * fractionScale;
                    fractionScale /= 10;
                } else {
                    if (b > 32 || pointPrefixed && fractionScale >= initialFractionScale) throw 48 <= b && b <= 57 ? IntervalUtils$.throwIAE$1(new StringBuilder(66).append("interval can only support nanosecond precision, '").append(IntervalUtils$.currentWord$1(s, i)).append("' is out").append(" of range").toString(), IntervalUtils$.throwIAE$default$2$1(), input) : IntervalUtils$.throwIAE$1(new StringBuilder(16).append("invalid value '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                    fraction /= (int)1000L;
                    state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_UNIT();
                }
                ++i.elem;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value14 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_UNIT();
            Enumeration.Value value15 = value;
            if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                IntervalUtils$.trimToNextState$1(b, IntervalUtils$ParseState$.MODULE$.UNIT_BEGIN(), i, state);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value16 = IntervalUtils$ParseState$.MODULE$.UNIT_BEGIN();
            Enumeration.Value value17 = value;
            if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                if (b != 115 && fractionScale >= 0) {
                    throw IntervalUtils$.throwIAE$1(new StringBuilder(30).append("'").append(IntervalUtils$.currentWord$1(s, i)).append("' cannot have fractional part").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                }
                if (isNegative) {
                    currentValue = -currentValue;
                    fraction = -fraction;
                }
                try {
                    byte by = b;
                    switch (by) {
                        case 121: {
                            if (!s.matchAt(this.yearStr(), i.elem)) throw IntervalUtils$.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            long monthsInYears = Math.multiplyExact(12L, currentValue);
                            months = Math.toIntExact(Math.addExact((long)months, monthsInYears));
                            i.elem += this.yearStr().numBytes();
                            break;
                        }
                        case 119: {
                            if (!s.matchAt(this.weekStr(), i.elem)) throw IntervalUtils$.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            long daysInWeeks = Math.multiplyExact(7L, currentValue);
                            days = Math.toIntExact(Math.addExact((long)days, daysInWeeks));
                            i.elem += this.weekStr().numBytes();
                            break;
                        }
                        case 100: {
                            if (!s.matchAt(this.dayStr(), i.elem)) throw IntervalUtils$.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            days = Math.addExact(days, Math.toIntExact(currentValue));
                            i.elem += this.dayStr().numBytes();
                            break;
                        }
                        case 104: {
                            if (!s.matchAt(this.hourStr(), i.elem)) throw IntervalUtils$.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            long hoursUs = Math.multiplyExact(currentValue, 3600000000L);
                            microseconds = Math.addExact(microseconds, hoursUs);
                            i.elem += this.hourStr().numBytes();
                            break;
                        }
                        case 115: {
                            if (!s.matchAt(this.secondStr(), i.elem)) throw IntervalUtils$.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            long secondsUs = Math.multiplyExact(currentValue, 1000000L);
                            microseconds = Math.addExact(Math.addExact(microseconds, secondsUs), (long)fraction);
                            i.elem += this.secondStr().numBytes();
                            break;
                        }
                        case 109: {
                            if (s.matchAt(this.monthStr(), i.elem)) {
                                months = Math.addExact(months, Math.toIntExact(currentValue));
                                i.elem += this.monthStr().numBytes();
                                break;
                            }
                            if (s.matchAt(this.minuteStr(), i.elem)) {
                                long minutesUs = Math.multiplyExact(currentValue, 60000000L);
                                microseconds = Math.addExact(microseconds, minutesUs);
                                i.elem += this.minuteStr().numBytes();
                                break;
                            }
                            if (s.matchAt(this.millisStr(), i.elem)) {
                                long millisUs = DateTimeUtils$.MODULE$.fromMillis(currentValue);
                                microseconds = Math.addExact(microseconds, millisUs);
                                i.elem += this.millisStr().numBytes();
                                break;
                            }
                            if (!s.matchAt(this.microsStr(), i.elem)) throw IntervalUtils$.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            microseconds = Math.addExact(microseconds, currentValue);
                            i.elem += this.microsStr().numBytes();
                            break;
                        }
                        default: {
                            throw IntervalUtils$.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                        }
                    }
                }
                catch (ArithmeticException e) {
                    throw IntervalUtils$.throwIAE$1(e.getMessage(), e, input);
                }
                state.elem = IntervalUtils$ParseState$.MODULE$.UNIT_SUFFIX();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value18 = IntervalUtils$ParseState$.MODULE$.UNIT_SUFFIX();
            Enumeration.Value value19 = value;
            if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
                byte by = b;
                switch (by) {
                    case 115: {
                        state.elem = IntervalUtils$ParseState$.MODULE$.UNIT_END();
                        break;
                    }
                    default: {
                        if (b > 32) throw IntervalUtils$.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                        state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
                        break;
                    }
                }
                ++i.elem;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value20 = IntervalUtils$ParseState$.MODULE$.UNIT_END();
            Enumeration.Value value21 = value;
            if (value20 == null) {
                if (value21 != null) {
                    throw new MatchError((Object)value);
                }
            } else if (!value20.equals(value21)) throw new MatchError((Object)value);
            if (b > 32) throw IntervalUtils$.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
            ++i.elem;
            state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
            boxedUnit = BoxedUnit.UNIT;
        }
        Enumeration.Value value = (Enumeration.Value)state.elem;
        Enumeration.Value value22 = IntervalUtils$ParseState$.MODULE$.UNIT_SUFFIX();
        Enumeration.Value value23 = value;
        if (!(value22 != null ? !value22.equals(value23) : value23 != null)) {
            bl = true;
        } else {
            Enumeration.Value value24 = IntervalUtils$ParseState$.MODULE$.UNIT_END();
            Enumeration.Value value25 = value;
            if (!(value24 != null ? !value24.equals(value25) : value25 != null)) {
                bl = true;
            } else {
                Enumeration.Value value26 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
                Enumeration.Value value27 = value;
                if (value26 == null) {
                    if (value27 != null) {
                        return null;
                    }
                } else if (!value26.equals(value27)) return null;
                bl = true;
            }
        }
        if (!bl) return null;
        CalendarInterval calendarInterval = new CalendarInterval(months, days, microseconds);
        return calendarInterval;
    }

    public CalendarInterval makeInterval(int years, int months, int weeks, int days, int hours, int mins, Decimal secs) {
        int totalMonths = Math.addExact(months, Math.multiplyExact(years, 12));
        int totalDays = Math.addExact(days, Math.multiplyExact(weeks, 7));
        long micros = secs.$times(Decimal$.MODULE$.apply(1000000L)).toLong();
        micros = Math.addExact(micros, Math.multiplyExact((long)hours, 3600000000L));
        micros = Math.addExact(micros, Math.multiplyExact((long)mins, 60000000L));
        return new CalendarInterval(totalMonths, totalDays, micros);
    }

    private final CalendarInterval toInterval$1(String yearStr, String monthStr) {
        CalendarInterval calendarInterval;
        try {
            int years = (int)this.toLongWithRange(IntervalUtils$IntervalUnit$.MODULE$.YEAR(), yearStr, 0L, Integer.MAX_VALUE);
            int months = (int)this.toLongWithRange(IntervalUtils$IntervalUnit$.MODULE$.MONTH(), monthStr, 0L, 11L);
            int totalMonths = Math.addExact(Math.multiplyExact(years, 12), months);
            calendarInterval = new CalendarInterval(totalMonths, 0, 0L);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(42).append("Error parsing interval year-month string: ").append(e.getMessage()).toString(), e);
            }
            throw throwable;
        }
        return calendarInterval;
    }

    public static final /* synthetic */ String $anonfun$parseDayTimeLegacy$1() {
        return "Interval day-time string must be not null";
    }

    public static final /* synthetic */ String $anonfun$parseDayTimeLegacy$2(String input$1) {
        return new StringBuilder(61).append("Interval string must match day-time format of 'd h:m:s.n': ").append(input$1).append(", ").append(MODULE$.fallbackNotice()).toString();
    }

    public static final /* synthetic */ String $anonfun$parseDayTime$1() {
        return "Interval day-time string must be not null";
    }

    public static final /* synthetic */ String $anonfun$parseDayTime$2(String input$2, Enumeration.Value from$1, Enumeration.Value to$1) {
        return new StringBuilder(44).append("Cannot support (interval '").append(input$2).append("' ").append(from$1).append(" to ").append(to$1).append(") expression").toString();
    }

    public static final /* synthetic */ String $anonfun$parseDayTime$3(Pattern pattern$1, String input$2) {
        return new StringBuilder(52).append("Interval string must match day-time format of '").append(pattern$1).append("': ").append(input$2).append(", ").append(MODULE$.fallbackNotice()).toString();
    }

    public static final /* synthetic */ void $anonfun$parseDayTime$4(IntRef days$1, Matcher m$1, LongRef micros$1, String input$2, Enumeration.Value from$1, Enumeration.Value to$1, Enumeration.Value x0$1) {
        Enumeration.Value value = x0$1;
        Enumeration.Value value2 = IntervalUtils$IntervalUnit$.MODULE$.DAY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Enumeration.Value value4 = value;
            days$1.elem = (int)MODULE$.toLongWithRange(value4, m$1.group(value4.toString()), 0L, Integer.MAX_VALUE);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Enumeration.Value value5 = IntervalUtils$IntervalUnit$.MODULE$.HOUR();
            Enumeration.Value value6 = value;
            if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                Enumeration.Value value7 = value;
                long parsed = MODULE$.toLongWithRange(value7, m$1.group(value7.toString()), 0L, 23L);
                micros$1.elem = Math.addExact(micros$1.elem, parsed * 3600000000L);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Enumeration.Value value8 = IntervalUtils$IntervalUnit$.MODULE$.MINUTE();
                Enumeration.Value value9 = value;
                if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                    Enumeration.Value value10 = value;
                    long parsed = MODULE$.toLongWithRange(value10, m$1.group(value10.toString()), 0L, 59L);
                    micros$1.elem = Math.addExact(micros$1.elem, parsed * 60000000L);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Enumeration.Value value11 = IntervalUtils$IntervalUnit$.MODULE$.SECOND();
                    Enumeration.Value value12 = value;
                    if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                        Enumeration.Value value13 = value;
                        micros$1.elem = Math.addExact(micros$1.elem, MODULE$.parseSecondNano(m$1.group(value13.toString())));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(44).append("Cannot support (interval '").append(input$2).append("' ").append(from$1).append(" to ").append(to$1).append(") expression").toString());
                    }
                }
            }
        }
    }

    private final long parseSeconds$1(String secondsStr) {
        return this.toLongWithRange(IntervalUtils$IntervalUnit$.MODULE$.SECOND(), secondsStr, -9223372036854L, 9223372036854L) * 1000000L;
    }

    private static final Nothing$ throwIAE$1(String msg, Exception e, UTF8String input$3) {
        throw new IllegalArgumentException(new StringBuilder(30).append("Error parsing '").append(input$3).append("' to interval, ").append(msg).toString(), e);
    }

    private static final Exception throwIAE$default$2$1() {
        return null;
    }

    private static final void trimToNextState$1(byte b, Enumeration.Value next, IntRef i$1, ObjectRef state$1) {
        if (b <= 32) {
            ++i$1.elem;
        } else {
            state$1.elem = next;
        }
    }

    private static final String currentWord$1(UTF8String s$1, IntRef i$1) {
        String sep = "\\s+";
        String[] strings = s$1.toString().split(sep);
        int lenRight = s$1.substring(i$1.elem, s$1.numBytes()).toString().split(sep).length;
        return strings[strings.length - lenRight];
    }

    private IntervalUtils$() {
        MODULE$ = this;
        this.yearMonthPattern = new StringOps(Predef$.MODULE$.augmentString("^([+|-])?(\\d+)-(\\d+)$")).r();
        this.dayTimePatternLegacy = new StringOps(Predef$.MODULE$.augmentString("^([+|-])?((\\d+) )?((\\d+):)?(\\d+):(\\d+)(\\.(\\d+))?$")).r();
        this.fallbackNotice = new StringBuilder(54).append("set ").append(SQLConf$.MODULE$.LEGACY_FROM_DAYTIME_STRING().key()).append(" to true ").append("to restore the behavior before Spark 3.0.").toString();
        this.signRe = "(?<sign>[+|-])";
        this.dayRe = "(?<day>\\d+)";
        this.hourRe = "(?<hour>\\d{1,2})";
        this.minuteRe = "(?<minute>\\d{1,2})";
        this.secondRe = "(?<second>(\\d{1,2})(\\.(\\d{1,9}))?)";
        this.dayTimePattern = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)IntervalUtils$IntervalUnit$.MODULE$.MINUTE(), (Object)IntervalUtils$IntervalUnit$.MODULE$.SECOND())), (Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(4).append("^").append(this.signRe()).append("?").append(this.minuteRe()).append(":").append(this.secondRe()).append("$").toString())).r()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)IntervalUtils$IntervalUnit$.MODULE$.HOUR(), (Object)IntervalUtils$IntervalUnit$.MODULE$.MINUTE())), (Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(4).append("^").append(this.signRe()).append("?").append(this.hourRe()).append(":").append(this.minuteRe()).append("$").toString())).r()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)IntervalUtils$IntervalUnit$.MODULE$.HOUR(), (Object)IntervalUtils$IntervalUnit$.MODULE$.SECOND())), (Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(5).append("^").append(this.signRe()).append("?").append(this.hourRe()).append(":").append(this.minuteRe()).append(":").append(this.secondRe()).append("$").toString())).r()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)IntervalUtils$IntervalUnit$.MODULE$.DAY(), (Object)IntervalUtils$IntervalUnit$.MODULE$.HOUR())), (Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(4).append("^").append(this.signRe()).append("?").append(this.dayRe()).append(" ").append(this.hourRe()).append("$").toString())).r()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)IntervalUtils$IntervalUnit$.MODULE$.DAY(), (Object)IntervalUtils$IntervalUnit$.MODULE$.MINUTE())), (Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(5).append("^").append(this.signRe()).append("?").append(this.dayRe()).append(" ").append(this.hourRe()).append(":").append(this.minuteRe()).append("$").toString())).r()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)IntervalUtils$IntervalUnit$.MODULE$.DAY(), (Object)IntervalUtils$IntervalUnit$.MODULE$.SECOND())), (Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(6).append("^").append(this.signRe()).append("?").append(this.dayRe()).append(" ").append(this.hourRe()).append(":").append(this.minuteRe()).append(":").append(this.secondRe()).append("$").toString())).r())}));
        this.intervalStr = UTF8String.fromString((String)"interval");
        this.yearStr = this.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.YEAR());
        this.monthStr = this.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.MONTH());
        this.weekStr = this.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.WEEK());
        this.dayStr = this.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.DAY());
        this.hourStr = this.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.HOUR());
        this.minuteStr = this.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.MINUTE());
        this.secondStr = this.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.SECOND());
        this.millisStr = this.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.MILLISECOND());
        this.microsStr = this.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.MICROSECOND());
    }

    public static final /* synthetic */ Object $anonfun$parseDayTime$4$adapted(IntRef days$1, Matcher m$1, LongRef micros$1, String input$2, Enumeration.Value from$1, Enumeration.Value to$1, Enumeration.Value x0$1) {
        IntervalUtils$.$anonfun$parseDayTime$4(days$1, m$1, micros$1, input$2, from$1, to$1, x0$1);
        return BoxedUnit.UNIT;
    }
}

