/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.catalyst.util.DateTimeFormatterHelper;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.Iso8601TimestampFormatter$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\n\u0015\u0001\u0005B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tw\u0001\u0011\t\u0011)A\u0005y!AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!q\u0006A!A!\u0002\u0013y\u0006\"\u00022\u0001\t\u0003\u0019\u0007\u0002\u00036\u0001\u0011\u000b\u0007I\u0011C6\t\u0011Y\u0004\u0001R1A\u0005\u0012]DQ!\u001f\u0001\u0005BiDaa\u001c\u0001\u0005B\u0005\u0005\u0001BB8\u0001\t\u0003\ni\u0001\u0003\u0004p\u0001\u0011\u0005\u00131\u0003\u0005\b\u0003G\u0001A\u0011IA\u0013\u000f%\ti\u0003FA\u0001\u0012\u0003\tyC\u0002\u0005\u0014)\u0005\u0005\t\u0012AA\u0019\u0011\u0019\u0011w\u0002\"\u0001\u0002:!I\u00111H\b\u0012\u0002\u0013\u0005\u0011Q\b\u0005\n\u0003'z\u0011\u0011!C\u0005\u0003+\u0012\u0011$S:pqY\u0002\u0014\u0007V5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e;fe*\u0011QCF\u0001\u0005kRLGN\u0003\u0002\u00181\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u001a5\u0005\u00191/\u001d7\u000b\u0005ma\u0012!B:qCJ\\'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001E!b\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g\r\u0005\u0002*U5\tA#\u0003\u0002,)\t\u0011B+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s!\tIS&\u0003\u0002/)\t9B)\u0019;f)&lWMR8s[\u0006$H/\u001a:IK2\u0004XM]\u0001\ba\u0006$H/\u001a:o!\t\t\u0004H\u0004\u00023mA\u00111\u0007J\u0007\u0002i)\u0011Q\u0007I\u0001\u0007yI|w\u000e\u001e \n\u0005]\"\u0013A\u0002)sK\u0012,g-\u0003\u0002:u\t11\u000b\u001e:j]\u001eT!a\u000e\u0013\u0002\ri|g.Z%e!\ti$)D\u0001?\u0015\ty\u0004)\u0001\u0003uS6,'\"A!\u0002\t)\fg/Y\u0005\u0003\u0007z\u0012aAW8oK&#\u0017A\u00027pG\u0006dW\r\u0005\u0002G\u00116\tqI\u0003\u0002\u0016\u0001&\u0011\u0011j\u0012\u0002\u0007\u0019>\u001c\u0017\r\\3\u0002\u00191,w-Y2z\r>\u0014X.\u0019;\u0011\u00051[fBA'Z\u001d\tq\u0005L\u0004\u0002P/:\u0011\u0001K\u0016\b\u0003#Vs!A\u0015+\u000f\u0005M\u001a\u0016\"A\u0010\n\u0005uq\u0012BA\u000e\u001d\u0013\tI\"$\u0003\u0002\u00181%\u0011QCF\u0005\u00035R\t\u0011\u0003T3hC\u000eLH)\u0019;f\r>\u0014X.\u0019;t\u0013\taVL\u0001\tMK\u001e\f7-\u001f#bi\u00164uN]7bi*\u0011!\fF\u0001\nSN\u0004\u0016M]:j]\u001e\u0004\"a\t1\n\u0005\u0005$#a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0011,gm\u001a5j!\tI\u0003\u0001C\u00030\r\u0001\u0007\u0001\u0007C\u0003<\r\u0001\u0007A\bC\u0003E\r\u0001\u0007Q\tC\u0004K\rA\u0005\t\u0019A&\t\u000by3\u0001\u0019A0\u0002\u0013\u0019|'/\\1ui\u0016\u0014X#\u00017\u0011\u00055\u0004X\"\u00018\u000b\u0005=t\u0014A\u00024pe6\fG/\u0003\u0002r]\n\tB)\u0019;f)&lWMR8s[\u0006$H/\u001a:)\u0005\u001d\u0019\bCA\u0012u\u0013\t)HEA\u0005ue\u0006t7/[3oi\u0006yA.Z4bGf4uN]7biR,'/F\u0001)Q\tA1/A\u0003qCJ\u001cX\r\u0006\u0002|}B\u00111\u0005`\u0005\u0003{\u0012\u0012A\u0001T8oO\")q0\u0003a\u0001a\u0005\t1\u000fF\u00021\u0003\u0007Aq!!\u0002\u000b\u0001\u0004\t9!A\u0004j]N$\u0018M\u001c;\u0011\u0007u\nI!C\u0002\u0002\fy\u0012q!\u00138ti\u0006tG\u000fF\u00021\u0003\u001fAa!!\u0005\f\u0001\u0004Y\u0018AA;t)\r\u0001\u0014Q\u0003\u0005\b\u0003/a\u0001\u0019AA\r\u0003\t!8\u000f\u0005\u0003\u0002\u001c\u0005}QBAA\u000f\u0015\tI\u0002)\u0003\u0003\u0002\"\u0005u!!\u0003+j[\u0016\u001cH/Y7q\u0003U1\u0018\r\\5eCR,\u0007+\u0019;uKJt7\u000b\u001e:j]\u001e$\"!a\n\u0011\u0007\r\nI#C\u0002\u0002,\u0011\u0012A!\u00168ji\u0006I\u0012j]89mA\nD+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s!\tIsb\u0005\u0003\u0010E\u0005M\u0002cA\u0012\u00026%\u0019\u0011q\u0007\u0013\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\u0005=\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002@)\u001a1*!\u0011,\u0005\u0005\r\u0003\u0003BA#\u0003\u001fj!!a\u0012\u000b\t\u0005%\u00131J\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0014%\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003#\n9EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u000b\t\u0005\u00033\ny&\u0004\u0002\u0002\\)\u0019\u0011Q\f!\u0002\t1\fgnZ\u0005\u0005\u0003C\nYF\u0001\u0004PE*,7\r\u001e")
public class Iso8601TimestampFormatter
implements TimestampFormatter,
DateTimeFormatterHelper {
    private transient DateTimeFormatter formatter;
    private transient TimestampFormatter legacyFormatter;
    private final String pattern;
    private final ZoneId zoneId;
    private final Locale locale;
    private final Enumeration.Value legacyFormat;
    private final boolean isParsing;
    private volatile transient byte bitmap$trans$0;

    public static Enumeration.Value $lessinit$greater$default$4() {
        return Iso8601TimestampFormatter$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public LocalDate toLocalDate(TemporalAccessor accessor) {
        return DateTimeFormatterHelper.toLocalDate$(this, accessor);
    }

    @Override
    public ZonedDateTime toZonedDateTime(TemporalAccessor accessor, ZoneId zoneId) {
        return DateTimeFormatterHelper.toZonedDateTime$(this, accessor, zoneId);
    }

    @Override
    public DateTimeFormatter getOrCreateFormatter(String pattern, Locale locale, boolean isParsing) {
        return DateTimeFormatterHelper.getOrCreateFormatter$(this, pattern, locale, isParsing);
    }

    @Override
    public <T> PartialFunction<Throwable, T> checkParsedDiff(String s, Function1<String, T> legacyParseFunc) {
        return DateTimeFormatterHelper.checkParsedDiff$(this, s, legacyParseFunc);
    }

    @Override
    public <T extends Date> PartialFunction<Throwable, String> checkFormattedDiff(T d, Function1<T, String> legacyFormatFunc) {
        return DateTimeFormatterHelper.checkFormattedDiff$(this, d, legacyFormatFunc);
    }

    @Override
    public PartialFunction<Throwable, DateTimeFormatter> checkLegacyFormatter(String pattern, Function0<BoxedUnit> tryLegacyFormatter) {
        return DateTimeFormatterHelper.checkLegacyFormatter$(this, pattern, tryLegacyFormatter);
    }

    private DateTimeFormatter formatter$lzycompute() {
        Iso8601TimestampFormatter iso8601TimestampFormatter = this;
        synchronized (iso8601TimestampFormatter) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatter = this.getOrCreateFormatter(this.pattern, this.locale, this.isParsing);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatter;
    }

    public DateTimeFormatter formatter() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.formatter$lzycompute() : this.formatter;
    }

    private TimestampFormatter legacyFormatter$lzycompute() {
        Iso8601TimestampFormatter iso8601TimestampFormatter = this;
        synchronized (iso8601TimestampFormatter) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.legacyFormatter = TimestampFormatter$.MODULE$.getLegacyFormatter(this.pattern, this.zoneId, this.locale, this.legacyFormat);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.legacyFormatter;
    }

    public TimestampFormatter legacyFormatter() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.legacyFormatter$lzycompute() : this.legacyFormatter;
    }

    @Override
    public long parse(String s) {
        Option<Object> specialDate = DateTimeUtils$.MODULE$.convertSpecialTimestamp(s.trim(), this.zoneId);
        return BoxesRunTime.unboxToLong((Object)specialDate.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            long l;
            try {
                TemporalAccessor parsed = this.formatter().parse(s);
                ZoneId parsedZoneId = parsed.query(TemporalQueries.zone());
                ZoneId timeZoneId = parsedZoneId == null ? $this.zoneId : parsedZoneId;
                ZonedDateTime zonedDateTime = this.toZonedDateTime(parsed, timeZoneId);
                long epochSeconds = zonedDateTime.toEpochSecond();
                int microsOfSecond = zonedDateTime.get(ChronoField.MICRO_OF_SECOND);
                l = Math.addExact(TimeUnit.SECONDS.toMicros(epochSeconds), (long)microsOfSecond);
            }
            catch (Throwable x$1) {
                PartialFunction catchExpr$1 = this.checkParsedDiff(s, (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToLong((long)Iso8601TimestampFormatter.$anonfun$parse$2(this, s)));
                if (catchExpr$1.isDefinedAt((Object)x$1)) {
                    l = BoxesRunTime.unboxToLong((Object)catchExpr$1.apply((Object)x$1));
                }
                throw x$1;
            }
            return l;
        }));
    }

    @Override
    public String format(Instant instant) {
        String string;
        try {
            string = this.formatter().withZone(this.zoneId).format(instant);
        }
        catch (Throwable x$2) {
            PartialFunction<Throwable, String> catchExpr$2 = this.checkFormattedDiff(DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.instantToMicros(instant)), (Function1 & Serializable & scala.Serializable)t -> this.format((Timestamp)t));
            if (catchExpr$2.isDefinedAt((Object)x$2)) {
                string = (String)catchExpr$2.apply((Object)x$2);
            }
            throw x$2;
        }
        return string;
    }

    @Override
    public String format(long us) {
        Instant instant = DateTimeUtils$.MODULE$.microsToInstant(us);
        return this.format(instant);
    }

    @Override
    public String format(Timestamp ts) {
        return this.legacyFormatter().format(ts);
    }

    @Override
    public void validatePatternString() {
        try {
            this.formatter();
        }
        catch (Throwable x$3) {
            PartialFunction<Throwable, DateTimeFormatter> catchExpr$3 = this.checkLegacyFormatter(this.pattern, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.legacyFormatter().validatePatternString());
            if (catchExpr$3.isDefinedAt((Object)x$3)) {
                catchExpr$3.apply((Object)x$3);
            }
            throw x$3;
        }
    }

    public static final /* synthetic */ long $anonfun$parse$2(Iso8601TimestampFormatter $this, String s) {
        return $this.legacyFormatter().parse(s);
    }

    public Iso8601TimestampFormatter(String pattern, ZoneId zoneId, Locale locale, Enumeration.Value legacyFormat, boolean isParsing) {
        this.pattern = pattern;
        this.zoneId = zoneId;
        this.locale = locale;
        this.legacyFormat = legacyFormat;
        this.isParsing = isParsing;
        DateTimeFormatterHelper.$init$(this);
    }
}

