/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp, fmt) - Converts `timestamp` to a value of string in the format specified by the date format `fmt`.", arguments="\n    Arguments:\n      * timestamp - A date/timestamp or string to be converted to the given format.\n      * fmt - Date/time format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid date\n              and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-04-08', 'y');\n       2016\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0015b\u0001B\u0012%\u0001FB\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011!i\u0005A!f\u0001\n\u0003q\u0005\u0002C/\u0001\u0005#\u0005\u000b\u0011B(\t\u000by\u0003A\u0011A0\t\u000by\u0003A\u0011\u00013\t\u000b\u001d\u0004A\u0011\t5\t\u000b=\u0004A\u0011\t9\t\u000bu\u0004A\u0011\t@\t\u0015\u0005\u0005\u0001\u0001#b\u0001\n\u0013\t\u0019\u0001C\u0004\u0002\u001c\u0001!\t&!\b\t\u000f\u00055\u0002\u0001\"\u0011\u00020!9\u00111\n\u0001\u0005B\u00055\u0003\"CA(\u0001\u0005\u0005I\u0011AA)\u0011%\tI\u0006AI\u0001\n\u0003\tY\u0006C\u0005\u0002r\u0001\t\n\u0011\"\u0001\u0002\\!I\u00111\u000f\u0001\u0012\u0002\u0013\u0005\u0011Q\u000f\u0005\n\u0003s\u0002\u0011\u0011!C!\u0003wB\u0011\"a#\u0001\u0003\u0003%\t!!$\t\u0013\u0005U\u0005!!A\u0005\u0002\u0005]\u0005\"CAO\u0001\u0005\u0005I\u0011IAP\u0011%\ti\u000bAA\u0001\n\u0003\ty\u000bC\u0005\u0002:\u0002\t\t\u0011\"\u0011\u0002<\u001eI\u0011Q\u001d\u0013\u0002\u0002#\u0005\u0011q\u001d\u0004\tG\u0011\n\t\u0011#\u0001\u0002j\"1al\u0007C\u0001\u0003oD\u0011\"!?\u001c\u0003\u0003%)%a?\t\u0013\u0005u8$!A\u0005\u0002\u0006}\b\"\u0003B\u00047E\u0005I\u0011AA;\u0011%\u0011IaGA\u0001\n\u0003\u0013Y\u0001C\u0005\u0003\u001am\t\n\u0011\"\u0001\u0002v!I!1D\u000e\u0002\u0002\u0013%!Q\u0004\u0002\u0010\t\u0006$XMR8s[\u0006$8\t\\1tg*\u0011QEJ\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002(Q\u0005A1-\u0019;bYf\u001cHO\u0003\u0002*U\u0005\u00191/\u001d7\u000b\u0005-b\u0013!B:qCJ\\'BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001eYJDH\u0011\t\u0003gQj\u0011\u0001J\u0005\u0003k\u0011\u0012\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005M:\u0014B\u0001\u001d%\u0005]!\u0016.\\3[_:,\u0017i^1sK\u0016C\bO]3tg&|g\u000e\u0005\u00024u%\u00111\b\n\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011Q\bQ\u0007\u0002})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B}\t9\u0001K]8ek\u000e$\bCA\u001fD\u0013\t!eH\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003mK\u001a$X#A$\u0011\u0005MB\u0015BA%%\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\u0015QLW.\u001a.p]\u0016LE-F\u0001P!\ri\u0004KU\u0005\u0003#z\u0012aa\u00149uS>t\u0007CA*[\u001d\t!\u0006\f\u0005\u0002V}5\taK\u0003\u0002Xa\u00051AH]8pizJ!!\u0017 \u0002\rA\u0013X\rZ3g\u0013\tYFL\u0001\u0004TiJLgn\u001a\u0006\u00033z\n1\u0002^5nKj{g.Z%eA\u00051A(\u001b8jiz\"B\u0001Y1cGB\u00111\u0007\u0001\u0005\u0006\u000b\u001e\u0001\ra\u0012\u0005\u0006\u0017\u001e\u0001\ra\u0012\u0005\b\u001b\u001e\u0001\n\u00111\u0001P)\r\u0001WM\u001a\u0005\u0006\u000b\"\u0001\ra\u0012\u0005\u0006\u0017\"\u0001\raR\u0001\tI\u0006$\u0018\rV=qKV\t\u0011\u000e\u0005\u0002k[6\t1N\u0003\u0002mQ\u0005)A/\u001f9fg&\u0011an\u001b\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003E\u00042A]<{\u001d\t\u0019XO\u0004\u0002Vi&\tq(\u0003\u0002w}\u00059\u0001/Y2lC\u001e,\u0017B\u0001=z\u0005\r\u0019V-\u001d\u0006\u0003mz\u0002\"A[>\n\u0005q\\'\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\t1t\u0010C\u0003N\u0017\u0001\u0007!+A\u0005g_Jl\u0017\r\u001e;feV\u0011\u0011Q\u0001\t\u0005{A\u000b9\u0001\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\tiAJ\u0001\u0005kRLG.\u0003\u0003\u0002\u0012\u0005-!A\u0005+j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJD3\u0001DA\u000b!\ri\u0014qC\u0005\u0004\u00033q$!\u0003;sC:\u001c\u0018.\u001a8u\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0019\ty\"!\n\u0002*A\u0019Q(!\t\n\u0007\u0005\rbHA\u0002B]fDq!a\n\u000e\u0001\u0004\ty\"A\u0005uS6,7\u000f^1na\"9\u00111F\u0007A\u0002\u0005}\u0011A\u00024pe6\fG/A\u0005e_\u001e+gnQ8eKR1\u0011\u0011GA\u001f\u0003\u000f\u0002B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003o!\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003w\t)D\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tyD\u0004a\u0001\u0003\u0003\n1a\u0019;y!\u0011\t\u0019$a\u0011\n\t\u0005\u0015\u0013Q\u0007\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\tIE\u0004a\u0001\u0003c\t!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001S\u0003\u0011\u0019w\u000e]=\u0015\u000f\u0001\f\u0019&!\u0016\u0002X!9Q\t\u0005I\u0001\u0002\u00049\u0005bB&\u0011!\u0003\u0005\ra\u0012\u0005\b\u001bB\u0001\n\u00111\u0001P\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0018+\u0007\u001d\u000byf\u000b\u0002\u0002bA!\u00111MA7\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014!C;oG\",7m[3e\u0015\r\tYGP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA8\u0003K\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002x)\u001aq*a\u0018\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\b\u0005\u0003\u0002\u0000\u0005%UBAAA\u0015\u0011\t\u0019)!\"\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000f\u000bAA[1wC&\u00191,!!\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005=\u0005cA\u001f\u0002\u0012&\u0019\u00111\u0013 \u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005}\u0011\u0011\u0014\u0005\n\u000373\u0012\u0011!a\u0001\u0003\u001f\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAQ!\u0019\t\u0019+!+\u0002 5\u0011\u0011Q\u0015\u0006\u0004\u0003Os\u0014AC2pY2,7\r^5p]&!\u00111VAS\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005E\u0016q\u0017\t\u0004{\u0005M\u0016bAA[}\t9!i\\8mK\u0006t\u0007\"CAN1\u0005\u0005\t\u0019AA\u0010\u0003\u0019)\u0017/^1mgR!\u0011\u0011WA_\u0011%\tY*GA\u0001\u0002\u0004\ty\u0002K\f\u0001\u0003\u0003\f9-!3\u0002N\u0006=\u00171[Ak\u00033\fY.a8\u0002bB\u00191'a1\n\u0007\u0005\u0015GEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005-\u0017\u0001^0G+:\u001bu\f\u000b;j[\u0016\u001cH/Y7qY\u00012W\u000e^\u0015![\u0001\u001auN\u001c<feR\u001c\b\u0005\u0019;j[\u0016\u001cH/Y7qA\u0002\"x\u000eI1!m\u0006dW/\u001a\u0011pM\u0002\u001aHO]5oO\u0002Jg\u000e\t;iK\u00022wN]7bi\u0002\u001a\b/Z2jM&,G\r\t2zAQDW\r\t3bi\u0016\u0004cm\u001c:nCR\u0004\u0003MZ7uA:\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005E\u0017A!\u001c\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"\u0018.\\3ti\u0006l\u0007\u000fI\u0017!\u0003\u0002\"\u0017\r^30i&lWm\u001d;b[B\u0004sN\u001d\u0011tiJLgn\u001a\u0011u_\u0002\u0012W\rI2p]Z,'\u000f^3eAQ|\u0007\u0005\u001e5fA\u001dLg/\u001a8!M>\u0014X.\u0019;/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u00012W\u000e\u001e\u0011.A\u0011\u000bG/Z\u0018uS6,\u0007EZ8s[\u0006$\b\u0005]1ui\u0016\u0014h\u000e\t;pA\u0019|G\u000e\\8x]\u0001\u001aV-\u001a\u0011=C\u0002B'/\u001a4>E!$H\u000f]:;_=\u001a\b/\u0019:l]\u0005\u0004\u0018m\u00195f]=\u0014xm\f3pGN|C.\u0019;fgR|3/\u001d7.e\u00164W\u0006Z1uKRLW.Z\u0017qCR$XM\u001d8/QRlGN\t ECR,G/[7fAA\u000bG\u000f^3s]Ndt&\u0019 !M>\u0014\bE^1mS\u0012\u0004C-\u0019;f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0005tG\r\t;j[\u0016\u0004cm\u001c:nCR\u0004\u0003/\u0019;uKJt7O\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002X\u00069%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aE2T\u0006\r\u001b.aa:C\u0006I\u0014zO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192m)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002^\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAr\u0003\u0015\td&\u000e\u00181\u0003=!\u0015\r^3G_Jl\u0017\r^\"mCN\u001c\bCA\u001a\u001c'\u0011Y\u00121\u001e\"\u0011\u0011\u00055\u00181_$H\u001f\u0002l!!a<\u000b\u0007\u0005Eh(A\u0004sk:$\u0018.\\3\n\t\u0005U\u0018q\u001e\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDCAAt\u0003!!xn\u0015;sS:<GCAA?\u0003\u0015\t\u0007\u000f\u001d7z)\u001d\u0001'\u0011\u0001B\u0002\u0005\u000bAQ!\u0012\u0010A\u0002\u001dCQa\u0013\u0010A\u0002\u001dCq!\u0014\u0010\u0011\u0002\u0003\u0007q*A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003\u001d)h.\u00199qYf$BA!\u0004\u0003\u0016A!Q\b\u0015B\b!\u0019i$\u0011C$H\u001f&\u0019!1\u0003 \u0003\rQ+\b\u000f\\34\u0011!\u00119\u0002IA\u0001\u0002\u0004\u0001\u0017a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1B]3bIJ+7o\u001c7wKR\u0011!q\u0004\t\u0005\u0003\u007f\u0012\t#\u0003\u0003\u0003$\u0005\u0005%AB(cU\u0016\u001cG\u000f")
public class DateFormatClass
extends BinaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
scala.Serializable {
    private transient Option<TimestampFormatter> formatter;
    private final Expression left;
    private final Expression right;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return DateFormatClass$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(DateFormatClass dateFormatClass) {
        return DateFormatClass$.MODULE$.unapply(dateFormatClass);
    }

    public static Option<String> apply$default$3() {
        return DateFormatClass$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, DateFormatClass> tupled() {
        return DateFormatClass$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, DateFormatClass>>> curried() {
        return DateFormatClass$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    private Option<TimestampFormatter> formatter$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatter = this.right().foldable() ? Option$.MODULE$.apply(this.right().eval(this.right().eval$default$1())).map((Function1 & Serializable & scala.Serializable)format -> TimestampFormatter$.MODULE$.apply(format.toString(), this.zoneId(), LegacyDateFormats$.MODULE$.SIMPLE_DATE_FORMAT(), false)) : None$.MODULE$;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatter;
    }

    private Option<TimestampFormatter> formatter() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.formatter$lzycompute() : this.formatter;
    }

    @Override
    public Object nullSafeEval(Object timestamp, Object format) {
        TimestampFormatter tf = this.formatter().isEmpty() ? TimestampFormatter$.MODULE$.apply(format.toString(), this.zoneId(), LegacyDateFormats$.MODULE$.SIMPLE_DATE_FORMAT(), false) : (TimestampFormatter)this.formatter().get();
        return UTF8String.fromString((String)tf.format(BoxesRunTime.unboxToLong((Object)timestamp)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return (ExprCode)this.formatter().map((Function1 & Serializable & scala.Serializable)tf -> {
            String timestampFormatter = ctx.addReferenceObj("timestampFormatter", tf, ctx.addReferenceObj$default$3());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(timestamp, x$1) -> new StringBuilder(32).append("UTF8String.fromString(").append(timestampFormatter).append(".format(").append((String)timestamp).append("))").toString());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String tf = new StringOps(Predef$.MODULE$.augmentString(TimestampFormatter$.MODULE$.getClass().getName())).stripSuffix("$");
            String ldf = new StringOps(Predef$.MODULE$.augmentString(LegacyDateFormats$.MODULE$.getClass().getName())).stripSuffix("$");
            String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(timestamp, format) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(177).append("|UTF8String.fromString(").append(tf).append("$.MODULE$.apply(\n            |  ").append((String)format).append(".toString(),\n            |  ").append(zid).append(",\n            |  ").append(ldf).append("$.MODULE$.SIMPLE_DATE_FORMAT(),\n            |  false)\n            |.format(").append((String)timestamp).append("))").toString())).stripMargin());
        });
    }

    @Override
    public String prettyName() {
        return "date_format";
    }

    public DateFormatClass copy(Expression left, Expression right, Option<String> timeZoneId) {
        return new DateFormatClass(left, right, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "DateFormatClass";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.left();
                break;
            }
            case 1: {
                option = this.right();
                break;
            }
            case 2: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DateFormatClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DateFormatClass)) return false;
        boolean bl = true;
        if (!bl) return false;
        DateFormatClass dateFormatClass = (DateFormatClass)x$1;
        Expression expression = this.left();
        Expression expression2 = dateFormatClass.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = dateFormatClass.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = dateFormatClass.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!dateFormatClass.canEqual(this)) return false;
        return true;
    }

    public DateFormatClass(Expression left, Expression right, Option<String> timeZoneId) {
        this.left = left;
        this.right = right;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public DateFormatClass(Expression left, Expression right) {
        this(left, right, (Option<String>)None$.MODULE$);
    }
}

