/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ElementAt$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetArrayItemUtil;
import org.apache.spark.sql.catalyst.expressions.GetMapValueUtil;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array, index) - Returns element of array at given (1-based) index. If index < 0,\n      accesses elements from the last to the first. Returns NULL if the index exceeds the length\n      of the array.\n\n    _FUNC_(map, key) - Returns value for given key, or NULL if the key is not contained in the map\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), 2);\n       2\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), 2);\n       b\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\tMa\u0001B\u0011#\u0001>B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005\u000b\"A\u0011\n\u0001BK\u0002\u0013\u0005A\t\u0003\u0005K\u0001\tE\t\u0015!\u0003F\u0011\u0015Y\u0005\u0001\"\u0001M\u0011!\u0001\u0006\u0001#b\u0001\n\u0013\t\u0006\u0002\u0003/\u0001\u0011\u000b\u0007I\u0011B/\t\u0011\t\u0004\u0001R1A\u0005\n\rD\u0001\u0002\u001e\u0001\t\u0006\u0004%\t%\u0015\u0005\u0006m\u0002!\te\u001e\u0005\u0006}\u0002!\te \u0005\u0007\u0003\u001b\u0001A\u0011I/\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!Q\u00111\u0004\u0001\t\u0006\u0004%I!!\b\t\u000f\u0005\u001d\u0002\u0001\"\u0011\u0002*!9\u0011Q\t\u0001\u0005B\u0005\u001d\u0003\"CA-\u0001\u0005\u0005I\u0011AA.\u0011%\t\t\u0007AI\u0001\n\u0003\t\u0019\u0007C\u0005\u0002z\u0001\t\n\u0011\"\u0001\u0002d!I\u00111\u0010\u0001\u0002\u0002\u0013\u0005\u0013Q\u0010\u0005\n\u0003\u001b\u0003\u0011\u0011!C\u0001\u0003\u001fC\u0011\"a&\u0001\u0003\u0003%\t!!'\t\u0013\u0005}\u0005!!A\u0005B\u0005\u0005\u0006\"CAX\u0001\u0005\u0005I\u0011AAY\u0011%\t)\fAA\u0001\n\u0003\n9lB\u0005\u0002V\n\n\t\u0011#\u0001\u0002X\u001aA\u0011EIA\u0001\u0012\u0003\tI\u000e\u0003\u0004L7\u0011\u0005\u0011q\u001d\u0005\n\u0003S\\\u0012\u0011!C#\u0003WD\u0011\"!<\u001c\u0003\u0003%\t)a<\t\u0013\u0005U8$!A\u0005\u0002\u0006]\b\"\u0003B\u00057\u0005\u0005I\u0011\u0002B\u0006\u0005%)E.Z7f]R\fEO\u0003\u0002$I\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)c%\u0001\u0005dCR\fG._:u\u0015\t9\u0003&A\u0002tc2T!!\u000b\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0001\u0007N\u001c;\u0001B\u0011\u0011GM\u0007\u0002E%\u00111G\t\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"!M\u001b\n\u0005Y\u0012#aD$fi6\u000b\u0007OV1mk\u0016,F/\u001b7\u0011\u0005EB\u0014BA\u001d#\u0005A9U\r^!se\u0006L\u0018\n^3n+RLG\u000e\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDHA\u0004Qe>$Wo\u0019;\u0011\u0005m\n\u0015B\u0001\"=\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003\u0015\u0003\"!\r$\n\u0005\u001d\u0013#AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0001P5oSRtDcA'O\u001fB\u0011\u0011\u0007\u0001\u0005\u0006\u0007\u0016\u0001\r!\u0012\u0005\u0006\u0013\u0016\u0001\r!R\u0001\u000b[\u0006\u00048*Z=UsB,W#\u0001*\u0011\u0005M3V\"\u0001+\u000b\u0005U3\u0013!\u0002;za\u0016\u001c\u0018BA,U\u0005!!\u0015\r^1UsB,\u0007F\u0001\u0004Z!\tY$,\u0003\u0002\\y\tIAO]1og&,g\u000e^\u0001\u0012CJ\u0014\u0018-_\"p]R\f\u0017N\\:Ok2dW#\u00010\u0011\u0005mz\u0016B\u00011=\u0005\u001d\u0011un\u001c7fC:D#aB-\u0002\u0011=\u0014H-\u001a:j]\u001e,\u0012\u0001\u001a\t\u0004K6\u0004hB\u00014l\u001d\t9'.D\u0001i\u0015\tIg&\u0001\u0004=e>|GOP\u0005\u0002{%\u0011A\u000eP\u0001\ba\u0006\u001c7.Y4f\u0013\tqwN\u0001\u0005Pe\u0012,'/\u001b8h\u0015\taG\b\u0005\u0002<c&\u0011!\u000f\u0010\u0002\u0004\u0003:L\bF\u0001\u0005Z\u0003!!\u0017\r^1UsB,\u0007FA\u0005Z\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002qB\u0019Q-_>\n\u0005i|'aA*fcB\u00111\u000b`\u0005\u0003{R\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001dA%\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\tY!!\u0002\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f\u0001B\\;mY\u0006\u0014G.Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0006a\u0006M\u0011q\u0003\u0005\u0007\u0003+i\u0001\u0019\u00019\u0002\u000bY\fG.^3\t\r\u0005eQ\u00021\u0001q\u0003\u001dy'\u000fZ5oC2\f1\u0002Z8FY\u0016lWM\u001c;BiV\u0011\u0011q\u0004\t\u0007w\u0005\u0005\u0002\u000f\u001d9\n\u0007\u0005\rBHA\u0005Gk:\u001cG/[8oe!\u0012a\"W\u0001\nI><UM\\\"pI\u0016$b!a\u000b\u00028\u0005\u0005\u0003\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005E\"%A\u0004d_\u0012,w-\u001a8\n\t\u0005U\u0012q\u0006\u0002\t\u000bb\u0004(oQ8eK\"9\u0011\u0011H\bA\u0002\u0005m\u0012aA2uqB!\u0011QFA\u001f\u0013\u0011\ty$a\f\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u00111I\bA\u0002\u0005-\u0012AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003\u0013\u0002B!a\u0013\u0002T9!\u0011QJA(!\t9G(C\u0002\u0002Rq\na\u0001\u0015:fI\u00164\u0017\u0002BA+\u0003/\u0012aa\u0015;sS:<'bAA)y\u0005!1m\u001c9z)\u0015i\u0015QLA0\u0011\u001d\u0019\u0015\u0003%AA\u0002\u0015Cq!S\t\u0011\u0002\u0003\u0007Q)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0015$fA#\u0002h-\u0012\u0011\u0011\u000e\t\u0005\u0003W\n)(\u0004\u0002\u0002n)!\u0011qNA9\u0003%)hn\u00195fG.,GMC\u0002\u0002tq\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9(!\u001c\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\b\u0005\u0003\u0002\u0002\u0006-UBAAB\u0015\u0011\t))a\"\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0013\u000bAA[1wC&!\u0011QKAB\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\nE\u0002<\u0003'K1!!&=\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r\u0001\u00181\u0014\u0005\n\u0003;3\u0012\u0011!a\u0001\u0003#\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAR!\u0015\t)+a+q\u001b\t\t9KC\u0002\u0002*r\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti+a*\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004=\u0006M\u0006\u0002CAO1\u0005\u0005\t\u0019\u00019\u0002\r\u0015\fX/\u00197t)\rq\u0016\u0011\u0018\u0005\t\u0003;K\u0012\u0011!a\u0001a\"z\u0001!!0\u0002D\u0006\u0015\u0017\u0011ZAf\u0003\u001f\f\t\u000eE\u00022\u0003\u007fK1!!1#\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a2\u0002\u0005cR\u0001\u0005\t\u0011!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0017!S:$W\r_\u0015![\u0001\u0012V\r^;s]N\u0004S\r\\3nK:$\be\u001c4!CJ\u0014\u0018-\u001f\u0011bi\u0002:\u0017N^3oA!\nTFY1tK\u0012L\u0003%\u001b8eKbt\u0003%\u00134!S:$W\r\u001f\u0011=AAb#\u0002\t\u0011!A\u0001\u0002\u0013mY2fgN,7\u000fI3mK6,g\u000e^:!MJ|W\u000e\t;iK\u0002b\u0017m\u001d;!i>\u0004C\u000f[3!M&\u00148\u000f\u001e\u0018!%\u0016$XO\u001d8tA9+F\n\u0014\u0011jM\u0002\"\b.\u001a\u0011j]\u0012,\u0007\u0010I3yG\u0016,Gm\u001d\u0011uQ\u0016\u0004C.\u001a8hi\"T\u0001\u0005\t\u0011!A\u0001zg\r\t;iK\u0002\n'O]1z])Q\u0001\u0005\t\u0011!?\u001a+fjQ0)[\u0006\u0004H\u0006I6fs&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011wC2,X\r\t4pe\u0002:\u0017N^3oA-,\u0017\u0010\f\u0011pe\u0002rU\u000b\u0014'!S\u001a\u0004C\u000f[3!W\u0016L\b%[:!]>$\beY8oi\u0006Lg.\u001a3!S:\u0004C\u000f[3![\u0006\u0004(\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!4\u0002y*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"\nD\u0006\t\u001a-AMJC\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK7ba\"\nD\u0006I\u0014bO1\u0002#\u0007\f\u0011(E\u001eJC\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005M\u0017!\u0002\u001a/i9\u0002\u0014!C#mK6,g\u000e^!u!\t\t4d\u0005\u0003\u001c\u00037\u0004\u0005cBAo\u0003G,U)T\u0007\u0003\u0003?T1!!9=\u0003\u001d\u0011XO\u001c;j[\u0016LA!!:\u0002`\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\u0005]\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0014!B1qa2LH#B'\u0002r\u0006M\b\"B\"\u001f\u0001\u0004)\u0005\"B%\u001f\u0001\u0004)\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003s\u0014)\u0001E\u0003<\u0003w\fy0C\u0002\u0002~r\u0012aa\u00149uS>t\u0007#B\u001e\u0003\u0002\u0015+\u0015b\u0001B\u0002y\t1A+\u001e9mKJB\u0001Ba\u0002 \u0003\u0003\u0005\r!T\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u0004\u0011\t\u0005\u0005%qB\u0005\u0005\u0005#\t\u0019I\u0001\u0004PE*,7\r\u001e")
public class ElementAt
extends BinaryExpression
implements GetMapValueUtil,
GetArrayItemUtil,
scala.Serializable {
    private transient DataType mapKeyType;
    private transient boolean arrayContainsNull;
    private transient Ordering<Object> ordering;
    private transient DataType dataType;
    private transient Function2<Object, Object, Object> doElementAt;
    private final Expression left;
    private final Expression right;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ElementAt elementAt) {
        return ElementAt$.MODULE$.unapply(elementAt);
    }

    public static Function1<Tuple2<Expression, Expression>, ElementAt> tupled() {
        return ElementAt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ElementAt>> curried() {
        return ElementAt$.MODULE$.curried();
    }

    @Override
    public boolean computeNullabilityFromArray(Expression child, Expression ordinal) {
        return GetArrayItemUtil.computeNullabilityFromArray$(this, child, ordinal);
    }

    @Override
    public Object getValueEval(Object value, Object ordinal, DataType keyType, Ordering<Object> ordering) {
        return GetMapValueUtil.getValueEval$(this, value, ordinal, keyType, ordering);
    }

    @Override
    public ExprCode doGetValueGenCode(CodegenContext ctx, ExprCode ev, MapType mapType) {
        return GetMapValueUtil.doGetValueGenCode$(this, ctx, ev, mapType);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private DataType mapKeyType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.mapKeyType = ((MapType)this.left().dataType()).keyType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.mapKeyType;
    }

    private DataType mapKeyType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.mapKeyType$lzycompute() : this.mapKeyType;
    }

    private boolean arrayContainsNull$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.arrayContainsNull = ((ArrayType)this.left().dataType()).containsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.arrayContainsNull;
    }

    private boolean arrayContainsNull() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.arrayContainsNull$lzycompute() : this.arrayContainsNull;
    }

    private Ordering<Object> ordering$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.mapKeyType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private DataType dataType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                DataType dataType;
                DataType dataType2 = this.left().dataType();
                if (dataType2 instanceof ArrayType) {
                    DataType elementType;
                    ArrayType arrayType = (ArrayType)dataType2;
                    dataType = elementType = arrayType.elementType();
                } else if (dataType2 instanceof MapType) {
                    DataType valueType;
                    MapType mapType = (MapType)dataType2;
                    dataType = valueType = mapType.valueType();
                } else {
                    throw new MatchError((Object)dataType2);
                }
                this.dataType = dataType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType arr = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (arr instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)arr;
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{arrayType, IntegerType$.MODULE$}));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                Seq seq;
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean hasNull = mapType.valueContainsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)keyType, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{new MapType(dt, valueType, hasNull), dt}));
                    return seq;
                } else {
                    seq = (Seq)Seq$.MODULE$.empty();
                }
                return seq;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        return (Seq)Seq$.MODULE$.empty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType e1;
        void var1_8;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType e2 = (DataType)tuple2._2();
            if (tuple2._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(67).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a ").append(IntegerType$.MODULE$.simpleString()).append(", but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
                    return var1_8;
                }
            }
        }
        if (tuple2 != null) {
            MapType mapType;
            DataType e12;
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType && !e2.sameType(e12 = (mapType = (MapType)dataType).keyType())) {
                TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(89).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(MapType$.MODULE$.simpleString()).append(" followed by a value of same key type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
                return var1_8;
            }
        }
        if (tuple2 != null && !((e1 = (DataType)tuple2._1()) instanceof MapType) && !(e1 instanceof ArrayType)) {
            TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(74).append("The first argument to function ").append(this.prettyName()).append(" should ").append("have been ").append(ArrayType$.MODULE$.simpleString()).append(" or ").append(MapType$.MODULE$.simpleString()).append(" type, but its ").append(this.left().dataType().catalogString()).append(" type.").toString());
            return var1_8;
        }
        TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
        return var1_8;
    }

    @Override
    public boolean nullable() {
        boolean bl;
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            bl = this.computeNullabilityFromArray(this.left(), this.right());
        } else if (dataType instanceof MapType) {
            bl = true;
        } else {
            throw new MatchError((Object)dataType);
        }
        return bl;
    }

    @Override
    public Object nullSafeEval(Object value, Object ordinal) {
        return this.doElementAt().apply(value, ordinal);
    }

    private Function2<Object, Object, Object> doElementAt$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                Function2 & Serializable & scala.Serializable intersect;
                DataType dataType = this.left().dataType();
                if (dataType instanceof ArrayType) {
                    intersect = (Function2 & Serializable & scala.Serializable)(value, ordinal) -> {
                        Object object;
                        ArrayData array = (ArrayData)value;
                        int index = BoxesRunTime.unboxToInt((Object)ordinal);
                        if (array.numElements() < package$.MODULE$.abs(index)) {
                            object = null;
                        } else {
                            if (index == 0) {
                                throw new ArrayIndexOutOfBoundsException("SQL array indices start at 1");
                            }
                            int idx = index > 0 ? index - 1 : array.numElements() + index;
                            object = this.arrayContainsNull() && array.isNullAt(idx) ? null : array.get(idx, this.dataType());
                        }
                        return object;
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function2 & Serializable & scala.Serializable)(value, ordinal) -> this.getValueEval(value, ordinal, this.mapKeyType(), this.ordering());
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doElementAt = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.doElementAt;
    }

    private Function2<Object, Object, Object> doElementAt() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.doElementAt$lzycompute() : this.doElementAt;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> {
                String index = ctx.freshName("elementAtIndex");
                String nullCheck = this.arrayContainsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\n               |if (").append((String)eval1).append(".isNullAt(").append(index).append(")) {\n               |  ").append(ev.isNull()).append(" = true;\n               |} else\n             ").toString())).stripMargin() : "";
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(489).append("\n             |int ").append(index).append(" = (int) ").append((String)eval2).append(";\n             |if (").append((String)eval1).append(".numElements() < Math.abs(").append(index).append(")) {\n             |  ").append(ev.isNull()).append(" = true;\n             |} else {\n             |  if (").append(index).append(" == 0) {\n             |    throw new ArrayIndexOutOfBoundsException(\"SQL array indices start at 1\");\n             |  } else if (").append(index).append(" > 0) {\n             |    ").append(index).append("--;\n             |  } else {\n             |    ").append(index).append(" += ").append((String)eval1).append(".numElements();\n             |  }\n             |  ").append(nullCheck).append("\n             |  {\n             |    ").append(ev.value()).append(" = ").append(CodeGenerator$.MODULE$.getValue((String)eval1, this.dataType(), index)).append(";\n             |  }\n             |}\n           ").toString())).stripMargin();
            });
        } else if (dataType instanceof MapType) {
            exprCode = this.doGetValueGenCode(ctx, ev, (MapType)this.left().dataType());
        } else {
            throw new MatchError((Object)dataType);
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "element_at";
    }

    public ElementAt copy(Expression left, Expression right) {
        return new ElementAt(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ElementAt";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ElementAt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ElementAt)) return false;
        boolean bl = true;
        if (!bl) return false;
        ElementAt elementAt = (ElementAt)x$1;
        Expression expression = this.left();
        Expression expression2 = elementAt.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = elementAt.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!elementAt.canEqual(this)) return false;
        return true;
    }

    public ElementAt(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        GetMapValueUtil.$init$(this);
        GetArrayItemUtil.$init$(this);
    }
}

