/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDate;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.MakeDate$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(year, month, day) - Create date from year, month and day fields.", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2013, 7, 15);\n       2013-07-15\n      > SELECT _FUNC_(2019, 13, 1);\n       NULL\n      > SELECT _FUNC_(2019, 7, NULL);\n       NULL\n      > SELECT _FUNC_(2019, 2, 30);\n       NULL\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001\u0002\u0011\"\u0001:B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\"AQ\t\u0001BK\u0002\u0013\u0005\u0001\t\u0003\u0005G\u0001\tE\t\u0015!\u0003B\u0011!9\u0005A!f\u0001\n\u0003\u0001\u0005\u0002\u0003%\u0001\u0005#\u0005\u000b\u0011B!\t\u000b%\u0003A\u0011\u0001&\t\u000b=\u0003A\u0011\t)\t\u000bu\u0003A\u0011\t0\t\u000b\u0019\u0004A\u0011I4\t\u000b-\u0004A\u0011\t7\t\u000bA\u0004A\u0011I9\t\u000ba\u0004A\u0011I=\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!I\u00111\u0005\u0001\u0002\u0002\u0013\u0005\u0011Q\u0005\u0005\n\u0003[\u0001\u0011\u0013!C\u0001\u0003_A\u0011\"!\u0012\u0001#\u0003%\t!a\f\t\u0013\u0005\u001d\u0003!%A\u0005\u0002\u0005=\u0002\"CA%\u0001\u0005\u0005I\u0011IA&\u0011%\tY\u0006AA\u0001\n\u0003\ti\u0006C\u0005\u0002f\u0001\t\t\u0011\"\u0001\u0002h!I\u0011Q\u000e\u0001\u0002\u0002\u0013\u0005\u0013q\u000e\u0005\n\u0003{\u0002\u0011\u0011!C\u0001\u0003\u007fB\u0011\"a!\u0001\u0003\u0003%\t%!\"\b\u0013\u0005=\u0016%!A\t\u0002\u0005Ef\u0001\u0003\u0011\"\u0003\u0003E\t!a-\t\r%SB\u0011AAa\u0011%\t\u0019MGA\u0001\n\u000b\n)\rC\u0005\u0002Hj\t\t\u0011\"!\u0002J\"I\u0011\u0011\u001b\u000e\u0002\u0002\u0013\u0005\u00151\u001b\u0005\n\u0003KT\u0012\u0011!C\u0005\u0003O\u0014\u0001\"T1lK\u0012\u000bG/\u001a\u0006\u0003E\r\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A%J\u0001\tG\u0006$\u0018\r\\=ti*\u0011aeJ\u0001\u0004gFd'B\u0001\u0015*\u0003\u0015\u0019\b/\u0019:l\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M)\u0001aL\u001a7yA\u0011\u0001'M\u0007\u0002C%\u0011!'\t\u0002\u0012)\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u00195\u0013\t)\u0014E\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u001d\u0001&o\u001c3vGR\u0004\"aN\u001f\n\u0005yB$\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001B=fCJ,\u0012!\u0011\t\u0003a\tK!aQ\u0011\u0003\u0015\u0015C\bO]3tg&|g.A\u0003zK\u0006\u0014\b%A\u0003n_:$\b.\u0001\u0004n_:$\b\u000eI\u0001\u0004I\u0006L\u0018\u0001\u00023bs\u0002\na\u0001P5oSRtD\u0003B&M\u001b:\u0003\"\u0001\r\u0001\t\u000b}:\u0001\u0019A!\t\u000b\u0015;\u0001\u0019A!\t\u000b\u001d;\u0001\u0019A!\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012!\u0015\t\u0004%j\u000beBA*Y\u001d\t!v+D\u0001V\u0015\t1V&\u0001\u0004=e>|GOP\u0005\u0002s%\u0011\u0011\fO\u0001\ba\u0006\u001c7.Y4f\u0013\tYFLA\u0002TKFT!!\u0017\u001d\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001`!\r\u0011&\f\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G\u0016\nQ\u0001^=qKNL!!\u001a2\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003!\u0004\"!Y5\n\u0005)\u0014'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00119,H\u000e\\1cY\u0016,\u0012!\u001c\t\u0003o9L!a\u001c\u001d\u0003\u000f\t{w\u000e\\3b]\u0006aa.\u001e7m'\u00064W-\u0012<bYR!!/\u001e<x!\t94/\u0003\u0002uq\t\u0019\u0011I\\=\t\u000b}b\u0001\u0019\u0001:\t\u000b\u0015c\u0001\u0019\u0001:\t\u000b\u001dc\u0001\u0019\u0001:\u0002\u0013\u0011|w)\u001a8D_\u0012,G#\u0002>\u0002\u0002\u0005-\u0001CA>\u007f\u001b\u0005a(BA?\"\u0003\u001d\u0019w\u000eZ3hK:L!a ?\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\u0001\u000e\u0001\u0004\t)!A\u0002dib\u00042a_A\u0004\u0013\r\tI\u0001 \u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0019\ti!\u0004a\u0001u\u0006\u0011QM^\u0001\u000baJ,G\u000f^=OC6,WCAA\n!\u0011\t)\"!\b\u000f\t\u0005]\u0011\u0011\u0004\t\u0003)bJ1!a\u00079\u0003\u0019\u0001&/\u001a3fM&!\u0011qDA\u0011\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0004\u001d\u0002\t\r|\u0007/\u001f\u000b\b\u0017\u0006\u001d\u0012\u0011FA\u0016\u0011\u001dyt\u0002%AA\u0002\u0005Cq!R\b\u0011\u0002\u0003\u0007\u0011\tC\u0004H\u001fA\u0005\t\u0019A!\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0007\u0016\u0004\u0003\u0006M2FAA\u001b!\u0011\t9$!\u0011\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}\u0002(\u0001\u0006b]:|G/\u0019;j_:LA!a\u0011\u0002:\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002NA!\u0011qJA-\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013\u0001\u00027b]\u001eT!!a\u0016\u0002\t)\fg/Y\u0005\u0005\u0003?\t\t&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002`A\u0019q'!\u0019\n\u0007\u0005\r\u0004HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002s\u0003SB\u0011\"a\u001b\u0016\u0003\u0003\u0005\r!a\u0018\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\bE\u0003\u0002t\u0005e$/\u0004\u0002\u0002v)\u0019\u0011q\u000f\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002|\u0005U$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2!\\AA\u0011!\tYgFA\u0001\u0002\u0004\u0011\u0018AB3rk\u0006d7\u000fF\u0002n\u0003\u000fC\u0001\"a\u001b\u0019\u0003\u0003\u0005\rA\u001d\u0015\u0018\u0001\u0005-\u0015\u0011SAJ\u0003/\u000bI*!(\u0002 \u0006\r\u0016QUAU\u0003W\u00032\u0001MAG\u0013\r\ty)\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t)*A$`\rVs5i\u0018\u0015zK\u0006\u0014H\u0006I7p]RDG\u0006\t3bs&\u0002S\u0006I\"sK\u0006$X\r\t3bi\u0016\u0004cM]8nAe,\u0017M\u001d\u0017![>tG\u000f\u001b\u0011b]\u0012\u0004C-Y=!M&,G\u000eZ:/\u0003%\t'oZ;nK:$8/\t\u0002\u0002\u001c\u0006\t9K\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!s\u0016\f'\u000fI\u0017!i\",\u0007%_3be\u0002\"x\u000e\t:faJ,7/\u001a8uY\u00012'o\\7!c\u0001\"x\u000eI\u001d:seR\u0001\u0005\t\u0011!A\u0001R\u0003%\\8oi\"\u0004S\u0006\t;iK\u0002jwN\u001c;i[=4W&_3be\u0002\"x\u000e\t:faJ,7/\u001a8uY\u00012'o\\7!c\u0001B#*\u00198vCJL\u0018\u0006\t;pAE\u0012\u0004\u0005\u000b#fG\u0016l'-\u001a:*\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"\u0017-\u001f\u0011.AQDW\r\t3bs6zg-L7p]RD\u0007\u0005^8!e\u0016\u0004(/Z:f]Rd\u0003E\u001a:p[\u0002\n\u0004\u0005^8!gER\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011U\u0001\u00024*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C#\u0007M\u00194Y\u0001:D\u0006I\u00196SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00194[A:T&M\u001b\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QI\u0002\u0014'\u000f\u0017!cMb\u0003%M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)eA\n\u0014\b\f\u00118Y\u0001rU\u000b\u0014'*w)\u0001\u0003\u0005\t\u0011!A\u0001rU\u000b\u0014'\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QI\u0002\u0014'\u000f\u0017!e1\u00023\u0007M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u0005)qM]8va\u0006\u0012\u0011qU\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\ti+A\u00034]Ar\u0003'\u0001\u0005NC.,G)\u0019;f!\t\u0001$d\u0005\u0003\u001b\u0003kc\u0004\u0003CA\\\u0003{\u000b\u0015)Q&\u000e\u0005\u0005e&bAA^q\u00059!/\u001e8uS6,\u0017\u0002BA`\u0003s\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\t\t,\u0001\u0005u_N#(/\u001b8h)\t\ti%A\u0003baBd\u0017\u0010F\u0004L\u0003\u0017\fi-a4\t\u000b}j\u0002\u0019A!\t\u000b\u0015k\u0002\u0019A!\t\u000b\u001dk\u0002\u0019A!\u0002\u000fUt\u0017\r\u001d9msR!\u0011Q[Aq!\u00159\u0014q[An\u0013\r\tI\u000e\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r]\ni.Q!B\u0013\r\ty\u000e\u000f\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005\rh$!AA\u0002-\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005%\b\u0003BA(\u0003WLA!!<\u0002R\t1qJ\u00196fGR\u0004")
public class MakeDate
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression year;
    private final Expression month;
    private final Expression day;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(MakeDate makeDate) {
        return MakeDate$.MODULE$.unapply(makeDate);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, MakeDate> tupled() {
        return MakeDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, MakeDate>>> curried() {
        return MakeDate$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression year() {
        return this.year;
    }

    public Expression month() {
        return this.month;
    }

    public Expression day() {
        return this.day;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.year(), this.month(), this.day()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IntegerType$[]{IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object day) {
        Integer n;
        try {
            LocalDate ld = LocalDate.of(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)day));
            n = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.localDateToDays(ld));
        }
        catch (DateTimeException dateTimeException) {
            n = null;
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(year, month, day) -> new StringBuilder(144).append("\n      try {\n        ").append(ev.value()).append(" = ").append(dtu).append(".localDateToDays(java.time.LocalDate.of(").append((String)year).append(", ").append((String)month).append(", ").append((String)day).append("));\n      } catch (java.time.DateTimeException e) {\n        ").append(ev.isNull()).append(" = true;\n      }").toString());
    }

    @Override
    public String prettyName() {
        return "make_date";
    }

    public MakeDate copy(Expression year, Expression month, Expression day) {
        return new MakeDate(year, month, day);
    }

    public Expression copy$default$1() {
        return this.year();
    }

    public Expression copy$default$2() {
        return this.month();
    }

    public Expression copy$default$3() {
        return this.day();
    }

    @Override
    public String productPrefix() {
        return "MakeDate";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.year();
                break;
            }
            case 1: {
                expression = this.month();
                break;
            }
            case 2: {
                expression = this.day();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeDate makeDate = (MakeDate)x$1;
        Expression expression = this.year();
        Expression expression2 = makeDate.year();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.month();
        Expression expression4 = makeDate.month();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.day();
        Expression expression6 = makeDate.day();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!makeDate.canEqual(this)) return false;
        return true;
    }

    public MakeDate(Expression year, Expression month, Expression day) {
        this.year = year;
        this.month = month;
        this.day = day;
        ExpectsInputTypes.$init$(this);
    }
}

