/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Shuffle$;
import org.apache.spark.sql.catalyst.expressions.Stateful;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.RandomIndicesGenerator;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(array) - Returns a random permutation of the given array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 20, 3, 5));\n       [3,1,5,20]\n      > SELECT _FUNC_(array(1, 20, null, 3));\n       [20,null,3,1]\n  ", note="\n    The function is non-deterministic.\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t%c\u0001\u0002\u0013&\u0001JB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005X\u0001\tE\t\u0015!\u0003R\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015A\u0006\u0001\"\u0001^\u0011\u0015y\u0006\u0001\"\u0011a\u0011!\u0019\u0007\u0001#b\u0001\n\u0003\"\u0007\"\u00025\u0001\t\u0003J\u0007\"\u0002?\u0001\t\u0003j\b\"CA\u0002\u0001!\u0015\r\u0011\"\u0001~\u0011-\ti\u0001\u0001a\u0001\u0002\u0003\u0006K!a\u0004\t\u000f\u0005u\u0001\u0001\"\u0015\u0002 !9\u0011\u0011\u0007\u0001\u0005R\u0005M\u0002bBA$\u0001\u0011E\u0013\u0011\n\u0005\b\u0003K\u0002A\u0011BA4\u0011\u001d\t\t\t\u0001C!\u0003\u0007C\u0011\"!\"\u0001\u0003\u0003%\t!a\"\t\u0013\u00055\u0005!%A\u0005\u0002\u0005=\u0005\"CAS\u0001E\u0005I\u0011AAT\u0011%\tY\u000bAA\u0001\n\u0003\ni\u000bC\u0005\u0002>\u0002\t\t\u0011\"\u0001\u0002@\"I\u0011\u0011\u0019\u0001\u0002\u0002\u0013\u0005\u00111\u0019\u0005\n\u0003\u0013\u0004\u0011\u0011!C!\u0003\u0017D\u0011\"!7\u0001\u0003\u0003%\t!a7\t\u0013\u0005}\u0007!!A\u0005B\u0005\u0005x!\u0003B\u0006K\u0005\u0005\t\u0012\u0001B\u0007\r!!S%!A\t\u0002\t=\u0001B\u0002-\u001d\t\u0003\u0011i\u0002C\u0005\u0003 q\t\t\u0011\"\u0012\u0003\"!I!1\u0005\u000f\u0002\u0002\u0013\u0005%Q\u0005\u0005\n\u0005Wa\u0012\u0013!C\u0001\u0003OC\u0011B!\f\u001d\u0003\u0003%\tIa\f\t\u0013\tuB$%A\u0005\u0002\u0005\u001d\u0006\"\u0003B 9\u0005\u0005I\u0011\u0002B!\u0005\u001d\u0019\u0006.\u001e4gY\u0016T!AJ\u0014\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003Q%\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003U-\n1a]9m\u0015\taS&A\u0003ta\u0006\u00148N\u0003\u0002/_\u00051\u0011\r]1dQ\u0016T\u0011\u0001M\u0001\u0004_J<7\u0001A\n\b\u0001M:$(\u0010!G!\t!T'D\u0001&\u0013\t1TEA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t!\u0004(\u0003\u0002:K\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005QZ\u0014B\u0001\u001f&\u0005!\u0019F/\u0019;fMVd\u0007C\u0001\u001b?\u0013\tyTE\u0001\rFqB\u0014Xm]:j_:<\u0016\u000e\u001e5SC:$w.\\*fK\u0012\u0004\"!\u0011#\u000e\u0003\tS\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000b\n\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002B\u000f&\u0011\u0001J\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006G\"LG\u000eZ\u000b\u0002\u0017B\u0011A\u0007T\u0005\u0003\u001b\u0016\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u0005Q!/\u00198e_6\u001cV-\u001a3\u0016\u0003E\u00032!\u0011*U\u0013\t\u0019&I\u0001\u0004PaRLwN\u001c\t\u0003\u0003VK!A\u0016\"\u0003\t1{gnZ\u0001\fe\u0006tGm\\7TK\u0016$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u00045nc\u0006C\u0001\u001b\u0001\u0011\u0015IU\u00011\u0001L\u0011\u001dyU\u0001%AA\u0002E#\"A\u00170\t\u000b%3\u0001\u0019A&\u0002\u0017]LG\u000f\u001b(foN+W\r\u001a\u000b\u00035\u0006DQAY\u0004A\u0002Q\u000bAa]3fI\u0006A!/Z:pYZ,G-F\u0001f!\t\te-\u0003\u0002h\u0005\n9!i\\8mK\u0006t\u0017AC5oaV$H+\u001f9fgV\t!\u000eE\u0002lgZt!\u0001\\9\u000f\u00055\u0004X\"\u00018\u000b\u0005=\f\u0014A\u0002\u001fs_>$h(C\u0001D\u0013\t\u0011()A\u0004qC\u000e\\\u0017mZ3\n\u0005Q,(aA*fc*\u0011!O\u0011\t\u0003ojl\u0011\u0001\u001f\u0006\u0003s&\nQ\u0001^=qKNL!a\u001f=\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003y\u0004\"a^@\n\u0007\u0005\u0005\u0001P\u0001\u0005ECR\fG+\u001f9f\u0003-)G.Z7f]R$\u0016\u0010]3)\u0007-\t9\u0001E\u0002B\u0003\u0013I1!a\u0003C\u0005%!(/\u00198tS\u0016tG/\u0001\u0004sC:$w.\u001c\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011QC\u0014\u0002\tU$\u0018\u000e\\\u0005\u0005\u00033\t\u0019B\u0001\fSC:$w.\\%oI&\u001cWm]$f]\u0016\u0014\u0018\r^8sQ\ra\u0011qA\u0001\u0013S:LG/[1mSj,\u0017J\u001c;fe:\fG\u000e\u0006\u0003\u0002\"\u0005\u001d\u0002cA!\u0002$%\u0019\u0011Q\u0005\"\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003Si\u0001\u0019AA\u0016\u00039\u0001\u0018M\u001d;ji&|g.\u00138eKb\u00042!QA\u0017\u0013\r\tyC\u0011\u0002\u0004\u0013:$\u0018\u0001D3wC2Le\u000e^3s]\u0006dG\u0003BA\u001b\u0003w\u00012!QA\u001c\u0013\r\tID\u0011\u0002\u0004\u0003:L\bbBA\u001f\u001d\u0001\u0007\u0011qH\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003\u0003\n\u0019%D\u0001(\u0013\r\t)e\n\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR1\u00111JA,\u0003C\u0002B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u0003#*\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003+\nyE\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tIf\u0004a\u0001\u00037\n1a\u0019;y!\u0011\ti%!\u0018\n\t\u0005}\u0013q\n\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t\u0019g\u0004a\u0001\u0003\u0017\n!!\u001a<\u0002'MDWO\u001a4mK\u0006\u0013(/Y=D_\u0012,w)\u001a8\u0015\u0011\u0005%\u0014\u0011PA>\u0003{\u0002B!a\u001b\u0002t9!\u0011QNA8!\ti')C\u0002\u0002r\t\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA;\u0003o\u0012aa\u0015;sS:<'bAA9\u0005\"9\u0011\u0011\f\tA\u0002\u0005m\u0003bBA2!\u0001\u0007\u00111\n\u0005\b\u0003\u007f\u0002\u0002\u0019AA5\u0003%\u0019\u0007.\u001b7e\u001d\u0006lW-A\u0005ge\u0016\u001c\bnQ8qsR\t!,\u0001\u0003d_BLH#\u0002.\u0002\n\u0006-\u0005bB%\u0013!\u0003\u0005\ra\u0013\u0005\b\u001fJ\u0001\n\u00111\u0001R\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!%+\u0007-\u000b\u0019j\u000b\u0002\u0002\u0016B!\u0011qSAQ\u001b\t\tIJ\u0003\u0003\u0002\u001c\u0006u\u0015!C;oG\",7m[3e\u0015\r\tyJQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAR\u00033\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!++\u0007E\u000b\u0019*A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003_\u0003B!!-\u0002<6\u0011\u00111\u0017\u0006\u0005\u0003k\u000b9,\u0001\u0003mC:<'BAA]\u0003\u0011Q\u0017M^1\n\t\u0005U\u00141W\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003W\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00026\u0005\u0015\u0007\"CAd/\u0005\u0005\t\u0019AA\u0016\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u001a\t\u0007\u0003\u001f\f).!\u000e\u000e\u0005\u0005E'bAAj\u0005\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0017\u0011\u001b\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002f\u0003;D\u0011\"a2\u001a\u0003\u0003\u0005\r!!\u000e\u0002\r\u0015\fX/\u00197t)\r)\u00171\u001d\u0005\n\u0003\u000fT\u0012\u0011!a\u0001\u0003kAs\u0003AAt\u0003[\fy/a=\u0002v\u0006e\u00181`A\u0000\u0005\u0003\u0011)Aa\u0002\u0011\u0007Q\nI/C\u0002\u0002l\u0016\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002r\u0006\u0001uLR+O\u0007~C\u0013M\u001d:bs&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bAI\fg\u000eZ8nAA,'/\\;uCRLwN\u001c\u0011pM\u0002\"\b.\u001a\u0011hSZ,g\u000eI1se\u0006Lh&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t90AA\u0012\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQEb\u0003E\r\u0019-AMb\u0003%N\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z6\u0007L\u0019-k1\u0012\u0004'\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012\u0004\u0007\f\u0011ok2dG\u0006I\u001a*SmR\u0001\u0005\t\u0011!A\u0001\u00023L\r\u0019-]VdG\u000eL\u001a-cuS\u0001\u0005I\u0001\u0005]>$X-\t\u0002\u0002~\u0006Q#\u0002\t\u0011!AQCW\r\t4v]\u000e$\u0018n\u001c8!SN\u0004cn\u001c8.I\u0016$XM]7j]&\u001cH/[2/\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018E\u0001B\u0002\u0003-\t'O]1z?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\t%\u0011!\u0002\u001a/i9\u0002\u0014aB*ik\u001a4G.\u001a\t\u0003iq\u0019B\u0001\bB\t\rB9!1\u0003B\r\u0017FSVB\u0001B\u000b\u0015\r\u00119BQ\u0001\beVtG/[7f\u0013\u0011\u0011YB!\u0006\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0003\u000e\u0005AAo\\*ue&tw\r\u0006\u0002\u00020\u0006)\u0011\r\u001d9msR)!La\n\u0003*!)\u0011j\ba\u0001\u0017\"9qj\bI\u0001\u0002\u0004\t\u0016aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0007B\u001d!\u0011\t%Ka\r\u0011\u000b\u0005\u0013)dS)\n\u0007\t]\"I\u0001\u0004UkBdWM\r\u0005\t\u0005w\t\u0013\u0011!a\u00015\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\r\u0003\u0003BAY\u0005\u000bJAAa\u0012\u00024\n1qJ\u00196fGR\u0004")
public class Shuffle
extends UnaryExpression
implements ExpectsInputTypes,
Stateful,
ExpressionWithRandomSeed,
scala.Serializable {
    private boolean resolved;
    private transient DataType elementType;
    private final Expression child;
    private final Option<Object> randomSeed;
    private transient RandomIndicesGenerator random;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Object> $lessinit$greater$default$2() {
        return Shuffle$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Object>>> unapply(Shuffle shuffle) {
        return Shuffle$.MODULE$.unapply(shuffle);
    }

    public static Option<Object> apply$default$2() {
        return Shuffle$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Option<Object>>, Shuffle> tupled() {
        return Shuffle$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Object>, Shuffle>> curried() {
        return Shuffle$.MODULE$.curried();
    }

    @Override
    public boolean fastEquals(TreeNode<?> other) {
        return Stateful.fastEquals$(this, other);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean deterministic$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.deterministic$lzycompute() : this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Option<Object> randomSeed() {
        return this.randomSeed;
    }

    @Override
    public Shuffle withNewSeed(long seed) {
        Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)seed));
        Expression x$2 = this.copy$default$1();
        return this.copy(x$2, (Option<Object>)x$1);
    }

    private boolean resolved$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = this.childrenResolved() && this.checkInputDataTypes().isSuccess() && this.randomSeed().isDefined();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType$[]{ArrayType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    private DataType elementType$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if (!this.bitmap$trans$0) {
                this.elementType = ((ArrayType)this.dataType()).elementType();
                this.bitmap$trans$0 = true;
            }
        }
        return this.elementType;
    }

    public DataType elementType() {
        return !this.bitmap$trans$0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.random = new RandomIndicesGenerator(BoxesRunTime.unboxToLong((Object)this.randomSeed().get()) + (long)partitionIndex);
    }

    @Override
    public Object evalInternal(InternalRow input) {
        GenericArrayData genericArrayData;
        Object value = this.child().eval(input);
        if (value == null) {
            genericArrayData = null;
        } else {
            ArrayData source = (ArrayData)value;
            int numElements = source.numElements();
            int[] indices = this.random.getNextIndices(numElements);
            genericArrayData = new GenericArrayData(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).map((Function1 & Serializable & scala.Serializable)x$25 -> source.get(BoxesRunTime.unboxToInt((Object)x$25), this.elementType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Object())));
        }
        return genericArrayData;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> this.shuffleArrayCodeGen(ctx, ev, (String)c));
    }

    private String shuffleArrayCodeGen(CodegenContext ctx, ExprCode ev, String childName) {
        String randomClass;
        String x$1 = randomClass = RandomIndicesGenerator.class.getName();
        String x$2 = "rand";
        boolean x$3 = true;
        Function1<String, String> x$4 = ctx.addMutableState$default$3();
        boolean x$5 = ctx.addMutableState$default$5();
        String rand = ctx.addMutableState(x$1, x$2, x$4, x$3, x$5);
        ctx.addPartitionInitializationStatement(new StringBuilder(28).append(rand).append(" = new ").append(randomClass).append("(").append(this.randomSeed().get()).append("L + partitionIndex);").toString());
        String numElements = ctx.freshName("numElements");
        String arrayData = ctx.freshName("arrayData");
        String indices = ctx.freshName("indices");
        String i = ctx.freshName("i");
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, this.elementType(), numElements, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, this.elementType(), childName, i, new StringBuilder(2).append(indices).append("[").append(i).append("]").toString(), ((ArrayType)this.dataType()).containsNull());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(150).append("\n       |int ").append(numElements).append(" = ").append(childName).append(".numElements();\n       |int[] ").append(indices).append(" = ").append(rand).append(".getNextIndices(").append(numElements).append(");\n       |").append(initialization).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(numElements).append("; ").append(i).append("++) {\n       |  ").append(assignment).append("\n       |}\n       |").append(ev.value()).append(" = ").append(arrayData).append(";\n     ").toString())).stripMargin();
    }

    @Override
    public Shuffle freshCopy() {
        return new Shuffle(this.child(), this.randomSeed());
    }

    public Shuffle copy(Expression child, Option<Object> randomSeed) {
        return new Shuffle(child, randomSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<Object> copy$default$2() {
        return this.randomSeed();
    }

    @Override
    public String productPrefix() {
        return "Shuffle";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Object> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.child();
                break;
            }
            case 1: {
                option = this.randomSeed();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Shuffle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Shuffle)) return false;
        boolean bl = true;
        if (!bl) return false;
        Shuffle shuffle = (Shuffle)x$1;
        Expression expression = this.child();
        Expression expression2 = shuffle.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Object> option = this.randomSeed();
        Option<Object> option2 = shuffle.randomSeed();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!shuffle.canEqual(this)) return false;
        return true;
    }

    public Shuffle(Expression child, Option<Object> randomSeed) {
        this.child = child;
        this.randomSeed = randomSeed;
        ExpectsInputTypes.$init$(this);
        Nondeterministic.$init$(this);
        Stateful.$init$(this);
    }

    public Shuffle(Expression child) {
        this(child, (Option<Object>)None$.MODULE$);
    }
}

