/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringToMap$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(text[, pairDelim[, keyValueDelim]]) - Creates a map after splitting the text into key/value pairs using delimiters. Default delimiters are ',' for `pairDelim` and ':' for `keyValueDelim`. Both `pairDelim` and `keyValueDelim` are treated as regular expressions.", examples="\n    Examples:\n      > SELECT _FUNC_('a:1,b:2,c:3', ',', ':');\n       {\"a\":\"1\",\"b\":\"2\",\"c\":\"3\"}\n      > SELECT _FUNC_('a');\n       {\"a\":null}\n  ", since="2.0.1")
@ScalaSignature(bytes="\u0006\u0001\t]a\u0001B\u0012%\u0001FB\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\t\"A\u0001\n\u0001BK\u0002\u0013\u00051\t\u0003\u0005J\u0001\tE\t\u0015!\u0003E\u0011!Q\u0005A!f\u0001\n\u0003\u0019\u0005\u0002C&\u0001\u0005#\u0005\u000b\u0011\u0002#\t\u000b1\u0003A\u0011A'\t\u000b1\u0003A\u0011\u0001*\t\u000b1\u0003A\u0011\u0001,\t\u000ba\u0003A\u0011I-\t\u000b\u0019\u0004A\u0011I4\t\u000b=\u0004A\u0011\t9\t\u000bQ\u0004A\u0011I;\t\u0011q\u0004\u0001R1A\u0005\nuDq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u0002 \u0001!\t&!\t\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@!I\u0011\u0011\u000b\u0001\u0002\u0002\u0013\u0005\u00111\u000b\u0005\n\u00037\u0002\u0011\u0013!C\u0001\u0003;B\u0011\"a\u001d\u0001#\u0003%\t!!\u0018\t\u0013\u0005U\u0004!%A\u0005\u0002\u0005u\u0003\"CA<\u0001\u0005\u0005I\u0011IA=\u0011%\tI\tAA\u0001\n\u0003\tY\tC\u0005\u0002\u0014\u0002\t\t\u0011\"\u0001\u0002\u0016\"I\u00111\u0014\u0001\u0002\u0002\u0013\u0005\u0013Q\u0014\u0005\n\u0003W\u0003\u0011\u0011!C\u0001\u0003[C\u0011\"a.\u0001\u0003\u0003%\t%!/\b\u0013\u0005]G%!A\t\u0002\u0005eg\u0001C\u0012%\u0003\u0003E\t!a7\t\r1kB\u0011AAu\u0011%\tY/HA\u0001\n\u000b\ni\u000fC\u0005\u0002pv\t\t\u0011\"!\u0002r\"I\u0011\u0011`\u000f\u0002\u0002\u0013\u0005\u00151 \u0005\n\u0005\u001bi\u0012\u0011!C\u0005\u0005\u001f\u00111b\u0015;sS:<Gk\\'ba*\u0011QEJ\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002(Q\u0005A1-\u0019;bYf\u001cHO\u0003\u0002*U\u0005\u00191/\u001d7\u000b\u0005-b\u0013!B:qCJ\\'BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001eYJt\b\u0005\u00024i5\tA%\u0003\u00026I\t\tB+\u001a:oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005M:\u0014B\u0001\u001d%\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\b!J|G-^2u!\tQ\u0004)\u0003\u0002Bw\ta1+\u001a:jC2L'0\u00192mK\u0006!A/\u001a=u+\u0005!\u0005CA\u001aF\u0013\t1EE\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001^3yi\u0002\n\u0011\u0002]1je\u0012+G.[7\u0002\u0015A\f\u0017N\u001d#fY&l\u0007%A\u0007lKf4\u0016\r\\;f\t\u0016d\u0017.\\\u0001\u000fW\u0016Lh+\u00197vK\u0012+G.[7!\u0003\u0019a\u0014N\\5u}Q!aj\u0014)R!\t\u0019\u0004\u0001C\u0003C\u000f\u0001\u0007A\tC\u0003I\u000f\u0001\u0007A\tC\u0003K\u000f\u0001\u0007A\tF\u0002O'VCQ\u0001\u0016\u0005A\u0002\u0011\u000bQa\u00195jY\u0012DQ\u0001\u0013\u0005A\u0002\u0011#\"AT,\t\u000bQK\u0001\u0019\u0001#\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012A\u0017\t\u00047\u000e$eB\u0001/b\u001d\ti\u0006-D\u0001_\u0015\ty\u0006'\u0001\u0004=e>|GOP\u0005\u0002y%\u0011!mO\u0001\ba\u0006\u001c7.Y4f\u0013\t!WMA\u0002TKFT!AY\u001e\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001i!\rY6-\u001b\t\u0003U6l\u0011a\u001b\u0006\u0003Y\"\nQ\u0001^=qKNL!A\\6\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003E\u0004\"A\u001b:\n\u0005M\\'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003Y\u0004\"a\u001e>\u000e\u0003aT!!\u001f\u0014\u0002\u0011\u0005t\u0017\r\\=tSNL!a\u001f=\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f!\"\\1q\u0005VLG\u000eZ3s+\u0005q\bcA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u00071\u0013\u0001B;uS2LA!a\u0002\u0002\u0002\t!\u0012I\u001d:bs\n\u000b7/\u001a3NCB\u0014U/\u001b7eKJ\fAB\\;mYN\u000bg-Z#wC2$\u0002\"!\u0004\u0002\u0014\u0005]\u00111\u0004\t\u0004u\u0005=\u0011bAA\tw\t\u0019\u0011I\\=\t\u000f\u0005Uq\u00021\u0001\u0002\u000e\u0005Y\u0011N\u001c9viN#(/\u001b8h\u0011\u001d\tIb\u0004a\u0001\u0003\u001b\tqb\u001d;sS:<G)\u001a7j[&$XM\u001d\u0005\b\u0003;y\u0001\u0019AA\u0007\u0003EYW-\u001f,bYV,G)\u001a7j[&$XM]\u0001\nI><UM\\\"pI\u0016$b!a\t\u00020\u0005e\u0002\u0003BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%B%A\u0004d_\u0012,w-\u001a8\n\t\u00055\u0012q\u0005\u0002\t\u000bb\u0004(oQ8eK\"9\u0011\u0011\u0007\tA\u0002\u0005M\u0012aA2uqB!\u0011QEA\u001b\u0013\u0011\t9$a\n\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u00111\b\tA\u0002\u0005\r\u0012AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002L9!\u0011QIA$!\ti6(C\u0002\u0002Jm\na\u0001\u0015:fI\u00164\u0017\u0002BA'\u0003\u001f\u0012aa\u0015;sS:<'bAA%w\u0005!1m\u001c9z)\u001dq\u0015QKA,\u00033BqA\u0011\n\u0011\u0002\u0003\u0007A\tC\u0004I%A\u0005\t\u0019\u0001#\t\u000f)\u0013\u0002\u0013!a\u0001\t\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA0U\r!\u0015\u0011M\u0016\u0003\u0003G\u0002B!!\u001a\u0002p5\u0011\u0011q\r\u0006\u0005\u0003S\nY'A\u0005v]\u000eDWmY6fI*\u0019\u0011QN\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002r\u0005\u001d$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005m\u0004\u0003BA?\u0003\u000fk!!a \u000b\t\u0005\u0005\u00151Q\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0006\u0006!!.\u0019<b\u0013\u0011\ti%a \u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u00055\u0005c\u0001\u001e\u0002\u0010&\u0019\u0011\u0011S\u001e\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u00055\u0011q\u0013\u0005\n\u00033C\u0012\u0011!a\u0001\u0003\u001b\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAP!\u0019\t\t+a*\u0002\u000e5\u0011\u00111\u0015\u0006\u0004\u0003K[\u0014AC2pY2,7\r^5p]&!\u0011\u0011VAR\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005=\u0016Q\u0017\t\u0004u\u0005E\u0016bAAZw\t9!i\\8mK\u0006t\u0007\"CAM5\u0005\u0005\t\u0019AA\u0007\u0003\u0019)\u0017/^1mgR!\u0011qVA^\u0011%\tIjGA\u0001\u0002\u0004\ti\u0001K\b\u0001\u0003\u007f\u000b)-a2\u0002L\u00065\u0017\u0011[Aj!\r\u0019\u0014\u0011Y\u0005\u0004\u0003\u0007$#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u0013\f!qC0G+:\u001bu\f\u000b;fqR\\F\u0006\t9bSJ$U\r\\5n72\u00023.Z=WC2,X\rR3mS6lV,\u000b\u0011.A\r\u0013X-\u0019;fg\u0002\n\u0007%\\1qA\u00054G/\u001a:!gBd\u0017\u000e\u001e;j]\u001e\u0004C\u000f[3!i\u0016DH\u000fI5oi>\u00043.Z=0m\u0006dW/\u001a\u0011qC&\u00148\u000fI;tS:<\u0007\u0005Z3mS6LG/\u001a:t]\u0001\"UMZ1vYR\u0004C-\u001a7j[&$XM]:!CJ,\u0007e\n\u0017(A\u0019|'\u000f\t1qC&\u0014H)\u001a7j[\u0002\u0004\u0013M\u001c3!Oi:\u0003EZ8sA\u0001\\W-\u001f,bYV,G)\u001a7j[\u0002t\u0003EQ8uQ\u0002\u0002\u0007/Y5s\t\u0016d\u0017.\u001c1!C:$\u0007\u0005Y6fsZ\u000bG.^3EK2LW\u000e\u0019\u0011be\u0016\u0004CO]3bi\u0016$\u0007%Y:!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|gn\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a4\u0002\u0003CQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ1;c1\u0012'H\r\u0017duM:C\u0006I\u0014-O1\u0002sEO\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(%\u0019\u0012;EE\u0012CF\t2#u\t\u0012$\u0005\f\u0012dEi\u00123GI?\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\nw%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!w\n\n'E\u000f8vY2l(\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005U\u0017!\u0002\u001a/a9\n\u0014aC*ue&tw\rV8NCB\u0004\"aM\u000f\u0014\tu\tin\u0010\t\t\u0003?\f)\u000f\u0012#E\u001d6\u0011\u0011\u0011\u001d\u0006\u0004\u0003G\\\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003O\f\tOA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!!7\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u001f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f9\u000b\u00190!>\u0002x\")!\t\ta\u0001\t\")\u0001\n\ta\u0001\t\")!\n\ta\u0001\t\u00069QO\\1qa2LH\u0003BA\u007f\u0005\u0013\u0001RAOA\u0000\u0005\u0007I1A!\u0001<\u0005\u0019y\u0005\u000f^5p]B1!H!\u0002E\t\u0012K1Aa\u0002<\u0005\u0019!V\u000f\u001d7fg!A!1B\u0011\u0002\u0002\u0003\u0007a*A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!\u0011\u0003\t\u0005\u0003{\u0012\u0019\"\u0003\u0003\u0003\u0016\u0005}$AB(cU\u0016\u001cG\u000f")
public class StringToMap
extends TernaryExpression
implements ExpectsInputTypes,
scala.Serializable {
    private ArrayBasedMapBuilder mapBuilder;
    private final Expression text;
    private final Expression pairDelim;
    private final Expression keyValueDelim;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringToMap stringToMap) {
        return StringToMap$.MODULE$.unapply(stringToMap);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringToMap> tupled() {
        return StringToMap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringToMap>>> curried() {
        return StringToMap$.MODULE$.curried();
    }

    public Expression text() {
        return this.text;
    }

    public Expression pairDelim() {
        return this.pairDelim;
    }

    public Expression keyValueDelim() {
        return this.keyValueDelim;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.text(), this.pairDelim(), this.keyValueDelim()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return MapType$.MODULE$.apply(StringType$.MODULE$, StringType$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.pairDelim(), this.keyValueDelim()}))).exists((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)StringToMap.$anonfun$checkInputDataTypes$7(x$28))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(31).append(this.prettyName()).append("'s delimiters must be foldable.").toString()) : ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        StringToMap stringToMap = this;
        synchronized (stringToMap) {
            if (!this.bitmap$0) {
                this.mapBuilder = new ArrayBasedMapBuilder(StringType$.MODULE$, StringType$.MODULE$);
                this.bitmap$0 = true;
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        return !this.bitmap$0 ? this.mapBuilder$lzycompute() : this.mapBuilder;
    }

    @Override
    public Object nullSafeEval(Object inputString, Object stringDelimiter, Object keyValueDelimiter) {
        UTF8String[] keyValues = ((UTF8String)inputString).split((UTF8String)stringDelimiter, -1);
        UTF8String keyValueDelimiterUTF8String = (UTF8String)keyValueDelimiter;
        for (int i = 0; i < keyValues.length; ++i) {
            UTF8String[] keyValueArray = keyValues[i].split(keyValueDelimiterUTF8String, 2);
            UTF8String key = keyValueArray[0];
            UTF8String value = keyValueArray.length < 2 ? null : keyValueArray[1];
            this.mapBuilder().put(key, value);
        }
        return this.mapBuilder().build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
        String keyValues = ctx.freshName("kvs");
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(text, pd, kvd) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(230).append("\n         |UTF8String[] ").append(keyValues).append(" = ").append((String)text).append(".split(").append((String)pd).append(", -1);\n         |for(UTF8String kvEntry: ").append(keyValues).append(") {\n         |  UTF8String[] kv = kvEntry.split(").append((String)kvd).append(", 2);\n         |  ").append(builderTerm).append(".put(kv[0], kv.length == 2 ? kv[1] : null);\n         |}\n         |").append(ev.value()).append(" = ").append(builderTerm).append(".build();\n         |").toString())).stripMargin());
    }

    @Override
    public String prettyName() {
        return "str_to_map";
    }

    public StringToMap copy(Expression text, Expression pairDelim, Expression keyValueDelim) {
        return new StringToMap(text, pairDelim, keyValueDelim);
    }

    public Expression copy$default$1() {
        return this.text();
    }

    public Expression copy$default$2() {
        return this.pairDelim();
    }

    public Expression copy$default$3() {
        return this.keyValueDelim();
    }

    @Override
    public String productPrefix() {
        return "StringToMap";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.text();
                break;
            }
            case 1: {
                expression = this.pairDelim();
                break;
            }
            case 2: {
                expression = this.keyValueDelim();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringToMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringToMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringToMap stringToMap = (StringToMap)x$1;
        Expression expression = this.text();
        Expression expression2 = stringToMap.text();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pairDelim();
        Expression expression4 = stringToMap.pairDelim();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.keyValueDelim();
        Expression expression6 = stringToMap.keyValueDelim();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringToMap.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$7(Expression x$28) {
        return !x$28.foldable();
    }

    public StringToMap(Expression text, Expression pairDelim, Expression keyValueDelim) {
        this.text = text;
        this.pairDelim = pairDelim;
        this.keyValueDelim = keyValueDelim;
        ExpectsInputTypes.$init$(this);
    }

    public StringToMap(Expression child, Expression pairDelim) {
        this(child, pairDelim, Literal$.MODULE$.apply(":"));
    }

    public StringToMap(Expression child) {
        this(child, Literal$.MODULE$.apply(","), Literal$.MODULE$.apply(":"));
    }
}

