/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.CreateArray;
import org.apache.spark.sql.catalyst.expressions.ElementAt$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetArrayItemUtil;
import org.apache.spark.sql.catalyst.expressions.GetArrayStructFields;
import org.apache.spark.sql.catalyst.expressions.GetMapValueUtil;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StructField;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array, index) - Returns element of array at given (1-based) index. If index < 0,\n      accesses elements from the last to the first. Returns NULL if the index exceeds the length\n      of the array.\n\n    _FUNC_(map, key) - Returns value for given key, or NULL if the key is not contained in the map\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), 2);\n       2\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), 2);\n       b\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t5b\u0001B\u0012%\u0001FB\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011\u0015i\u0005\u0001\"\u0001O\u0011!\u0011\u0006\u0001#b\u0001\n\u0013\u0019\u0006\u0002\u00030\u0001\u0011\u000b\u0007I\u0011B0\t\u0011\u0011\u0004\u0001R1A\u0005\n\u0015D\u0001B\u001e\u0001\t\u0006\u0004%\te\u0015\u0005\u0006q\u0002!\t%\u001f\u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'Aq!!\n\u0001\t\u0003\n9\u0003\u0003\u0004\u00020\u0001!\te\u0018\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011)\tY\u0004\u0001EC\u0002\u0013%\u0011Q\b\u0005\b\u0003\u000f\u0002A\u0011IA%\u0011\u001d\t)\u0007\u0001C!\u0003OB\u0011\"!\u001f\u0001\u0003\u0003%\t!a\u001f\t\u0013\u0005\u0005\u0005!%A\u0005\u0002\u0005\r\u0005\"CAM\u0001E\u0005I\u0011AAB\u0011%\tY\nAA\u0001\n\u0003\ni\nC\u0005\u0002.\u0002\t\t\u0011\"\u0001\u00020\"I\u0011\u0011\u0017\u0001\u0002\u0002\u0013\u0005\u00111\u0017\u0005\n\u0003s\u0003\u0011\u0011!C!\u0003wC\u0011\"!3\u0001\u0003\u0003%\t!a3\t\u0013\u0005=\u0007!!A\u0005B\u0005Ew!CAxI\u0005\u0005\t\u0012AAy\r!\u0019C%!A\t\u0002\u0005M\bBB'\u001e\t\u0003\u0011\t\u0001C\u0005\u0003\u0004u\t\t\u0011\"\u0012\u0003\u0006!I!qA\u000f\u0002\u0002\u0013\u0005%\u0011\u0002\u0005\n\u0005\u001fi\u0012\u0011!CA\u0005#A\u0011Ba\t\u001e\u0003\u0003%IA!\n\u0003\u0013\u0015cW-\\3oi\u0006#(BA\u0013'\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u001dB\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005%R\u0013aA:rY*\u00111\u0006L\u0001\u0006gB\f'o\u001b\u0006\u0003[9\na!\u00199bG\",'\"A\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0011d'\u000f\u001fC!\t\u0019D'D\u0001%\u0013\t)DE\u0001\tCS:\f'/_#yaJ,7o]5p]B\u00111gN\u0005\u0003q\u0011\u0012qbR3u\u001b\u0006\u0004h+\u00197vKV#\u0018\u000e\u001c\t\u0003giJ!a\u000f\u0013\u0003!\u001d+G/\u0011:sCfLE/Z7Vi&d\u0007CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$a\u0002)s_\u0012,8\r\u001e\t\u0003{\rK!\u0001\u0012 \u0003\u0019M+'/[1mSj\f'\r\\3\u0002\t1,g\r^\u000b\u0002\u000fB\u00111\u0007S\u0005\u0003\u0013\u0012\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051A(\u001b8jiz\"2a\u0014)R!\t\u0019\u0004\u0001C\u0003F\u000b\u0001\u0007q\tC\u0003L\u000b\u0001\u0007q)\u0001\u0006nCB\\U-\u001f+za\u0016,\u0012\u0001\u0016\t\u0003+bk\u0011A\u0016\u0006\u0003/\"\nQ\u0001^=qKNL!!\u0017,\u0003\u0011\u0011\u000bG/\u0019+za\u0016D#AB.\u0011\u0005ub\u0016BA/?\u0005%!(/\u00198tS\u0016tG/A\tbeJ\f\u0017pQ8oi\u0006Lgn\u001d(vY2,\u0012\u0001\u0019\t\u0003{\u0005L!A\u0019 \u0003\u000f\t{w\u000e\\3b]\"\u0012qaW\u0001\t_J$WM]5oOV\ta\rE\u0002h_Jt!\u0001[7\u000f\u0005%dW\"\u00016\u000b\u0005-\u0004\u0014A\u0002\u001fs_>$h(C\u0001@\u0013\tqg(A\u0004qC\u000e\\\u0017mZ3\n\u0005A\f(\u0001C(sI\u0016\u0014\u0018N\\4\u000b\u00059t\u0004CA\u001ft\u0013\t!hHA\u0002B]fD#\u0001C.\u0002\u0011\u0011\fG/\u0019+za\u0016D#!C.\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001{!\r970`\u0005\u0003yF\u00141aU3r!\t)f0\u0003\u0002\u0000-\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003\u000b\u0001B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u00171\u0013\u0001C1oC2L8/[:\n\t\u0005=\u0011\u0011\u0002\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006Ya.\u001e7mC\nLG.\u001b;z)\u0015\u0001\u0017QCA\u000e\u0011\u001d\t9\u0002\u0004a\u0001\u00033\t\u0001\"\u001a7f[\u0016tGo\u001d\t\u0004On<\u0005bBA\u000f\u0019\u0001\u0007\u0011qD\u0001\b_J$\u0017N\\1m!\ri\u0014\u0011E\u0005\u0004\u0003Gq$aA%oi\u0006Y2m\\7qkR,g*\u001e7mC\nLG.\u001b;z\rJ|W.\u0011:sCf$R\u0001YA\u0015\u0003[Aa!a\u000b\u000e\u0001\u00049\u0015!B2iS2$\u0007BBA\u000f\u001b\u0001\u0007q)\u0001\u0005ok2d\u0017M\u00197f\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0015\u0011\u0018QGA\u001d\u0011\u0019\t9d\u0004a\u0001e\u0006)a/\u00197vK\"1\u0011QD\bA\u0002I\f1\u0002Z8FY\u0016lWM\u001c;BiV\u0011\u0011q\b\t\u0007{\u0005\u0005#O\u001d:\n\u0007\u0005\rcHA\u0005Gk:\u001cG/[8oe!\u0012\u0001cW\u0001\nI><UM\\\"pI\u0016$b!a\u0013\u0002X\u0005\u0005\u0004\u0003BA'\u0003'j!!a\u0014\u000b\u0007\u0005EC%A\u0004d_\u0012,w-\u001a8\n\t\u0005U\u0013q\n\u0002\t\u000bb\u0004(oQ8eK\"9\u0011\u0011L\tA\u0002\u0005m\u0013aA2uqB!\u0011QJA/\u0013\u0011\ty&a\u0014\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u00111M\tA\u0002\u0005-\u0013AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003S\u0002B!a\u001b\u0002t9!\u0011QNA8!\tIg(C\u0002\u0002ry\na\u0001\u0015:fI\u00164\u0017\u0002BA;\u0003o\u0012aa\u0015;sS:<'bAA9}\u0005!1m\u001c9z)\u0015y\u0015QPA@\u0011\u001d)5\u0003%AA\u0002\u001dCqaS\n\u0011\u0002\u0003\u0007q)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0015%fA$\u0002\b.\u0012\u0011\u0011\u0012\t\u0005\u0003\u0017\u000b)*\u0004\u0002\u0002\u000e*!\u0011qRAI\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0014z\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9*!$\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\n\u0005\u0003\u0002\"\u0006-VBAAR\u0015\u0011\t)+a*\u0002\t1\fgn\u001a\u0006\u0003\u0003S\u000bAA[1wC&!\u0011QOAR\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\"\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007I\f)\fC\u0005\u00028b\t\t\u00111\u0001\u0002 \u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!0\u0011\u000b\u0005}\u0016Q\u0019:\u000e\u0005\u0005\u0005'bAAb}\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0017\u0011\u0019\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002a\u0003\u001bD\u0001\"a.\u001b\u0003\u0003\u0005\rA]\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0001\f\u0019\u000e\u0003\u0005\u00028n\t\t\u00111\u0001sQ=\u0001\u0011q[Ao\u0003?\f\u0019/!:\u0002j\u0006-\bcA\u001a\u0002Z&\u0019\u00111\u001c\u0013\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011]\u0001\u0003r)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010\f\u0011j]\u0012,\u00070\u000b\u0011.AI+G/\u001e:og\u0002*G.Z7f]R\u0004sN\u001a\u0011beJ\f\u0017\u0010I1uA\u001dLg/\u001a8!QEj#-Y:fI&\u0002\u0013N\u001c3fq:\u0002\u0013J\u001a\u0011j]\u0012,\u0007\u0010\t\u001f!a1R\u0001\u0005\t\u0011!A\u0001\n7mY3tg\u0016\u001c\b%\u001a7f[\u0016tGo\u001d\u0011ge>l\u0007\u0005\u001e5fA1\f7\u000f\u001e\u0011u_\u0002\"\b.\u001a\u0011gSJ\u001cHO\f\u0011SKR,(O\\:!\u001dVcE\nI5gAQDW\rI5oI\u0016D\b%\u001a=dK\u0016$7\u000f\t;iK\u0002bWM\\4uQ*\u0001\u0003\u0005\t\u0011!A=4\u0007\u0005\u001e5fA\u0005\u0014(/Y=/\u0015)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015nCBd\u0003e[3zS\u0001j\u0003EU3ukJt7\u000f\t<bYV,\u0007EZ8sA\u001dLg/\u001a8!W\u0016LH\u0006I8sA9+F\n\u0014\u0011jM\u0002\"\b.\u001a\u0011lKf\u0004\u0013n\u001d\u0011o_R\u00043m\u001c8uC&tW\r\u001a\u0011j]\u0002\"\b.\u001a\u0011nCBT\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011q]\u0001}\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQEb\u0003E\r\u0017!g%b\u0003EM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AIR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\\1qQEb\u0003eJ1(Y\u0001\u0012D\u0006I\u0014cO%b\u0003EM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\tT\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003[\fQA\r\u00185]A\n\u0011\"\u00127f[\u0016tG/\u0011;\u0011\u0005Mj2\u0003B\u000f\u0002v\n\u0003r!a>\u0002~\u001e;u*\u0004\u0002\u0002z*\u0019\u00111  \u0002\u000fI,h\u000e^5nK&!\u0011q`A}\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003c\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003?\u000bQ!\u00199qYf$Ra\u0014B\u0006\u0005\u001bAQ!\u0012\u0011A\u0002\u001dCQa\u0013\u0011A\u0002\u001d\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0014\t}\u0001#B\u001f\u0003\u0016\te\u0011b\u0001B\f}\t1q\n\u001d;j_:\u0004R!\u0010B\u000e\u000f\u001eK1A!\b?\u0005\u0019!V\u000f\u001d7fe!A!\u0011E\u0011\u0002\u0002\u0003\u0007q*A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!q\u0005\t\u0005\u0003C\u0013I#\u0003\u0003\u0003,\u0005\r&AB(cU\u0016\u001cG\u000f")
public class ElementAt
extends BinaryExpression
implements GetMapValueUtil,
GetArrayItemUtil,
scala.Serializable {
    private transient DataType mapKeyType;
    private transient boolean arrayContainsNull;
    private transient Ordering<Object> ordering;
    private transient DataType dataType;
    private transient Function2<Object, Object, Object> doElementAt;
    private final Expression left;
    private final Expression right;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ElementAt elementAt) {
        return ElementAt$.MODULE$.unapply(elementAt);
    }

    public static Function1<Tuple2<Expression, Expression>, ElementAt> tupled() {
        return ElementAt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ElementAt>> curried() {
        return ElementAt$.MODULE$.curried();
    }

    @Override
    public Object getValueEval(Object value, Object ordinal, DataType keyType, Ordering<Object> ordering) {
        return GetMapValueUtil.getValueEval$(this, value, ordinal, keyType, ordering);
    }

    @Override
    public ExprCode doGetValueGenCode(CodegenContext ctx, ExprCode ev, MapType mapType) {
        return GetMapValueUtil.doGetValueGenCode$(this, ctx, ev, mapType);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private DataType mapKeyType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.mapKeyType = ((MapType)this.left().dataType()).keyType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.mapKeyType;
    }

    private DataType mapKeyType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.mapKeyType$lzycompute() : this.mapKeyType;
    }

    private boolean arrayContainsNull$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.arrayContainsNull = ((ArrayType)this.left().dataType()).containsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.arrayContainsNull;
    }

    private boolean arrayContainsNull() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.arrayContainsNull$lzycompute() : this.arrayContainsNull;
    }

    private Ordering<Object> ordering$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.mapKeyType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private DataType dataType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                DataType dataType;
                DataType dataType2 = this.left().dataType();
                if (dataType2 instanceof ArrayType) {
                    DataType elementType;
                    ArrayType arrayType = (ArrayType)dataType2;
                    dataType = elementType = arrayType.elementType();
                } else if (dataType2 instanceof MapType) {
                    DataType valueType;
                    MapType mapType = (MapType)dataType2;
                    dataType = valueType = mapType.valueType();
                } else {
                    throw new MatchError((Object)dataType2);
                }
                this.dataType = dataType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType arr = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (arr instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)arr;
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{arrayType, IntegerType$.MODULE$}));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                Seq seq;
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean hasNull = mapType.valueContainsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)keyType, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{new MapType(dt, valueType, hasNull), dt}));
                    return seq;
                } else {
                    seq = (Seq)Seq$.MODULE$.empty();
                }
                return seq;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        return (Seq)Seq$.MODULE$.empty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType e1;
        void var1_8;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType e2 = (DataType)tuple2._2();
            if (tuple2._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(67).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a ").append(IntegerType$.MODULE$.simpleString()).append(", but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
                    return var1_8;
                }
            }
        }
        if (tuple2 != null) {
            MapType mapType;
            DataType e12;
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType && !e2.sameType(e12 = (mapType = (MapType)dataType).keyType())) {
                TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(89).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(MapType$.MODULE$.simpleString()).append(" followed by a value of same key type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
                return var1_8;
            }
        }
        if (tuple2 != null && !((e1 = (DataType)tuple2._1()) instanceof MapType) && !(e1 instanceof ArrayType)) {
            TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(74).append("The first argument to function ").append(this.prettyName()).append(" should ").append("have been ").append(ArrayType$.MODULE$.simpleString()).append(" or ").append(MapType$.MODULE$.simpleString()).append(" type, but its ").append(this.left().dataType().catalogString()).append(" type.").toString());
            return var1_8;
        }
        TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
        return var1_8;
    }

    private boolean nullability(Seq<Expression> elements, int ordinal) {
        return ordinal == 0 ? false : (elements.length() < package$.MODULE$.abs(ordinal) ? true : (ordinal < 0 ? ((Expression)elements.apply(elements.length() + ordinal)).nullable() : ((Expression)elements.apply(ordinal - 1)).nullable()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean computeNullabilityFromArray(Expression child, Expression ordinal) {
        if (!ordinal.foldable()) return true;
        if (ordinal.nullable()) return true;
        int intOrdinal = ((Number)ordinal.eval(ordinal.eval$default$1())).intValue();
        Expression expression = child;
        if (!(expression instanceof CreateArray)) {
            if (!(expression instanceof GetArrayStructFields)) return true;
            GetArrayStructFields getArrayStructFields = (GetArrayStructFields)expression;
            Expression expression2 = getArrayStructFields.child();
            StructField field = getArrayStructFields.field();
            if (!(expression2 instanceof CreateArray)) return true;
            CreateArray createArray = (CreateArray)expression2;
            Seq<Expression> elements = createArray.children();
            if (this.nullability(elements, intOrdinal)) return true;
            if (!field.nullable()) return false;
            return true;
        }
        CreateArray createArray = (CreateArray)expression;
        Seq<Expression> ar = createArray.children();
        boolean bl = this.nullability(ar, intOrdinal);
        boolean bl2 = bl;
        return bl2;
    }

    @Override
    public boolean nullable() {
        boolean bl;
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            bl = this.computeNullabilityFromArray(this.left(), this.right());
        } else if (dataType instanceof MapType) {
            bl = true;
        } else {
            throw new MatchError((Object)dataType);
        }
        return bl;
    }

    @Override
    public Object nullSafeEval(Object value, Object ordinal) {
        return this.doElementAt().apply(value, ordinal);
    }

    private Function2<Object, Object, Object> doElementAt$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                Function2 & Serializable & scala.Serializable intersect;
                DataType dataType = this.left().dataType();
                if (dataType instanceof ArrayType) {
                    intersect = (Function2 & Serializable & scala.Serializable)(value, ordinal) -> {
                        Object object;
                        ArrayData array = (ArrayData)value;
                        int index = BoxesRunTime.unboxToInt((Object)ordinal);
                        if (array.numElements() < package$.MODULE$.abs(index)) {
                            object = null;
                        } else {
                            if (index == 0) {
                                throw new ArrayIndexOutOfBoundsException("SQL array indices start at 1");
                            }
                            int idx = index > 0 ? index - 1 : array.numElements() + index;
                            object = this.arrayContainsNull() && array.isNullAt(idx) ? null : array.get(idx, this.dataType());
                        }
                        return object;
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function2 & Serializable & scala.Serializable)(value, ordinal) -> this.getValueEval(value, ordinal, this.mapKeyType(), this.ordering());
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doElementAt = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.doElementAt;
    }

    private Function2<Object, Object, Object> doElementAt() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.doElementAt$lzycompute() : this.doElementAt;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> {
                String index = ctx.freshName("elementAtIndex");
                String nullCheck = this.arrayContainsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\n               |if (").append((String)eval1).append(".isNullAt(").append(index).append(")) {\n               |  ").append(ev.isNull()).append(" = true;\n               |} else\n             ").toString())).stripMargin() : "";
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(489).append("\n             |int ").append(index).append(" = (int) ").append((String)eval2).append(";\n             |if (").append((String)eval1).append(".numElements() < Math.abs(").append(index).append(")) {\n             |  ").append(ev.isNull()).append(" = true;\n             |} else {\n             |  if (").append(index).append(" == 0) {\n             |    throw new ArrayIndexOutOfBoundsException(\"SQL array indices start at 1\");\n             |  } else if (").append(index).append(" > 0) {\n             |    ").append(index).append("--;\n             |  } else {\n             |    ").append(index).append(" += ").append((String)eval1).append(".numElements();\n             |  }\n             |  ").append(nullCheck).append("\n             |  {\n             |    ").append(ev.value()).append(" = ").append(CodeGenerator$.MODULE$.getValue((String)eval1, this.dataType(), index)).append(";\n             |  }\n             |}\n           ").toString())).stripMargin();
            });
        } else if (dataType instanceof MapType) {
            exprCode = this.doGetValueGenCode(ctx, ev, (MapType)this.left().dataType());
        } else {
            throw new MatchError((Object)dataType);
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "element_at";
    }

    public ElementAt copy(Expression left, Expression right) {
        return new ElementAt(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ElementAt";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ElementAt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ElementAt)) return false;
        boolean bl = true;
        if (!bl) return false;
        ElementAt elementAt = (ElementAt)x$1;
        Expression expression = this.left();
        Expression expression2 = elementAt.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = elementAt.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!elementAt.canEqual(this)) return false;
        return true;
    }

    public ElementAt(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        GetMapValueUtil.$init$(this);
        GetArrayItemUtil.$init$(this);
    }
}

