/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FromUnixTime$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ExpressionDescription(usage="_FUNC_(unix_time[, format]) - Returns `unix_time` in the specified `format`.", arguments="\n    Arguments:\n      * unix_time - UNIX Timestamp to be converted to the provided format.\n      * format - Date/time format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a>\n                 for valid date and time format patterns. The 'yyyy-MM-dd HH:mm:ss' pattern is used if omitted.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(0, 'yyyy-MM-dd HH:mm:ss');\n       1969-12-31 16:00:00\n\n      > SELECT _FUNC_(0);\n       1969-12-31 16:00:00\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t%c\u0001\u0002\u0015*\u0001ZB\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0001\u000b\u0001BK\u0002\u0013\u00051\n\u0003\u0005R\u0001\tE\t\u0015!\u0003M\u0011!\u0011\u0006A!f\u0001\n\u0003\u0019\u0006\u0002\u00032\u0001\u0005#\u0005\u000b\u0011\u0002+\t\u000b\r\u0004A\u0011\u00013\t\u000b\r\u0004A\u0011A5\t\u000b1\u0004A\u0011I&\t\u000b5\u0004A\u0011I&\t\u000b9\u0004A\u0011I8\t\u000b\r\u0004A\u0011\u00019\t\u000bM\u0004A\u0011\t;\t\u000bm\u0004A\u0011\t?\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u0011Q\u0004\u0001\u0005B\u0005}\u0001BCA\u0012\u0001!\u0015\r\u0011\"\u0003\u0002&!Q\u0011Q\u0007\u0001\t\u0006\u0004%I!a\u000e\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002H!9\u00111\f\u0001\u0005B\u0005u\u0003\"CA=\u0001\u0005\u0005I\u0011AA>\u0011%\t\u0019\tAI\u0001\n\u0003\t)\tC\u0005\u0002\u001c\u0002\t\n\u0011\"\u0001\u0002\u0006\"I\u0011Q\u0014\u0001\u0012\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0003G\u0003\u0011\u0011!C!\u0003KC\u0011\"!.\u0001\u0003\u0003%\t!a.\t\u0013\u0005}\u0006!!A\u0005\u0002\u0005\u0005\u0007\"CAd\u0001\u0005\u0005I\u0011IAe\u0011%\t9\u000eAA\u0001\n\u0003\tI\u000eC\u0005\u0002^\u0002\t\t\u0011\"\u0011\u0002`\u001eI!\u0011B\u0015\u0002\u0002#\u0005!1\u0002\u0004\tQ%\n\t\u0011#\u0001\u0003\u000e!11\r\tC\u0001\u00057A\u0011B!\b!\u0003\u0003%)Ea\b\t\u0013\t\u0005\u0002%!A\u0005\u0002\n\r\u0002\"\u0003B\u0016AE\u0005I\u0011AAP\u0011%\u0011i\u0003IA\u0001\n\u0003\u0013y\u0003C\u0005\u0003>\u0001\n\n\u0011\"\u0001\u0002 \"I!q\b\u0011\u0002\u0002\u0013%!\u0011\t\u0002\r\rJ|W.\u00168jqRKW.\u001a\u0006\u0003U-\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A&L\u0001\tG\u0006$\u0018\r\\=ti*\u0011afL\u0001\u0004gFd'B\u0001\u00192\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00114'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0005\u0019qN]4\u0004\u0001M1\u0001aN\u001e?\u0003\u001e\u0003\"\u0001O\u001d\u000e\u0003%J!AO\u0015\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001d=\u0013\ti\u0014FA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011\u0001hP\u0005\u0003\u0001&\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\b!J|G-^2u!\t\u0011\u0005*\u0003\u0002J\u0007\na1+\u001a:jC2L'0\u00192mK\u0006\u00191/Z2\u0016\u00031\u0003\"\u0001O'\n\u00059K#AC#yaJ,7o]5p]\u0006!1/Z2!\u0003\u00191wN]7bi\u00069am\u001c:nCR\u0004\u0013A\u0003;j[\u0016TvN\\3JIV\tA\u000bE\u0002C+^K!AV\"\u0003\r=\u0003H/[8o!\tAvL\u0004\u0002Z;B\u0011!lQ\u0007\u00027*\u0011A,N\u0001\u0007yI|w\u000e\u001e \n\u0005y\u001b\u0015A\u0002)sK\u0012,g-\u0003\u0002aC\n11\u000b\u001e:j]\u001eT!AX\"\u0002\u0017QLW.\u001a.p]\u0016LE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u00154w\r\u001b\t\u0003q\u0001AQAS\u0004A\u00021CQ\u0001U\u0004A\u00021CqAU\u0004\u0011\u0002\u0003\u0007A\u000bF\u0002fU.DQA\u0013\u0005A\u00021CQ\u0001\u0015\u0005A\u00021\u000bA\u0001\\3gi\u0006)!/[4ii\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003]#\"!Z9\t\u000bId\u0001\u0019\u0001'\u0002\tUt\u0017\u000e_\u0001\tI\u0006$\u0018\rV=qKV\tQ\u000f\u0005\u0002ws6\tqO\u0003\u0002y[\u0005)A/\u001f9fg&\u0011!p\u001e\u0002\t\t\u0006$\u0018\rV=qK\u0006Aa.\u001e7mC\ndW-F\u0001~!\t\u0011e0\u0003\u0002\u0000\u0007\n9!i\\8mK\u0006t\u0017AC5oaV$H+\u001f9fgV\u0011\u0011Q\u0001\t\u0007\u0003\u000f\t\t\"a\u0006\u000f\t\u0005%\u0011Q\u0002\b\u00045\u0006-\u0011\"\u0001#\n\u0007\u0005=1)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0011Q\u0003\u0002\u0004'\u0016\f(bAA\b\u0007B\u0019a/!\u0007\n\u0007\u0005mqO\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006aq/\u001b;i)&lWMW8oKR\u00191(!\t\t\u000bI\u0003\u0002\u0019A,\u0002\u0017\r|gn\u001d;G_Jl\u0017\r^\u000b\u0003\u0003O\u0001B!!\u000b\u000225\u0011\u00111\u0006\u0006\u0004q\u00065\"bAA\u0018_\u00051QO\\:bM\u0016LA!a\r\u0002,\tQQ\u000b\u0016$9'R\u0014\u0018N\\4\u0002\u0013\u0019|'/\\1ui\u0016\u0014XCAA\u001d!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA W\u0005!Q\u000f^5m\u0013\u0011\t\u0019%!\u0010\u0003%QKW.Z:uC6\u0004hi\u001c:nCR$XM]\u0001\u0005KZ\fG\u000e\u0006\u0003\u0002J\u0005=\u0003c\u0001\"\u0002L%\u0019\u0011QJ\"\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002RM\u0001\n\u00111\u0001\u0002T\u0005)\u0011N\u001c9viB!\u0011QKA,\u001b\u0005Y\u0013bAA-W\tY\u0011J\u001c;fe:\fGNU8x\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002`\u0005-\u0014Q\u000f\t\u0005\u0003C\n9'\u0004\u0002\u0002d)\u0019\u0011QM\u0015\u0002\u000f\r|G-Z4f]&!\u0011\u0011NA2\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA7)\u0001\u0007\u0011qN\u0001\u0004GRD\b\u0003BA1\u0003cJA!a\u001d\u0002d\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA<)\u0001\u0007\u0011qL\u0001\u0003KZ\fAaY8qsR9Q-! \u0002\u0000\u0005\u0005\u0005b\u0002&\u0016!\u0003\u0005\r\u0001\u0014\u0005\b!V\u0001\n\u00111\u0001M\u0011\u001d\u0011V\u0003%AA\u0002Q\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\b*\u001aA*!#,\u0005\u0005-\u0005\u0003BAG\u0003/k!!a$\u000b\t\u0005E\u00151S\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!&D\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\u000byIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0005&f\u0001+\u0002\n\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a*\u0011\t\u0005%\u00161W\u0007\u0003\u0003WSA!!,\u00020\u0006!A.\u00198h\u0015\t\t\t,\u0001\u0003kCZ\f\u0017b\u00011\u0002,\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0018\t\u0004\u0005\u0006m\u0016bAA_\u0007\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011JAb\u0011%\t)mGA\u0001\u0002\u0004\tI,A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0017\u0004b!!4\u0002T\u0006%SBAAh\u0015\r\t\tnQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAk\u0003\u001f\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019Q0a7\t\u0013\u0005\u0015W$!AA\u0002\u0005%\u0013AB3rk\u0006d7\u000fF\u0002~\u0003CD\u0011\"!2\u001f\u0003\u0003\u0005\r!!\u0013)/\u0001\t)/a;\u0002n\u0006E\u00181_A|\u0003s\fi0a@\u0003\u0004\t\u0015\u0001c\u0001\u001d\u0002h&\u0019\u0011\u0011^\u0015\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011q^\u0001M?\u001a+fjQ0)k:L\u0007p\u0018;j[\u0016\\F\u0006\t4pe6\fG/X\u0015![\u0001\u0012V\r^;s]N\u0004\u0003-\u001e8jq~#\u0018.\\3aA%t\u0007\u0005\u001e5fAM\u0004XmY5gS\u0016$\u0007\u0005\u00194pe6\fG\u000f\u0019\u0018\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA{\u0003\tM'\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011v]&Dx\f^5nK\u0002j\u0003%\u0016(J1\u0002\"\u0016.\\3ti\u0006l\u0007\u000f\t;pA\t,\u0007eY8om\u0016\u0014H/\u001a3!i>\u0004C\u000f[3!aJ|g/\u001b3fI\u00022wN]7bi:R\u0001\u0005\t\u0011!A\u0001R\u0003EZ8s[\u0006$\b%\f\u0011ECR,w\u0006^5nK\u00022wN]7bi\u0002\u0002\u0018\r\u001e;fe:\u0004Co\u001c\u0011g_2dwn\u001e\u0018!'\u0016,\u0007\u0005P1!QJ,g-\u0010\u0012iiR\u00048OO\u00180gB\f'o\u001b\u0018ba\u0006\u001c\u0007.\u001a\u0018pe\u001e|Cm\\2t_1\fG/Z:u_M\fH.\f:fM6\"\u0017\r^3uS6,W\u0006]1ui\u0016\u0014hN\f5u[2\u0014c\bR1uKRLW.\u001a\u0011QCR$XM\u001d8ty=\ngH\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0019|'\u000f\t<bY&$\u0007\u0005Z1uK\u0002\ng\u000e\u001a\u0011uS6,\u0007EZ8s[\u0006$\b\u0005]1ui\u0016\u0014hn\u001d\u0018!)\",\u0007eJ=zsflS*T\u0017eI\u0002B\u0005JO7nuM\u001cx\u0005\t9biR,'O\u001c\u0011jg\u0002*8/\u001a3!S\u001a\u0004s.\\5ui\u0016$gF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA~\u0003\u0005\u001d\"\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b\u0019-A\u001dJ\u00180_=.\u001b6kC\r\u001a\u0011I\u0011jjWNO:tO%Z$\u0002\t\u0011!A\u0001\u0002\u0003%M\u001d7s5\n$'L\u001a2AE2$\b\r\u0019;aAR!\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0014HN\u001d.cIj3'\r\u00112mi\u0002\u0004G\u000f\u00191\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018E\u0001B\u0001\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f#Aa\u0002\u0002\u000bErSG\f\u0019\u0002\u0019\u0019\u0013x.\\+oSb$\u0016.\\3\u0011\u0005a\u00023\u0003\u0002\u0011\u0003\u0010\u001d\u0003\u0002B!\u0005\u0003\u00181cE+Z\u0007\u0003\u0005'Q1A!\u0006D\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0007\u0003\u0014\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\t-\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u001d\u0016!B1qa2LHcB3\u0003&\t\u001d\"\u0011\u0006\u0005\u0006\u0015\u000e\u0002\r\u0001\u0014\u0005\u0006!\u000e\u0002\r\u0001\u0014\u0005\b%\u000e\u0002\n\u00111\u0001U\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005c\u0011I\u0004\u0005\u0003C+\nM\u0002C\u0002\"\u000361cE+C\u0002\u00038\r\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B\u001eK\u0005\u0005\t\u0019A3\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003DA!\u0011\u0011\u0016B#\u0013\u0011\u00119%a+\u0003\r=\u0013'.Z2u\u0001")
public class FromUnixTime
extends BinaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
scala.Serializable {
    private UTF8String constFormat;
    private TimestampFormatter formatter;
    private final Expression sec;
    private final Expression format;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient ZoneId zoneId;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return FromUnixTime$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(FromUnixTime fromUnixTime) {
        return FromUnixTime$.MODULE$.unapply(fromUnixTime);
    }

    public static Option<String> apply$default$3() {
        return FromUnixTime$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, FromUnixTime> tupled() {
        return FromUnixTime$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, FromUnixTime>>> curried() {
        return FromUnixTime$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    public Expression sec() {
        return this.sec;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.sec();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public String prettyName() {
        return "from_unixtime";
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{LongType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    private UTF8String constFormat$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Expression qual$1 = this.right();
                InternalRow x$1 = qual$1.eval$default$1();
                this.constFormat = (UTF8String)qual$1.eval(x$1);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.constFormat;
    }

    private UTF8String constFormat() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.constFormat$lzycompute() : this.constFormat;
    }

    private TimestampFormatter formatter$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.formatter = this.liftedTree2$1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.formatter;
    }

    private TimestampFormatter formatter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.formatter$lzycompute() : this.formatter;
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String uTF8String;
        Object time = this.left().eval(input);
        if (time == null) {
            uTF8String = null;
        } else if (this.format().foldable()) {
            if (this.constFormat() == null || this.formatter() == null) {
                uTF8String = null;
            } else {
                try {
                    uTF8String = UTF8String.fromString((String)this.formatter().format(BoxesRunTime.unboxToLong((Object)time) * 1000000L));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof SparkUpgradeException) {
                        SparkUpgradeException sparkUpgradeException = (SparkUpgradeException)throwable2;
                        throw sparkUpgradeException;
                    }
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Object var3_7 = null;
                    uTF8String = var3_7;
                }
            }
        } else {
            Object f = this.format().eval(input);
            if (f == null) {
                uTF8String = null;
            } else {
                try {
                    uTF8String = UTF8String.fromString((String)TimestampFormatter$.MODULE$.apply(f.toString(), this.zoneId(), LegacyDateFormats$.MODULE$.SIMPLE_DATE_FORMAT(), false).format(BoxesRunTime.unboxToLong((Object)time) * 1000000L));
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    if (throwable3 instanceof SparkUpgradeException) {
                        SparkUpgradeException sparkUpgradeException = (SparkUpgradeException)throwable3;
                        throw sparkUpgradeException;
                    }
                    Option option = NonFatal$.MODULE$.unapply(throwable3);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Object var2_13 = null;
                    uTF8String = var2_13;
                }
            }
        }
        return uTF8String;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String df = TimestampFormatter.class.getName();
        if (this.format().foldable()) {
            if (this.formatter() == null) {
                exprCode = ExprCode$.MODULE$.forNullValue(StringType$.MODULE$);
            } else {
                String formatterName = ctx.addReferenceObj("formatter", this.formatter(), df);
                ExprCode t = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            try {\n              ", " = UTF8String.fromString(", ".format(", " * 1000000L));\n            } catch (java.lang.IllegalArgumentException e) {\n              ", " = true;\n            }\n          }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.code(), ev.isNull(), t.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), formatterName, t.value(), ev.isNull()})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
            String tf = new StringOps(Predef$.MODULE$.augmentString(TimestampFormatter$.MODULE$.getClass().getName())).stripSuffix("$");
            String ldf = new StringOps(Predef$.MODULE$.augmentString(LegacyDateFormats$.MODULE$.getClass().getName())).stripSuffix("$");
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(seconds, f) -> new StringBuilder(255).append("\n        try {\n          ").append(ev.value()).append(" = UTF8String.fromString(\n            ").append(tf).append("$.MODULE$.apply(").append((String)f).append(".toString(), ").append(zid).append(", ").append(ldf).append("$.MODULE$.SIMPLE_DATE_FORMAT(), false)\n              .format(").append((String)seconds).append(" * 1000000L));\n        } catch (java.lang.IllegalArgumentException e) {\n          ").append(ev.isNull()).append(" = true;\n        }").toString());
        }
        return exprCode;
    }

    public FromUnixTime copy(Expression sec, Expression format, Option<String> timeZoneId) {
        return new FromUnixTime(sec, format, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.sec();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "FromUnixTime";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.sec();
                break;
            }
            case 1: {
                option = this.format();
                break;
            }
            case 2: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FromUnixTime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FromUnixTime)) return false;
        boolean bl = true;
        if (!bl) return false;
        FromUnixTime fromUnixTime = (FromUnixTime)x$1;
        Expression expression = this.sec();
        Expression expression2 = fromUnixTime.sec();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = fromUnixTime.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = fromUnixTime.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!fromUnixTime.canEqual(this)) return false;
        return true;
    }

    private final TimestampFormatter liftedTree2$1() {
        TimestampFormatter timestampFormatter;
        try {
            timestampFormatter = TimestampFormatter$.MODULE$.apply(this.constFormat().toString(), this.zoneId(), LegacyDateFormats$.MODULE$.SIMPLE_DATE_FORMAT(), false);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SparkUpgradeException) {
                SparkUpgradeException sparkUpgradeException = (SparkUpgradeException)throwable2;
                throw sparkUpgradeException;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object var1_5 = null;
            timestampFormatter = var1_5;
        }
        return timestampFormatter;
    }

    public FromUnixTime(Expression sec, Expression format, Option<String> timeZoneId) {
        this.sec = sec;
        this.format = format;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public FromUnixTime(Expression sec, Expression format) {
        this(sec, format, (Option<String>)None$.MODULE$);
    }

    public FromUnixTime(Expression unix) {
        this(unix, Literal$.MODULE$.apply(TimestampFormatter$.MODULE$.defaultPattern()));
    }
}

