/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.MakeTimestamp$;
import org.apache.spark.sql.catalyst.expressions.SeptenaryExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function7;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple8;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(year, month, day, hour, min, sec[, timezone]) - Create timestamp from year, month, day, hour, min, sec and timezone fields.", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n      * hour - the hour-of-day to represent, from 0 to 23\n      * min - the minute-of-hour to represent, from 0 to 59\n      * sec - the second-of-minute and its micro-fraction to represent, from\n              0 to 60. If the sec argument equals to 60, the seconds field is set\n              to 0 and 1 minute is added to the final timestamp.\n      * timezone - the time zone identifier. For example, CET, UTC and etc.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887);\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887, 'CET');\n       2014-12-27 21:30:45.887\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 60);\n       2019-07-01 00:00:00\n      > SELECT _FUNC_(2019, 13, 1, 10, 11, 12, 'PST');\n       NULL\n      > SELECT _FUNC_(null, 7, 22, 15, 30, 0);\n       NULL\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\t5g\u0001B\u001c9\u0001\u0016C\u0001\"\u0017\u0001\u0003\u0016\u0004%\tA\u0017\u0005\t=\u0002\u0011\t\u0012)A\u00057\"Aq\f\u0001BK\u0002\u0013\u0005!\f\u0003\u0005a\u0001\tE\t\u0015!\u0003\\\u0011!\t\u0007A!f\u0001\n\u0003Q\u0006\u0002\u00032\u0001\u0005#\u0005\u000b\u0011B.\t\u0011\r\u0004!Q3A\u0005\u0002iC\u0001\u0002\u001a\u0001\u0003\u0012\u0003\u0006Ia\u0017\u0005\tK\u0002\u0011)\u001a!C\u00015\"Aa\r\u0001B\tB\u0003%1\f\u0003\u0005h\u0001\tU\r\u0011\"\u0001[\u0011!A\u0007A!E!\u0002\u0013Y\u0006\u0002C5\u0001\u0005+\u0007I\u0011\u00016\t\u00119\u0004!\u0011#Q\u0001\n-D\u0001b\u001c\u0001\u0003\u0016\u0004%\t\u0001\u001d\u0005\t{\u0002\u0011\t\u0012)A\u0005c\")a\u0010\u0001C\u0001\u007f\"1a\u0010\u0001C\u0001\u0003'AaA \u0001\u0005\u0002\u0005\u0005\u0002bBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\b\u0003\u000f\u0002A\u0011IA%\u0011\u001d\tI\u0006\u0001C!\u00037Bq!a\u0019\u0001\t\u0003\n)\u0007C\u0004\u0002n\u0001!\t%a\u001c\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v!9\u00111\u0016\u0001\u0005B\u00055\u0006bBA`\u0001\u0011\u0005\u0013\u0011\u0019\u0005\b\u0003;\u0004A\u0011IAp\u0011%\t\t\u000fAA\u0001\n\u0003\t\u0019\u000fC\u0005\u0002v\u0002\t\n\u0011\"\u0001\u0002x\"I!Q\u0002\u0001\u0012\u0002\u0013\u0005\u0011q\u001f\u0005\n\u0005\u001f\u0001\u0011\u0013!C\u0001\u0003oD\u0011B!\u0005\u0001#\u0003%\t!a>\t\u0013\tM\u0001!%A\u0005\u0002\u0005]\b\"\u0003B\u000b\u0001E\u0005I\u0011AA|\u0011%\u00119\u0002AI\u0001\n\u0003\u0011I\u0002C\u0005\u0003\u001e\u0001\t\n\u0011\"\u0001\u0003 !I!1\u0005\u0001\u0002\u0002\u0013\u0005#Q\u0005\u0005\n\u0005c\u0001\u0011\u0011!C\u0001\u0005gA\u0011B!\u000e\u0001\u0003\u0003%\tAa\u000e\t\u0013\tu\u0002!!A\u0005B\t}\u0002\"\u0003B'\u0001\u0005\u0005I\u0011\u0001B(\u0011%\u0011\u0019\u0006AA\u0001\n\u0003\u0012)fB\u0005\u0003\u0000a\n\t\u0011#\u0001\u0003\u0002\u001aAq\u0007OA\u0001\u0012\u0003\u0011\u0019\t\u0003\u0004\u007f[\u0011\u0005!\u0011\u0013\u0005\n\u0005'k\u0013\u0011!C#\u0005+C\u0011Ba&.\u0003\u0003%\tI!'\t\u0013\t-V&%A\u0005\u0002\te\u0001\"\u0003BW[E\u0005I\u0011\u0001B\u0010\u0011%\u0011y+LA\u0001\n\u0003\u0013\t\fC\u0005\u0003@6\n\n\u0011\"\u0001\u0003\u001a!I!\u0011Y\u0017\u0012\u0002\u0013\u0005!q\u0004\u0005\n\u0005\u0007l\u0013\u0011!C\u0005\u0005\u000b\u0014Q\"T1lKRKW.Z:uC6\u0004(BA\u001d;\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005mb\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005ur\u0014aA:rY*\u0011q\bQ\u0001\u0006gB\f'o\u001b\u0006\u0003\u0003\n\u000ba!\u00199bG\",'\"A\"\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u00011%*\u0014)W!\t9\u0005*D\u00019\u0013\tI\u0005HA\nTKB$XM\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002H\u0017&\u0011A\n\u000f\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:\u0004\"a\u0012(\n\u0005=C$AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005E#V\"\u0001*\u000b\u0003M\u000bQa]2bY\u0006L!!\u0016*\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011kV\u0005\u00031J\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fA!_3beV\t1\f\u0005\u0002H9&\u0011Q\f\u000f\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!B=fCJ\u0004\u0013!B7p]RD\u0017AB7p]RD\u0007%A\u0002eCf\fA\u0001Z1zA\u0005!\u0001n\\;s\u0003\u0015Aw.\u001e:!\u0003\ri\u0017N\\\u0001\u0005[&t\u0007%A\u0002tK\u000e\fAa]3dA\u0005AA/[7fu>tW-F\u0001l!\r\tFnW\u0005\u0003[J\u0013aa\u00149uS>t\u0017!\u0003;j[\u0016TxN\\3!\u0003)!\u0018.\\3[_:,\u0017\nZ\u000b\u0002cB\u0019\u0011\u000b\u001c:\u0011\u0005MThB\u0001;y!\t)(+D\u0001w\u0015\t9H)\u0001\u0004=e>|GOP\u0005\u0003sJ\u000ba\u0001\u0015:fI\u00164\u0017BA>}\u0005\u0019\u0019FO]5oO*\u0011\u0011PU\u0001\fi&lWMW8oK&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003\u0003\t\u0019!!\u0002\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\t\t\u0002\u0005\u0002H\u0001!)\u0011,\u0005a\u00017\")q,\u0005a\u00017\")\u0011-\u0005a\u00017\")1-\u0005a\u00017\")Q-\u0005a\u00017\")q-\u0005a\u00017\"9\u0011.\u0005I\u0001\u0002\u0004Y\u0007bB8\u0012!\u0003\u0005\r!\u001d\u000b\u000f\u0003\u0003\t)\"a\u0006\u0002\u001a\u0005m\u0011QDA\u0010\u0011\u0015I&\u00031\u0001\\\u0011\u0015y&\u00031\u0001\\\u0011\u0015\t'\u00031\u0001\\\u0011\u0015\u0019'\u00031\u0001\\\u0011\u0015)'\u00031\u0001\\\u0011\u00159'\u00031\u0001\\)A\t\t!a\t\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0003[\ty\u0003C\u0003Z'\u0001\u00071\fC\u0003`'\u0001\u00071\fC\u0003b'\u0001\u00071\fC\u0003d'\u0001\u00071\fC\u0003f'\u0001\u00071\fC\u0003h'\u0001\u00071\fC\u0003j'\u0001\u00071,\u0001\u0005dQ&dGM]3o+\t\t)\u0004E\u0003\u00028\u0005\u00053L\u0004\u0003\u0002:\u0005ubbA;\u0002<%\t1+C\u0002\u0002@I\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002D\u0005\u0015#aA*fc*\u0019\u0011q\b*\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002LA1\u0011qGA!\u0003\u001b\u0002B!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'b\u0014!\u0002;za\u0016\u001c\u0018\u0002BA,\u0003#\u0012\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!!\u0018\u0011\t\u0005=\u0013qL\u0005\u0005\u0003C\n\tF\u0001\u0005ECR\fG+\u001f9f\u0003!qW\u000f\u001c7bE2,WCAA4!\r\t\u0016\u0011N\u0005\u0004\u0003W\u0012&a\u0002\"p_2,\u0017M\\\u0001\ro&$\b\u000eV5nKj{g.\u001a\u000b\u0004\u0015\u0006E\u0004\"B8\u0019\u0001\u0004\u0011\u0018\u0001\u0003;p\u001b&\u001c'o\\:\u0015!\u0005]\u0014QPAC\u0003\u000f\u000bI)a#\u0002\u000e\u0006]\u0005cA)\u0002z%\u0019\u00111\u0010*\u0003\u0007\u0005s\u0017\u0010\u0003\u0004Z3\u0001\u0007\u0011q\u0010\t\u0004#\u0006\u0005\u0015bAAB%\n\u0019\u0011J\u001c;\t\r}K\u0002\u0019AA@\u0011\u0019\t\u0017\u00041\u0001\u0002\u0000!11-\u0007a\u0001\u0003\u007fBa!Z\rA\u0002\u0005}\u0004bBAH3\u0001\u0007\u0011\u0011S\u0001\fg\u0016\u001c\u0017I\u001c3OC:|7\u000f\u0005\u0003\u0002P\u0005M\u0015\u0002BAK\u0003#\u0012q\u0001R3dS6\fG\u000eC\u0004\u0002\u001af\u0001\r!a'\u0002\ri|g.Z%e!\u0011\ti*a*\u000e\u0005\u0005}%\u0002BAQ\u0003G\u000bA\u0001^5nK*\u0011\u0011QU\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002*\u0006}%A\u0002.p]\u0016LE-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\t\u0002x\u0005=\u0016\u0011WAZ\u0003k\u000b9,!/\u0002<\"1\u0011L\u0007a\u0001\u0003oBaa\u0018\u000eA\u0002\u0005]\u0004BB1\u001b\u0001\u0004\t9\b\u0003\u0004d5\u0001\u0007\u0011q\u000f\u0005\u0007Kj\u0001\r!a\u001e\t\r\u001dT\u0002\u0019AA<\u0011\u0019I'\u00041\u0001\u0002>B!\u0011\u000b\\A<\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002D\u0006=\u0017\u0011\u001c\t\u0005\u0003\u000b\fY-\u0004\u0002\u0002H*\u0019\u0011\u0011\u001a\u001d\u0002\u000f\r|G-Z4f]&!\u0011QZAd\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBAi7\u0001\u0007\u00111[\u0001\u0004GRD\b\u0003BAc\u0003+LA!a6\u0002H\nq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBAn7\u0001\u0007\u00111Y\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f+\u0005\u0011\u0018\u0001B2paf$\"#!\u0001\u0002f\u0006\u001d\u0018\u0011^Av\u0003[\fy/!=\u0002t\"9\u0011,\bI\u0001\u0002\u0004Y\u0006bB0\u001e!\u0003\u0005\ra\u0017\u0005\bCv\u0001\n\u00111\u0001\\\u0011\u001d\u0019W\u0004%AA\u0002mCq!Z\u000f\u0011\u0002\u0003\u00071\fC\u0004h;A\u0005\t\u0019A.\t\u000f%l\u0002\u0013!a\u0001W\"9q.\bI\u0001\u0002\u0004\t\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003sT3aWA~W\t\ti\u0010\u0005\u0003\u0002\u0000\n%QB\u0001B\u0001\u0015\u0011\u0011\u0019A!\u0002\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0004%\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t-!\u0011\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nabY8qs\u0012\"WMZ1vYR$S'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!1\u0004\u0016\u0004W\u0006m\u0018AD2paf$C-\u001a4bk2$H\u0005O\u000b\u0003\u0005CQ3!]A~\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!q\u0005\t\u0005\u0005S\u0011y#\u0004\u0002\u0003,)!!QFAR\u0003\u0011a\u0017M\\4\n\u0007m\u0014Y#\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0000\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA<\u0005sA\u0011Ba\u000f)\u0003\u0003\u0005\r!a \u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\t\u0005\u0005\u0004\u0003D\t%\u0013qO\u0007\u0003\u0005\u000bR1Aa\u0012S\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u0017\u0012)E\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA4\u0005#B\u0011Ba\u000f+\u0003\u0003\u0005\r!a\u001e\u0002\r\u0015\fX/\u00197t)\u0011\t9Ga\u0016\t\u0013\tm2&!AA\u0002\u0005]\u0004f\u0006\u0001\u0003\\\t\u0005$1\rB4\u0005S\u0012iGa\u001c\u0003t\tU$\u0011\u0010B>!\r9%QL\u0005\u0004\u0005?B$!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005K\n\u0011QA0G+:\u001bu\fK=fCJd\u0003%\\8oi\"d\u0003\u0005Z1zY\u0001Bw.\u001e:-A5Lg\u000e\f\u0011tK\u000e\\F\u0006\t;j[\u0016TxN\\3^S\u0001j\u0003e\u0011:fCR,\u0007\u0005^5nKN$\u0018-\u001c9!MJ|W\u000eI=fCJd\u0003%\\8oi\"d\u0003\u0005Z1zY\u0001Bw.\u001e:-A5Lg\u000e\f\u0011tK\u000e\u0004\u0013M\u001c3!i&lWM_8oK\u00022\u0017.\u001a7eg:\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\t-\u0014\u0001b;\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001JX-\u0019:![\u0001\"\b.\u001a\u0011zK\u0006\u0014\b\u0005^8!e\u0016\u0004(/Z:f]Rd\u0003E\u001a:p[\u0002\n\u0004\u0005^8!seJ\u0014H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011n_:$\b\u000eI\u0017!i\",\u0007%\\8oi\"lsNZ\u0017zK\u0006\u0014\b\u0005^8!e\u0016\u0004(/Z:f]Rd\u0003E\u001a:p[\u0002\n\u0004\u0005\u000b&b]V\f'/_\u0015!i>\u0004\u0013G\r\u0011)\t\u0016\u001cW-\u001c2fe&R\u0001\u0005\t\u0011!A\u0001R\u0003\u0005Z1zA5\u0002C\u000f[3!I\u0006LXf\u001c4.[>tG\u000f\u001b\u0011u_\u0002\u0012X\r\u001d:fg\u0016tG\u000f\f\u0011ge>l\u0007%\r\u0011u_\u0002\u001a\u0014G\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011i_V\u0014\b%\f\u0011uQ\u0016\u0004\u0003n\\;s[=4W\u0006Z1zAQ|\u0007E]3qe\u0016\u001cXM\u001c;-A\u0019\u0014x.\u001c\u00111AQ|\u0007EM\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011+A5Lg\u000eI\u0017!i\",\u0007%\\5okR,Wf\u001c4.Q>,(\u000f\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0003\u0007\t;pAUJ$\u0002\t\u0011!A\u0001\u0002#\u0006I:fG\u0002j\u0003\u0005\u001e5fAM,7m\u001c8e[=4W&\\5okR,\u0007%\u00198eA%$8\u000fI7jGJ|WF\u001a:bGRLwN\u001c\u0011u_\u0002\u0012X\r\u001d:fg\u0016tG\u000f\f\u0011ge>l'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\r\u0011u_\u00022\u0004G\f\u0011JM\u0002\"\b.\u001a\u0011tK\u000e\u0004\u0013M]4v[\u0016tG\u000fI3rk\u0006d7\u000f\t;pAY\u0002D\u0006\t;iK\u0002\u001aXmY8oIN\u0004c-[3mI\u0002J7\u000fI:fi*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"x\u000e\t\u0019!C:$\u0007%\r\u0011nS:,H/\u001a\u0011jg\u0002\nG\rZ3eAQ|\u0007\u0005\u001e5fA\u0019Lg.\u00197!i&lWm\u001d;b[Bt#\u0002\t\u0011!A\u0001\u0002#\u0006\t;j[\u0016TxN\\3![\u0001\"\b.\u001a\u0011uS6,\u0007E_8oK\u0002JG-\u001a8uS\u001aLWM\u001d\u0018!\r>\u0014\b%\u001a=b[BdW\r\f\u0011D\u000bRc\u0003%\u0016+DA\u0005tG\rI3uG:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!\u0011O\u0001\u0004\u0010)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C#\u0007M\u00195Y\u0001\n$\u0007\f\u00113q1\u0002c\u0007\f\u00114a1\u0002C'\u000e\u00189q]J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cQj\u0013GM\u00173q\u0001\u0002dGO\u001a1uQ*d\u0006\u000f\u001d8\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012\u0004'\r\u001b-AE\u0012D\u0006\t\u001a9Y\u00012D\u0006I\u001a1Y\u0001\"TG\f\u001d9o1\u0002seQ#UO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192i5\n$'\f\u001a8AI\n$h\r\u0019;iUr\u0003\bO\u001c\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QI\u0002\u0014'\u000f\u0017!m1\u00023\u0007\r\u0017!eMb\u0003%N\u001d-AY\u0002\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aEJT\u0006M\u001c.aE\u0002\u0003\u0007\r\u001e1ai\u0002\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00153aEJD\u0006I\u00194Y\u0001\nD\u0006I\u00191Y\u0001\n\u0014\u0007\f\u00112e1\u0002s\u0005U*UO%Z$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cc.\u001e7mY\u0001:D\u0006\t\u001a3Y\u0001\nT\u0007\f\u00114a1\u0002\u0003'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u001dVcEJ\u0003\u0011!\u0003\u00159'o\\;qC\t\u00119(\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\tu\u0014!B\u001a/a9\u0002\u0014!D'bW\u0016$\u0016.\\3ti\u0006l\u0007\u000f\u0005\u0002H[M!QF!\"W!9\u00119I!$\\7n[6lW6r\u0003\u0003i!A!#\u000b\u0007\t-%+A\u0004sk:$\u0018.\\3\n\t\t=%\u0011\u0012\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:DDC\u0001BA\u0003!!xn\u0015;sS:<GC\u0001B\u0014\u0003\u0015\t\u0007\u000f\u001d7z)I\t\tAa'\u0003\u001e\n}%\u0011\u0015BR\u0005K\u00139K!+\t\u000be\u0003\u0004\u0019A.\t\u000b}\u0003\u0004\u0019A.\t\u000b\u0005\u0004\u0004\u0019A.\t\u000b\r\u0004\u0004\u0019A.\t\u000b\u0015\u0004\u0004\u0019A.\t\u000b\u001d\u0004\u0004\u0019A.\t\u000f%\u0004\u0004\u0013!a\u0001W\"9q\u000e\rI\u0001\u0002\u0004\t\u0018aD1qa2LH\u0005Z3gCVdG\u000fJ\u001c\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIa\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u00034\nm\u0006\u0003B)m\u0005k\u00032\"\u0015B\\7n[6lW.lc&\u0019!\u0011\u0018*\u0003\rQ+\b\u000f\\39\u0011%\u0011ilMA\u0001\u0002\u0004\t\t!A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(A\u0006sK\u0006$'+Z:pYZ,GC\u0001Bd!\u0011\u0011IC!3\n\t\t-'1\u0006\u0002\u0007\u001f\nTWm\u0019;")
public class MakeTimestamp
extends SeptenaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
scala.Serializable {
    private final Expression year;
    private final Expression month;
    private final Expression day;
    private final Expression hour;
    private final Expression min;
    private final Expression sec;
    private final Option<Expression> timezone;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient ZoneId zoneId;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$8() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Expression> $lessinit$greater$default$7() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<Tuple8<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Option<String>>> unapply(MakeTimestamp makeTimestamp) {
        return MakeTimestamp$.MODULE$.unapply(makeTimestamp);
    }

    public static Option<String> apply$default$8() {
        return MakeTimestamp$.MODULE$.apply$default$8();
    }

    public static Option<Expression> apply$default$7() {
        return MakeTimestamp$.MODULE$.apply$default$7();
    }

    public static Function1<Tuple8<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Option<String>>, MakeTimestamp> tupled() {
        return MakeTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Option<Expression>, Function1<Option<String>, MakeTimestamp>>>>>>>> curried() {
        return MakeTimestamp$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        MakeTimestamp makeTimestamp = this;
        synchronized (makeTimestamp) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        MakeTimestamp makeTimestamp = this;
        synchronized (makeTimestamp) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    public Expression year() {
        return this.year;
    }

    public Expression month() {
        return this.month;
    }

    public Expression day() {
        return this.day;
    }

    public Expression hour() {
        return this.hour;
    }

    public Expression min() {
        return this.min;
    }

    public Expression sec() {
        return this.sec;
    }

    public Option<Expression> timezone() {
        return this.timezone;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.year(), this.month(), this.day(), this.hour(), this.min(), this.sec()}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.timezone()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, new DecimalType(8, 6)}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.timezone().map((Function1 & Serializable & scala.Serializable)x$3 -> StringType$.MODULE$)), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        Expression x$6 = this.copy$default$5();
        Expression x$7 = this.copy$default$6();
        Option<Expression> x$8 = this.copy$default$7();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, (Option<String>)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object toMicros(int year, int month, int day, int hour, int min, Decimal secAndNanos, ZoneId zoneId) {
        try {
            LocalDateTime localDateTime;
            Decimal secFloor = secAndNanos.floor();
            Decimal nanosPerSec = Decimal$.MODULE$.apply(1000000000L, 10, 0);
            int nanos = secAndNanos.$minus(secFloor).$times(nanosPerSec).toInt();
            int seconds = secFloor.toInt();
            if (seconds == 60) {
                if (nanos != 0) throw new DateTimeException("The fraction of sec must be zero. Valid range is [0, 60].");
                localDateTime = LocalDateTime.of(year, month, day, hour, min, 0, 0).plusMinutes(1L);
            } else {
                localDateTime = LocalDateTime.of(year, month, day, hour, min, seconds, nanos);
            }
            LocalDateTime ldt = localDateTime;
            Long l = BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(ldt.atZone(zoneId).toInstant()));
            return l;
        }
        catch (DateTimeException dateTimeException) {
            return null;
        }
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object day, Object hour, Object min, Object sec, Option<Object> timezone) {
        ZoneId zid = (ZoneId)timezone.map((Function1 & Serializable & scala.Serializable)tz -> DateTimeUtils$.MODULE$.getZoneId(((UTF8String)tz).toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.zoneId());
        return this.toMicros(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)day), BoxesRunTime.unboxToInt((Object)hour), BoxesRunTime.unboxToInt((Object)min), (Decimal)sec, zid);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
        String d = new StringOps(Predef$.MODULE$.augmentString(Decimal$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.nullSafeCodeGen(ctx, ev, (Function7<String, String, String, String, String, String, Option<String>, String>)(Function7 & Serializable & scala.Serializable)(year, month, day, hour, min, secAndNanos, timezone) -> {
            String zoneId = (String)timezone.map((Function1 & Serializable & scala.Serializable)tz -> new StringBuilder(23).append(dtu).append(".getZoneId(").append((String)tz).append(".toString())").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> zid);
            return new StringBuilder(895).append("\n      try {\n        org.apache.spark.sql.types.Decimal secFloor = ").append((String)secAndNanos).append(".floor();\n        org.apache.spark.sql.types.Decimal nanosPerSec = ").append(d).append("$.MODULE$.apply(1000000000L, 10, 0);\n        int nanos = ((").append((String)secAndNanos).append(".$minus(secFloor)).$times(nanosPerSec)).toInt();\n        int seconds = secFloor.toInt();\n        java.time.LocalDateTime ldt;\n        if (seconds == 60) {\n          if (nanos == 0) {\n            ldt = java.time.LocalDateTime.of(\n              ").append((String)year).append(", ").append((String)month).append(", ").append((String)day).append(", ").append((String)hour).append(", ").append((String)min).append(", 0, 0).plusMinutes(1);\n          } else {\n            throw new java.time.DateTimeException(\n              \"The fraction of sec must be zero. Valid range is [0, 60].\");\n          }\n        } else {\n          ldt = java.time.LocalDateTime.of(").append((String)year).append(", ").append((String)month).append(", ").append((String)day).append(", ").append((String)hour).append(", ").append((String)min).append(", seconds, nanos);\n        }\n        java.time.Instant instant = ldt.atZone(").append(zoneId).append(").toInstant();\n        ").append(ev.value()).append(" = ").append(dtu).append(".instantToMicros(instant);\n      } catch (java.time.DateTimeException e) {\n        ").append(ev.isNull()).append(" = true;\n      }").toString();
        });
    }

    @Override
    public String prettyName() {
        return "make_timestamp";
    }

    public MakeTimestamp copy(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, Option<String> timeZoneId) {
        return new MakeTimestamp(year, month, day, hour, min, sec, timezone, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.year();
    }

    public Expression copy$default$2() {
        return this.month();
    }

    public Expression copy$default$3() {
        return this.day();
    }

    public Expression copy$default$4() {
        return this.hour();
    }

    public Expression copy$default$5() {
        return this.min();
    }

    public Expression copy$default$6() {
        return this.sec();
    }

    public Option<Expression> copy$default$7() {
        return this.timezone();
    }

    public Option<String> copy$default$8() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "MakeTimestamp";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.year();
                break;
            }
            case 1: {
                object = this.month();
                break;
            }
            case 2: {
                object = this.day();
                break;
            }
            case 3: {
                object = this.hour();
                break;
            }
            case 4: {
                object = this.min();
                break;
            }
            case 5: {
                object = this.sec();
                break;
            }
            case 6: {
                object = this.timezone();
                break;
            }
            case 7: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeTimestamp makeTimestamp = (MakeTimestamp)x$1;
        Expression expression = this.year();
        Expression expression2 = makeTimestamp.year();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.month();
        Expression expression4 = makeTimestamp.month();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.day();
        Expression expression6 = makeTimestamp.day();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.hour();
        Expression expression8 = makeTimestamp.hour();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.min();
        Expression expression10 = makeTimestamp.min();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        Expression expression11 = this.sec();
        Expression expression12 = makeTimestamp.sec();
        if (expression11 == null) {
            if (expression12 != null) {
                return false;
            }
        } else if (!expression11.equals(expression12)) return false;
        Option<Expression> option = this.timezone();
        Option<Expression> option2 = makeTimestamp.timezone();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = makeTimestamp.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!makeTimestamp.canEqual(this)) return false;
        return true;
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, Option<String> timeZoneId) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        this.timezone = timezone;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec) {
        this(year, month, day, hour, min, sec, (Option<Expression>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Expression timezone) {
        this(year, month, day, hour, min, sec, (Option<Expression>)new Some((Object)timezone), (Option<String>)None$.MODULE$);
    }
}

