/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.IntegerLiteral$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NonNullLiteral$;
import org.apache.spark.sql.catalyst.expressions.TimeWindow;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class TimeWindow$
implements Serializable {
    public static TimeWindow$ MODULE$;

    static {
        new TimeWindow$();
    }

    private long getIntervalInMicroSeconds(String interval) {
        CalendarInterval cal = IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)interval));
        if (cal.months != 0) {
            throw new IllegalArgumentException(new StringBuilder(51).append("Intervals greater than a month is not supported (").append(interval).append(").").toString());
        }
        return (long)cal.days * 86400000000L + cal.microseconds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long org$apache$spark$sql$catalyst$expressions$TimeWindow$$parseExpression(Expression expr) {
        Option<Object> option;
        boolean bl = false;
        Literal literal = null;
        Expression expression = expr;
        if (expression instanceof Literal) {
            bl = true;
            literal = (Literal)expression;
            Option<Tuple2<Object, DataType>> option2 = NonNullLiteral$.MODULE$.unapply(literal);
            if (!option2.isEmpty()) {
                Object s = ((Tuple2)option2.get())._1();
                DataType dataType = (DataType)((Tuple2)option2.get())._2();
                if (StringType$.MODULE$.equals(dataType)) {
                    return this.getIntervalInMicroSeconds(s.toString());
                }
            }
        }
        if (!(option = IntegerLiteral$.MODULE$.unapply(expression)).isEmpty()) {
            int i = BoxesRunTime.unboxToInt((Object)option.get());
            return i;
        }
        if (!bl) throw new AnalysisException("The duration and time inputs to window must be an integer, long or string literal.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        Option<Tuple2<Object, DataType>> option3 = NonNullLiteral$.MODULE$.unapply(literal);
        if (option3.isEmpty()) throw new AnalysisException("The duration and time inputs to window must be an integer, long or string literal.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        Object l = ((Tuple2)option3.get())._1();
        DataType dataType = (DataType)((Tuple2)option3.get())._2();
        if (!LongType$.MODULE$.equals(dataType)) throw new AnalysisException("The duration and time inputs to window must be an integer, long or string literal.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        return new StringOps(Predef$.MODULE$.augmentString(l.toString())).toLong();
    }

    public TimeWindow apply(Expression timeColumn, String windowDuration, String slideDuration, String startTime) {
        return new TimeWindow(timeColumn, this.getIntervalInMicroSeconds(windowDuration), this.getIntervalInMicroSeconds(slideDuration), this.getIntervalInMicroSeconds(startTime));
    }

    public TimeWindow apply(Expression timeColumn, long windowDuration, long slideDuration, long startTime) {
        return new TimeWindow(timeColumn, windowDuration, slideDuration, startTime);
    }

    public Option<Tuple4<Expression, Object, Object, Object>> unapply(TimeWindow x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.timeColumn(), (Object)BoxesRunTime.boxToLong((long)x$0.windowDuration()), (Object)BoxesRunTime.boxToLong((long)x$0.slideDuration()), (Object)BoxesRunTime.boxToLong((long)x$0.startTime())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TimeWindow$() {
        MODULE$ = this;
    }
}

