/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.ToUnixTimestamp$;
import org.apache.spark.sql.catalyst.expressions.UnixTime;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timeExp[, format]) - Returns the UNIX timestamp of the given time.", arguments="\n    Arguments:\n      * timeExp - A date/timestamp or string which is returned as a UNIX timestamp.\n      * format - Date/time format pattern to follow. Ignored if `timeExp` is not a string.\n                 Default value is \"yyyy-MM-dd HH:mm:ss\". See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a>\n                 for valid date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-04-08', 'yyyy-MM-dd');\n       1460098800\n  ", group="datetime_funcs", since="1.6.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0011#\u0001>B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u0005\u0002\u0011\t\u0012)A\u0005\u007f!A1\t\u0001BK\u0002\u0013\u0005a\b\u0003\u0005E\u0001\tE\t\u0015!\u0003@\u0011!)\u0005A!f\u0001\n\u00031\u0005\u0002C+\u0001\u0005#\u0005\u000b\u0011B$\t\u000bY\u0003A\u0011A,\t\u000bY\u0003A\u0011\u0001/\t\u000b}\u0003A\u0011\t \t\u000b\u0001\u0004A\u0011\t \t\u000b\u0005\u0004A\u0011\t2\t\u000bY\u0003A\u0011A4\t\u000b)\u0004A\u0011I6\t\u000f1\u0004\u0011\u0011!C\u0001[\"9\u0011\u000fAI\u0001\n\u0003\u0011\bbB?\u0001#\u0003%\tA\u001d\u0005\b}\u0002\t\n\u0011\"\u0001\u0000\u0011%\t\u0019\u0001AA\u0001\n\u0003\n)\u0001C\u0005\u0002\u0016\u0001\t\t\u0011\"\u0001\u0002\u0018!I\u0011q\u0004\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0005\u0005\n\u0003[\u0001\u0011\u0011!C!\u0003_A\u0011\"!\u0010\u0001\u0003\u0003%\t!a\u0010\t\u0013\u0005%\u0003!!A\u0005B\u0005-s!CA;E\u0005\u0005\t\u0012AA<\r!\t#%!A\t\u0002\u0005e\u0004B\u0002,\u001a\t\u0003\t9\tC\u0005\u0002\nf\t\t\u0011\"\u0012\u0002\f\"I\u0011QR\r\u0002\u0002\u0013\u0005\u0015q\u0012\u0005\t\u0003/K\u0012\u0013!C\u0001\u007f\"I\u0011\u0011T\r\u0002\u0002\u0013\u0005\u00151\u0014\u0005\t\u0003SK\u0012\u0013!C\u0001\u007f\"I\u00111V\r\u0002\u0002\u0013%\u0011Q\u0016\u0002\u0010)>,f.\u001b=US6,7\u000f^1na*\u00111\u0005J\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002&M\u0005A1-\u0019;bYf\u001cHO\u0003\u0002(Q\u0005\u00191/\u001d7\u000b\u0005%R\u0013!B:qCJ\\'BA\u0016-\u0003\u0019\t\u0007/Y2iK*\tQ&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001aQR\u0004CA\u00193\u001b\u0005\u0011\u0013BA\u001a#\u0005!)f.\u001b=US6,\u0007CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$a\u0002)s_\u0012,8\r\u001e\t\u0003kmJ!\u0001\u0010\u001c\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000fQLW.Z#yaV\tq\b\u0005\u00022\u0001&\u0011\u0011I\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001\u0003;j[\u0016,\u0005\u0010\u001d\u0011\u0002\r\u0019|'/\\1u\u0003\u001d1wN]7bi\u0002\n!\u0002^5nKj{g.Z%e+\u00059\u0005cA\u001bI\u0015&\u0011\u0011J\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005-\u0013fB\u0001'Q!\tie'D\u0001O\u0015\tye&\u0001\u0004=e>|GOP\u0005\u0003#Z\na\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011KN\u0001\fi&lWMW8oK&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u00051fS6\f\u0005\u00022\u0001!)Qh\u0002a\u0001\u007f!)1i\u0002a\u0001\u007f!9Qi\u0002I\u0001\u0002\u00049Ec\u0001-^=\")Q\b\u0003a\u0001\u007f!)1\t\u0003a\u0001\u007f\u0005!A.\u001a4u\u0003\u0015\u0011\u0018n\u001a5u\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\t\u0019g\r\u0005\u00022I&\u0011QM\t\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:DQ!R\u0006A\u0002)#\"\u0001\u00175\t\u000b%d\u0001\u0019A \u0002\tQLW.Z\u0001\u000baJ,G\u000f^=OC6,W#\u0001&\u0002\t\r|\u0007/\u001f\u000b\u00051:|\u0007\u000fC\u0004>\u001dA\u0005\t\u0019A \t\u000f\rs\u0001\u0013!a\u0001\u007f!9QI\u0004I\u0001\u0002\u00049\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0002g*\u0012q\b^\u0016\u0002kB\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\nk:\u001c\u0007.Z2lK\u0012T!A\u001f\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002}o\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA\u0001U\t9E/A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00145\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!\u0001\u0003mC:<'BAA\t\u0003\u0011Q\u0017M^1\n\u0007M\u000bY!\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u001aA\u0019Q'a\u0007\n\u0007\u0005uaGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002$\u0005%\u0002cA\u001b\u0002&%\u0019\u0011q\u0005\u001c\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002,Q\t\t\u00111\u0001\u0002\u001a\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\r\u0011\r\u0005M\u0012\u0011HA\u0012\u001b\t\t)DC\u0002\u00028Y\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY$!\u000e\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0003\n9\u0005E\u00026\u0003\u0007J1!!\u00127\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u000b\u0017\u0003\u0003\u0005\r!a\t\u0002\r\u0015\fX/\u00197t)\u0011\t\t%!\u0014\t\u0013\u0005-r#!AA\u0002\u0005\r\u0002f\u0006\u0001\u0002R\u0005]\u0013\u0011LA/\u0003?\n\u0019'!\u001a\u0002j\u0005-\u0014qNA9!\r\t\u00141K\u0005\u0004\u0003+\u0012#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u00037\n\u0011j\u0018$V\u001d\u000e{\u0006\u0006^5nK\u0016C\bo\u0017\u0017!M>\u0014X.\u0019;^S\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002*f*\u0013-!i&lWm\u001d;b[B\u0004sN\u001a\u0011uQ\u0016\u0004s-\u001b<f]\u0002\"\u0018.\\3/\u0003%\t'oZ;nK:$8/\t\u0002\u0002b\u0005\u00199D\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!i&lW-\u0012=qA5\u0002\u0013\t\t3bi\u0016|C/[7fgR\fW\u000e\u001d\u0011pe\u0002\u001aHO]5oO\u0002:\b.[2iA%\u001c\bE]3ukJtW\r\u001a\u0011bg\u0002\n\u0007%\u0016(J1\u0002\"\u0018.\\3ti\u0006l\u0007O\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!M>\u0014X.\u0019;![\u0001\"\u0015\r^30i&lW\r\t4pe6\fG\u000f\t9biR,'O\u001c\u0011u_\u00022w\u000e\u001c7po:\u0002\u0013j\u001a8pe\u0016$\u0007%\u001b4!ARLW.Z#ya\u0002\u0004\u0013n\u001d\u0011o_R\u0004\u0013\rI:ue&twM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"UMZ1vYR\u0004c/\u00197vK\u0002J7\u000f\t\u0012zsfLX&T'.I\u0012\u0004\u0003\n\u0013\u001en[j\u001a8O\t\u0018!'\u0016,\u0007\u0005P1!QJ,g-\u0010\u0012iiR\u00048OO\u00180gB\f'o\u001b\u0018ba\u0006\u001c\u0007.\u001a\u0018pe\u001e|Cm\\2t_1\fG/Z:u_M\fH.\f:fM6\"\u0017\r^3uS6,W\u0006]1ui\u0016\u0014hN\f5u[2\u0014c\bR1uKRLW.\u001a\u0011QCR$XM\u001d8ty=\ngH\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0019|'\u000f\t<bY&$\u0007\u0005Z1uK\u0002\ng\u000e\u001a\u0011uS6,\u0007EZ8s[\u0006$\b\u0005]1ui\u0016\u0014hn\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003O\naK\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\nd'\f\u00195[ABt\u0005\f\u0011(sfL\u00180L'N[\u0011$w%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cQ2\u0004\u0007M\u001d9qA\u0002$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u00055\u0014A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003g\nQ!\r\u00187]A\nq\u0002V8V]&DH+[7fgR\fW\u000e\u001d\t\u0003ce\u0019B!GA>uAA\u0011QPAB\u007f}:\u0005,\u0004\u0002\u0002\u0000)\u0019\u0011\u0011\u0011\u001c\u0002\u000fI,h\u000e^5nK&!\u0011QQA@\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003o\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u000f\tQ!\u00199qYf$r\u0001WAI\u0003'\u000b)\nC\u0003>9\u0001\u0007q\bC\u0003D9\u0001\u0007q\bC\u0004F9A\u0005\t\u0019A$\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u001e\u0006\u0015\u0006\u0003B\u001bI\u0003?\u0003b!NAQ\u007f}:\u0015bAARm\t1A+\u001e9mKNB\u0001\"a*\u001f\u0003\u0003\u0005\r\u0001W\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'A\u0006sK\u0006$'+Z:pYZ,GCAAX!\u0011\tI!!-\n\t\u0005M\u00161\u0002\u0002\u0007\u001f\nTWm\u0019;")
public class ToUnixTimestamp
extends UnixTime
implements Serializable {
    private final Expression timeExp;
    private final Expression format;
    private final Option<String> timeZoneId;

    public static Option<String> $lessinit$greater$default$3() {
        return ToUnixTimestamp$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(ToUnixTimestamp toUnixTimestamp) {
        return ToUnixTimestamp$.MODULE$.unapply(toUnixTimestamp);
    }

    public static Option<String> apply$default$3() {
        return ToUnixTimestamp$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, ToUnixTimestamp> tupled() {
        return ToUnixTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, ToUnixTimestamp>>> curried() {
        return ToUnixTimestamp$.MODULE$.curried();
    }

    public Expression timeExp() {
        return this.timeExp;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.timeExp();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public String prettyName() {
        return "to_unix_timestamp";
    }

    public ToUnixTimestamp copy(Expression timeExp, Expression format, Option<String> timeZoneId) {
        return new ToUnixTimestamp(timeExp, format, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.timeExp();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "ToUnixTimestamp";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.timeExp();
                break;
            }
            case 1: {
                option = this.format();
                break;
            }
            case 2: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToUnixTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToUnixTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToUnixTimestamp toUnixTimestamp = (ToUnixTimestamp)x$1;
        Expression expression = this.timeExp();
        Expression expression2 = toUnixTimestamp.timeExp();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = toUnixTimestamp.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = toUnixTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!toUnixTimestamp.canEqual(this)) return false;
        return true;
    }

    public ToUnixTimestamp(Expression timeExp, Expression format, Option<String> timeZoneId) {
        this.timeExp = timeExp;
        this.format = format;
        this.timeZoneId = timeZoneId;
    }

    public ToUnixTimestamp(Expression timeExp, Expression format) {
        this(timeExp, format, (Option<String>)None$.MODULE$);
    }

    public ToUnixTimestamp(Expression time) {
        this(time, Literal$.MODULE$.apply(TimestampFormatter$.MODULE$.defaultPattern()));
    }
}

