/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnixTime;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([timeExp[, format]]) - Returns the UNIX timestamp of current or specified time.", arguments="\n    Arguments:\n      * timeExp - A date/timestamp or string. If not provided, this defaults to current time.\n      * format - Date/time format pattern to follow. Ignored if `timeExp` is not a string.\n                 Default value is \"yyyy-MM-dd HH:mm:ss\". See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\"> Datetime Patterns</a>\n                 for valid date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_();\n       1476884637\n      > SELECT _FUNC_('2016-04-08', 'yyyy-MM-dd');\n       1460041200\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001\u0002\u0012$\u0001BB\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\"AA\t\u0001BK\u0002\u0013\u0005q\b\u0003\u0005F\u0001\tE\t\u0015!\u0003A\u0011!1\u0005A!f\u0001\n\u00039\u0005\u0002\u0003,\u0001\u0005#\u0005\u000b\u0011\u0002%\t\u000b]\u0003A\u0011\u0001-\t\u000b]\u0003A\u0011A/\t\u000b\u0001\u0004A\u0011I \t\u000b\u0005\u0004A\u0011I \t\u000b\t\u0004A\u0011I2\t\u000b]\u0003A\u0011\u00015\t\u000b]\u0003A\u0011A6\t\u000b1\u0004A\u0011I7\t\u000f9\u0004\u0011\u0011!C\u0001_\"91\u000fAI\u0001\n\u0003!\bbB@\u0001#\u0003%\t\u0001\u001e\u0005\n\u0003\u0003\u0001\u0011\u0013!C\u0001\u0003\u0007A\u0011\"a\u0002\u0001\u0003\u0003%\t%!\u0003\t\u0013\u0005e\u0001!!A\u0005\u0002\u0005m\u0001\"CA\u0012\u0001\u0005\u0005I\u0011AA\u0013\u0011%\t\t\u0004AA\u0001\n\u0003\n\u0019\u0004C\u0005\u0002B\u0001\t\t\u0011\"\u0001\u0002D!I\u0011Q\n\u0001\u0002\u0002\u0013\u0005\u0013qJ\u0004\n\u0003s\u001a\u0013\u0011!E\u0001\u0003w2\u0001BI\u0012\u0002\u0002#\u0005\u0011Q\u0010\u0005\u0007/j!\t!a#\t\u0013\u00055%$!A\u0005F\u0005=\u0005\"CAI5\u0005\u0005I\u0011QAJ\u0011%\tYJGI\u0001\n\u0003\t\u0019\u0001C\u0005\u0002\u001ej\t\t\u0011\"!\u0002 \"I\u0011Q\u0016\u000e\u0012\u0002\u0013\u0005\u00111\u0001\u0005\n\u0003_S\u0012\u0011!C\u0005\u0003c\u0013Q\"\u00168jqRKW.Z:uC6\u0004(B\u0001\u0013&\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0019:\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005!J\u0013aA:rY*\u0011!fK\u0001\u0006gB\f'o\u001b\u0006\u0003Y5\na!\u00199bG\",'\"\u0001\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\tTg\u000f\t\u0003eMj\u0011aI\u0005\u0003i\r\u0012\u0001\"\u00168jqRKW.\u001a\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\b!J|G-^2u!\t1D(\u0003\u0002>o\ta1+\u001a:jC2L'0\u00192mK\u00069A/[7f\u000bb\u0004X#\u0001!\u0011\u0005I\n\u0015B\u0001\"$\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\ti&lW-\u0012=qA\u00051am\u001c:nCR\fqAZ8s[\u0006$\b%\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012\u0001\u0013\t\u0004m%[\u0015B\u0001&8\u0005\u0019y\u0005\u000f^5p]B\u0011Aj\u0015\b\u0003\u001bF\u0003\"AT\u001c\u000e\u0003=S!\u0001U\u0018\u0002\rq\u0012xn\u001c;?\u0013\t\u0011v'\u0001\u0004Qe\u0016$WMZ\u0005\u0003)V\u0013aa\u0015;sS:<'B\u0001*8\u0003-!\u0018.\\3[_:,\u0017\n\u001a\u0011\u0002\rqJg.\u001b;?)\u0011I&l\u0017/\u0011\u0005I\u0002\u0001\"\u0002 \b\u0001\u0004\u0001\u0005\"\u0002#\b\u0001\u0004\u0001\u0005b\u0002$\b!\u0003\u0005\r\u0001\u0013\u000b\u00043z{\u0006\"\u0002 \t\u0001\u0004\u0001\u0005\"\u0002#\t\u0001\u0004\u0001\u0015\u0001\u00027fMR\fQA]5hQR\fAb^5uQRKW.\u001a.p]\u0016$\"\u0001Z4\u0011\u0005I*\u0017B\u00014$\u0005]!\u0016.\\3[_:,\u0017i^1sK\u0016C\bO]3tg&|g\u000eC\u0003G\u0017\u0001\u00071\n\u0006\u0002ZS\")!\u000e\u0004a\u0001\u0001\u0006!A/[7f)\u0005I\u0016A\u00039sKR$\u0018PT1nKV\t1*\u0001\u0003d_BLH\u0003B-qcJDqAP\b\u0011\u0002\u0003\u0007\u0001\tC\u0004E\u001fA\u0005\t\u0019\u0001!\t\u000f\u0019{\u0001\u0013!a\u0001\u0011\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A;+\u0005\u000138&A<\u0011\u0005alX\"A=\u000b\u0005i\\\u0018!C;oG\",7m[3e\u0015\tax'\u0001\u0006b]:|G/\u0019;j_:L!A`=\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0001\u0016\u0003\u0011Z\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0006!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\tA\u0001\\1oO*\u0011\u0011QC\u0001\u0005U\u00064\u0018-C\u0002U\u0003\u001f\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\b\u0011\u0007Y\ny\"C\u0002\u0002\"]\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\n\u0002.A\u0019a'!\u000b\n\u0007\u0005-rGA\u0002B]fD\u0011\"a\f\u0016\u0003\u0003\u0005\r!!\b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u0004\u0005\u0004\u00028\u0005u\u0012qE\u0007\u0003\u0003sQ1!a\u000f8\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u007f\tID\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA#\u0003\u0017\u00022ANA$\u0013\r\tIe\u000e\u0002\b\u0005>|G.Z1o\u0011%\tycFA\u0001\u0002\u0004\t9#\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u000b\n\t\u0006C\u0005\u00020a\t\t\u00111\u0001\u0002(!:\u0002!!\u0016\u0002\\\u0005u\u0013\u0011MA2\u0003O\nI'!\u001c\u0002p\u0005M\u0014Q\u000f\t\u0004e\u0005]\u0013bAA-G\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA0\u0003Y{f)\u0016(D?\"ZF/[7f\u000bb\u00048\f\f\u0011g_Jl\u0017\r^/^S\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002*f*\u0013-!i&lWm\u001d;b[B\u0004sN\u001a\u0011dkJ\u0014XM\u001c;!_J\u00043\u000f]3dS\u001aLW\r\u001a\u0011uS6,g&A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011QM\u0001\u0004N)\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003\u0005^5nK\u0016C\b\u000fI\u0017!\u0003\u0002\"\u0017\r^30i&lWm\u001d;b[B\u0004sN\u001d\u0011tiJLgn\u001a\u0018!\u0013\u001a\u0004cn\u001c;!aJ|g/\u001b3fI2\u0002C\u000f[5tA\u0011,g-Y;miN\u0004Co\u001c\u0011dkJ\u0014XM\u001c;!i&lWM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!M>\u0014X.\u0019;![\u0001\"\u0015\r^30i&lW\r\t4pe6\fG\u000f\t9biR,'O\u001c\u0011u_\u00022w\u000e\u001c7po:\u0002\u0013j\u001a8pe\u0016$\u0007%\u001b4!ARLW.Z#ya\u0002\u0004\u0013n\u001d\u0011o_R\u0004\u0013\rI:ue&twM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"UMZ1vYR\u0004c/\u00197vK\u0002J7\u000f\t\u0012zsfLX&T'.I\u0012\u0004\u0003\n\u0013\u001en[j\u001a8O\t\u0018!'\u0016,\u0007\u0005P1!QJ,g-\u0010\u0012iiR\u00048OO\u00180gB\f'o\u001b\u0018ba\u0006\u001c\u0007.\u001a\u0018pe\u001e|Cm\\2t_1\fG/Z:u_M\fH.\f:fM6\"\u0017\r^3uS6,W\u0006]1ui\u0016\u0014hN\f5u[2\u0014c\b\t#bi\u0016$\u0018.\\3!!\u0006$H/\u001a:ogrz\u0013M\u0010\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u00012wN\u001d\u0011wC2LG\r\t3bi\u0016\u0004\u0013M\u001c3!i&lW\r\t4pe6\fG\u000f\t9biR,'O\\:/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005-\u0014!a\u0001\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u001b8maBDGN\u001a8\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#\u0007M\u00197[A\"T\u0006\r\u001d(Y\u0001:\u00130_=z[5kU\u0006\u001a3(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013\u0007\u000e\u001c1aQ\n$\u0007\r\u0019\u000bA\u0001\nQa\u001a:pkB\f#!!\u001d\u0002\u001d\u0011\fG/\u001a;j[\u0016|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011qO\u0001\u0006c9*d\u0006M\u0001\u000e+:L\u0007\u0010V5nKN$\u0018-\u001c9\u0011\u0005IR2\u0003\u0002\u000e\u0002\u0000m\u0002\u0002\"!!\u0002\b\u0002\u0003\u0005*W\u0007\u0003\u0003\u0007S1!!\"8\u0003\u001d\u0011XO\u001c;j[\u0016LA!!#\u0002\u0004\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\u0005m\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005-\u0011!B1qa2LHcB-\u0002\u0016\u0006]\u0015\u0011\u0014\u0005\u0006}u\u0001\r\u0001\u0011\u0005\u0006\tv\u0001\r\u0001\u0011\u0005\b\rv\u0001\n\u00111\u0001I\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003C\u000bI\u000b\u0005\u00037\u0013\u0006\r\u0006C\u0002\u001c\u0002&\u0002\u0003\u0005*C\u0002\u0002(^\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CAV?\u0005\u0005\t\u0019A-\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u00024B!\u0011QBA[\u0013\u0011\t9,a\u0004\u0003\r=\u0013'.Z2u\u0001")
public class UnixTimestamp
extends UnixTime
implements Serializable {
    private final Expression timeExp;
    private final Expression format;
    private final Option<String> timeZoneId;

    public static Option<String> $lessinit$greater$default$3() {
        return UnixTimestamp$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(UnixTimestamp unixTimestamp) {
        return UnixTimestamp$.MODULE$.unapply(unixTimestamp);
    }

    public static Option<String> apply$default$3() {
        return UnixTimestamp$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, UnixTimestamp> tupled() {
        return UnixTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, UnixTimestamp>>> curried() {
        return UnixTimestamp$.MODULE$.curried();
    }

    public Expression timeExp() {
        return this.timeExp;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.timeExp();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public String prettyName() {
        return "unix_timestamp";
    }

    public UnixTimestamp copy(Expression timeExp, Expression format, Option<String> timeZoneId) {
        return new UnixTimestamp(timeExp, format, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.timeExp();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "UnixTimestamp";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.timeExp();
                break;
            }
            case 1: {
                option = this.format();
                break;
            }
            case 2: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnixTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnixTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnixTimestamp unixTimestamp = (UnixTimestamp)x$1;
        Expression expression = this.timeExp();
        Expression expression2 = unixTimestamp.timeExp();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = unixTimestamp.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = unixTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!unixTimestamp.canEqual(this)) return false;
        return true;
    }

    public UnixTimestamp(Expression timeExp, Expression format, Option<String> timeZoneId) {
        this.timeExp = timeExp;
        this.format = format;
        this.timeZoneId = timeZoneId;
    }

    public UnixTimestamp(Expression timeExp, Expression format) {
        this(timeExp, format, (Option<String>)None$.MODULE$);
    }

    public UnixTimestamp(Expression time) {
        this(time, Literal$.MODULE$.apply(TimestampFormatter$.MODULE$.defaultPattern()));
    }

    public UnixTimestamp() {
        this(new CurrentTimestamp());
    }
}

