/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog$;
import org.apache.spark.sql.connector.catalog.CatalogExtension;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogNotFoundException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Catalogs$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c!\u0002\u000f\u001e\u0001\u0005J\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011u\u0002!\u0011!Q\u0001\nyB\u0001B\u0011\u0001\u0003\u0006\u0004%\ta\u0011\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\t\")A\n\u0001C\u0001\u001b\"9!\u000b\u0001b\u0001\n\u0013\u0019\u0006BB4\u0001A\u0003%A\u000bC\u0003\u001f\u0001\u0011\u0005\u0001\u000eC\u0003l\u0001\u0011\u0005A\u000eC\u0003r\u0001\u0011%!\u000f\u0003\u0004t\u0001\u0011\u0005\u0011\u0005\u001e\u0005\bk\u0002\u0001\r\u0011\"\u0003w\u0011\u001di\b\u00011A\u0005\nyDq!!\u0003\u0001A\u0003&q\u000fC\u0004\u0002\f\u0001!\t!!\u0004\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!I\u0011q\u0003\u0001A\u0002\u0013%\u0011\u0011\u0004\u0005\n\u0003;\u0001\u0001\u0019!C\u0005\u0003?A\u0001\"a\t\u0001A\u0003&\u00111\u0004\u0005\u0007\u0003K\u0001A\u0011\u0001;\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*!A\u0011q\u0006\u0001\u0005\u0002\u0005\n\td\u0002\u0005\u00024uA\t!IA\u001b\r\u001daR\u0004#\u0001\"\u0003oAa\u0001\u0014\r\u0005\u0002\u0005e\u0002\"CA\u001e1\t\u0007I\u0011AA\u001f\u0011\u001d\ty\u0004\u0007Q\u0001\nq\u0013abQ1uC2|w-T1oC\u001e,'O\u0003\u0002\u001f?\u000591-\u0019;bY><'B\u0001\u0011\"\u0003%\u0019wN\u001c8fGR|'O\u0003\u0002#G\u0005\u00191/\u001d7\u000b\u0005\u0011*\u0013!B:qCJ\\'B\u0001\u0014(\u0003\u0019\t\u0007/Y2iK*\t\u0001&A\u0002pe\u001e\u001c2\u0001\u0001\u00161!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fMB\u0011\u0011\u0007N\u0007\u0002e)\u00111gI\u0001\tS:$XM\u001d8bY&\u0011QG\r\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0004\u0001A\u0011\u0011hO\u0007\u0002u)\u00111'I\u0005\u0003yi\u0012qaU)M\u0007>tg-A\u000beK\u001a\fW\u000f\u001c;TKN\u001c\u0018n\u001c8DCR\fGn\\4\u0011\u0005}\u0002U\"A\u000f\n\u0005\u0005k\"!D\"bi\u0006dwn\u001a)mk\u001eLg.\u0001\twcM+7o]5p]\u000e\u000bG/\u00197pOV\tA\t\u0005\u0002F\u00136\taI\u0003\u0002\u001f\u000f*\u0011\u0001*I\u0001\tG\u0006$\u0018\r\\=ti&\u0011!J\u0012\u0002\u000f'\u0016\u001c8/[8o\u0007\u0006$\u0018\r\\8h\u0003E1\u0018gU3tg&|gnQ1uC2|w\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t9{\u0005+\u0015\t\u0003\u007f\u0001AQAN\u0003A\u0002aBQ!P\u0003A\u0002yBQAQ\u0003A\u0002\u0011\u000b\u0001bY1uC2|wm]\u000b\u0002)B!QK\u0017/?\u001b\u00051&BA,Y\u0003\u001diW\u000f^1cY\u0016T!!\u0017\u0017\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\\-\n9\u0001*Y:i\u001b\u0006\u0004\bCA/e\u001d\tq&\r\u0005\u0002`Y5\t\u0001M\u0003\u0002bo\u00051AH]8pizJ!a\u0019\u0017\u0002\rA\u0013X\rZ3g\u0013\t)gM\u0001\u0004TiJLgn\u001a\u0006\u0003G2\n\u0011bY1uC2|wm\u001d\u0011\u0015\u0005yJ\u0007\"\u00026\t\u0001\u0004a\u0016\u0001\u00028b[\u0016\f1#[:DCR\fGn\\4SK\u001eL7\u000f^3sK\u0012$\"!\u001c9\u0011\u0005-r\u0017BA8-\u0005\u001d\u0011un\u001c7fC:DQA[\u0005A\u0002q\u000bA\u0003\\8bIZ\u00134+Z:tS>t7)\u0019;bY><G#\u0001 \u0002!Y\u00144+Z:tS>t7)\u0019;bY><W#\u0001 \u0002#}\u001bWO\u001d:f]Rt\u0015-\\3ta\u0006\u001cW-F\u0001x!\rY\u0003P_\u0005\u0003s2\u0012aa\u00149uS>t\u0007cA\u0016|9&\u0011A\u0010\f\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0016?\u000e,(O]3oi:\u000bW.Z:qC\u000e,w\fJ3r)\ry\u0018Q\u0001\t\u0004W\u0005\u0005\u0011bAA\u0002Y\t!QK\\5u\u0011!\t9!DA\u0001\u0002\u00049\u0018a\u0001=%c\u0005\u0011rlY;se\u0016tGOT1nKN\u0004\u0018mY3!\u0003A\u0019WO\u001d:f]Rt\u0015-\\3ta\u0006\u001cW-F\u0001{\u0003M\u0019X\r^\"veJ,g\u000e\u001e(b[\u0016\u001c\b/Y2f)\ry\u00181\u0003\u0005\u0007\u0003+\u0001\u0002\u0019\u0001>\u0002\u00139\fW.Z:qC\u000e,\u0017aE0dkJ\u0014XM\u001c;DCR\fGn\\4OC6,WCAA\u000e!\rY\u0003\u0010X\u0001\u0018?\u000e,(O]3oi\u000e\u000bG/\u00197pO:\u000bW.Z0%KF$2a`A\u0011\u0011%\t9AEA\u0001\u0002\u0004\tY\"\u0001\u000b`GV\u0014(/\u001a8u\u0007\u0006$\u0018\r\\8h\u001d\u0006lW\rI\u0001\u000fGV\u0014(/\u001a8u\u0007\u0006$\u0018\r\\8h\u0003E\u0019X\r^\"veJ,g\u000e^\"bi\u0006dwn\u001a\u000b\u0004\u007f\u0006-\u0002BBA\u0017+\u0001\u0007A,A\u0006dCR\fGn\\4OC6,\u0017!\u0002:fg\u0016$H#A@\u0002\u001d\r\u000bG/\u00197pO6\u000bg.Y4feB\u0011q\bG\n\u00031)\"\"!!\u000e\u0002)M+5kU%P\u001d~\u001b\u0015\tV!M\u001f\u001e{f*Q'F+\u0005a\u0016!F*F'NKuJT0D\u0003R\u000bEjT$`\u001d\u0006kU\t\t")
public class CatalogManager
implements Logging {
    private final SQLConf conf;
    private final CatalogPlugin defaultSessionCatalog;
    private final SessionCatalog v1SessionCatalog;
    private final HashMap<String, CatalogPlugin> catalogs;
    private Option<String[]> _currentNamespace;
    private Option<String> _currentCatalogName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String SESSION_CATALOG_NAME() {
        return CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SessionCatalog v1SessionCatalog() {
        return this.v1SessionCatalog;
    }

    private HashMap<String, CatalogPlugin> catalogs() {
        return this.catalogs;
    }

    public synchronized CatalogPlugin catalog(String name) {
        return name.equalsIgnoreCase(CatalogManager$.MODULE$.SESSION_CATALOG_NAME()) ? this.v2SessionCatalog() : (CatalogPlugin)this.catalogs().getOrElseUpdate((Object)name, (Function0 & Serializable & scala.Serializable)() -> Catalogs$.MODULE$.load(name, $this.conf));
    }

    public boolean isCatalogRegistered(String name) {
        boolean bl;
        try {
            this.catalog(name);
            bl = true;
        }
        catch (CatalogNotFoundException catalogNotFoundException) {
            bl = false;
        }
        return bl;
    }

    private CatalogPlugin loadV2SessionCatalog() {
        CatalogPlugin catalogPlugin;
        CatalogPlugin catalogPlugin2 = Catalogs$.MODULE$.load(CatalogManager$.MODULE$.SESSION_CATALOG_NAME(), this.conf);
        if (catalogPlugin2 instanceof CatalogExtension) {
            CatalogExtension catalogExtension = (CatalogExtension)catalogPlugin2;
            catalogExtension.setDelegateCatalog(this.defaultSessionCatalog);
            catalogPlugin = catalogExtension;
        } else {
            catalogPlugin = catalogPlugin2;
        }
        return catalogPlugin;
    }

    public CatalogPlugin v2SessionCatalog() {
        return (CatalogPlugin)this.conf.getConf(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION()).map((Function1 & Serializable & scala.Serializable)customV2SessionCatalog -> {
            CatalogPlugin catalogPlugin;
            try {
                catalogPlugin = (CatalogPlugin)this.catalogs().getOrElseUpdate((Object)CatalogManager$.MODULE$.SESSION_CATALOG_NAME(), (Function0 & Serializable & scala.Serializable)() -> this.loadV2SessionCatalog());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Fail to instantiate the custom v2 session catalog: ").append((String)customV2SessionCatalog).toString());
                CatalogPlugin catalogPlugin2 = $this.defaultSessionCatalog;
                catalogPlugin = catalogPlugin2;
            }
            return catalogPlugin;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.defaultSessionCatalog);
    }

    private Option<String[]> _currentNamespace() {
        return this._currentNamespace;
    }

    private void _currentNamespace_$eq(Option<String[]> x$1) {
        this._currentNamespace = x$1;
    }

    public synchronized String[] currentNamespace() {
        return (String[])this._currentNamespace().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String string = this.currentCatalog().name();
            String string2 = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
            return !(string != null ? !string.equals(string2) : string2 != null) ? (String[])((Object[])new String[]{this.v1SessionCatalog().getCurrentDatabase()}) : this.currentCatalog().defaultNamespace();
        });
    }

    public synchronized void setCurrentNamespace(String[] namespace) {
        String string = this.currentCatalog().name();
        String string2 = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (namespace.length != 1) {
                throw new NoSuchNamespaceException(namespace);
            }
            this.v1SessionCatalog().setCurrentDatabase((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).head());
        } else {
            this._currentNamespace_$eq((Option<String[]>)new Some((Object)namespace));
        }
    }

    private Option<String> _currentCatalogName() {
        return this._currentCatalogName;
    }

    private void _currentCatalogName_$eq(Option<String> x$1) {
        this._currentCatalogName = x$1;
    }

    public synchronized CatalogPlugin currentCatalog() {
        return this.catalog((String)this._currentCatalogName().getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.conf.getConf(SQLConf$.MODULE$.DEFAULT_CATALOG())));
    }

    public synchronized void setCurrentCatalog(String catalogName) {
        block0: {
            String string = this.currentCatalog().name();
            String string2 = catalogName;
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            this._currentCatalogName_$eq((Option<String>)new Some((Object)catalogName));
            this._currentNamespace_$eq((Option<String[]>)None$.MODULE$);
            this.v1SessionCatalog().setCurrentDatabase(SessionCatalog$.MODULE$.DEFAULT_DATABASE());
        }
    }

    public synchronized void reset() {
        this.catalogs().clear();
        this._currentNamespace_$eq((Option<String[]>)None$.MODULE$);
        this._currentCatalogName_$eq((Option<String>)None$.MODULE$);
        this.v1SessionCatalog().setCurrentDatabase(SessionCatalog$.MODULE$.DEFAULT_DATABASE());
    }

    public CatalogManager(SQLConf conf, CatalogPlugin defaultSessionCatalog, SessionCatalog v1SessionCatalog) {
        this.conf = conf;
        this.defaultSessionCatalog = defaultSessionCatalog;
        this.v1SessionCatalog = v1SessionCatalog;
        Logging.$init$((Logging)this);
        this.catalogs = HashMap$.MODULE$.empty();
        this._currentNamespace = None$.MODULE$;
        this._currentCatalogName = None$.MODULE$;
    }
}

