/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LessThan$;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is less than `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 1 _FUNC_ 2;\n       true\n      > SELECT 1.1 _FUNC_ '1';\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       true\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001\u0002\r\u001a\u0001\u001aB\u0001b\u000f\u0001\u0003\u0016\u0004%\t\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0012)A\u0005{!A\u0011\t\u0001BK\u0002\u0013\u0005A\b\u0003\u0005C\u0001\tE\t\u0015!\u0003>\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u0015A\u0005\u0001\"\u0011J\u0011\u0015)\u0006\u0001\"\u0015W\u0011\u001dq\u0006!!A\u0005\u0002}CqA\u0019\u0001\u0012\u0002\u0013\u00051\rC\u0004o\u0001E\u0005I\u0011A2\t\u000f=\u0004\u0011\u0011!C!a\"9\u0001\u0010AA\u0001\n\u0003I\bbB?\u0001\u0003\u0003%\tA \u0005\n\u0003\u0007\u0001\u0011\u0011!C!\u0003\u000bA\u0011\"a\u0005\u0001\u0003\u0003%\t!!\u0006\t\u0013\u0005}\u0001!!A\u0005B\u0005\u0005r!CA#3\u0005\u0005\t\u0012AA$\r!A\u0012$!A\t\u0002\u0005%\u0003BB\"\u0013\t\u0003\t9\u0006C\u0005\u0002ZI\t\t\u0011\"\u0012\u0002\\!I\u0011Q\f\n\u0002\u0002\u0013\u0005\u0015q\f\u0005\n\u0003K\u0012\u0012\u0011!CA\u0003OB\u0011\"!\u001f\u0013\u0003\u0003%I!a\u001f\u0003\u00111+7o\u001d+iC:T!AG\u000e\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u00039u\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003=}\t1a]9m\u0015\t\u0001\u0013%A\u0003ta\u0006\u00148N\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0006\u0001\u001dZ#\u0007\u000f\t\u0003Q%j\u0011!G\u0005\u0003Ue\u0011\u0001CQ5oCJL8i\\7qCJL7o\u001c8\u0011\u00051zcB\u0001\u0015.\u0013\tq\u0013$A\u0004qC\u000e\\\u0017mZ3\n\u0005A\n$A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003]e\u0001\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00024s%\u0011!\b\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005Y\u00164G/F\u0001>!\tAc(\u0003\u0002@3\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003\u0019a\u0014N\\5u}Q\u0019QIR$\u0011\u0005!\u0002\u0001\"B\u001e\u0006\u0001\u0004i\u0004\"B!\u0006\u0001\u0004i\u0014AB:z[\n|G.F\u0001K!\tY%K\u0004\u0002M!B\u0011Q\nN\u0007\u0002\u001d*\u0011q*J\u0001\u0007yI|w\u000e\u001e \n\u0005E#\u0014A\u0002)sK\u0012,g-\u0003\u0002T)\n11\u000b\u001e:j]\u001eT!!\u0015\u001b\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0007]SF\f\u0005\u000241&\u0011\u0011\f\u000e\u0002\u0004\u0003:L\b\"B.\b\u0001\u00049\u0016AB5oaV$\u0018\u0007C\u0003^\u000f\u0001\u0007q+\u0001\u0004j]B,HOM\u0001\u0005G>\u0004\u0018\u0010F\u0002FA\u0006Dqa\u000f\u0005\u0011\u0002\u0003\u0007Q\bC\u0004B\u0011A\u0005\t\u0019A\u001f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tAM\u000b\u0002>K.\na\r\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003WR\n!\"\u00198o_R\fG/[8o\u0013\ti\u0007NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002cB\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0005Y\u0006twMC\u0001w\u0003\u0011Q\u0017M^1\n\u0005M\u001b\u0018\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001>\u0011\u0005MZ\u0018B\u0001?5\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\t9v\u0010\u0003\u0005\u0002\u00025\t\t\u00111\u0001{\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0001\t\u0006\u0003\u0013\tyaV\u0007\u0003\u0003\u0017Q1!!\u00045\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003#\tYA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\f\u0003;\u00012aMA\r\u0013\r\tY\u0002\u000e\u0002\b\u0005>|G.Z1o\u0011!\t\taDA\u0001\u0002\u00049\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0018\u0005\r\u0002\u0002CA\u0001!\u0005\u0005\t\u0019A,)'\u0001\t9#!\f\u00020\u0005M\u0012QGA\u001d\u0003w\ty$!\u0011\u0011\u0007!\nI#C\u0002\u0002,e\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u00022\u0005\u0011U\r\u001f9sc\u0001zf)\u0016(D?\u0002*\u0007\u0010\u001d:3A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e:vK\u0002Jg\r\t1fqB\u0014\u0018\u0007\u0019\u0011jg\u0002bWm]:!i\"\fg\u000e\t1fqB\u0014(\u0007\u0019\u0018\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA\u001c\u0003\tM%\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011fqB\u0014\u0018\u0007\f\u0011fqB\u0014(\u0007I\u0017!i\",\u0007\u0005^<pA\u0015D\bO]3tg&|gn\u001d\u0011nkN$\bEY3!g\u0006lW\r\t;za\u0016\u0004sN\u001d\u0011dC:\u0004#-\u001a\u0011dCN$X\r\u001a\u0011u_\u0002\n\u0007eY8n[>t\u0007\u0005^=qK2R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011b]\u0012\u0004S.^:uA\t,\u0007%\u0019\u0011usB,\u0007\u0005\u001e5bi\u0002\u001a\u0017M\u001c\u0011cK\u0002z'\u000fZ3sK\u0012t\u0003ER8sA\u0015D\u0018-\u001c9mK2\u0002S.\u00199!if\u0004X\rI5tA9|G\u000fI8sI\u0016\u0014\u0018M\u00197fY\u0001\u001ax\u000eI5u\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%[:!]>$\be];qa>\u0014H/\u001a3/A\u0019{'\u000fI2p[BdW\r\u001f\u0011usB,7\u000fI:vG\"\u0004\u0013M\u001d:bs>\u001aHO];di2\u0002C\u000f[3!I\u0006$\u0018\r\t;za\u0016\u001c\be\u001c4!M&,G\u000eZ:![V\u001cHO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\t,\u0007e\u001c:eKJ\f'\r\\3/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005u\u0012Aa)\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAE\u0002sLR+O\u0007~\u0003#g\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u0019/c\u0001zf)\u0016(D?\u0002:\u0013gJ\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!M\u0006d7/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!i>|F-\u0019;fQ\u001d\u0012\u0004\u0007M\u001d.a]j3\u0007\r\u00111ii\ntGO\u001b3O%\u0002sLR+O\u0007~\u0003Co\\0eCR,\u0007f\n\u001a1aej\u0003gN\u00174a\u0001\u0002DGO\u00198uU\u0012t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!M\u0006d7/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!i>|F-\u0019;fQ\u001d\u0012\u0004\u0007M\u001d.a]j3\u0007\r\u00111ii\ntGO\u001b3O%\u0002sLR+O\u0007~\u0003Co\\0eCR,\u0007f\n\u001a1aej\u0003\u0007O\u00171c\u0001\u0002DGO\u00198uU\u0012t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u00112A}3UKT\"`A9+F\nT\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u001dVcEJ\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019%A\u00032]Ar\u0003'\u0001\u0005MKN\u001cH\u000b[1o!\tA#c\u0005\u0003\u0013\u0003\u0017B\u0004cBA'\u0003'jT(R\u0007\u0003\u0003\u001fR1!!\u00155\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\u0016\u0002P\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\u0005\u001d\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003E\fQ!\u00199qYf$R!RA1\u0003GBQaO\u000bA\u0002uBQ!Q\u000bA\u0002u\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002j\u0005U\u0004#B\u001a\u0002l\u0005=\u0014bAA7i\t1q\n\u001d;j_:\u0004RaMA9{uJ1!a\u001d5\u0005\u0019!V\u000f\u001d7fe!A\u0011q\u000f\f\u0002\u0002\u0003\u0007Q)A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0010\t\u0004e\u0006}\u0014bAAAg\n1qJ\u00196fGR\u0004")
public class LessThan
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(LessThan lessThan) {
        return LessThan$.MODULE$.unapply(lessThan);
    }

    public static Function1<Tuple2<Expression, Expression>, LessThan> tupled() {
        return LessThan$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, LessThan>> curried() {
        return LessThan$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "<";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().lt(input1, input2));
    }

    public LessThan copy(Expression left, Expression right) {
        return new LessThan(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "LessThan";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LessThan;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LessThan)) return false;
        boolean bl = true;
        if (!bl) return false;
        LessThan lessThan = (LessThan)x$1;
        Expression expression = this.left();
        Expression expression2 = lessThan.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = lessThan.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!lessThan.canEqual(this)) return false;
        return true;
    }

    public LessThan(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

