/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RDG;
import org.apache.spark.sql.catalyst.expressions.Randn$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([seed]) - Returns a random value with independent and identically distributed (i.i.d.) values drawn from the standard normal distribution.", examples="\n    Examples:\n      > SELECT _FUNC_();\n       -0.3254147983080288\n      > SELECT _FUNC_(0);\n       1.1164209726833079\n      > SELECT _FUNC_(null);\n       1.1164209726833079\n  ", note="\n    The function is non-deterministic in general case.\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001\u0002\u0011\"\u0001:B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\"AQ\t\u0001BK\u0002\u0013\u0005a\t\u0003\u0005K\u0001\tE\t\u0015!\u0003H\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u0015Y\u0005\u0001\"\u0001Q\u0011\u0015Y\u0005\u0001\"\u0001R\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015Q\u0006\u0001\"\u0015\\\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015!\b\u0001\"\u0011Q\u0011\u0015)\b\u0001\"\u0011w\u0011\u00191\u0003\u0001\"\u0011\u0002\u000e!I\u0011q\u0004\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0005\u0005\n\u0003O\u0001\u0011\u0013!C\u0001\u0003SA\u0011\"a\u0010\u0001#\u0003%\t!!\u0011\t\u0013\u0005\u0015\u0003!!A\u0005B\u0005\u001d\u0003\"CA,\u0001\u0005\u0005I\u0011AA-\u0011%\t\t\u0007AA\u0001\n\u0003\t\u0019\u0007C\u0005\u0002j\u0001\t\t\u0011\"\u0011\u0002l!I\u0011q\u000f\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0010\u0005\n\u0003{\u0002\u0011\u0011!C!\u0003\u007f:q!a)\"\u0011\u0003\t)K\u0002\u0004!C!\u0005\u0011q\u0015\u0005\u0007\u0017b!\t!a,\t\u000f\u0005E\u0006\u0004\"\u0001\u00024\"I\u0011\u0011\u0017\r\u0002\u0002\u0013\u0005\u0015q\u0017\u0005\n\u0003{C\u0012\u0013!C\u0001\u0003\u0003B\u0011\"a0\u0019\u0003\u0003%\t)!1\t\u0013\u0005M\u0007$%A\u0005\u0002\u0005\u0005\u0003\"CAk1\u0005\u0005I\u0011BAl\u0005\u0015\u0011\u0016M\u001c3o\u0015\t\u00113%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0013&\u0003!\u0019\u0017\r^1msN$(B\u0001\u0014(\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Q%\nQa\u001d9be.T!AK\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0013aA8sO\u000e\u00011#\u0002\u00010gYb\u0004C\u0001\u00192\u001b\u0005\t\u0013B\u0001\u001a\"\u0005\r\u0011Fi\u0012\t\u0003aQJ!!N\u0011\u00031\u0015C\bO]3tg&|gnV5uQJ\u000bg\u000eZ8n'\u0016,G\r\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004HA\u0004Qe>$Wo\u0019;\u0011\u0005]j\u0014B\u0001 9\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015\u0019\u0007.\u001b7e+\u0005\t\u0005C\u0001\u0019C\u0013\t\u0019\u0015E\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013\u0001\u00035jI\u0016\u001cV-\u001a3\u0016\u0003\u001d\u0003\"a\u000e%\n\u0005%C$a\u0002\"p_2,\u0017M\\\u0001\nQ&$WmU3fI\u0002\na\u0001P5oSRtDcA'O\u001fB\u0011\u0001\u0007\u0001\u0005\u0006\u007f\u0015\u0001\r!\u0011\u0005\b\u000b\u0016\u0001\n\u00111\u0001H)\u0005iECA'S\u0011\u0015yt\u00011\u0001B\u0003-9\u0018\u000e\u001e5OK^\u001cV-\u001a3\u0015\u00055+\u0006\"\u0002,\t\u0001\u00049\u0016\u0001B:fK\u0012\u0004\"a\u000e-\n\u0005eC$\u0001\u0002'p]\u001e\fA\"\u001a<bY&sG/\u001a:oC2$\"\u0001X0\u0011\u0005]j\u0016B\u000109\u0005\u0019!u.\u001e2mK\")\u0001-\u0003a\u0001C\u0006)\u0011N\u001c9viB\u0011!mY\u0007\u0002G%\u0011Am\t\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR\u0019q-\u001c:\u0011\u0005!\\W\"A5\u000b\u0005)\f\u0013aB2pI\u0016<WM\\\u0005\u0003Y&\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006]*\u0001\ra\\\u0001\u0004GRD\bC\u00015q\u0013\t\t\u0018N\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000bMT\u0001\u0019A4\u0002\u0005\u00154\u0018!\u00034sKND7i\u001c9z\u000351G.\u0019;Be\u001e,X.\u001a8ugV\tq\u000fE\u0003y\u0003\u0003\t9A\u0004\u0002z}:\u0011!0`\u0007\u0002w*\u0011A0L\u0001\u0007yI|w\u000e\u001e \n\u0003eJ!a \u001d\u0002\u000fA\f7m[1hK&!\u00111AA\u0003\u0005!IE/\u001a:bi>\u0014(BA@9!\r9\u0014\u0011B\u0005\u0004\u0003\u0017A$aA!osV\u0011\u0011q\u0002\t\u0005\u0003#\tIB\u0004\u0003\u0002\u0014\u0005U\u0001C\u0001>9\u0013\r\t9\u0002O\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0011Q\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]\u0001(\u0001\u0003d_BLH#B'\u0002$\u0005\u0015\u0002bB \u000f!\u0003\u0005\r!\u0011\u0005\b\u000b:\u0001\n\u00111\u0001H\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u000b+\u0007\u0005\u000bic\u000b\u0002\u00020A!\u0011\u0011GA\u001e\u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012!C;oG\",7m[3e\u0015\r\tI\u0004O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001f\u0003g\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u0011+\u0007\u001d\u000bi#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0013\u0002B!a\u0013\u0002V5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\n\t&\u0001\u0003mC:<'BAA*\u0003\u0011Q\u0017M^1\n\t\u0005m\u0011QJ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u00037\u00022aNA/\u0013\r\ty\u0006\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u000f\t)\u0007C\u0005\u0002hM\t\t\u00111\u0001\u0002\\\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u001c\u0011\r\u0005=\u0014QOA\u0004\u001b\t\t\tHC\u0002\u0002ta\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019!!\u001d\u0002\u0011\r\fg.R9vC2$2aRA>\u0011%\t9'FA\u0001\u0002\u0004\t9!\u0001\u0004fcV\fGn\u001d\u000b\u0004\u000f\u0006\u0005\u0005\"CA4-\u0005\u0005\t\u0019AA\u0004QM\u0001\u0011QQAF\u0003\u001b\u000b\t*a%\u0002\u0018\u0006e\u0015QTAP!\r\u0001\u0014qQ\u0005\u0004\u0003\u0013\u000b#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u001f\u000b\u00111E0G+:\u001bu\fK.tK\u0016$W,\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007E]1oI>l\u0007E^1mk\u0016\u0004s/\u001b;iA%tG-\u001a9f]\u0012,g\u000e\u001e\u0011b]\u0012\u0004\u0013\u000eZ3oi&\u001c\u0017\r\u001c7zA\u0011L7\u000f\u001e:jEV$X\r\u001a\u0011)S:Jg\u0006\u001a\u0018*AY\fG.^3tA\u0011\u0014\u0018m\u001e8!MJ|W\u000e\t;iK\u0002\u001aH/\u00198eCJ$\u0007E\\8s[\u0006d\u0007\u0005Z5tiJL'-\u001e;j_:t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005U\u0015!!\u0019\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\f\u0019/gI*D'\r\u001b8sa\u001a\u0004\u0007\u000f\u00193qaR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AEr\u0013'\r\u001c5eAJtG\r\u001c9gM\u0002t'\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)]VdG.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c9\n\u0014G\u000e\u001b3ae:$G\u000e\u001d4gA:\u0014H\u0003\u0011!\u0003\u0011qw\u000e^3\"\u0005\u0005m\u0015A\u000f\u0006!A\u0001\u0002C\u000b[3!MVt7\r^5p]\u0002J7\u000f\t8p]6\"W\r^3s[&t\u0017n\u001d;jG\u0002Jg\u000eI4f]\u0016\u0014\u0018\r\u001c\u0011dCN,gF\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\t+A\u00032]Ur\u0003'A\u0003SC:$g\u000e\u0005\u000211M!\u0001$!+=!\r9\u00141V\u0005\u0004\u0003[C$AB!osJ+g\r\u0006\u0002\u0002&\u0006)\u0011\r\u001d9msR\u0019Q*!.\t\u000bYS\u0002\u0019A,\u0015\u000b5\u000bI,a/\t\u000b}Z\u0002\u0019A!\t\u000f\u0015[\u0002\u0013!a\u0001\u000f\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\r\u0017q\u001a\t\u0006o\u0005\u0015\u0017\u0011Z\u0005\u0004\u0003\u000fD$AB(qi&|g\u000eE\u00038\u0003\u0017\fu)C\u0002\u0002Nb\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAi;\u0005\u0005\t\u0019A'\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002ZB!\u00111JAn\u0013\u0011\ti.!\u0014\u0003\r=\u0013'.Z2u\u0001")
public class Randn
extends RDG
implements ExpressionWithRandomSeed,
Serializable {
    private final Expression child;
    private final boolean hideSeed;

    public static boolean $lessinit$greater$default$2() {
        return Randn$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Randn randn) {
        return Randn$.MODULE$.unapply(randn);
    }

    public static boolean apply$default$2() {
        return Randn$.MODULE$.apply$default$2();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean hideSeed() {
        return this.hideSeed;
    }

    @Override
    public Randn withNewSeed(long seed) {
        return new Randn(new Literal(BoxesRunTime.boxToLong((long)seed), LongType$.MODULE$), Randn$.MODULE$.apply$default$2());
    }

    public double evalInternal(InternalRow input) {
        return this.rng().nextGaussian();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(new StringBuilder(28).append(rngTerm).append(" = new ").append(className).append("(").append(this.seed()).append("L + partitionIndex);").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", ".nextGaussian();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), rngTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Randn freshCopy() {
        return new Randn(this.child(), this.hideSeed());
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public String sql() {
        return new StringBuilder(7).append("randn(").append((Object)(this.hideSeed() ? "" : this.child().sql())).append(")").toString();
    }

    public Randn copy(Expression child, boolean hideSeed) {
        return new Randn(child, hideSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.hideSeed();
    }

    @Override
    public String productPrefix() {
        return "Randn";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.hideSeed());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Randn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Randn)) return false;
        boolean bl = true;
        if (!bl) return false;
        Randn randn = (Randn)x$1;
        Expression expression = this.child();
        Expression expression2 = randn.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.hideSeed() != randn.hideSeed()) return false;
        if (!randn.canEqual(this)) return false;
        return true;
    }

    public Randn(Expression child, boolean hideSeed) {
        this.child = child;
        this.hideSeed = hideSeed;
    }

    public Randn() {
        this(new Literal(BoxesRunTime.boxToLong((long)Utils$.MODULE$.random().nextLong()), LongType$.MODULE$), true);
    }

    public Randn(Expression child) {
        this(child, false);
    }
}

