/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Flatten$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(arrayOfArrays) - Transforms an array of arrays into a single array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(array(1, 2), array(3, 4)));\n       [1,2,3,4]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u000f\u001f\u0001.B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u0005\")a\t\u0001C\u0001\u000f\")!\n\u0001C\u0005\u0017\")!\u000b\u0001C!'\"Aq\u000b\u0001EC\u0002\u0013\u0005\u0003\f\u0003\u0005a\u0001!\u0015\r\u0011\"\u0003Y\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0019y\b\u0001\"\u0003\u0002\u0002!9\u0011Q\u0005\u0001\u0005\n\u0005\u001d\u0002bBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\n\u0003k\u0001\u0011\u0011!C\u0001\u0003oA\u0011\"a\u000f\u0001#\u0003%\t!!\u0010\t\u0013\u0005M\u0003!!A\u0005B\u0005U\u0003\"CA3\u0001\u0005\u0005I\u0011AA4\u0011%\ty\u0007AA\u0001\n\u0003\t\t\bC\u0005\u0002x\u0001\t\t\u0011\"\u0011\u0002z!I\u0011q\u0011\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0012\u0005\n\u0003\u001b\u0003\u0011\u0011!C!\u0003\u001f;\u0011\"a-\u001f\u0003\u0003E\t!!.\u0007\u0011uq\u0012\u0011!E\u0001\u0003oCaAR\f\u0005\u0002\u0005\u0015\u0007\"CAd/\u0005\u0005IQIAe\u0011%\tYmFA\u0001\n\u0003\u000bi\rC\u0005\u0002R^\t\t\u0011\"!\u0002T\"I\u0011q\\\f\u0002\u0002\u0013%\u0011\u0011\u001d\u0002\b\r2\fG\u000f^3o\u0015\ty\u0002%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0011#\u0003!\u0019\u0017\r^1msN$(BA\u0012%\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003K\u0019\nQa\u001d9be.T!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sO\u000e\u00011#\u0002\u0001-a]j\u0004CA\u0017/\u001b\u0005q\u0012BA\u0018\u001f\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u00195\u001d\ti#'\u0003\u00024=\u00059\u0001/Y2lC\u001e,\u0017BA\u001b7\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!a\r\u0010\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001HP\u0005\u0003\u007fe\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fQa\u00195jY\u0012,\u0012A\u0011\t\u0003[\rK!\u0001\u0012\u0010\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005!K\u0005CA\u0017\u0001\u0011\u0015\u00015\u00011\u0001C\u00035\u0019\u0007.\u001b7e\t\u0006$\u0018\rV=qKV\tA\n\u0005\u0002N!6\taJ\u0003\u0002PE\u0005)A/\u001f9fg&\u0011\u0011K\u0014\u0002\n\u0003J\u0014\u0018-\u001f+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u0002)B\u0011\u0001(V\u0005\u0003-f\u0012qAQ8pY\u0016\fg.\u0001\u0005eCR\fG+\u001f9f+\u0005I\u0006CA'[\u0013\tYfJ\u0001\u0005ECR\fG+\u001f9fQ\t1Q\f\u0005\u00029=&\u0011q,\u000f\u0002\niJ\fgn]5f]R\f1\"\u001a7f[\u0016tG\u000fV=qK\"\u0012q!X\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0002IB\u0011Q\r[\u0007\u0002M*\u0011q\rI\u0001\tC:\fG._:jg&\u0011\u0011N\u001a\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0011An\u001c\t\u0003q5L!A\\\u001d\u0003\u0007\u0005s\u0017\u0010C\u0003A\u0013\u0001\u0007A.A\u0005e_\u001e+gnQ8eKR\u0019!\u000f_?\u0011\u0005M4X\"\u0001;\u000b\u0005Ut\u0012aB2pI\u0016<WM\\\u0005\u0003oR\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006s*\u0001\rA_\u0001\u0004GRD\bCA:|\u0013\taHO\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000byT\u0001\u0019\u0001:\u0002\u0005\u00154\u0018AG4f]\u000e{G-\u001a$pe:+XNY3s\u001f\u001a,E.Z7f]R\u001cHCBA\u0002\u0003?\t\t\u0003E\u00049\u0003\u000b\tI!!\u0003\n\u0007\u0005\u001d\u0011H\u0001\u0004UkBdWM\r\t\u0005\u0003\u0017\tIB\u0004\u0003\u0002\u000e\u0005U\u0001cAA\bs5\u0011\u0011\u0011\u0003\u0006\u0004\u0003'Q\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u0018e\na\u0001\u0015:fI\u00164\u0017\u0002BA\u000e\u0003;\u0011aa\u0015;sS:<'bAA\fs!)\u0011p\u0003a\u0001u\"9\u00111E\u0006A\u0002\u0005%\u0011!E2iS2$g+\u0019:jC\ndWMT1nK\u0006\tr-\u001a8D_\u0012,gi\u001c:GY\u0006$H/\u001a8\u0015\u0011\u0005%\u0011\u0011FA\u0016\u0003[AQ!\u001f\u0007A\u0002iDq!a\t\r\u0001\u0004\tI\u0001C\u0004\u000201\u0001\r!!\u0003\u0002\u001b\u0005\u0014(/Y=ECR\fg*Y7f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003\u0013\tAaY8qsR\u0019\u0001*!\u000f\t\u000f\u0001s\u0001\u0013!a\u0001\u0005\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA U\r\u0011\u0015\u0011I\u0016\u0003\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%A\u0005v]\u000eDWmY6fI*\u0019\u0011QJ\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002R\u0005\u001d#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0016\u0011\t\u0005e\u00131M\u0007\u0003\u00037RA!!\u0018\u0002`\u0005!A.\u00198h\u0015\t\t\t'\u0001\u0003kCZ\f\u0017\u0002BA\u000e\u00037\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u001b\u0011\u0007a\nY'C\u0002\u0002ne\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001\\A:\u0011%\t)HEA\u0001\u0002\u0004\tI'A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003w\u0002R!! \u0002\u00042l!!a \u000b\u0007\u0005\u0005\u0015(\u0001\u0006d_2dWm\u0019;j_:LA!!\"\u0002\u0000\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r!\u00161\u0012\u0005\t\u0003k\"\u0012\u0011!a\u0001Y\u00061Q-];bYN$2\u0001VAI\u0011!\t)(FA\u0001\u0002\u0004a\u0007f\u0005\u0001\u0002\u0016\u0006m\u0015QTAQ\u0003G\u000b9+!+\u0002.\u0006=\u0006cA\u0017\u0002\u0018&\u0019\u0011\u0011\u0014\u0010\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qT\u0001K?\u001a+fjQ0)CJ\u0014\u0018-_(g\u0003J\u0014\u0018-_:*A5\u0002CK]1og\u001a|'/\\:!C:\u0004\u0013M\u001d:bs\u0002zg\rI1se\u0006L8\u000fI5oi>\u0004\u0013\rI:j]\u001edW\rI1se\u0006Lh&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t)+\u0001.\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012\u0014\u0006\f\u0011beJ\f\u0017\u0010K\u001a-AQJ\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7Fb#\u0007L\u001a-iuS\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003W\u000b1\"\u0019:sCf|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011\u0011W\u0001\u0006e9\"d\u0006M\u0001\b\r2\fG\u000f^3o!\tisc\u0005\u0003\u0018\u0003sk\u0004CBA^\u0003\u0003\u0014\u0005*\u0004\u0002\u0002>*\u0019\u0011qX\u001d\u0002\u000fI,h\u000e^5nK&!\u00111YA_\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0003k\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003/\nQ!\u00199qYf$2\u0001SAh\u0011\u0015\u0001%\u00041\u0001C\u0003\u001d)h.\u00199qYf$B!!6\u0002\\B!\u0001(a6C\u0013\r\tI.\u000f\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005u7$!AA\u0002!\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\r\b\u0003BA-\u0003KLA!a:\u0002\\\t1qJ\u00196fGR\u0004")
public class Flatten
extends UnaryExpression
implements package.NullIntolerant,
scala.Serializable {
    private transient DataType dataType;
    private transient DataType elementType;
    private final Expression child;
    private volatile transient byte bitmap$trans$0;

    public static Option<Expression> unapply(Flatten flatten) {
        return Flatten$.MODULE$.unapply(flatten);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Flatten, A> function1) {
        return Flatten$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Flatten> compose(Function1<A, Expression> function1) {
        return Flatten$.MODULE$.compose(function1);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    private ArrayType childDataType() {
        return (ArrayType)this.child().dataType();
    }

    @Override
    public boolean nullable() {
        return this.child().nullable() || this.childDataType().containsNull();
    }

    private DataType dataType$lzycompute() {
        Flatten flatten = this;
        synchronized (flatten) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.dataType = this.childDataType().elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    private DataType elementType$lzycompute() {
        Flatten flatten = this;
        synchronized (flatten) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.elementType = ((ArrayType)this.dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.elementType;
    }

    private DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        ArrayType arrayType;
        DataType dataType = this.child().dataType();
        TypeCheckResult typeCheckResult = dataType instanceof ArrayType && (arrayType = (ArrayType)dataType).elementType() instanceof ArrayType ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(62).append("The argument should be an array of arrays, ").append("but '").append(this.child().sql()).append("' is of ").append(this.child().dataType().catalogString()).append(" type.").toString());
        return typeCheckResult;
    }

    @Override
    public Object nullSafeEval(Object child) {
        GenericArrayData genericArrayData;
        Object[] elements = ((ArrayData)child).toObjectArray(this.dataType());
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(elements)).contains(null)) {
            genericArrayData = null;
        } else {
            ArrayData[] arrayData = (ArrayData[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(elements)).map((Function1 & Serializable & scala.Serializable)x$61 -> (ArrayData)x$61, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ArrayData.class)));
            long numberOfElements = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arrayData)).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(sum, e) -> BoxesRunTime.boxToLong((long)Flatten.$anonfun$nullSafeEval$6(BoxesRunTime.unboxToLong((Object)sum), e))));
            if (numberOfElements > (long)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH) {
                throw new RuntimeException(new StringBuilder(101).append("Unsuccessful try to flatten an array of arrays with ").append(numberOfElements).append(" elements due to exceeding the array size limit ").append(ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH).append(".").toString());
            }
            Object[] flattenedData = (Object[])ClassTag$.MODULE$.Nothing().newArray((int)numberOfElements);
            IntRef position = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arrayData)).foreach((Function1 & Serializable & scala.Serializable)ad -> {
                Flatten.$anonfun$nullSafeEval$7(this, flattenedData, position, ad);
                return BoxedUnit.UNIT;
            });
            genericArrayData = new GenericArrayData((Object)flattenedData);
        }
        return genericArrayData;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> {
            String code = this.genCodeForFlatten(ctx, (String)c, ExprValue$.MODULE$.exprValueToString(ev.value()));
            return ctx.nullArrayElementsSaveExec(this.childDataType().containsNull(), ExprValue$.MODULE$.exprValueToString(ev.isNull()), (String)c, code);
        });
    }

    private Tuple2<String, String> genCodeForNumberOfElements(CodegenContext ctx, String childVariableName) {
        String variableName = ctx.freshName("numElements");
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(125).append("\n      |long ").append(variableName).append(" = 0;\n      |for (int z = 0; z < ").append(childVariableName).append(".numElements(); z++) {\n      |  ").append(variableName).append(" += ").append(childVariableName).append(".getArray(z).numElements();\n      |}\n      ").toString())).stripMargin();
        return new Tuple2((Object)code, (Object)variableName);
    }

    private String genCodeForFlatten(CodegenContext ctx, String childVariableName, String arrayDataName) {
        String counter = ctx.freshName("counter");
        String tempArrayDataName = ctx.freshName("tempArrayData");
        String k = ctx.freshName("k");
        String l = ctx.freshName("l");
        String arr = ctx.freshName("arr");
        Tuple2<String, String> tuple2 = this.genCodeForNumberOfElements(ctx, childVariableName);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String numElemCode = (String)tuple2._1();
        String numElemName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)numElemCode, (Object)numElemName);
        Tuple2 tuple23 = tuple22;
        String numElemCode2 = (String)tuple23._1();
        String numElemName2 = (String)tuple23._2();
        String allocation = CodeGenerator$.MODULE$.createArrayData(tempArrayDataName, this.elementType(), numElemName2, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(tempArrayDataName, this.elementType(), arr, counter, l, ((ArrayType)this.dataType()).containsNull());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(203).append("\n    |").append(numElemCode2).append("\n    |").append(allocation).append("\n    |int ").append(counter).append(" = 0;\n    |for (int ").append(k).append(" = 0; ").append(k).append(" < ").append(childVariableName).append(".numElements(); ").append(k).append("++) {\n    |  ArrayData ").append(arr).append(" = ").append(childVariableName).append(".getArray(").append(k).append(");\n    |  for (int ").append(l).append(" = 0; ").append(l).append(" < ").append(arr).append(".numElements(); ").append(l).append("++) {\n    |   ").append(assignment).append("\n    |   ").append(counter).append("++;\n    | }\n    |}\n    |").append(arrayDataName).append(" = ").append(tempArrayDataName).append(";\n    ").toString())).stripMargin();
    }

    @Override
    public String prettyName() {
        return "flatten";
    }

    public Flatten copy(Expression child) {
        return new Flatten(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Flatten";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Flatten;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Flatten)) return false;
        boolean bl = true;
        if (!bl) return false;
        Flatten flatten = (Flatten)x$1;
        Expression expression = this.child();
        Expression expression2 = flatten.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!flatten.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$nullSafeEval$6(long sum, ArrayData e) {
        return sum + (long)e.numElements();
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$7(Flatten $this, Object[] flattenedData$1, IntRef position$2, ArrayData ad) {
        Object[] arr = ad.toObjectArray($this.elementType());
        Array$.MODULE$.copy((Object)arr, 0, (Object)flattenedData$1, position$2.elem, arr.length);
        position$2.elem += arr.length;
    }

    public Flatten(Expression child) {
        this.child = child;
    }
}

