/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MonthsBetween$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(timestamp1, timestamp2[, roundOff]) - If `timestamp1` is later than `timestamp2`, then the result\n      is positive. If `timestamp1` and `timestamp2` are on the same day of month, or both\n      are the last day of month, time of day will be ignored. Otherwise, the difference is\n      calculated based on 31 days per month, and rounded to 8 digits unless roundOff=false.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('1997-02-28 10:30:00', '1996-10-30');\n       3.94959677\n      > SELECT _FUNC_('1997-02-28 10:30:00', '1996-10-30', false);\n       3.9495967741935485\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\tUb\u0001B\u0014)\u0001VB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t+\u0002\u0011\t\u0012)A\u0005%\"Aa\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005X\u0001\tE\t\u0015!\u0003S\u0011!A\u0006A!f\u0001\n\u0003\t\u0006\u0002C-\u0001\u0005#\u0005\u000b\u0011\u0002*\t\u0011i\u0003!Q3A\u0005\u0002mC\u0001B\u001b\u0001\u0003\u0012\u0003\u0006I\u0001\u0018\u0005\u0006W\u0002!\t\u0001\u001c\u0005\u0006W\u0002!\tA\u001d\u0005\u0006W\u0002!\t!\u001e\u0005\u0006s\u0002!\tE\u001f\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0011\u001d\tI\u0002\u0001C!\u00037Aq!a\t\u0001\t\u0003\n)\u0003C\u0004\u0002*\u0001!\t%a\u000b\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@!9\u00111\f\u0001\u0005B\u0005u\u0003\"CA0\u0001\u0005\u0005I\u0011AA1\u0011%\tY\u0007AI\u0001\n\u0003\ti\u0007C\u0005\u0002\u0004\u0002\t\n\u0011\"\u0001\u0002n!I\u0011Q\u0011\u0001\u0012\u0002\u0013\u0005\u0011Q\u000e\u0005\n\u0003\u000f\u0003\u0011\u0013!C\u0001\u0003\u0013C\u0011\"!$\u0001\u0003\u0003%\t%a$\t\u0013\u0005}\u0005!!A\u0005\u0002\u0005\u0005\u0006\"CAU\u0001\u0005\u0005I\u0011AAV\u0011%\t\t\fAA\u0001\n\u0003\n\u0019\fC\u0005\u0002B\u0002\t\t\u0011\"\u0001\u0002D\"I\u0011Q\u001a\u0001\u0002\u0002\u0013\u0005\u0013qZ\u0004\n\u0003gD\u0013\u0011!E\u0001\u0003k4\u0001b\n\u0015\u0002\u0002#\u0005\u0011q\u001f\u0005\u0007W~!\tA!\u0002\t\u0013\t\u001dq$!A\u0005F\t%\u0001\"\u0003B\u0006?\u0005\u0005I\u0011\u0011B\u0007\u0011%\u00119bHI\u0001\n\u0003\tI\tC\u0005\u0003\u001a}\t\t\u0011\"!\u0003\u001c!I!\u0011F\u0010\u0012\u0002\u0013\u0005\u0011\u0011\u0012\u0005\n\u0005Wy\u0012\u0011!C\u0005\u0005[\u0011Q\"T8oi\"\u001c()\u001a;xK\u0016t'BA\u0015+\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005-b\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u00055r\u0013aA:rY*\u0011q\u0006M\u0001\u0006gB\f'o\u001b\u0006\u0003cI\na!\u00199bG\",'\"A\u001a\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u00011$(\u0010!H\u001bB\u0011q\u0007O\u0007\u0002Q%\u0011\u0011\b\u000b\u0002\u0012)\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u001c<\u0013\ta\u0004FA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011qGP\u0005\u0003\u007f!\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003\u0003\u0012s!a\u000e\"\n\u0005\rC\u0013a\u00029bG.\fw-Z\u0005\u0003\u000b\u001a\u0013aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002DQA\u0011\u0001jS\u0007\u0002\u0013*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u0013\n9\u0001K]8ek\u000e$\bC\u0001%O\u0013\ty\u0015J\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003eCR,\u0017'F\u0001S!\t94+\u0003\u0002UQ\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\u0011\fG/Z\u0019!\u0003\u0015!\u0017\r^33\u0003\u0019!\u0017\r^33A\u0005A!o\\;oI>3g-A\u0005s_VtGm\u00144gA\u0005QA/[7f5>tW-\u00133\u0016\u0003q\u00032\u0001S/`\u0013\tq\u0016J\u0001\u0004PaRLwN\u001c\t\u0003A\u001et!!Y3\u0011\u0005\tLU\"A2\u000b\u0005\u0011$\u0014A\u0002\u001fs_>$h(\u0003\u0002g\u0013\u00061\u0001K]3eK\u001aL!\u0001[5\u0003\rM#(/\u001b8h\u0015\t1\u0017*A\u0006uS6,'l\u001c8f\u0013\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u0003n]>\u0004\u0018\u000f\u0005\u00028\u0001!)\u0001+\u0003a\u0001%\")a+\u0003a\u0001%\")\u0001,\u0003a\u0001%\"9!,\u0003I\u0001\u0002\u0004aFcA7ti\")\u0001K\u0003a\u0001%\")aK\u0003a\u0001%R!QN^<y\u0011\u0015\u00016\u00021\u0001S\u0011\u001516\u00021\u0001S\u0011\u0015A6\u00021\u0001S\u0003!\u0019\u0007.\u001b7ee\u0016tW#A>\u0011\tq\f\tA\u0015\b\u0003{~t!A\u0019@\n\u0003)K!aQ%\n\t\u0005\r\u0011Q\u0001\u0002\u0004'\u0016\f(BA\"J\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003\u0017\u0001R\u0001`A\u0001\u0003\u001b\u0001B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'a\u0013!\u0002;za\u0016\u001c\u0018\u0002BA\f\u0003#\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!!\b\u0011\t\u0005=\u0011qD\u0005\u0005\u0003C\t\tB\u0001\u0005ECR\fG+\u001f9f\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\rQ\u0014q\u0005\u0005\u00065>\u0001\raX\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\t\u0003[\t\u0019$a\u000e\u0002<A\u0019\u0001*a\f\n\u0007\u0005E\u0012JA\u0002B]fDq!!\u000e\u0011\u0001\u0004\ti#\u0001\u0002uc!9\u0011\u0011\b\tA\u0002\u00055\u0012A\u0001;3\u0011\u0019A\u0006\u00031\u0001\u0002.\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003\u0003\ni%a\u0016\u0011\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bR1!a\u0012)\u0003\u001d\u0019w\u000eZ3hK:LA!a\u0013\u0002F\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002PE\u0001\r!!\u0015\u0002\u0007\r$\b\u0010\u0005\u0003\u0002D\u0005M\u0013\u0002BA+\u0003\u000b\u0012abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002ZE\u0001\r!!\u0011\u0002\u0005\u00154\u0018A\u00039sKR$\u0018PT1nKV\tq,\u0001\u0003d_BLH#C7\u0002d\u0005\u0015\u0014qMA5\u0011\u001d\u00016\u0003%AA\u0002ICqAV\n\u0011\u0002\u0003\u0007!\u000bC\u0004Y'A\u0005\t\u0019\u0001*\t\u000fi\u001b\u0002\u0013!a\u00019\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA8U\r\u0011\u0016\u0011O\u0016\u0003\u0003g\u0002B!!\u001e\u0002\u00005\u0011\u0011q\u000f\u0006\u0005\u0003s\nY(A\u0005v]\u000eDWmY6fI*\u0019\u0011QP%\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0002\u0006]$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\tYIK\u0002]\u0003c\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAI!\u0011\t\u0019*!(\u000e\u0005\u0005U%\u0002BAL\u00033\u000bA\u0001\\1oO*\u0011\u00111T\u0001\u0005U\u00064\u0018-C\u0002i\u0003+\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a)\u0011\u0007!\u000b)+C\u0002\u0002(&\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\f\u0002.\"I\u0011q\u0016\u000e\u0002\u0002\u0003\u0007\u00111U\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005U\u0006CBA\\\u0003{\u000bi#\u0004\u0002\u0002:*\u0019\u00111X%\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002@\u0006e&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!2\u0002LB\u0019\u0001*a2\n\u0007\u0005%\u0017JA\u0004C_>dW-\u00198\t\u0013\u0005=F$!AA\u0002\u00055\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002F\u0006E\u0007\"CAX;\u0005\u0005\t\u0019AA\u0017QM\u0001\u0011Q[An\u0003;\f\t/a9\u0002h\u0006%\u0018Q^Ax!\r9\u0014q[\u0005\u0004\u00033D#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003?\f11\u0001\u0006!A\u0001\u0002sLR+O\u0007~CC/[7fgR\fW\u000e]\u0019-AQLW.Z:uC6\u0004(g\u0017\u0017!e>,h\u000eZ(gMvK\u0003%\f\u0011JM\u0002\u0002G/[7fgR\fW\u000e]\u0019aA%\u001c\b\u0005\\1uKJ\u0004C\u000f[1oA\u0001$\u0018.\\3ti\u0006l\u0007O\r1-AQDWM\u001c\u0011uQ\u0016\u0004#/Z:vYRT\u0001\u0005\t\u0011!A\u0001J7\u000f\t9pg&$\u0018N^3/A%3\u0007\u0005\u0019;j[\u0016\u001cH/Y7qc\u0001\u0004\u0013M\u001c3!ARLW.Z:uC6\u0004(\u0007\u0019\u0011be\u0016\u0004sN\u001c\u0011uQ\u0016\u00043/Y7fA\u0011\f\u0017\u0010I8gA5|g\u000e\u001e5-A=\u0014\bEY8uQ*\u0001\u0003\u0005\t\u0011!A\u0005\u0014X\r\t;iK\u0002b\u0017m\u001d;!I\u0006L\be\u001c4![>tG\u000f\u001b\u0017!i&lW\rI8gA\u0011\f\u0017\u0010I<jY2\u0004#-\u001a\u0011jO:|'/\u001a3/A=#\b.\u001a:xSN,G\u0006\t;iK\u0002\"\u0017N\u001a4fe\u0016t7-\u001a\u0011jg*\u0001\u0003\u0005\t\u0011!A\r\fGnY;mCR,G\r\t2bg\u0016$\u0007e\u001c8!gE\u0002C-Y=tAA,'\u000fI7p]RDG\u0006I1oI\u0002\u0012x.\u001e8eK\u0012\u0004Co\u001c\u00119A\u0011Lw-\u001b;tAUtG.Z:tAI|WO\u001c3PM\u001ald-\u00197tK:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011Q]\u0001\u0002z)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%M\u001d:o5\u0002$'\f\u001a9AE\u0002$h\r\u0019;aA:C\u0006I\u00142se2T&\r\u0019.gA:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00114]e\"\u0014(N\u001d7o]R\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ\u0019:s]j\u0003GM\u00173q\u0001\n\u0004GO\u001a1uA\u0002t\u0005\f\u0011(ceJd'L\u00191[M\u0002t\u0005\f\u0011gC2\u001cX-K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!g9JD'O\u001b:m]:D'M\u001d4kQBTG\u0003\u0011!\u0003\u00159'o\\;qC\t\tY/\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005E\u0018!B\u0019/k9\u0002\u0014!D'p]RD7OQ3uo\u0016,g\u000e\u0005\u00028?M!q$!?N!%\tYP!\u0001S%JcV.\u0004\u0002\u0002~*\u0019\u0011q`%\u0002\u000fI,h\u000e^5nK&!!1AA\u007f\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\u000b\u0003\u0003k\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003#\u000bQ!\u00199qYf$\u0012\"\u001cB\b\u0005#\u0011\u0019B!\u0006\t\u000bA\u0013\u0003\u0019\u0001*\t\u000bY\u0013\u0003\u0019\u0001*\t\u000ba\u0013\u0003\u0019\u0001*\t\u000fi\u0013\u0003\u0013!a\u00019\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tu!Q\u0005\t\u0005\u0011v\u0013y\u0002E\u0004I\u0005C\u0011&K\u0015/\n\u0007\t\r\u0012J\u0001\u0004UkBdW\r\u000e\u0005\t\u0005O!\u0013\u0011!a\u0001[\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t=\u0002\u0003BAJ\u0005cIAAa\r\u0002\u0016\n1qJ\u00196fGR\u0004")
public class MonthsBetween
extends TernaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression date1;
    private final Expression date2;
    private final Expression roundOff;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient ZoneId zoneId;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$4() {
        return MonthsBetween$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Expression, Expression, Option<String>>> unapply(MonthsBetween monthsBetween) {
        return MonthsBetween$.MODULE$.unapply(monthsBetween);
    }

    public static Option<String> apply$default$4() {
        return MonthsBetween$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Option<String>>, MonthsBetween> tupled() {
        return MonthsBetween$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Option<String>, MonthsBetween>>>> curried() {
        return MonthsBetween$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        MonthsBetween monthsBetween = this;
        synchronized (monthsBetween) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        MonthsBetween monthsBetween = this;
        synchronized (monthsBetween) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    public Expression date1() {
        return this.date1;
    }

    public Expression date2() {
        return this.date2;
    }

    public Expression roundOff() {
        return this.roundOff;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.date1(), this.date2(), this.roundOff()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, TimestampType$.MODULE$, BooleanType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object t1, Object t2, Object roundOff) {
        return BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(BoxesRunTime.unboxToLong((Object)t1), BoxesRunTime.unboxToLong((Object)t2), BoxesRunTime.unboxToBoolean((Object)roundOff), this.zoneId()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(d1, d2, roundOff) -> new StringBuilder(22).append(dtu).append(".monthsBetween(").append((String)d1).append(", ").append((String)d2).append(", ").append((String)roundOff).append(", ").append(zid).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "months_between";
    }

    public MonthsBetween copy(Expression date1, Expression date2, Expression roundOff, Option<String> timeZoneId) {
        return new MonthsBetween(date1, date2, roundOff, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.date1();
    }

    public Expression copy$default$2() {
        return this.date2();
    }

    public Expression copy$default$3() {
        return this.roundOff();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "MonthsBetween";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.date1();
                break;
            }
            case 1: {
                option = this.date2();
                break;
            }
            case 2: {
                option = this.roundOff();
                break;
            }
            case 3: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MonthsBetween;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MonthsBetween)) return false;
        boolean bl = true;
        if (!bl) return false;
        MonthsBetween monthsBetween = (MonthsBetween)x$1;
        Expression expression = this.date1();
        Expression expression2 = monthsBetween.date1();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.date2();
        Expression expression4 = monthsBetween.date2();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.roundOff();
        Expression expression6 = monthsBetween.roundOff();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = monthsBetween.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!monthsBetween.canEqual(this)) return false;
        return true;
    }

    public MonthsBetween(Expression date1, Expression date2, Expression roundOff, Option<String> timeZoneId) {
        this.date1 = date1;
        this.date2 = date2;
        this.roundOff = roundOff;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public MonthsBetween(Expression date1, Expression date2) {
        this(date1, date2, Literal$.MODULE$.TrueLiteral(), (Option<String>)None$.MODULE$);
    }

    public MonthsBetween(Expression date1, Expression date2, Expression roundOff) {
        this(date1, date2, roundOff, (Option<String>)None$.MODULE$);
    }
}

