/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnixTime;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([timeExp[, fmt]]) - Returns the UNIX timestamp of current or specified time.", arguments="\n    Arguments:\n      * timeExp - A date/timestamp or string. If not provided, this defaults to current time.\n      * fmt - Date/time format pattern to follow. Ignored if `timeExp` is not a string.\n              Default value is \"yyyy-MM-dd HH:mm:ss\". See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\"> Datetime Patterns</a>\n              for valid date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_();\n       1476884637\n      > SELECT _FUNC_('2016-04-08', 'yyyy-MM-dd');\n       1460041200\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0014)\u0001VB\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005\u000b\"A\u0011\n\u0001BK\u0002\u0013\u0005A\t\u0003\u0005K\u0001\tE\t\u0015!\u0003F\u0011!Y\u0005A!f\u0001\n\u0003a\u0005\u0002C.\u0001\u0005#\u0005\u000b\u0011B'\t\u0011q\u0003!Q3A\u0005\u0002uC\u0001\"\u0019\u0001\u0003\u0012\u0003\u0006IA\u0018\u0005\u0006E\u0002!\ta\u0019\u0005\u0006E\u0002!\t!\u001b\u0005\u0006Y\u0002!\t\u0005\u0012\u0005\u0006[\u0002!\t\u0005\u0012\u0005\u0006]\u0002!\te\u001c\u0005\u0006E\u0002!\t\u0001\u001e\u0005\u0006E\u0002!\ta\u001e\u0005\u0006q\u0002!\t%\u001f\u0005\bu\u0002\t\t\u0011\"\u0001|\u0011%\t\t\u0001AI\u0001\n\u0003\t\u0019\u0001C\u0005\u0002\u001a\u0001\t\n\u0011\"\u0001\u0002\u0004!I\u00111\u0004\u0001\u0012\u0002\u0013\u0005\u0011Q\u0004\u0005\n\u0003C\u0001\u0011\u0013!C\u0001\u0003GA\u0011\"a\n\u0001\u0003\u0003%\t%!\u000b\t\u0013\u0005e\u0002!!A\u0005\u0002\u0005m\u0002\"CA\"\u0001\u0005\u0005I\u0011AA#\u0011%\t\t\u0006AA\u0001\n\u0003\n\u0019\u0006C\u0005\u0002b\u0001\t\t\u0011\"\u0001\u0002d!I\u0011q\r\u0001\u0002\u0002\u0013\u0005\u0013\u0011N\u0004\n\u0003'C\u0013\u0011!E\u0001\u0003+3\u0001b\n\u0015\u0002\u0002#\u0005\u0011q\u0013\u0005\u0007Ev!\t!!*\t\u0013\u0005\u001dV$!A\u0005F\u0005%\u0006\"CAV;\u0005\u0005I\u0011QAW\u0011%\t9,HI\u0001\n\u0003\ti\u0002C\u0005\u0002:v\t\n\u0011\"\u0001\u0002$!I\u00111X\u000f\u0002\u0002\u0013\u0005\u0015Q\u0018\u0005\n\u0003\u0017l\u0012\u0013!C\u0001\u0003;A\u0011\"!4\u001e#\u0003%\t!a\t\t\u0013\u0005=W$!A\u0005\n\u0005E'!D+oSb$\u0016.\\3ti\u0006l\u0007O\u0003\u0002*U\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tYC&\u0001\u0005dCR\fG._:u\u0015\tic&A\u0002tc2T!a\f\u0019\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0012\u0014AB1qC\u000eDWMC\u00014\u0003\ry'oZ\u0002\u0001'\u0011\u0001aG\u000f!\u0011\u0005]BT\"\u0001\u0015\n\u0005eB#\u0001C+oSb$\u0016.\\3\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\u000fA\u0013x\u000eZ;diB\u00111(Q\u0005\u0003\u0005r\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fq\u0001^5nK\u0016C\b/F\u0001F!\t9d)\u0003\u0002HQ\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u0011QLW.Z#ya\u0002\naAZ8s[\u0006$\u0018a\u00024pe6\fG\u000fI\u0001\u000bi&lWMW8oK&#W#A'\u0011\u0007mr\u0005+\u0003\u0002Py\t1q\n\u001d;j_:\u0004\"!\u0015-\u000f\u0005I3\u0006CA*=\u001b\u0005!&BA+5\u0003\u0019a$o\\8u}%\u0011q\u000bP\u0001\u0007!J,G-\u001a4\n\u0005eS&AB*ue&twM\u0003\u0002Xy\u0005YA/[7f5>tW-\u00133!\u0003-1\u0017-\u001b7P]\u0016\u0013(o\u001c:\u0016\u0003y\u0003\"aO0\n\u0005\u0001d$a\u0002\"p_2,\u0017M\\\u0001\rM\u0006LGn\u00148FeJ|'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0011,gm\u001a5\u0011\u0005]\u0002\u0001\"B\"\n\u0001\u0004)\u0005\"B%\n\u0001\u0004)\u0005bB&\n!\u0003\u0005\r!\u0014\u0005\b9&\u0001\n\u00111\u0001_)\r!'n\u001b\u0005\u0006\u0007*\u0001\r!\u0012\u0005\u0006\u0013*\u0001\r!R\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/\u0001\u0007xSRDG+[7f5>tW\r\u0006\u0002qgB\u0011q']\u0005\u0003e\"\u0012q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\t\u000b-k\u0001\u0019\u0001)\u0015\u0005\u0011,\b\"\u0002<\u000f\u0001\u0004)\u0015\u0001\u0002;j[\u0016$\u0012\u0001Z\u0001\u000baJ,G\u000f^=OC6,W#\u0001)\u0002\t\r|\u0007/\u001f\u000b\u0006Irlhp \u0005\b\u0007F\u0001\n\u00111\u0001F\u0011\u001dI\u0015\u0003%AA\u0002\u0015CqaS\t\u0011\u0002\u0003\u0007Q\nC\u0004]#A\u0005\t\u0019\u00010\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0001\u0016\u0004\u000b\u0006\u001d1FAA\u0005!\u0011\tY!!\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005MA(\u0001\u0006b]:|G/\u0019;j_:LA!a\u0006\u0002\u000e\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA\u0010U\ri\u0015qA\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\t)CK\u0002_\u0003\u000f\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0016!\u0011\ti#a\u000e\u000e\u0005\u0005=\"\u0002BA\u0019\u0003g\tA\u0001\\1oO*\u0011\u0011QG\u0001\u0005U\u00064\u0018-C\u0002Z\u0003_\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0010\u0011\u0007m\ny$C\u0002\u0002Bq\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0012\u0002NA\u00191(!\u0013\n\u0007\u0005-CHA\u0002B]fD\u0011\"a\u0014\u0019\u0003\u0003\u0005\r!!\u0010\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u0006\u0005\u0004\u0002X\u0005u\u0013qI\u0007\u0003\u00033R1!a\u0017=\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003?\nIF\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00010\u0002f!I\u0011q\n\u000e\u0002\u0002\u0003\u0007\u0011qI\u0001\u0007KF,\u0018\r\\:\u0015\u0007y\u000bY\u0007C\u0005\u0002Pm\t\t\u00111\u0001\u0002H!:\u0002!a\u001c\u0002v\u0005]\u00141PA?\u0003\u0003\u000b\u0019)a\"\u0002\n\u00065\u0015q\u0012\t\u0004o\u0005E\u0014bAA:Q\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA=\u0003M{f)\u0016(D?\"ZF/[7f\u000bb\u00048\f\f\u0011g[RlV,\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011V\u001d&C\u0006\u0005^5nKN$\u0018-\u001c9!_\u001a\u00043-\u001e:sK:$\be\u001c:!gB,7-\u001b4jK\u0012\u0004C/[7f]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003\u007f\n11\b\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AQLW.Z#ya\u0002j\u0003%\u0011\u0011eCR,w\u0006^5nKN$\u0018-\u001c9!_J\u00043\u000f\u001e:j]\u001et\u0003%\u00134!]>$\b\u0005\u001d:pm&$W\r\u001a\u0017!i\"L7\u000f\t3fM\u0006,H\u000e^:!i>\u00043-\u001e:sK:$\b\u0005^5nK:R\u0001\u0005\t\u0011!A\u0001R\u0003EZ7uA5\u0002C)\u0019;f_QLW.\u001a\u0011g_Jl\u0017\r\u001e\u0011qCR$XM\u001d8!i>\u0004cm\u001c7m_^t\u0003%S4o_J,G\rI5gA\u0001$\u0018.\\3FqB\u0004\u0007%[:!]>$\b%\u0019\u0011tiJLgn\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\t\u00164\u0017-\u001e7uAY\fG.^3!SN\u0004#%_=zs6jU*\f3eA!C%(\\7;gN\u0014c\u0006I*fK\u0002b\u0014\r\t5sK\u001al$\u0005\u001b;uaNTtfL:qCJ\\g&\u00199bG\",gf\u001c:h_\u0011|7m]\u0018mCR,7\u000f^\u0018tc2l#/\u001a4.I\u0006$X\r^5nK6\u0002\u0018\r\u001e;fe:t\u0003\u000e^7mEy\u0002C)\u0019;fi&lW\r\t)biR,'O\\:=_\u0005t$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EZ8sAY\fG.\u001b3!I\u0006$X\rI1oI\u0002\"\u0018.\\3!M>\u0014X.\u0019;!a\u0006$H/\u001a:og:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QQ\u0001\u0002\u0004)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112i]2\u0004\b\u000f\u001b7g]R\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001a1cYj\u0003\u0007N\u00171q\u001db\u0003eJ=zsflS*T\u0017eI\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u00195mA\u0002D'\r\u001a1a)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002\f\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAI\u0003\u0015\td&\u000e\u00181\u00035)f.\u001b=US6,7\u000f^1naB\u0011q'H\n\u0005;\u0005e\u0005\tE\u0005\u0002\u001c\u0006\u0005V)R'_I6\u0011\u0011Q\u0014\u0006\u0004\u0003?c\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003G\u000biJA\tBEN$(/Y2u\rVt7\r^5p]R\"\"!!&\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u000b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013\u0011\fy+!-\u00024\u0006U\u0006\"B\"!\u0001\u0004)\u0005\"B%!\u0001\u0004)\u0005bB&!!\u0003\u0005\r!\u0014\u0005\b9\u0002\u0002\n\u00111\u0001_\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!\u0011qXAd!\u0011Yd*!1\u0011\u000fm\n\u0019-R#N=&\u0019\u0011Q\u0019\u001f\u0003\rQ+\b\u000f\\35\u0011!\tImIA\u0001\u0002\u0004!\u0017a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a5\u0011\t\u00055\u0012Q[\u0005\u0005\u0003/\fyC\u0001\u0004PE*,7\r\u001e")
public class UnixTimestamp
extends UnixTime
implements Serializable {
    private final Expression timeExp;
    private final Expression format;
    private final Option<String> timeZoneId;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$4() {
        return UnixTimestamp$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return UnixTimestamp$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Option<String>, Object>> unapply(UnixTimestamp unixTimestamp) {
        return UnixTimestamp$.MODULE$.unapply(unixTimestamp);
    }

    public static boolean apply$default$4() {
        return UnixTimestamp$.MODULE$.apply$default$4();
    }

    public static Option<String> apply$default$3() {
        return UnixTimestamp$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Option<String>, Object>, UnixTimestamp> tupled() {
        return UnixTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, Function1<Object, UnixTimestamp>>>> curried() {
        return UnixTimestamp$.MODULE$.curried();
    }

    public Expression timeExp() {
        return this.timeExp;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Expression left() {
        return this.timeExp();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, (Option<String>)x$1, x$4);
    }

    @Override
    public String prettyName() {
        return "unix_timestamp";
    }

    public UnixTimestamp copy(Expression timeExp, Expression format, Option<String> timeZoneId, boolean failOnError) {
        return new UnixTimestamp(timeExp, format, timeZoneId, failOnError);
    }

    public Expression copy$default$1() {
        return this.timeExp();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    public boolean copy$default$4() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "UnixTimestamp";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.timeExp();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnixTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnixTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnixTimestamp unixTimestamp = (UnixTimestamp)x$1;
        Expression expression = this.timeExp();
        Expression expression2 = unixTimestamp.timeExp();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = unixTimestamp.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = unixTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.failOnError() != unixTimestamp.failOnError()) return false;
        if (!unixTimestamp.canEqual(this)) return false;
        return true;
    }

    public UnixTimestamp(Expression timeExp, Expression format, Option<String> timeZoneId, boolean failOnError) {
        this.timeExp = timeExp;
        this.format = format;
        this.timeZoneId = timeZoneId;
        this.failOnError = failOnError;
    }

    public UnixTimestamp(Expression timeExp, Expression format) {
        this(timeExp, format, (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled());
    }

    public UnixTimestamp(Expression time) {
        this(time, Literal$.MODULE$.apply(TimestampFormatter$.MODULE$.defaultPattern()));
    }

    public UnixTimestamp() {
        this(new CurrentTimestamp());
    }
}

