/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import sun.util.calendar.ZoneInfo;

public final class DateTimeUtils$ {
    public static DateTimeUtils$ MODULE$;
    private final TimeZone TimeZoneUTC;
    private final String TIMEZONE_OPTION;
    private final UTF8String gmtUtf8;
    private final long MIN_SECONDS;
    private final int SUNDAY;
    private final int MONDAY;
    private final int TUESDAY;
    private final int WEDNESDAY;
    private final int THURSDAY;
    private final int FRIDAY;
    private final int SATURDAY;
    private final int TRUNC_INVALID;
    private final int TRUNC_TO_MICROSECOND;
    private final int MIN_LEVEL_OF_TIMESTAMP_TRUNC;
    private final int TRUNC_TO_MILLISECOND;
    private final int TRUNC_TO_SECOND;
    private final int TRUNC_TO_MINUTE;
    private final int TRUNC_TO_HOUR;
    private final int TRUNC_TO_DAY;
    private final int TRUNC_TO_WEEK;
    private final int MIN_LEVEL_OF_DATE_TRUNC;
    private final int TRUNC_TO_MONTH;
    private final int TRUNC_TO_QUARTER;
    private final int TRUNC_TO_YEAR;
    private final Regex specialValueRe;

    static {
        new DateTimeUtils$();
    }

    public final int JULIAN_DAY_OF_EPOCH() {
        return 2440588;
    }

    public final TimeZone TimeZoneUTC() {
        return this.TimeZoneUTC;
    }

    public String TIMEZONE_OPTION() {
        return this.TIMEZONE_OPTION;
    }

    public ZoneId getZoneId(String timeZoneId) {
        return ZoneId.of(timeZoneId.replaceFirst("(\\+|\\-)(\\d):", "$10$2:"), ZoneId.SHORT_IDS);
    }

    public TimeZone getTimeZone(String timeZoneId) {
        return TimeZone.getTimeZone(this.getZoneId(timeZoneId));
    }

    public int microsToDays(long micros, ZoneId zoneId) {
        return this.localDateToDays(this.getLocalDateTime(micros, zoneId).toLocalDate());
    }

    public long daysToMicros(int days, ZoneId zoneId) {
        Instant instant = this.daysToLocalDate(days).atStartOfDay(zoneId).toInstant();
        return this.instantToMicros(instant);
    }

    public int fromJavaDate(Date date) {
        long millisUtc = date.getTime();
        long millisLocal = millisUtc + (long)TimeZone.getDefault().getOffset(millisUtc);
        int julianDays = Math.toIntExact(Math.floorDiv(millisLocal, 86400000L));
        return RebaseDateTime$.MODULE$.rebaseJulianToGregorianDays(julianDays);
    }

    public Date toJavaDate(int days) {
        int n;
        int rebasedDays = RebaseDateTime$.MODULE$.rebaseGregorianToJulianDays(days);
        long localMillis = Math.multiplyExact((long)rebasedDays, 86400000L);
        TimeZone timeZone = TimeZone.getDefault();
        if (timeZone instanceof ZoneInfo) {
            ZoneInfo zoneInfo = (ZoneInfo)timeZone;
            n = zoneInfo.getOffsetsByWall(localMillis, null);
        } else if (timeZone != null) {
            TimeZone timeZone2 = timeZone;
            n = timeZone2.getOffset(localMillis - (long)timeZone2.getRawOffset());
        } else {
            throw new MatchError((Object)timeZone);
        }
        int timeZoneOffset = n;
        return new Date(localMillis - (long)timeZoneOffset);
    }

    public Timestamp toJavaTimestamp(long micros) {
        long rebasedMicros = RebaseDateTime$.MODULE$.rebaseGregorianToJulianMicros(micros);
        long seconds = Math.floorDiv(rebasedMicros, 1000000L);
        Timestamp ts = new Timestamp(seconds * 1000L);
        long nanos = (rebasedMicros - seconds * 1000000L) * 1000L;
        ts.setNanos((int)nanos);
        return ts;
    }

    public long fromJavaTimestamp(Timestamp t) {
        long micros = this.millisToMicros(t.getTime()) + (long)t.getNanos() / 1000L % 1000L;
        return RebaseDateTime$.MODULE$.rebaseJulianToGregorianMicros(micros);
    }

    public long fromJulianDay(int days, long nanos) {
        return (long)(days - 2440588) * 86400000000L + nanos / 1000L;
    }

    public Tuple2<Object, Object> toJulianDay(long micros) {
        long julianUs = micros + 210866803200000000L;
        long days = julianUs / 86400000000L;
        long us = julianUs % 86400000000L;
        return new Tuple2.mcIJ.sp((int)days, TimeUnit.MICROSECONDS.toNanos(us));
    }

    public long microsToMillis(long micros) {
        return Math.floorDiv(micros, 1000L);
    }

    public long millisToMicros(long millis) {
        return Math.multiplyExact(millis, 1000L);
    }

    private final UTF8String gmtUtf8() {
        return this.gmtUtf8;
    }

    public UTF8String cleanLegacyTimestampStr(UTF8String s) {
        return s.replace(this.gmtUtf8(), UTF8String.EMPTY_UTF8);
    }

    /*
     * Unable to fully structure code
     */
    public Option<Object> stringToTimestamp(UTF8String s, ZoneId timeZoneId) {
        try {
            block33: {
                block32: {
                    if (s == null) {
                        return None$.MODULE$;
                    }
                    tz = None$.MODULE$;
                    segments = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 1, 1, 0, 0, 0, 0, 0, 0}), ClassTag$.MODULE$.Int());
                    i = 0;
                    currentSegmentValue = 0;
                    bytes = s.trimAll().getBytes();
                    specialTimestamp = this.convertSpecialTimestamp(bytes, timeZoneId);
                    if (specialTimestamp.isDefined()) {
                        return specialTimestamp;
                    }
                    digitsMilli = 0;
                    justTime = false;
                    for (j = 0; j < bytes.length; ++j) {
                        b = bytes[j];
                        parsedValue = b - (byte)48;
                        if (parsedValue < 0 || parsedValue > 9) {
                            if (j == 0 && b == 84) {
                                justTime = true;
                                i += 3;
                                continue;
                            }
                            if (i < 2) {
                                if (b == 45) {
                                    if (i == 0 && j != 4) {
                                        return None$.MODULE$;
                                    }
                                    segments[i] = currentSegmentValue;
                                    currentSegmentValue = 0;
                                    ++i;
                                    continue;
                                }
                                if (i == 0 && b == 58) {
                                    justTime = true;
                                    segments[3] = currentSegmentValue;
                                    currentSegmentValue = 0;
                                    i = 4;
                                    continue;
                                }
                                return None$.MODULE$;
                            }
                            if (i == 2) {
                                if (b == 32 || b == 84) {
                                    segments[i] = currentSegmentValue;
                                    currentSegmentValue = 0;
                                    ++i;
                                    continue;
                                }
                                return None$.MODULE$;
                            }
                            if (i == 3 || i == 4) {
                                if (b == 58) {
                                    segments[i] = currentSegmentValue;
                                    currentSegmentValue = 0;
                                    ++i;
                                    continue;
                                }
                                return None$.MODULE$;
                            }
                            if (i == 5 || i == 6) {
                                if (b == 45 || b == 43) {
                                    segments[i] = currentSegmentValue;
                                    currentSegmentValue = 0;
                                    ++i;
                                    tz = new Some((Object)new String(bytes, j, 1));
                                } else if (b == 46 && i == 5) {
                                    segments[i] = currentSegmentValue;
                                    currentSegmentValue = 0;
                                    ++i;
                                } else {
                                    segments[i] = currentSegmentValue;
                                    currentSegmentValue = 0;
                                    ++i;
                                    tz = new Some((Object)new String(bytes, j, bytes.length - j));
                                    j = bytes.length - 1;
                                }
                                if (i != 6 || b == 46) continue;
                                ++i;
                                continue;
                            }
                            if (i < segments.length && (b == 58 || b == 32)) {
                                segments[i] = currentSegmentValue;
                                currentSegmentValue = 0;
                                ++i;
                                continue;
                            }
                            return None$.MODULE$;
                        }
                        if (i == 6) {
                            ++digitsMilli;
                        }
                        currentSegmentValue = currentSegmentValue * 10 + parsedValue;
                    }
                    segments[i] = currentSegmentValue;
                    if (!justTime && i == 0 && j != 4) {
                        return None$.MODULE$;
                    }
                    while (digitsMilli < 6) {
                        segments[6] = segments[6] * 10;
                        ++digitsMilli;
                    }
                    while (digitsMilli > 6) {
                        segments[6] = segments[6] / 10;
                        --digitsMilli;
                    }
                    var17_14 = false;
                    var18_15 = null;
                    var19_16 = tz;
                    if (!None$.MODULE$.equals(var19_16)) break block32;
                    var4_17 = timeZoneId;
                    break block33;
                }
                if (!(var19_16 instanceof Some)) ** GOTO lbl-1000
                var17_14 = true;
                var18_15 = (Some)var19_16;
                var20_18 = (String)var18_15.value();
                if ("+".equals(var20_18)) {
                    var4_17 = ZoneOffset.ofHoursMinutes(segments[7], segments[8]);
                } else if (var17_14 && "-".equals(var21_19 = (String)var18_15.value())) {
                    var4_17 = ZoneOffset.ofHoursMinutes(-segments[7], -segments[8]);
                } else if (var17_14 && (zoneName = (String)var18_15.value()) != null) {
                    var23_21 = zoneName;
                    var4_17 = this.getZoneId(var23_21.trim());
                } else {
                    throw new MatchError((Object)var19_16);
                }
            }
            zoneId = var4_17;
            nanoseconds = TimeUnit.MICROSECONDS.toNanos(segments[6]);
            localTime = LocalTime.of(segments[3], segments[4], segments[5], (int)nanoseconds);
            localDate = justTime != false ? LocalDate.now(zoneId) : LocalDate.of(segments[0], segments[1], segments[2]);
            localDateTime = LocalDateTime.of(localDate, localTime);
            zonedDateTime = ZonedDateTime.of(localDateTime, zoneId);
            instant = Instant.from(zonedDateTime);
            v0 = new Some((Object)BoxesRunTime.boxToLong((long)this.instantToMicros(instant)));
        }
        catch (Throwable var31_29) {
            var32_30 = var31_29;
            var33_31 = NonFatal$.MODULE$.unapply(var32_30);
            if (var33_31.isEmpty()) {
                throw var31_29;
            }
            var3_32 = None$.MODULE$;
            v0 = var3_32;
        }
        return v0;
    }

    public long stringToTimestampAnsi(UTF8String s, ZoneId timeZoneId) {
        Option<Object> timestamp = this.stringToTimestamp(s, timeZoneId);
        if (timestamp.isEmpty()) {
            throw new DateTimeException(new StringBuilder(30).append("Cannot cast ").append(s).append(" to TimestampType.").toString());
        }
        return BoxesRunTime.unboxToLong((Object)timestamp.get());
    }

    private long MIN_SECONDS() {
        return this.MIN_SECONDS;
    }

    public long instantToMicros(Instant instant) {
        long l;
        long secs = instant.getEpochSecond();
        if (secs == this.MIN_SECONDS()) {
            long us = Math.multiplyExact(secs + 1L, 1000000L);
            l = Math.addExact(us, TimeUnit.NANOSECONDS.toMicros(instant.getNano()) - 1000000L);
        } else {
            long us = Math.multiplyExact(secs, 1000000L);
            l = Math.addExact(us, TimeUnit.NANOSECONDS.toMicros(instant.getNano()));
        }
        return l;
    }

    public Instant microsToInstant(long micros) {
        long secs = Math.floorDiv(micros, 1000000L);
        long mos = micros - secs * 1000000L;
        return Instant.ofEpochSecond(secs, mos * 1000L);
    }

    public int localDateToDays(LocalDate localDate) {
        return Math.toIntExact(localDate.toEpochDay());
    }

    public LocalDate daysToLocalDate(int days) {
        return LocalDate.ofEpochDay(days);
    }

    public Option<Object> stringToDate(UTF8String s, ZoneId zoneId) {
        Some some;
        int j;
        if (s == null) {
            return None$.MODULE$;
        }
        int[] segments = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 1, 1}), ClassTag$.MODULE$.Int());
        int i = 0;
        int currentSegmentValue = 0;
        byte[] bytes = s.trimAll().getBytes();
        Option<Object> specialDate = this.convertSpecialDate(bytes, zoneId);
        if (specialDate.isDefined()) {
            return specialDate;
        }
        for (j = 0; j < bytes.length && i < 3 && bytes[j] != 32 && bytes[j] != 84; ++j) {
            byte b = bytes[j];
            if (i < 2 && b == 45) {
                if (i == 0 && j != 4) {
                    return None$.MODULE$;
                }
                segments[i] = currentSegmentValue;
                currentSegmentValue = 0;
                ++i;
                continue;
            }
            int parsedValue = b - (byte)48;
            if (parsedValue < 0 || parsedValue > 9) {
                return None$.MODULE$;
            }
            currentSegmentValue = currentSegmentValue * 10 + parsedValue;
        }
        if (i == 0 && j != 4) {
            return None$.MODULE$;
        }
        if (i < 2 && j < bytes.length) {
            return None$.MODULE$;
        }
        segments[i] = currentSegmentValue;
        try {
            LocalDate localDate = LocalDate.of(segments[0], segments[1], segments[2]);
            some = new Some((Object)BoxesRunTime.boxToInteger((int)this.localDateToDays(localDate)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    private LocalDateTime getLocalDateTime(long micros, ZoneId zoneId) {
        return this.microsToInstant(micros).atZone(zoneId).toLocalDateTime();
    }

    public int getHours(long micros, ZoneId zoneId) {
        return this.getLocalDateTime(micros, zoneId).getHour();
    }

    public int getMinutes(long micros, ZoneId zoneId) {
        return this.getLocalDateTime(micros, zoneId).getMinute();
    }

    public int getSeconds(long micros, ZoneId zoneId) {
        return this.getLocalDateTime(micros, zoneId).getSecond();
    }

    public Decimal getSecondsWithFraction(long micros, ZoneId zoneId) {
        return Decimal$.MODULE$.apply(this.getMicroseconds(micros, zoneId), 8, 6);
    }

    public int getMicroseconds(long micros, ZoneId zoneId) {
        LocalDateTime lt = this.getLocalDateTime(micros, zoneId);
        return (int)(lt.getLong(ChronoField.MICRO_OF_SECOND) + (long)lt.getSecond() * 1000000L);
    }

    public int getDayInYear(int days) {
        return this.daysToLocalDate(days).getDayOfYear();
    }

    public int getYear(int days) {
        return this.daysToLocalDate(days).getYear();
    }

    public int getWeekBasedYear(int days) {
        return this.daysToLocalDate(days).get(IsoFields.WEEK_BASED_YEAR);
    }

    public int getQuarter(int days) {
        return this.daysToLocalDate(days).get(IsoFields.QUARTER_OF_YEAR);
    }

    public int getMonth(int days) {
        return this.daysToLocalDate(days).getMonthValue();
    }

    public int getDayOfMonth(int days) {
        return this.daysToLocalDate(days).getDayOfMonth();
    }

    public int getDayOfWeek(int days) {
        return LocalDate.ofEpochDay(days).getDayOfWeek().plus(1L).getValue();
    }

    public int getWeekDay(int days) {
        return LocalDate.ofEpochDay(days).getDayOfWeek().ordinal();
    }

    public int getWeekOfYear(int days) {
        return LocalDate.ofEpochDay(days).get(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
    }

    public int dateAddMonths(int days, int months) {
        return this.localDateToDays(this.daysToLocalDate(days).plusMonths(months));
    }

    public long timestampAddInterval(long start, int months, int days, long microseconds, ZoneId zoneId) {
        ZonedDateTime resultTimestamp = this.microsToInstant(start).atZone(zoneId).plusMonths(months).plusDays(days).plus(microseconds, ChronoUnit.MICROS);
        return this.instantToMicros(resultTimestamp.toInstant());
    }

    public int dateAddInterval(int start, CalendarInterval interval) {
        Predef$.MODULE$.require(interval.microseconds == 0L, (Function0 & Serializable & scala.Serializable)() -> "Cannot add hours, minutes or seconds, milliseconds, microseconds to a date");
        LocalDate ld = this.daysToLocalDate(start).plusMonths(interval.months).plusDays(interval.days);
        return this.localDateToDays(ld);
    }

    private Tuple4<Object, Object, Object, Object> splitDate(int days) {
        LocalDate ld = this.daysToLocalDate(days);
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)ld.getYear()), (Object)BoxesRunTime.boxToInteger((int)ld.getMonthValue()), (Object)BoxesRunTime.boxToInteger((int)ld.getDayOfMonth()), (Object)BoxesRunTime.boxToInteger((int)(ld.lengthOfMonth() - ld.getDayOfMonth())));
    }

    public double monthsBetween(long micros1, long micros2, boolean roundOff, ZoneId zoneId) {
        int date1 = this.microsToDays(micros1, zoneId);
        int date2 = this.microsToDays(micros2, zoneId);
        Tuple4<Object, Object, Object, Object> tuple4 = this.splitDate(date1);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        int year1 = BoxesRunTime.unboxToInt((Object)tuple4._1());
        int monthInYear1 = BoxesRunTime.unboxToInt((Object)tuple4._2());
        int dayInMonth1 = BoxesRunTime.unboxToInt((Object)tuple4._3());
        int daysToMonthEnd1 = BoxesRunTime.unboxToInt((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)year1), (Object)BoxesRunTime.boxToInteger((int)monthInYear1), (Object)BoxesRunTime.boxToInteger((int)dayInMonth1), (Object)BoxesRunTime.boxToInteger((int)daysToMonthEnd1));
        Tuple4 tuple43 = tuple42;
        int year12 = BoxesRunTime.unboxToInt((Object)tuple43._1());
        int monthInYear12 = BoxesRunTime.unboxToInt((Object)tuple43._2());
        int dayInMonth12 = BoxesRunTime.unboxToInt((Object)tuple43._3());
        int daysToMonthEnd12 = BoxesRunTime.unboxToInt((Object)tuple43._4());
        Tuple4<Object, Object, Object, Object> tuple44 = this.splitDate(date2);
        if (tuple44 == null) {
            throw new MatchError(tuple44);
        }
        int year2 = BoxesRunTime.unboxToInt((Object)tuple44._1());
        int monthInYear2 = BoxesRunTime.unboxToInt((Object)tuple44._2());
        int dayInMonth2 = BoxesRunTime.unboxToInt((Object)tuple44._3());
        int daysToMonthEnd2 = BoxesRunTime.unboxToInt((Object)tuple44._4());
        Tuple4 tuple45 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)monthInYear2), (Object)BoxesRunTime.boxToInteger((int)dayInMonth2), (Object)BoxesRunTime.boxToInteger((int)daysToMonthEnd2));
        Tuple4 tuple46 = tuple45;
        int year22 = BoxesRunTime.unboxToInt((Object)tuple46._1());
        int monthInYear22 = BoxesRunTime.unboxToInt((Object)tuple46._2());
        int dayInMonth22 = BoxesRunTime.unboxToInt((Object)tuple46._3());
        int daysToMonthEnd22 = BoxesRunTime.unboxToInt((Object)tuple46._4());
        int months1 = year12 * 12 + monthInYear12;
        int months2 = year22 * 12 + monthInYear22;
        double monthDiff = months1 - months2;
        if (dayInMonth12 == dayInMonth22 || daysToMonthEnd12 == 0 && daysToMonthEnd22 == 0) {
            return monthDiff;
        }
        long secondsInDay1 = TimeUnit.MICROSECONDS.toSeconds(micros1 - this.daysToMicros(date1, zoneId));
        long secondsInDay2 = TimeUnit.MICROSECONDS.toSeconds(micros2 - this.daysToMicros(date2, zoneId));
        long secondsDiff = (long)(dayInMonth12 - dayInMonth22) * 86400L + secondsInDay1 - secondsInDay2;
        long secondsInMonth = TimeUnit.DAYS.toSeconds(31L);
        double diff = monthDiff + (double)secondsDiff / (double)secondsInMonth;
        return roundOff ? (double)package$.MODULE$.round(diff * 1.0E8) / 1.0E8 : diff;
    }

    private int SUNDAY() {
        return this.SUNDAY;
    }

    private int MONDAY() {
        return this.MONDAY;
    }

    private int TUESDAY() {
        return this.TUESDAY;
    }

    private int WEDNESDAY() {
        return this.WEDNESDAY;
    }

    private int THURSDAY() {
        return this.THURSDAY;
    }

    private int FRIDAY() {
        return this.FRIDAY;
    }

    private int SATURDAY() {
        return this.SATURDAY;
    }

    public int getDayOfWeekFromString(UTF8String string) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        String dowString = string.toString().toUpperCase(Locale.ROOT);
        String string2 = dowString;
        boolean bl7 = "SU".equals(string2) ? true : ("SUN".equals(string2) ? true : "SUNDAY".equals(string2));
        int n = bl7 ? this.SUNDAY() : ((bl6 = "MO".equals(string2) ? true : ("MON".equals(string2) ? true : "MONDAY".equals(string2))) ? this.MONDAY() : ((bl5 = "TU".equals(string2) ? true : ("TUE".equals(string2) ? true : "TUESDAY".equals(string2))) ? this.TUESDAY() : ((bl4 = "WE".equals(string2) ? true : ("WED".equals(string2) ? true : "WEDNESDAY".equals(string2))) ? this.WEDNESDAY() : ((bl3 = "TH".equals(string2) ? true : ("THU".equals(string2) ? true : "THURSDAY".equals(string2))) ? this.THURSDAY() : ((bl2 = "FR".equals(string2) ? true : ("FRI".equals(string2) ? true : "FRIDAY".equals(string2))) ? this.FRIDAY() : ((bl = "SA".equals(string2) ? true : ("SAT".equals(string2) ? true : "SATURDAY".equals(string2))) ? this.SATURDAY() : -1))))));
        return n;
    }

    public int getNextDateForDayOfWeek(int startDay, int dayOfWeek) {
        return startDay + 1 + ((dayOfWeek - 1 - startDay) % 7 + 7) % 7;
    }

    public int getLastDayOfMonth(int days) {
        LocalDate localDate = this.daysToLocalDate(days);
        return days - localDate.getDayOfMonth() + localDate.lengthOfMonth();
    }

    public int TRUNC_INVALID() {
        return this.TRUNC_INVALID;
    }

    public int TRUNC_TO_MICROSECOND() {
        return this.TRUNC_TO_MICROSECOND;
    }

    public int MIN_LEVEL_OF_TIMESTAMP_TRUNC() {
        return this.MIN_LEVEL_OF_TIMESTAMP_TRUNC;
    }

    public int TRUNC_TO_MILLISECOND() {
        return this.TRUNC_TO_MILLISECOND;
    }

    public int TRUNC_TO_SECOND() {
        return this.TRUNC_TO_SECOND;
    }

    public int TRUNC_TO_MINUTE() {
        return this.TRUNC_TO_MINUTE;
    }

    public int TRUNC_TO_HOUR() {
        return this.TRUNC_TO_HOUR;
    }

    public int TRUNC_TO_DAY() {
        return this.TRUNC_TO_DAY;
    }

    public int TRUNC_TO_WEEK() {
        return this.TRUNC_TO_WEEK;
    }

    public int MIN_LEVEL_OF_DATE_TRUNC() {
        return this.MIN_LEVEL_OF_DATE_TRUNC;
    }

    public int TRUNC_TO_MONTH() {
        return this.TRUNC_TO_MONTH;
    }

    public int TRUNC_TO_QUARTER() {
        return this.TRUNC_TO_QUARTER;
    }

    public int TRUNC_TO_YEAR() {
        return this.TRUNC_TO_YEAR;
    }

    public int truncDate(int days, int level) {
        int n;
        int n2 = level;
        if (this.TRUNC_TO_WEEK() == n2) {
            n = this.getNextDateForDayOfWeek(days - 7, this.MONDAY());
        } else if (this.TRUNC_TO_MONTH() == n2) {
            n = days - this.getDayOfMonth(days) + 1;
        } else if (this.TRUNC_TO_QUARTER() == n2) {
            n = this.localDateToDays(this.daysToLocalDate(days).with(IsoFields.DAY_OF_QUARTER, 1L));
        } else if (this.TRUNC_TO_YEAR() == n2) {
            n = days - this.getDayInYear(days) + 1;
        } else {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(21).append("Invalid trunc level: ").append(level).toString());
        }
        return n;
    }

    private long truncToUnit(long micros, ZoneId zoneId, ChronoUnit unit) {
        ZonedDateTime truncated = this.microsToInstant(micros).atZone(zoneId).truncatedTo(unit);
        return this.instantToMicros(truncated.toInstant());
    }

    public long truncTimestamp(long micros, int level, ZoneId zoneId) {
        long l;
        int n = level;
        if (this.TRUNC_TO_MICROSECOND() == n) {
            l = micros;
        } else if (this.TRUNC_TO_MILLISECOND() == n) {
            l = micros - Math.floorMod(micros, 1000L);
        } else if (this.TRUNC_TO_SECOND() == n) {
            l = micros - Math.floorMod(micros, 1000000L);
        } else if (this.TRUNC_TO_MINUTE() == n) {
            l = this.truncToUnit(micros, zoneId, ChronoUnit.MINUTES);
        } else if (this.TRUNC_TO_HOUR() == n) {
            l = this.truncToUnit(micros, zoneId, ChronoUnit.HOURS);
        } else if (this.TRUNC_TO_DAY() == n) {
            l = this.truncToUnit(micros, zoneId, ChronoUnit.DAYS);
        } else {
            int dDays = this.microsToDays(micros, zoneId);
            l = this.daysToMicros(this.truncDate(dDays, level), zoneId);
        }
        return l;
    }

    public int parseTruncLevel(UTF8String format) {
        int n;
        if (format == null) {
            n = this.TRUNC_INVALID();
        } else {
            int n2;
            String string = format.toString().toUpperCase(Locale.ROOT);
            if ("MICROSECOND".equals(string)) {
                n2 = this.TRUNC_TO_MICROSECOND();
            } else if ("MILLISECOND".equals(string)) {
                n2 = this.TRUNC_TO_MILLISECOND();
            } else if ("SECOND".equals(string)) {
                n2 = this.TRUNC_TO_SECOND();
            } else if ("MINUTE".equals(string)) {
                n2 = this.TRUNC_TO_MINUTE();
            } else if ("HOUR".equals(string)) {
                n2 = this.TRUNC_TO_HOUR();
            } else {
                boolean bl = "DAY".equals(string) ? true : "DD".equals(string);
                if (bl) {
                    n2 = this.TRUNC_TO_DAY();
                } else if ("WEEK".equals(string)) {
                    n2 = this.TRUNC_TO_WEEK();
                } else {
                    boolean bl2 = "MON".equals(string) ? true : ("MONTH".equals(string) ? true : "MM".equals(string));
                    if (bl2) {
                        n2 = this.TRUNC_TO_MONTH();
                    } else if ("QUARTER".equals(string)) {
                        n2 = this.TRUNC_TO_QUARTER();
                    } else {
                        boolean bl3 = "YEAR".equals(string) ? true : ("YYYY".equals(string) ? true : "YY".equals(string));
                        n2 = bl3 ? this.TRUNC_TO_YEAR() : this.TRUNC_INVALID();
                    }
                }
            }
            n = n2;
        }
        return n;
    }

    public long convertTz(long micros, ZoneId fromZone, ZoneId toZone) {
        ZonedDateTime rebasedDateTime = this.getLocalDateTime(micros, toZone).atZone(fromZone);
        return this.instantToMicros(rebasedDateTime.toInstant());
    }

    public long fromUTCTime(long micros, String timeZone) {
        return this.convertTz(micros, ZoneOffset.UTC, this.getZoneId(timeZone));
    }

    public long toUTCTime(long micros, String timeZone) {
        return this.convertTz(micros, this.getZoneId(timeZone), ZoneOffset.UTC);
    }

    public long currentTimestamp() {
        return this.instantToMicros(Instant.now());
    }

    public int currentDate(ZoneId zoneId) {
        return this.localDateToDays(LocalDate.now(zoneId));
    }

    private ZonedDateTime today(ZoneId zoneId) {
        return Instant.now().atZone(zoneId).with(LocalTime.MIDNIGHT);
    }

    private Regex specialValueRe() {
        return this.specialValueRe;
    }

    private Option<String> extractSpecialValue(String input, ZoneId zoneId) {
        String z;
        String v;
        Predef$.MODULE$.assert(input.trim().length() == input.length());
        if (input.length() < 3 || !RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(input), 0)))) {
            return None$.MODULE$;
        }
        String string = input;
        Option option = this.specialValueRe().unapplySeq((CharSequence)string);
        Object object = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0 && this.isValid$1(v = (String)((LinearSeqOptimized)option.get()).apply(0), z = (String)((LinearSeqOptimized)option.get()).apply(1)) ? new Some((Object)v.toLowerCase(Locale.US)) : None$.MODULE$;
        return object;
    }

    public Option<Object> convertSpecialTimestamp(String input, ZoneId zoneId) {
        return this.extractSpecialValue(input, zoneId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            Object object = "epoch".equals(string) ? new Some((Object)BoxesRunTime.boxToLong((long)0L)) : ("now".equals(string) ? new Some((Object)BoxesRunTime.boxToLong((long)MODULE$.currentTimestamp())) : ("today".equals(string) ? new Some((Object)BoxesRunTime.boxToLong((long)MODULE$.instantToMicros(MODULE$.today(zoneId).toInstant()))) : ("tomorrow".equals(string) ? new Some((Object)BoxesRunTime.boxToLong((long)MODULE$.instantToMicros(MODULE$.today(zoneId).plusDays(1L).toInstant()))) : ("yesterday".equals(string) ? new Some((Object)BoxesRunTime.boxToLong((long)MODULE$.instantToMicros(MODULE$.today(zoneId).minusDays(1L).toInstant()))) : None$.MODULE$))));
            return object;
        });
    }

    private Option<Object> convertSpecialTimestamp(byte[] bytes, ZoneId zoneId) {
        return bytes.length > 0 && Character.isAlphabetic(bytes[0]) ? this.convertSpecialTimestamp(new String(bytes, StandardCharsets.UTF_8), zoneId) : None$.MODULE$;
    }

    public Option<Object> convertSpecialDate(String input, ZoneId zoneId) {
        return this.extractSpecialValue(input, zoneId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl;
            String string = x0$1;
            Object object = "epoch".equals(string) ? new Some((Object)BoxesRunTime.boxToInteger((int)0)) : ((bl = "now".equals(string) ? true : "today".equals(string)) ? new Some((Object)BoxesRunTime.boxToInteger((int)MODULE$.currentDate(zoneId))) : ("tomorrow".equals(string) ? new Some((Object)BoxesRunTime.boxToInteger((int)Math.addExact(MODULE$.currentDate(zoneId), 1))) : ("yesterday".equals(string) ? new Some((Object)BoxesRunTime.boxToInteger((int)Math.subtractExact(MODULE$.currentDate(zoneId), 1))) : None$.MODULE$)));
            return object;
        });
    }

    private Option<Object> convertSpecialDate(byte[] bytes, ZoneId zoneId) {
        return bytes.length > 0 && Character.isAlphabetic(bytes[0]) ? this.convertSpecialDate(new String(bytes, StandardCharsets.UTF_8), zoneId) : None$.MODULE$;
    }

    public CalendarInterval subtractDates(int endDay, int startDay) {
        Period period = Period.between(this.daysToLocalDate(startDay), this.daysToLocalDate(endDay));
        int months = Math.toIntExact(period.toTotalMonths());
        int days = period.getDays();
        return new CalendarInterval(months, days, 0L);
    }

    private final boolean isValid$1(String value, String timeZoneId) {
        boolean bl;
        if (timeZoneId.isEmpty()) {
            return true;
        }
        if (value.compareToIgnoreCase("now") == 0) {
            return false;
        }
        try {
            this.getZoneId(timeZoneId);
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    private DateTimeUtils$() {
        MODULE$ = this;
        this.TimeZoneUTC = TimeZone.getTimeZone("UTC");
        this.TIMEZONE_OPTION = "timeZone";
        this.gmtUtf8 = UTF8String.fromString((String)"GMT");
        this.MIN_SECONDS = Math.floorDiv(Long.MIN_VALUE, 1000000L);
        this.SUNDAY = 3;
        this.MONDAY = 4;
        this.TUESDAY = 5;
        this.WEDNESDAY = 6;
        this.THURSDAY = 0;
        this.FRIDAY = 1;
        this.SATURDAY = 2;
        this.TRUNC_INVALID = -1;
        this.TRUNC_TO_MICROSECOND = 0;
        this.MIN_LEVEL_OF_TIMESTAMP_TRUNC = this.TRUNC_TO_MICROSECOND();
        this.TRUNC_TO_MILLISECOND = 1;
        this.TRUNC_TO_SECOND = 2;
        this.TRUNC_TO_MINUTE = 3;
        this.TRUNC_TO_HOUR = 4;
        this.TRUNC_TO_DAY = 5;
        this.TRUNC_TO_WEEK = 6;
        this.MIN_LEVEL_OF_DATE_TRUNC = this.TRUNC_TO_WEEK();
        this.TRUNC_TO_MONTH = 7;
        this.TRUNC_TO_QUARTER = 8;
        this.TRUNC_TO_YEAR = 9;
        this.specialValueRe = new StringOps(Predef$.MODULE$.augmentString("(\\p{Alpha}+)\\p{Blank}*(.*)")).r();
    }
}

