/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Generator;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.JsonTuple$;
import org.apache.spark.sql.catalyst.expressions.SharedFactory$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(jsonStr, p1, p2, ..., pn) - Returns a tuple like the function get_json_object, but it takes multiple names. All the input parameters and output column types are string.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":1, \"b\":2}', 'a', 'b');\n       1\t2\n  ", group="json_funcs", since="1.6.0")
@ScalaSignature(bytes="\u0006\u0001\t-b\u0001\u0002\u0011\"\u0001:B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t'\u0002\u0011\t\u0012)A\u0005\u000f\")A\u000b\u0001C\u0001+\")\u0001\f\u0001C!3\"AQ\f\u0001EC\u0002\u0013%a\f\u0003\u0005i\u0001!\u0015\r\u0011\"\u0003j\u0011!Y\u0007\u0001#b\u0001\n\u00131\u0005\u0002C7\u0001\u0011\u000b\u0007I\u0011\u00028\t\u0011y\u0004\u0001R1A\u0005\n}Dq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u0002\u001a\u0001!\t%a\u0007\t\u000f\u0005u\u0001\u0001\"\u0011\u0002 !9\u0011Q\u0006\u0001\u0005B\u0005=\u0002bBA\u001e\u0001\u0011%\u0011Q\b\u0005\b\u0003;\u0002A\u0011BA0\u0011\u001d\t\u0019\b\u0001C)\u0003kB\u0011\"! \u0001\u0003\u0003%\t!a \t\u0013\u0005\r\u0005!%A\u0005\u0002\u0005\u0015\u0005\"CAN\u0001\u0005\u0005I\u0011IAO\u0011!\ti\u000bAA\u0001\n\u0003y\b\"CAX\u0001\u0005\u0005I\u0011AAY\u0011%\ti\fAA\u0001\n\u0003\ny\fC\u0005\u0002N\u0002\t\t\u0011\"\u0001\u0002P\"I\u00111\u001b\u0001\u0002\u0002\u0013\u0005\u0013Q[\u0004\n\u0003s\f\u0013\u0011!E\u0001\u0003w4\u0001\u0002I\u0011\u0002\u0002#\u0005\u0011Q \u0005\u0007)j!\tAa\u0003\t\u0013\t5!$!A\u0005F\t=\u0001\"\u0003B\t5\u0005\u0005I\u0011\u0011B\n\u0011%\u00119BGA\u0001\n\u0003\u0013I\u0002C\u0005\u0003\"i\t\t\u0011\"\u0003\u0003$\tI!j]8o)V\u0004H.\u001a\u0006\u0003E\r\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A%J\u0001\tG\u0006$\u0018\r\\=ti*\u0011aeJ\u0001\u0004gFd'B\u0001\u0015*\u0003\u0015\u0019\b/\u0019:l\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M1\u0001aL\u001a7y\t\u0003\"\u0001M\u0019\u000e\u0003\u0005J!AM\u0011\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u00021i%\u0011Q'\t\u0002\n\u000f\u0016tWM]1u_J\u0004\"a\u000e\u001e\u000e\u0003aR!!O\u0011\u0002\u000f\r|G-Z4f]&\u00111\b\u000f\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0011Q\bQ\u0007\u0002})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B}\t9\u0001K]8ek\u000e$\bCA\u001fD\u0013\t!eH\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0005dQ&dGM]3o+\u00059\u0005c\u0001%Q_9\u0011\u0011J\u0014\b\u0003\u00156k\u0011a\u0013\u0006\u0003\u00196\na\u0001\u0010:p_Rt\u0014\"A \n\u0005=s\u0014a\u00029bG.\fw-Z\u0005\u0003#J\u00131aU3r\u0015\tye(A\u0005dQ&dGM]3oA\u00051A(\u001b8jiz\"\"AV,\u0011\u0005A\u0002\u0001\"B#\u0004\u0001\u00049\u0015\u0001\u00038vY2\f'\r\\3\u0016\u0003i\u0003\"!P.\n\u0005qs$a\u0002\"p_2,\u0017M\\\u0001\b]VdGNU8x+\u0005y\u0006c\u0001%QAB\u0011\u0011MY\u0007\u0002G%\u00111m\t\u0002\f\u0013:$XM\u001d8bYJ{w\u000f\u000b\u0002\u0006KB\u0011QHZ\u0005\u0003Oz\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0011)\u001cxN\\#yaJ,\u0012a\f\u0015\u0003\r\u0015\f\u0001CZ5fY\u0012,\u0005\u0010\u001d:fgNLwN\\:)\u0005\u001d)\u0017A\u00054pY\u0012\f'\r\\3GS\u0016dGMT1nKN,\u0012a\u001c\t\u0004\u0011B\u0014\u0018BA9S\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\t\u0004{M,\u0018B\u0001;?\u0005\u0019y\u0005\u000f^5p]B\u0011aO\u001f\b\u0003ob\u0004\"A\u0013 \n\u0005et\u0014A\u0002)sK\u0012,g-\u0003\u0002|y\n11\u000b\u001e:j]\u001eT!!\u001f )\u0005!)\u0017AD2p]N$\u0018M\u001c;GS\u0016dGm]\u000b\u0003\u0003\u0003\u00012!PA\u0002\u0013\r\t)A\u0010\u0002\u0004\u0013:$\bFA\u0005f\u00035)G.Z7f]R\u001c6\r[3nCV\u0011\u0011Q\u0002\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111C\u0013\u0002\u000bQL\b/Z:\n\t\u0005]\u0011\u0011\u0003\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017A\u00039sKR$\u0018PT1nKV\tQ/A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u0002\"A!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(\r\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0003W\t)CA\bUsB,7\t[3dWJ+7/\u001e7u\u0003\u0011)g/\u00197\u0015\t\u0005E\u0012q\u0007\t\u0005\u0011\u0006M\u0002-C\u0002\u00026I\u0013q\u0002\u0016:bm\u0016\u00148/\u00192mK>s7-\u001a\u0005\t\u0003si\u0001\u0013!a\u0001A\u0006)\u0011N\u001c9vi\u0006A\u0001/\u0019:tKJ{w\u000fF\u0003`\u0003\u007f\tY\u0006C\u0004\u0002B9\u0001\r!a\u0011\u0002\rA\f'o]3s!\u0011\t)%a\u0016\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\nAaY8sK*!\u0011QJA(\u0003\u001dQ\u0017mY6t_:TA!!\u0015\u0002T\u0005Ia-Y:uKJDX\u000e\u001c\u0006\u0003\u0003+\n1aY8n\u0013\u0011\tI&a\u0012\u0003\u0015)\u001bxN\u001c)beN,'\u000f\u0003\u0004\u0002:9\u0001\r\u0001Y\u0001\u0015G>\u0004\u0018pQ;se\u0016tGo\u0015;sk\u000e$XO]3\u0015\r\u0005\u0005\u0014qMA9!\ri\u00141M\u0005\u0004\u0003Kr$\u0001B+oSRDq!!\u001b\u0010\u0001\u0004\tY'A\u0005hK:,'/\u0019;peB!\u0011QIA7\u0013\u0011\ty'a\u0012\u0003\u001b)\u001bxN\\$f]\u0016\u0014\u0018\r^8s\u0011\u001d\t\te\u0004a\u0001\u0003\u0007\nqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0007Y\u000b9\bC\u0004\u0002zA\u0001\r!a\u001f\u0002\u00179,wo\u00115jY\u0012\u0014XM\u001c\t\u0004\u0011B|\u0013\u0001B2paf$2AVAA\u0011\u001d)\u0015\u0003%AA\u0002\u001d\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\b*\u001aq)!#,\u0005\u0005-\u0005\u0003BAG\u0003/k!!a$\u000b\t\u0005E\u00151S\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!&?\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\u000byIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAP!\u0011\t\t+a+\u000e\u0005\u0005\r&\u0002BAS\u0003O\u000bA\u0001\\1oO*\u0011\u0011\u0011V\u0001\u0005U\u00064\u0018-C\u0002|\u0003G\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00024\u0006e\u0006cA\u001f\u00026&\u0019\u0011q\u0017 \u0003\u0007\u0005s\u0017\u0010C\u0005\u0002<V\t\t\u00111\u0001\u0002\u0002\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!1\u0011\r\u0005\r\u0017\u0011ZAZ\u001b\t\t)MC\u0002\u0002Hz\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY-!2\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u00045\u0006E\u0007\"CA^/\u0005\u0005\t\u0019AAZ\u0003\u0019)\u0017/^1mgR\u0019!,a6\t\u0013\u0005m\u0006$!AA\u0002\u0005M\u0006f\u0005\u0001\u0002\\\u0006\u0005\u00181]At\u0003S\fi/a<\u0002t\u0006U\bc\u0001\u0019\u0002^&\u0019\u0011q\\\u0011\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011Q]\u0001\u0002`}3UKT\"`Q)\u001cxN\\*ue2\u0002\u0003/\r\u0017!aJb\u0003E\f\u0018/Y\u0001\u0002h.\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007\u0005^;qY\u0016\u0004C.[6fAQDW\r\t4v]\u000e$\u0018n\u001c8!O\u0016$xL[:p]~{'M[3di2\u0002#-\u001e;!SR\u0004C/Y6fg\u0002jW\u000f\u001c;ja2,\u0007E\\1nKNt\u0003%\u00117mAQDW\rI5oaV$\b\u0005]1sC6,G/\u001a:tA\u0005tG\rI8viB,H\u000fI2pYVlg\u000e\t;za\u0016\u001c\b%\u0019:fAM$(/\u001b8h]\u0005AQ\r_1na2,7/\t\u0002\u0002l\u0006y%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014|E\u0005\u0014#(\r\u0017!E\t\u0014#HM?(Y\u0001:\u0013m\n\u0017!O\t<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112\u0013IR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003c\f!B[:p]~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\t90A\u00032]Yr\u0003'A\u0005Kg>tG+\u001e9mKB\u0011\u0001GG\n\u00055\u0005}(\t\u0005\u0004\u0003\u0002\t\u001dqIV\u0007\u0003\u0005\u0007Q1A!\u0002?\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0003\u0003\u0004\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\u0005m\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0015!B1qa2LHc\u0001,\u0003\u0016!)Q)\ba\u0001\u000f\u00069QO\\1qa2LH\u0003\u0002B\u000e\u0005;\u00012!P:H\u0011!\u0011yBHA\u0001\u0002\u00041\u0016a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011)\u0003\u0005\u0003\u0002\"\n\u001d\u0012\u0002\u0002B\u0015\u0003G\u0013aa\u00142kK\u000e$\b")
public class JsonTuple
extends Expression
implements Generator,
CodegenFallback,
scala.Serializable {
    private transient Seq<InternalRow> nullRow;
    private transient Expression jsonExpr;
    private transient Seq<Expression> fieldExpressions;
    private transient IndexedSeq<Option<String>> foldableFieldNames;
    private transient int constantFields;
    private final Seq<Expression> children;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile transient byte bitmap$trans$0;

    public static Option<Seq<Expression>> unapply(JsonTuple jsonTuple) {
        return JsonTuple$.MODULE$.unapply(jsonTuple);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<JsonTuple, A> function1) {
        return JsonTuple$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, JsonTuple> compose(Function1<A, Seq<Expression>> function1) {
        return JsonTuple$.MODULE$.compose(function1);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public DataType dataType() {
        return Generator.dataType$(this);
    }

    @Override
    public boolean foldable() {
        return Generator.foldable$(this);
    }

    @Override
    public TraversableOnce<InternalRow> terminate() {
        return Generator.terminate$(this);
    }

    @Override
    public boolean supportCodegen() {
        return Generator.supportCodegen$(this);
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$Generator$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    private Seq<InternalRow> nullRow$lzycompute() {
        JsonTuple jsonTuple = this;
        synchronized (jsonTuple) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                GenericInternalRow genericInternalRow = new GenericInternalRow((Object[])Array$.MODULE$.ofDim(this.fieldExpressions().length(), ClassTag$.MODULE$.Any()));
                this.nullRow = Nil$.MODULE$.$colon$colon((Object)genericInternalRow);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.nullRow;
    }

    private Seq<InternalRow> nullRow() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.nullRow$lzycompute() : this.nullRow;
    }

    private Expression jsonExpr$lzycompute() {
        JsonTuple jsonTuple = this;
        synchronized (jsonTuple) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.jsonExpr = (Expression)this.children().head();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.jsonExpr;
    }

    private Expression jsonExpr() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.jsonExpr$lzycompute() : this.jsonExpr;
    }

    private Seq<Expression> fieldExpressions$lzycompute() {
        JsonTuple jsonTuple = this;
        synchronized (jsonTuple) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.fieldExpressions = (Seq)this.children().tail();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.fieldExpressions;
    }

    private Seq<Expression> fieldExpressions() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.fieldExpressions$lzycompute() : this.fieldExpressions;
    }

    private IndexedSeq<Option<String>> foldableFieldNames$lzycompute() {
        JsonTuple jsonTuple = this;
        synchronized (jsonTuple) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.foldableFieldNames = ((TraversableOnce)this.fieldExpressions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Expression expression = x0$1;
                    Option option = expression.foldable() ? Option$.MODULE$.apply(expression.eval(expression.eval$default$1())).map((Function1 & Serializable & scala.Serializable)x$6 -> ((UTF8String)x$6).toString()) : null;
                    return option;
                }, Seq$.MODULE$.canBuildFrom())).toIndexedSeq();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.foldableFieldNames;
    }

    private IndexedSeq<Option<String>> foldableFieldNames() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.foldableFieldNames$lzycompute() : this.foldableFieldNames;
    }

    private int constantFields$lzycompute() {
        JsonTuple jsonTuple = this;
        synchronized (jsonTuple) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.constantFields = this.foldableFieldNames().count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)JsonTuple.$anonfun$constantFields$1(x$7)));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.constantFields;
    }

    private int constantFields() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.constantFields$lzycompute() : this.constantFields;
    }

    @Override
    public StructType elementSchema() {
        return StructType$.MODULE$.apply((Seq<StructField>)((Seq)((TraversableLike)this.fieldExpressions().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int idx = tuple2._2$mcI$sp();
            StructField structField = new StructField(new StringBuilder(1).append("c").append(idx).toString(), StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            return structField;
        }, Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    public String prettyName() {
        return "json_tuple";
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.children().length() < 2 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(32).append(this.prettyName()).append(" requires at least two arguments").toString()) : (this.children().forall((Function1 & Serializable & scala.Serializable)child -> BoxesRunTime.boxToBoolean((boolean)StringType$.MODULE$.acceptsType(child.dataType()))) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(40).append(this.prettyName()).append(" requires that all arguments are strings").toString()));
    }

    @Override
    public TraversableOnce<InternalRow> eval(InternalRow input) {
        TraversableOnce traversableOnce;
        UTF8String json = (UTF8String)this.jsonExpr().eval(input);
        if (json == null) {
            return this.nullRow();
        }
        try {
            traversableOnce = (TraversableOnce)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> CreateJacksonParser$.MODULE$.utf8String(SharedFactory$.MODULE$.jsonFactory(), json), (Function1 & Serializable & scala.Serializable)parser -> this.parseRow((JsonParser)parser, input));
        }
        catch (JsonProcessingException jsonProcessingException) {
            traversableOnce = this.nullRow();
        }
        return traversableOnce;
    }

    private Seq<InternalRow> parseRow(JsonParser parser, InternalRow input) {
        JsonToken jsonToken = parser.nextToken();
        JsonToken jsonToken2 = JsonToken.START_OBJECT;
        if (jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2)) {
            return this.nullRow();
        }
        Seq fieldNames = this.constantFields() == this.fieldExpressions().length() ? (Seq)this.foldableFieldNames().map((Function1 & Serializable & scala.Serializable)x$8 -> (String)x$8.orNull(Predef$.MODULE$.$conforms()), IndexedSeq$.MODULE$.canBuildFrom()) : (this.constantFields() == 0 ? (Seq)this.fieldExpressions().map((Function1 & Serializable & scala.Serializable)x$9 -> ((UTF8String)x$9.eval(input)).toString(), Seq$.MODULE$.canBuildFrom()) : (Seq)((TraversableLike)this.foldableFieldNames().zip(this.fieldExpressions(), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Expression expr = (Expression)tuple2._2();
                if (option == null) {
                    return ((UTF8String)expr.eval(input)).toString();
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Option fieldName = (Option)tuple2._1();
            return (String)fieldName.orNull(Predef$.MODULE$.$conforms());
        }, IndexedSeq$.MODULE$.canBuildFrom()));
        Object[] row = (Object[])Array$.MODULE$.ofDim(fieldNames.length(), ClassTag$.MODULE$.Any());
        while (true) {
            String jsonField;
            int idx;
            JsonToken jsonToken3 = parser.nextToken();
            JsonToken jsonToken4 = JsonToken.END_OBJECT;
            if (!(jsonToken3 == null ? jsonToken4 != null : !jsonToken3.equals(jsonToken4))) break;
            JsonToken jsonToken5 = parser.getCurrentToken();
            JsonToken jsonToken6 = JsonToken.FIELD_NAME;
            if (!(jsonToken5 != null ? !jsonToken5.equals(jsonToken6) : jsonToken6 != null) && (idx = fieldNames.indexOf((Object)(jsonField = parser.getCurrentName()))) >= 0) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                JsonToken jsonToken7 = parser.nextToken();
                JsonToken jsonToken8 = JsonToken.VALUE_NULL;
                if (jsonToken7 == null ? jsonToken8 != null : !jsonToken7.equals(jsonToken8)) {
                    Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> SharedFactory$.MODULE$.jsonFactory().createGenerator((OutputStream)output, JsonEncoding.UTF8), (Function1 & Serializable & scala.Serializable)generator -> {
                        this.copyCurrentStructure(generator, parser);
                        return BoxedUnit.UNIT;
                    });
                    UTF8String jsonValue = UTF8String.fromBytes((byte[])output.toByteArray());
                    do {
                        row[idx] = jsonValue;
                    } while ((idx = fieldNames.indexOf((Object)jsonField, idx + 1)) >= 0);
                }
            }
            parser.skipChildren();
        }
        GenericInternalRow genericInternalRow = new GenericInternalRow(row);
        return Nil$.MODULE$.$colon$colon((Object)genericInternalRow);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void copyCurrentStructure(JsonGenerator generator, JsonParser parser) {
        boolean bl = false;
        JsonToken jsonToken = null;
        JsonToken jsonToken2 = parser.getCurrentToken();
        if (JsonToken.VALUE_STRING.equals(jsonToken2)) {
            bl = true;
            jsonToken = jsonToken2;
            if (parser.hasTextCharacters()) {
                generator.writeRaw(parser.getTextCharacters(), parser.getTextOffset(), parser.getTextLength());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            generator.writeRaw(parser.getText());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (JsonToken.VALUE_NULL.equals(jsonToken2)) {
            throw QueryExecutionErrors$.MODULE$.copyNullFieldNotAllowedError();
        }
        generator.copyCurrentStructure(parser);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public JsonTuple withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren);
    }

    public JsonTuple copy(Seq<Expression> children2) {
        return new JsonTuple(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "JsonTuple";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.children();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonTuple;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonTuple)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonTuple jsonTuple = (JsonTuple)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = jsonTuple.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!jsonTuple.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$constantFields$1(Option x$7) {
        return x$7 != null;
    }

    public JsonTuple(Seq<Expression> children2) {
        this.children = children2;
        Generator.$init$(this);
        CodegenFallback.$init$(this);
    }
}

