/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.errors;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.QualifiedTableName;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.CannotReplaceMissingTableException;
import org.apache.spark.sql.catalyst.analysis.CannotReplaceMissingTableException$;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException$;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException$;
import org.apache.spark.sql.catalyst.analysis.ResolvedNamespace;
import org.apache.spark.sql.catalyst.analysis.ResolvedTable;
import org.apache.spark.sql.catalyst.analysis.ResolvedView;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.InvalidUDFClassException;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.CreateMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GroupingID;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowFunction;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SerdeInfo;
import org.apache.spark.sql.catalyst.plans.logical.Window;
import org.apache.spark.sql.catalyst.trees.Origin;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class QueryCompilationErrors$ {
    public static QueryCompilationErrors$ MODULE$;

    static {
        new QueryCompilationErrors$();
    }

    public Throwable groupingIDMismatchError(GroupingID groupingID, Seq<Expression> groupByExprs) {
        return new AnalysisException("GROUPING_ID_COLUMN_MISMATCH", (String[])((Object[])new String[]{groupingID.groupByExprs().mkString(","), groupByExprs.mkString(",")}));
    }

    public Throwable groupingColInvalidError(Expression groupingCol, Seq<Expression> groupByExprs) {
        return new AnalysisException("GROUPING_COLUMN_MISMATCH", (String[])((Object[])new String[]{groupingCol.toString(), groupByExprs.mkString(",")}));
    }

    public Throwable groupingSizeTooLargeError(int sizeLimit) {
        return new AnalysisException("GROUPING_SIZE_LIMIT_EXCEEDED", (String[])((Object[])new String[]{Integer.toString(sizeLimit)}));
    }

    public Throwable unorderablePivotColError(Expression pivotCol) {
        return new AnalysisException("INCOMPARABLE_PIVOT_COLUMN", (String[])((Object[])new String[]{pivotCol.toString()}));
    }

    public Throwable nonLiteralPivotValError(Expression pivotVal) {
        return new AnalysisException("NON_LITERAL_PIVOT_VALUES", (String[])((Object[])new String[]{pivotVal.toString()}));
    }

    public Throwable pivotValDataTypeMismatchError(Expression pivotVal, Expression pivotCol) {
        return new AnalysisException("PIVOT_VALUE_DATA_TYPE_MISMATCH", (String[])((Object[])new String[]{pivotVal.toString(), pivotVal.dataType().simpleString(), pivotCol.dataType().catalogString()}));
    }

    public Throwable unsupportedIfNotExistsError(String tableName) {
        return new AnalysisException("IF_PARTITION_NOT_EXISTS_UNSUPPORTED", (String[])((Object[])new String[]{tableName}));
    }

    public Throwable nonPartitionColError(String partitionName) {
        return new AnalysisException("NON_PARTITION_COLUMN", (String[])((Object[])new String[]{partitionName}));
    }

    public Throwable missingStaticPartitionColumn(String staticName) {
        return new AnalysisException("MISSING_STATIC_PARTITION_COLUMN", (String[])((Object[])new String[]{staticName}));
    }

    public Throwable nestedGeneratorError(Expression trimmedNestedGenerator) {
        return new AnalysisException(new java.lang.StringBuilder(71).append("Generators are not supported when it's nested in expressions, but got: ").append(package$.MODULE$.toPrettySQL(trimmedNestedGenerator)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable moreThanOneGeneratorError(Seq<Expression> generators, String clause) {
        return new AnalysisException(new java.lang.StringBuilder(51).append("Only one generator allowed per ").append(clause).append(" clause but found ").append(generators.size()).append(": ").append(((TraversableOnce)generators.map((Function1 & Serializable & scala.Serializable)e -> package$.MODULE$.toPrettySQL((Expression)e), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable generatorOutsideSelectError(LogicalPlan plan2) {
        return new AnalysisException(new java.lang.StringBuilder(65).append("Generators are not supported outside the SELECT clause, but got: ").append(plan2.simpleString(SQLConf$.MODULE$.get().maxToStringFields())).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable legacyStoreAssignmentPolicyError() {
        String configKey = SQLConf$.MODULE$.STORE_ASSIGNMENT_POLICY().key();
        return new AnalysisException(new java.lang.StringBuilder(116).append("LEGACY store assignment policy is disallowed in Spark data source V2. ").append("Please set the configuration ").append(configKey).append(" to other values.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable unresolvedUsingColForJoinError(String colName, LogicalPlan plan2, String side) {
        return new AnalysisException(new java.lang.StringBuilder(82).append("USING column `").append(colName).append("` cannot be resolved on the ").append(side).append(" ").append("side of the join. The ").append(side).append("-side columns: [").append(((TraversableOnce)plan2.output().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("]").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable dataTypeMismatchForDeserializerError(DataType dataType, String desiredType) {
        String quantifier = desiredType.equals("array") ? "an" : "a";
        return new AnalysisException(new java.lang.StringBuilder(21).append("need ").append(quantifier).append(" ").append(desiredType).append(" field but got ").append(dataType.catalogString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable fieldNumberMismatchForDeserializerError(StructType schema, int maxOrdinal) {
        return new AnalysisException(new java.lang.StringBuilder(74).append("Try to map ").append(schema.catalogString()).append(" to Tuple").append(maxOrdinal + 1).append(", ").append("but failed as the number of fields does not line up.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable upCastFailureError(String fromStr, Expression from, DataType to, Seq<String> walkedTypePath) {
        return new AnalysisException(new java.lang.StringBuilder(187).append("Cannot up cast ").append(fromStr).append(" from ").append(from.dataType().catalogString()).append(" to ").append(to.catalogString()).append(".\n").append("The type path of the target object is:\n").append(walkedTypePath.mkString("", "\n", "\n")).append("You can either add an explicit cast to the input data or choose a higher precision ").append("type of the field in the target object").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable unsupportedAbstractDataTypeForUpCastError(AbstractDataType gotType) {
        return new AnalysisException(new java.lang.StringBuilder(66).append("UpCast only support DecimalType as AbstractDataType yet, but got: ").append(gotType).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable outerScopeFailureForNewInstanceError(String className) {
        return new AnalysisException(new java.lang.StringBuilder(155).append("Unable to generate an encoder for inner class `").append(className).append("` without ").append("access to the scope that this class was defined in.\n").append("Try moving this class out of its parent class.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable referenceColNotFoundForAlterTableChangesError(TableChange.After after, String parentName) {
        return new AnalysisException(new java.lang.StringBuilder(43).append("Couldn't find the reference column for ").append(after).append(" at ").append(parentName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable windowSpecificationNotDefinedError(String windowName) {
        return new AnalysisException(new java.lang.StringBuilder(58).append("Window specification ").append(windowName).append(" is not defined in the WINDOW clause.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable selectExprNotInGroupByError(Expression expr, Seq<Alias> groupByAliases) {
        return new AnalysisException(new java.lang.StringBuilder(38).append(expr).append(" doesn't show up in the GROUP BY list ").append(groupByAliases).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable groupingMustWithGroupingSetsOrCubeOrRollupError() {
        return new AnalysisException("grouping()/grouping_id() can only be used with GroupingSets/Cube/Rollup", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable pandasUDFAggregateNotSupportedInPivotError() {
        return new AnalysisException("Pandas UDF aggregate expressions are currently not supported in pivot.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable aggregateExpressionRequiredForPivotError(String sql2) {
        return new AnalysisException(new java.lang.StringBuilder(89).append("Aggregate expression required for pivot, but '").append(sql2).append("' ").append("did not appear in any aggregate function.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable writeIntoTempViewNotAllowedError(String quoted) {
        return new AnalysisException(new java.lang.StringBuilder(67).append("Cannot write into temp view ").append(quoted).append(" as it's not a data source v2 relation.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable expectTableOrPermanentViewNotTempViewError(String quoted, String cmd, TreeNode<?> t) {
        return new AnalysisException(new java.lang.StringBuilder(54).append(quoted).append(" is a temp view. '").append(cmd).append("' expects a table or permanent view.").toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable readNonStreamingTempViewError(String quoted) {
        return new AnalysisException(new java.lang.StringBuilder(111).append(quoted).append(" is not a temp view of streaming ").append("logical plan, please use batch API such as `DataFrameReader.table` to read it.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable viewDepthExceedsMaxResolutionDepthError(TableIdentifier identifier, int maxNestedViewDepth, TreeNode<?> t) {
        return new AnalysisException(new java.lang.StringBuilder(145).append("The depth of view ").append(identifier).append(" exceeds the maximum ").append("view resolution depth (").append(maxNestedViewDepth).append("). Analysis is aborted to ").append("avoid errors. Increase the value of ").append(SQLConf$.MODULE$.MAX_NESTED_VIEW_DEPTH().key()).append(" to work ").append("around this.").toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable insertIntoViewNotAllowedError(TableIdentifier identifier, TreeNode<?> t) {
        return new AnalysisException(new java.lang.StringBuilder(45).append("Inserting into a view is not allowed. View: ").append(identifier).append(".").toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable writeIntoViewNotAllowedError(TableIdentifier identifier, TreeNode<?> t) {
        return new AnalysisException(new java.lang.StringBuilder(43).append("Writing into a view is not allowed. View: ").append(identifier).append(".").toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable writeIntoV1TableNotAllowedError(TableIdentifier identifier, TreeNode<?> t) {
        return new AnalysisException(new java.lang.StringBuilder(29).append("Cannot write into v1 table: ").append(identifier).append(".").toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable expectTableNotViewError(ResolvedView v, String cmd, Option<String> mismatchHint, TreeNode<?> t) {
        String viewStr = v.isTemp() ? "temp view" : "view";
        String hintStr = (String)mismatchHint.map((Function1 & Serializable & scala.Serializable)x$2 -> new java.lang.StringBuilder(1).append(" ").append((String)x$2).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new AnalysisException(new java.lang.StringBuilder(27).append(CatalogV2Implicits$.MODULE$.IdentifierHelper(v.identifier()).quoted()).append(" is a ").append(viewStr).append(". '").append(cmd).append("' expects a table.").append(hintStr).toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable expectViewNotTableError(ResolvedTable v, String cmd, Option<String> mismatchHint, TreeNode<?> t) {
        String hintStr = (String)mismatchHint.map((Function1 & Serializable & scala.Serializable)x$3 -> new java.lang.StringBuilder(1).append(" ").append((String)x$3).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new AnalysisException(new java.lang.StringBuilder(31).append(CatalogV2Implicits$.MODULE$.IdentifierHelper(v.identifier()).quoted()).append(" is a table. '").append(cmd).append("' expects a view.").append(hintStr).toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable permanentViewNotSupportedByStreamingReadingAPIError(String quoted) {
        return new AnalysisException(new java.lang.StringBuilder(107).append(quoted).append(" is a permanent view, which is not supported by ").append("streaming reading API such as `DataStreamReader.table` yet.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable starNotAllowedWhenGroupByOrdinalPositionUsedError() {
        return new AnalysisException("Star (*) is not allowed in select list when GROUP BY ordinal position is used", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidStarUsageError(String prettyName) {
        return new AnalysisException(new java.lang.StringBuilder(24).append("Invalid usage of '*' in ").append(prettyName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable singleTableStarInCountNotAllowedError(String targetString) {
        return new AnalysisException(new java.lang.StringBuilder(100).append("count(").append(targetString).append(".*) is not allowed. ").append("Please use count(*) or expand the columns manually, e.g. count(col1, col2)").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable orderByPositionRangeError(int index, int size, TreeNode<?> t) {
        return new AnalysisException(new java.lang.StringBuilder(63).append("ORDER BY position ").append(index).append(" is not in select list ").append("(valid range is [1, ").append(size).append("])").toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable groupByPositionRefersToAggregateFunctionError(int index, Expression expr) {
        return new AnalysisException(new java.lang.StringBuilder(134).append("GROUP BY ").append(index).append(" refers to an expression that is or contains ").append("an aggregate function. Aggregate functions are not allowed in GROUP BY, ").append("but got ").append(expr.sql()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable groupByPositionRangeError(int index, int size) {
        return new AnalysisException(new java.lang.StringBuilder(63).append("GROUP BY position ").append(index).append(" is not in select list ").append("(valid range is [1, ").append(size).append("])").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable generatorNotExpectedError(FunctionIdentifier name, String classCanonicalName) {
        return new AnalysisException(new java.lang.StringBuilder(81).append(name).append(" is expected to be a generator. However, ").append("its class is ").append(classCanonicalName).append(", which is not a generator.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable functionWithUnsupportedSyntaxError(String prettyName, String syntax) {
        return new AnalysisException(new java.lang.StringBuilder(27).append("Function ").append(prettyName).append(" does not support ").append(syntax).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable nonDeterministicFilterInAggregateError() {
        return new AnalysisException("FILTER expression is non-deterministic, it cannot be used in aggregate functions", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable aliasNumberNotMatchColumnNumberError(int columnSize, int outputSize, TreeNode<?> t) {
        return new AnalysisException(new java.lang.StringBuilder(107).append("Number of column aliases does not match number of columns. ").append("Number of column aliases: ").append(columnSize).append("; ").append("number of columns: ").append(outputSize).append(".").toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable aliasesNumberNotMatchUDTFOutputError(int aliasesSize, String aliasesNames) {
        return new AnalysisException(new java.lang.StringBuilder(131).append("The number of aliases supplied in the AS clause does not ").append("match the number of columns output by the UDTF expected ").append(aliasesSize).append(" ").append("aliases but got ").append(aliasesNames).append(" ").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable windowAggregateFunctionWithFilterNotSupportedError() {
        return new AnalysisException("window aggregate function with filter predicate is not supported yet.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable windowFunctionInsideAggregateFunctionNotAllowedError() {
        return new AnalysisException("It is not allowed to use a window function inside an aggregate function. Please use the inner window function in a sub-query.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable expressionWithoutWindowExpressionError(NamedExpression expr) {
        return new AnalysisException(new java.lang.StringBuilder(36).append(expr).append(" does not have any WindowExpression.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable expressionWithMultiWindowExpressionsError(NamedExpression expr, Seq<WindowSpecDefinition> distinctWindowSpec) {
        return new AnalysisException(new java.lang.StringBuilder(116).append(expr).append(" has multiple Window Specifications (").append(distinctWindowSpec).append(").").append("Please file a bug report with this error message, stack trace, and the query.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable windowFunctionNotAllowedError(String clauseName) {
        return new AnalysisException(new java.lang.StringBuilder(56).append("It is not allowed to use window functions inside ").append(clauseName).append(" clause").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotSpecifyWindowFrameError(String prettyName) {
        return new AnalysisException(new java.lang.StringBuilder(41).append("Cannot specify window frame for ").append(prettyName).append(" function").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable windowFrameNotMatchRequiredFrameError(SpecifiedWindowFrame f, WindowFrame required) {
        return new AnalysisException(new java.lang.StringBuilder(44).append("Window Frame ").append(f).append(" must match the required frame ").append(required).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable windowFunctionWithWindowFrameNotOrderedError(WindowFunction wf) {
        return new AnalysisException(new java.lang.StringBuilder(180).append("Window function ").append(wf).append(" requires window to be ordered, please add ").append("ORDER BY clause. For example SELECT ").append(wf).append("(value_expr) OVER (PARTITION BY window_partition ").append("ORDER BY window_ordering) from table").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotResolveUserSpecifiedColumnsError(String col, TreeNode<?> t) {
        return new AnalysisException(new java.lang.StringBuilder(27).append("Cannot resolve column name ").append(col).toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable writeTableWithMismatchedColumnsError(int columnSize, int outputSize, TreeNode<?> t) {
        return new AnalysisException(new java.lang.StringBuilder(91).append("Cannot write to table due to mismatched user specified column ").append("size(").append(columnSize).append(") and data column size(").append(outputSize).append(")").toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable multiTimeWindowExpressionsNotSupportedError(TreeNode<?> t) {
        return new AnalysisException("Multiple time/session window expressions would result in a cartesian product of rows, therefore they are currently not supported.", t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable sessionWindowGapDurationDataTypeError(DataType dt) {
        return new AnalysisException(new java.lang.StringBuilder(85).append("Gap duration expression used in session window must be ").append("CalendarIntervalType, but got ").append(dt).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable viewOutputNumberMismatchQueryColumnNamesError(Seq<Attribute> output, Seq<String> queryColumnNames) {
        return new AnalysisException(new java.lang.StringBuilder(84).append("The view output ").append(output.mkString("[", ",", "]")).append(" doesn't have the same").append("number of columns with the query column names ").append(queryColumnNames.mkString("[", ",", "]")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable attributeNotFoundError(String colName, LogicalPlan child) {
        return new AnalysisException(new java.lang.StringBuilder(41).append("Attribute with name '").append(colName).append("' is not found in ").append("'").append(((TraversableOnce)child.output().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Seq$.MODULE$.canBuildFrom())).mkString("(", ",", ")")).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotUpCastAsAttributeError(Attribute fromAttr, Attribute toAttr) {
        return new AnalysisException(new java.lang.StringBuilder(44).append("Cannot up cast ").append(fromAttr.sql()).append(" from ").append(fromAttr.dataType().catalogString()).append(" to ").append(toAttr.dataType().catalogString()).append(" ").append("as it may truncate").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable functionUndefinedError(FunctionIdentifier name) {
        return new AnalysisException(new java.lang.StringBuilder(19).append("undefined function ").append(name).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidFunctionArgumentsError(String name, String expectedInfo, int actualNumber) {
        return new AnalysisException(new java.lang.StringBuilder(62).append("Invalid number of arguments for function ").append(name).append(". ").append("Expected: ").append(expectedInfo).append("; Found: ").append(actualNumber).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidFunctionArgumentNumberError(Seq<Object> validParametersCount, String name, Seq<Class<Expression>> params) {
        Throwable throwable;
        if (validParametersCount.length() == 0) {
            throwable = new AnalysisException(new java.lang.StringBuilder(31).append("Invalid arguments for function ").append(name).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        } else {
            String expectedNumberOfParameters = validParametersCount.length() == 1 ? validParametersCount.head().toString() : new java.lang.StringBuilder(0).append(((TraversableOnce)validParametersCount.init()).mkString("one of ", ", ", " and ")).append(validParametersCount.last()).toString();
            throwable = this.invalidFunctionArgumentsError(name, expectedNumberOfParameters, params.length());
        }
        return throwable;
    }

    public Throwable functionAcceptsOnlyOneArgumentError(String name) {
        return new AnalysisException(new java.lang.StringBuilder(35).append("Function ").append(name).append(" accepts only one argument").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable alterV2TableSetLocationWithPartitionNotSupportedError() {
        return new AnalysisException("ALTER TABLE SET LOCATION does not support partition for v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable joinStrategyHintParameterNotSupportedError(Object unsupported) {
        return new AnalysisException(new java.lang.StringBuilder(73).append("Join strategy hint parameter ").append("should be an identifier or string but was ").append(unsupported).append(" (").append(unsupported.getClass()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidHintParameterError(String hintName, Seq<Object> invalidParams) {
        return new AnalysisException(new java.lang.StringBuilder(50).append(hintName).append(" Hint parameter should include columns, but ").append(invalidParams.mkString(", ")).append(" found").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidCoalesceHintParameterError(String hintName) {
        return new AnalysisException(new java.lang.StringBuilder(47).append(hintName).append(" Hint expects a partition number as a parameter").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable attributeNameSyntaxError(String name) {
        return new AnalysisException(new java.lang.StringBuilder(32).append("syntax error in attribute name: ").append(name).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable starExpandDataTypeNotSupportedError(Seq<String> attributes) {
        return new AnalysisException(new java.lang.StringBuilder(53).append("Can only star expand struct data types. Attribute: `").append(attributes).append("`").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotResolveStarExpandGivenInputColumnsError(String targetString, String columns) {
        return new AnalysisException(new java.lang.StringBuilder(42).append("cannot resolve '").append(targetString).append(".*' given input columns '").append(columns).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable addColumnWithV1TableCannotSpecifyNotNullError() {
        return new AnalysisException("ADD COLUMN with v1 tables cannot specify NOT NULL.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable replaceColumnsOnlySupportedWithV2TableError() {
        return new AnalysisException("REPLACE COLUMNS is only supported with v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable alterQualifiedColumnOnlySupportedWithV2TableError() {
        return new AnalysisException("ALTER COLUMN with qualified column is only supported with v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable alterColumnWithV1TableCannotSpecifyNotNullError() {
        return new AnalysisException("ALTER COLUMN with v1 tables cannot specify NOT NULL.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable alterOnlySupportedWithV2TableError() {
        return new AnalysisException("ALTER COLUMN ... FIRST | ALTER is only supported with v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable alterColumnCannotFindColumnInV1TableError(String colName, V1Table v1Table) {
        return new AnalysisException(new java.lang.StringBuilder(57).append("ALTER COLUMN cannot find column ").append(colName).append(" in v1 table. ").append("Available: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])v1Table.schema().fieldNames())).mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable renameColumnOnlySupportedWithV2TableError() {
        return new AnalysisException("RENAME COLUMN is only supported with v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable dropColumnOnlySupportedWithV2TableError() {
        return new AnalysisException("DROP COLUMN is only supported with v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidDatabaseNameError(String quoted) {
        return new AnalysisException(new java.lang.StringBuilder(32).append("The database name is not valid: ").append(quoted).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable replaceTableOnlySupportedWithV2TableError() {
        return new AnalysisException("REPLACE TABLE is only supported with v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable replaceTableAsSelectOnlySupportedWithV2TableError() {
        return new AnalysisException("REPLACE TABLE AS SELECT is only supported with v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotDropViewWithDropTableError() {
        return new AnalysisException("Cannot drop a view with DROP TABLE. Please use DROP VIEW instead", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable showColumnsWithConflictDatabasesError(Seq<String> db, TableIdentifier v1TableName) {
        return new AnalysisException(new java.lang.StringBuilder(49).append("SHOW COLUMNS with conflicting databases: ").append("'").append(db.head()).append("' != '").append(v1TableName.database().get()).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable externalCatalogNotSupportShowViewsError(ResolvedNamespace resolved2) {
        return new AnalysisException(new java.lang.StringBuilder(79).append("Catalog ").append(resolved2.catalog().name()).append(" doesn't support ").append("SHOW VIEWS, only SessionCatalog supports this command.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable unsupportedFunctionNameError(String quoted) {
        return new AnalysisException(new java.lang.StringBuilder(28).append("Unsupported function name '").append(quoted).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable sqlOnlySupportedWithV1TablesError(String sql2) {
        return new AnalysisException(new java.lang.StringBuilder(34).append(sql2).append(" is only supported with v1 tables.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotCreateTableWithBothProviderAndSerdeError(Option<String> provider, Option<SerdeInfo> maybeSerdeInfo) {
        return new AnalysisException(new java.lang.StringBuilder(41).append("Cannot create table with both USING ").append(provider).append(" and ").append(((SerdeInfo)maybeSerdeInfo.get()).describe()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidFileFormatForStoredAsError(SerdeInfo serdeInfo) {
        return new AnalysisException(new java.lang.StringBuilder(41).append("STORED AS with file format '").append(serdeInfo.storedAs().get()).append("' is invalid.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable commandNotSupportNestedColumnError(String command, String quoted) {
        return new AnalysisException(new java.lang.StringBuilder(33).append(command).append(" does not support nested column: ").append(quoted).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable columnDoesNotExistError(String colName) {
        return new AnalysisException(new java.lang.StringBuilder(22).append("Column ").append(colName).append(" does not exist").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable renameTempViewToExistingViewError(String oldName, String newName) {
        return new AnalysisException(new java.lang.StringBuilder(68).append("rename temporary view from '").append(oldName).append("' to '").append(newName).append("': destination view already exists").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable databaseNotEmptyError(String db, String details) {
        return new AnalysisException(new java.lang.StringBuilder(43).append("Database ").append(db).append(" is not empty. One or more ").append(details).append(" exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidNameForTableOrDatabaseError(String name) {
        return new AnalysisException(new java.lang.StringBuilder(105).append("`").append(name).append("` is not a valid name for tables/databases. ").append("Valid names only contain alphabet characters, numbers and _.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotCreateDatabaseWithSameNameAsPreservedDatabaseError(String database) {
        return new AnalysisException(new java.lang.StringBuilder(77).append(database).append(" is a system preserved database, ").append("you cannot create a database with this name.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotDropDefaultDatabaseError() {
        return new AnalysisException("Can not drop default database", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotUsePreservedDatabaseAsCurrentDatabaseError(String database) {
        return new AnalysisException(new java.lang.StringBuilder(196).append(database).append(" is a system preserved database, you cannot use it as ").append("current database. To access global temporary views, you should use qualified name with ").append("the GLOBAL_TEMP_DATABASE, e.g. SELECT * FROM ").append(database).append(".viewName.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable createExternalTableWithoutLocationError() {
        return new AnalysisException("CREATE EXTERNAL TABLE must be accompanied by LOCATION", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotOperateManagedTableWithExistingLocationError(String methodName, TableIdentifier tableIdentifier, Path tableLocation) {
        return new AnalysisException(new java.lang.StringBuilder(75).append("Can not ").append(methodName).append(" the managed table('").append(tableIdentifier).append("')").append(". The associated location('").append(tableLocation.toString()).append("') already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable dropNonExistentColumnsNotSupportedError(Seq<String> nonExistentColumnNames) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(135).append("\n         |Some existing schema fields (").append(nonExistentColumnNames.mkString("[", ",", "]")).append(") are\n         |not present in the new schema. We don't support dropping columns yet.\n         ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotRetrieveTableOrViewNotInSameDatabaseError(Seq<QualifiedTableName> qualifiedTableNames) {
        return new AnalysisException(new java.lang.StringBuilder(94).append("Only the tables/views belong to the same database can be retrieved. ").append("Querying tables/views are ").append(qualifiedTableNames).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable renameTableSourceAndDestinationMismatchError(String db, String newDb) {
        return new AnalysisException(new java.lang.StringBuilder(68).append("RENAME TABLE source and destination databases do not match: '").append(db).append("' != '").append(newDb).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotRenameTempViewWithDatabaseSpecifiedError(TableIdentifier oldName, TableIdentifier newName) {
        return new AnalysisException(new java.lang.StringBuilder(93).append("RENAME TEMPORARY VIEW from '").append(oldName).append("' to '").append(newName).append("': cannot ").append("specify database name '").append(newName.database().get()).append("' in the destination table").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotRenameTempViewToExistingTableError(TableIdentifier oldName, TableIdentifier newName) {
        return new AnalysisException(new java.lang.StringBuilder(69).append("RENAME TEMPORARY VIEW from '").append(oldName).append("' to '").append(newName).append("': ").append("destination table already exists").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidPartitionSpecError(String details) {
        return new AnalysisException(new java.lang.StringBuilder(27).append("Partition spec is invalid. ").append(details).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable functionAlreadyExistsError(FunctionIdentifier func) {
        return new AnalysisException(new java.lang.StringBuilder(24).append("Function ").append(func).append(" already exists").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotLoadClassWhenRegisteringFunctionError(String className, FunctionIdentifier func) {
        return new AnalysisException(new java.lang.StringBuilder(95).append("Can not load class '").append(className).append("' when registering ").append("the function '").append(func).append("', please make sure it is on the classpath").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable resourceTypeNotSupportedError(String resourceType) {
        return new AnalysisException(new java.lang.StringBuilder(34).append("Resource Type '").append(resourceType).append("' is not supported.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable tableNotSpecifyDatabaseError(TableIdentifier identifier) {
        return new AnalysisException(new java.lang.StringBuilder(31).append("table ").append(identifier).append(" did not specify database").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable tableNotSpecifyLocationUriError(TableIdentifier identifier) {
        return new AnalysisException(new java.lang.StringBuilder(34).append("table ").append(identifier).append(" did not specify locationUri").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable partitionNotSpecifyLocationUriError(String specString) {
        return new AnalysisException(new java.lang.StringBuilder(40).append("Partition [").append(specString).append("] did not specify locationUri").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidBucketNumberError(int bucketingMaxBuckets, int numBuckets) {
        return new AnalysisException(new java.lang.StringBuilder(102).append("Number of buckets should be greater than 0 but less than or equal to ").append("bucketing.maxBuckets (`").append(bucketingMaxBuckets).append("`). Got `").append(numBuckets).append("`").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable corruptedTableNameContextInCatalogError(int numParts, int index) {
        return new AnalysisException(new java.lang.StringBuilder(79).append("Corrupted table name context in catalog: ").append(numParts).append(" parts expected, but part ").append(index).append(" is missing.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable corruptedViewSQLConfigsInCatalogError(Exception e) {
        String x$1 = "Corrupted view SQL configs in catalog";
        Some x$2 = new Some((Object)e);
        Option<Object> x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option<Object> x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option<LogicalPlan> x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
        Option<String> x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$6();
        String[] x$7 = AnalysisException$.MODULE$.$lessinit$greater$default$7();
        return new AnalysisException(x$1, x$3, x$4, x$5, (Option<Throwable>)x$2, x$6, x$7);
    }

    public Throwable corruptedViewQueryOutputColumnsInCatalogError(String numCols, int index) {
        return new AnalysisException(new java.lang.StringBuilder(91).append("Corrupted view query output column names in catalog: ").append(numCols).append(" parts expected, but part ").append(index).append(" is missing.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable corruptedViewReferredTempViewInCatalogError(Exception e) {
        String x$1 = "corrupted view referred temp view names in catalog";
        Some x$2 = new Some((Object)e);
        Option<Object> x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option<Object> x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option<LogicalPlan> x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
        Option<String> x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$6();
        String[] x$7 = AnalysisException$.MODULE$.$lessinit$greater$default$7();
        return new AnalysisException(x$1, x$3, x$4, x$5, (Option<Throwable>)x$2, x$6, x$7);
    }

    public Throwable corruptedViewReferredTempFunctionsInCatalogError(Exception e) {
        String x$1 = "corrupted view referred temp functions names in catalog";
        Some x$2 = new Some((Object)e);
        Option<Object> x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option<Object> x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option<LogicalPlan> x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
        Option<String> x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$6();
        String[] x$7 = AnalysisException$.MODULE$.$lessinit$greater$default$7();
        return new AnalysisException(x$1, x$3, x$4, x$5, (Option<Throwable>)x$2, x$6, x$7);
    }

    public Throwable columnStatisticsDeserializationNotSupportedError(String name, DataType dataType) {
        return new AnalysisException(new java.lang.StringBuilder(78).append("Column statistics deserialization is not supported for ").append("column ").append(name).append(" of data type: ").append(dataType).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable columnStatisticsSerializationNotSupportedError(String colName, DataType dataType) {
        return new AnalysisException(new java.lang.StringBuilder(76).append("Column statistics serialization is not supported for ").append("column ").append(colName).append(" of data type: ").append(dataType).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotReadCorruptedTablePropertyError(String key, String details) {
        return new AnalysisException(new java.lang.StringBuilder(48).append("Cannot read table property '").append(key).append("' as it's corrupted.").append(details).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public String cannotReadCorruptedTablePropertyError$default$2() {
        return "";
    }

    public Throwable invalidSchemaStringError(Expression exp) {
        return new AnalysisException(new java.lang.StringBuilder(47).append("The expression '").append(exp.sql()).append("' is not a valid schema string.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable schemaNotFoldableError(Expression exp) {
        return new AnalysisException(new java.lang.StringBuilder(128).append("Schema should be specified in DDL format as a string literal or output of ").append("the schema_of_json/schema_of_csv functions instead of ").append(exp.sql()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable schemaIsNotStructTypeError(DataType dataType) {
        return new AnalysisException(new java.lang.StringBuilder(38).append("Schema should be struct type but got ").append(dataType.sql()).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable keyValueInMapNotStringError(CreateMap m) {
        return new AnalysisException(new java.lang.StringBuilder(59).append("A type of keys and values in map() must be string, but got ").append(m.dataType().catalogString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable nonMapFunctionNotAllowedError() {
        return new AnalysisException("Must use a map() function for options", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidFieldTypeForCorruptRecordError() {
        return new AnalysisException("The field for corrupt records must be string type and nullable", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable dataTypeUnsupportedByClassError(DataType x, String className) {
        return new AnalysisException(new java.lang.StringBuilder(33).append("DataType '").append(x).append("' is not supported by ").append(className).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable parseModeUnsupportedError(String funcName, ParseMode mode) {
        return new AnalysisException(new java.lang.StringBuilder(57).append(funcName).append("() doesn't support the ").append(mode.name()).append(" mode. ").append("Acceptable modes are ").append(PermissiveMode$.MODULE$.name()).append(" and ").append(FailFastMode$.MODULE$.name()).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable unfoldableFieldUnsupportedError() {
        return new AnalysisException("The field parameter needs to be a foldable string value.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable literalTypeUnsupportedForSourceTypeError(String field, Expression source) {
        return new AnalysisException(new java.lang.StringBuilder(62).append("Literals of type '").append(field).append("' are currently not supported ").append("for the ").append(source.dataType().catalogString()).append(" type.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable arrayComponentTypeUnsupportedError(Class<?> clz) {
        return new AnalysisException(new java.lang.StringBuilder(37).append("Unsupported component type ").append(clz).append(" in arrays").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable secondArgumentNotDoubleLiteralError() {
        return new AnalysisException("The second argument should be a double literal.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable dataTypeUnsupportedByExtractValueError(DataType dataType, Expression extraction, Expression child) {
        DataType dataType2 = dataType;
        String string = dataType2 instanceof StructType ? new java.lang.StringBuilder(46).append("Field name should be String Literal, but it's ").append(extraction).toString() : new java.lang.StringBuilder(52).append("Can't extract value from ").append(child).append(": need struct type but got ").append(dataType2.catalogString()).toString();
        String errorMsg = string;
        return new AnalysisException(errorMsg, AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable noHandlerForUDAFError(String name) {
        return new InvalidUDFClassException(new java.lang.StringBuilder(67).append("No handler for UDAF '").append(name).append("'. ").append("Use sparkSession.udf.register(...) instead.").toString());
    }

    public Throwable batchWriteCapabilityError(Table table, String v2WriteClassName, String v1WriteClassName) {
        return new AnalysisException(new java.lang.StringBuilder(55).append("Table ").append(table.name()).append(" declares ").append((Object)TableCapability.V1_BATCH_WRITE).append(" capability but ").append(v2WriteClassName).append(" is not an instance of ").append(v1WriteClassName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable unsupportedDeleteByConditionWithSubqueryError(Option<Expression> condition) {
        return new AnalysisException(new java.lang.StringBuilder(52).append("Delete by condition with subquery is not supported: ").append(condition).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotTranslateExpressionToSourceFilterError(Expression f) {
        return new AnalysisException(new java.lang.StringBuilder(66).append("Exec update failed:").append(" cannot translate expression to source filter: ").append(f).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotDeleteTableWhereFiltersError(Table table, Filter[] filters) {
        return new AnalysisException(new java.lang.StringBuilder(32).append("Cannot delete from table ").append(table.name()).append(" where ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).mkString("[", ", ", "]")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable deleteOnlySupportedWithV2TablesError() {
        return new AnalysisException("DELETE is only supported with v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable describeDoesNotSupportPartitionForV2TablesError() {
        return new AnalysisException("DESCRIBE does not support partition for v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotReplaceMissingTableError(Identifier tableIdentifier) {
        return new CannotReplaceMissingTableException(tableIdentifier, CannotReplaceMissingTableException$.MODULE$.$lessinit$greater$default$2());
    }

    public Throwable cannotReplaceMissingTableError(Identifier tableIdentifier, Option<Throwable> cause) {
        return new CannotReplaceMissingTableException(tableIdentifier, cause);
    }

    public Throwable unsupportedTableOperationError(Table table, String cmd) {
        return new AnalysisException(new java.lang.StringBuilder(25).append("Table ").append(table.name()).append(" does not support ").append(cmd).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable unsupportedBatchReadError(Table table) {
        return this.unsupportedTableOperationError(table, "batch scan");
    }

    public Throwable unsupportedMicroBatchOrContinuousScanError(Table table) {
        return this.unsupportedTableOperationError(table, "either micro-batch or continuous scan");
    }

    public Throwable unsupportedAppendInBatchModeError(Table table) {
        return this.unsupportedTableOperationError(table, "append in batch mode");
    }

    public Throwable unsupportedDynamicOverwriteInBatchModeError(Table table) {
        return this.unsupportedTableOperationError(table, "dynamic overwrite in batch mode");
    }

    public Throwable unsupportedTruncateInBatchModeError(Table table) {
        return this.unsupportedTableOperationError(table, "truncate in batch mode");
    }

    public Throwable unsupportedOverwriteByFilterInBatchModeError(Table table) {
        return this.unsupportedTableOperationError(table, "overwrite by filter in batch mode");
    }

    public Throwable streamingSourcesDoNotSupportCommonExecutionModeError(Seq<String> microBatchSources, Seq<String> continuousSources) {
        return new AnalysisException(new java.lang.StringBuilder(138).append("The streaming sources in a query do not have a common supported execution mode.\nSources support micro-batch: ").append(microBatchSources.mkString(", ")).append("\n").append("Sources support continuous: ").append(continuousSources.mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable noSuchTableError(Identifier ident) {
        return new NoSuchTableException(ident);
    }

    public Throwable noSuchNamespaceError(String[] namespace) {
        return new NoSuchNamespaceException(namespace);
    }

    public Throwable tableAlreadyExistsError(Identifier ident) {
        return new TableAlreadyExistsException(ident);
    }

    public Throwable requiresSinglePartNamespaceError(Identifier ident) {
        return new NoSuchTableException(new java.lang.StringBuilder(53).append("V2 session catalog requires a single-part namespace: ").append(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).quoted()).toString(), NoSuchTableException$.MODULE$.$lessinit$greater$default$2());
    }

    public Throwable namespaceAlreadyExistsError(String[] namespace) {
        return new NamespaceAlreadyExistsException(namespace);
    }

    private Throwable notSupportedInJDBCCatalog(String cmd) {
        return new AnalysisException(new java.lang.StringBuilder(34).append(cmd).append(" is not supported in JDBC catalog.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotCreateJDBCTableUsingProviderError() {
        return this.notSupportedInJDBCCatalog("CREATE TABLE ... USING ...");
    }

    public Throwable cannotCreateJDBCTableUsingLocationError() {
        return this.notSupportedInJDBCCatalog("CREATE TABLE ... LOCATION ...");
    }

    public Throwable cannotCreateJDBCNamespaceUsingProviderError() {
        return this.notSupportedInJDBCCatalog("CREATE NAMESPACE ... LOCATION ...");
    }

    public Throwable cannotCreateJDBCNamespaceWithPropertyError(String k) {
        return this.notSupportedInJDBCCatalog(new java.lang.StringBuilder(31).append("CREATE NAMESPACE with property ").append(k).toString());
    }

    public Throwable cannotSetJDBCNamespaceWithPropertyError(String k) {
        return this.notSupportedInJDBCCatalog(new java.lang.StringBuilder(28).append("SET NAMESPACE with property ").append(k).toString());
    }

    public Throwable cannotUnsetJDBCNamespaceWithPropertyError(String k) {
        return this.notSupportedInJDBCCatalog(new java.lang.StringBuilder(26).append("Remove NAMESPACE property ").append(k).toString());
    }

    public Throwable unsupportedJDBCNamespaceChangeInCatalogError(Seq<NamespaceChange> changes) {
        return new AnalysisException(new java.lang.StringBuilder(45).append("Unsupported NamespaceChange ").append(changes).append(" in JDBC catalog.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    private Throwable tableDoesNotSupportError(String cmd, Table table) {
        return new AnalysisException(new java.lang.StringBuilder(25).append("Table does not support ").append(cmd).append(": ").append(table.name()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable tableDoesNotSupportReadsError(Table table) {
        return this.tableDoesNotSupportError("reads", table);
    }

    public Throwable tableDoesNotSupportWritesError(Table table) {
        return this.tableDoesNotSupportError("writes", table);
    }

    public Throwable tableDoesNotSupportDeletesError(Table table) {
        return this.tableDoesNotSupportError("deletes", table);
    }

    public Throwable tableDoesNotSupportTruncatesError(Table table) {
        return this.tableDoesNotSupportError("truncates", table);
    }

    public Throwable tableDoesNotSupportPartitionManagementError(Table table) {
        return this.tableDoesNotSupportError("partition management", table);
    }

    public Throwable tableDoesNotSupportAtomicPartitionManagementError(Table table) {
        return this.tableDoesNotSupportError("atomic partition management", table);
    }

    public Throwable cannotRenameTableWithAlterViewError() {
        return new AnalysisException("Cannot rename a table with ALTER VIEW. Please use ALTER TABLE instead.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    private Throwable notSupportedForV2TablesError(String cmd) {
        return new AnalysisException(new java.lang.StringBuilder(32).append(cmd).append(" is not supported for v2 tables.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable analyzeTableNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("ANALYZE TABLE");
    }

    public Throwable alterTableRecoverPartitionsNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("ALTER TABLE ... RECOVER PARTITIONS");
    }

    public Throwable alterTableSerDePropertiesNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("ALTER TABLE ... SET [SERDE|SERDEPROPERTIES]");
    }

    public Throwable loadDataNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("LOAD DATA");
    }

    public Throwable showCreateTableAsSerdeNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("SHOW CREATE TABLE AS SERDE");
    }

    public Throwable showColumnsNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("SHOW COLUMNS");
    }

    public Throwable repairTableNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("MSCK REPAIR TABLE");
    }

    public Throwable databaseFromV1SessionCatalogNotSpecifiedError() {
        return new AnalysisException("Database from v1 session catalog is not specified", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable nestedDatabaseUnsupportedByV1SessionCatalogError(String catalog) {
        return new AnalysisException(new java.lang.StringBuilder(58).append("Nested databases are not supported by v1 session catalog: ").append(catalog).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidRepartitionExpressionsError(Seq<Object> sortOrders) {
        return new AnalysisException(new java.lang.StringBuilder(91).append("Invalid partitionExprs specified: ").append(sortOrders).append(" For range ").append("partitioning use REPARTITION_BY_RANGE instead.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable partitionColumnNotSpecifiedError(String format, String partitionColumn) {
        return new AnalysisException(new java.lang.StringBuilder(92).append("Failed to resolve the schema for ").append(format).append(" for ").append("the partition column: ").append(partitionColumn).append(". It must be specified manually.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable dataSchemaNotSpecifiedError(String format) {
        return new AnalysisException(new java.lang.StringBuilder(59).append("Unable to infer schema for ").append(format).append(". It must be specified manually.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable dataPathNotExistError(String path) {
        return new AnalysisException(new java.lang.StringBuilder(21).append("Path does not exist: ").append(path).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable dataSourceOutputModeUnsupportedError(String className, OutputMode outputMode) {
        return new AnalysisException(new java.lang.StringBuilder(42).append("Data source ").append(className).append(" does not support ").append(outputMode).append(" output mode").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable schemaNotSpecifiedForSchemaRelationProviderError(String className) {
        return new AnalysisException(new java.lang.StringBuilder(43).append("A schema needs to be specified when using ").append(className).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable userSpecifiedSchemaMismatchActualSchemaError(StructType schema, StructType actualSchema) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(306).append("\n         |The user-specified schema doesn't match the actual schema:\n         |user-specified: ").append(schema.toDDL()).append(", actual: ").append(actualSchema.toDDL()).append(". If you're using\n         |DataFrameReader.schema API or creating a table, please do not specify the schema.\n         |Or if you're scanning an existed table, please drop it and re-create it.\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable dataSchemaNotSpecifiedError(String format, String fileCatalog) {
        return new AnalysisException(new java.lang.StringBuilder(62).append("Unable to infer schema for ").append(format).append(" at ").append(fileCatalog).append(". It must be specified manually").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidDataSourceError(String className) {
        return new AnalysisException(new java.lang.StringBuilder(38).append(className).append(" is not a valid Spark SQL Data Source.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotSaveIntervalIntoExternalStorageError() {
        return new AnalysisException("Cannot save interval data type into external storage.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotResolveAttributeError(String name, String outputStr) {
        return new AnalysisException(new java.lang.StringBuilder(27).append("Unable to resolve ").append(name).append(" given [").append(outputStr).append("]").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable orcNotUsedWithHiveEnabledError() {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString("\n         |Hive built-in ORC data source must be used with Hive support enabled.\n         |Please use the native ORC data source by setting 'spark.sql.orc.impl' to 'native'\n       ")).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable failedToFindAvroDataSourceError(String provider) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(230).append("\n         |Failed to find data source: ").append(provider).append(". Avro is built-in but external data\n         |source module since Spark 2.4. Please deploy the application as per\n         |the deployment section of \"Apache Avro Data Source Guide\".\n       ").toString())).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable failedToFindKafkaDataSourceError(String provider) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(171).append("\n         |Failed to find data source: ").append(provider).append(". Please deploy the application as\n         |per the deployment section of \"Structured Streaming + Kafka Integration Guide\".\n       ").toString())).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable findMultipleDataSourceError(String provider, Seq<String> sourceNames) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(108).append("\n         |Multiple sources found for ").append(provider).append(" (").append(sourceNames.mkString(", ")).append("),\n         | please specify the fully qualified class name.\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable writeEmptySchemasUnsupportedByDataSourceError() {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString("\n         |Datasource does not support writing empty or nested empty schemas.\n         |Please make sure the data schema has at least one or more column(s).\n       ")).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable insertMismatchedColumnNumberError(Seq<Attribute> targetAttributes, Seq<Attribute> sourceAttributes, int staticPartitionsSize) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(278).append("\n         |The data to be inserted needs to have the same number of columns as the\n         |target table: target table has ").append(targetAttributes.size()).append(" column(s) but the\n         |inserted data has ").append(sourceAttributes.size() + staticPartitionsSize).append(" column(s),\n         |which contain ").append(staticPartitionsSize).append(" partition column(s) having assigned\n         |constant values.\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable insertMismatchedPartitionNumberError(StructType targetPartitionSchema, int providedPartitionsSize) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(238).append("\n         |The data to be inserted needs to have the same number of partition columns\n         |as the target table: target table has ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targetPartitionSchema.fields())).size()).append("\n         |partition column(s) but the inserted data has ").append(providedPartitionsSize).append("\n         |partition columns specified.\n       ").toString())).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidPartitionColumnError(String partKey, StructType targetPartitionSchema) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(79).append("\n         |").append(partKey).append(" is not a partition column. Partition columns are\n         |").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targetPartitionSchema.fields())).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ",", "]")).append("\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable multiplePartitionColumnValuesSpecifiedError(StructField field, Map<String, String> potentialSpecs) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(116).append("\n         |Partition column ").append(field.name()).append(" have multiple values specified,\n         |").append(potentialSpecs.mkString("[", ", ", "]")).append(". Please only specify a single value.\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidOrderingForConstantValuePartitionColumnError(StructType targetPartitionSchema) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(222).append("\n         |The ordering of partition columns is\n         |").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targetPartitionSchema.fields())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ",", "]")).append("\n         |All partition columns having constant values need to appear before other\n         |partition columns that do not have an assigned constant value.\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotWriteDataToRelationsWithMultiplePathsError() {
        return new AnalysisException("Can only write data to relations with a single path.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable failedToRebuildExpressionError(Filter filter) {
        return new AnalysisException(new java.lang.StringBuilder(68).append("Fail to rebuild expression: missing key ").append(filter).append(" in `translatedFilterToExpr`").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable dataTypeUnsupportedByDataSourceError(String format, StructField field) {
        return new AnalysisException(new java.lang.StringBuilder(41).append(format).append(" data source does not support ").append(field.dataType().catalogString()).append(" data type.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable failToResolveDataSourceForTableError(CatalogTable table, String key) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(383).append("\n         |Fail to resolve data source for the table ").append(table.identifier()).append(" since the table\n         |serde property has the duplicated key ").append(key).append(" with extra options specified for this\n         |scan operation. To fix this, you can rollback to the legacy behavior of ignoring\n         |the extra options by setting the config\n         |").append(SQLConf$.MODULE$.LEGACY_EXTRA_OPTIONS_BEHAVIOR().key()).append(" to `false`, or address the\n         |conflicts of the same config.\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable outputPathAlreadyExistsError(Path outputPath) {
        return new AnalysisException(new java.lang.StringBuilder(21).append("path ").append(outputPath).append(" already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotUseDataTypeForPartitionColumnError(StructField field) {
        return new AnalysisException(new java.lang.StringBuilder(32).append("Cannot use ").append(field.dataType()).append(" for partition column").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotUseAllColumnsForPartitionColumnsError() {
        return new AnalysisException("Cannot use all columns for partition columns", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable partitionColumnNotFoundInSchemaError(String col, String schemaCatalog) {
        return new AnalysisException(new java.lang.StringBuilder(40).append("Partition column `").append(col).append("` not found in schema ").append(schemaCatalog).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable columnNotFoundInSchemaError(StructField col, Option<StructType> tableSchema) {
        return new AnalysisException(new java.lang.StringBuilder(30).append("Column \"").append(col.name()).append("\" not found in schema ").append(tableSchema).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable unsupportedDataSourceTypeForDirectQueryOnFilesError(String className) {
        return new AnalysisException(new java.lang.StringBuilder(56).append("Unsupported data source type for direct query on files: ").append(className).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable saveDataIntoViewNotAllowedError() {
        return new AnalysisException("Saving data into a view is not allowed.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable mismatchedTableFormatError(String tableName, Class<?> existingProvider, Class<?> specifiedProvider) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(111).append("\n         |The format of the existing table ").append(tableName).append(" is `").append(existingProvider.getSimpleName()).append("`.\n         |It doesn't match the specified format `").append(specifiedProvider.getSimpleName()).append("`.\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable mismatchedTableLocationError(TableIdentifier identifier, CatalogTable existingTable, CatalogTable tableDesc) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(125).append("\n         |The location of the existing table ").append(identifier.quotedString()).append(" is\n         |`").append(existingTable.location()).append("`. It doesn't match the specified location\n         |`").append(tableDesc.location()).append("`.\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable mismatchedTableColumnNumberError(String tableName, CatalogTable existingTable, LogicalPlan query) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(115).append("\n         |The column number of the existing table ").append(tableName).append("\n         |(").append(existingTable.schema().catalogString()).append(") doesn't match the data schema\n         |(").append(query.schema().catalogString()).append(")\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotResolveColumnGivenInputColumnsError(String col, String inputColumns) {
        return new AnalysisException(new java.lang.StringBuilder(41).append("cannot resolve '").append(col).append("' given input columns: [").append(inputColumns).append("]").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable mismatchedTablePartitionColumnError(String tableName, Seq<String> specifiedPartCols, String existingPartCols) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(168).append("\n         |Specified partitioning does not match that of the existing table ").append(tableName).append(".\n         |Specified partition columns: [").append(specifiedPartCols.mkString(", ")).append("]\n         |Existing partition columns: [").append(existingPartCols).append("]\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable mismatchedTableBucketingError(String tableName, String specifiedBucketString, String existingBucketString) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(145).append("\n         |Specified bucketing does not match that of the existing table ").append(tableName).append(".\n         |Specified bucketing: ").append(specifiedBucketString).append("\n         |Existing bucketing: ").append(existingBucketString).append("\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable specifyPartitionNotAllowedWhenTableSchemaNotDefinedError() {
        return new AnalysisException("It is not allowed to specify partitioning when the table schema is not defined.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable bucketingColumnCannotBePartOfPartitionColumnsError(String bucketCol, Seq<String> normalizedPartCols) {
        return new AnalysisException(new java.lang.StringBuilder(62).append("bucketing column '").append(bucketCol).append("' should not be part of ").append("partition columns '").append(normalizedPartCols.mkString(", ")).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable bucketSortingColumnCannotBePartOfPartitionColumnsError(String sortCol, Seq<String> normalizedPartCols) {
        return new AnalysisException(new java.lang.StringBuilder(67).append("bucket sorting column '").append(sortCol).append("' should not be part of ").append("partition columns '").append(normalizedPartCols.mkString(", ")).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable mismatchedInsertedDataColumnNumberError(String tableName, InsertIntoStatement insert, Set<String> staticPartCols) {
        return new AnalysisException(new java.lang.StringBuilder(214).append(tableName).append(" requires that the data to be inserted have the same number of columns as ").append("the target table: target table has ").append(insert.table().output().size()).append(" column(s) but the ").append("inserted data has ").append(insert.query().output().length() + staticPartCols.size()).append(" column(s), ").append("including ").append(staticPartCols.size()).append(" partition column(s) having constant value(s).").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable requestedPartitionsMismatchTablePartitionsError(String tableName, Map<String, Option<String>> normalizedPartSpec, StructType partColNames) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(130).append("\n         |Requested partitioning does not match the table ").append(tableName).append(":\n         |Requested partitions: ").append(normalizedPartSpec.keys().mkString(",")).append("\n         |Table partitions: ").append(partColNames.mkString(",")).append("\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable ddlWithoutHiveSupportEnabledError(String detail) {
        return new AnalysisException(new java.lang.StringBuilder(28).append("Hive support is required to ").append(detail).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable createTableColumnTypesOptionColumnNotFoundInSchemaError(String col, StructType schema) {
        return new AnalysisException(new java.lang.StringBuilder(58).append("createTableColumnTypes option column ").append(col).append(" not found in schema ").append(schema.catalogString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable parquetTypeUnsupportedYetError(String parquetType) {
        return new AnalysisException(new java.lang.StringBuilder(32).append("Parquet type not yet supported: ").append(parquetType).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable illegalParquetTypeError(String parquetType) {
        return new AnalysisException(new java.lang.StringBuilder(22).append("Illegal Parquet type: ").append(parquetType).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable unrecognizedParquetTypeError(String field) {
        return new AnalysisException(new java.lang.StringBuilder(27).append("Unrecognized Parquet type: ").append(field).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotConvertDataTypeToParquetTypeError(StructField field) {
        return new AnalysisException(new java.lang.StringBuilder(22).append("Unsupported data type ").append(field.dataType().catalogString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable incompatibleViewSchemaChange(String viewName, String colName, int expectedNum, Seq<Attribute> actualCols, Option<String> viewDDL) {
        return new AnalysisException(new java.lang.StringBuilder(122).append("The SQL query of view ").append(viewName).append(" has an incompatible schema change ").append("and column ").append(colName).append(" cannot be resolved. Expected ").append(expectedNum).append(" columns named ").append(colName).append(" but ").append("got ").append(((TraversableOnce)actualCols.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]")).append(viewDDL.map((Function1 & Serializable & scala.Serializable)s -> new java.lang.StringBuilder(46).append("\nPlease try to re-create the view by running: ").append((String)s).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable numberOfPartitionsNotAllowedWithUnspecifiedDistributionError() {
        throw new AnalysisException("The number of partitions can't be specified with unspecified distribution. Invalid writer requirements detected.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotApplyTableValuedFunctionError(String name, String arguments, String usage, String details) {
        return new AnalysisException(new java.lang.StringBuilder(68).append("Table-valued function ").append(name).append(" with alternatives: ").append(usage).append("\n").append("cannot be applied to (").append(arguments).append("): ").append(details).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public String cannotApplyTableValuedFunctionError$default$4() {
        return "";
    }

    public Throwable incompatibleRangeInputDataTypeError(Expression expression, DataType dataType) {
        return new AnalysisException(new java.lang.StringBuilder(49).append("Incompatible input data type. ").append("Expected: ").append(dataType.typeName()).append("; Found: ").append(expression.dataType().typeName()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable groupAggPandasUDFUnsupportedByStreamingAggError() {
        return new AnalysisException("Streaming aggregation doesn't support group aggregate pandas UDF", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable streamJoinStreamWithoutEqualityPredicateUnsupportedError(LogicalPlan plan2) {
        String x$1 = "Stream-stream join without equality predicate is not supported";
        Some x$2 = new Some((Object)plan2);
        Option<Object> x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option<Object> x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option<Throwable> x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$5();
        Option<String> x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$6();
        String[] x$7 = AnalysisException$.MODULE$.$lessinit$greater$default$7();
        return new AnalysisException(x$1, x$3, x$4, (Option<LogicalPlan>)x$2, x$5, x$6, x$7);
    }

    public Throwable cannotUseMixtureOfAggFunctionAndGroupAggPandasUDFError() {
        return new AnalysisException("Cannot use a mixture of aggregate function and group aggregate pandas UDF", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable ambiguousAttributesInSelfJoinError(Seq<AttributeReference> ambiguousAttrs) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(524).append("\n         |Column ").append(ambiguousAttrs.mkString(", ")).append(" are ambiguous. It's probably because\n         |you joined several Datasets together, and some of these Datasets are the same.\n         |This column points to one of the Datasets but Spark is unable to figure out\n         |which one. Please alias the Datasets with different names via `Dataset.as`\n         |before joining them, and specify the column using qualified name, e.g.\n         |`df.as(\"a\").join(df.as(\"b\"), $\"a.id\" > $\"b.id\")`. You can also set\n         |").append(SQLConf$.MODULE$.FAIL_AMBIGUOUS_SELF_JOIN_ENABLED().key()).append(" to false to disable this check.\n       ").toString())).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable unexpectedEvalTypesForUDFsError(Set<Object> evalTypes) {
        return new AnalysisException(new java.lang.StringBuilder(66).append("Expected udfs have the same evalType but got different evalTypes: ").append(evalTypes.mkString(",")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable ambiguousFieldNameError(Seq<String> fieldName, int numMatches, Origin context) {
        return new AnalysisException("AMBIGUOUS_FIELD_NAME", (String[])((Object[])new String[]{CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(fieldName).quoted(), Integer.toString(numMatches)}), context);
    }

    public Throwable cannotUseIntervalTypeInTableSchemaError() {
        return new AnalysisException("Cannot use interval type in the table schema.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotConvertBucketWithSortColumnsToTransformError(BucketSpec spec) {
        return new AnalysisException(new java.lang.StringBuilder(59).append("Cannot convert bucketing with sort columns to a transform: ").append(spec).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotConvertTransformsToPartitionColumnsError(Seq<Transform> nonIdTransforms) {
        return new AnalysisException(new java.lang.StringBuilder(53).append("Transforms cannot be converted to partition columns: ").append(((TraversableOnce)nonIdTransforms.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.describe(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotPartitionByNestedColumnError(NamedReference reference) {
        return new AnalysisException(new java.lang.StringBuilder(35).append("Cannot partition by nested column: ").append(reference).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotUseCatalogError(CatalogPlugin plugin, String msg) {
        return new AnalysisException(new java.lang.StringBuilder(21).append("Cannot use catalog ").append(plugin.name()).append(": ").append(msg).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable identifierHavingMoreThanTwoNamePartsError(String quoted, String identifier) {
        return new AnalysisException(new java.lang.StringBuilder(50).append(quoted).append(" is not a valid ").append(identifier).append(" as it has more than 2 name parts.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable emptyMultipartIdentifierError() {
        return new AnalysisException("multi-part identifier cannot be empty.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable functionUnsupportedInV2CatalogError() {
        return new AnalysisException("function is only supported in v1 catalog", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotOperateOnHiveDataSourceFilesError(String operation) {
        return new AnalysisException(new java.lang.StringBuilder(95).append("Hive data source can only be used with tables, you can not ").append(operation).append(" files of Hive data source directly.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable setPathOptionAndCallWithPathParameterError(String method) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(212).append("\n         |There is a 'path' option set and ").append(method).append("() is called with a path\n         |parameter. Either remove the path option, or call ").append(method).append("() without the parameter.\n         |To ignore this check, set '").append(SQLConf$.MODULE$.LEGACY_PATH_OPTION_BEHAVIOR().key()).append("' to 'true'.\n       ").toString())).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable userSpecifiedSchemaUnsupportedError(String operation) {
        return new AnalysisException(new java.lang.StringBuilder(43).append("User specified schema not supported with `").append(operation).append("`").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable tempViewNotSupportStreamingWriteError(String viewName) {
        return new AnalysisException(new java.lang.StringBuilder(47).append("Temporary view ").append(viewName).append(" doesn't support streaming write").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable streamingIntoViewNotSupportedError(String viewName) {
        return new AnalysisException(new java.lang.StringBuilder(39).append("Streaming into views ").append(viewName).append(" is not supported.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable inputSourceDiffersFromDataSourceProviderError(String source, String tableName, CatalogTable table) {
        return new AnalysisException(new java.lang.StringBuilder(73).append("The input source(").append(source).append(") is different from the table ").append(tableName).append("'s data source provider(").append(table.provider().get()).append(").").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable tableNotSupportStreamingWriteError(String tableName, Table t) {
        return new AnalysisException(new java.lang.StringBuilder(41).append("Table ").append(tableName).append(" doesn't support streaming write - ").append(t).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable queryNameNotSpecifiedForMemorySinkError() {
        return new AnalysisException("queryName must be specified for memory sink", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable sourceNotSupportedWithContinuousTriggerError(String source) {
        return new AnalysisException(new java.lang.StringBuilder(43).append("'").append(source).append("' is not supported with continuous trigger").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable columnNotFoundInExistingColumnsError(String columnType, String columnName, Seq<String> validColumnNames) {
        return new AnalysisException(new java.lang.StringBuilder(41).append(columnType).append(" column ").append(columnName).append(" not found in ").append("existing columns (").append(validColumnNames.mkString(", ")).append(")").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable operationNotSupportPartitioningError(String operation) {
        return new AnalysisException(new java.lang.StringBuilder(32).append("'").append(operation).append("' does not support partitioning").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable mixedRefsInAggFunc(String funcStr) {
        String msg = new java.lang.StringBuilder(120).append("Found an aggregate function in a correlated predicate that has both outer and local references, which is not supported: ").append(funcStr).toString();
        return new AnalysisException(msg, AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable lookupFunctionInNonFunctionCatalogError(Identifier ident, CatalogPlugin catalog) {
        return new AnalysisException(new java.lang.StringBuilder(76).append("Trying to lookup function '").append(ident).append("' in ").append("catalog '").append(catalog.name()).append("', but it is not a FunctionCatalog.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable functionCannotProcessInputError(UnboundFunction unbound, Seq<Expression> arguments, UnsupportedOperationException unsupported) {
        String x$1 = new java.lang.StringBuilder(38).append("Function '").append(unbound.name()).append("' cannot process ").append("input: (").append(((TraversableOnce)arguments.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.dataType().simpleString(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("): ").append(unsupported.getMessage()).toString();
        Some x$2 = new Some((Object)unsupported);
        Option<Object> x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option<Object> x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option<LogicalPlan> x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
        Option<String> x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$6();
        String[] x$7 = AnalysisException$.MODULE$.$lessinit$greater$default$7();
        return new AnalysisException(x$1, x$3, x$4, x$5, (Option<Throwable>)x$2, x$6, x$7);
    }

    public Throwable v2FunctionInvalidInputTypeLengthError(BoundFunction bound, Seq<Expression> args) {
        return new AnalysisException(new java.lang.StringBuilder(91).append("Invalid bound function '").append(bound.name()).append(": there are ").append(args.length()).append(" ").append("arguments but ").append(bound.inputTypes().length).append(" parameters returned from 'inputTypes()'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable ambiguousRelationAliasNameInNestedCTEError(String name) {
        return new AnalysisException(new java.lang.StringBuilder(208).append("Name ").append(name).append(" is ambiguous in nested CTE. ").append("Please set ").append(SQLConf$.MODULE$.LEGACY_CTE_PRECEDENCE_POLICY().key()).append(" to CORRECTED so that name ").append("defined in inner CTE takes precedence. If set it to LEGACY, outer CTE ").append("definitions will take precedence. See more details in SPARK-28228.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable commandUnsupportedInV2TableError(String name) {
        return new AnalysisException(new java.lang.StringBuilder(32).append(name).append(" is not supported for v2 tables.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotResolveColumnNameAmongAttributesError(String colName, String fieldNames) {
        return new AnalysisException(new java.lang.StringBuilder(38).append("Cannot resolve column name \"").append(colName).append("\" among (").append(fieldNames).append(")").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotWriteTooManyColumnsToTableError(String tableName, Seq<Attribute> expected, LogicalPlan query) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(112).append("\n         |Cannot write to '").append(tableName).append("', too many data columns:\n         |Table columns: ").append(((TraversableOnce)expected.map((Function1 & Serializable & scala.Serializable)c -> new java.lang.StringBuilder(2).append("'").append(c.name()).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("\n         |Data columns: ").append(((TraversableOnce)query.output().map((Function1 & Serializable & scala.Serializable)c -> new java.lang.StringBuilder(2).append("'").append(c.name()).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotWriteNotEnoughColumnsToTableError(String tableName, Seq<Attribute> expected, LogicalPlan query) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(95).append("Cannot write to '").append(tableName).append("', not enough data columns:\n         |Table columns: ").append(((TraversableOnce)expected.map((Function1 & Serializable & scala.Serializable)c -> new java.lang.StringBuilder(2).append("'").append(c.name()).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("\n         |Data columns: ").append(((TraversableOnce)query.output().map((Function1 & Serializable & scala.Serializable)c -> new java.lang.StringBuilder(2).append("'").append(c.name()).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotWriteIncompatibleDataToTableError(String tableName, Seq<String> errors) {
        return new AnalysisException(new java.lang.StringBuilder(46).append("Cannot write incompatible data to table '").append(tableName).append("':\n- ").append(errors.mkString("\n- ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable secondArgumentOfFunctionIsNotIntegerError(String function, NumberFormatException e) {
        return new AnalysisException("SECOND_FUNCTION_ARGUMENT_NOT_INTEGER", (String[])((Object[])new String[]{function}), (Option<Throwable>)new Some((Object)e));
    }

    public Throwable nonPartitionPruningPredicatesNotExpectedError(Seq<Expression> nonPartitionPruningPredicates) {
        return new AnalysisException(new java.lang.StringBuilder(44).append("Expected only partition pruning predicates: ").append(nonPartitionPruningPredicates).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable columnNotDefinedInTableError(String colType, String colName, String tableName, Seq<String> tableCols) {
        return new AnalysisException(new java.lang.StringBuilder(62).append(colType).append(" column ").append(colName).append(" is not defined in table ").append(tableName).append(", ").append("defined table columns are: ").append(tableCols.mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidLiteralForWindowDurationError() {
        return new AnalysisException("The duration and time inputs to window must be an integer, long or string literal.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable noSuchStructFieldInGivenFieldsError(String fieldName, StructField[] fields) {
        return new AnalysisException(new java.lang.StringBuilder(25).append("No such struct field ").append(fieldName).append(" in ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable ambiguousReferenceToFieldsError(String fields) {
        return new AnalysisException(new java.lang.StringBuilder(30).append("Ambiguous reference to fields ").append(fields).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable secondArgumentInFunctionIsNotBooleanLiteralError(String funcName) {
        return new AnalysisException(new java.lang.StringBuilder(52).append("The second argument in ").append(funcName).append(" should be a boolean literal.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable joinConditionMissingOrTrivialError(Join join, LogicalPlan left, LogicalPlan right) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(378).append("Detected implicit cartesian product for ").append(join.joinType().sql()).append(" join between logical plans\n         |").append(left.treeString(false, left.treeString$default$2(), left.treeString$default$3(), left.treeString$default$4()).trim()).append("\n         |and\n         |").append(right.treeString(false, right.treeString$default$2(), right.treeString$default$3(), right.treeString$default$4()).trim()).append("\n         |Join condition is missing or trivial.\n         |Either: use the CROSS JOIN syntax to allow cartesian products between these\n         |relations, or: enable implicit cartesian products by setting the configuration\n         |variable spark.sql.crossJoin.enabled=true").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable usePythonUDFInJoinConditionUnsupportedError(JoinType joinType) {
        return new AnalysisException(new java.lang.StringBuilder(65).append("Using PythonUDF in join condition of join type").append(" ").append(joinType).append(" is not supported.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable conflictingAttributesInJoinConditionError(AttributeSet conflictingAttrs, LogicalPlan outerPlan, LogicalPlan subplan) {
        return new AnalysisException(new java.lang.StringBuilder(85).append("Found conflicting attributes ").append(conflictingAttrs.mkString(",")).append(" in the condition joining outer plan:\n  ").append(outerPlan).append("\nand subplan:\n  ").append(subplan).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable emptyWindowExpressionError(Window expr) {
        return new AnalysisException(new java.lang.StringBuilder(30).append("Window expression is empty in ").append(expr).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable foundDifferentWindowFunctionTypeError(Seq<NamedExpression> windowExpressions) {
        return new AnalysisException(new java.lang.StringBuilder(40).append("Found different window function type in ").append(windowExpressions).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable charOrVarcharTypeAsStringUnsupportedError() {
        return new AnalysisException(new java.lang.StringBuilder(150).append("char/varchar type can only be used in the table schema. ").append("You can set ").append(SQLConf$.MODULE$.LEGACY_CHAR_VARCHAR_AS_STRING().key()).append(" to true, so that Spark").append(" treat them as string type as same as Spark 3.0 and earlier").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidPatternError(String pattern, String message) {
        return new AnalysisException(new java.lang.StringBuilder(27).append("the pattern '").append(pattern).append("' is invalid, ").append(message).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable tableIdentifierExistsError(TableIdentifier tableIdentifier) {
        return new AnalysisException(new java.lang.StringBuilder(16).append(tableIdentifier).append(" already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable tableIdentifierNotConvertedToHadoopFsRelationError(TableIdentifier tableIdentifier) {
        return new AnalysisException(new java.lang.StringBuilder(41).append(tableIdentifier).append(" should be converted to HadoopFsRelation.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable alterDatabaseLocationUnsupportedError(String version) {
        return new AnalysisException(new java.lang.StringBuilder(49).append("Hive ").append(version).append(" does not support altering database location").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable hiveTableTypeUnsupportedError(String tableType) {
        return new AnalysisException(new java.lang.StringBuilder(23).append("Hive ").append(tableType).append(" is not supported.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable hiveCreatePermanentFunctionsUnsupportedError() {
        return new AnalysisException("Hive 0.12 doesn't support creating permanent functions. Please use Hive 0.13 or higher.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable unknownHiveResourceTypeError(String resourceType) {
        return new AnalysisException(new java.lang.StringBuilder(23).append("Unknown resource type: ").append(resourceType).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidDayTimeField(byte field) {
        Seq supportedIds = (Seq)DayTimeIntervalType$.MODULE$.dayTimeFields().map((Function1 & Serializable & scala.Serializable)i -> QueryCompilationErrors$.$anonfun$invalidDayTimeField$1(BoxesRunTime.unboxToByte((Object)i)), Seq$.MODULE$.canBuildFrom());
        return new AnalysisException(new java.lang.StringBuilder(70).append("Invalid field id '").append(field).append("' in day-time interval. ").append("Supported interval fields: ").append(supportedIds.mkString(", ")).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidDayTimeIntervalType(String startFieldName, String endFieldName) {
        return new AnalysisException(new java.lang.StringBuilder(27).append("'interval ").append(startFieldName).append(" to ").append(endFieldName).append("' is invalid.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidYearMonthField(byte field) {
        Seq supportedIds = (Seq)YearMonthIntervalType$.MODULE$.yearMonthFields().map((Function1 & Serializable & scala.Serializable)i -> QueryCompilationErrors$.$anonfun$invalidYearMonthField$1(BoxesRunTime.unboxToByte((Object)i)), Seq$.MODULE$.canBuildFrom());
        return new AnalysisException(new java.lang.StringBuilder(72).append("Invalid field id '").append(field).append("' in year-month interval. ").append("Supported interval fields: ").append(supportedIds.mkString(", ")).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidYearMonthIntervalType(String startFieldName, String endFieldName) {
        return new AnalysisException(new java.lang.StringBuilder(27).append("'interval ").append(startFieldName).append(" to ").append(endFieldName).append("' is invalid.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable configRemovedInVersionError(String configName, String version, String comment) {
        return new AnalysisException(new java.lang.StringBuilder(47).append("The SQL config '").append(configName).append("' was removed in the version ").append(version).append(". ").append(comment).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable failedFallbackParsingError(String msg, Throwable e1, Throwable e2) {
        String x$1 = new java.lang.StringBuilder(26).append(msg).append(e1.getMessage()).append("\nFailed fallback parsing: ").append(e2.getMessage()).toString();
        Some x$2 = new Some((Object)e1.getCause());
        Option<Object> x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option<Object> x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option<LogicalPlan> x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
        Option<String> x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$6();
        String[] x$7 = AnalysisException$.MODULE$.$lessinit$greater$default$7();
        return new AnalysisException(x$1, x$3, x$4, x$5, (Option<Throwable>)x$2, x$6, x$7);
    }

    public Throwable decimalCannotGreaterThanPrecisionError(int scale, int precision) {
        return new AnalysisException(new java.lang.StringBuilder(53).append("Decimal scale (").append(scale).append(") cannot be greater than precision (").append(precision).append(").").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable decimalOnlySupportPrecisionUptoError(String decimalType, int precision) {
        return new AnalysisException(new java.lang.StringBuilder(34).append(decimalType).append(" can only support precision up to ").append(precision).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable negativeScaleNotAllowedError(int scale) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(106).append("|Negative scale is not allowed: ").append(scale).append(".\n         |You can use ").append(SQLConf$.MODULE$.LEGACY_ALLOW_NEGATIVE_SCALE_OF_DECIMAL_ENABLED().key()).append("=true\n         |to enable legacy mode to allow it.").toString())).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidPartitionColumnKeyInTableError(String key, String tblName) {
        return new AnalysisException(new java.lang.StringBuilder(43).append(key).append(" is not a valid partition column in table ").append(tblName).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidPartitionSpecError(String specKeys, Seq<String> partitionColumnNames, String tableName) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(110).append("|Partition spec is invalid. The spec (").append(specKeys).append(") must match\n        |the partition spec (").append(partitionColumnNames.mkString(", ")).append(") defined in\n        |table '").append(tableName).append("'").toString())).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable foundDuplicateColumnError(String colType, Seq<String> duplicateCol) {
        return new AnalysisException(new java.lang.StringBuilder(28).append("Found duplicate column(s) ").append(colType).append(": ").append(((TraversableOnce)duplicateCol.sorted((Ordering)Ordering.String$.MODULE$)).mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable noSuchTableError(String db, String table) {
        return new NoSuchTableException(db, table);
    }

    public Throwable tempViewNotCachedForAnalyzingColumnsError(TableIdentifier tableIdent) {
        return new AnalysisException(new java.lang.StringBuilder(52).append("Temporary view ").append(tableIdent).append(" is not cached for analyzing columns.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable columnTypeNotSupportStatisticsCollectionError(String name, TableIdentifier tableIdent, DataType dataType) {
        return new AnalysisException(new java.lang.StringBuilder(100).append("Column ").append(name).append(" in table ").append(tableIdent).append(" is of type ").append(dataType).append(", ").append("and Spark does not support statistics collection on this column type.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable analyzeTableNotSupportedOnViewsError() {
        return new AnalysisException("ANALYZE TABLE is not supported on views.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable unexpectedPartitionColumnPrefixError(String table, String database, String schemaColumns, String specColumns) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(270).append("\n         |The list of partition columns with values\n         |in partition specification for table '").append(table).append("'\n         |in database '").append(database).append("' is not a prefix of the list of\n         |partition columns defined in the table schema.\n         |Expected a prefix of [").append(schemaColumns).append("], but got [").append(specColumns).append("].\n       ").toString())).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable noSuchPartitionError(String db, String table, Map<String, String> partition) {
        return new NoSuchPartitionException(db, table, partition);
    }

    public Throwable analyzingColumnStatisticsNotSupportedForColumnTypeError(String name, DataType dataType) {
        return new AnalysisException(new java.lang.StringBuilder(72).append("Analyzing column statistics is not supported for column ").append(name).append(" of data type: ").append(dataType).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable tableAlreadyExistsError(String table, String guide) {
        return new AnalysisException(new java.lang.StringBuilder(22).append("Table ").append(table).append(" already exists.").append(guide).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable createTableAsSelectWithNonEmptyDirectoryError(String tablePath) {
        return new AnalysisException(new java.lang.StringBuilder(155).append("CREATE-TABLE-AS-SELECT cannot create table with location to a non-empty directory ").append(tablePath).append(" . To allow overwriting the existing non-empty directory, ").append("set '").append(SQLConf$.MODULE$.ALLOW_NON_EMPTY_LOCATION_IN_CTAS().key()).append("' to true.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable tableOrViewNotFoundError(String table) {
        return new AnalysisException(new java.lang.StringBuilder(25).append("Table or view not found: ").append(table).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable unsetNonExistentPropertyError(String property, TableIdentifier table) {
        return new AnalysisException(new java.lang.StringBuilder(55).append("Attempted to unset non-existent property '").append(property).append("' in table '").append(table).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable alterTableChangeColumnNotSupportedForColumnTypeError(StructField originColumn, StructField newColumn) {
        return new AnalysisException(new java.lang.StringBuilder(97).append("ALTER TABLE CHANGE COLUMN is not supported for changing column ").append("'").append(originColumn.name()).append("' with type '").append(originColumn.dataType()).append("' to ").append("'").append(newColumn.name()).append("' with type '").append(newColumn.dataType()).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotFindColumnError(String name, String[] fieldNames) {
        return new AnalysisException(new java.lang.StringBuilder(46).append("Can't find column `").append(name).append("` given table data columns ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).mkString("[`", "`, `", "`]")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable alterTableSetSerdeForSpecificPartitionNotSupportedError() {
        return new AnalysisException("Operation not allowed: ALTER TABLE SET [SERDE | SERDEPROPERTIES] for a specific partition is not supported for tables created with the datasource API", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable alterTableSetSerdeNotSupportedError() {
        return new AnalysisException("Operation not allowed: ALTER TABLE SET SERDE is not supported for tables created with the datasource API", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cmdOnlyWorksOnPartitionedTablesError(String cmd, String tableIdentWithDB) {
        return new AnalysisException(new java.lang.StringBuilder(58).append("Operation not allowed: ").append(cmd).append(" only works on partitioned tables: ").append(tableIdentWithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cmdOnlyWorksOnTableWithLocationError(String cmd, String tableIdentWithDB) {
        return new AnalysisException(new java.lang.StringBuilder(68).append("Operation not allowed: ").append(cmd).append(" only works on table with ").append("location provided: ").append(tableIdentWithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable actionNotAllowedOnTableWithFilesourcePartitionManagementDisabledError(String action, String tableName) {
        return new AnalysisException(new java.lang.StringBuilder(122).append(action).append(" is not allowed on ").append(tableName).append(" since filesource partition management is ").append("disabled (spark.sql.hive.manageFilesourcePartitions = false).").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable actionNotAllowedOnTableSincePartitionMetadataNotStoredError(String action, String tableName) {
        return new AnalysisException(new java.lang.StringBuilder(157).append(action).append(" is not allowed on ").append(tableName).append(" since its partition metadata is not stored in ").append("the Hive metastore. To import this information into the metastore, run ").append("`msck repair table ").append(tableName).append("`").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotAlterViewWithAlterTableError() {
        return new AnalysisException("Cannot alter a view with ALTER TABLE. Please use ALTER VIEW instead", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotAlterTableWithAlterViewError() {
        return new AnalysisException("Cannot alter a table with ALTER VIEW. Please use ALTER TABLE instead", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotOverwritePathBeingReadFromError() {
        return new AnalysisException("Cannot overwrite a path that is also being read from.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable createFuncWithBothIfNotExistsAndReplaceError() {
        return new AnalysisException("CREATE FUNCTION with both IF NOT EXISTS and REPLACE is not allowed.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable defineTempFuncWithIfNotExistsError() {
        return new AnalysisException("It is not allowed to define a TEMPORARY function with IF NOT EXISTS.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable specifyingDBInCreateTempFuncError(String databaseName) {
        return new AnalysisException(new java.lang.StringBuilder(69).append("Specifying a database in CREATE TEMPORARY FUNCTION is not allowed: '").append(databaseName).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable specifyingDBInDropTempFuncError(String databaseName) {
        return new AnalysisException(new java.lang.StringBuilder(67).append("Specifying a database in DROP TEMPORARY FUNCTION is not allowed: '").append(databaseName).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotDropNativeFuncError(String functionName) {
        return new AnalysisException(new java.lang.StringBuilder(30).append("Cannot drop native function '").append(functionName).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotRefreshBuiltInFuncError(String functionName) {
        return new AnalysisException(new java.lang.StringBuilder(33).append("Cannot refresh built-in function ").append(functionName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotRefreshTempFuncError(String functionName) {
        return new AnalysisException(new java.lang.StringBuilder(34).append("Cannot refresh temporary function ").append(functionName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable noSuchFunctionError(FunctionIdentifier identifier) {
        return new NoSuchFunctionException((String)identifier.database().get(), identifier.funcName(), NoSuchFunctionException$.MODULE$.$lessinit$greater$default$3());
    }

    public Throwable alterAddColNotSupportViewError(TableIdentifier table) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(144).append("\n         |ALTER ADD COLUMNS does not support views.\n         |You must drop and re-create the views for adding the new columns. Views: ").append(table).append("\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable alterAddColNotSupportDatasourceTableError(Object tableType, TableIdentifier table) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(167).append("\n         |ALTER ADD COLUMNS does not support datasource table with type ").append(tableType).append(".\n         |You must drop and re-create the table for adding the new columns. Tables: ").append(table).append("\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable loadDataNotSupportedForDatasourceTablesError(String tableIdentWithDB) {
        return new AnalysisException(new java.lang.StringBuilder(50).append("LOAD DATA is not supported for datasource tables: ").append(tableIdentWithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable loadDataWithoutPartitionSpecProvidedError(String tableIdentWithDB) {
        return new AnalysisException(new java.lang.StringBuilder(73).append("LOAD DATA target table ").append(tableIdentWithDB).append(" is partitioned, ").append("but no partition spec is provided").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable loadDataPartitionSizeNotMatchNumPartitionColumnsError(String tableIdentWithDB, int partitionSize, int targetTableSize) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(185).append("\n         |LOAD DATA target table ").append(tableIdentWithDB).append(" is partitioned,\n         |but number of columns in provided partition spec (").append(partitionSize).append(")\n         |do not match number of partitioned columns in table (").append(targetTableSize).append(")\n       ").toString())).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable loadDataTargetTableNotPartitionedButPartitionSpecWasProvidedError(String tableIdentWithDB) {
        return new AnalysisException(new java.lang.StringBuilder(78).append("LOAD DATA target table ").append(tableIdentWithDB).append(" is not ").append("partitioned, but a partition spec was provided.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable loadDataInputPathNotExistError(String path) {
        return new AnalysisException(new java.lang.StringBuilder(37).append("LOAD DATA input path does not exist: ").append(path).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable truncateTableOnExternalTablesError(String tableIdentWithDB) {
        return new AnalysisException(new java.lang.StringBuilder(58).append("Operation not allowed: TRUNCATE TABLE on external tables: ").append(tableIdentWithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable truncateTablePartitionNotSupportedForNotPartitionedTablesError(String tableIdentWithDB) {
        return new AnalysisException(new java.lang.StringBuilder(106).append("Operation not allowed: TRUNCATE TABLE ... PARTITION is not supported").append(" for tables that are not partitioned: ").append(tableIdentWithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable failToTruncateTableWhenRemovingDataError(String tableIdentWithDB, Path path, Throwable e) {
        return new AnalysisException(new java.lang.StringBuilder(70).append("Failed to truncate table ").append(tableIdentWithDB).append(" when ").append("removing data of the path: ").append(path).append(" because of ").append(e.toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable descPartitionNotAllowedOnTempView(String table) {
        return new AnalysisException(new java.lang.StringBuilder(51).append("DESC PARTITION is not allowed on a temporary view: ").append(table).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable descPartitionNotAllowedOnView(String table) {
        return new AnalysisException(new java.lang.StringBuilder(41).append("DESC PARTITION is not allowed on a view: ").append(table).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable showPartitionNotAllowedOnTableNotPartitionedError(String tableIdentWithDB) {
        return new AnalysisException(new java.lang.StringBuilder(67).append("SHOW PARTITIONS is not allowed on a table that is not partitioned: ").append(tableIdentWithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable showCreateTableNotSupportedOnTempView(String table) {
        return new AnalysisException(new java.lang.StringBuilder(56).append("SHOW CREATE TABLE is not supported on a temporary view: ").append(table).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable showCreateTableFailToExecuteUnsupportedFeatureError(CatalogTable table) {
        return new AnalysisException(new java.lang.StringBuilder(191).append("Failed to execute SHOW CREATE TABLE against table ").append(table.identifier()).append(", which is created by Hive and uses the ").append("following unsupported feature(s)\n").append(((TraversableOnce)table.unsupportedFeatures().map((Function1 & Serializable & scala.Serializable)x$11 -> new java.lang.StringBuilder(3).append(" - ").append((String)x$11).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append(". ").append("Please use `SHOW CREATE TABLE ").append(table.identifier()).append(" AS SERDE` to show Hive DDL instead.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable showCreateTableNotSupportTransactionalHiveTableError(CatalogTable table) {
        return new AnalysisException(new java.lang.StringBuilder(126).append("SHOW CREATE TABLE doesn't support transactional Hive table. ").append("Please use `SHOW CREATE TABLE ").append(table.identifier()).append(" AS SERDE` ").append("to show Hive DDL instead.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable showCreateTableFailToExecuteUnsupportedConfError(TableIdentifier table, StringBuilder builder) {
        return new AnalysisException(new java.lang.StringBuilder(132).append("Failed to execute SHOW CREATE TABLE against table ").append(table.identifier()).append(", which is created by Hive and uses the ").append("following unsupported serde configuration\n").append(builder.toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable descPartitionNotAllowedOnViewError(String table) {
        return new AnalysisException(new java.lang.StringBuilder(41).append("DESC PARTITION is not allowed on a view: ").append(table).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable showCreateTableAsSerdeNotAllowedOnSparkDataSourceTableError(TableIdentifier table) {
        return new AnalysisException(new java.lang.StringBuilder(82).append(table).append(" is a Spark data source table. Use `SHOW CREATE TABLE` without `AS SERDE` instead.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable showCreateTableOrViewFailToExecuteUnsupportedFeatureError(CatalogTable table, Seq<String> features) {
        return new AnalysisException(new java.lang.StringBuilder(128).append("Failed to execute SHOW CREATE TABLE against table/view ").append(table.identifier()).append(", ").append("which is created by Hive and uses the following unsupported feature(s)\n").append(((TraversableOnce)features.map((Function1 & Serializable & scala.Serializable)x$12 -> new java.lang.StringBuilder(3).append(" - ").append((String)x$12).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable createViewWithBothIfNotExistsAndReplaceError() {
        return new AnalysisException("CREATE VIEW with both IF NOT EXISTS and REPLACE is not allowed.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable defineTempViewWithIfNotExistsError() {
        return new AnalysisException("It is not allowed to define a TEMPORARY view with IF NOT EXISTS.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable notAllowedToAddDBPrefixForTempViewError(String database) {
        return new AnalysisException(new java.lang.StringBuilder(72).append("It is not allowed to add database prefix `").append(database).append("` for the TEMPORARY view name.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable logicalPlanForViewNotAnalyzedError() {
        return new AnalysisException("The logical plan that represents the view is not analyzed.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable createViewNumColumnsMismatchUserSpecifiedColumnLengthError(int analyzedPlanLength, int userSpecifiedColumnsLength) {
        return new AnalysisException(new java.lang.StringBuilder(139).append("The number of columns produced by the SELECT clause ").append("(num: `").append(analyzedPlanLength).append("`) does not match the number of column names ").append("specified by CREATE VIEW (num: `").append(userSpecifiedColumnsLength).append("`).").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable tableIsNotViewError(TableIdentifier name) {
        return new AnalysisException(new java.lang.StringBuilder(14).append(name).append(" is not a view").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable viewAlreadyExistsError(TableIdentifier name) {
        return new AnalysisException(new java.lang.StringBuilder(118).append("View ").append(name).append(" already exists. If you want to update the view definition, ").append("please use ALTER VIEW AS or CREATE OR REPLACE VIEW AS").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable createPersistedViewFromDatasetAPINotAllowedError() {
        return new AnalysisException("It is not allowed to create a persisted view from the Dataset API", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable recursiveViewDetectedError(TableIdentifier viewIdent, Seq<TableIdentifier> newPath) {
        return new AnalysisException(new java.lang.StringBuilder(34).append("Recursive view ").append(viewIdent).append(" detected ").append("(cycle: ").append(newPath.mkString(" -> ")).append(")").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable notAllowedToCreatePermanentViewWithoutAssigningAliasForExpressionError(TableIdentifier name, String attrName) {
        return new AnalysisException(new java.lang.StringBuilder(93).append("Not allowed to create a permanent view ").append(name).append(" without ").append("explicitly assigning an alias for expression ").append(attrName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable notAllowedToCreatePermanentViewByReferencingTempViewError(TableIdentifier name, String nameParts) {
        return new AnalysisException(new java.lang.StringBuilder(127).append("Not allowed to create a permanent view ").append(name).append(" by ").append("referencing a temporary view ").append(nameParts).append(". ").append("Please create a temp view instead by CREATE TEMP VIEW").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable notAllowedToCreatePermanentViewByReferencingTempFuncError(TableIdentifier name, String funcName) {
        return new AnalysisException(new java.lang.StringBuilder(78).append("Not allowed to create a permanent view ").append(name).append(" by ").append("referencing a temporary function `").append(funcName).append("`").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable queryFromRawFilesIncludeCorruptRecordColumnError() {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString("\n        |Since Spark 2.3, the queries from raw JSON/CSV files are disallowed when the\n        |referenced columns only include the internal corrupt record column\n        |(named _corrupt_record by default). For example:\n        |spark.read.schema(schema).csv(file).filter($\"_corrupt_record\".isNotNull).count()\n        |and spark.read.schema(schema).csv(file).select(\"_corrupt_record\").show().\n        |Instead, you can cache or save the parsed results and then send the same query.\n        |For example, val df = spark.read.schema(schema).csv(file).cache() and then\n        |df.filter($\"_corrupt_record\".isNotNull).count().\n      ")).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable userDefinedPartitionNotFoundInJDBCRelationError(String columnName, String schema) {
        return new AnalysisException(new java.lang.StringBuilder(63).append("User-defined partition column ").append(columnName).append(" not ").append("found in the JDBC relation: ").append(schema).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidPartitionColumnTypeError(StructField column) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(91).append("\n         |Partition column type should be ").append(NumericType$.MODULE$.simpleString()).append(",\n         |").append(DateType$.MODULE$.catalogString()).append(", or ").append(TimestampType$.MODULE$.catalogString()).append(", but\n         |").append(column.dataType().catalogString()).append(" found.\n       ").toString())).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable tableOrViewAlreadyExistsError(String name) {
        return new AnalysisException(new java.lang.StringBuilder(57).append("Table or view '").append(name).append("' already exists. SaveMode: ErrorIfExists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable columnNameContainsInvalidCharactersError(String name) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(105).append("\n         |Column name \"").append(name).append("\" contains invalid character(s).\n         |Please use alias to rename it.\n       ").toString())).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable textDataSourceWithMultiColumnsError(StructType schema) {
        return new AnalysisException(new java.lang.StringBuilder(70).append("Text data source supports only a single column, and you have ").append(schema.size()).append(" columns.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotFindPartitionColumnInPartitionSchemaError(StructField readField, StructType partitionSchema) {
        return new AnalysisException(new java.lang.StringBuilder(58).append("Can't find required partition column ").append(readField.name()).append(" ").append("in partition schema ").append(partitionSchema).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotSpecifyDatabaseForTempViewError(TableIdentifier tableIdent) {
        return new AnalysisException(new java.lang.StringBuilder(54).append("Temporary view '").append(tableIdent).append("' should not have specified a database").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotCreateTempViewUsingHiveDataSourceError() {
        return new AnalysisException("Hive data source can only be used with tables, you can't use it with CREATE TEMP VIEW USING", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidTimestampProvidedForStrategyError(String strategy, String timeString) {
        return new AnalysisException(new java.lang.StringBuilder(127).append("The timestamp provided for the '").append(strategy).append("' option is invalid. The expected format ").append("is 'YYYY-MM-DDTHH:mm:ss', but the provided timestamp: ").append(timeString).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable hostOptionNotSetError() {
        return new AnalysisException("Set a host to read from with option(\"host\", ...).", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable portOptionNotSetError() {
        return new AnalysisException("Set a port to read from with option(\"port\", ...).", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidIncludeTimestampValueError() {
        return new AnalysisException("includeTimestamp must be set to either \"true\" or \"false\"", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable checkpointLocationNotSpecifiedError() {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(158).append("\n         |checkpointLocation must be specified either\n         |through option(\"checkpointLocation\", ...) or\n         |SparkSession.conf.set(\"").append(SQLConf$.MODULE$.CHECKPOINT_LOCATION().key()).append("\", ...)\n       ").toString())).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable recoverQueryFromCheckpointUnsupportedError(Path checkpointPath) {
        return new AnalysisException(new java.lang.StringBuilder(87).append("This query does not support recovering from checkpoint location. ").append("Delete ").append(checkpointPath).append(" to start over.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotFindColumnInRelationOutputError(String colName, LogicalPlan relation) {
        return new AnalysisException(new java.lang.StringBuilder(37).append("Unable to find the column `").append(colName).append("` ").append("given [").append(((TraversableOnce)relation.output().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.name(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("]").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidBoundaryStartError(long start) {
        return new AnalysisException(new java.lang.StringBuilder(39).append("Boundary start is not a valid integer: ").append(start).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidBoundaryEndError(long end) {
        return new AnalysisException(new java.lang.StringBuilder(37).append("Boundary end is not a valid integer: ").append(end).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable databaseDoesNotExistError(String dbName) {
        return new AnalysisException(new java.lang.StringBuilder(27).append("Database '").append(dbName).append("' does not exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable tableDoesNotExistInDatabaseError(String tableName, String dbName) {
        return new AnalysisException(new java.lang.StringBuilder(39).append("Table '").append(tableName).append("' does not exist in database '").append(dbName).append("'.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable tableOrViewNotFoundInDatabaseError(String tableName, String dbName) {
        return new AnalysisException(new java.lang.StringBuilder(41).append("Table or view '").append(tableName).append("' not found in database '").append(dbName).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable unexpectedTypeOfRelationError(LogicalPlan relation, String tableName) {
        return new AnalysisException(new java.lang.StringBuilder(33).append("Unexpected type ").append(relation.getClass().getCanonicalName()).append(" of the relation ").append(tableName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable unsupportedTableChangeInJDBCCatalogError(TableChange change) {
        return new AnalysisException(new java.lang.StringBuilder(41).append("Unsupported TableChange ").append(change).append(" in JDBC catalog.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable pathOptionNotSetCorrectlyWhenReadingError() {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(314).append("\n         |There is a 'path' or 'paths' option set and load() is called\n         |with path parameters. Either remove the path option if it's the same as the path\n         |parameter, or add it to the load() parameter if you do want to read multiple paths.\n         |To ignore this check, set '").append(SQLConf$.MODULE$.LEGACY_PATH_OPTION_BEHAVIOR().key()).append("' to 'true'.\n       ").toString())).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable pathOptionNotSetCorrectlyWhenWritingError() {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(220).append("\n         |There is a 'path' option set and save() is called with a path\n         |parameter. Either remove the path option, or call save() without the parameter.\n         |To ignore this check, set '").append(SQLConf$.MODULE$.LEGACY_PATH_OPTION_BEHAVIOR().key()).append("' to 'true'.\n       ").toString())).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable writeWithSaveModeUnsupportedBySourceError(String source, String createMode) {
        return new AnalysisException(new java.lang.StringBuilder(105).append("TableProvider implementation ").append(source).append(" cannot be ").append("written with ").append(createMode).append(" mode, please use Append or Overwrite modes instead.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable partitionByDoesNotAllowedWhenUsingInsertIntoError() {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString("\n        |insertInto() can't be used together with partitionBy().\n        |Partition columns have already been defined for the table.\n        |It is not necessary to use partitionBy().\n      ")).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotFindCatalogToHandleIdentifierError(String quote) {
        return new AnalysisException(new java.lang.StringBuilder(50).append("Couldn't find a catalog to handle the identifier ").append(quote).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable sortByNotUsedWithBucketByError() {
        return new AnalysisException("sortBy must be used together with bucketBy", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable bucketByUnsupportedByOperationError(String operation) {
        return new AnalysisException(new java.lang.StringBuilder(38).append("'").append(operation).append("' does not support bucketBy right now").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable bucketByAndSortByUnsupportedByOperationError(String operation) {
        return new AnalysisException(new java.lang.StringBuilder(49).append("'").append(operation).append("' does not support bucketBy and sortBy right now").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable tableAlreadyExistsError(TableIdentifier tableIdent) {
        return new AnalysisException(new java.lang.StringBuilder(22).append("Table ").append(tableIdent).append(" already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public String tableAlreadyExistsError$default$2() {
        return "";
    }

    public Throwable cannotOverwriteTableThatIsBeingReadFromError(String tableName) {
        return new AnalysisException(new java.lang.StringBuilder(52).append("Cannot overwrite table ").append(tableName).append(" that is also being read from").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidPartitionTransformationError(Expression expr) {
        return new AnalysisException(new java.lang.StringBuilder(34).append("Invalid partition transformation: ").append(expr.sql()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public AnalysisException cannotResolveColumnNameAmongFieldsError(String colName, String fieldsStr, String extraMsg) {
        return new AnalysisException(new java.lang.StringBuilder(38).append("Cannot resolve column name \"").append(colName).append("\" among (").append(fieldsStr).append(")").append(extraMsg).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotParseIntervalError(String delayThreshold, Throwable e) {
        String x$1 = new java.lang.StringBuilder(18).append("Unable to parse '").append(delayThreshold).append("'").toString();
        Some x$2 = new Some((Object)e);
        Option<Object> x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option<Object> x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option<LogicalPlan> x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
        Option<String> x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$6();
        String[] x$7 = AnalysisException$.MODULE$.$lessinit$greater$default$7();
        return new AnalysisException(x$1, x$3, x$4, x$5, (Option<Throwable>)x$2, x$6, x$7);
    }

    public Throwable invalidJoinTypeInJoinWithError(JoinType joinType) {
        return new AnalysisException(new java.lang.StringBuilder(31).append("Invalid join type in joinWith: ").append(joinType.sql()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotPassTypedColumnInUntypedSelectError(String typedCol) {
        return new AnalysisException(new java.lang.StringBuilder(132).append("Typed column ").append(typedCol).append(" that needs input type and schema ").append("cannot be passed in untyped `select` API. Use the typed `Dataset.select` API instead.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidViewNameError(String viewName) {
        return new AnalysisException(new java.lang.StringBuilder(19).append("Invalid view name: ").append(viewName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidBucketsNumberError(String numBuckets, String e) {
        return new AnalysisException(new java.lang.StringBuilder(37).append("Invalid number of buckets: bucket(").append(numBuckets).append(", ").append(e).append(")").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable usingUntypedScalaUDFError() {
        return new AnalysisException(new java.lang.StringBuilder(648).append("You're using untyped Scala UDF, which does not have the input type information. Spark may blindly pass null to the Scala closure with primitive-type argument, and the closure will see the default value of the Java type for the null argument, e.g. `udf((x: Int) => x, IntegerType)`, the result is 0 for null input. To get rid of this error, you could:\n1. use typed Scala UDF APIs(without return type parameter), e.g. `udf((x: Int) => x)`\n2. use Java UDF APIs, e.g. `udf(new UDF1[String, Integer] { override def call(s: String): Integer = s.length() }, IntegerType)`, if input types are all non primitive\n").append("3. set ").append(SQLConf$.MODULE$.LEGACY_ALLOW_UNTYPED_SCALA_UDF().key()).append(" to true and ").append("use this API with caution").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable aggregationFunctionAppliedOnNonNumericColumnError(String colName) {
        return new AnalysisException(new java.lang.StringBuilder(89).append("\"").append(colName).append("\" is not a numeric column. ").append("Aggregation function can only be applied on a numeric column.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable aggregationFunctionAppliedOnNonNumericColumnError(String pivotColumn, int maxValues) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(218).append("\n         |The pivot column ").append(pivotColumn).append(" has more than ").append(maxValues).append(" distinct values,\n         |this could indicate an error.\n         |If this was intended, set ").append(SQLConf$.MODULE$.DATAFRAME_PIVOT_MAX_VALUES().key()).append("\n         |to at least the number of distinct values of the pivot column.\n       ").toString())).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotModifyValueOfStaticConfigError(String key) {
        return new AnalysisException(new java.lang.StringBuilder(44).append("Cannot modify the value of a static config: ").append(key).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotModifyValueOfSparkConfigError(String key) {
        return new AnalysisException(new java.lang.StringBuilder(43).append("Cannot modify the value of a Spark config: ").append(key).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable commandExecutionInRunnerUnsupportedError(String runner) {
        return new AnalysisException(new java.lang.StringBuilder(45).append("Command execution is not supported in runner ").append(runner).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable udfClassDoesNotImplementAnyUDFInterfaceError(String className) {
        return new AnalysisException(new java.lang.StringBuilder(46).append("UDF class ").append(className).append(" doesn't implement any UDF interface").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable udfClassNotAllowedToImplementMultiUDFInterfacesError(String className) {
        return new AnalysisException(new java.lang.StringBuilder(62).append("It is invalid to implement multiple UDF interfaces, UDF class ").append(className).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable udfClassWithTooManyTypeArgumentsError(int n) {
        return new AnalysisException(new java.lang.StringBuilder(48).append("UDF class with ").append(n).append(" type arguments is not supported.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable classWithoutPublicNonArgumentConstructorError(String className) {
        return new AnalysisException(new java.lang.StringBuilder(83).append("Can not instantiate class ").append(className).append(", please make sure").append(" it has public non argument constructor").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable cannotLoadClassNotOnClassPathError(String className) {
        return new AnalysisException(new java.lang.StringBuilder(60).append("Can not load class ").append(className).append(", please make sure it is on the classpath").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable classDoesNotImplementUserDefinedAggregateFunctionError(String className) {
        return new AnalysisException(new java.lang.StringBuilder(63).append("class ").append(className).append(" doesn't implement interface UserDefinedAggregateFunction").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable missingFieldError(Seq<String> fieldName, ResolvedTable table, Origin context) {
        throw new AnalysisException(new java.lang.StringBuilder(38).append("Missing field ").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(fieldName).quoted()).append(" in table ").append(table.name()).append(" with schema:\n").append(table.schema().treeString()).toString(), context.line(), context.startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
    }

    public Throwable invalidFieldName(Seq<String> fieldName, Seq<String> path, Origin context) {
        return new AnalysisException("INVALID_FIELD_NAME", (String[])((Object[])new String[]{CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(fieldName).quoted(), CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(path).quoted()}), context);
    }

    public static final /* synthetic */ String $anonfun$invalidDayTimeField$1(byte i) {
        return new java.lang.StringBuilder(3).append(i).append(" (").append(DayTimeIntervalType$.MODULE$.fieldToString(i)).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$invalidYearMonthField$1(byte i) {
        return new java.lang.StringBuilder(3).append(i).append(" (").append(YearMonthIntervalType$.MODULE$.fieldToString(i)).append(")").toString();
    }

    private QueryCompilationErrors$() {
        MODULE$ = this;
    }
}

