/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.LocalTimestamp$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampNTZType$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_() - Returns the current timestamp without time zone at the start of query evaluation. All calls of localtimestamp within the same query return the same value.\n\n    _FUNC_ - Returns the current local date-time at the session time zone at the start of query evaluation.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_();\n       2020-04-25 15:49:11.914\n  ", group="datetime_funcs", since="3.3.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\u000f\u001f\u0001.B\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t%\u0002\u0011\t\u0012)A\u0005\t\")1\u000b\u0001C\u0001)\")1\u000b\u0001C\u0001/\")\u0001\f\u0001C!3\")Q\f\u0001C!3\")a\f\u0001C!?\")a\r\u0001C#O\"9\u0011Q\u0002\u0001\u0005B\u0005=\u0001bBA\n\u0001\u0011\u0005\u0013Q\u0003\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011%\ti\u0003AA\u0001\n\u0003\ty\u0003C\u0005\u00024\u0001\t\n\u0011\"\u0001\u00026!I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0013Q\n\u0005\n\u0003;\u0002\u0011\u0011!C\u0001\u0003?B\u0011\"a\u001a\u0001\u0003\u0003%\t!!\u001b\t\u0013\u0005=\u0004!!A\u0005B\u0005E\u0004\"CA@\u0001\u0005\u0005I\u0011AAA\u0011%\t)\tAA\u0001\n\u0003\n9iB\u0005\u0002,z\t\t\u0011#\u0001\u0002.\u001aAQDHA\u0001\u0012\u0003\ty\u000b\u0003\u0004T+\u0011\u0005\u0011Q\u0018\u0005\n\u0003\u007f+\u0012\u0011!C#\u0003\u0003D\u0011\"a1\u0016\u0003\u0003%\t)!2\t\u0013\u0005%W#%A\u0005\u0002\u0005U\u0002\"CAf+\u0005\u0005I\u0011QAg\u0011%\t).FI\u0001\n\u0003\t)\u0004C\u0005\u0002XV\t\t\u0011\"\u0003\u0002Z\nqAj\\2bYRKW.Z:uC6\u0004(BA\u0010!\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0005\u0012\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\r\"\u0013aA:rY*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001a\u0003gM\u001d@!\tic&D\u0001\u001f\u0013\tycD\u0001\bMK\u00064W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00055\n\u0014B\u0001\u001a\u001f\u0005]!\u0016.\\3[_:,\u0017i^1sK\u0016C\bO]3tg&|g\u000e\u0005\u00025o5\tQG\u0003\u00027=\u000591m\u001c3fO\u0016t\u0017B\u0001\u001d6\u0005=\u0019u\u000eZ3hK:4\u0015\r\u001c7cC\u000e\\\u0007C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$a\u0002)s_\u0012,8\r\u001e\t\u0003u\u0001K!!Q\u001e\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0015QLW.\u001a.p]\u0016LE-F\u0001E!\rQTiR\u0005\u0003\rn\u0012aa\u00149uS>t\u0007C\u0001%P\u001d\tIU\n\u0005\u0002Kw5\t1J\u0003\u0002MU\u00051AH]8pizJ!AT\u001e\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0016K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001dn\n1\u0002^5nKj{g.Z%eA\u00051A(\u001b8jiz\"\"!\u0016,\u0011\u00055\u0002\u0001b\u0002\"\u0004!\u0003\u0005\r\u0001\u0012\u000b\u0002+\u0006Aam\u001c7eC\ndW-F\u0001[!\tQ4,\u0003\u0002]w\t9!i\\8mK\u0006t\u0017\u0001\u00038vY2\f'\r\\3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G\n\nQ\u0001^=qKNL!!\u001a2\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fAC\\8eKB\u000bG\u000f^3s]NLe\u000e^3s]\u0006dG#\u00015\u0011\u0007%t\u0017O\u0004\u0002kY:\u0011!j[\u0005\u0002y%\u0011QnO\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0007OA\u0002TKFT!!\\\u001e\u0011\u0007I\f9AD\u0002t\u0003\u0003q!\u0001\u001e@\u000f\u0005UlhB\u0001<}\u001d\t98P\u0004\u0002yu:\u0011!*_\u0005\u0002S%\u0011q\u0005K\u0005\u0003K\u0019J!a\t\u0013\n\u0005\u0005\u0012\u0013BA@!\u0003\u0015!(/Z3t\u0013\u0011\t\u0019!!\u0002\u0002\u0017Q\u0013X-\u001a)biR,'O\u001c\u0006\u0003\u007f\u0002JA!!\u0003\u0002\f\tYAK]3f!\u0006$H/\u001a:o\u0015\u0011\t\u0019!!\u0002\u0002\u0019]LG\u000f\u001b+j[\u0016TvN\\3\u0015\u0007A\n\t\u0002C\u0003C\u0013\u0001\u0007q)\u0001\u0003fm\u0006dG\u0003BA\f\u0003;\u00012AOA\r\u0013\r\tYb\u000f\u0002\u0004\u0003:L\b\"CA\u0010\u0015A\u0005\t\u0019AA\u0011\u0003\u0015Ig\u000e];u!\u0011\t\u0019#!\n\u000e\u0003\u0001J1!a\n!\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001H\u0003\u0011\u0019w\u000e]=\u0015\u0007U\u000b\t\u0004C\u0004C\u0019A\u0005\t\u0019\u0001#\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0007\u0016\u0004\t\u0006e2FAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u00153(\u0001\u0006b]:|G/\u0019;j_:LA!!\u0013\u0002@\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0005\u0005\u0003\u0002R\u0005mSBAA*\u0015\u0011\t)&a\u0016\u0002\t1\fgn\u001a\u0006\u0003\u00033\nAA[1wC&\u0019\u0001+a\u0015\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0005\u0004c\u0001\u001e\u0002d%\u0019\u0011QM\u001e\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005]\u00111\u000e\u0005\n\u0003[\u0002\u0012\u0011!a\u0001\u0003C\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA:!\u0019\t)(a\u001f\u0002\u00185\u0011\u0011q\u000f\u0006\u0004\u0003sZ\u0014AC2pY2,7\r^5p]&!\u0011QPA<\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007i\u000b\u0019\tC\u0005\u0002nI\t\t\u00111\u0001\u0002\u0018\u00051Q-];bYN$2AWAE\u0011%\tigEA\u0001\u0002\u0004\t9\u0002K\n\u0001\u0003\u001b\u000b\u0019*!&\u0002\u001a\u0006m\u0015qTAQ\u0003K\u000b9\u000bE\u0002.\u0003\u001fK1!!%\u001f\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a&\u0002\u0005kQ\u0001\u0005\t\u0011!?\u001a+fjQ0)S\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002\u001aWO\u001d:f]R\u0004C/[7fgR\fW\u000e\u001d\u0011xSRDw.\u001e;!i&lW\r\t>p]\u0016\u0004\u0013\r\u001e\u0011uQ\u0016\u00043\u000f^1si\u0002zg\rI9vKJL\b%\u001a<bYV\fG/[8o]\u0001\nE\u000e\u001c\u0011dC2d7\u000fI8gA1|7-\u00197uS6,7\u000f^1na\u0002:\u0018\u000e\u001e5j]\u0002\"\b.\u001a\u0011tC6,\u0007%];fef\u0004#/\u001a;ve:\u0004C\u000f[3!g\u0006lW\r\t<bYV,gF\u0003\u0006!A\u0001\u0002sLR+O\u0007~\u0003S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043-\u001e:sK:$\b\u0005\\8dC2\u0004C-\u0019;f[QLW.\u001a\u0011bi\u0002\"\b.\u001a\u0011tKN\u001c\u0018n\u001c8!i&lW\r\t>p]\u0016\u0004\u0013\r\u001e\u0011uQ\u0016\u00043\u000f^1si\u0002zg\rI9vKJL\b%\u001a<bYV\fG/[8o])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ti*A%\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00193a5\u0002D'\f\u001a6AE*$\bN\u001d;cEr\u0013(\r\u001b\u000bA\u0001\nQa\u001a:pkB\f#!a)\u0002\u001d\u0011\fG/\u001a;j[\u0016|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011\u0011V\u0001\u0006g9\u001ad\u0006M\u0001\u000f\u0019>\u001c\u0017\r\u001c+j[\u0016\u001cH/Y7q!\tiSc\u0005\u0003\u0016\u0003c{\u0004CBAZ\u0003s#U+\u0004\u0002\u00026*\u0019\u0011qW\u001e\u0002\u000fI,h\u000e^5nK&!\u00111XA[\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0003[\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u001f\nQ!\u00199qYf$2!VAd\u0011\u001d\u0011\u0005\u0004%AA\u0002\u0011\u000bq\"\u00199qYf$C-\u001a4bk2$H%M\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ty-!5\u0011\u0007i*E\t\u0003\u0005\u0002Tj\t\t\u00111\u0001V\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u00037\u0004B!!\u0015\u0002^&!\u0011q\\A*\u0005\u0019y%M[3di\u0002")
public class LocalTimestamp
extends LeafExpression
implements TimeZoneAwareExpression,
CodegenFallback,
Serializable {
    private final Option<String> timeZoneId;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$1() {
        return LocalTimestamp$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Option<String>> unapply(LocalTimestamp localTimestamp) {
        return LocalTimestamp$.MODULE$.unapply(localTimestamp);
    }

    public static Option<String> apply$default$1() {
        return LocalTimestamp$.MODULE$.apply$default$1();
    }

    public static <A> Function1<Option<String>, A> andThen(Function1<LocalTimestamp, A> function1) {
        return LocalTimestamp$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, LocalTimestamp> compose(Function1<A, Option<String>> function1) {
        return LocalTimestamp$.MODULE$.compose(function1);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        LocalTimestamp localTimestamp = this;
        synchronized (localTimestamp) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        LocalTimestamp localTimestamp = this;
        synchronized (localTimestamp) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean foldable() {
        return true;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return TimestampNTZType$.MODULE$;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatternsInternal() {
        return (Seq)new .colon.colon((Object)TreePattern$.MODULE$.CURRENT_LIKE(), (List)Nil$.MODULE$);
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        return this.copy((Option<String>)Option$.MODULE$.apply((Object)timeZoneId));
    }

    @Override
    public Object eval(InternalRow input) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.now(this.zoneId())));
    }

    @Override
    public String prettyName() {
        return "localtimestamp";
    }

    public LocalTimestamp copy(Option<String> timeZoneId) {
        return new LocalTimestamp(timeZoneId);
    }

    public Option<String> copy$default$1() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "LocalTimestamp";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.timeZoneId();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LocalTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LocalTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        LocalTimestamp localTimestamp = (LocalTimestamp)x$1;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = localTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!localTimestamp.canEqual(this)) return false;
        return true;
    }

    public LocalTimestamp(Option<String> timeZoneId) {
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
    }

    public LocalTimestamp() {
        this((Option<String>)None$.MODULE$);
    }
}

