/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog$;
import org.apache.spark.sql.connector.catalog.CatalogExtension;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogNotFoundException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Catalogs$;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005eb!B\u000e\u001d\u0001\u0001B\u0003\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011\u0005\u0003!Q1A\u0005\u0002\tC\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\u0006\u0013\u0002!\tA\u0013\u0005\b\u001d\u0002\u0011\r\u0011\"\u0003P\u0011\u0019\u0019\u0007\u0001)A\u0005!\")Q\u0004\u0001C\u0001I\")q\r\u0001C\u0001Q\")Q\u000e\u0001C\u0005]\"1q\u000e\u0001C\u0001AADq!\u001d\u0001A\u0002\u0013%!\u000fC\u0004z\u0001\u0001\u0007I\u0011\u0002>\t\u000f\u0005\u0005\u0001\u0001)Q\u0005g\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\u0004\u0001\u0011\u0005\u0011\u0011\u0002\u0005\n\u0003\u001f\u0001\u0001\u0019!C\u0005\u0003#A\u0011\"!\u0006\u0001\u0001\u0004%I!a\u0006\t\u0011\u0005m\u0001\u0001)Q\u0005\u0003'Aa!!\b\u0001\t\u0003\u0001\bbBA\u0010\u0001\u0011\u0005\u0011\u0011\u0005\u0005\t\u0003O\u0001A\u0011\u0001\u0011\u0002*\u001dA\u00111\u0006\u000f\t\u0002\u0001\niCB\u0004\u001c9!\u0005\u0001%a\f\t\r%;B\u0011AA\u0019\u0011%\t\u0019d\u0006b\u0001\n\u0003\t)\u0004C\u0004\u00028]\u0001\u000b\u0011\u0002-\u0003\u001d\r\u000bG/\u00197pO6\u000bg.Y4fe*\u0011QDH\u0001\bG\u0006$\u0018\r\\8h\u0015\ty\u0002%A\u0005d_:tWm\u0019;pe*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0014\t\u0001Is&\u000e\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005A\u001aT\"A\u0019\u000b\u0005I\u0002\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\u0005Q\n$!D*R\u0019\u000e{gN\u001a%fYB,'\u000f\u0005\u00027s5\tqG\u0003\u00029E\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002;o\t9Aj\\4hS:<\u0017!\u00063fM\u0006,H\u000e^*fgNLwN\\\"bi\u0006dwnZ\u0002\u0001!\tqt(D\u0001\u001d\u0013\t\u0001EDA\u0007DCR\fGn\\4QYV<\u0017N\\\u0001\u0011mF\u001aVm]:j_:\u001c\u0015\r^1m_\u001e,\u0012a\u0011\t\u0003\t\u001ak\u0011!\u0012\u0006\u0003;EJ!aR#\u0003\u001dM+7o]5p]\u000e\u000bG/\u00197pO\u0006\tb/M*fgNLwN\\\"bi\u0006dwn\u001a\u0011\u0002\rqJg.\u001b;?)\rYE*\u0014\t\u0003}\u0001AQa\u000f\u0003A\u0002uBQ!\u0011\u0003A\u0002\r\u000b\u0001bY1uC2|wm]\u000b\u0002!B!\u0011K\u0016->\u001b\u0005\u0011&BA*U\u0003\u001diW\u000f^1cY\u0016T!!V\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002X%\n9\u0001*Y:i\u001b\u0006\u0004\bCA-a\u001d\tQf\f\u0005\u0002\\W5\tAL\u0003\u0002^y\u00051AH]8pizJ!aX\u0016\u0002\rA\u0013X\rZ3g\u0013\t\t'M\u0001\u0004TiJLgn\u001a\u0006\u0003?.\n\u0011bY1uC2|wm\u001d\u0011\u0015\u0005u*\u0007\"\u00024\b\u0001\u0004A\u0016\u0001\u00028b[\u0016\f1#[:DCR\fGn\\4SK\u001eL7\u000f^3sK\u0012$\"!\u001b7\u0011\u0005)R\u0017BA6,\u0005\u001d\u0011un\u001c7fC:DQA\u001a\u0005A\u0002a\u000bA\u0003\\8bIZ\u00134+Z:tS>t7)\u0019;bY><G#A\u001f\u0002!Y\u00144+Z:tS>t7)\u0019;bY><W#A\u001f\u0002#}\u001bWO\u001d:f]Rt\u0015-\\3ta\u0006\u001cW-F\u0001t!\rQCO^\u0005\u0003k.\u0012aa\u00149uS>t\u0007c\u0001\u0016x1&\u0011\u0001p\u000b\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0016?\u000e,(O]3oi:\u000bW.Z:qC\u000e,w\fJ3r)\tYh\u0010\u0005\u0002+y&\u0011Qp\u000b\u0002\u0005+:LG\u000fC\u0004\u0000\u0019\u0005\u0005\t\u0019A:\u0002\u0007a$\u0013'\u0001\n`GV\u0014(/\u001a8u\u001d\u0006lWm\u001d9bG\u0016\u0004\u0013\u0001E2veJ,g\u000e\u001e(b[\u0016\u001c\b/Y2f+\u00051\u0018aE:fi\u000e+(O]3oi:\u000bW.Z:qC\u000e,GcA>\u0002\f!1\u0011QB\bA\u0002Y\f\u0011B\\1nKN\u0004\u0018mY3\u0002'}\u001bWO\u001d:f]R\u001c\u0015\r^1m_\u001et\u0015-\\3\u0016\u0005\u0005M\u0001c\u0001\u0016u1\u00069rlY;se\u0016tGoQ1uC2|wMT1nK~#S-\u001d\u000b\u0004w\u0006e\u0001\u0002C@\u0012\u0003\u0003\u0005\r!a\u0005\u0002)}\u001bWO\u001d:f]R\u001c\u0015\r^1m_\u001et\u0015-\\3!\u00039\u0019WO\u001d:f]R\u001c\u0015\r^1m_\u001e\f\u0011c]3u\u0007V\u0014(/\u001a8u\u0007\u0006$\u0018\r\\8h)\rY\u00181\u0005\u0005\u0007\u0003K!\u0002\u0019\u0001-\u0002\u0017\r\fG/\u00197pO:\u000bW.Z\u0001\u0006e\u0016\u001cX\r\u001e\u000b\u0002w\u0006q1)\u0019;bY><W*\u00198bO\u0016\u0014\bC\u0001 \u0018'\t9\u0012\u0006\u0006\u0002\u0002.\u0005!2+R*T\u0013>sulQ!U\u00032{ui\u0018(B\u001b\u0016+\u0012\u0001W\u0001\u0016'\u0016\u001b6+S(O?\u000e\u000bE+\u0011'P\u000f~s\u0015)T#!\u0001")
public class CatalogManager
implements SQLConfHelper,
Logging {
    private final CatalogPlugin defaultSessionCatalog;
    private final SessionCatalog v1SessionCatalog;
    private final HashMap<String, CatalogPlugin> catalogs;
    private Option<String[]> _currentNamespace;
    private Option<String> _currentCatalogName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String SESSION_CATALOG_NAME() {
        return CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SessionCatalog v1SessionCatalog() {
        return this.v1SessionCatalog;
    }

    private HashMap<String, CatalogPlugin> catalogs() {
        return this.catalogs;
    }

    public synchronized CatalogPlugin catalog(String name) {
        return name.equalsIgnoreCase(CatalogManager$.MODULE$.SESSION_CATALOG_NAME()) ? this.v2SessionCatalog() : (CatalogPlugin)this.catalogs().getOrElseUpdate((Object)name, (Function0 & Serializable & scala.Serializable)() -> Catalogs$.MODULE$.load(name, this.conf()));
    }

    public boolean isCatalogRegistered(String name) {
        boolean bl;
        try {
            this.catalog(name);
            bl = true;
        }
        catch (CatalogNotFoundException catalogNotFoundException) {
            bl = false;
        }
        return bl;
    }

    private CatalogPlugin loadV2SessionCatalog() {
        CatalogPlugin catalogPlugin;
        CatalogPlugin catalogPlugin2 = Catalogs$.MODULE$.load(CatalogManager$.MODULE$.SESSION_CATALOG_NAME(), this.conf());
        if (catalogPlugin2 instanceof CatalogExtension) {
            CatalogExtension catalogExtension = (CatalogExtension)catalogPlugin2;
            catalogExtension.setDelegateCatalog(this.defaultSessionCatalog);
            catalogPlugin = catalogExtension;
        } else {
            catalogPlugin = catalogPlugin2;
        }
        return catalogPlugin;
    }

    public CatalogPlugin v2SessionCatalog() {
        return (CatalogPlugin)this.conf().getConf(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION()).map((Function1 & Serializable & scala.Serializable)x$1 -> (CatalogPlugin)this.catalogs().getOrElseUpdate((Object)CatalogManager$.MODULE$.SESSION_CATALOG_NAME(), (Function0 & Serializable & scala.Serializable)() -> this.loadV2SessionCatalog())).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.defaultSessionCatalog);
    }

    private Option<String[]> _currentNamespace() {
        return this._currentNamespace;
    }

    private void _currentNamespace_$eq(Option<String[]> x$1) {
        this._currentNamespace = x$1;
    }

    public synchronized String[] currentNamespace() {
        return (String[])this._currentNamespace().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String string = this.currentCatalog().name();
            String string2 = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
            return !(string != null ? !string.equals(string2) : string2 != null) ? (String[])((Object[])new String[]{this.v1SessionCatalog().getCurrentDatabase()}) : this.currentCatalog().defaultNamespace();
        });
    }

    public synchronized void setCurrentNamespace(String[] namespace) {
        CatalogPlugin catalogPlugin = this.currentCatalog();
        if (CatalogV2Util$.MODULE$.isSessionCatalog(this.currentCatalog()) && namespace.length == 1) {
            this.v1SessionCatalog().setCurrentDatabase((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).head());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            SupportsNamespaces supportsNamespaces;
            if (CatalogV2Util$.MODULE$.isSessionCatalog(this.currentCatalog())) {
                throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
            }
            if (catalogPlugin instanceof SupportsNamespaces && !(supportsNamespaces = (SupportsNamespaces)catalogPlugin).namespaceExists(namespace)) {
                throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
            }
            this._currentNamespace_$eq((Option<String[]>)new Some((Object)namespace));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Option<String> _currentCatalogName() {
        return this._currentCatalogName;
    }

    private void _currentCatalogName_$eq(Option<String> x$1) {
        this._currentCatalogName = x$1;
    }

    public synchronized CatalogPlugin currentCatalog() {
        return this.catalog((String)this._currentCatalogName().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.conf().getConf(SQLConf$.MODULE$.DEFAULT_CATALOG())));
    }

    public synchronized void setCurrentCatalog(String catalogName) {
        block0: {
            String string = this.currentCatalog().name();
            String string2 = catalogName;
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            this._currentCatalogName_$eq((Option<String>)new Some((Object)catalogName));
            this._currentNamespace_$eq((Option<String[]>)None$.MODULE$);
            this.v1SessionCatalog().setCurrentDatabase(SessionCatalog$.MODULE$.DEFAULT_DATABASE());
        }
    }

    public synchronized void reset() {
        this.catalogs().clear();
        this._currentNamespace_$eq((Option<String[]>)None$.MODULE$);
        this._currentCatalogName_$eq((Option<String>)None$.MODULE$);
        this.v1SessionCatalog().setCurrentDatabase(SessionCatalog$.MODULE$.DEFAULT_DATABASE());
    }

    public CatalogManager(CatalogPlugin defaultSessionCatalog, SessionCatalog v1SessionCatalog) {
        this.defaultSessionCatalog = defaultSessionCatalog;
        this.v1SessionCatalog = v1SessionCatalog;
        SQLConfHelper.$init$(this);
        Logging.$init$((Logging)this);
        this.catalogs = HashMap$.MODULE$.empty();
        this._currentNamespace = None$.MODULE$;
        this._currentCatalogName = None$.MODULE$;
    }
}

