/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonToStructs$;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.json.JacksonParser$;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(jsonStr, schema[, options]) - Returns a struct value with the given `jsonStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":1, \"b\":0.8}', 'a INT, b DOUBLE');\n       {\"a\":1,\"b\":0.8}\n      > SELECT _FUNC_('{\"time\":\"26/08/2015\"}', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":2015-08-26 00:00:00}\n  ", group="json_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\tmg\u0001B\u00193\u0001~B\u0001\u0002\u0019\u0001\u0003\u0016\u0004%\t!\u0019\u0005\tQ\u0002\u0011\t\u0012)A\u0005E\"A\u0011\u000e\u0001BK\u0002\u0013\u0005!\u000e\u0003\u0005z\u0001\tE\t\u0015!\u0003l\u0011!Q\bA!f\u0001\n\u0003Y\b\u0002C@\u0001\u0005#\u0005\u000b\u0011\u0002?\t\u0015\u0005\u0005\u0001A!f\u0001\n\u0003\t\u0019\u0001\u0003\u0006\u0002\f\u0001\u0011\t\u0012)A\u0005\u0003\u000bAq!!\u0004\u0001\t\u0003\ty\u0001\u0003\u0005\u0002\u001c\u0001\u0011\r\u0011\"\u0001b\u0011\u001d\ti\u0002\u0001Q\u0001\n\tDq!a\b\u0001\t\u0003\n\t\u0003C\u0004\u0002*\u0001!)%a\u000b\t\u000f\u00055\u0001\u0001\"\u0001\u0002h!9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0004bBA\u0007\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003{\u0002A\u0011IA@\u0011)\ti\t\u0001EC\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0003\u0007\u0004!\u0019!C\u0001\u0003\u000bDq!a2\u0001A\u0003%a\u000f\u0003\u0006\u0002J\u0002A)\u0019!C\u0001\u0003\u0017Da!!;\u0001\t\u0003\n\u0007bBAv\u0001\u0011\u0005\u0013Q\u001e\u0005\b\u0003c\u0004A\u0011IAz\u0011\u001d\ty\u0010\u0001C!\u0005\u0003Aaa\u000e\u0001\u0005B\u0005\u0015\u0007b\u0002B\u0006\u0001\u0011\u0005\u0013Q\u0019\u0005\b\u0005\u001b\u0001A\u0011\u000bB\b\u0011%\u0011)\u0002AA\u0001\n\u0003\u00119\u0002C\u0005\u0003\"\u0001\t\n\u0011\"\u0001\u0003$!I!\u0011\b\u0001\u0012\u0002\u0013\u0005!1\b\u0005\n\u0005\u007f\u0001\u0011\u0013!C\u0001\u0005\u0003B\u0011B!\u0012\u0001#\u0003%\tAa\u0012\t\u0013\t-\u0003!!A\u0005B\t5\u0003\"\u0003B*\u0001\u0005\u0005I\u0011\u0001B+\u0011%\u0011i\u0006AA\u0001\n\u0003\u0011y\u0006C\u0005\u0003f\u0001\t\t\u0011\"\u0011\u0003h!I!1\u000f\u0001\u0002\u0002\u0013\u0005!Q\u000f\u0005\n\u0005s\u0002\u0011\u0011!C!\u0005w:\u0011Ba(3\u0003\u0003E\tA!)\u0007\u0011E\u0012\u0014\u0011!E\u0001\u0005GCq!!\u0004*\t\u0003\u0011\t\fC\u0005\u00034&\n\t\u0011\"\u0012\u00036\"I!qW\u0015\u0002\u0002\u0013\u0005%\u0011\u0018\u0005\n\u0005\u0007L\u0013\u0013!C\u0001\u0005\u000fB\u0011B!2*\u0003\u0003%\tIa2\t\u0013\tU\u0017&%A\u0005\u0002\t\u001d\u0003\"\u0003BlS\u0005\u0005I\u0011\u0002Bm\u00055Q5o\u001c8U_N#(/^2ug*\u00111\u0007N\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00026m\u0005A1-\u0019;bYf\u001cHO\u0003\u00028q\u0005\u00191/\u001d7\u000b\u0005eR\u0014!B:qCJ\\'BA\u001e=\u0003\u0019\t\u0007/Y2iK*\tQ(A\u0002pe\u001e\u001c\u0001a\u0005\u0005\u0001\u0001\u0012;U\nU,^!\t\t%)D\u00013\u0013\t\u0019%GA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tU)\u0003\u0002Ge\t9B+[7f5>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015J\nqaY8eK\u001e,g.\u0003\u0002M\u0013\ny1i\u001c3fO\u0016tg)\u00197mE\u0006\u001c7\u000e\u0005\u0002B\u001d&\u0011qJ\r\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA)U\u001d\t\t%+\u0003\u0002Te\u00059\u0001/Y2lC\u001e,\u0017BA+W\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!a\u0015\u001a\u0011\u0005a[V\"A-\u000b\u0003i\u000bQa]2bY\u0006L!\u0001X-\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001LX\u0005\u0003?f\u0013AbU3sS\u0006d\u0017N_1cY\u0016\faa]2iK6\fW#\u00012\u0011\u0005\r4W\"\u00013\u000b\u0005\u00154\u0014!\u0002;za\u0016\u001c\u0018BA4e\u0005!!\u0015\r^1UsB,\u0017aB:dQ\u0016l\u0017\rI\u0001\b_B$\u0018n\u001c8t+\u0005Y\u0007\u0003\u00027tmZt!!\\9\u0011\u00059LV\"A8\u000b\u0005At\u0014A\u0002\u001fs_>$h(\u0003\u0002s3\u00061\u0001K]3eK\u001aL!\u0001^;\u0003\u00075\u000b\u0007O\u0003\u0002s3B\u0011An^\u0005\u0003qV\u0014aa\u0015;sS:<\u0017\u0001C8qi&|gn\u001d\u0011\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003q\u0004\"!Q?\n\u0005y\u0014$AC#yaJ,7o]5p]\u000611\r[5mI\u0002\n!\u0002^5nKj{g.Z%e+\t\t)\u0001\u0005\u0003Y\u0003\u000f1\u0018bAA\u00053\n1q\n\u001d;j_:\f1\u0002^5nKj{g.Z%eA\u00051A(\u001b8jiz\"\"\"!\u0005\u0002\u0014\u0005U\u0011qCA\r!\t\t\u0005\u0001C\u0003a\u0013\u0001\u0007!\rC\u0003j\u0013\u0001\u00071\u000eC\u0003{\u0013\u0001\u0007A\u0010C\u0005\u0002\u0002%\u0001\n\u00111\u0001\u0002\u0006\u0005qa.\u001e7mC\ndWmU2iK6\f\u0017a\u00048vY2\f'\r\\3TG\",W.\u0019\u0011\u0002\u00119,H\u000e\\1cY\u0016,\"!a\t\u0011\u0007a\u000b)#C\u0002\u0002(e\u0013qAQ8pY\u0016\fg.\u0001\u000bo_\u0012,\u0007+\u0019;uKJt7/\u00138uKJt\u0017\r\u001c\u000b\u0003\u0003[\u0001b!a\f\u00028\u0005ub\u0002BA\u0019\u0003kq1A\\A\u001a\u0013\u0005Q\u0016BA*Z\u0013\u0011\tI$a\u000f\u0003\u0007M+\u0017O\u0003\u0002T3B!\u0011qHA1\u001d\u0011\t\t%a\u0017\u000f\t\u0005\r\u0013q\u000b\b\u0005\u0003\u000b\n)F\u0004\u0003\u0002H\u0005Mc\u0002BA%\u0003#rA!a\u0013\u0002P9\u0019a.!\u0014\n\u0003uJ!a\u000f\u001f\n\u0005eR\u0014BA\u001c9\u0013\t)d'C\u0002\u0002ZQ\nQ\u0001\u001e:fKNLA!!\u0018\u0002`\u0005YAK]3f!\u0006$H/\u001a:o\u0015\r\tI\u0006N\u0005\u0005\u0003G\n)GA\u0006Ue\u0016,\u0007+\u0019;uKJt'\u0002BA/\u0003?\"\u0002\"!\u0005\u0002j\u0005-\u0014Q\u000e\u0005\u0006u:\u0001\r\u0001 \u0005\u0006A:\u0001\r\u0001 \u0005\u0006S:\u0001\ra\u001b\u000b\u0007\u0003#\t\t(a\u001d\t\u000bi|\u0001\u0019\u0001?\t\u000b\u0001|\u0001\u0019\u0001?\u0015\u0011\u0005E\u0011qOA=\u0003wBQA\u001f\tA\u0002qDQ\u0001\u0019\tA\u0002qDQ!\u001b\tA\u0002q\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\"!!!\u0011\t\u0005\r\u0015\u0011R\u0007\u0003\u0003\u000bS1!a\"5\u0003!\tg.\u00197zg&\u001c\u0018\u0002BAF\u0003\u000b\u0013q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\nG>tg/\u001a:uKJ,\"!!%\u0011\u000fa\u000b\u0019*a&\u0002&&\u0019\u0011QS-\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CBA\u0018\u00033\u000bi*\u0003\u0003\u0002\u001c\u0006m\"\u0001C%uKJ\fGo\u001c:\u0011\t\u0005}\u0015\u0011U\u0007\u0002i%\u0019\u00111\u0015\u001b\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\n\u0006\u0003Ok\u00161\u0016\u0004\u0007\u0003S\u0003\u0001!!*\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\t\u00055\u0016qW\u0007\u0003\u0003_SA!!-\u00024\u0006!A.\u00198h\u0015\t\t),\u0001\u0003kCZ\f\u0017\u0002BA]\u0003_\u0013aa\u00142kK\u000e$\bf\u0001\n\u0002>B\u0019\u0001,a0\n\u0007\u0005\u0005\u0017LA\u0005ue\u0006t7/[3oi\u0006\u0019b.Y7f\u001f\u001a\u001cuN\u001d:vaR\u0014VmY8sIV\ta/\u0001\u000boC6,wJZ\"peJ,\b\u000f\u001e*fG>\u0014H\rI\u0001\u0007a\u0006\u00148/\u001a:\u0016\u0005\u00055\u0007CBAh\u0003+\fI.\u0004\u0002\u0002R*\u0019\u00111\u001b\u001b\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003/\f\tNA\tGC&dWO]3TC\u001a,\u0007+\u0019:tKJ\u0004B!a7\u0002d6\u0011\u0011Q\u001c\u0006\u0004K\u0006}'bAAqq\u00051QO\\:bM\u0016LA!!:\u0002^\nQQ\u000b\u0016$9'R\u0014\u0018N\\4)\u0007U\ti,\u0001\u0005eCR\fG+\u001f9f\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\r!\u0015q\u001e\u0005\u0007\u0003\u00039\u0002\u0019\u0001<\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\t\u0005U\u00181 \t\u00041\u0006]\u0018bAA}3\n\u0019\u0011I\\=\t\u000f\u0005u\b\u00041\u0001\u0002v\u0006!!n]8o\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0005\u0007\u0001b!a\f\u00028\t\u0015\u0001cA2\u0003\b%\u0019!\u0011\u00023\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017A\u00039sKR$\u0018PT1nK\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$B!!\u0005\u0003\u0012!1!1\u0003\u000fA\u0002q\f\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010\u0006\u0006\u0002\u0012\te!1\u0004B\u000f\u0005?Aq\u0001Y\u000f\u0011\u0002\u0003\u0007!\rC\u0004j;A\u0005\t\u0019A6\t\u000fil\u0002\u0013!a\u0001y\"I\u0011\u0011A\u000f\u0011\u0002\u0003\u0007\u0011QA\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011)CK\u0002c\u0005OY#A!\u000b\u0011\t\t-\"QG\u0007\u0003\u0005[QAAa\f\u00032\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005gI\u0016AC1o]>$\u0018\r^5p]&!!q\u0007B\u0017\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011iDK\u0002l\u0005O\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003D)\u001aAPa\n\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!\u0011\n\u0016\u0005\u0003\u000b\u00119#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u001f\u0002B!!,\u0003R%\u0019\u00010a,\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\t]\u0003c\u0001-\u0003Z%\u0019!1L-\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005U(\u0011\r\u0005\n\u0005G\"\u0013\u0011!a\u0001\u0005/\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B5!\u0019\u0011YG!\u001d\u0002v6\u0011!Q\u000e\u0006\u0004\u0005_J\u0016AC2pY2,7\r^5p]&!\u00111\u0014B7\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0012\u0005oB\u0011Ba\u0019'\u0003\u0003\u0005\r!!>\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019C! \t\u0013\t\rt%!AA\u0002\u0005U\bf\u0005\u0001\u0003\u0002\n\u001d%\u0011\u0012BG\u0005\u001f\u0013\u0019J!&\u0003\u001a\nm\u0005cA!\u0003\u0004&\u0019!Q\u0011\u001a\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!1R\u0001c?\u001a+fjQ0)UN|gn\u0015;sY\u0001\u001a8\r[3nCnc\u0003e\u001c9uS>t7/X\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\rI:ueV\u001cG\u000f\t<bYV,\u0007e^5uQ\u0002\"\b.\u001a\u0011hSZ,g\u000e\t1kg>t7\u000b\u001e:aA\u0005tG\r\t1tG\",W.\u00191/\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001BI\u0003\u0005\u0015(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014|E\u0005\u0014#(\r\u0017!E\t\u0014#\b\r\u00189{\u001eb\u0003eJ1!\u0013:#F\u0006\t2!\t>+&\tT#(SmR\u0001\u0005\t\u0011!A\u0001\u00023PI1#uEb#E\u0019\u0012;a9BTP\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(w\n\"\u0018.\\3#u\t\u0012dg\f\u00199_I\u0002\u0014'\u000e\u0012~O1\u0002s\u0005^5nK\u0002\"\u0016.\\3ti\u0006l\u0007o\n\u0017![\u0006\u0004\bf\n;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;(Y\u0001:C\rZ\u0018N\u001b>J\u00180_=(S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012uS6,'E\u000f\u001a1cUj\u0003\u0007O\u00173m\u0001\u0002\u0004G\u000f\u00191uA\u0002TP\u0003\u0011!\u0003\u00159'o\\;qC\t\u00119*\u0001\u0006kg>twLZ;oGN\fQa]5oG\u0016\f#A!(\u0002\u000bIr#G\f\u0019\u0002\u001b)\u001bxN\u001c+p'R\u0014Xo\u0019;t!\t\t\u0015f\u0005\u0003*\u0005Kk\u0006c\u0003BT\u0005[\u00137\u000e`A\u0003\u0003#i!A!+\u000b\u0007\t-\u0016,A\u0004sk:$\u0018.\\3\n\t\t=&\u0011\u0016\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DC\u0001BQ\u0003!!xn\u0015;sS:<GC\u0001B(\u0003\u0015\t\u0007\u000f\u001d7z))\t\tBa/\u0003>\n}&\u0011\u0019\u0005\u0006A2\u0002\rA\u0019\u0005\u0006S2\u0002\ra\u001b\u0005\u0006u2\u0002\r\u0001 \u0005\n\u0003\u0003a\u0003\u0013!a\u0001\u0003\u000b\tq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011IM!5\u0011\u000ba\u000b9Aa3\u0011\u0011a\u0013iMY6}\u0003\u000bI1Aa4Z\u0005\u0019!V\u000f\u001d7fi!I!1\u001b\u0018\u0002\u0002\u0003\u0007\u0011\u0011C\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'A\u0006sK\u0006$'+Z:pYZ,GCAAV\u0001")
public class JsonToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient Function1<Iterator<InternalRow>, Object> converter;
    private transient FailureSafeParser<UTF8String> parser;
    private final DataType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final DataType nullableSchema;
    private final String nameOfCorruptRecord;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$4() {
        return JsonToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<DataType, Map<String, String>, Expression, Option<String>>> unapply(JsonToStructs jsonToStructs) {
        return JsonToStructs$.MODULE$.unapply(jsonToStructs);
    }

    public static Option<String> apply$default$4() {
        return JsonToStructs$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<DataType, Map<String, String>, Expression, Option<String>>, JsonToStructs> tupled() {
        return JsonToStructs$.MODULE$.tupled();
    }

    public static Function1<DataType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, JsonToStructs>>>> curried() {
        return JsonToStructs$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public DataType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public DataType nullableSchema() {
        return this.nullableSchema;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatternsInternal() {
        return (Seq)new .colon.colon((Object)TreePattern$.MODULE$.JSON_TO_STRUCT(), (List)Nil$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType = this.nullableSchema();
        boolean bl = dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType);
        TypeCheckResult typeCheckResult = bl ? ExpectsInputTypes.checkInputDataTypes$(this) : new TypeCheckResult.TypeCheckFailure(new StringBuilder(50).append("Input schema ").append(this.nullableSchema().catalogString()).append(" must be a struct, an array or a map.").toString());
        return typeCheckResult;
    }

    private Function1<Iterator<InternalRow>, Object> converter$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.nullableSchema();
                if (dataType instanceof StructType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> rows.hasNext() ? (InternalRow)rows.next() : null;
                } else if (dataType instanceof ArrayType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> rows.hasNext() ? ((SpecializedGetters)rows.next()).getArray(0) : null;
                } else if (dataType instanceof MapType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> rows.hasNext() ? ((SpecializedGetters)rows.next()).getMap(0) : null;
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.converter = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.converter;
    }

    public Function1<Iterator<InternalRow>, Object> converter() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.converter$lzycompute() : this.converter;
    }

    public String nameOfCorruptRecord() {
        return this.nameOfCorruptRecord;
    }

    private FailureSafeParser<UTF8String> parser$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Tuple2 tuple2;
                DataType dataType;
                ParseMode mode;
                JSONOptions parsedOptions = new JSONOptions(this.options(), (String)this.timeZoneId().get(), this.nameOfCorruptRecord());
                ParseMode parseMode = mode = parsedOptions.parseMode();
                PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
                if (parseMode == null ? permissiveMode$ != null : !parseMode.equals(permissiveMode$)) {
                    ParseMode parseMode2 = mode;
                    FailFastMode$ failFastMode$ = FailFastMode$.MODULE$;
                    if (parseMode2 == null ? failFastMode$ != null : !parseMode2.equals(failFastMode$)) {
                        throw QueryCompilationErrors$.MODULE$.parseModeUnsupportedError("from_json", mode);
                    }
                }
                if ((dataType = this.nullableSchema()) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(structType, parsedOptions.columnNameOfCorruptRecord());
                    tuple2 = new Tuple2((Object)structType, (Object)StructType$.MODULE$.apply((Seq<StructField>)((Seq)structType.filterNot((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)JsonToStructs.$anonfun$parser$1(parsedOptions, x$12))))));
                } else {
                    StructField structField = new StructField("value", dataType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                    tuple2 = new Tuple2((Object)StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$.$colon$colon((Object)structField)), (Object)dataType);
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                StructType parserSchema = (StructType)tuple22._1();
                DataType actualSchema = (DataType)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)parserSchema, (Object)actualSchema);
                Tuple2 tuple24 = tuple23;
                StructType parserSchema2 = (StructType)tuple24._1();
                DataType actualSchema2 = (DataType)tuple24._2();
                JacksonParser rawParser = new JacksonParser(actualSchema2, parsedOptions, false, JacksonParser$.MODULE$.$lessinit$greater$default$4());
                Function2 & Serializable & scala.Serializable createParser = (Function2 & Serializable & scala.Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.utf8String((JsonFactory)jsonFactory, (UTF8String)record);
                this.parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> rawParser.parse(input, createParser, (Function1 & Serializable & scala.Serializable)x -> (UTF8String)Predef$.MODULE$.identity(x)), mode, parserSchema2, parsedOptions.columnNameOfCorruptRecord());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.parser;
    }

    public FailureSafeParser<UTF8String> parser() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.parser$lzycompute() : this.parser;
    }

    @Override
    public DataType dataType() {
        return this.nullableSchema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object json) {
        return this.converter().apply(this.parser().parse((UTF8String)json));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)stringType$);
    }

    @Override
    public String sql() {
        DataType dataType = this.schema();
        String string = dataType instanceof MapType ? "entries" : super.sql();
        return string;
    }

    @Override
    public String prettyName() {
        return "from_json";
    }

    @Override
    public JsonToStructs withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Option<String> x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    public JsonToStructs copy(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new JsonToStructs(schema, options, child, timeZoneId);
    }

    public DataType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "JsonToStructs";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.schema();
                break;
            }
            case 1: {
                object = this.options();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonToStructs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonToStructs jsonToStructs = (JsonToStructs)x$1;
        DataType dataType = this.schema();
        DataType dataType2 = jsonToStructs.schema();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = jsonToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = jsonToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = jsonToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!jsonToStructs.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$parser$1(JSONOptions parsedOptions$1, StructField x$12) {
        String string = x$12.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public JsonToStructs(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.nullableSchema = schema.asNullable();
        this.nameOfCorruptRecord = SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.COLUMN_NAME_OF_CORRUPT_RECORD());
    }

    public JsonToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), options, child, (Option<String>)None$.MODULE$);
    }

    public JsonToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public JsonToStructs(Expression child, Expression schema, Expression options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

