/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.ArrayTransform;
import org.apache.spark.sql.catalyst.expressions.CaseWhen;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.CreateArray;
import org.apache.spark.sql.catalyst.expressions.CreateMap;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GetStructField$;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.KnownFloatingPointNormalized;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.optimizer.NormalizeFloatingNumbers$;
import org.apache.spark.sql.catalyst.optimizer.NormalizeNaNAndZero;
import org.apache.spark.sql.catalyst.planning.ExtractEquiJoinKeys$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.JoinHint;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Window;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.TreePatternBits;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class NormalizeFloatingNumbers$
extends Rule<LogicalPlan> {
    public static NormalizeFloatingNumbers$ MODULE$;
    private final Function1<Object, Object> FLOAT_NORMALIZER;
    private final Function1<Object, Object> DOUBLE_NORMALIZER;

    static {
        new NormalizeFloatingNumbers$();
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        LogicalPlan logicalPlan = plan2;
        LogicalPlan logicalPlan2 = (LogicalPlan)plan2.transformWithPruning((Function1<TreePatternBits, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.containsAnyPattern((Seq<Enumeration.Value>)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.WINDOW(), TreePattern$.MODULE$.JOIN()}))), plan2.transformWithPruning$default$2(), new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Join join;
                Option<Tuple7<JoinType, Seq<Expression>, Seq<Expression>, Option<Expression>, LogicalPlan, LogicalPlan, JoinHint>> option;
                Object object;
                Window window;
                A1 A1 = x1;
                if (A1 instanceof Window && (window = (Window)A1).partitionSpec().exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)anonfun.apply.2.$anonfun$applyOrElse$1(p)))) {
                    Seq x$1 = (Seq)window.partitionSpec().map((Function1 & Serializable & scala.Serializable)expr -> NormalizeFloatingNumbers$.MODULE$.normalize((Expression)expr), Seq$.MODULE$.canBuildFrom());
                    Seq<NamedExpression> x$2 = window.copy$default$1();
                    Seq<SortOrder> x$3 = window.copy$default$3();
                    LogicalPlan x$4 = window.copy$default$4();
                    object = window.copy(x$2, (Seq<Expression>)x$1, x$3, x$4);
                    return (B1)object;
                }
                if (A1 instanceof Join && !(option = ExtractEquiJoinKeys$.MODULE$.unapply(join = (Join)A1)).isEmpty()) {
                    Seq leftKeys = (Seq)((Tuple7)option.get())._2();
                    Seq rightKeys = (Seq)((Tuple7)option.get())._3();
                    Option condition = (Option)((Tuple7)option.get())._4();
                    if (leftKeys.exists((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)anonfun.apply.2.$anonfun$applyOrElse$3(k)))) {
                        Seq newLeftJoinKeys = (Seq)leftKeys.map((Function1 & Serializable & scala.Serializable)expr -> NormalizeFloatingNumbers$.MODULE$.normalize((Expression)expr), Seq$.MODULE$.canBuildFrom());
                        Seq newRightJoinKeys = (Seq)rightKeys.map((Function1 & Serializable & scala.Serializable)expr -> NormalizeFloatingNumbers$.MODULE$.normalize((Expression)expr), Seq$.MODULE$.canBuildFrom());
                        Seq newConditions = (Seq)((TraversableLike)((TraversableLike)newLeftJoinKeys.zip((GenIterable)newRightJoinKeys, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Expression l = (Expression)tuple2._1();
                            Expression r = (Expression)tuple2._2();
                            EqualTo equalTo = new EqualTo(l, r);
                            return equalTo;
                        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(condition), Seq$.MODULE$.canBuildFrom());
                        Some x$5 = new Some(newConditions.reduce((Function2)And$.MODULE$));
                        LogicalPlan x$6 = join.copy$default$1();
                        LogicalPlan x$7 = join.copy$default$2();
                        JoinType x$8 = join.copy$default$3();
                        JoinHint x$9 = join.copy$default$5();
                        object = join.copy(x$6, x$7, x$8, (Option<Expression>)x$5, x$9);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                Seq leftKeys;
                Join join;
                Option<Tuple7<JoinType, Seq<Expression>, Seq<Expression>, Option<Expression>, LogicalPlan, LogicalPlan, JoinHint>> option;
                Window window;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof Window && (window = (Window)logicalPlan).partitionSpec().exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)anonfun.apply.2.$anonfun$isDefinedAt$1(p))) ? true : logicalPlan instanceof Join && !(option = ExtractEquiJoinKeys$.MODULE$.unapply(join = (Join)logicalPlan)).isEmpty() && (leftKeys = (Seq)((Tuple7)option.get())._2()).exists((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)anonfun.apply.2.$anonfun$isDefinedAt$2(k)));
                return bl;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(Expression p) {
                return NormalizeFloatingNumbers$.MODULE$.org$apache$spark$sql$catalyst$optimizer$NormalizeFloatingNumbers$$needNormalize(p);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$3(Expression k) {
                return NormalizeFloatingNumbers$.MODULE$.org$apache$spark$sql$catalyst$optimizer$NormalizeFloatingNumbers$$needNormalize(k);
            }

            public static final /* synthetic */ boolean $anonfun$isDefinedAt$1(Expression p) {
                return NormalizeFloatingNumbers$.MODULE$.org$apache$spark$sql$catalyst$optimizer$NormalizeFloatingNumbers$$needNormalize(p);
            }

            public static final /* synthetic */ boolean $anonfun$isDefinedAt$2(Expression k) {
                return NormalizeFloatingNumbers$.MODULE$.org$apache$spark$sql$catalyst$optimizer$NormalizeFloatingNumbers$$needNormalize(k);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$applyOrElse$3$adapted(org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$applyOrElse$4(org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$applyOrElse$5(org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$applyOrElse$6(scala.Tuple2 ), $anonfun$isDefinedAt$1$adapted(org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$isDefinedAt$2$adapted(org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
            }
        });
        return logicalPlan2;
    }

    public boolean org$apache$spark$sql$catalyst$optimizer$NormalizeFloatingNumbers$$needNormalize(Expression expr) {
        Expression expression = expr;
        boolean bl = expression instanceof KnownFloatingPointNormalized ? false : this.needNormalize(expr.dataType());
        return bl;
    }

    private boolean needNormalize(DataType dt) {
        boolean bl;
        block4: {
            DataType dataType;
            while (true) {
                DataType et;
                boolean bl2;
                if (bl2 = FloatType$.MODULE$.equals(dataType = dt) ? true : DoubleType$.MODULE$.equals(dataType)) {
                    bl = true;
                    break block4;
                }
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    StructField[] fields = structType.fields();
                    bl = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)NormalizeFloatingNumbers$.MODULE$.needNormalize(f.dataType())));
                    break block4;
                }
                if (!(dataType instanceof ArrayType)) break;
                ArrayType arrayType = (ArrayType)dataType;
                dt = et = arrayType.elementType();
            }
            if (dataType instanceof MapType) {
                throw new IllegalStateException("grouping/join/window partition keys cannot be map type.");
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression normalize(Expression expr2) {
        Expression expression = expr2;
        if (!this.org$apache$spark$sql$catalyst$optimizer$NormalizeFloatingNumbers$$needNormalize(expr2)) {
            return expr2;
        }
        if (expression instanceof Alias) {
            Alias alias = (Alias)expression;
            return (Expression)alias.withNewChildren((Seq)new .colon.colon((Object)this.normalize(alias.child()), (List)Nil$.MODULE$));
        }
        if (expression instanceof CreateNamedStruct) {
            CreateNamedStruct createNamedStruct = (CreateNamedStruct)expression;
            Seq<Expression> children2 = createNamedStruct.children();
            return new CreateNamedStruct((Seq<Expression>)((Seq)children2.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.normalize((Expression)expr), Seq$.MODULE$.canBuildFrom())));
        }
        if (expression instanceof CreateArray) {
            CreateArray createArray = (CreateArray)expression;
            Seq<Expression> children3 = createArray.children();
            boolean useStringTypeWhenEmpty = createArray.useStringTypeWhenEmpty();
            return new CreateArray((Seq<Expression>)((Seq)children3.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.normalize((Expression)expr), Seq$.MODULE$.canBuildFrom())), useStringTypeWhenEmpty);
        }
        if (expression instanceof CreateMap) {
            CreateMap createMap = (CreateMap)expression;
            Seq<Expression> children4 = createMap.children();
            boolean useStringTypeWhenEmpty = createMap.useStringTypeWhenEmpty();
            return new CreateMap((Seq<Expression>)((Seq)children4.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.normalize((Expression)expr), Seq$.MODULE$.canBuildFrom())), useStringTypeWhenEmpty);
        }
        DataType dataType = expr2.dataType();
        FloatType$ floatType$ = FloatType$.MODULE$;
        if (dataType == null) {
            if (floatType$ == null) return new KnownFloatingPointNormalized(new NormalizeNaNAndZero(expr2));
        } else if (dataType.equals(floatType$)) return new KnownFloatingPointNormalized(new NormalizeNaNAndZero(expr2));
        DataType dataType2 = expr2.dataType();
        DoubleType$ doubleType$ = DoubleType$.MODULE$;
        if (dataType2 == null) {
            if (doubleType$ == null) return new KnownFloatingPointNormalized(new NormalizeNaNAndZero(expr2));
        } else if (dataType2.equals(doubleType$)) {
            return new KnownFloatingPointNormalized(new NormalizeNaNAndZero(expr2));
        }
        if (expression instanceof If) {
            If if_ = (If)expression;
            Expression cond = if_.predicate();
            Expression trueValue = if_.trueValue();
            Expression falseValue = if_.falseValue();
            return new If(cond, this.normalize(trueValue), this.normalize(falseValue));
        }
        if (expression instanceof CaseWhen) {
            CaseWhen caseWhen = (CaseWhen)expression;
            Seq<Tuple2<Expression, Expression>> branches = caseWhen.branches();
            Option<Expression> elseVale = caseWhen.elseValue();
            return new CaseWhen((Seq<Tuple2<Expression, Expression>>)((Seq)branches.map((Function1 & Serializable & scala.Serializable)br -> new Tuple2(br._1(), (Object)MODULE$.normalize((Expression)br._2())), Seq$.MODULE$.canBuildFrom())), (Option<Expression>)elseVale.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.normalize((Expression)expr)));
        }
        if (expression instanceof Coalesce) {
            Coalesce coalesce = (Coalesce)expression;
            Seq<Expression> children5 = coalesce.children();
            return new Coalesce((Seq<Expression>)((Seq)children5.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.normalize((Expression)expr), Seq$.MODULE$.canBuildFrom())));
        }
        if (expr2.dataType() instanceof StructType) {
            Seq[] fields = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((StructType)expr2.dataType()).fieldNames())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                int i = tuple2._2$mcI$sp();
                Seq seq = (Seq)new .colon.colon((Object)Literal$.MODULE$.apply(name), (List)new .colon.colon((Object)MODULE$.normalize(new GetStructField(expr2, i, GetStructField$.MODULE$.apply$default$3())), (List)Nil$.MODULE$));
                return seq;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
            CreateNamedStruct struct = new CreateNamedStruct((Seq<Expression>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).flatten((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(Expression.class)))).toSeq());
            return new KnownFloatingPointNormalized(new If(new IsNull(expr2), new Literal(null, struct.dataType()), struct));
        }
        if (!(expr2.dataType() instanceof ArrayType)) throw new IllegalStateException(new StringBuilder(18).append("fail to normalize ").append(expr2).toString());
        DataType dataType3 = expr2.dataType();
        if (!(dataType3 instanceof ArrayType)) throw new MatchError((Object)dataType3);
        ArrayType arrayType = (ArrayType)dataType3;
        DataType et = arrayType.elementType();
        boolean containsNull = arrayType.containsNull();
        Tuple2 tuple2 = new Tuple2((Object)et, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull));
        Tuple2 tuple22 = tuple2;
        DataType et2 = (DataType)tuple22._1();
        boolean containsNull2 = tuple22._2$mcZ$sp();
        NamedLambdaVariable lv = new NamedLambdaVariable("arg", et2, containsNull2, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        Expression function = this.normalize(lv);
        return new KnownFloatingPointNormalized(new ArrayTransform(expr2, new LambdaFunction(function, (Seq<NamedExpression>)((Seq)new .colon.colon((Object)lv, (List)Nil$.MODULE$)), LambdaFunction$.MODULE$.apply$default$3())));
    }

    public Function1<Object, Object> FLOAT_NORMALIZER() {
        return this.FLOAT_NORMALIZER;
    }

    public Function1<Object, Object> DOUBLE_NORMALIZER() {
        return this.DOUBLE_NORMALIZER;
    }

    private NormalizeFloatingNumbers$() {
        MODULE$ = this;
        this.FLOAT_NORMALIZER = (Function1 & Serializable & scala.Serializable)input -> {
            float f = BoxesRunTime.unboxToFloat((Object)input);
            return Float.isNaN(f) ? BoxesRunTime.boxToFloat((float)Float.NaN) : (f == -0.0f ? BoxesRunTime.boxToFloat((float)0.0f) : BoxesRunTime.boxToFloat((float)f));
        };
        this.DOUBLE_NORMALIZER = (Function1 & Serializable & scala.Serializable)input -> {
            double d = BoxesRunTime.unboxToDouble((Object)input);
            return Double.isNaN(d) ? BoxesRunTime.boxToDouble((double)Double.NaN) : (d == -0.0 ? BoxesRunTime.boxToDouble((double)0.0) : BoxesRunTime.boxToDouble((double)d));
        };
    }
}

