/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringRepeat$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, n) - Returns the string which repeats the given string value n times.", examples="\n    Examples:\n      > SELECT _FUNC_('123', 2);\n       123123\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001\u0002\u0010 \u00012B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\"A!\n\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005L\u0001\tE\t\u0015!\u0003G\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015\t\u0006\u0001\"\u0011F\u0011\u0015\u0011\u0006\u0001\"\u0011F\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015\t\b\u0001\"\u0011s\u0011\u0015Y\b\u0001\"\u0011}\u0011\u001d\t)\u0002\u0001C)\u0003/A\u0011\"!\t\u0001\u0003\u0003%\t!a\t\t\u0013\u0005%\u0002!%A\u0005\u0002\u0005-\u0002\"CA!\u0001E\u0005I\u0011AA\u0016\u0011%\t\u0019\u0005AA\u0001\n\u0003\n)\u0005C\u0005\u0002V\u0001\t\t\u0011\"\u0001\u0002X!I\u0011q\f\u0001\u0002\u0002\u0013\u0005\u0011\u0011\r\u0005\n\u0003O\u0002\u0011\u0011!C!\u0003SB\u0011\"a\u001e\u0001\u0003\u0003%\t!!\u001f\t\u0013\u0005\r\u0005!!A\u0005B\u0005\u0015u!CAU?\u0005\u0005\t\u0012AAV\r!qr$!A\t\u0002\u00055\u0006B\u0002'\u0019\t\u0003\tY\fC\u0005\u0002>b\t\t\u0011\"\u0012\u0002@\"I\u0011\u0011\u0019\r\u0002\u0002\u0013\u0005\u00151\u0019\u0005\n\u0003\u0013D\u0012\u0011!CA\u0003\u0017D\u0011\"!8\u0019\u0003\u0003%I!a8\u0003\u0019M#(/\u001b8h%\u0016\u0004X-\u0019;\u000b\u0005\u0001\n\u0013aC3yaJ,7o]5p]NT!AI\u0012\u0002\u0011\r\fG/\u00197zgRT!\u0001J\u0013\u0002\u0007M\fHN\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u00172im\n\u0005C\u0001\u00180\u001b\u0005y\u0012B\u0001\u0019 \u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002/e%\u00111g\b\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011Q\u0007\u000f\b\u0003]YJ!aN\u0010\u0002\u000fA\f7m[1hK&\u0011\u0011H\u000f\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\t9t\u0004\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UHA\u0004Qe>$Wo\u0019;\u0011\u0005q\u0012\u0015BA\">\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\r\u0019HO]\u000b\u0002\rB\u0011afR\u0005\u0003\u0011~\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0011\u0019HO\u001d\u0011\u0002\u000bQLW.Z:\u0002\rQLW.Z:!\u0003\u0019a\u0014N\\5u}Q\u0019aj\u0014)\u0011\u00059\u0002\u0001\"\u0002#\u0006\u0001\u00041\u0005\"\u0002&\u0006\u0001\u00041\u0015\u0001\u00027fMR\fQA]5hQR\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002+B\u0011a+W\u0007\u0002/*\u0011\u0001lI\u0001\u0006if\u0004Xm]\u0005\u00035^\u0013\u0001\u0002R1uCRK\b/Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A/\u0011\u0007y+WK\u0004\u0002`I:\u0011\u0001mY\u0007\u0002C*\u0011!mK\u0001\u0007yI|w\u000e\u001e \n\u0003yJ!aN\u001f\n\u0005\u0019<'aA*fc*\u0011q'P\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004U6|\u0007C\u0001\u001fl\u0013\taWHA\u0002B]fDQA\u001c\u0006A\u0002)\faa\u001d;sS:<\u0007\"\u00029\u000b\u0001\u0004Q\u0017!\u00018\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001t!\t!\bP\u0004\u0002vmB\u0011\u0001-P\u0005\u0003ov\na\u0001\u0015:fI\u00164\u0017BA={\u0005\u0019\u0019FO]5oO*\u0011q/P\u0001\nI><UM\\\"pI\u0016$R!`A\u0004\u0003#\u00012A`A\u0002\u001b\u0005y(bAA\u0001?\u000591m\u001c3fO\u0016t\u0017bAA\u0003\u007f\nAQ\t\u001f9s\u0007>$W\rC\u0004\u0002\n1\u0001\r!a\u0003\u0002\u0007\r$\b\u0010E\u0002\u007f\u0003\u001bI1!a\u0004\u0000\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDa!a\u0005\r\u0001\u0004i\u0018AA3w\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003O\u00033\ti\u0002\u0003\u0004\u0002\u001c5\u0001\rAR\u0001\b]\u0016<H*\u001a4u\u0011\u0019\ty\"\u0004a\u0001\r\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLH#\u0002(\u0002&\u0005\u001d\u0002b\u0002#\u000f!\u0003\u0005\rA\u0012\u0005\b\u0015:\u0001\n\u00111\u0001G\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\f+\u0007\u0019\u000byc\u000b\u0002\u00022A!\u00111GA\u001f\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012!C;oG\",7m[3e\u0015\r\tY$P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA \u0003k\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA$!\u0011\tI%a\u0015\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\nA\u0001\\1oO*\u0011\u0011\u0011K\u0001\u0005U\u00064\u0018-C\u0002z\u0003\u0017\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0017\u0011\u0007q\nY&C\u0002\u0002^u\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2A[A2\u0011%\t)gEA\u0001\u0002\u0004\tI&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003W\u0002R!!\u001c\u0002t)l!!a\u001c\u000b\u0007\u0005ET(\u0001\u0006d_2dWm\u0019;j_:LA!!\u001e\u0002p\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tY(!!\u0011\u0007q\ni(C\u0002\u0002\u0000u\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002fU\t\t\u00111\u0001k\u0003\u0019)\u0017/^1mgR!\u00111PAD\u0011!\t)GFA\u0001\u0002\u0004Q\u0007f\u0005\u0001\u0002\f\u0006E\u00151SAL\u00033\u000bi*a(\u0002$\u0006\u0015\u0006c\u0001\u0018\u0002\u000e&\u0019\u0011qR\u0010\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QS\u0001R?\u001a+fjQ0)gR\u0014H\u0006\t8*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fAM$(/\u001b8hA]D\u0017n\u00195!e\u0016\u0004X-\u0019;tAQDW\rI4jm\u0016t\u0007e\u001d;sS:<\u0007E^1mk\u0016\u0004c\u000e\t;j[\u0016\u001ch&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tY*\u0001!\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n$gM\u0014-AIJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u00193gE\u00124G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\t+A\u00032]Ur\u0003'A\u0003he>,\b/\t\u0002\u0002(\u0006a1\u000f\u001e:j]\u001e|f-\u001e8dg\u0006a1\u000b\u001e:j]\u001e\u0014V\r]3biB\u0011a\u0006G\n\u00051\u0005=\u0016\tE\u0004\u00022\u0006]fI\u0012(\u000e\u0005\u0005M&bAA[{\u00059!/\u001e8uS6,\u0017\u0002BA]\u0003g\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\tY+\u0001\u0005u_N#(/\u001b8h)\t\t9%A\u0003baBd\u0017\u0010F\u0003O\u0003\u000b\f9\rC\u0003E7\u0001\u0007a\tC\u0003K7\u0001\u0007a)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u00055\u0017\u0011\u001c\t\u0006y\u0005=\u00171[\u0005\u0004\u0003#l$AB(qi&|g\u000eE\u0003=\u0003+4e)C\u0002\u0002Xv\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAn9\u0005\u0005\t\u0019\u0001(\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAq!\u0011\tI%a9\n\t\u0005\u0015\u00181\n\u0002\u0007\u001f\nTWm\u0019;")
public class StringRepeat
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression str;
    private final Expression times;

    public static Option<Tuple2<Expression, Expression>> unapply(StringRepeat stringRepeat) {
        return StringRepeat$.MODULE$.unapply(stringRepeat);
    }

    public static Function1<Tuple2<Expression, Expression>, StringRepeat> tupled() {
        return StringRepeat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, StringRepeat>> curried() {
        return StringRepeat$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression times() {
        return this.times;
    }

    @Override
    public Expression left() {
        return this.str();
    }

    @Override
    public Expression right() {
        return this.times();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public Object nullSafeEval(Object string, Object n) {
        return ((UTF8String)string).repeat(Predef$.MODULE$.Integer2int((Integer)n));
    }

    @Override
    public String prettyName() {
        return "repeat";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(l, r) -> new StringBuilder(11).append("(").append((String)l).append(").repeat(").append((String)r).append(")").toString());
    }

    @Override
    public StringRepeat withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public StringRepeat copy(Expression str, Expression times) {
        return new StringRepeat(str, times);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.times();
    }

    @Override
    public String productPrefix() {
        return "StringRepeat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.times();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringRepeat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringRepeat)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringRepeat stringRepeat = (StringRepeat)x$1;
        Expression expression = this.str();
        Expression expression2 = stringRepeat.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.times();
        Expression expression4 = stringRepeat.times();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!stringRepeat.canEqual(this)) return false;
        return true;
    }

    public StringRepeat(Expression str, Expression times) {
        this.str = str;
        this.times = times;
        ExpectsInputTypes.$init$(this);
    }
}

