/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.WidthBucket$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import scala.Function4;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(value, min_value, max_value, num_bucket) - Returns the bucket number to which\n      `value` would be assigned in an equiwidth histogram with `num_bucket` buckets,\n      in the range `min_value` to `max_value`.\"\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(5.3, 0.2, 10.6, 5);\n       3\n      > SELECT _FUNC_(-2.1, 1.3, 3.4, 3);\n       0\n      > SELECT _FUNC_(8.1, 0.0, 5.7, 4);\n       5\n      > SELECT _FUNC_(-0.9, 5.2, 0.5, 2);\n       3\n  ", since="3.1.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\tMs!B\u0015+\u0011\u00039d!B\u001d+\u0011\u0003Q\u0004\"\u0002#\u0002\t\u0003)\u0005\"\u0002$\u0002\t\u00039\u0005\"B/\u0002\t\u0003q\u0006\"\u00024\u0002\t\u00039\u0007b\u00027\u0002\u0003\u0003%\t)\u001c\u0005\n\u0005k\t\u0011\u0011!CA\u0005oA\u0011B!\u0013\u0002\u0003\u0003%IAa\u0013\u0007\teR\u0003i\u001c\u0005\n#&\u0011)\u001a!C\u0001\u0003\u0003A!\"!\u0003\n\u0005#\u0005\u000b\u0011BA\u0002\u0011)\tY!\u0003BK\u0002\u0013\u0005\u0011\u0011\u0001\u0005\u000b\u0003\u001bI!\u0011#Q\u0001\n\u0005\r\u0001BCA\b\u0013\tU\r\u0011\"\u0001\u0002\u0002!Q\u0011\u0011C\u0005\u0003\u0012\u0003\u0006I!a\u0001\t\u0013iK!Q3A\u0005\u0002\u0005\u0005\u0001BCA\n\u0013\tE\t\u0015!\u0003\u0002\u0004!1A)\u0003C\u0001\u0003+Aq!a\b\n\t\u0003\n\t\u0003C\u0004\u0002F%!\t%a\u0012\t\u000f\u0005=\u0013\u0002\"\u0011\u0002R!9\u00111K\u0005\u0005B\u0005U\u0003bBA4\u0013\u0011E\u0013\u0011\u000e\u0005\b\u0003wJA\u0011IA?\u0011\u001d\tI*\u0003C!\u0003\u0003Aq!a'\n\t\u0003\n\t\u0001C\u0004\u0002\u001e&!\t%!\u0001\t\u000f\u0005}\u0015\u0002\"\u0011\u0002\u0002!9\u0011\u0011U\u0005\u0005R\u0005\r\u0006\"CAW\u0013\u0005\u0005I\u0011AAX\u0011%\tI,CI\u0001\n\u0003\tY\fC\u0005\u0002R&\t\n\u0011\"\u0001\u0002<\"I\u00111[\u0005\u0012\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003+L\u0011\u0013!C\u0001\u0003wC\u0011\"a6\n\u0003\u0003%\t%!7\t\u0013\u0005}\u0017\"!A\u0005\u0002\u0005\u0005\b\"CAu\u0013\u0005\u0005I\u0011AAv\u0011%\t\t0CA\u0001\n\u0003\n\u0019\u0010C\u0005\u0003\u0002%\t\t\u0011\"\u0001\u0003\u0004!I!qA\u0005\u0002\u0002\u0013\u0005#\u0011B\u0001\f/&$G\u000f\u001b\"vG.,GO\u0003\u0002,Y\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tic&\u0001\u0005dCR\fG._:u\u0015\ty\u0003'A\u0002tc2T!!\r\u001a\u0002\u000bM\u0004\u0018M]6\u000b\u0005M\"\u0014AB1qC\u000eDWMC\u00016\u0003\ry'oZ\u0002\u0001!\tA\u0014!D\u0001+\u0005-9\u0016\u000e\u001a;i\u0005V\u001c7.\u001a;\u0014\u0007\u0005Y\u0014\t\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UH\u0001\u0004B]f\u0014VM\u001a\t\u0003y\tK!aQ\u001f\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u00059\u0014aE2p[B,H/\u001a\"vG.,GOT;nE\u0016\u0014H#\u0002%Q+^K\u0006CA%O\u001b\u0005Q%BA&M\u0003\u0011a\u0017M\\4\u000b\u00035\u000bAA[1wC&\u0011qJ\u0013\u0002\u0005\u0019>tw\rC\u0003R\u0007\u0001\u0007!+A\u0003wC2,X\r\u0005\u0002='&\u0011A+\u0010\u0002\u0007\t>,(\r\\3\t\u000bY\u001b\u0001\u0019\u0001*\u0002\u00075Lg\u000eC\u0003Y\u0007\u0001\u0007!+A\u0002nCbDQAW\u0002A\u0002m\u000b\u0011B\\;n\u0005V\u001c7.\u001a;\u0011\u0005qb\u0016BA(>\u0003\u0019I7OT;mYR)qLY2eKB\u0011A\bY\u0005\u0003Cv\u0012qAQ8pY\u0016\fg\u000eC\u0003R\t\u0001\u0007!\u000bC\u0003W\t\u0001\u0007!\u000bC\u0003Y\t\u0001\u0007!\u000bC\u0003[\t\u0001\u00071,\u0001\u000ed_6\u0004X\u000f^3Ck\u000e\\W\r\u001e(v[\n,'OT8u\u001dVdG\u000eF\u0003IQ&T7\u000eC\u0003R\u000b\u0001\u0007!\u000bC\u0003W\u000b\u0001\u0007!\u000bC\u0003Y\u000b\u0001\u0007!\u000bC\u0003[\u000b\u0001\u00071,A\u0003baBd\u0017\u0010F\u0005o\u0005[\u0011yC!\r\u00034A\u0011\u0001(C\n\u0007\u0013A\u001ch/`!\u0011\u0005a\n\u0018B\u0001:+\u0005Q\tV/\u0019;fe:\f'/_#yaJ,7o]5p]B\u0011\u0001\b^\u0005\u0003k*\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003ojt!\u0001\u000f=\n\u0005eT\u0013a\u00029bG.\fw-Z\u0005\u0003wr\u0014aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002zUA\u0011AH`\u0005\u0003\u007fv\u0012q\u0001\u0015:pIV\u001cG/\u0006\u0002\u0002\u0004A\u0019\u0001(!\u0002\n\u0007\u0005\u001d!F\u0001\u0006FqB\u0014Xm]:j_:\faA^1mk\u0016\u0004\u0013\u0001C7j]Z\u000bG.^3\u0002\u00135LgNV1mk\u0016\u0004\u0013\u0001C7bqZ\u000bG.^3\u0002\u00135\f\u0007PV1mk\u0016\u0004\u0013A\u00038v[\n+8m[3uAQIa.a\u0006\u0002\u001a\u0005m\u0011Q\u0004\u0005\u0007#J\u0001\r!a\u0001\t\u000f\u0005-!\u00031\u0001\u0002\u0004!9\u0011q\u0002\nA\u0002\u0005\r\u0001B\u0002.\u0013\u0001\u0004\t\u0019!\u0001\u0006j]B,H\u000fV=qKN,\"!a\t\u0011\r\u0005\u0015\u00121GA\u001d\u001d\u0011\t9#!\r\u000f\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\f7\u0003\u0019a$o\\8u}%\ta(\u0003\u0002z{%!\u0011QGA\u001c\u0005\r\u0019V-\u001d\u0006\u0003sv\u0002B!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0004\u0003\u007fq\u0013!\u0002;za\u0016\u001c\u0018\u0002BA\"\u0003{\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!!\u0013\u0011\t\u0005m\u00121J\u0005\u0005\u0003\u001b\niD\u0001\u0005ECR\fG+\u001f9f\u0003!qW\u000f\u001c7bE2,W#A0\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002XA!\u0011\u0011LA1\u001d\u0011\tY&!\u0018\u0011\u0007\u0005%R(C\u0002\u0002`u\na\u0001\u0015:fI\u00164\u0017\u0002BA2\u0003K\u0012aa\u0015;sS:<'bAA0{\u0005aa.\u001e7m'\u00064W-\u0012<bYRQ\u00111NA9\u0003k\n9(!\u001f\u0011\u0007q\ni'C\u0002\u0002pu\u00121!\u00118z\u0011\u001d\t\u0019h\u0006a\u0001\u0003W\nQ!\u001b8qkRDaAV\fA\u0002\u0005-\u0004B\u0002-\u0018\u0001\u0004\tY\u0007\u0003\u0004[/\u0001\u0007\u00111N\u0001\nI><UM\\\"pI\u0016$b!a \u0002\f\u0006U\u0005\u0003BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u0015%&A\u0004d_\u0012,w-\u001a8\n\t\u0005%\u00151\u0011\u0002\t\u000bb\u0004(oQ8eK\"9\u0011Q\u0012\rA\u0002\u0005=\u0015aA2uqB!\u0011\u0011QAI\u0013\u0011\t\u0019*a!\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011q\u0013\rA\u0002\u0005}\u0014AA3w\u0003\u00151\u0017N]:u\u0003\u0019\u0019XmY8oI\u0006)A\u000f[5sI\u00061am\\;si\"\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u00139\f)+a*\u0002*\u0006-\u0006bBAM;\u0001\u0007\u00111\u0001\u0005\b\u00037k\u0002\u0019AA\u0002\u0011\u001d\ti*\ba\u0001\u0003\u0007Aq!a(\u001e\u0001\u0004\t\u0019!\u0001\u0003d_BLH#\u00038\u00022\u0006M\u0016QWA\\\u0011!\tf\u0004%AA\u0002\u0005\r\u0001\"CA\u0006=A\u0005\t\u0019AA\u0002\u0011%\tyA\bI\u0001\u0002\u0004\t\u0019\u0001\u0003\u0005[=A\u0005\t\u0019AA\u0002\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!0+\t\u0005\r\u0011qX\u0016\u0003\u0003\u0003\u0004B!a1\u0002N6\u0011\u0011Q\u0019\u0006\u0005\u0003\u000f\fI-A\u0005v]\u000eDWmY6fI*\u0019\u00111Z\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002P\u0006\u0015'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u001c\t\u0004\u0013\u0006u\u0017bAA2\u0015\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u001d\t\u0004y\u0005\u0015\u0018bAAt{\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111NAw\u0011%\ty/JA\u0001\u0002\u0004\t\u0019/A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003k\u0004b!a>\u0002~\u0006-TBAA}\u0015\r\tY0P\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0000\u0003s\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019qL!\u0002\t\u0013\u0005=x%!AA\u0002\u0005-\u0014AB3rk\u0006d7\u000fF\u0002`\u0005\u0017A\u0011\"a<)\u0003\u0003\u0005\r!a\u001b)'%\u0011yA!\u0006\u0003\u0018\tm!Q\u0004B\u0011\u0005G\u00119C!\u000b\u0011\u0007a\u0012\t\"C\u0002\u0003\u0014)\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003\u001a\u0005\t\u0019M\u0003\u0011!A\u0001zf)\u0016(D?\"2\u0018\r\\;fY\u0001j\u0017N\\0wC2,X\r\f\u0011nCb|f/\u00197vK2\u0002c.^7`EV\u001c7.\u001a;*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA\t,8m[3uA9,XNY3sAQ|\u0007e\u001e5jG\"T\u0001\u0005\t\u0011!A\u0001\u0002g/\u00197vK\u0002\u0004so\\;mI\u0002\u0012W\rI1tg&<g.\u001a3!S:\u0004\u0013M\u001c\u0011fcVLw/\u001b3uQ\u0002B\u0017n\u001d;pOJ\fW\u000eI<ji\"\u0004\u0003M\\;n?\n,8m[3uA\u0002\u0012WoY6fiNd#\u0002\t\u0011!A\u0001\u0002\u0013N\u001c\u0011uQ\u0016\u0004#/\u00198hK\u0002\u0002W.\u001b8`m\u0006dW/\u001a1!i>\u0004\u0003-\\1y?Z\fG.^3a]\tR\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!qD\u0001\u0002:*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CSGL\u001a-AAr#\u0007\f\u00112a92D\u0006I\u001b*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00173]Eb\u0003%\r\u00184Y\u0001\u001ad\u0006\u000e\u0017!g%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)q9\nD\u0006\t\u0019/a1\u0002SGL\u001c-AQJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001b\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q5\u0002d&\u000f\u0017!k9\u0012D\u0006\t\u0019/k1\u0002#'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!g)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0003&\u0005)1GL\u0019/a\u0005)qM]8va\u0006\u0012!1F\u0001\u000b[\u0006$\bn\u00184v]\u000e\u001c\bBB)\u0007\u0001\u0004\t\u0019\u0001C\u0004\u0002\f\u0019\u0001\r!a\u0001\t\u000f\u0005=a\u00011\u0001\u0002\u0004!1!L\u0002a\u0001\u0003\u0007\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003:\t\u0015\u0003#\u0002\u001f\u0003<\t}\u0012b\u0001B\u001f{\t1q\n\u001d;j_:\u00042\u0002\u0010B!\u0003\u0007\t\u0019!a\u0001\u0002\u0004%\u0019!1I\u001f\u0003\rQ+\b\u000f\\35\u0011!\u00119eBA\u0001\u0002\u0004q\u0017a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011i\u0005E\u0002J\u0005\u001fJ1A!\u0015K\u0005\u0019y%M[3di\u0002")
public class WidthBucket
extends QuaternaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression value;
    private final Expression minValue;
    private final Expression maxValue;
    private final Expression numBucket;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(WidthBucket widthBucket) {
        return WidthBucket$.MODULE$.unapply(widthBucket);
    }

    public static Long computeBucketNumberNotNull(double d, double d2, double d3, long l) {
        return WidthBucket$.MODULE$.computeBucketNumberNotNull(d, d2, d3, l);
    }

    public static boolean isNull(double d, double d2, double d3, long l) {
        return WidthBucket$.MODULE$.isNull(d, d2, d3, l);
    }

    public static Long computeBucketNumber(double d, double d2, double d3, long l) {
        return WidthBucket$.MODULE$.computeBucketNumber(d, d2, d3, l);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression value() {
        return this.value;
    }

    public Expression minValue() {
        return this.minValue;
    }

    public Expression maxValue() {
        return this.maxValue;
    }

    public Expression numBucket() {
        return this.numBucket;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)DoubleType$.MODULE$, (List)new .colon.colon((Object)DoubleType$.MODULE$, (List)new .colon.colon((Object)DoubleType$.MODULE$, (List)new .colon.colon((Object)LongType$.MODULE$, (List)Nil$.MODULE$))));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "width_bucket";
    }

    @Override
    public Object nullSafeEval(Object input, Object min, Object max, Object numBucket) {
        return WidthBucket$.MODULE$.computeBucketNumber(BoxesRunTime.unboxToDouble((Object)input), BoxesRunTime.unboxToDouble((Object)min), BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToLong((Object)numBucket));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function4<String, String, String, String, String>)(Function4 & Serializable & scala.Serializable)(input, min, max, numBucket) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(236).append(ev.isNull()).append(" = org.apache.spark.sql.catalyst.expressions.WidthBucket\n         |  .isNull(").append((String)input).append(", ").append((String)min).append(", ").append((String)max).append(", ").append((String)numBucket).append(");\n         |if (!").append(ev.isNull()).append(") {\n         |  ").append(ev.value()).append(" = org.apache.spark.sql.catalyst.expressions.WidthBucket\n         |    .computeBucketNumberNotNull(").append((String)input).append(", ").append((String)min).append(", ").append((String)max).append(", ").append((String)numBucket).append(");\n         |}").toString())).stripMargin());
    }

    @Override
    public Expression first() {
        return this.value();
    }

    @Override
    public Expression second() {
        return this.minValue();
    }

    @Override
    public Expression third() {
        return this.maxValue();
    }

    @Override
    public Expression fourth() {
        return this.numBucket();
    }

    @Override
    public WidthBucket withNewChildrenInternal(Expression first, Expression second, Expression third, Expression fourth) {
        return this.copy(first, second, third, fourth);
    }

    public WidthBucket copy(Expression value, Expression minValue, Expression maxValue, Expression numBucket) {
        return new WidthBucket(value, minValue, maxValue, numBucket);
    }

    public Expression copy$default$1() {
        return this.value();
    }

    public Expression copy$default$2() {
        return this.minValue();
    }

    public Expression copy$default$3() {
        return this.maxValue();
    }

    public Expression copy$default$4() {
        return this.numBucket();
    }

    @Override
    public String productPrefix() {
        return "WidthBucket";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.value();
                break;
            }
            case 1: {
                expression = this.minValue();
                break;
            }
            case 2: {
                expression = this.maxValue();
                break;
            }
            case 3: {
                expression = this.numBucket();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof WidthBucket;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof WidthBucket)) return false;
        boolean bl = true;
        if (!bl) return false;
        WidthBucket widthBucket = (WidthBucket)x$1;
        Expression expression = this.value();
        Expression expression2 = widthBucket.value();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.minValue();
        Expression expression4 = widthBucket.minValue();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.maxValue();
        Expression expression6 = widthBucket.maxValue();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.numBucket();
        Expression expression8 = widthBucket.numBucket();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!widthBucket.canEqual(this)) return false;
        return true;
    }

    public WidthBucket(Expression value, Expression minValue, Expression maxValue, Expression numBucket) {
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.numBucket = numBucket;
        ExpectsInputTypes.$init$(this);
    }
}

