/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.ToNumber;
import org.apache.spark.sql.catalyst.expressions.TryToNumber$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ToNumberParser;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n     _FUNC_(expr, fmt) - Convert string 'expr' to a number based on the string format `fmt`.\n       Returns NULL if the string 'expr' does not match the expected format. The format follows the\n       same semantics as the to_number function.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('454', '999');\n       454\n      > SELECT _FUNC_('454.00', '000.00');\n       454.00\n      > SELECT _FUNC_('12,454', '99,999');\n       12454\n      > SELECT _FUNC_('$78.12', '$99.99');\n       78.12\n      > SELECT _FUNC_('12,454.8-', '99,999.9S');\n       -12454.8\n  ", since="3.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\t5a\u0001\u0002\u0011\"\u0001:B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0011\"AA\n\u0001BK\u0002\u0013\u0005q\t\u0003\u0005N\u0001\tE\t\u0015!\u0003I\u0011\u0015q\u0005\u0001\"\u0001P\u0011!\u0019\u0006\u0001#b\u0001\n\u0013!\u0006\u0002C/\u0001\u0011\u000b\u0007I\u0011\u00020\t\u000b\u0015\u0004A\u0011\t4\t\u000b5\u0004A\u0011\t8\t\u000bi\u0004A\u0011I>\t\r}\u0004A\u0011IA\u0001\u0011\u001d\ty\u0001\u0001C!\u0003#Aq!!\t\u0001\t\u0003\n\u0019\u0003C\u0004\u00024\u0001!\t%!\u000e\t\u000f\u0005E\u0003\u0001\"\u0015\u0002T!I\u0011Q\f\u0001\u0002\u0002\u0013\u0005\u0011q\f\u0005\n\u0003K\u0002\u0011\u0013!C\u0001\u0003OB\u0011\"! \u0001#\u0003%\t!a\u001a\t\u0011\u0005}\u0004!!A\u0005BQC\u0011\"!!\u0001\u0003\u0003%\t!a!\t\u0013\u0005-\u0005!!A\u0005\u0002\u00055\u0005\"CAJ\u0001\u0005\u0005I\u0011IAK\u0011%\t\u0019\u000bAA\u0001\n\u0003\t)\u000bC\u0005\u0002*\u0002\t\t\u0011\"\u0011\u0002,\u001eI\u0011qZ\u0011\u0002\u0002#\u0005\u0011\u0011\u001b\u0004\tA\u0005\n\t\u0011#\u0001\u0002T\"1aJ\u0007C\u0001\u0003CD\u0011\"a9\u001b\u0003\u0003%)%!:\t\u0013\u0005\u001d($!A\u0005\u0002\u0006%\b\"CAx5\u0005\u0005I\u0011QAy\u0011%\u0011\u0019AGA\u0001\n\u0013\u0011)AA\u0006Uef$vNT;nE\u0016\u0014(B\u0001\u0012$\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0011*\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0019:\u0013aA:rY*\u0011\u0001&K\u0001\u0006gB\f'o\u001b\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001y3GN\u001fD!\t\u0001\u0014'D\u0001\"\u0013\t\u0011\u0014E\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0001\u0007N\u0005\u0003k\u0005\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003oir!\u0001\r\u001d\n\u0005e\n\u0013a\u00029bG.\fw-Z\u0005\u0003wq\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002:CA\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t9\u0001K]8ek\u000e$\bC\u0001 E\u0013\t)uH\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003mK\u001a$X#\u0001%\u0011\u0005AJ\u0015B\u0001&\"\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\r\u0001\u0016K\u0015\t\u0003a\u0001AQAR\u0003A\u0002!CQ\u0001T\u0003A\u0002!\u000bAB\\;nE\u0016\u0014hi\u001c:nCR,\u0012!\u0016\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000bA\u0001\\1oO*\t!,\u0001\u0003kCZ\f\u0017B\u0001/X\u0005\u0019\u0019FO]5oO\u0006ya.^7cKJ4uN]7biR,'/F\u0001`!\t\u00017-D\u0001b\u0015\t\u00117%\u0001\u0003vi&d\u0017B\u00013b\u00059!vNT;nE\u0016\u0014\b+\u0019:tKJ\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002OB\u0011\u0001n[\u0007\u0002S*\u0011!.J\u0001\u0006if\u0004Xm]\u0005\u0003Y&\u0014\u0001\u0002R1uCRK\b/Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A8\u0011\u0007A<xM\u0004\u0002rm:\u0011!/^\u0007\u0002g*\u0011A/L\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001K!!O \n\u0005aL(aA*fc*\u0011\u0011hP\u0001\t]VdG.\u00192mKV\tA\u0010\u0005\u0002?{&\u0011ap\u0010\u0002\b\u0005>|G.Z1o\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tIaI\u0001\tC:\fG._:jg&!\u0011QBA\u0004\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018A\u00039sKR$\u0018PT1nKV\u0011\u00111\u0003\t\u0005\u0003+\tiB\u0004\u0003\u0002\u0018\u0005e\u0001C\u0001:@\u0013\r\tYbP\u0001\u0007!J,G-\u001a4\n\u0007q\u000byBC\u0002\u0002\u001c}\nAB\\;mYN\u000bg-Z#wC2$b!!\n\u0002,\u0005=\u0002c\u0001 \u0002(%\u0019\u0011\u0011F \u0003\u0007\u0005s\u0017\u0010C\u0004\u0002.5\u0001\r!!\n\u0002\rM$(/\u001b8h\u0011\u001d\t\t$\u0004a\u0001\u0003K\taAZ8s[\u0006$\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t9$a\u0011\u0002NA!\u0011\u0011HA \u001b\t\tYDC\u0002\u0002>\u0005\nqaY8eK\u001e,g.\u0003\u0003\u0002B\u0005m\"\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005\u0015c\u00021\u0001\u0002H\u0005\u00191\r\u001e=\u0011\t\u0005e\u0012\u0011J\u0005\u0005\u0003\u0017\nYD\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005=c\u00021\u0001\u00028\u0005\u0011QM^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$R\u0001UA+\u00033Ba!a\u0016\u0010\u0001\u0004A\u0015a\u00028fo2+g\r\u001e\u0005\u0007\u00037z\u0001\u0019\u0001%\u0002\u00119,wOU5hQR\fAaY8qsR)\u0001+!\u0019\u0002d!9a\t\u0005I\u0001\u0002\u0004A\u0005b\u0002'\u0011!\u0003\u0005\r\u0001S\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIGK\u0002I\u0003WZ#!!\u001c\u0011\t\u0005=\u0014\u0011P\u0007\u0003\u0003cRA!a\u001d\u0002v\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003oz\u0014AC1o]>$\u0018\r^5p]&!\u00111PA9\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0011\t\u0004}\u0005\u001d\u0015bAAE\u007f\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QEAH\u0011%\t\t*FA\u0001\u0002\u0004\t))A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003/\u0003b!!'\u0002 \u0006\u0015RBAAN\u0015\r\tijP\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAQ\u00037\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019A0a*\t\u0013\u0005Eu#!AA\u0002\u0005\u0015\u0012AB3rk\u0006d7\u000fF\u0002}\u0003[C\u0011\"!%\u0019\u0003\u0003\u0005\r!!\n)'\u0001\t\t,a.\u0002:\u0006u\u0016qXAb\u0003\u000b\fI-a3\u0011\u0007A\n\u0019,C\u0002\u00026\u0006\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002<\u0006\tYO\u0003\u0011!A\u0001\u0002sLR+O\u0007~CS\r\u001f9sY\u00012W\u000e^\u0015![\u0001\u001auN\u001c<feR\u00043\u000f\u001e:j]\u001e\u0004s%\u001a=qe\u001e\u0002Co\u001c\u0011bA9,XNY3sA\t\f7/\u001a3!_:\u0004C\u000f[3!gR\u0014\u0018N\\4!M>\u0014X.\u0019;!A\u001alG\u000f\u0019\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!%\u0016$XO\u001d8tA9+F\n\u0014\u0011jM\u0002\"\b.\u001a\u0011tiJLgn\u001a\u0011(Kb\u0004(o\n\u0011e_\u0016\u001c\bE\\8uA5\fGo\u00195!i\",\u0007%\u001a=qK\u000e$X\r\u001a\u0011g_Jl\u0017\r\u001e\u0018!)\",\u0007EZ8s[\u0006$\bEZ8mY><8\u000f\t;iK*\u0001\u0003\u0005\t\u0011!A\u0001\u001a\u0018-\\3!g\u0016l\u0017M\u001c;jGN\u0004\u0013m\u001d\u0011uQ\u0016\u0004Co\\0ok6\u0014WM\u001d\u0011gk:\u001cG/[8o])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\t-\u0001B,\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":C'\u000e\u001b(Y\u0001:\u0013(O\u001d(SmR\u0001\u0005\t\u0011!A\u0001\u0002C'\u000e\u001b\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\"T\u0007\u000e\u00181a\u001db\u0003e\n\u00191a9\u0002\u0004gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ*DG\f\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013G\r\u00175kQ:C\u0006I\u0014:s1J\u0014(O\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\n$\u0007N\u001b5\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":Ce\u000e\u001d/cI:C\u0006I\u0014%ser\u0013(O\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001:\u0004HL\u00193\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013G\r\u00175kQr\u0003(L\u0014-A\u001dJ\u0014\bL\u001d:s9J4kJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A5\n$\u0007N\u001b5]aR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u000f\fQa\r\u00184]A\nQa\u001a:pkB\f#!!4\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u0017Q\u0013\u0018\u0010V8Ok6\u0014WM\u001d\t\u0003ai\u0019BAGAk\u0007B9\u0011q[Ao\u0011\"\u0003VBAAm\u0015\r\tYnP\u0001\beVtG/[7f\u0013\u0011\ty.!7\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002R\u0006AAo\\*ue&tw\rF\u0001V\u0003\u0015\t\u0007\u000f\u001d7z)\u0015\u0001\u00161^Aw\u0011\u00151U\u00041\u0001I\u0011\u0015aU\u00041\u0001I\u0003\u001d)h.\u00199qYf$B!a=\u0002\u0000B)a(!>\u0002z&\u0019\u0011q_ \u0003\r=\u0003H/[8o!\u0015q\u00141 %I\u0013\r\tip\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\t\u0005a$!AA\u0002A\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u001d\u0001c\u0001,\u0003\n%\u0019!1B,\u0003\r=\u0013'.Z2u\u0001")
public class TryToNumber
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private String numberFormat;
    private ToNumberParser numberFormatter;
    private final Expression left;
    private final Expression right;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(TryToNumber tryToNumber) {
        return TryToNumber$.MODULE$.unapply(tryToNumber);
    }

    public static Function1<Tuple2<Expression, Expression>, TryToNumber> tupled() {
        return TryToNumber$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, TryToNumber>> curried() {
        return TryToNumber$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private String numberFormat$lzycompute() {
        TryToNumber tryToNumber = this;
        synchronized (tryToNumber) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.numberFormat = this.right().eval(this.right().eval$default$1()).toString().toUpperCase(Locale.ROOT);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.numberFormat;
    }

    private String numberFormat() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.numberFormat$lzycompute() : this.numberFormat;
    }

    private ToNumberParser numberFormatter$lzycompute() {
        TryToNumber tryToNumber = this;
        synchronized (tryToNumber) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.numberFormatter = new ToNumberParser(this.numberFormat(), false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.numberFormatter;
    }

    private ToNumberParser numberFormatter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.numberFormatter$lzycompute() : this.numberFormatter;
    }

    @Override
    public DataType dataType() {
        return this.numberFormatter().parsedDecimalType();
    }

    public Seq<DataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return new ToNumber(this.left(), this.right()).checkInputDataTypes();
    }

    @Override
    public String prettyName() {
        return "try_to_number";
    }

    @Override
    public Object nullSafeEval(Object string, Object format) {
        UTF8String input = (UTF8String)string;
        return this.numberFormatter().parse(input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String builder = ctx.addReferenceObj("builder", this.numberFormatter(), ToNumberParser.class.getName());
        ExprCode eval = this.left().genCode(ctx);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |", "\n        |boolean ", " = ", ";\n        |", " ", " = ", ";\n        |if (!", ") {\n        |  ", " = ", ".parse(", ");\n        |}\n      "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), builder, eval.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public TryToNumber withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public TryToNumber copy(Expression left, Expression right) {
        return new TryToNumber(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "TryToNumber";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TryToNumber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TryToNumber)) return false;
        boolean bl = true;
        if (!bl) return false;
        TryToNumber tryToNumber = (TryToNumber)x$1;
        Expression expression = this.left();
        Expression expression2 = tryToNumber.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = tryToNumber.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!tryToNumber.canEqual(this)) return false;
        return true;
    }

    public TryToNumber(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

