/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.WidthBucket$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Function4;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(value, min_value, max_value, num_bucket) - Returns the bucket number to which\n      `value` would be assigned in an equiwidth histogram with `num_bucket` buckets,\n      in the range `min_value` to `max_value`.\"\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(5.3, 0.2, 10.6, 5);\n       3\n      > SELECT _FUNC_(-2.1, 1.3, 3.4, 3);\n       0\n      > SELECT _FUNC_(8.1, 0.0, 5.7, 4);\n       5\n      > SELECT _FUNC_(-0.9, 5.2, 0.5, 2);\n       3\n      > SELECT _FUNC_(INTERVAL '0' YEAR, INTERVAL '0' YEAR, INTERVAL '10' YEAR, 10);\n       1\n      > SELECT _FUNC_(INTERVAL '1' YEAR, INTERVAL '0' YEAR, INTERVAL '10' YEAR, 10);\n       2\n      > SELECT _FUNC_(INTERVAL '0' DAY, INTERVAL '0' DAY, INTERVAL '10' DAY, 10);\n       1\n      > SELECT _FUNC_(INTERVAL '1' DAY, INTERVAL '0' DAY, INTERVAL '10' DAY, 10);\n       2\n  ", since="3.1.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\t\u0015t!\u0002\u0016,\u0011\u0003Ad!\u0002\u001e,\u0011\u0003Y\u0004\"B#\u0002\t\u00031\u0005\"B$\u0002\t\u0003A\u0005\"\u00020\u0002\t\u0003y\u0006\"B4\u0002\t\u0003A\u0007bB7\u0002\u0003\u0003%\tI\u001c\u0005\n\u0005\u000f\n\u0011\u0011!CA\u0005\u0013B\u0011Ba\u0017\u0002\u0003\u0003%IA!\u0018\u0007\tiZ\u0003\t\u001d\u0005\n%&\u0011)\u001a!C\u0001\u0003\u0007A!\"a\u0003\n\u0005#\u0005\u000b\u0011BA\u0003\u0011)\ti!\u0003BK\u0002\u0013\u0005\u00111\u0001\u0005\u000b\u0003\u001fI!\u0011#Q\u0001\n\u0005\u0015\u0001BCA\t\u0013\tU\r\u0011\"\u0001\u0002\u0004!Q\u00111C\u0005\u0003\u0012\u0003\u0006I!!\u0002\t\u0013mK!Q3A\u0005\u0002\u0005\r\u0001BCA\u000b\u0013\tE\t\u0015!\u0003\u0002\u0006!1Q)\u0003C\u0001\u0003/Aq!!\t\n\t\u0003\n\u0019\u0003C\u0004\u0002H%!\t%!\u0013\t\u000f\u0005]\u0013\u0002\"\u0011\u0002Z!9\u0011\u0011M\u0005\u0005B\u0005\r\u0004bBA3\u0013\u0011\u0005\u0013q\r\u0005\b\u0003sJA\u0011KA>\u0011\u001d\ti)\u0003C!\u0003\u001fCq!a+\n\t\u0003\n\u0019\u0001C\u0004\u0002.&!\t%a\u0001\t\u000f\u0005=\u0016\u0002\"\u0011\u0002\u0004!9\u0011\u0011W\u0005\u0005B\u0005\r\u0001bBAZ\u0013\u0011E\u0013Q\u0017\u0005\n\u0003\u007fK\u0011\u0011!C\u0001\u0003\u0003D\u0011\"a3\n#\u0003%\t!!4\t\u0013\u0005\r\u0018\"%A\u0005\u0002\u00055\u0007\"CAs\u0013E\u0005I\u0011AAg\u0011%\t9/CI\u0001\n\u0003\ti\rC\u0005\u0002j&\t\t\u0011\"\u0011\u0002l\"I\u0011\u0011_\u0005\u0002\u0002\u0013\u0005\u00111\u001f\u0005\n\u0003wL\u0011\u0011!C\u0001\u0003{D\u0011Ba\u0001\n\u0003\u0003%\tE!\u0002\t\u0013\tM\u0011\"!A\u0005\u0002\tU\u0001\"\u0003B\r\u0013\u0005\u0005I\u0011\tB\u000e\u0003-9\u0016\u000e\u001a;i\u0005V\u001c7.\u001a;\u000b\u00051j\u0013aC3yaJ,7o]5p]NT!AL\u0018\u0002\u0011\r\fG/\u00197zgRT!\u0001M\u0019\u0002\u0007M\fHN\u0003\u00023g\u0005)1\u000f]1sW*\u0011A'N\u0001\u0007CB\f7\r[3\u000b\u0003Y\n1a\u001c:h\u0007\u0001\u0001\"!O\u0001\u000e\u0003-\u00121bV5ei\"\u0014UoY6fiN\u0019\u0011\u0001\u0010\"\u0011\u0005u\u0002U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\r\u0005s\u0017PU3g!\ti4)\u0003\u0002E}\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012\u0001O\u0001\u0014G>l\u0007/\u001e;f\u0005V\u001c7.\u001a;Ok6\u0014WM\u001d\u000b\u0006\u0013F3\u0006L\u0017\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000bA\u0001\\1oO*\ta*\u0001\u0003kCZ\f\u0017B\u0001)L\u0005\u0011auN\\4\t\u000bI\u001b\u0001\u0019A*\u0002\u000bY\fG.^3\u0011\u0005u\"\u0016BA+?\u0005\u0019!u.\u001e2mK\")qk\u0001a\u0001'\u0006\u0019Q.\u001b8\t\u000be\u001b\u0001\u0019A*\u0002\u00075\f\u0007\u0010C\u0003\\\u0007\u0001\u0007A,A\u0005ok6\u0014UoY6fiB\u0011Q(X\u0005\u0003!z\na![:Ok2dG#\u00021dI\u00164\u0007CA\u001fb\u0013\t\u0011gHA\u0004C_>dW-\u00198\t\u000bI#\u0001\u0019A*\t\u000b]#\u0001\u0019A*\t\u000be#\u0001\u0019A*\t\u000bm#\u0001\u0019\u0001/\u00025\r|W\u000e];uK\n+8m[3u\u001dVl'-\u001a:O_RtU\u000f\u001c7\u0015\u000b%K'n\u001b7\t\u000bI+\u0001\u0019A*\t\u000b]+\u0001\u0019A*\t\u000be+\u0001\u0019A*\t\u000bm+\u0001\u0019\u0001/\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013=\u0014yD!\u0011\u0003D\t\u0015\u0003CA\u001d\n'\u0019I\u0011\u000f^<\u007f\u0005B\u0011\u0011H]\u0005\u0003g.\u0012A#U;bi\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u001dv\u0013\t18F\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tA8P\u0004\u0002:s&\u0011!pK\u0001\ba\u0006\u001c7.Y4f\u0013\taXP\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005i\\\u0003CA\u001f\u0000\u0013\r\t\tA\u0010\u0002\b!J|G-^2u+\t\t)\u0001E\u0002:\u0003\u000fI1!!\u0003,\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007m\u0006dW/\u001a\u0011\u0002\u00115LgNV1mk\u0016\f\u0011\"\\5o-\u0006dW/\u001a\u0011\u0002\u00115\f\u0007PV1mk\u0016\f\u0011\"\\1y-\u0006dW/\u001a\u0011\u0002\u00159,XNQ;dW\u0016$\b\u0005F\u0005p\u00033\tY\"!\b\u0002 !1!K\u0005a\u0001\u0003\u000bAq!!\u0004\u0013\u0001\u0004\t)\u0001C\u0004\u0002\u0012I\u0001\r!!\u0002\t\rm\u0013\u0002\u0019AA\u0003\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003K\u0001b!a\n\u00026\u0005mb\u0002BA\u0015\u0003gqA!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_9\u0014A\u0002\u001fs_>$h(C\u0001@\u0013\tQh(\u0003\u0003\u00028\u0005e\"aA*fc*\u0011!P\u0010\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011I\u0018\u0002\u000bQL\b/Z:\n\t\u0005\u0015\u0013q\b\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\"!a\u0013\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fR1!!\u0015.\u0003!\tg.\u00197zg&\u001c\u0018\u0002BA+\u0003\u001f\u0012q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\tI\u0006$\u0018\rV=qKV\u0011\u00111\f\t\u0005\u0003{\ti&\u0003\u0003\u0002`\u0005}\"\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00119,H\u000e\\1cY\u0016,\u0012\u0001Y\u0001\u000baJ,G\u000f^=OC6,WCAA5!\u0011\tY'a\u001d\u000f\t\u00055\u0014q\u000e\t\u0004\u0003Wq\u0014bAA9}\u00051\u0001K]3eK\u001aLA!!\u001e\u0002x\t11\u000b\u001e:j]\u001eT1!!\u001d?\u00031qW\u000f\u001c7TC\u001a,WI^1m))\ti(a!\u0002\b\u0006%\u00151\u0012\t\u0004{\u0005}\u0014bAAA}\t\u0019\u0011I\\=\t\u000f\u0005\u0015\u0005\u00041\u0001\u0002~\u0005)\u0011N\u001c9vi\"1q\u000b\u0007a\u0001\u0003{Ba!\u0017\rA\u0002\u0005u\u0004BB.\u0019\u0001\u0004\ti(A\u0005e_\u001e+gnQ8eKR1\u0011\u0011SAO\u0003O\u0003B!a%\u0002\u001a6\u0011\u0011Q\u0013\u0006\u0004\u0003/[\u0013aB2pI\u0016<WM\\\u0005\u0005\u00037\u000b)J\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\ty*\u0007a\u0001\u0003C\u000b1a\u0019;y!\u0011\t\u0019*a)\n\t\u0005\u0015\u0016Q\u0013\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\tI+\u0007a\u0001\u0003#\u000b!!\u001a<\u0002\u000b\u0019L'o\u001d;\u0002\rM,7m\u001c8e\u0003\u0015!\b.\u001b:e\u0003\u00191w.\u001e:uQ\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\n_\u0006]\u0016\u0011XA^\u0003{Cq!a+\u001f\u0001\u0004\t)\u0001C\u0004\u0002.z\u0001\r!!\u0002\t\u000f\u0005=f\u00041\u0001\u0002\u0006!9\u0011\u0011\u0017\u0010A\u0002\u0005\u0015\u0011\u0001B2paf$\u0012b\\Ab\u0003\u000b\f9-!3\t\u0011I{\u0002\u0013!a\u0001\u0003\u000bA\u0011\"!\u0004 !\u0003\u0005\r!!\u0002\t\u0013\u0005Eq\u0004%AA\u0002\u0005\u0015\u0001\u0002C. !\u0003\u0005\r!!\u0002\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u001a\u0016\u0005\u0003\u000b\t\tn\u000b\u0002\u0002TB!\u0011Q[Ap\u001b\t\t9N\u0003\u0003\u0002Z\u0006m\u0017!C;oG\",7m[3e\u0015\r\tiNP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAq\u0003/\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\u000fE\u0002K\u0003_L1!!\u001eL\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\u0010E\u0002>\u0003oL1!!??\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ti(a@\t\u0013\t\u0005a%!AA\u0002\u0005U\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\bA1!\u0011\u0002B\b\u0003{j!Aa\u0003\u000b\u0007\t5a(\u0001\u0006d_2dWm\u0019;j_:LAA!\u0005\u0003\f\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r\u0001'q\u0003\u0005\n\u0005\u0003A\u0013\u0011!a\u0001\u0003{\na!Z9vC2\u001cHc\u00011\u0003\u001e!I!\u0011A\u0015\u0002\u0002\u0003\u0007\u0011Q\u0010\u0015\u0014\u0013\t\u0005\"q\u0005B\u0015\u0005[\u0011yCa\r\u00036\te\"1\b\t\u0004s\t\r\u0012b\u0001B\u0013W\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B\u0016\u0003\u0005\r'\u0002\t\u0011!A}3UKT\"`QY\fG.^3-A5Lgn\u0018<bYV,G\u0006I7bq~3\u0018\r\\;fY\u0001rW/\\0ck\u000e\\W\r^\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!EV\u001c7.\u001a;!]Vl'-\u001a:!i>\u0004s\u000f[5dQ*\u0001\u0003\u0005\t\u0011!A\u00014\u0018\r\\;fA\u0002:x.\u001e7eA\t,\u0007%Y:tS\u001etW\r\u001a\u0011j]\u0002\ng\u000eI3rk&<\u0018\u000e\u001a;iA!L7\u000f^8he\u0006l\u0007e^5uQ\u0002\u0002g.^7`EV\u001c7.\u001a;aA\t,8m[3ug2R\u0001\u0005\t\u0011!A\u0001Jg\u000e\t;iK\u0002\u0012\u0018M\\4fA\u0001l\u0017N\\0wC2,X\r\u0019\u0011u_\u0002\u0002W.\u0019=`m\u0006dW/\u001a1/E)\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011\t$\u0001CO\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"*df\r\u0017!a9\u0012D\u0006I\u00191]Yb\u0003%N\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\f\u001a/c1\u0002\u0013GL\u001a-AMrC\u0007\f\u00114SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00159]Eb\u0003\u0005\r\u00181Y\u0001*df\u000e\u0017!i%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)[Ar\u0013\b\f\u00116]Ib\u0003\u0005\r\u00186Y\u0001\u0012\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00114\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"Je\nV#S-\u0006c\u0005e\n\u0019(Ae+\u0015I\u0015\u0017!\u0013:#VI\u0015,B\u0019\u0002:\u0003g\n\u0011Z\u000b\u0006\u0013F\u0006I%O)\u0016\u0013f+\u0011'!OE\u0002t\u0005I-F\u0003Jc\u0003%\r\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK%O)\u0016\u0013f+\u0011'!OE:\u0003%W#B%2\u0002\u0013J\u0014+F%Z\u000bE\nI\u00141O\u0001JV)\u0011*-A%sE+\u0012*W\u00032\u0003s%\r\u0019(Ae+\u0015I\u0015\u0017!cAJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q%sE+\u0012*W\u00032\u0003s\u0005M\u0014!\t\u0006KF\u0006I%O)\u0016\u0013f+\u0011'!OA:\u0003\u0005R!ZY\u0001Je\nV#S-\u0006c\u0005eJ\u00191O\u0001\"\u0015)\u0017\u0017!cAJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q%sE+\u0012*W\u00032\u0003s%M\u0014!\t\u0006KF\u0006I%O)\u0016\u0013f+\u0011'!OA:\u0003\u0005R!ZY\u0001Je\nV#S-\u0006c\u0005eJ\u00191O\u0001\"\u0015)\u0017\u0017!cAJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a\u000bA\u0001\nQa]5oG\u0016\f#Aa\u000e\u0002\u000bMr\u0013G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\tu\u0012AC7bi\"|f-\u001e8dg\"1!K\u0002a\u0001\u0003\u000bAq!!\u0004\u0007\u0001\u0004\t)\u0001C\u0004\u0002\u0012\u0019\u0001\r!!\u0002\t\rm3\u0001\u0019AA\u0003\u0003\u001d)h.\u00199qYf$BAa\u0013\u0003XA)QH!\u0014\u0003R%\u0019!q\n \u0003\r=\u0003H/[8o!-i$1KA\u0003\u0003\u000b\t)!!\u0002\n\u0007\tUcH\u0001\u0004UkBdW\r\u000e\u0005\t\u00053:\u0011\u0011!a\u0001_\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005?\u00022A\u0013B1\u0013\r\u0011\u0019g\u0013\u0002\u0007\u001f\nTWm\u0019;")
public class WidthBucket
extends QuaternaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression value;
    private final Expression minValue;
    private final Expression maxValue;
    private final Expression numBucket;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(WidthBucket widthBucket) {
        return WidthBucket$.MODULE$.unapply(widthBucket);
    }

    public static Long computeBucketNumberNotNull(double d, double d2, double d3, long l) {
        return WidthBucket$.MODULE$.computeBucketNumberNotNull(d, d2, d3, l);
    }

    public static boolean isNull(double d, double d2, double d3, long l) {
        return WidthBucket$.MODULE$.isNull(d, d2, d3, l);
    }

    public static Long computeBucketNumber(double d, double d2, double d3, long l) {
        return WidthBucket$.MODULE$.computeBucketNumber(d, d2, d3, l);
    }

    public Expression value() {
        return this.value;
    }

    public Expression minValue() {
        return this.minValue;
    }

    public Expression maxValue() {
        return this.maxValue;
    }

    public Expression numBucket() {
        return this.numBucket;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), (List)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), (List)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), (List)new .colon.colon((Object)LongType$.MODULE$, (List)Nil$.MODULE$))));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        TypeCheckResult typeCheckResult2 = ExpectsInputTypes.checkInputDataTypes$(this);
        if (TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult2)) {
            TypeCheckResult typeCheckResult3;
            Tuple3 tuple3 = new Tuple3((Object)this.value().dataType(), (Object)this.minValue().dataType(), (Object)this.maxValue().dataType());
            if (tuple3 != null && tuple3._1() instanceof YearMonthIntervalType && tuple3._2() instanceof YearMonthIntervalType && tuple3._3() instanceof YearMonthIntervalType) {
                typeCheckResult3 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            } else if (tuple3 != null && tuple3._1() instanceof DayTimeIntervalType && tuple3._2() instanceof DayTimeIntervalType && tuple3._3() instanceof DayTimeIntervalType) {
                typeCheckResult3 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            } else {
                Seq types = (Seq)new .colon.colon((Object)this.value().dataType(), (List)new .colon.colon((Object)this.minValue().dataType(), (List)new .colon.colon((Object)this.maxValue().dataType(), (List)Nil$.MODULE$)));
                typeCheckResult3 = TypeUtils$.MODULE$.checkForSameTypeInputExpr((Seq<DataType>)types, new StringBuilder(9).append("function ").append(this.prettyName()).toString());
            }
            typeCheckResult = typeCheckResult3;
        } else {
            typeCheckResult = typeCheckResult2;
        }
        return typeCheckResult;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "width_bucket";
    }

    @Override
    public Object nullSafeEval(Object input, Object min, Object max, Object numBucket) {
        return WidthBucket$.MODULE$.computeBucketNumber(((Number)input).doubleValue(), ((Number)min).doubleValue(), ((Number)max).doubleValue(), BoxesRunTime.unboxToLong((Object)numBucket));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function4<String, String, String, String, String>)(Function4 & Serializable & scala.Serializable)(input, min, max, numBucket) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(236).append(ev.isNull()).append(" = org.apache.spark.sql.catalyst.expressions.WidthBucket\n         |  .isNull(").append((String)input).append(", ").append((String)min).append(", ").append((String)max).append(", ").append((String)numBucket).append(");\n         |if (!").append(ev.isNull()).append(") {\n         |  ").append(ev.value()).append(" = org.apache.spark.sql.catalyst.expressions.WidthBucket\n         |    .computeBucketNumberNotNull(").append((String)input).append(", ").append((String)min).append(", ").append((String)max).append(", ").append((String)numBucket).append(");\n         |}").toString())).stripMargin());
    }

    @Override
    public Expression first() {
        return this.value();
    }

    @Override
    public Expression second() {
        return this.minValue();
    }

    @Override
    public Expression third() {
        return this.maxValue();
    }

    @Override
    public Expression fourth() {
        return this.numBucket();
    }

    @Override
    public WidthBucket withNewChildrenInternal(Expression first, Expression second, Expression third, Expression fourth) {
        return this.copy(first, second, third, fourth);
    }

    public WidthBucket copy(Expression value, Expression minValue, Expression maxValue, Expression numBucket) {
        return new WidthBucket(value, minValue, maxValue, numBucket);
    }

    public Expression copy$default$1() {
        return this.value();
    }

    public Expression copy$default$2() {
        return this.minValue();
    }

    public Expression copy$default$3() {
        return this.maxValue();
    }

    public Expression copy$default$4() {
        return this.numBucket();
    }

    @Override
    public String productPrefix() {
        return "WidthBucket";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.value();
                break;
            }
            case 1: {
                expression = this.minValue();
                break;
            }
            case 2: {
                expression = this.maxValue();
                break;
            }
            case 3: {
                expression = this.numBucket();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof WidthBucket;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof WidthBucket)) return false;
        boolean bl = true;
        if (!bl) return false;
        WidthBucket widthBucket = (WidthBucket)x$1;
        Expression expression = this.value();
        Expression expression2 = widthBucket.value();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.minValue();
        Expression expression4 = widthBucket.minValue();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.maxValue();
        Expression expression6 = widthBucket.maxValue();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.numBucket();
        Expression expression8 = widthBucket.numBucket();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!widthBucket.canEqual(this)) return false;
        return true;
    }

    public WidthBucket(Expression value, Expression minValue, Expression maxValue, Expression numBucket) {
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.numBucket = numBucket;
        ExpectsInputTypes.$init$(this);
    }
}

