/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import org.apache.spark.annotation.Evolving;

@Evolving
public interface NamespaceChange {
    public static NamespaceChange setProperty(String property, String value) {
        return new SetProperty(property, value);
    }

    public static NamespaceChange removeProperty(String property) {
        return new RemoveProperty(property);
    }

    public static final class RemoveProperty
    implements NamespaceChange {
        private final String property;

        private RemoveProperty(String property) {
            this.property = property;
        }

        public String property() {
            return this.property;
        }
    }

    public static final class SetProperty
    implements NamespaceChange {
        private final String property;
        private final String value;

        private SetProperty(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public String property() {
            return this.property;
        }

        public String value() {
            return this.value;
        }
    }
}

