/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.package$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.SimpleAnalyzer$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Add$;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BRound;
import org.apache.spark.sql.catalyst.expressions.BRound$;
import org.apache.spark.sql.catalyst.expressions.BitwiseAnd;
import org.apache.spark.sql.catalyst.expressions.BitwiseNot;
import org.apache.spark.sql.catalyst.expressions.BitwiseOr;
import org.apache.spark.sql.catalyst.expressions.BitwiseXor;
import org.apache.spark.sql.catalyst.expressions.CaseKeyWhen$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.CreateArray$;
import org.apache.spark.sql.catalyst.expressions.CreateMap$;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.Divide$;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Explode;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FrameType;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Greatest$;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Lag;
import org.apache.spark.sql.catalyst.expressions.Least$;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.Multiply$;
import org.apache.spark.sql.catalyst.expressions.Murmur3Hash;
import org.apache.spark.sql.catalyst.expressions.NonFoldableLiteral$;
import org.apache.spark.sql.catalyst.expressions.PosExplode;
import org.apache.spark.sql.catalyst.expressions.RangeFrame$;
import org.apache.spark.sql.catalyst.expressions.Remainder;
import org.apache.spark.sql.catalyst.expressions.Remainder$;
import org.apache.spark.sql.catalyst.expressions.Round;
import org.apache.spark.sql.catalyst.expressions.Round$;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.Subtract$;
import org.apache.spark.sql.catalyst.expressions.UnspecifiedFrame$;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.catalyst.expressions.XxHash64;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average$;
import org.apache.spark.sql.catalyst.expressions.aggregate.BoolAnd;
import org.apache.spark.sql.catalyst.expressions.aggregate.BoolOr;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001E4Aa\u0003\u0007\u00013!)!\u0006\u0001C\u0001W!9a\u0006\u0001b\u0001\n\u0003y\u0003B\u0002\u001c\u0001A\u0003%\u0001\u0007C\u00038\u0001\u0011%\u0001\bC\u0003F\u0001\u0011%a\tC\u0003O\u0001\u0011%q\nC\u0003b\u0001\u0011%!\rC\u0003f\u0001\u0011%a\rC\u0003j\u0001\u0011%!\u000eC\u0003n\u0001\u0011%aNA\u000eFqB\u0014Xm]:j_:$\u0016\u0010]3DQ\u0016\u001c7.\u001b8h'VLG/\u001a\u0006\u0003\u001b9\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003\u001fA\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003#I\t1a]9m\u0015\t\u0019B#A\u0003ta\u0006\u00148N\u0003\u0002\u0016-\u00051\u0011\r]1dQ\u0016T\u0011aF\u0001\u0004_J<7\u0001A\n\u0005\u0001iqB\u0005\u0005\u0002\u001c95\t!#\u0003\u0002\u001e%\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\b\u0012\u000e\u0003\u0001R!!\t\b\u0002\u000bAd\u0017M\\:\n\u0005\r\u0002#!C*R\u0019\"+G\u000e]3s!\t)\u0003&D\u0001'\u0015\t9\u0003#\u0001\u0004feJ|'o]\u0005\u0003S\u0019\u0012q\"U;fef,%O]8sg\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\u0002\"!\f\u0001\u000e\u00031\tA\u0002^3tiJ+G.\u0019;j_:,\u0012\u0001\r\t\u0003cQj\u0011A\r\u0006\u0003g\u0001\nq\u0001\\8hS\u000e\fG.\u0003\u00026e\tiAj\\2bYJ+G.\u0019;j_:\fQ\u0002^3tiJ+G.\u0019;j_:\u0004\u0013!E1oC2L8/[:Fq\u000e,\u0007\u000f^5p]R\u0011\u0011(\u0010\t\u0003umj\u0011\u0001E\u0005\u0003yA\u0011\u0011#\u00118bYf\u001c\u0018n]#yG\u0016\u0004H/[8o\u0011\u0015qD\u00011\u0001@\u0003\u0011)\u0007\u0010\u001d:\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\ts\u0011aC3yaJ,7o]5p]NL!\u0001R!\u0003\u0015\u0015C\bO]3tg&|g.A\u0007bgN,'\u000f^*vG\u000e,7o\u001d\u000b\u0003\u000f6\u0003\"\u0001S&\u000e\u0003%S\u0011AS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0019&\u0013A!\u00168ji\")a(\u0002a\u0001\u007f\u0005\u0011\u0013m]:feR,%O]8s\r>\u0014()\u001b8bef$\u0015N\u001a4fe&tw\rV=qKN$2a\u0012)R\u0011\u0015qd\u00011\u0001@\u0011\u0015\u0011f\u00011\u0001T\u0003EiWm]:bO\u0016\u0004\u0016M]1nKR,'o\u001d\t\u0005)nsfL\u0004\u0002V3B\u0011a+S\u0007\u0002/*\u0011\u0001\fG\u0001\u0007yI|w\u000e\u001e \n\u0005iK\u0015A\u0002)sK\u0012,g-\u0003\u0002];\n\u0019Q*\u00199\u000b\u0005iK\u0005C\u0001+`\u0013\t\u0001WL\u0001\u0004TiJLgnZ\u0001\u001cCN\u001cXM\u001d;FeJ|'OR8s\u001fJ$WM]5oORK\b/Z:\u0015\u0007\u001d\u001bG\rC\u0003?\u000f\u0001\u0007q\bC\u0003S\u000f\u0001\u00071+\u0001\u0011bgN,'\u000f^#se>\u0014hi\u001c:ECR\fG)\u001b4gKJLgn\u001a+za\u0016\u001cHcA$hQ\")a\b\u0003a\u0001\u007f!)!\u000b\u0003a\u0001'\u0006\u0001\u0013m]:feR,%O]8s\r>\u0014xK]8oO:+X\u000eU1sC6,G/\u001a:t)\r95\u000e\u001c\u0005\u0006}%\u0001\ra\u0010\u0005\u0006%&\u0001\raU\u0001\u0013CN\u001cXM\u001d;G_J<&o\u001c8h)f\u0004X\rF\u0002H_BDQA\u0010\u0006A\u0002}BQA\u0015\u0006A\u0002M\u0003")
public class ExpressionTypeCheckingSuite
extends SparkFunSuite
implements SQLHelper,
QueryErrorsBase {
    private final LocalRelation testRelation;
    private String sparkHome;
    private volatile boolean bitmap$0;

    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$((QueryErrorsBase)this, (Object)v, (DataType)t);
    }

    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$((QueryErrorsBase)this, (String)text);
    }

    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, (String)parts);
    }

    public String toSQLType(AbstractDataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLType(String text) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$((QueryErrorsBase)this, (String)conf);
    }

    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$((QueryErrorsBase)this, (String)conf);
    }

    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$((QueryErrorsBase)this, (String)option);
    }

    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$((QueryErrorsBase)this, (Expression)e);
    }

    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$((QueryErrorsBase)this, (String)schema);
    }

    public String getSummary(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getSummary$((QueryErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getQueryContext$((QueryErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    private String sparkHome$lzycompute() {
        ExpressionTypeCheckingSuite expressionTypeCheckingSuite = this;
        synchronized (expressionTypeCheckingSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    private AnalysisException analysisException(Expression expr) {
        return (AnalysisException)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertSuccess(expr), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44)));
    }

    private void assertSuccess(Expression expr) {
        LogicalPlan analyzed = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(expr).as("c")}))).analyze();
        SimpleAnalyzer$.MODULE$.checkAnalysis(analyzed);
    }

    private void assertErrorForBinaryDifferingTypes(Expression expr, Map<String, String> messageParameters) {
        AnalysisException x$1 = this.analysisException(expr);
        String x$2 = "DATATYPE_MISMATCH.BINARY_OP_DIFF_TYPES";
        Map<String, String> x$3 = messageParameters;
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        QueryContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
    }

    private void assertErrorForOrderingTypes(Expression expr, Map<String, String> messageParameters) {
        AnalysisException x$1 = this.analysisException(expr);
        String x$2 = "DATATYPE_MISMATCH.INVALID_ORDERING_TYPE";
        Map<String, String> x$3 = messageParameters;
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        QueryContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
    }

    private void assertErrorForDataDifferingTypes(Expression expr, Map<String, String> messageParameters) {
        AnalysisException x$1 = this.analysisException(expr);
        String x$2 = "DATATYPE_MISMATCH.DATA_DIFF_TYPES";
        Map<String, String> x$3 = messageParameters;
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        QueryContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
    }

    private void assertErrorForWrongNumParameters(Expression expr, Map<String, String> messageParameters) {
        AnalysisException x$1 = this.analysisException(expr);
        String x$2 = "WRONG_NUM_ARGS.WITHOUT_SUGGESTION";
        Map<String, String> x$3 = messageParameters;
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        QueryContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
    }

    private void assertForWrongType(Expression expr, Map<String, String> messageParameters) {
        AnalysisException x$1 = this.analysisException(expr);
        String x$2 = "DATATYPE_MISMATCH.BINARY_OP_WRONG_TYPE";
        Map<String, String> x$3 = messageParameters;
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        QueryContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
    }

    public static final /* synthetic */ void $anonfun$new$28(ExpressionTypeCheckingSuite $this, Function1 operator) {
        Expression expr1 = (Expression)operator.apply((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$));
        $this.assertErrorForWrongNumParameters(expr1, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)$this.toSQLId(expr1.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedNum"), (Object)"> 1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualNum"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"docroot"), (Object)package$.MODULE$.SPARK_DOC_ROOT())}))));
        Expression expr2 = (Expression)operator.apply((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stringField"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)));
        $this.assertErrorForDataDifferingTypes(expr2, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)$this.toSQLExpr(expr2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)$this.toSQLId(expr2.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"[\"INT\", \"STRING\"]")}))));
        Expression expr3 = (Expression)operator.apply((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)));
        $this.assertErrorForOrderingTypes(expr3, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)$this.toSQLExpr(expr3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)new StringBuilder(2).append("`").append(expr3.prettyName()).append("`").toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"\"MAP<STRING, BIGINT>\"")}))));
    }

    public ExpressionTypeCheckingSuite() {
        SQLHelper.$init$(this);
        QueryErrorsBase.$init$((QueryErrorsBase)this);
        this.testRelation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$)).int(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stringField"}))).$((Seq)Nil$.MODULE$)).string(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$)).boolean(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"decimalField"}))).$((Seq)Nil$.MODULE$)).decimal(8, 0), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"arrayField"}))).$((Seq)Nil$.MODULE$)).array((DataType)StringType$.MODULE$), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "mapField")).map((DataType)StringType$.MODULE$, (DataType)LongType$.MODULE$)}));
        this.test("check types for unary arithmetic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AnalysisException x$1 = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertSuccess((Expression)new BitwiseNot((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stringField"}))).$((Seq)Nil$.MODULE$))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93))));
            String x$2 = "DATATYPE_MISMATCH.UNEXPECTED_INPUT_TYPE";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"~stringField\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"stringField\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"STRING\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"\"INTEGRAL\"")}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            QueryContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("check types for binary arithmetic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertSuccess((Expression)new Add((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stringField"}))).$((Seq)Nil$.MODULE$), Add$.MODULE$.apply$default$3()));
            this.assertSuccess((Expression)new Subtract((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stringField"}))).$((Seq)Nil$.MODULE$), Subtract$.MODULE$.apply$default$3()));
            this.assertSuccess((Expression)new Multiply((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stringField"}))).$((Seq)Nil$.MODULE$), Multiply$.MODULE$.apply$default$3()));
            this.assertSuccess((Expression)new Divide((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stringField"}))).$((Seq)Nil$.MODULE$), Divide$.MODULE$.apply$default$3()));
            this.assertSuccess((Expression)new Remainder((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stringField"}))).$((Seq)Nil$.MODULE$), Remainder$.MODULE$.apply$default$3()));
            this.assertErrorForBinaryDifferingTypes((Expression)new Add((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), Add$.MODULE$.apply$default$3()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(intField + booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"BOOLEAN\"")}))));
            this.assertErrorForBinaryDifferingTypes((Expression)new Subtract((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), Subtract$.MODULE$.apply$default$3()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(intField - booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"BOOLEAN\"")}))));
            this.assertErrorForBinaryDifferingTypes((Expression)new Multiply((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), Multiply$.MODULE$.apply$default$3()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(intField * booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"BOOLEAN\"")}))));
            this.assertErrorForBinaryDifferingTypes((Expression)new Divide((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), Divide$.MODULE$.apply$default$3()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(intField / booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"BOOLEAN\"")}))));
            this.assertErrorForBinaryDifferingTypes((Expression)new Remainder((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), Remainder$.MODULE$.apply$default$3()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(intField % booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"BOOLEAN\"")}))));
            this.assertErrorForBinaryDifferingTypes((Expression)new BitwiseAnd((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(intField & booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"BOOLEAN\"")}))));
            this.assertErrorForBinaryDifferingTypes((Expression)new BitwiseOr((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(intField | booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"BOOLEAN\"")}))));
            this.assertErrorForBinaryDifferingTypes((Expression)new BitwiseXor((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(intField ^ booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"BOOLEAN\"")}))));
            this.assertForWrongType((Expression)new Add((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), Add$.MODULE$.apply$default$3()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(booleanField + booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"(\"NUMERIC\" or \"INTERVAL DAY TO SECOND\" or \"INTERVAL YEAR TO MONTH\" or \"INTERVAL\")"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualDataType"), (Object)"\"BOOLEAN\"")}))));
            this.assertForWrongType((Expression)new Subtract((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), Subtract$.MODULE$.apply$default$3()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(booleanField - booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"(\"NUMERIC\" or \"INTERVAL DAY TO SECOND\" or \"INTERVAL YEAR TO MONTH\" or \"INTERVAL\")"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualDataType"), (Object)"\"BOOLEAN\"")}))));
            this.assertForWrongType((Expression)new Multiply((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), Multiply$.MODULE$.apply$default$3()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(booleanField * booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"NUMERIC\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualDataType"), (Object)"\"BOOLEAN\"")}))));
            this.assertForWrongType((Expression)new Divide((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), Divide$.MODULE$.apply$default$3()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(booleanField / booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"(\"DOUBLE\" or \"DECIMAL\")"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualDataType"), (Object)"\"BOOLEAN\"")}))));
            this.assertForWrongType((Expression)new Remainder((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), Remainder$.MODULE$.apply$default$3()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(booleanField % booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"NUMERIC\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualDataType"), (Object)"\"BOOLEAN\"")}))));
            this.assertForWrongType((Expression)new BitwiseAnd((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(booleanField & booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"INTEGRAL\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualDataType"), (Object)"\"BOOLEAN\"")}))));
            this.assertForWrongType((Expression)new BitwiseOr((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(booleanField | booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"INTEGRAL\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualDataType"), (Object)"\"BOOLEAN\"")}))));
            this.assertForWrongType((Expression)new BitwiseXor((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(booleanField ^ booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"INTEGRAL\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualDataType"), (Object)"\"BOOLEAN\"")}))));
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("check types for predicates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.assertSuccess((Expression)new EqualTo((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stringField"}))).$((Seq)Nil$.MODULE$)));
            this.assertSuccess((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stringField"}))).$((Seq)Nil$.MODULE$)));
            this.assertSuccess((Expression)new LessThan((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stringField"}))).$((Seq)Nil$.MODULE$)));
            this.assertSuccess((Expression)new LessThanOrEqual((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stringField"}))).$((Seq)Nil$.MODULE$)));
            this.assertSuccess((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stringField"}))).$((Seq)Nil$.MODULE$)));
            this.assertSuccess((Expression)new GreaterThanOrEqual((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stringField"}))).$((Seq)Nil$.MODULE$)));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.assertSuccess((Expression)new EqualTo((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$)));
                this.assertSuccess((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$)));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.assertErrorForBinaryDifferingTypes((Expression)new EqualTo((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(intField = booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"BOOLEAN\"")}))));
                this.assertErrorForBinaryDifferingTypes((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(intField <=> booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"BOOLEAN\"")}))));
            });
            this.assertErrorForBinaryDifferingTypes((Expression)new EqualTo((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(intField = mapField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"MAP<STRING, BIGINT>\"")}))));
            this.assertErrorForBinaryDifferingTypes((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(intField <=> mapField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"MAP<STRING, BIGINT>\"")}))));
            this.assertErrorForBinaryDifferingTypes((Expression)new LessThan((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(intField < booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"BOOLEAN\"")}))));
            this.assertErrorForBinaryDifferingTypes((Expression)new LessThanOrEqual((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(intField <= booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"BOOLEAN\"")}))));
            this.assertErrorForBinaryDifferingTypes((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(intField > booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"BOOLEAN\"")}))));
            this.assertErrorForBinaryDifferingTypes((Expression)new GreaterThanOrEqual((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(intField >= booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"BOOLEAN\"")}))));
            this.assertErrorForOrderingTypes((Expression)new EqualTo((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(mapField = mapField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`=`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"\"MAP<STRING, BIGINT>\"")}))));
            this.assertErrorForOrderingTypes((Expression)new EqualTo((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(mapField = mapField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`=`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"\"MAP<STRING, BIGINT>\"")}))));
            this.assertErrorForOrderingTypes((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(mapField <=> mapField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`<=>`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"\"MAP<STRING, BIGINT>\"")}))));
            this.assertErrorForOrderingTypes((Expression)new LessThan((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(mapField < mapField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`<`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"\"MAP<STRING, BIGINT>\"")}))));
            this.assertErrorForOrderingTypes((Expression)new LessThanOrEqual((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(mapField <= mapField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`<=`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"\"MAP<STRING, BIGINT>\"")}))));
            this.assertErrorForOrderingTypes((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(mapField > mapField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`>`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"\"MAP<STRING, BIGINT>\"")}))));
            this.assertErrorForOrderingTypes((Expression)new GreaterThanOrEqual((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"(mapField >= mapField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`>=`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"\"MAP<STRING, BIGINT>\"")}))));
            TypeCheckResult $org_scalatest_assert_macro_left = new If((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)Literal$.MODULE$.apply((Object)"a"), (Expression)Literal$.MODULE$.apply((Object)"b")).checkInputDataTypes();
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)BooleanType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"1\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"INT\"")})));
            TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
            TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
            TypeCheckResult $org_scalatest_assert_macro_left2 = new If((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false))).checkInputDataTypes();
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right2 = new TypeCheckResult.DataTypeMismatch("DATA_DIFF_TYPES", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`if`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"[\"INT\", \"BOOLEAN\"]")})));
            TypeCheckResult typeCheckResult2 = $org_scalatest_assert_macro_left2;
            TypeCheckResult.DataTypeMismatch dataTypeMismatch2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(typeCheckResult2 != null ? !typeCheckResult2.equals(dataTypeMismatch2) : dataTypeMismatch2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
            TypeCheckResult $org_scalatest_assert_macro_left3 = new CaseWhen((Seq)new .colon.colon((Object)new Tuple2((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), (List)new .colon.colon((Object)new Tuple2((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)Literal$.MODULE$.apply((Object)"a")), (List)Nil$.MODULE$)), CaseWhen$.MODULE$.apply$default$2()).checkInputDataTypes();
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right3 = new TypeCheckResult.DataTypeMismatch("DATA_DIFF_TYPES", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`casewhen`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"[\"INT\", \"STRING\"]")})));
            TypeCheckResult typeCheckResult3 = $org_scalatest_assert_macro_left3;
            TypeCheckResult.DataTypeMismatch dataTypeMismatch3 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(typeCheckResult3 != null ? !typeCheckResult3.equals(dataTypeMismatch3) : dataTypeMismatch3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
            TypeCheckResult $org_scalatest_assert_macro_left4 = CaseKeyWhen$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"a"), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (List)Nil$.MODULE$))))).checkInputDataTypes();
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right4 = new TypeCheckResult.DataTypeMismatch("DATA_DIFF_TYPES", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`casewhen`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"[\"STRING\", \"INT\"]")})));
            TypeCheckResult typeCheckResult4 = $org_scalatest_assert_macro_left4;
            TypeCheckResult.DataTypeMismatch dataTypeMismatch4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(typeCheckResult4 != null ? !typeCheckResult4.equals(dataTypeMismatch4) : dataTypeMismatch4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
            TypeCheckResult $org_scalatest_assert_macro_left5 = new CaseWhen((Seq)new .colon.colon((Object)new Tuple2((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), (List)new .colon.colon((Object)new Tuple2((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))), (List)Nil$.MODULE$)), CaseWhen$.MODULE$.apply$default$2()).checkInputDataTypes();
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right5 = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"2\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"INT\"")})));
            TypeCheckResult typeCheckResult5 = $org_scalatest_assert_macro_left5;
            TypeCheckResult.DataTypeMismatch dataTypeMismatch5 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(typeCheckResult5 != null ? !typeCheckResult5.equals(dataTypeMismatch5) : dataTypeMismatch5 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        this.test("check types for aggregates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertSuccess((Expression)new Sum((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stringField"}))).$((Seq)Nil$.MODULE$), Sum$.MODULE$.apply$default$2()));
            this.assertSuccess((Expression)new Average((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stringField"}))).$((Seq)Nil$.MODULE$), Average$.MODULE$.apply$default$2()));
            this.assertSuccess((Expression)new Min((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"arrayField"}))).$((Seq)Nil$.MODULE$)));
            this.assertSuccess((Expression)new BoolAnd((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$)));
            this.assertSuccess((Expression)new BoolOr((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$)));
            this.assertErrorForOrderingTypes((Expression)new Min((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"min(mapField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`min`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"\"MAP<STRING, BIGINT>\"")}))));
            this.assertErrorForOrderingTypes((Expression)new Max((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$)), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"max(mapField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`max`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"\"MAP<STRING, BIGINT>\"")}))));
            AnalysisException x$7 = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertSuccess((Expression)new Sum((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), Sum$.MODULE$.apply$default$2())), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426))));
            String x$8 = "DATATYPE_MISMATCH.UNEXPECTED_INPUT_TYPE";
            Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"sum(booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"booleanField\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"\"NUMERIC\" or \"ANSI INTERVAL\"")}));
            Option x$10 = this.checkError$default$3();
            boolean x$11 = this.checkError$default$5();
            QueryContext[] x$12 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$7, x$8, x$10, x$9, x$11, x$12);
            AnalysisException x$13 = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertSuccess((Expression)new Average((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), Average$.MODULE$.apply$default$2())), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437))));
            String x$14 = "DATATYPE_MISMATCH.UNEXPECTED_INPUT_TYPE";
            Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"avg(booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"booleanField\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"\"NUMERIC\" or \"ANSI INTERVAL\"")}));
            Option x$16 = this.checkError$default$3();
            boolean x$17 = this.checkError$default$5();
            QueryContext[] x$18 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$13, x$14, x$16, x$15, x$17, x$18);
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
        this.test("check types for others", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertErrorForDataDifferingTypes((Expression)CreateArray$.MODULE$.apply((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$))), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"array(intField, booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`array`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"(\"INT\" or \"BOOLEAN\")")}))));
            this.assertErrorForDataDifferingTypes((Expression)new Coalesce((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$))), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"coalesce(intField, booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`coalesce`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"(\"INT\" or \"BOOLEAN\")")}))));
            Coalesce coalesce = new Coalesce((Seq)Nil$.MODULE$);
            AnalysisException x$19 = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertSuccess((Expression)coalesce), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469))));
            String x$20 = "WRONG_NUM_ARGS.WITHOUT_SUGGESTION";
            Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(coalesce.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedNum"), (Object)"> 0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualNum"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"docroot"), (Object)package$.MODULE$.SPARK_DOC_ROOT())}));
            Option x$22 = this.checkError$default$3();
            boolean x$23 = this.checkError$default$5();
            QueryContext[] x$24 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$19, x$20, x$22, x$21, x$23, x$24);
            Murmur3Hash murmur3Hash = new Murmur3Hash((Seq)Nil$.MODULE$);
            AnalysisException x$25 = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertSuccess((Expression)murmur3Hash), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481))));
            String x$26 = "WRONG_NUM_ARGS.WITHOUT_SUGGESTION";
            Map x$27 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(murmur3Hash.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedNum"), (Object)"> 0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualNum"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"docroot"), (Object)package$.MODULE$.SPARK_DOC_ROOT())}));
            Option x$28 = this.checkError$default$3();
            boolean x$29 = this.checkError$default$5();
            QueryContext[] x$30 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$25, x$26, x$28, x$27, x$29, x$30);
            XxHash64 xxHash64 = new XxHash64((Seq)Nil$.MODULE$);
            AnalysisException x$31 = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertSuccess((Expression)xxHash64), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493))));
            String x$32 = "WRONG_NUM_ARGS.WITHOUT_SUGGESTION";
            Map x$33 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(xxHash64.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedNum"), (Object)"> 0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualNum"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"docroot"), (Object)package$.MODULE$.SPARK_DOC_ROOT())}));
            Option x$34 = this.checkError$default$3();
            boolean x$35 = this.checkError$default$5();
            QueryContext[] x$36 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$31, x$32, x$34, x$33, x$35, x$36);
            AnalysisException x$37 = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertSuccess((Expression)new Explode((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504))));
            String x$38 = "DATATYPE_MISMATCH.UNEXPECTED_INPUT_TYPE";
            Map x$39 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"explode(intField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"intField\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"(\"ARRAY\" or \"MAP\")")}));
            Option x$40 = this.checkError$default$3();
            boolean x$41 = this.checkError$default$5();
            QueryContext[] x$42 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$37, x$38, x$40, x$39, x$41, x$42);
            AnalysisException x$43 = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertSuccess((Expression)new PosExplode((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516))));
            String x$44 = "DATATYPE_MISMATCH.UNEXPECTED_INPUT_TYPE";
            Map x$45 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"posexplode(intField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"intField\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"(\"ARRAY\" or \"MAP\")")}));
            Option x$46 = this.checkError$default$3();
            boolean x$47 = this.checkError$default$5();
            QueryContext[] x$48 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$43, x$44, x$46, x$45, x$47, x$48);
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        this.test("check types for CreateNamedStruct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AnalysisException x$49 = this.analysisException((Expression)new CreateNamedStruct((Seq)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("a"), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("b"), (List)new .colon.colon((Object)package.expressions$.MODULE$.doubleToLiteral(2.0), (List)Nil$.MODULE$)))));
            String x$50 = "WRONG_NUM_ARGS.WITHOUT_SUGGESTION";
            Map x$51 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`named_struct`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedNum"), (Object)"2n (n > 0)"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualNum"), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"docroot"), (Object)package$.MODULE$.SPARK_DOC_ROOT())}));
            Option x$52 = this.checkError$default$3();
            boolean x$53 = this.checkError$default$5();
            QueryContext[] x$54 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$49, x$50, x$52, x$51, x$53, x$54);
            AnalysisException x$55 = this.analysisException((Expression)new CreateNamedStruct((Seq)new .colon.colon((Object)package.expressions$.MODULE$.intToLiteral(1), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("a"), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("b"), (List)new .colon.colon((Object)package.expressions$.MODULE$.doubleToLiteral(2.0), (List)Nil$.MODULE$))))));
            String x$56 = "DATATYPE_MISMATCH.CREATE_NAMED_STRUCT_WITHOUT_FOLDABLE_STRING";
            Map x$57 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"named_struct(1, a, b, 2.0)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExprs"), (Object)"[\"1\"]")}));
            Option x$58 = this.checkError$default$3();
            boolean x$59 = this.checkError$default$5();
            QueryContext[] x$60 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$55, x$56, x$58, x$57, x$59, x$60);
            AnalysisException x$61 = this.analysisException((Expression)new CreateNamedStruct((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttribute(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).string()).at(0), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("a"), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("b"), (List)new .colon.colon((Object)package.expressions$.MODULE$.doubleToLiteral(2.0), (List)Nil$.MODULE$))))));
            String x$62 = "DATATYPE_MISMATCH.CREATE_NAMED_STRUCT_WITHOUT_FOLDABLE_STRING";
            Map x$63 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"named_struct(boundreference(), a, b, 2.0)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExprs"), (Object)"[\"boundreference()\"]")}));
            Option x$64 = this.checkError$default$3();
            boolean x$65 = this.checkError$default$5();
            QueryContext[] x$66 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$61, x$62, x$64, x$63, x$65, x$66);
            AnalysisException x$67 = this.analysisException((Expression)new CreateNamedStruct((Seq)new .colon.colon((Object)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("a"), (List)Nil$.MODULE$))));
            String x$68 = "DATATYPE_MISMATCH.UNEXPECTED_NULL";
            Map x$69 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"named_struct(NULL, a)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"[\"NULL\"]")}));
            Option x$70 = this.checkError$default$3();
            boolean x$71 = this.checkError$default$5();
            QueryContext[] x$72 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$67, x$68, x$70, x$69, x$71, x$72);
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
        this.test("check types for CreateMap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AnalysisException x$73 = this.analysisException((Expression)CreateMap$.MODULE$.apply((Seq)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("a"), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("b"), (List)new .colon.colon((Object)package.expressions$.MODULE$.doubleToLiteral(2.0), (List)Nil$.MODULE$)))));
            String x$74 = "WRONG_NUM_ARGS.WITHOUT_SUGGESTION";
            Map x$75 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`map`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedNum"), (Object)"2n (n > 0)"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualNum"), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"docroot"), (Object)package$.MODULE$.SPARK_DOC_ROOT())}));
            Option x$76 = this.checkError$default$3();
            boolean x$77 = this.checkError$default$5();
            QueryContext[] x$78 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$73, x$74, x$76, x$75, x$77, x$78);
            AnalysisException x$79 = this.analysisException((Expression)CreateMap$.MODULE$.apply((Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"a"), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"b"), (List)Nil$.MODULE$))))));
            String x$80 = "DATATYPE_MISMATCH.CREATE_MAP_KEY_DIFF_TYPES";
            Map x$81 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"map(1, a, true, b)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`map`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"[\"INT\", \"BOOLEAN\"]")}));
            Option x$82 = this.checkError$default$3();
            boolean x$83 = this.checkError$default$5();
            QueryContext[] x$84 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$79, x$80, x$82, x$81, x$83, x$84);
            AnalysisException x$85 = this.analysisException((Expression)CreateMap$.MODULE$.apply((Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"a"), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"b"), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$))))));
            String x$86 = "DATATYPE_MISMATCH.CREATE_MAP_VALUE_DIFF_TYPES";
            Map x$87 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"map(a, 1, b, true)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`map`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"[\"INT\", \"BOOLEAN\"]")}));
            Option x$88 = this.checkError$default$3();
            boolean x$89 = this.checkError$default$5();
            QueryContext[] x$90 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$85, x$86, x$88, x$87, x$89, x$90);
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
        this.test("check types for ROUND/BROUND", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertSuccess((Expression)new Round((Expression)Literal$.MODULE$.apply(null), (Expression)Literal$.MODULE$.apply(null), Round$.MODULE$.apply$default$3()));
            this.assertSuccess((Expression)new Round((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Round$.MODULE$.apply$default$3()));
            AnalysisException x$91 = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertSuccess((Expression)new Round((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), Round$.MODULE$.apply$default$3())), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599))));
            String x$92 = "DATATYPE_MISMATCH.NON_FOLDABLE_INPUT";
            Map x$93 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"round(intField, intField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"scale"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)"\"intField\"")}));
            Option x$94 = this.checkError$default$3();
            boolean x$95 = this.checkError$default$5();
            QueryContext[] x$96 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$91, x$92, x$94, x$93, x$95, x$96);
            AnalysisException x$97 = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertSuccess((Expression)new Round((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), Round$.MODULE$.apply$default$3())), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 610))));
            String x$98 = "DATATYPE_MISMATCH.UNEXPECTED_INPUT_TYPE";
            Map x$99 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"round(intField, booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"booleanField\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"\"INT\"")}));
            Option x$100 = this.checkError$default$3();
            boolean x$101 = this.checkError$default$5();
            QueryContext[] x$102 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$97, x$98, x$100, x$99, x$101, x$102);
            AnalysisException x$103 = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertSuccess((Expression)new Round((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$), Round$.MODULE$.apply$default$3())), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 621))));
            String x$104 = "DATATYPE_MISMATCH.UNEXPECTED_INPUT_TYPE";
            Map x$105 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"round(intField, mapField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"mapField\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"MAP<STRING, BIGINT>\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"\"INT\"")}));
            Option x$106 = this.checkError$default$3();
            boolean x$107 = this.checkError$default$5();
            QueryContext[] x$108 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$103, x$104, x$106, x$105, x$107, x$108);
            AnalysisException x$109 = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertSuccess((Expression)new Round((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), Round$.MODULE$.apply$default$3())), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 632))));
            String x$110 = "DATATYPE_MISMATCH.UNEXPECTED_INPUT_TYPE";
            Map x$111 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"round(booleanField, intField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"booleanField\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"\"NUMERIC\"")}));
            Option x$112 = this.checkError$default$3();
            boolean x$113 = this.checkError$default$5();
            QueryContext[] x$114 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$109, x$110, x$112, x$111, x$113, x$114);
            this.assertSuccess((Expression)new BRound((Expression)Literal$.MODULE$.apply(null), (Expression)Literal$.MODULE$.apply(null), BRound$.MODULE$.apply$default$3()));
            this.assertSuccess((Expression)new BRound((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), BRound$.MODULE$.apply$default$3()));
            AnalysisException x$115 = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertSuccess((Expression)new BRound((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), BRound$.MODULE$.apply$default$3())), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 646))));
            String x$116 = "DATATYPE_MISMATCH.NON_FOLDABLE_INPUT";
            Map x$117 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"bround(intField, intField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"scale"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)"\"intField\"")}));
            Option x$118 = this.checkError$default$3();
            boolean x$119 = this.checkError$default$5();
            QueryContext[] x$120 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$115, x$116, x$118, x$117, x$119, x$120);
            AnalysisException x$121 = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertSuccess((Expression)new BRound((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), BRound$.MODULE$.apply$default$3())), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656))));
            String x$122 = "DATATYPE_MISMATCH.UNEXPECTED_INPUT_TYPE";
            Map x$123 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"bround(intField, booleanField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"booleanField\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"\"INT\"")}));
            Option x$124 = this.checkError$default$3();
            boolean x$125 = this.checkError$default$5();
            QueryContext[] x$126 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$121, x$122, x$124, x$123, x$125, x$126);
            AnalysisException x$127 = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertSuccess((Expression)new BRound((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapField"}))).$((Seq)Nil$.MODULE$), BRound$.MODULE$.apply$default$3())), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667))));
            String x$128 = "DATATYPE_MISMATCH.UNEXPECTED_INPUT_TYPE";
            Map x$129 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"bround(intField, mapField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"mapField\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"MAP<STRING, BIGINT>\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"\"INT\"")}));
            Option x$130 = this.checkError$default$3();
            boolean x$131 = this.checkError$default$5();
            QueryContext[] x$132 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$127, x$128, x$130, x$129, x$131, x$132);
            AnalysisException x$133 = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertSuccess((Expression)new BRound((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"booleanField"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"}))).$((Seq)Nil$.MODULE$), BRound$.MODULE$.apply$default$3())), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 678))));
            String x$134 = "DATATYPE_MISMATCH.UNEXPECTED_INPUT_TYPE";
            Map x$135 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)"\"bround(booleanField, intField)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"booleanField\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"\"NUMERIC\"")}));
            Option x$136 = this.checkError$default$3();
            boolean x$137 = this.checkError$default$5();
            QueryContext[] x$138 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$133, x$134, x$136, x$135, x$137, x$138);
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
        this.test("check types for Greatest/Least", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)Greatest$.MODULE$, (List)new .colon.colon((Object)Least$.MODULE$, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)operator -> {
            ExpressionTypeCheckingSuite.$anonfun$new$28(this, operator);
            return BoxedUnit.UNIT;
        }), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
        this.test("check types for SQL string generation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String $org_scalatest_assert_macro_left = Literal$.MODULE$.create((Object)new int[]{1, 2, 3}, (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)).sql();
            String $org_scalatest_assert_macro_right = "ARRAY(1, 2, 3)";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
            String $org_scalatest_assert_macro_left2 = Literal$.MODULE$.create((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), null}, (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)).sql();
            String $org_scalatest_assert_macro_right2 = "ARRAY(1, 2, CAST(NULL AS INT))";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
            String $org_scalatest_assert_macro_left3 = Literal$.MODULE$.default((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("col", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).sql();
            String $org_scalatest_assert_macro_right3 = "NAMED_STRUCT('col', '')";
            String string5 = $org_scalatest_assert_macro_left3;
            String string6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 729));
            String $org_scalatest_assert_macro_left4 = Literal$.MODULE$.default((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("col", (DataType)NullType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).sql();
            String $org_scalatest_assert_macro_right4 = "NAMED_STRUCT('col', NULL)";
            String string7 = $org_scalatest_assert_macro_left4;
            String string8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 731));
            String $org_scalatest_assert_macro_left5 = Literal$.MODULE$.create((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)42L)), (Object)BoxesRunTime.boxToBoolean((boolean)true))})), (DataType)MapType$.MODULE$.apply((DataType)LongType$.MODULE$, (DataType)BooleanType$.MODULE$)).sql();
            String $org_scalatest_assert_macro_right5 = "MAP(42L, true)";
            String string9 = $org_scalatest_assert_macro_left5;
            String string10 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 733));
            String $org_scalatest_assert_macro_left6 = Literal$.MODULE$.create((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)42L)), null)})), (DataType)MapType$.MODULE$.apply((DataType)LongType$.MODULE$, (DataType)NullType$.MODULE$)).sql();
            String $org_scalatest_assert_macro_right6 = "MAP(42L, NULL)";
            String string11 = $org_scalatest_assert_macro_left6;
            String string12 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 735));
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
        this.test("hash expressions are prohibited on MapType elements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Literal argument = Literal$.MODULE$.create((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)42L)), (Object)BoxesRunTime.boxToBoolean((boolean)true))})), (DataType)MapType$.MODULE$.apply((DataType)LongType$.MODULE$, (DataType)BooleanType$.MODULE$));
            Murmur3Hash murmur3Hash = new Murmur3Hash((Seq)new .colon.colon((Object)argument, (List)Nil$.MODULE$));
            TypeCheckResult $org_scalatest_assert_macro_left = murmur3Hash.checkInputDataTypes();
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("HASH_MAP_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(murmur3Hash.prettyName()))})));
            TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
            TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 742));
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 739));
        this.test("check types for Lag", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Lag lag = new Lag((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)NonFoldableLiteral$.MODULE$.apply(BoxesRunTime.boxToInteger((int)10)), (Expression)Literal$.MODULE$.apply(null), true);
            TypeCheckResult $org_scalatest_assert_macro_left = lag.checkInputDataTypes();
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"offset"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)"\"(- nonfoldableliteral())\"")})));
            TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
            TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 752));
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 750));
        this.test("check types for SpecifiedWindowFrame", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SpecifiedWindowFrame swf1 = new SpecifiedWindowFrame((FrameType)RangeFrame$.MODULE$, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)10.0)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000000L)));
            TypeCheckResult $org_scalatest_assert_macro_left = swf1.checkInputDataTypes();
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("SPECIFIED_WINDOW_FRAME_DIFF_TYPES", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lower"), (Object)"\"10.0\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upper"), (Object)"\"2147483648\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lowerType"), (Object)"\"DOUBLE\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upperType"), (Object)"\"BIGINT\"")})));
            TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
            TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
            SpecifiedWindowFrame swf2 = new SpecifiedWindowFrame((FrameType)RangeFrame$.MODULE$, (Expression)NonFoldableLiteral$.MODULE$.apply(BoxesRunTime.boxToDouble((double)10.0)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000000L)));
            TypeCheckResult $org_scalatest_assert_macro_left2 = swf2.checkInputDataTypes();
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right2 = new TypeCheckResult.DataTypeMismatch("SPECIFIED_WINDOW_FRAME_WITHOUT_FOLDABLE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"location"), (Object)"lower"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expression"), (Object)"\"nonfoldableliteral()\"")})));
            TypeCheckResult typeCheckResult2 = $org_scalatest_assert_macro_left2;
            TypeCheckResult.DataTypeMismatch dataTypeMismatch2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(typeCheckResult2 != null ? !typeCheckResult2.equals(dataTypeMismatch2) : dataTypeMismatch2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 763));
        this.test("check types for WindowSpecDefinition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UnresolvedAttribute unresolvedAttribute = UnresolvedAttribute$.MODULE$.apply("a");
            SortOrder sortOrder = SortOrder$.MODULE$.apply((Expression)UnresolvedAttribute$.MODULE$.apply("b"), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            WindowSpecDefinition wsd = new WindowSpecDefinition((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), (WindowFrame)UnspecifiedFrame$.MODULE$);
            SparkException x$139 = (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> wsd.checkInputDataTypes(), ClassTag$.MODULE$.apply(SparkException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 795));
            String x$140 = "INTERNAL_ERROR";
            Map x$141 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)"Cannot use an UnspecifiedFrame. This should have been converted during analysis.")}));
            Option x$142 = this.checkError$default$3();
            boolean x$143 = this.checkError$default$5();
            QueryContext[] x$144 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$139, x$140, x$142, x$141, x$143, x$144);
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 789));
    }
}

